#undef DEBUG

#include <stdlib.h>   /* NULL */
#include "dalib.h"

struct SharedRecord
 
{ int  shared_kind;

};

/**************************************************************************
*                                                                         *
*   global_data is needed to exchange data via CJmread, CJmwrite          *
*                                                                         *
*   IMPORTANT:  global_data must have the same address on all processors  *
*                                                                         *
**************************************************************************/

#define MAX_SIZE 64 

unsigned char global_data [MAX_SIZE];

/**************************************************************************
*                                                                         *
*   int dalib_is_globally_shared (Shared info)                            *
*                                                                         *
*     - returns 0 if local memory on each processor (local addresses)     *
*     - returns 1 if global memory for all processors (global addresses)  *
*                                                                         *
**************************************************************************/

int dalib_is_globally_shared (info)

Shared info;

{ 

  return (0);

} /* dalib_is_globally_shared */

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/
 
void FUNCTION(dalib_array_shared) (array_id, kind)
 
array_info *array_id;
int        *kind;
 
{ Shared shared_ptr;

  /* allocate the pointer of Shared Record structure */

  shared_ptr = (Shared) dalib_malloc (sizeof (struct SharedRecord),
                                      "dalib_array_shared");
  /* set the shared_kind */

  shared_ptr->shared_kind = *kind;

  /* assign the array_id->SharedInfo */

  (*array_id)->SharedInfo = shared_ptr;
 
  FUNCTION(dalib_barrier) ();

  /* make remote access possible */

  dalib_array_remote_init (*array_id);

} /* dalib_array_shared */

void FUNCTION(dalib_array_vshared) (array_id, dummy_id, kind)
 
array_info *array_id;
 
{
}

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_array_shared_alloc (array_id)
 
array_info array_id;

{ /* memory is created as for a usual array */

  dalib_array_malloc (array_id);

  /* nothing else is to do */

}  /* dalib_array_shared_alloc */
 
/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

int dalib_rpc_read (array_id, from_pid, offset)
 
array_info *array_id;
int from_pid;
int offset;
 
{ int global_indices[MAX_DIMENSIONS];

  int rank, size;   /* info from array_id */
  int rtn;

  unsigned char *pdata;    /* calculation of array data address */
  int  *idata;             /* help pointer for type conversion  */

  rank         = (*array_id)->rank;
  size         = (*array_id)->size;
 
#ifdef DEBUG
  printf ("%d: dalib_rpc_read from %d, offset = %d\n", 
            pcb.i, from_pid+1, offset);
#endif
 
  pdata = (*array_id)->data;

  pdata += offset * (*array_id)->size;
 
  /* give pdata to the calling processor */

  if (size <= sizeof(int)) 

     { idata = (int *) pdata;
       return (*idata);
     }

   else

     { rtn = CJrmwrite (pdata, from_pid, global_data, size);
      
       if (rtn != size) {
         dalib_internal_error ("CJrmwrite failed; %d\n", rtn);
       } 

       return (0);
     }
  
} /* dalib_rpc_read */

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_array_rpc_read (data, array_id, offset, to_pid)

unsigned char *data;
array_info *array_id;
int offset;
int to_pid;     /* owner */

{ int size, rank;
  int rtn;

  size = (*array_id)->size;
  rank = (*array_id)->rank;

  { /* note: CENJU numbers proc from 0 to n-1 instead of 1 to n */

    rtn = CJrpc (to_pid-1,
                 dalib_rpc_read,
                 3,                    /* number of parameter */
                 array_id,  /* evtl. &array_id; doppelt indirekt */
                 pcb.i-1,
                 offset);

     /* rtn has result only for integer sizes or smaller otherwise
        the data is available via global_data                      */

     if (size <= sizeof (int))

       { dalib_memcopy (data, &rtn, size);
         
       }

       else

       { /* copy the global data written by remote processor to_pid */

         dalib_memcopy (data, global_data, size);

       }
 
     }

} /* dalib_array_rpc_read */

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_array_read) (data, array_id, ind1, ind2, ind3, ind4,
                                        ind5 ,ind6, ind7)
unsigned char *data;
array_info *array_id;
int *ind1, *ind2, *ind3, *ind4, *ind5, *ind6, *ind7;
 

{ int owner;
  int offset;

  int global_indices[MAX_DIMENSIONS];
  int i, rank;

  int top_id;
  array_info template_dsp;

  unsigned char *pdata;

  /* pack indices for local and remote address computation */

  rank = (*array_id)->rank;

  dalib_array_info (*array_id, &template_dsp, &top_id);

  /* initialization */

  for (i=0; i<MAX_DIMENSIONS; i++) global_indices[i] = 0;
 
  switch (rank) {
    case 7: global_indices[6] = *ind7;
    case 6: global_indices[5] = *ind6;
    case 5: global_indices[4] = *ind5;
    case 4: global_indices[3] = *ind4;
    case 3: global_indices[2] = *ind3;
    case 2: global_indices[1] = *ind2;
    case 1: global_indices[0] = *ind1;
  } /* end switch */
 
  /* compute ownership */

  if (pcb.p == 1)

      { owner = 1;
        offset = dalib_local_offset (*array_id, global_indices);
      }
       
    else

      { owner  = dalib_multidim_owner (*array_id, global_indices);
        offset = dalib_remote_offset (*array_id, owner, global_indices);
        owner  = dalib_top_elem (top_id, owner);
      }

  if (owner == pcb.i)          /* then it is a local data access */

    { 

#ifdef DEBUG
      printf ("%d: dalib_array_read, index = %d, local, offset = %d\n",
               pcb.i, *ind1, offset);
#endif
  
      pdata = (*array_id)->data;

      pdata += offset * (*array_id)->size;

      dalib_memcopy (data, pdata, (*array_id)->size);

    }

   else              /* remote data access */

    { 

#ifdef DEBUG
      printf ("%d: dalib_array_read, index = %d, remote on = %d, offset = %d\n",
               pcb.i, *ind1, owner, offset);
#endif

      dalib_array_rpc_read (data, array_id, offset, owner);
 
    } /* end rpc */

}  /* dalib_array_read */

/**************************************************************************
*                                                                         *
*  dalib_shared_free (descriptor, data_flag)                              *
*                                                                         *
*   - delete data only if data_flag is set                                *
*                                                                         *
**************************************************************************/

void dalib_shared_free (descriptor, data_flag)

array_info descriptor;
int        data_flag;

{ Shared shared_ptr;

  FUNCTION(dalib_barrier) ();

  shared_ptr  = descriptor->SharedInfo;
 
  /* detach/deallocate distributed memory region */

  free (descriptor->data);
  free (shared_ptr);

  if (descriptor->data != NO_DATA)
 
     { /* deallocate local data of the array if data_flag */
 
       if (data_flag) free (descriptor->data);
     }

} /* dalib_shared_free */
 
