#define DEBUG

#include "dalib.h"
#include "mpproto.h"

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_pause (n)
int *n;

{ int i, j;
  float x;

  x = 1.0;
  for (i=0; i<*n; i++)
    { for (j=0; j<100000; j++)
        x = (x + j/2) / j;
    }

} /* dalib_pause */

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

static int rpc_server_is_running = 0;

static volatile int servers;

extern int mperrno;

#define RPC_QUERY_TYPE  1051
#define RPC_ANSWER_TYPE 2051

typedef struct {

  int kind;
  array_info *array_id;
  int offset;

  } question_type;

question_type question[MAXP];
 
int client [MAXP]; 
int type   [MAXP];
int msgid  [MAXP];

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_array_local_read (data, array_id, offset)

unsigned char *data;
array_info *array_id;
int offset;

{ unsigned char *pdata;

  pdata = (*array_id)->data;

  pdata += offset * (*array_id)->size;
 
#ifdef DEBUG
  printf ("%d: read in my array at offset %d\n", pcb.i, offset);
#endif

  dalib_memcopy (data, pdata, (*array_id)->size);
 
} /* read_my_array */

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void rpc_handler (int *inmsg)

{ /* answering request */

  int rc;
  int my_client;

  size_t nbytes;

  int answer;

  size_t length;
  int    answer_tag;

  int i;

#ifdef DEBUG
  printf ("%d: rpc_handler activated, msg_id = %d\n", pcb.i, *inmsg);
#endif

  my_client = -1;

  for (i=0; i<pcb.p; i++)
     if (*inmsg == msgid[i]) my_client = i;

  rc = mpc_wait (inmsg, &nbytes);

  if (rc)
    { dalib_internal_error ("rpc_handler: message not available");
      dalib_stop ();
    }

#ifdef DEBUG
  printf ("%d: got a request of client %d, size = %d\n", 
           pcb.i, my_client+1, nbytes);
#endif

  if (question[my_client].kind == 0)

     {  /* I can stop the server for this processor */

        servers = servers - 1;

#ifdef DEBUG
  printf ("%d: stop service for processor %d, %d servers running\n",
           pcb.i, my_client+1, servers);
#endif

        return;
     }

  /* now we can answer the request */

  dalib_array_local_read (&answer, question[my_client].array_id, 
                          question[my_client].offset);

  /* send answer back */

  answer_tag = RPC_ANSWER_TYPE + my_client;
  length     = 4;

#ifdef DEBUG
  printf ("%d: answer (tag=%d) the request of client %d\n", 
          pcb.i, answer_tag, my_client+1);
#endif

  rc = mpc_bsend (&answer, length, my_client, answer_tag);

#ifdef DEBUG
  printf ("%d: sent the answer data to processor %d\n", pcb.i, my_client+1);
#endif

  if (rc)

     { dalib_internal_error ("rpc_handler: could not answer");
       dalib_stop ();
     }

  /* restart server mode */

  length = sizeof(question_type);

  rc = mpc_rcvncall (question+my_client, length,
                     client+my_client,
                     type+my_client, msgid+my_client, rpc_handler);

#ifdef DEBUG
  printf ("%d: set up the server mode again, type = %d, msgid = %d\n", 
           pcb.i, type[my_client], msgid[my_client]);
#endif

  if (rc) 
     { dalib_internal_error ("rpc_handler: could not restart server mode");
       dalib_exit ();
     }

} /* rpc_handler */

/**************************************************************************
*                                                                         *
*   void rpc_init ()                                                      *
*                                                                         *
*     - starts the server mode which allows recvncalls                    *
*                                                                         *
**************************************************************************/

void rpc_init ()

{ int rc;
  size_t length;
  int i;

  if (rpc_server_is_running) 
     return;

#ifdef DEBUG
  printf ("%d: will start the server mode\n", pcb.i);
#endif 

  length = sizeof(question);

  for (i=0; i<pcb.p; i++)

   if (i+1 != pcb.p)

    { client[i] = DONTCARE;
      type  [i] = RPC_QUERY_TYPE + i;

      rc = mpc_rcvncall (question + i, length, client + i,
                         type + i, msgid + i, rpc_handler);

#ifdef DEBUG
      printf ("%d: recv for %d, tag = %d, msgid = %d\n",
               pcb.i, i+1, type[i], msgid[i]);
#endif

      if (rc) 

         { dalib_internal_error ("rpc_init: could not start server mode");
           dalib_exit ();
         }

    } /* for all processors */

#ifdef DEBUG
  printf ("%d: server mode should run now forever\n", pcb.i);
#endif 

  /* note : server mode will run forever as rpc_handler starts again */

  rpc_server_is_running = 1;

  servers = pcb.p - 1;

#ifdef DEBUG
  printf ("%d: %d servers are running\n", pcb.i, servers);
#endif 

} /* rpc_init */

void rpc_exit ()

{ /* shutdown the server */

  int pid;
  int tag;
  int rc;

  question_type send_data;

          /********************************************
          *                                           *
          *   send the final message to all others    *
          *                                           *
          ********************************************/

   for (pid = 0; pid < pcb.p; pid++)

   if (pid+1 != pcb.i)

    { send_data.kind     = 0;           /* I am ready */
 
      tag    = RPC_QUERY_TYPE + pcb.i - 1;  /* call my server */
 
#ifdef DEBUG
      printf ("%d: call of rpc_end on %d (tag = %d) \n",
               pcb.i, pid+1, tag );
#endif
 
      rc = mpc_bsend (&send_data, sizeof (send_data), pid, tag);
 
      if (rc)
        { dalib_internal_error ("rpc_end failed");
          printf ("mpc_bsend error code = %d\n", mperrno);
          dalib_stop ();
        }

     } /* sending final request to all processors */

          /********************************************
          *                                           *
          *   wait for all final message of others    *
          *                                           *
          ********************************************/

   printf ("%d: still %d services running\n", pcb.i, servers);

   while (servers) {

     int source, type, rc, mstat;

     source = DONTCARE;
     type   = DONTCARE;
     for(;;)  {
            rc = mpc_probe(&source,&type,&mstat);
            if(mstat >= 0)  break;
         }

     printf ("%d: attention message arrived, source = %d, type = %d\n", 
              pcb.i, source, type);
 
     /* rpc_handler (msgid + source); */

   }

   printf ("%d: all services finished\n", pcb.i);

} /* rpc_exit */

/**************************************************************************
*                                                                         *
*   void rpc_get (data, remote_pid, array_id, offset)                     *
*                                                                         *
*     - read remote data of array_id (offset) on remote_pid processor     *
*                                                                         *
**************************************************************************/

void rpc_get (data, remote_pid, array_id, offset)

int *data;
int remote_pid;
array_info *array_id;
int offset;

{  question_type send_data;

   int tag;
   int rc;
   int server;
   size_t nbytes;

          /********************************************
          *                                           *
          *   prepare the request                     *
          *                                           *
          ********************************************/

   send_data.kind     = 1;           /* remote read */
   send_data.array_id = array_id;
   send_data.offset   = offset;

   tag    = RPC_QUERY_TYPE + pcb.i - 1;  /* call my server */
   server = remote_pid-1;

#ifdef DEBUG
   printf ("%d: call of rpc_get on %d (tag = %d) with offset %d\n",
            pcb.i, remote_pid, tag, offset);
#endif

   rc = mpc_bsend (&send_data, sizeof (send_data), server, tag);

   if (rc)
     { dalib_internal_error ("rpc_call failed");
       printf ("mpc_bsend error code = %d\n", mperrno);
       dalib_stop ();
     }

          /********************************************
          *                                           *
          *   wait for the response                   *
          *                                           *
          ********************************************/

   tag   = RPC_ANSWER_TYPE + pcb.i - 1;

#ifdef DEBUG
   printf ("%d: wait for answer (tag=%d) of processor %d\n", 
            pcb.i, tag, remote_pid);
#endif

   rc = mpc_brecv (data, sizeof (int), &server, &tag, &nbytes);

   if (rc)

     { dalib_internal_error ("rpc_get answer failed");
       printf ("mpc_brecv error code = %d\n", mperrno);
       dalib_stop ();
     }

#ifdef DEBUG
   printf ("%d: got the answer of processr %d\n", pcb.i, remote_pid);
#endif

} /* rpc_call */

