/*****************************************************************************
 *                                                                           *
 * VAMPIRtrace MPI Profiling Library - GENERIC Module                        *
 *                                                                           *
 * Copyright (c) PALLAS GmbH 1996                                            *
 *                                                                           *
 * VAMPIRtrace API include file                                              *
 *                                                                           *
 * $Revision: 1.1 $
 *                                                                           *
 * $Date: 1996/09/10 15:32:39 $
 *                                                                           *
 * $State: Exp $
 *                                                                           *
 * $Id: VT.h,v 1.1 1996/09/10 15:32:39 hch Exp $
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                                                                           *
 * $Log: VT.h,v $
 * Revision 1.1  1996/09/10 15:32:39  hch
 * Initial revision
 *
 *****************************************************************************/

#ifndef __VT__
#define __VT__

static char VT_rcsid[] = "@(#) $Id: VT.h,v 1.1 1996/09/10 15:32:39 hch Exp $";

/**
 * Version constant
 **/
#define VT_VERSION 1020
/**
 * Max length of activity/symbol strings
 **/
#define VT_STRLEN 80
/**
 * Max user-defined symbol code
 **/
#define VT_MAX_USERCODE	65536
/**
 * VAMPIRtrace error codes
 **/
#define VT_OK            0
#define VT_ENOIDX       -1
#define VT_ENOMEM       -2
#define VT_ENOINIT      -3
#define VT_EBADSYM      -4
/**
 * VAMPIRtrace API function declarations
 **/
extern int  VT_symdef (int code, char *symname, char *activity);
extern int  VT_begin (int code);
extern int  VT_end (int code);
extern void VT_traceon (void);
extern void VT_traceoff (void);

#endif /* __VT__ */
