/*******************************************************************
*                                                                  *
*  DEFINITIONS : system.h                                          *
*                                                                  *
*  Definition of the shared memory : mailboxes                     *
*                                                                  *
*******************************************************************/

#define shared_size 4 * 4096
#define shared_id   1

#define MB_TYPE double
#define MB_SIZE 8

typedef struct
  { int volatile flag;      /* 0 : no message, otherwise there is a message */
    MB_TYPE *ptr;           /* Pointer to the message in the local mailbox  */
    int length;             /* number of mail-box items                     */
    int blength;            /* length of the message in number of bytes     */
  } msg;

#define MAIL_SIZE 256*1024   /* MB items for mailbox of one process */

typedef struct
  { MB_TYPE base_addr [MAIL_SIZE]; /* Pointer to base of mail memory   */
    int offset;                    /* Offset for top of mail           */
    int dummy;                     /* makes mailbox size multiple of 8 */
    msg inmail [MAXP1];            /* messag informations              */
  } mailbox;

/* mailbox.inmail[i].flag != 0 : there is a message from process i */

/*    Mailbox :   ------------
                  |          |
                  |          |
                  |----------|      -
                  |oooooooooo|      |  offset
                  |oooooooooo|      |
                  ------------     <--- base_addr

   Some Rules:

   - other processes can put messages in the mailbox of the receiver
   - no process can put two messages in the same mailbox (it will wait
     until the first messsage has been read)
   - in the mailbox is always a copy of the message
   - when receiving a message, the process gets a copy of the content
   - if the mailbox is full, automatic garbage collection will be ini-
     tiated (system stop if no more place will be available)

*/

extern mailbox * mail_memory;

/* mailboxes will be locked with semaphores */

