/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Jun 94                                                   *
*  Last Update : Jun 94                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : pt2pt.c                                                  *
*                                                                         *
*  Function: machine dependent point-to-point communication               *
*                                                                         *
*      Shared memory version  (e.g. SUN4, IRIX, ...)                      *
*                                                                         *
*  Export :  internal Interface                                           *
*  ============================                                           *
*                                                                         *
**************************************************************************/

#undef TEST
#undef MSG_DEBUG

#include <stdio.h>
#include <memory.h>
#include "dalib.h"
#include "system.h"

int mail_NP;

     /*************************************************************
     *                                                            *
     *  void machine_mpi_init ()                                  *
     *                                                            *
     *************************************************************/

void machine_mpi_init ()

{ } /* machine_mpi_init */

     /*************************************************************
     *                                                            *
     *  void machine_mpi_exit ()                                  *
     *                                                            *
     *************************************************************/

void machine_mpi_exit ()

{ } /* machine_mpi_exit */

/*******************************************************************
*                                                                  *
*  Initialization of Mailboxes (called by host with init)          *
*                                                                  *
*******************************************************************/

void init_mailboxes (NP)
int NP;
{ int i, j;
  mail_NP = NP;
  for (i=0;i<=NP;i++)
   {
     mail_memory[i].offset = 0;
     for (j=0;j<=NP;j++)
        mail_memory[i].inmail[j].flag = 0;
   }
}

/*********************************************************************
 Managing Mail Memory
 *********************************************************************/

void mail_sort (pointers, processes, n)
long pointers [];  /* sizeof (long) = sizeof (* long)  */
int processes[];
int n;
{ int i, j;
  long hp; int hpr;
  for (i=n-1;i>=1;i--)
    for (j=1;j<=i;j++)
      if (pointers [j-1] > pointers [j])
        { /* switch the elements */
          hp = pointers[j-1];
          pointers[j-1] = pointers[j];
          pointers[j] = hp;
          hpr = processes [j-1];
          processes[j-1] = processes[j];
          processes[j] = hpr;
        }
}

MB_TYPE *mail_garbage_collection (process, length)
int process, length;

{ int i, j, mail_counter, offset, hlength;
  MB_TYPE *h, *base_addr, *hbase, *mail_pointers [MAXP1];
  int processes [MAXP1];

  /* count mails in mailboxes and sort the pointers */
  /* printf ("Process %d has a garbage collection \n",process); */
  mail_counter = 0;
  for (i=0;i<=mail_NP;i++)
    if (mail_memory[process].inmail[i].flag != 0)
        { mail_pointers [mail_counter] = mail_memory[process].inmail[i].ptr;
          processes [mail_counter] = i;
          mail_counter += 1;
        }
  /* sort the pointers in the mailbox of process j */
  mail_sort  (mail_pointers, processes, mail_counter);
  /*
  printf ("The mails are now sorted\n");
  for (i=0;i<mail_counter;i++)
     printf ("Mail of Process %d, Pointer = %d\n",
              processes[i], mail_pointers[i]);
  */
  /* contract messages in the mailbox */
  offset = 0;
  hbase = mail_memory[process].base_addr;
  base_addr = hbase;
  for (i=0;i<mail_counter;i++)
    { h = mail_pointers [i];
      hlength = mail_memory[process].inmail[processes[i]].length;
      mail_memory[process].inmail[processes[i]].ptr = base_addr;
      offset += hlength;
      for (j=0;j<hlength;j++)
        * (base_addr + j) = * (h+j);
      base_addr = hbase + offset;
     }
  /* get new memory for the new mail */
  h = base_addr;  
  offset += length;
  if (offset >= MAIL_SIZE)
     { /* no more memory in mailbox, the mailbox is full */
       printf ("The mailbox of process %d is full (size=%d,in=%d,needed=%d)\n", 
                process, MAIL_SIZE, offset-length, length);
       exit (1);
     }
  mail_memory[process].offset = offset;      
  return (h);
}

/*******************************************************************
*                                                                  *
*  Allocation of mail memory on the receiving process node         *
*                                                                  *
*******************************************************************/

MB_TYPE *get_mail_mem (process, length)
int process, length;
/* reservation of length items in mailbox of the process */
{ MB_TYPE *h;
  h = mail_memory[process].base_addr + mail_memory[process].offset;
  mail_memory[process].offset += length;
  /*
  printf ("Process %d, get mail_mem with length = %d, new offset = %d\n",
           process, length, mail_memory[process].offset);
  */
  if (mail_memory[process].offset >= MAIL_SIZE)
     { /* no more memory in mailbox, make a garbage_collection */
       mail_memory[process].offset -= length;
       h = mail_garbage_collection (process, length);
       /* it is funny here that an other process will collect the garbagge */
     }
  return (h);
}

/*******************************************************************
*                                                                  *
*  Sending and receiving of messages                               *
*                                                                  *
*******************************************************************/

void asend (from, to, message, length)
int from, to;
unsigned char *message;
int length;

/* Process 'from' sends a message to process 'to' */

{  MB_TYPE *local_ptr;
   int items;

# ifdef TEST
   my_lock (-1);
   printf ("Process %d sends a message to %d, length = %d\n",from,to,length);
   my_unlock (-1);
# endif 
   
   while (mail_memory[to].inmail[from].flag != 0);
   
   my_lock (to);

   /* Reservation of mail_memory on process 'to' and copy message  */
   items = (length + MB_SIZE - 1) / MB_SIZE;

   local_ptr = get_mail_mem (to, items);

   /* local_ptr is aligned to 4 bytes */

   if ((((int) local_ptr) & 3 ) != 0)
      printf ("ERROR: local pointer not aligned\n");

   dalib_memcopy (local_ptr, message, length);
 
   /* make an entry in the mail table */

   mail_memory[to].inmail[from].ptr = local_ptr;
   mail_memory[to].inmail[from].length = items;
   mail_memory[to].inmail[from].blength = length;
   mail_memory[to].inmail[from].flag = 1;

   my_unlock (to);

# ifdef TEST
   my_lock (-1);
   printf ("Process %d has sent a message to %d, length = %d\n",from,to,length);
   my_unlock (-1);
# endif 
}

void areceive (to, from, message, length)
int to, from;
unsigned char *message;
int length;

{  MB_TYPE *local_ptr;

# ifdef TEST
   my_lock(-1);
   printf ("Process %d wants a message from %d, length = %d\n",to,from,length);
   my_unlock (-1);
# endif 

   while (mail_memory[to].inmail[from].flag != 1);
   /* Waiting for the message */
 
   /* make sure that no other process sends now a mail (garbage collection */

   my_lock (to);

   if (length != mail_memory[to].inmail[from].blength)
     { printf ("areceive (from = %d, to =%d : length conflict \n", from,to);
       printf ("got length = %d, expected length = %d\n",
                mail_memory[to].inmail[from].length, length);
     }

   local_ptr = mail_memory[to].inmail[from].ptr;

   dalib_memcopy (message, local_ptr, length);
 
   mail_memory[to].inmail[from].flag = 0;   /* signal mail can be sent */

   my_unlock (to);

# ifdef TEST
   my_lock (-1);
   printf ("Process %d gots a message from %d, length = %d\n",to,from,length);
   my_unlock (-1);
# endif 

   /* Hint: Until now it is not possible that more than one
            process can write mails to a process (due to garbage)  */
}

/*******************************************************************
*                                                                  *
*  Checking for the correct determination (no pending messages)    *
*                                                                  *
*******************************************************************/

void check_mailboxes ()
/* test whether there are no pending messages */
{ int i, j;
  for (i=0;i<=mail_NP;i++)
    for (j=0;j<=mail_NP;j++)
      if (mail_memory[j].inmail[i].flag != 0)
        printf ("Hanging message from process %d for process %d\n",i,j);
}

/*******************************************************************
*                                                                  *
*  DALIB : Interface                                               *
*                                                                  *
*******************************************************************/

     /***************************************************************
     *                                                              *
     *  machine_mpi_send (int to, char *msg, int len, int kind)     *
     *                                                              *
     *  BLOCKING send                                               *
     *                                                              *
     *  - kind = 0 : really blocking until receive                  *
     *  - kind = 1 : blocking until msg copied                      *
     *  - kind = 2 : msg buffer can directly be used                *
     *                                                              *
     ***************************************************************/

void machine_mpi_send (to, message, length, kind)

int to, length, kind;
char *message;

{ /* blocking send */

#ifdef MSG_DEBUG
  printf ("%d: call of send to = %d, length = %d\n", pcb.i, to, length);
#endif

  asend (pcb.i, to, message, length);

  if (kind == 2)
     dalib_free (message, length);

} /* machine_mpi_send */

     /*********************************************************
     *                                                        *
     *  machine_mpi_receive (int from, char *msg, int len)    *
     *                                                        *
     *  BLOCKING receive                                      *
     *                                                        *
     *  - blocks really until message has been received       *
     *                                                        *
     *********************************************************/

void machine_mpi_receive (from, message, length)

int  from, length;
char *message;

{ int to;

#ifdef MSG_DEBUG
  printf ("%d: will recv from = %d length = %d\n",
           pcb.i, from, length);
#endif

  to = pcb.i;

  areceive (to, from, message, length);

#ifdef MSG_DEBUG
  printf ("%d: has recvd from = %d , length = %d\n",
           pcb.i, from, length);
#endif

} /* machine_mpi_receive */

     /*********************************************************
     *                                                        *
     *  machine_mpi_sendreceive (...)                                 *
     *                                                        *
     *   - blocking send/receive in one step                  *
     *                                                        *
     *********************************************************/

void machine_mpi_sendreceive (to, out_msg, out_len,
                      from, in_msg, in_len)

int to, from;
char *out_msg, *in_msg;
int in_len, out_len;

{
  dalib_internal_error ("machine_mpi_sendreceive not supported");

} /* machine_mpi_sendreceive */


     /*********************************************************
     *                                                        *
     *  int machine_mpi_isend (int to, char *msg, int len)    *
     *                                                        *
     *  NON BLOCKING send                                     *
     *                                                        *
     *********************************************************/

int machine_mpi_isend (to, message, length)

int to, length;
char *message;

{ int msg_id;

  /* non blocking send */

#ifdef MSG_DEBUG
  printf ("%d: call of isend : to = %d, length = %d\n",
           pcb.i, to, length);
#endif

  msg_id = 0;

  dalib_internal_error ("NON BLOCKING mode not available for MPI");

#ifdef MSG_DEBUG
  printf ("%d: call of isend : to = %d, msg_id = %d\n", pcb.i, to, msg_id);
#endif

  return (msg_id);

} /* machine_mpi_isend */


     /************************************************************
     *                                                           *
     *  int machine_mpi_ireceive (int from, char *msg, int len)  *
     *                                                           *
     *  NON BLOCKING receive                                     *
     *                                                           *
     ************************************************************/

int machine_mpi_ireceive (from, message, length)

int  from, length;
char *message;

{ int msg_id;

#ifdef MSG_DEBUG
  printf ("%d: will irecv from = %d length = %d\n",
           pcb.i, from, length);
#endif

  /* msg_id = irecv (tag, message, length); */

  msg_id = 0;

  dalib_internal_error ("NON BLOCKING mode not available for SHM");
  dalib_stop ();

#ifdef MSG_DEBUG
  printf ("%d: irecv got msg_id = %d\n", pcb.i, msg_id);
#endif

  return (msg_id);

} /* machine_mpi_receive */


     /*********************************************************
     *                                                        *
     *  int machine_mpi_done (int msg_id)                     *
     *                                                        *
     *  - ask status of an immediate send/receive             *
     *  - msg_id is free if machine_mpi_done == 1             *
     *                                                        *
     *********************************************************/

int machine_mpi_done (msg_id)

int msg_id;    /* has been given by immediate send or receive */

{ dalib_internal_error ("NON BLOCKING mode not available for MPI");
  return (0);

} /* machine_mpi_done */

     /*********************************************************
     *                                                        *
     *  void machine_mpi_wait (int msg_id)                            *
     *                                                        *
     *  - wait for completion of an immediate send/receive    *
     *                                                        *
     *********************************************************/

void machine_mpi_wait (msg_id)
int msg_id;

{
#ifdef MSG_DEBUG
  printf ("%d: isend/irecv for msg_id %d will be waited\n",
           pcb.i, msg_id);
#endif

  /* msgwait (msg_id); */

  dalib_internal_error ("NON BLOCKING mode not available for shared mem");

#ifdef MSG_DEBUG
  printf ("%d: isend/irecv for msg_id %d is finished\n",
           pcb.i, msg_id);
#endif

} /* machine_mpi_wait */
