/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Feb 96                                                   *
*  Last Update : Apr 96                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : rma_access.m4                                            *
*                                                                         *
*  Function: machine dependent remote memory access                       *
*                                                                         *
*      DUMMY version (not                                                 *
*                                                                         *
*  Export :  internal Interface                                           *
*  ============================                                           *
*                                                                         *
*   void dalib_system_rma_init ()                                         *
*                                                                         *
*     - starts remote memory access (if initialization is necessary)      *
*                                                                         *
*   void dalib_system_rma_exit ()                                         *
*                                                                         *
*     - stops remote memory access (can happen for server mode)           *
*                                                                         *
*   void dalib_system_rma_get (char *data, int remote_pid,                *
*                              void *address, int size)                   *
*                                                                         *
*     - read remote data at address on remote_pid (size bytes)            *
*                                                                         *
*   void dalib_system_rma_put (char *data, int remote_pid,                *
*                              void *address, int size)                   *
*                                                                         *
*     - write remote data at address on remote_pid (size bytes)           *
*                                                                         *
*   void dalib_system_rma_update (int op, char *data, int remote_pid,     *
*                                void *address, int size)                 *
*                                                                         *
*     - (atomic) update of remote data at address                         *
*                                                                         *
**************************************************************************/

#undef DEBUG

#include "dalib.h"

#ifdef RMA

#ifdef CENJU

void dalib_system_rma_init ()

{ /* nothing more to do on the CENJU */
}

void dalib_system_rma_exit ()

{ /* nothing more to do on the CENJU */
}

void dalib_system_rma_get (data, remote_pid, address, size)

char *data;
int remote_pid;
void *address;
int size;

{ int rtn;

#ifdef DEBUG
   printf ("%d: system_rma_get from rem_pid = %d, addr = %p, size %d\n",
            pcb.i, remote_pid, address, size);
#endif

  rtn = CJrmread (address, remote_pid-1, data, size);

  if (rtn != size)

    {
      dalib_internal_error ("CJrmread failed; rtn = %d\n", rtn);
      dalib_stop ();
    }

} /* dalib_system_rma_get */

void dalib_system_rma_put (data, remote_pid, address, size)

char *data;
int remote_pid;
void *address;
int size;

{ int rtn;

#ifdef DEBUG
   printf ("%d: system_rma_get from rem_pid = %d, addr = %p, size %d\n",
            pcb.i, remote_pid, address, size);
#endif

  rtn = CJrmwrite (address, remote_pid-1, data, size);

  if (rtn != size)

    {
      dalib_internal_error ("CJrmwrite failed; rtn = %d\n", rtn);
      dalib_stop ();
    }

} /* dalib_system_rma_put */

void dalib_system_rma_update (op, data, remote_pid, address, size)

int op;
char *data;
int remote_pid;
void *address;
int size;

{ dalib_internal_error ("system_rma_update not available");
  dalib_stop ();

} /* dalib_system_rma_update */

#endif


#endif
