/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Feb 97                                                   *
*  Last Update : Feb 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : pack.m4                                                  *
*                                                                         *
*  Function    : F90 intrinsics pack, unpack                              *
*                                                                         *
*  Export :  FORTRAN Interface                                            *
*                                                                         *
**************************************************************************/

#define CHECK
#undef DEBUG

#include <stdio.h>
#include "dalib.h"

/**************************************************************************
*                                                                         *
*  void dalib_do_pack (int size,                                          *
*                      void *result_data,                                 *
*                      int  result_no,                                    *
*                      void *array_data,                                  *
*                      int  array_no,                                     *
*                      int  *mask_data)                                   *
*                                                                         *
**************************************************************************/

static void dalib_do_pack (size, result_data, result_no,
                                 array_data,  array_no,  mask_data)

void    *result_data, *array_data;
INTEGER *mask_data;

int size;            /* number of bytes for one element in array/result */
int result_no;       /* number of elements in result vector             */
int array_no;        /* number of elements in source array / mask       */

{ TYPE1 *result_ptr, *array_ptr;

  int  true_elements;

  int i, j;

  /* not implemented yet 

  if (result_size == 1)
     dalib_mempack1 (result_data, array_data, mask_data, array_no);

  */

   result_ptr = (TYPE1 *) result_data;
   array_ptr  = (TYPE1 *) array_data;

   true_elements = 0;

   for (i=0; i<array_no; i++)

     { if (mask_data[i])

         { /* make sure that result array is sufficient large */

           if (++true_elements > result_no)

             { dalib_internal_error ("PACK: target too small");
               fprintf (stderr, " more than %d true elements in mask\n",
                        result_no);
               dalib_stop ();
             }

           for (j=0; j<size; j++)
              *(result_ptr++) = *(array_ptr++);

         }

        else

          array_ptr += size;

     } /* for all source elements */

} /* dalib_do_pack */

/**************************************************************************
*                                                                         *
*  void dalib_do_unpack (int size,                                        *
*                        void *result_data,                               *
*                        int  result_no,                                  *
*                        void *vector_data,                               *
*                        int  vector_no,                                  *
*                        int  *mask_data)                                 *
*                                                                         *
**************************************************************************/

static void dalib_do_unpack (size, result_data, result_no, 
                             vector_data, vector_no, mask_data)

void    *result_data, *vector_data;
INTEGER *mask_data;

int size;            /* number of bytes for one element in vector/result */
int result_no;       /* number of elements in result vector              */
int vector_no;       /* number of elements in source vector              */

{ TYPE1 *result_ptr;
  TYPE1 *vector_ptr;
  int  true_elements;

  int i, j;

   result_ptr = (TYPE1 *) result_data;
   vector_ptr = (TYPE1 *) vector_data;

   true_elements = 0;

   for (i=0; i<result_no; i++)

     { if (mask_data[i])

         { /* make sure that result array is sufficient large */

           if (++true_elements > vector_no)

             { dalib_internal_error ("UNPACK: source vector too small");
               fprintf (stderr, " more than %d true elements in mask\n",
                        vector_no);
               dalib_stop ();
             }

           for (j=0; j<size; j++)
              *(result_ptr++) = *(vector_ptr++);

         }

        else

          result_ptr += size;

     } /* for all target elements */

} /* dalib_do_unpack */

/**************************************************************************
*                                                                         *
*  FUNCTION (dalib_pack)                                                  * 
*                                                                         *
*    (result, array, mask, vector, ....)                                  *
*                                                                         *
*   - at this time only implemented as a serial routine                   *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_pack) (result,     array,     mask,     vector,
                           result_dsp, array_dsp, mask_dsp, vector_dsp)

void *result, *array, *mask, *vector;

array_info *result_dsp;
array_info *array_dsp;
array_info *mask_dsp;
array_info *vector_dsp;

{ void *result_data, *array_data, *mask_data;   /* data pointers  */
  int  result_no, array_no, mask_no;               /* no of elements */
  int  result_size, array_size, mask_size;       /* size in bytes  */
  int  result_new, array_new, mask_new;           /* new data flag  */

  /* if VECTOR is available copy VECTOR into RESULT at first */

  if (dalib_secarray_is_mapped (result_dsp))

     { dalib_internal_error ("PACK: result is mapped");
       dalib_stop ();
     }

  if (dalib_secarray_is_mapped (array_dsp))

     { dalib_internal_error ("PACK: array is mapped");
       dalib_stop ();
     }

  if (dalib_secarray_is_mapped (mask_dsp))

     { dalib_internal_error ("PACK: mask is mapped");
       dalib_stop ();
     }

  if (FUNCTION(dalib_present) (vector_dsp))

     { if (dalib_secarray_is_mapped (vector_dsp))

          { dalib_internal_error ("PACK: vector is mapped");
            dalib_stop ();
          }

        dalib_secarray_copy (*result_dsp, *vector_dsp);
     }

  dalib_secarray_get_data (*array_dsp, 1,
                      &array_no, &array_size, &array_data, &array_new);

  dalib_secarray_get_data (*mask_dsp, 1,
                      &mask_no, &mask_size, &mask_data, &mask_new);

  dalib_secarray_get_data (*result_dsp, 1,
                      &result_no, &result_size, &result_data, &result_new);

#ifdef CHECK

  if (array_no != mask_no)

     { dalib_internal_error
          ("pack: array and mask have not same number of elements");
       dalib_stop ();

     }

  if (mask_size != sizeof(INTEGER))

     { dalib_internal_error ("pack: mask is not default LOGICAL");
       dalib_stop ();
     }
    
  if (result_size != array_size)

     { dalib_internal_error ("pack: array and result have different type size");
       dalib_stop ();
     }
#endif

#ifdef DEBUG
  printf ("%d: pack %d elements (size = %d bytes)\n",
           pcb.i, array_no, result_size);
  printf ("%d: array has %d elements, size = %d bytes, new = %d\n", 
           pcb.i, array_no, array_size, array_new);
  printf ("%d: mask has %d elements, size = %d bytes, new = %d\n", 
           pcb.i, mask_no, mask_size, mask_new);
  printf ("%d: result has %d elements, size = %d bytes, new = %d\n", 
           pcb.i, result_no, result_size, result_new);
#endif

  dalib_do_pack (array_size, result_data, result_no, 
                 array_data, array_no, (INTEGER *) mask_data);

  if (result_new)

     dalib_secarray_unpack (*result_dsp, result_data);

  if (mask_new) free (mask_data);
  if (array_new) free (array_data);

} /* FUNCTION(dalib_pack) */ 

/**************************************************************************
*                                                                         *
*  FUNCTION (dalib_unpack)                                                * 
*                                                                         *
*    (result, vector, mask, field, ....)                                  *
*                                                                         *
*   - at this time only implemented as a serial routine                   *
*                                                                         *
*   VECTOR : any type, rank one, size at least count(mask)                *
*   MASK   : type logical, array valued                                   *
*   FIELD  : same type as VECTOR, conformable with MASK                   *
*                                                                         *
*   RESULT : same type as vector, same shape as MASK                      *
*                                                                         *
*   RESULT = UNPACK (VECTOR, MASK, FIELD)                                 *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_unpack) (result,     vector,     mask,     field,
                             result_dsp, vector_dsp, mask_dsp, field_dsp)

void *result, *vector, *mask, *field;

array_info *result_dsp;
array_info *vector_dsp;
array_info *mask_dsp;
array_info *field_dsp;

{ char *result_data, *vector_data, *mask_data;   /* data pointers  */
  int  result_no, vector_no, mask_no;               /* no of elements */
  int  result_size, vector_size, mask_size;       /* size in bytes  */
  int  result_new, vector_new, mask_new;           /* new data flag  */

  dalib_secarray_get_data (*vector_dsp, 1,
                      &vector_no, &vector_size, &vector_data, &vector_new);

  dalib_secarray_get_data (*mask_dsp, 1,
                      &mask_no, &mask_size, &mask_data, &mask_new);

  dalib_secarray_get_data (*result_dsp, 0,
                      &result_no, &result_size, &result_data, &result_new);

  /* Attention: field can also be a scalar value */

  if (FUNCTION(dalib_present) (field_dsp))

     { /* field is array valued, so we can copy it to result */

       dalib_secarray_copy (*result_dsp, *field_dsp);

       dalib_secarray_get_data (*result_dsp, 1,
                      &result_no, &result_size, &result_data, &result_new);

     }
  
   else

     { /* field is a scalar, so we copy it result_no times */

       int i, j;
       char *result_ptr;
       char *field_ptr;

       dalib_secarray_get_data (*result_dsp, 0,
                      &result_no, &result_size, &result_data, &result_new);

       result_ptr = result_data;
       field_ptr  = field;

       for (i=0; i<result_no; i++)
           for (j=0; j<result_size; j++)
              *(result_ptr++) = field_ptr[j];
     }

#ifdef CHECK
  if (mask_size != sizeof(INTEGER))

     { dalib_internal_error ("UNPACK: mask is not default LOGICAL");
       dalib_stop ();
     }
    
  if (result_size != vector_size)

     { dalib_internal_error (
          "UNPACK: result and vector have different type size");
       dalib_stop ();
     }
#endif

#ifdef DEBUG
  printf ("%d: UNPACK, vector has %d elements, size = %d bytes, new = %d\n", 
           pcb.i, vector_no, vector_size, vector_new);
  printf ("%d: UNPACK, mask has %d elements, size = %d bytes, new = %d\n", 
           pcb.i, mask_no, mask_size, mask_new);
  printf ("%d: UNPACK, result has %d elements, size = %d bytes, new = %d\n", 
           pcb.i, result_no, result_size, result_new);
#endif

  dalib_do_unpack (result_size, result_data, result_no, 
                   vector_data, vector_no, (INTEGER *) mask_data);

  if (result_new)

     dalib_secarray_unpack (*result_dsp, result_data);

  if (mask_new) free (mask_data);
  if (vector_new) free (vector_data);

} /* FUNCTION(dalib_unpack) */ 
