/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Mar 98                                            *
*  Last Update : Mar 98                                            *
*                                                                  *
*  MODULE : ncombiners.m4                                          *
*                                                                  *
*  Function:   vectorizable reduction routines                     *
*                                                                  *
*******************************************************************/

# include "dalib.h"        /* import type reduction_fn */

static int no_elems;

void dalib_n_or_bools (i1, i2)   /* .OR., ANY */

INTEGER i1[], i2[];

{ int k;
  for (k=0; k<no_elems; k++) if (i2[k]) i1[k] = i2[k];
} /* dalib_n_or_bools */

void dalib_n_and_bools (i1, i2)  /* .AND., ALL */

INTEGER i1[], i2[];
{ int k;
  for (k=0; k<no_elems; k++) if (!i2[k]) i1[k] = i2[k];
} /* dalib_n_and_bools */

void dalib_n_neq_bools (i1, i2)   /* .NEQV., PARITY */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k<no_elems; k++) if (i2[k]) i1[k] = !(i1[k]);
} /* dalib_n_neq_bools */

void dalib_n_add_ints (i1, i2)   /* +, SUM, COUNT */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k<no_elems; k++) i1[k] = i1[k] + i2[k];
} /* dalib_n_add_ints */

void dalib_n_mult_ints (i1, i2)   /* *, PRODUCT */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k<no_elems; k++) i1[k] = i1[k] * i2[k];
} /* dalib_n_mult_ints */

void dalib_n_max_ints (i1, i2)    /* max, MAXVAL */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k < no_elems; k++) if (i2[k] > i1[k]) i1[k] = i2[k]; 
} /* dalib_n_max_ints */

void dalib_n_min_ints (i1, i2)    /* min, MINVAL */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k < no_elems; k++) if (i2[k] < i1[k]) i1[k] = i2[k]; 
} /* dalib_n_min_ints */

void dalib_n_and_ints (i1, i2)   /* IAND, AND */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k < no_elems; k++) i1[k] = i1[k] & i2[k]; 
} /* dalib_n_and_ints */

void dalib_n_or_ints (i1, i2)   /* IOR, OR */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k < no_elems; k++) i1[k] = i1[k] | i2[k]; 
} /* dalib_n_or_ints */

void dalib_n_eor_ints (i1, i2)   /* IEOR, EOR */
INTEGER i1[], i2[];
{ int k;
  for (k=0; k < no_elems; k++) i1[k] = i1[k] ^ i2[k]; 
} /* dalib_n_eor_ints */

void dalib_n_add_reals (f1, f2)   /* +, SUM */
REAL f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) f1[k] = f1[k] + f2[k]; 
} /* dalib_n_add_reals */

void dalib_n_mult_reals (f1, f2)   /* *, PRODUCT */
REAL f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) f1[k] = f1[k] * f2[k]; 
} /* dalib_n_mult_reals */

void dalib_n_max_reals (f1, f2)    /* MAX, MAXVAL */
REAL f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) if (f2[k] > f1[k]) f1[k] = f2[k]; 
} /* dalib_n_max_reals */

void dalib_n_min_reals (f1, f2)    /* MIN, MINVAL */
REAL f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) if (f2[k] < f1[k]) f1[k] = f2[k]; 
} /* dalib_n_min_reals */

void dalib_n_add_doubles (f1, f2)    /* +, SUM */
DOUBLE_PRECISION f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) f1[k] = f1[k] + f2[k]; 
} /* dalib_n_add_doubles */

void dalib_n_mult_doubles (f1, f2)   /* *, PRODUCT */
DOUBLE_PRECISION f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) f1[k] = f1[k] * f2[k]; 
} /* dalib_n_mult_doubles */

void dalib_n_max_doubles (f1, f2)    /* MAX, MAXVAL */
DOUBLE_PRECISION f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) if (f2[k] > f1[k]) f1[k] = f2[k]; 
} /* dalib_n_max_doubles */

void dalib_n_min_doubles (f1, f2)    /* MIN, MINVAL */
DOUBLE_PRECISION f1[], f2[];
{ int k;
  for (k=0; k < no_elems; k++) if (f2[k] < f1[k]) f1[k] = f2[k]; 
} /* dalib_n_min_doubles */

void dalib_n_add_complexes (f1, f2)    /* +, SUM */
REAL f1[], f2[];
{ int k;
  for (k=0; k < 2*no_elems; k++) f1[k] = f1[k] + f2[k];  
} /* dalib_n_add_complexes */

void dalib_n_mult_complexes (f1, f2)    /* *, COMPLEXES */
REAL f1[], f2[];

  /*  (a1,a2) * (b1,b2) = (a1*b1-a2*b2, a1*b2+a2*b1) */

{ int k;
  REAL h;
  for (k=0; k<no_elems; k++)
    { h = f1[2*k];
      f1[2*k  ] = h*f2[2*k  ] - f1[2*k+1]*f2[2*k+1];  
      f1[2*k+1] = h*f2[2*k+1] + f1[2*k+1]*f2[2*k  ]; 
    }
} /* dalib_n_mult_complexes */

     /*********************************************************
     *                                                        *
     *  dalib_routine *dalib_get_n_reduction_fn (int op)      *
     *                                                        *
     *********************************************************/

dalib_routine *dalib_get_n_reduction_fn (op)

int op;

{
  switch (op) {

  case  1 : return (dalib_n_min_ints); 
  case  2 : return (dalib_n_min_reals); 
  case  3 : return (dalib_n_min_doubles);
  case  4 : return (dalib_n_max_ints);
  case  5 : return (dalib_n_max_reals);
  case  6 : return (dalib_n_max_doubles);
  case  7 : return (dalib_n_add_ints);
  case  8 : return (dalib_n_add_reals);
  case  9 : return (dalib_n_add_doubles);
  case 10 : return (dalib_n_mult_ints);
  case 11 : return (dalib_n_mult_reals);
  case 12 : return (dalib_n_mult_doubles);
  case 13 : return (dalib_n_and_ints);
  case 14 : return (dalib_n_or_ints);
  case 15 : return (dalib_n_eor_ints);
  case 16 : return (dalib_n_and_bools);
  case 17 : return (dalib_n_or_bools);
  case 18 : return (dalib_n_neq_bools);
  case 19 : return (dalib_n_add_complexes);
  case 20 : return (dalib_n_mult_complexes);
  default : printf ("dalib: n_reduction, illegal op = %d\n", op);
            dalib_internal_error ("fatal");
            dalib_stop ();

  } /* end of switch */

  return (dalib_n_min_ints);

} /* dalib_get_n_reduction_fn */

void dalib_set_n_reduction_elems (elems)

int elems;

{ no_elems = elems; 

} /* dalib_set_n_reduction_elems */

