/**************************************************************************
*                                                                         *
*  Author      : Thomas Brandes, GMD, SCAI.LAB                            *
*                Cecile Germain, Orsay, LRI                               *
*                                                                         *
*  Copyright   : LRI, Orsay, France                                       *
*  Date        : Mar 97                                                   *
*  Last Update : Mar 97                                                   *
*                                                                         *
*  Module      : inspector.h                                              *
*                                                                         *
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

# define MAX_INSPECTORS 12

/**************************************************************************
*                                                                         *
* FORALL (i=1:number_of_indexes, mask(i))                                 *
*   base_array (ind1(i), ..., indk(i)) = source_array (i)                 *
* END FORALL                                                              *
*                                                                         *
* Notes:                                                                  *
*                                                                         *
*   - inspector will be the same for gather operation                     *
*                                                                         *
**************************************************************************/

        /******************************************************
        *                                                     *
        *   insp_base_dsp                                     *
        *                                                     *
        ******************************************************/

typedef struct

  { int rank;                           /* rank of base                     */

    int lb          [MAX_DIMENSIONS];   /* lb relevant for top dim          */
    int ub          [MAX_DIMENSIONS];
    int left_ov     [MAX_DIMENSIONS];
    int right_ov    [MAX_DIMENSIONS];

    int top_id;                         /* topology to which base is mapped */
    int top_dim     [MAX_DIMENSIONS];   /* index dim mapped to top dim      */

    int t_base      [MAX_DIMENSIONS];   /* offset to aligned template dim */
    int t_stride    [MAX_DIMENSIONS];   /* stride to aligned template dim */
    int t_lb        [MAX_DIMENSIONS];   /* lower bound of template dim    */
    int t_ub        [MAX_DIMENSIONS];   /* upper bound of template dim    */

    int t_kind      [MAX_DIMENSIONS];   /* distribution kind of template  */
    int t_size      [MAX_DIMENSIONS];   /* N for BLOCK(N) or CYCLIC(N)    */

  } insp_base_dsp;

        /******************************************************
        *                                                     *
        *   insp_index_dsp                                    *
        *                                                     *
        ******************************************************/

typedef struct

  { int rank;        /* 0 if index is scalar, rank otherwise */
    int scalar_val;  /* value of index if index is scalar    */

    int section_bounds[MAX_DIMENSIONS][3];
    int *data_ptr;

  } insp_index_dsp;

        /******************************************************
        *                                                     *
        *   inspector_info                                    *
        *                                                     *
        ******************************************************/

typedef struct

  { int number_of_indexes;

    int is_shadow;            /* 1 if inspector for SHADOW array */

    int base_rank;

    array_info   source_array;   /* not available for SHADOW     */

    array_info   base_array;   

    int          is_masked;
    array_info   mask_array;
    int          *mask_data;

    array_info   ind_array [MAX_DIMENSIONS];
    int          *ind_data [MAX_DIMENSIONS];

  } inspector_info;

        /******************************************************
        *                                                     *
        *   inspector_data                                    *
        *                                                     *
        ******************************************************/

typedef struct

  { int number_of_indexes;

    int is_shadow;            /* 1 if inspector for SHADOW array */

    /* relevant information about the base array that is indirectly accessed */

    insp_base_dsp   base_array;

    /* information about the integer arrays/scalars used for indirect access */

    insp_index_dsp  ind_array [MAX_DIMENSIONS];

    /* information about the mask array */

    insp_index_dsp  mask_array;

    /* FLAG to indicate that schedule can be reused */

    int is_traced;

    /* pointer to the schedue    */

    SchedulePtr   schedule_id;

    int *index_changes;    /* info needed for updates in indirection array */

    int shadow_high;       /* offset in shadow area                        */
    int index_temp_size;   /* number of bytes for existing index temporary */

    unsigned char *index_f_data;  /* fortran data for index temporary      */
    unsigned char *index_c_data;  /* allocated data for index temporary    */

  } inspector_data;

/**************************************************************************
*                                                                         *
*    index_changes keeps track of value changes in the indirection array  *
*                                                                         *
*    index_changes [0]    number of new indexes                           *
*                                                                         *
*    index_changes [1]    pos                                             *
*    index_changes [2]    old_index                                       *
*    index_changes [3]    new_index                                       *
*    index_changes [4]    pos                                             *
*    index_changes [5]    old_index                                       *
*    index_changes [6]    new_index                                       *
*    ....                                                                 *
*                                                                         *
*    change_indexes (ind_array, ...)                                      *
*                                                                         *
*       ind_array [pos] = new_index + <ptr to shadow_edge>                *
*                                                                         *
*    reset_indexes (ind_array, ...)                                       *
*                                                                         *
*       ind_array [pos] = old_index (is a non local address)              *
*                                                                         *
**************************************************************************/
