/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Mar 97                                                   *
*  Last Update : Mar 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : f77_local.m4                                             *
*                                                                         *
*  Function    : F77 LOCAL LIBRARY                                        *
*                                                                         *
*  Export :  FORTRAN Interface                                            *
*                                                                         *
*   Note : these routines are called from (serial) Fortran 77 programs    *
*                                                                         *
**************************************************************************/

#define CHECK
#undef  DEBUG

#include "dalib.h"

/**************************************************************************
*                                                                         *
*   F77_SUBGRID_INFO (ARRAY, IERR1, IERR2, DIM, LB, UB, STRIDE,           *
*                     LB_EMBED, UB_EMBED, AXIS_MAP)                       *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_subgrid_info)

  (array, ierr1, ierr2, dim, lb, ub, stride, lb_embed, ub_embed, axis_map)

section_info *array;   /* is assumed to be a descriptor */

INTEGER *ierr1;
INTEGER *ierr2;

INTEGER *dim;
INTEGER *lb, *ub, *stride;
INTEGER *lb_embed, *ub_embed, *axis_map;

{ int rank;

  /* note : dim should not be available   */
  /* Note : axis_map is not computed here */

  if (dalib_is_array_info (*array))

     { dalib_array_local_shape (*array, &rank, lb, ub, stride); 
       *ierr1 = 0;
       dalib_array_local_embedding (*array, ierr2, &rank, lb_embed, ub_embed);
     }

    else

     { dalib_internal_error ("SUBGRID_INFO : only for arrays");
       dalib_stop ();
     }

} /* f77_subgrid_info */

/**************************************************************************
*                                                                         *
*  F77_GLOBAL_ALIGNMENT (ALIGNEE, LB, UB, STRIDE, AXIS_MAP,               *
*                        IDENTITY_MAP, DYNAMIC, NCOPIES)                  *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_global_alignment)

  (alignee, lb, ub, stride, axis_map, identity_map, dynamic, ncopies)

section_info *alignee;

int  *lb, *ub, *stride, *identity_map, *dynamic, *ncopies;
int  *axis_map;

{ dalib_internal_error ("f77_global_alignment not implemented yet");
  dalib_stop ();

} /* f77_global_alignment */

/**************************************************************************
*                                                                         *
*  F77_GLOBAL_DISTRIBUTION (DISTRIBUTEE, AXIS_TYPE, AXIS_INFO,            *
*                           PROCESSORS_RANK, PROCESSORS_SHAPE)            *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_global_distribution)

  (distributee, axis_type, axis_info, processors_rank, processors_shape)

section_info *distributee;
char *axis_type;
int  *axis_info;
int  *processors_rank, *processors_shape;

{ dalib_internal_error ("f77_global_distribution not implemented yet");
  dalib_stop ();

} /* f77_global_distribution */

/**************************************************************************
*                                                                         *
*   F77_GLOBAL_TEMPLATE (ALIGNEE, TEMPLATE_RANK, LB, UB,                  *
*                        AXIS_TYPE, AXIS_INFO, NUMBER_ALIGNED, DYNAMIC)   *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_global_template)

  (alignee, template_rank, lb, ub, axis_type, axis_info,
   number_aligned, dynamic)

section_info *alignee;
int  *lb, *ub;
char *axis_type;
int  *axis_info, *number_aligned, *dynamic;
int  *template_rank;

{ dalib_internal_error ("f77_global_template not implemented yet");
  dalib_stop ();

} /* f77_global_template */

/**************************************************************************
*                                                                         *
*   F77_ABSTRACT_TO_PHYSICAL (ARRAY, INDEX, PROC)                         *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_abstract_to_physical) (array, index, proc)

section_info *array;
int *index;
int *proc;

{ dalib_internal_error ("f77_abstract_to_physical not implemented yet");
  dalib_stop ();

} /* f77_abstract_to_physical */

/**************************************************************************
*                                                                         *
*   F77_PHYSICAL_TO_ABSTRACT (ARRAY, PROC, INDEX)                         *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_physical_to_abstract) (array, proc, index)

section_info *array;
int *proc;
int *index;

{ dalib_internal_error ("f77_physical_to_abstract not implemented yet");
  dalib_stop ();

} /* f77_physical_to_abstract */

/**************************************************************************
*                                                                         *
*   F77_LOCAL_TO_GLOBAL (ARRAY, L_INDEX, G_INDEX)                         *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_local_to_global) (array, l_index, g_index)

section_info *array;
int *l_index;
int *g_index;

{ dalib_internal_error ("f77_local_to_global not implemented yet");
  dalib_stop ();

} /* f77_local_to_global */

/**************************************************************************
*                                                                         *
*   F77_GLOBAL_TO_LOCAL (ARRAY, G_INDEX, L_INDEX, LOCAL, NCOPIES, PROCS)  *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_global_to_local) (array, l_index, g_index)

section_info *array;
int *l_index;
int *g_index;

{ dalib_internal_error ("f77_global_to_local not implemented yet");
  dalib_stop ();

} /* f77_global_to_local */

/**************************************************************************
*                                                                         *
*   F77_LOCAL_BLKCNT (L_BLKCNT, ARRAY, DIM, PROC)                         *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_local_blkcnt) (l_blkcnt, array, dim, proc)

{ dalib_internal_error ("f77_local_blkcnt not implemented yet");
  dalib_stop ();

} /* f77_local_blkcnt */

/**************************************************************************
*                                                                         *
*   F77_LOCAL_LINDEX (L_LINDEX, ARRAY, DIM, PROC)                         *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_local_lindex) (l_lindex, array, dim, proc)

{ dalib_internal_error ("f77_local_lindex not implemented yet");
  dalib_stop ();

} /* f77_local_lindex */

/**************************************************************************
*                                                                         *
*   F77_LOCAL_UINDEX (L_UINDEX, ARRAY, DIM, PROC)                         *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_local_uindex) (l_uindex, array, dim, proc)

{ dalib_internal_error ("f77_local_uindex not implemented yet");
  dalib_stop ();

} /* f77_local_uindex */

/**************************************************************************
*                                                                         *
*   F77_GLOBAL_SHAPE (SHAPE, ARRAY)                                       *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_global_shape) (shape, array)

INTEGER    *shape;
array_info *array;

{ int rank;

  dalib_secarray_shape (array, &rank, shape);

} /* f77_global_shape */

/**************************************************************************
*                                                                         *
*   F77_GLOBAL_SIZE (SIZE, ARRAY, DIM)                                    *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_global_size) (size, array, dim)

INTEGER    *size;
array_info *array;
INTEGER    *dim;

{ int shape[MAX_DIMENSIONS];
  int i, rank;
  int idim;

  dalib_secarray_shape (array, &rank, shape);

  idim = *dim;

  if (idim == -1)

    { *size = 1;

      for (i=0; i<rank; i++)
         *size  = *size * shape[i];

    }
 
  else if ( (idim > 0) && (idim <= rank) )

     *size = shape[idim-1];

  else

     { dalib_internal_error ("f77_global_size : illegal val for dim");
       dalib_stop ();
     }

} /* f77_global_size */

/**************************************************************************
*                                                                         *
*   F77_SHAPE (SHAPE, ARRAY)                                              *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_shape) (shape, array)

{ dalib_internal_error ("f77_shape not implemented yet");
  dalib_stop ();

} /* f77_shape */

/**************************************************************************
*                                                                         *
*   F77_SIZE (SIZE, ARRAY, DIM)                                           *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_size) (size, array, dim)

INTEGER    *size;
array_info *array;
INTEGER    *dim;

{ dalib_internal_error ("f77_size not implemented yet");
  dalib_stop ();

} /* f77_size */

/**************************************************************************
*                                                                         *
*   F77_MY_PROCESSOR (MY_PROC)                                            *
*                                                                         *
**************************************************************************/

void FUNCTION(f77_my_processor) (my_proc)

INTEGER *my_proc;

{ *my_proc = pcb.i - 1;

} /* f77_my_processor */

