/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Apr 93                                            *
*                                                                  *
*  MODULE : combiners.c                                            *
*                                                                  *
*  Function:   Actual parameter functions for reductions/scatters  *
*                                                                  *
*******************************************************************/

# include "dalib.h"        /* import type reduction_fn */

void or_bools (i1, i2)   /* .OR., ANY */
INTEGER *i1, *i2;
{ if (*i2) *i1 = *i2;
}

void and_bools (i1, i2)  /* .AND., ALL */
INTEGER *i1, *i2;
{ if (!(*i2)) *i1 = *i2;
}

void neq_bools (i1, i2)   /* .NEQV., PARITY */
INTEGER *i1, *i2;
{ if (*i2) *i1 = !(*i1);
}

void add_ints (i1, i2)   /* +, SUM, COUNT */
INTEGER *i1, *i2;
{ *i1 = *i1 + *i2;
}

void mult_ints (i1, i2)   /* *, PRODUCT */
INTEGER *i1, *i2;
{ *i1 = *i1 * *i2;
}

void max_ints (i1, i2)    /* max, MAXVAL */
INTEGER *i1, *i2;
{ if (*i2 > *i1) *i1 = *i2; }

void min_ints (i1, i2)    /* min, MINVAL */
INTEGER *i1, *i2;
{ if (*i2 < *i1) *i1 = *i2; }

void and_ints (i1, i2)   /* IAND, AND */
INTEGER *i1, *i2;
{ *i1 = *i1 & *i2;
}

void or_ints (i1, i2)   /* IOR, OR */
INTEGER *i1, *i2;
{ *i1 = *i1 | *i2;
}

void eor_ints (i1, i2)   /* IEOR, EOR */
INTEGER *i1, *i2;
{ *i1 = *i1 ^ *i2;
}

void add_reals (f1, f2)   /* +, SUM */
REAL *f1, *f2;
{ *f1 = *f1 + *f2; }

void mult_reals (f1, f2)   /* *, PRODUCT */
REAL *f1, *f2;
{ *f1 = *f1 * *f2; }

void max_reals (f1, f2)    /* MAX, MAXVAL */
REAL *f1, *f2;
{ if (*f2 > *f1) *f1 = *f2; }

void min_reals (f1, f2)    /* MIN, MINVAL */
REAL *f1, *f2;
{ if (*f2 < *f1) *f1 = *f2; }

void add_doubles (f1, f2)    /* +, SUM */
DOUBLE_PRECISION *f1, *f2;
{ *f1 = *f1 + *f2; }

void mult_doubles (f1, f2)   /* *, PRODUCT */
DOUBLE_PRECISION *f1, *f2;
{ *f1 = *f1 * *f2; }

void max_doubles (f1, f2)    /* MAX, MAXVAL */
DOUBLE_PRECISION *f1, *f2;
{ if (*f2 > *f1) *f1 = *f2; }

void min_doubles (f1, f2)    /* MIN, MINVAL */
DOUBLE_PRECISION *f1, *f2;
{ if (*f2 < *f1) *f1 = *f2; }

void add_complexes (f1, f2)    /* +, SUM */
REAL f1[2], f2[2];
{ f1[0] = f1[0] + f2[0];  
  f1[1] = f1[1] + f2[1]; }

void mult_complexes (f1, f2)    /* *, COMPLEXES */
REAL f1[2], f2[2];

  /*  (a1,a2) * (b1,b2) = (a1*b1-a2*b2, a1*b2+a2*b1) */

{ REAL h;
  h = f1[0];
  f1[0] = h*f2[0] - f1[1]*f2[1];  
  f1[1] = h*f2[1] - f1[1]*f2[0]; 
}

/*******************************************************************
*                                                                  *
*  reduction functions with saving position                        *
*                                                                  *
*******************************************************************/

void max_pos_ints (p1, p2, f1, f2)    /* MAX, MAXLOC */
INTEGER *p1, *p2;
INTEGER *f1, *f2;
{ if (*f2 > *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void min_pos_ints (p1, p2, f1, f2)    /* MIN, MINLOC */
INTEGER *p1, *p2;
INTEGER *f1, *f2;
{ if (*f2 < *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void max_pos_reals (p1, p2, f1, f2)    /* MAX, MAXLOC */
INTEGER *p1, *p2;
REAL *f1, *f2;
{ if (*f2 > *f1) 
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void min_pos_reals (p1, p2, f1, f2)    /* MIN, MINLOC */
INTEGER *p1, *p2;
REAL *f1, *f2;
{ if (*f2 < *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void max_pos_doubles (p1, p2, f1, f2)    /* MAX, MAXLOC */
INTEGER *p1, *p2;
DOUBLE_PRECISION *f1, *f2;
{ if (*f2 > *f1)
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

void min_pos_doubles (p1, p2, f1, f2)    /* MIN, MINLOC */
INTEGER *p1, *p2;
DOUBLE_PRECISION *f1, *f2;
{ if (*f2 < *f1) 
     { *f1 = *f2; 
       *p1 = *p2;
     }
}

     /*********************************************************
     *                                                        *
     *  dalib_routine *dalib_get_reduction_fn (int op)        *
     *                                                        *
     *********************************************************/

dalib_routine *dalib_get_reduction_fn (op)

int op;

{
  switch (op) {

  case  1 : return (min_ints); 
  case  2 : return (min_reals); 
  case  3 : return (min_doubles);
  case  4 : return (max_ints);
  case  5 : return (max_reals);
  case  6 : return (max_doubles);
  case  7 : return (add_ints);
  case  8 : return (add_reals);
  case  9 : return (add_doubles);
  case 10 : return (mult_ints);
  case 11 : return (mult_reals);
  case 12 : return (mult_doubles);
  case 13 : return (and_ints);
  case 14 : return (or_ints);
  case 15 : return (eor_ints);
  case 16 : return (and_bools);
  case 17 : return (or_bools);
  case 18 : return (neq_bools);
  case 19 : return (add_complexes);
  case 20 : return (mult_complexes);
  default : printf ("dalib: reduction, illegal op = %d\n", op);
            dalib_internal_error ("fatal");

  } /* end of switch */

  return (min_ints);

} /* dalib_get_reduction_fn */

     /*********************************************************
     *                                                        *
     *  dalib_routine *dalib_get_pos_reduction_fn (int op)    *
     *                                                        *
     *********************************************************/

dalib_routine *dalib_get_pos_reduction_fn (op)

int op;

{
  switch (op) {

  case  1 : return (min_pos_ints);
  case  2 : return (min_pos_reals);
  case  3 : return (min_pos_doubles);
  case  4 : return (max_pos_ints);
  case  5 : return (max_pos_reals);
  case  6 : return (max_pos_doubles);

  default : printf ("dalib: loc reduction, illegal op = %d\n", op);
            dalib_internal_error ("fatal");

  } /* end of switch */

  return (min_pos_ints);   /* give a default value */

} /* dalib_get_pos_reduction_fn */

     /*********************************************************
     *                                                        *
     *                                                        *
     *********************************************************/

int dalib_get_reduction_size (op)

int op;

{
  switch (op) {

  case  1 : return(sizeof(INTEGER));            /* MIN (int, int)       */
  case  2 : return(sizeof(REAL));               /* MIN (real, real)     */
  case  3 : return(sizeof(DOUBLE_PRECISION));   /* MIN (double, double) */
  case  4 : return(sizeof(INTEGER));            /* MAX (int, int)       */
  case  5 : return(sizeof(REAL));
  case  6 : return(sizeof(DOUBLE_PRECISION));
  case  7 : return(sizeof(INTEGER));            /* int + int            */
  case  8 : return(sizeof(REAL));
  case  9 : return(sizeof(DOUBLE_PRECISION));
  case 10 : return(sizeof(INTEGER));            /* int * int            */
  case 11 : return(sizeof(REAL));
  case 12 : return(sizeof(DOUBLE_PRECISION));
  case 13 : return(sizeof(INTEGER));          /* IOR  */
  case 14 : return(sizeof(INTEGER));          /* IAND */
  case 15 : return(sizeof(INTEGER));          /* IEOR */
  case 16 : return(sizeof(INTEGER));          /* AND */
  case 17 : return(sizeof(INTEGER));          /* OR */
  case 18 : return(sizeof(INTEGER));          /* NEQ */
  case 19 : return(2*sizeof(REAL));           /* complex add  */
  case 20 : return(2*sizeof(REAL));           /* complex mult */

  default : printf ("dalib: reduction, illegal op = %d\n", op);
            dalib_internal_error ("fatal");
            return (0);

  } /* end of switch */

} /* dalib_get_reduction_size */

