/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Nov 98                                            *
*                                                                  *
*  MODULE : arguments.m4                                           *
*                                                                  *
*  EXPORT (only in DALIB)                                          *
*                                                                  *
*  void dalib_set_program_name ()                                  *
*                                                                  *
*    - sets program name globally in variable dalib_program_name   *
*      (programs might be called with different names -> tasks)    *
*                                                                  *
*    - called by all processors in initall                         *
*                                                                  *
*  void eval_arg (default_NP, max_NP)                              *
*                                                                  *
*  Get values for number of processors and set trace_flag          *
*                                                                  *
*   setenv NP 10 or 2x5 or 2x2x3                                   *
*   setenv TRACE on | 1 | ON                                       *
*                                                                  *
*  command line arguments have highest priority                    *
*                                                                  *
*  UPDATES                                                         *
*  =======                                                         *
*                                                                  *
*  10/1998   Allow for MPMD execution of different HPF tasks       *
*  11/1998   environment via variables TIME/COMM/REDIST/TASKS      *
*                                                                  *
*******************************************************************/

#undef DEBUG

#if defined(SX4)
/* make sure that INDEX routine returns address and not integer */
#include <string.h>
#endif

#include "dalib.h"

#define ARG_SIZE 120 

char dalib_program_name [MAX_FNAME_LEN];

extern char *getenv ();

void dalib_set_top1 (n1)
int n1;
{
#ifdef DEBUG
  printf ("dalib_set_top1 (%d)\n", n1);
#endif
  pcb.p = n1;
  pcb.p_rank = 1;
  pcb.p2_1 = 0;
  pcb.p2_2 = 0;
  pcb.p3_1 = 0;
  pcb.p3_2 = 0;
  pcb.p3_3 = 0;
} /* dalib_set_top1 */

void dalib_set_top2 (n1, n2)
int n1, n2;

{
#ifdef DEBUG
  printf ("dalib_set_top2 (%d, %d)\n", n1, n2);
#endif

  pcb.p = n1 * n2;
  pcb.p_rank = 2;
  pcb.p2_1 = n1;
  pcb.p2_2 = n2;
  pcb.p3_1 = 0;
  pcb.p3_2 = 0;
  pcb.p3_3 = 0;
}

void dalib_set_top3 (n1, n2, n3)
int n1, n2, n3;

{
#ifdef DEBUG
  printf ("dalib_set_top3 (%d, %d, %d)\n", n1, n2, n3);
#endif

  pcb.p = n1 * n2 * n3;
  pcb.p_rank = 3;
  pcb.p2_1 = 0;
  pcb.p2_2 = 0;
  pcb.p3_1 = n1;
  pcb.p3_2 = n2;
  pcb.p3_3 = n3;
}

void dalib_env_top2 (argument)
char *argument;

{ int n1, n2;
  if (sscanf (argument, "%dx%d", &n1, &n2) == 2)
     dalib_set_top2 (n1, n2);
  else if (sscanf (argument, "%dX%d", &n1, &n2) == 2)
     dalib_set_top2 (n1, n2);
  else if (sscanf (argument, "%d %d", &n1, &n2) == 2)
     dalib_set_top2 (n1, n2);
} /* dalib_env_top2 */

void dalib_env_top3 (argument)
char *argument;

{ int n1, n2, n3;
  if (sscanf (argument, "%dx%dx%d", &n1, &n2, &n3) == 3)
     dalib_set_top3 (n1, n2, n3);
  else if (sscanf (argument, "%dX%dX%d", &n1, &n2, &n3) == 3)
     dalib_set_top3 (n1, n2, n3);
  else if (sscanf (argument, "%d %d %d", &n1, &n2, &n3) == 3)
     dalib_set_top3 (n1, n2, n3);
} /* dalib_env_top3 */

void dalib_print_arg_info ()

{  printf (
"<executable> [-call] [-redist] [-comm] [-time] [-t] [n1[xn2[xn3]]]\n"
   );

   /* normal termination without error: stops other processes (?) */

   dalib_system_exit (0);

} /* dalib_print_arg_info */

/*******************************************************************
*                                                                  *
*  int dalib_no_args ()                                            *
*                                                                  *
*   - returns number of arguments in the command line              *
*                                                                  *
*   ATTENTION: might be machine-specific                           *
*                                                                  *
*******************************************************************/

int dalib_no_args ()

{ int narg;

#if defined(HPPA) || defined(CRAY)
  int IARGC ();
#elif defined(PowerPC)
  /* iarg not available for PowerPC */
#else
  int iargc_ ();
#endif

#if defined(HPPA)
  narg = IARGC ();
#elif defined(CRAY)
  narg = IARGC ();
#elif defined(PowerPC)
  narg = 0;
#else
  narg = iargc_ ();
#endif

  return narg;

} /* dalib_no_args */

/*******************************************************************
*                                                                  *
*  void dalib_get_argument (int argpos, char argval[ARG_POS])      *
*                                                                  *
*   - get the argument argpos from command line                    *
*   - argpos == 0 stands for the program name                      *
*                                                                  *
*   ATTENTION: might be machine-specific                           *
*                                                                  *
*******************************************************************/

void dalib_get_argument (argpos, argval)

int  argpos;
char *argval;

{ int pos;
  char *p;      /* pointer to the leading blanks */

#if defined(HPPA)
  char *GETARG ();
#elif defined (CRAY)
  char *PXFGETARG (); int ilen; int ierror;
  _fcd argument_fcd;
#elif defined(PowerPC) 
  /* getarg not avialable */
#else
  char *getarg_ ();
#endif

  pos = argpos;     /* copy dummy argument to local variable */

#if defined(HPPA)
  GETARG (&pos, argval, ARG_SIZE-1);
#elif defined(CRAY)
  argument_fcd = _cptofcd (argval, ARG_SIZE-1);
  PXFGETARG (&pos, argument_fcd, &ilen, &ierror);
#elif defined(PowerPC)
  /* getarg not available */
#else
  getarg_ (&pos, argval, ARG_SIZE-1);
#endif

  /* Trim trailing blanks */

  p = (char *) INDEX(argval,' ');

  if (p)   /* p can be the null pointer if no blanks in argval 
              bug report of Soma Ghosh, 27th Nov 1997          */

  *p = '\0';

} /* dalib_get_argument */

/*******************************************************************
*                                                                  *
*   void dalib_is_env_on (char env_name[], int *value)             *
*                                                                  *
*    value = 1   if environment name is set to on/ON/1             *
*    value = 0   otherwise                                         *
*                                                                  *
*******************************************************************/

static void dalib_is_env_on (env_name, value)

char env_name[];
int  *value;

{ char *argument;

  argument = getenv (env_name);

  /* return directly if environment variable is not set */

  if (argument == ((char *)0) ) return;

  if (strcmp(argument,"1") == 0)
     *value = 1;
   else if (strcmp(argument,"on") == 0)
     *value = 1;
   else if (strcmp(argument,"ON") == 0)
     *value = 1;

#ifdef DEBUG
  printf ("%d: eval environment variable %s = %s, value = %d\n", 
           pcb.i, env_name, argument, *value); 
#endif

} /* dalib_is_env_on */

/*******************************************************************
*                                                                  *
*  void eval_arg (int default_NP, int max_NP)                      *
*                                                                  *
*    - sets pcb.trace_flag   (1 if TRACE  is on/ON/1) or -t        *
*    - sets pcb.time_flag    (1 if TIME   is on/ON/1) or -time     *
*    - sets pcb.call_flag    (1 if CALL   is on/ON/1) or -call     *
*    - sets pcb.redist_flag  (1 if REDIST is on/ON/1) or -redist   *
*    - sets pcb.comm_flag    (1 if COMM   is on/ON/1) or -comm     *
*                                                                  *
*******************************************************************/

void eval_arg (default_NP, max_NP)

int default_NP, max_NP;

{ char *argument;

  char argval[ARG_SIZE];
  char *p;
  int narg;
  int i, j;
  int NP;

  /* defaults */

  NP = default_NP;

  dalib_set_top1 (NP);

  pcb.trace_flag = 0;    /* default start without trace */
  pcb.call_flag = 0;     /* default start without call trace */
  pcb.redist_flag = 0;   /* default start without redist trace */
  pcb.comm_flag = 0;     /* default start without comm statistics */
  pcb.time_flag = 0;     /* default start without time statistics */

  argument = getenv ("NP");

  if (argument != ((char *)0) )

     {  /* printf ("eval environment variable NP = %s\n", argument); */
        sscanf (argument, "%d", &NP);
        dalib_set_top1 (NP);
        dalib_env_top2 (argument);
        dalib_env_top3 (argument);
        NP = pcb.p;
     }

  dalib_is_env_on ("TRACE",  &(pcb.trace_flag));
  dalib_is_env_on ("TIME",   &(pcb.time_flag));
  dalib_is_env_on ("CALL",   &(pcb.call_flag));
  dalib_is_env_on ("REDIST", &(pcb.redist_flag));
  dalib_is_env_on ("COMM",   &(pcb.comm_flag));

  argument = getenv ("TASK_FILE");

  if (argument != ((char *)0) )

     pcb.mpmd_flag = dalib_mpmd_read_taskfile (argument);

  narg = dalib_no_args ();

  for (i=0;i<=narg;i++)

      { dalib_get_argument (i, argval);

        printf ("arg[%d] = :%s:\n", i, argval);

        if (i == 0)
 
         { /* find the program name */

           p = (char *) strrchr (argval, '/');
 
           if (p != (char *) 0)
              p = p + 1;
            else
              p = argval;

           strcpy (dalib_program_name, p);

         }

         else if (strcmp (argval, "-t") == 0)
           pcb.trace_flag = 1;
         else if (strcmp (argval, "-call") == 0)
           pcb.call_flag = 1;
         else if (strcmp (argval, "-redist") == 0)
           pcb.redist_flag = 1;
         else if (strcmp (argval, "-time") == 0)
           pcb.time_flag = 1;
         else if (strcmp (argval, "-comm") == 0)
           pcb.comm_flag = 1;
          else if (strcmp (argval, "-help") == 0)
           dalib_print_arg_info ();
          else if (strcmp (argval, "-n") == 0)
           pcb.trace_flag = 0;
          else
           { sscanf (argval, "%d", &NP);
             dalib_set_top1 (NP);
             dalib_env_top2 (argval);
             dalib_env_top3 (argval);
             NP = pcb.p;
           }
      }

  /* Enter number of processes */

  while ((NP > max_NP) || (NP < 1))

   { printf ("Please enter number of processes : \n");
     scanf ("%d",&NP);
     dalib_set_top1 (NP);
     if ((NP > max_NP) || (NP < 1))
       { printf ("Illegal Number of Processes (only %d - %d)\n", 1, max_NP);
         NP = 0;
       }
   }

  NP = pcb.p;

  if (pcb.trace_flag == 1)
     printf ("starting %d processes with trace\n", NP);
#ifdef DEBUG
    else
     printf ("starting %d processes\n", NP);
#endif

}  /* eval_arg */

/*******************************************************************
*                                                                  *
*  void dalib_set_program_name ()                                  *
*                                                                  *
*    - sets program name globally in variable dalib_program_name   *
*      (programs might be called with different names -> tasks)    *
*                                                                  *
*    - called by all processors in initall                         *
*                                                                  *
*******************************************************************/

void dalib_set_program_name ()

{ char pname [ARG_SIZE];
  char *p;

  /* find the program name */

  dalib_get_argument (0, pname);

  p = (char *) strrchr (pname, '/');
 
  if (p != (char *) 0)
     p = p + 1;
   else
     p = pname;

  strcpy (dalib_program_name, p);

#ifdef DEBUG
  printf ("set my program name = :%s:\n", pcb.i, dalib_program_name);
#endif

} /* dalib_set_program_name */
