/*
 *   init.m4  --  part of DALIB
 *
 *   DALIB is run-time library of Adaptor.
 *   Adaptor is implementation of High Performance Fortran
 *   Copyright(c) GMD St. Augustin, Germany
 *
 *   System-dependent initialization over Embedded Parix system.
 *   Written by Ilya Evseev, CSA, Russia~. Date: Nov 1998
 *   Contact e-mail: evseev@csa.ru
 */

#include <stdio.h>
#include <stdarg.h>

#include "dalib_epx.h"


#define  min(a,b)  ( ((a)<(b))? (a):(b) )
#define  max(a,b)  ( ((a)>(b))? (a):(b) )


/*
 *  Called from DALIB before exit()
 */
void dalib_machine_exit( void )
{
    if( topoId >= 0 )
        FreeTop( topoId );
}


/*
 *  Called from DALIB at startup
 */
void dalib_machine_enroll( int *NP )
{
    int myRank, nProcs, error, i, linkId;

 /* setup common data. note: pcb.i=1..nProcs ! */

    pcb.i = ( myRank = GET_ROOT()->ProcRoot->MyProcId ) + 1;
    *NP   =   nProcs = GET_ROOT()->ProcRoot->nProcs;

 /* create topology, init asynchronous communications */

    if(( topoId = NewTop( nProcs )) < 0 )
        dalib_epx_stop("NewTop() failed");
    AInit( topoId, -1, 0 );  /* unlimited threads count, no temp buffering */

 /* establish connections with all other nodes */

    DBG( printf("%d. Allocated links:", pcb.i) );

    for( i=0; i<nProcs; i++ )
    {
        linkId = min( i, myRank ) + nProcs * ( 1 + max( i, myRank ) );
        if( i != myRank )
        {
            mailbox[i].LinkCB = ConnectLink( i, linkId, &error );
            if( error < 0 )
                dalib_epx_stop("ConnectLink() failed: %d/%d", i, nProcs );
        } else
            mailbox[i].LinkCB = (LinkCB_t *) NULL;
        if(( error = AddTop( topoId, mailbox[i].LinkCB )) < 0 )
            dalib_epx_stop("AddTop() failed: %d/%d, error=%d",
                i, nProcs, error );
        DBG( printf("  ptr=%p,id=%d", mailbox[i].LinkCB, linkId ) );
    }

    DBG( printf("\n") );

 /* only first process gets the parameters */

    if (pcb.i == 1)
        eval_arg (*NP, *NP);

} /* dalib_machine_enroll */

/* EOF */
