/*
 *   dalib_epx.h  --  part of DALIB
 *
 *   DALIB is run-time library of Adaptor.
 *   Adaptor is implementation of High Performance Fortran
 *   Copyright(c) GMD St. Augustin, Germany
 *
 *   Common data and routines for communications over Embedded Parix system.
 *   Written by Ilya Evseev, CSA, Russia~. Date: Nov 1998
 *   Contact e-mail: evseev@csa.ru
 */


#include "dalib.h"

#include <epx/root.h>


/*
 *  Debugging facilities
 */
/*#define DEBUG*/

#ifdef DEBUG
#  define  DBG(expression)  expression
#else
#  define  DBG(expression)
#endif


/*
 *  Macro that returns count of items in given array
 */
#define  ELEMS(array)  (sizeof(array)/sizeof(array[0]))


/*
 *  Each node contain array of mailboxes
 *  for connectivity with all others nodes
 */
typedef struct
{
    char     *msgbuf;   /* last message sent in asynchronous mode. */
                        /* NULL, if none */
    int       msglen;
    LinkCB_t *LinkCB;   /* perform permanent connections between all nodes */
} mailbox_t;

extern mailbox_t mailbox[];   /* Contain MAXP items */


/*
 *  Ident of virtual topology used by DALIB_EPX
 *  for asynchronous commutations
 */
extern int topoId;


/*
 *  print formatted message and abort execution
 */
void dalib_epx_stop( char *format, ... );


/* EOF */
