/*************************************************************************
*                                                                        *
*  Name : listsglobal.h                                                  *
*                                                                        *
*  Purpose : declaration of global data for genlists                     *
*            (generated userlisting for fadapt from fadapt prot-files)   *
*                                                                        *
*  Author : Resi Hoever-Klier, GMD, SCAI.LAB                             *
*                                                                        *
*  Last Update : Feb.  1997                                              *
*                                                                        *
*************************************************************************/

#include <stdio.h>
# include "ratc.h"

 
#define MESSAGE_FILE_NAME "adaptor.messages"
 
#define MAXPATHLEN 128


          /*************************************************
          *                                                *
          *  Names                                         *
          *                                                *
          *************************************************/

extern char    errormessage[];  
extern char    extractsfile[];   /* only one file */
extern char    sortfilename[];   /* only one file */
extern char    message_file_name[];   /* only one file */


#define MAX_SOURCE_FILE_NAMES 100 /* max. nr. of adapted source-files */
                         /* max. len. of source_file_name: MAXPATHLEN */

extern int     act_source_file;
extern int     no_source_files;
extern char ** source_file_names;    /* many names */
extern int     act_source_file_line; 


#define MAX_PU_S 100          /* max. nr. of adapted program units */
#define MAX_PU_HEAD_LEN 50

extern int     act_pu;
extern int     no_pus;               /* no of pu's already found */
extern char ** pu_heads;             /* many names */


extern char * generated_source_file_names;
extern int    offset_of_next_source_file_name; /*start point in gen'ed pu_n's */
extern int    max_size_of_source_file_names;

extern char * generated_pu_heads;
extern int    offset_of_next_pu_head;  /* starting point ingenerated pu_heads*/
extern int    max_size_of_pu_heads;

 
/* possible values for act_prot_file, must be conform to the
   prot_file_names defined in genlists.c        */

#define NO_PROT_FILES 16

#define DEF       0
#define SEM       1
#define CF        2
#define DIST      3
#define NORMAL    4
#define OVL       5
#define IPA       6
#define ANA       7
#define ARGS      8
#define LOOPS     9
#define HOME      10
#define LOCAL     11
#define CLASS     12
#define OPT       13
#define CODE      14
#define FINAL     15

extern char *prot_file_names [];  /* character description of prot_file_names */
extern int no_prot_file_names;    /* number of entries of machine_items */
extern int act_prot_file;         /* currently examined prot-file       */
extern FILE *prot_file_ptr [];    /* list of file pointers */
extern int protf_lineno;          /* actual line of actual prot_file */
 
#define PROT_FILE_LINE_LEN 240      /* ist das so?? */



          /*************************************************
          *                                                *
          *  Collection of Messages                        *
          *                                                *
          *************************************************/


typedef struct {
   int pu;                /* index of program unit in array of names of pu's */
   int file;         /* ind of f-name in array of names of adapted source-f's */
   int line_nr;           /* related line_nr. in source file */
   int prot_file;         /* ind of prot_file_name in array of names of p-f's */
   long msg_start;        /* postion of msg_start in prot_file */
   long msg_end;          /* position of msg_end in prot_file */
  }  msg;    /* rememered for each msg found */
 
/*extern  msg messages[];*/   /*all the messages found */
extern int no_messages;   /* no. of messages already collected */

#define MAX_MESSAGES 100000
		/* max. number of messages; very happy suggestion */
 /* (NO_PROT_FILES+10) * NO_LINES_OF_ADAPTDED_SOURCE_FILES might be o.k. */
 
#define VERSION_STRING "GENLIST 1.0 (Feb 1997)"
