/*************************************************************************
*                                                                        *
*  Name : global.h                                                       *
*                                                                        *
* !!!! copy of /home/brandes/adaptor/compiler1/global.h from 18.4.97 !!! *
*                                                                        *
*  Purpose : declaration of global data for ADAPTOR translation          *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, I1.HR                               *
*                                                                        *
*  Last Update : April 1993                                              *
*                                                                        *
*************************************************************************/

#include "ratc.h"

#define MAX_LINE_LENGTH 132
#define MAX_DIMENSIONS   7    /* maximal rank of an array       */
#define MAX_TORUS_RANK   3    /* maximal rank of torus topology */
 
          /*************************************************
          *                                                *
          *  DRIVER  FLAGS                                 *
          *                                                *
          *************************************************/
 
extern int     no_input_files;
extern char ** input_file_name;    /* many files */
extern char *  output_file_name;   /* only one file */
 
          /*************************************************
          *                                                *
          *  Fix Length                                    *
          *                                                *
          *    (relevant number of columns in input file)  *
          *                                                *
          *************************************************/
 
extern int fix_length;

#define predefined_fix_length 72

extern int verbose_flag;

          /*************************************************
          *                                                *
          *  MACHINE-SIZES                                 *
          *                                                *
          *  - changes necessary for KSR1, CRAY, ...       *
          *                                                *
          *************************************************/
 
extern int default_int_size;
extern int default_real_size;
extern int default_addr_size;
extern int is_double_precision;
 
#define predefined_default_int_size  (sizeof(int))
#define predefined_default_real_size (sizeof(float))
#define predefined_default_addr_size (sizeof(int *))
 
          /*************************************************
          *                                                *
          *  TARGET LANGUAGE                               *
          *                                                *
          *************************************************/
 
extern int target_language;

          /*************************************************
          *                                                *
          *  ERROR Message                                 *
          *                                                *
          *************************************************/
 
extern char last_message [160];   /* last error/hints message  */
 
/* possible values for target_language */
 
#define FORTRAN_77 0
#define FORTRAN_V  1
#define FORTRAN_90 2
#define PG_FORTRAN 3    /* PGI fortran compiler  */
#define FORTRAN_95 4    /* F90 + forall          */

#define predefined_target_language       FORTRAN_77

