/*************************************************************************
*                                                                        *
*  Name : gmdhpfglobal.c                                                 *
*                                                                        *
*  Purpose : declaration of global data for gmdhpf (driver for ADAPTOR)  *
*                                                                        *
*  Author : Resi Hoever-Klier, GMD, SCAI.LAB                             *
*                                                                        *
*  Last Update : Nov.  1996                                              *
*                                                                        *
*************************************************************************/

#include "ratc.h"
#include "gmdhpfglobal.h"
#include <sys/param.h>


          /*************************************************
          *                                                *
          *  Version String                                *
          *                                                *
          *************************************************/

static char SccsID[] = "@(#)GMDHPF (1.0), Jan. 1997, Copyright R.H-K. GMD";

          /*************************************************
          *                                                *
          *  DRIVER  FLAGS                                 *
          *                                                *
          *************************************************/

char    ADPRC_FILES[3*(MAXPATHLEN+1)];      /* names of configuration files */

int     no_input_files;
char ** input_file_name;
char ** ld_input_file; 

int     no_generated_files;
int     file_factor;  /* how many filenames to be generated from 1 inputfile*/
char *  generated_file_names;

char    output_file_name[MAXPATHLEN];

int verbose_flag;
int dryrun_flag;              /* show commands and files but don't exec */
int keep_flag;                /* do not delete intermediate files (gmdhpf) */

int ld_flag;                  /* invoke linker or not */
int uniproc_flag;             /* generate single node program or not */

int list_flag;                /* generate listfile of fadapt messages */


          /*************************************************
          *                                                *
          *  TARGET MACHINE                                *
          *                                                *
          *************************************************/

/* possible target machines */

char *machine_items [] =
    { "CM-5           ",
      "Paragon XP/S   ",
      "Meiko CS 2     ",
      "KSR            ",
      "IBM SP         ",
      "Sun OS         ",
      "Sun Solaris 2.x",
      "Silicon Graphic",   
      "Intel iPSC/860 ",
      "HP UX          ",
      "ALPHA          ",
      "PowerPC        ",
      "Cenju-3        ",
      "Cray T3D       ",
      "Cray T3E       ",
      "Linux          ",
      "NEC SX/4       ",
      "Fujitsu VPP    ",
      "<new_machine>  "
    };

char *machine_options [] =
    { "-cm5",
      "-pgon",
      "-cs",
      "-ksr",
      "-rs6k",
      "-sun4",
      "-sun4sol2",
      "-sgi",   
      "-i860",
      "-hppa",
      "-alpha",
      "-ppc",
      "-cenju3",
      "-t3d",
      "-t3e",
      "-linux",
      "-sx4",
      "-vpp",
      "-new_machine"
    };

int no_machine = NO_MACHINES;

int target_machine;

          /*************************************************
          *                                                *
          *  COMMUNICATION MODEL                           *
          *                                                *
          *************************************************/

/* possible communication models */

char *communication_items [] =
    { "native     ",
      "MPI        ",
      "PVM 3.x    ",
      "Shared Mem.",
    };

char *communication_options [] =
    { "-native",
      "-mpi",
      "-pvm",
      "-shm",
    };

int no_communication = 4;

int target_communication;


          /*************************************************
          *                                                *
          *  PHOME Directory                               *
          *                                                *
          *************************************************/

char PHOME [160];          /* home directory of ADAPTOR */


          /*************************************************
          *                                                *
          *  Global Variables for the Customization        *
          *                                                *
          *************************************************/

char *environment [NO_MACHINES][13] =

 { CM5_env,
   PGON_env,
   CS_env,
   KSR_env,
   RS6K_env,
   SUN4_env,
   SUN4SOL2_env,
   SGI_env,
   I860_env,
   HPPA_env,
   ALPHA_env,
   PPC_env,
   CENJU3_env,
   CRAY_T3D_env,
   CRAY_T3E_env,
   LINUX_env,
   SX4_env,
   VPP_env,
   NEW_env
 };

char CPP[MAXPATHLEN];     /* cpp for adaptor */
char CPP_OPT[160+MAXPATHLEN];        /* cpp-options */

char FADAPT[MAXPATHLEN];    /* fadapt */
char FADAPT_OPT[160+MAXPATHLEN];        /* FADAPT-options */
char FADAPT_MP[MAXPATHLEN];        /* FADAPT-options */

char GENLIST[MAXPATHLEN];    /* genlist */

char FC[MAXPATHLEN];     /* FORTRAN-Compiler */
char FC_OPT[160+MAXPATHLEN];        /* fortran-compiler-options */
char FC_MP[160+MAXPATHLEN];        /* fortran-compiler-options */

char LD[MAXPATHLEN];     /* linker for cube-program */
char LD_OPT[160+MAXPATHLEN];      /* linker-flags */
char LD_MP[MAXPATHLEN];      /* linker-flags */

char LD1[MAXPATHLEN];    /* linker for single-node-program */
char LD1_OPT[160+MAXPATHLEN];     /* linker-flags */
char LD1_MP[MAXPATHLEN];     /* linker-flags */

int USER_DEFINED_DALIB_FLAG; /* dalib name defined in .adprc-file or not*/ 
char DALIB  [MAXPATHLEN];    /* home directory of ADAPTOR installation */
                             /* cont. .../dalib.a and .../unilib.a for */
                             /* choosen mess.pass.sys. (f.e PVM,MPI)   */
char MESS_PASS_LIB[MAXPATHLEN];    /* routines for choosen mes.pass.sys*/
char MPI_LIB[MAXPATHLEN];    /* routines for MPI */
char PVM_LIB[MAXPATHLEN];    /* routines for PVM */
char SHM_LIB[MAXPATHLEN];    /* routines for SHM */

int INITIALIZED_FLAG;        /* 1 if fadapt called by gmdhpf */
