/*************************************************************************
*                                                                        *
*  Name : labels.c                                                       *
*                                                                        *
*  Purpose : Data Structures for Label Tables                            *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, SCAI.LAB                            *
*                                                                        *
*  Date   : 15. 4. 1993                                                  *
*                                                                        *
*************************************************************************/

#include "labels.h"
#include "DynArray.h"
#include "Scanner.h"  /* MakeEndDos */

#undef DEBUG
#define LABEL_SIZE 25

static int  LabelCounter = 0;
static long LabelMax     = 0;

typedef struct
 { int name, used, defined, inDos ;
 } label_info;

static label_info *Labels;

     /***************************************************************
     *                                                              *
     *   nr    name   used    defined   inDos                       *
     *        --------------------------------                      *
     *    1    10      3        1       0                           *
     *    2    30      0        1       1                           *
     *    3    100     1        1       0      <- LabelCounter(=3)  *
     *                                                              *
     ***************************************************************/

void VerifyLabelArray ()
{ if (Labels == (label_info *) 0)
    { printf ("Could not extend Label array to size %d\n", LabelMax);
      printf ("Internal Error\n");
      exit (-1);
    }
}

void InitLabels ()

{ LabelCounter = 0;

  /* allocate memory for the first time */

  if (LabelMax == 0)
    { LabelMax = LABEL_SIZE;
      MakeArray ((char * *) &Labels, &LabelMax, (long) sizeof (label_info));
      VerifyLabelArray ();
    }

#ifdef DEBUG
      printf ("label array created, LabelMax = %d\n", LabelMax);
#endif

}

int SearchLabel (label)
int label;
{  int found, i;
   i = 0;
   found = 0;
   while ((i < LabelCounter) && (found == 0))
     { if (Labels[i].name == label)
          found = 1;
        else
          i++;
     }
   /* printf ("Search: Position of Label %d is %d\n",label,i); */
   return (i);
}

/*************************************************************************
*                                                                        *
*  NewLabel (name, used, defined, inDos)                                 *
*                                                                        *
*************************************************************************/

void NewLabel (name, used, defined, inDos)
int name, used, defined, inDos;

{ if (LabelCounter == LabelMax)
    { /* extend the label array from LabelMax to 2*LabelMax */
#ifdef DEBUG
      printf ("extend label array, LabelMax = %d\n", LabelMax);
#endif
      ExtendArray ((char **) &Labels, &LabelMax, (long) sizeof (label_info));
#ifdef DEBUG
      printf ("label array extended, LabelMax = %d\n", LabelMax);
#endif
      VerifyLabelArray ();
    }
  Labels[LabelCounter].name = name;
  Labels[LabelCounter].used = used;
  Labels[LabelCounter].defined = defined;
  Labels[LabelCounter].inDos = inDos;
  LabelCounter += 1;
}

/*************************************************************************
*                                                                        *
*   DO 15, I = 1, N   ->  will call 'LabelDo(15)'                        *
*                                                                        *
*************************************************************************/

void LabelDo (label)
int label;
{  int pos;
   /* printf ("%d will be a Do Label \n", label); */
   pos = SearchLabel (label);
   if (pos == LabelCounter) /* not found, define */
     NewLabel (label, 1, 0, 1);
    else
     { Labels[pos].used = 1;
       Labels[pos].inDos += 1;  }
}

/*************************************************************************
*                                                                        *
*   15  ....    ->  will call 'LabelDefine(15)'                          *
*                                                                        *
*************************************************************************/

void LabelDefine (label)
int label;
{ int pos;

  if (label == 0) return;   /* this label does not exist */

  pos = SearchLabel (label);
  /* printf ("Label %d will be defined \n", label); */
  if (pos < LabelCounter)  /* found */
   { if (Labels[pos].defined > 0)
       printf ("Label %d defined twice\n", label);
     MakeEndDos = Labels[pos].inDos;
     /* printf ("%d EndDos inserted\n", MakeEndDos);  */
   }
   else
     NewLabel (label, 0, 1, 0);
  /* return (pos+1);  */

} /* LabelDefine */
           
/*************************************************************************
*                                                                        *
*   GOTO 15     ->  will call 'LabelUse(15)'                             *
*                                                                        *
*************************************************************************/

void LabelUse (label)
int label;
{  int pos;
   pos = SearchLabel (label);
   /* printf ("Label %d is used\n", label); */
   if (pos < LabelCounter)  /* found */
    { Labels[pos].used = 1;
    }
    else
      NewLabel (label, 1, 0, 0);
  /* return (pos+1); */
} /* LabelUse */
