/*************************************************************************
*                                                                        *
*  Name : pred.h                                                         *
*  Purpose : Data Structures for Predicate Vectors and Predicates        *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, Z1.HR                               *
*  Date   : 3. 12. 1991                                                  *
*                                                                        *
*************************************************************************/

/* Data Structures :

   PredSimple, PredVector, Predicate

   Operations :

   PVSetFalse, PVSetExact, PVAndComponent, PVMakeForLoopNest,
   PVIsFalse, PVIsExact, PVGetDimension, PVGetComponent

   PMakeFalse, POrVector, PHoldConstant, PRestrict,
   PIsFalse, PGetLevel

   PSOut (Str, ps), PVOut (Str, *pv), POut (Str, *p)

*/


# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

#include <stdio.h>
#include <string.h>
#include "Tree.h"  /* MAX_DIMENSIONS */

#define MaxInt 20000     /* 2**31-1 */

#define MAX_VECTORS MAX_DIMENSIONS

typedef struct
  { int Low, High;
  } PredSimple;       /* corresponds [Low, High] */

  /* abbreviations:

     <   : stands for [ -maxint, -1 ]
     <=  : stands for [ -maxint, 0  ]
     >   : stands for [ 1, maxint ]
     >=  : stands for [ 0, maxint ]
     T   : stands for [ -maxint, maxint ]
     <=a : stands for [ -maxint, a ]
     >=a : stands for [ a, maxint ]
     'a' : stands for [ a, a ]

  */

typedef struct
  { int pv_dim ;                         /* dimension */
    int pv_exact;                        /* 1 if predicate is exact */
    PredSimple pv_arr[MAX_DIMENSIONS];
  } PredVector;

/*  p = (pv_arr[0], ..., pv_arr[pv_dim-1]),
    pv_exact = 1 if vector is exact
    pv_dim = 0  : p is equivalent to TRUE,
    pv_dim = -1 : p is equivalent to FALSE       */

typedef struct
  { int p_dim;
    PredVector p_arr[MAX_VECTORS];
  } Predicate;

/* p = p_arr[0] or p_arr[1] or ... or p_arr[p_dim-1]
   p_dim = 0  :  p is FALSE  (neutrales Element bzgl. or)   */

/**************************************************************************
*                                                                         *
*  Predicate Vectors                                                      *
*                                                                         *
**************************************************************************/

extern void PVMakeForLoopNest 
   ARGS((int N, int CommonL, int ConstL, PredVector *PV));

extern void PVAndComponent 
   ARGS((PredVector *PV, int k, int Low1, int High1));

extern void PVSetFalse ARGS((PredVector *PV));

extern void PVSetNotExact ARGS((PredVector *PV));

extern int PVIsFalse ARGS((PredVector *PV));

extern int PVIsZero ARGS((PredVector *PV));

extern int PVIsExact ARGS((PredVector *PV));

extern int PVGetDimension ARGS((PredVector *PV));

extern void PVGetComponent ARGS((PredVector *PV, int k, int *Low, int *High));

/*     General  Predicates                                               */

extern void PMakeFalse ARGS((Predicate *P));

extern void POrVector ARGS((Predicate *P, PredVector *PV));

extern void PHoldConstant ARGS((Predicate *P, int n));

extern void PRestrict ARGS((Predicate *P, int n));

extern int PIsFalse ARGS((Predicate *P));

extern int PGetLevel ARGS((Predicate *P));

/*  String Representation of Predicates and PredVectors  */

char * PSOut ARGS((char *Str, PredSimple ps));

char * PVOut ARGS((char *Str, PredVector *PV));

char * POut ARGS((char *Str, Predicate *P));
