# ifndef yyTypes
# define yyTypes

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definitions.h"

# line 55 "Types.puma"


# include <stdio.h>

   /***********************************************************
   *                                                          *
   *   type_rec  :  struct for description of a type          *
   *                                                          *
   ***********************************************************/

typedef struct

   { int    type_kind;
     int    type_size;

   } type_rec;

typedef type_rec *ptype;

extern void OutType ARGS((char *Str, type_rec t));



extern void (* Types_Exit) ();

extern tTree GetObjectType ARGS((tDefinitions obj));
extern tTree GetVariableType ARGS((tTree var));
extern int GetObjectSize ARGS((tDefinitions obj));
extern tTree TreeType ARGS((tTree var));
extern tTree GetBaseType ARGS((tTree t));
extern int TreeSize ARGS((tTree t));
extern tTree ArrayFormals ARGS((tDefinitions v));
extern bool IsDummyType ARGS((tTree t));
extern bool IsArrayType ARGS((tTree type));
extern bool IsStringType ARGS((tTree type));
extern bool IsPointerType ARGS((tTree type));
extern void GetExpType ARGS((tTree exp, type_rec * yyP1));
extern void GetParamType ARGS((tTree param, type_rec * yyP3));
extern void GetTypeRecord ARGS((tTree type, type_rec * yyP5));
extern tTree GetTypeZero ARGS((tTree texp));
extern bool IsSameExpType ARGS((tTree t1, tTree t2));
extern bool IsSameBaseType ARGS((tTree t1, tTree t2));
extern bool IsSubType ARGS((type_rec type1, type_rec type2));
extern bool SameTypeRecord ARGS((type_rec type1, type_rec type2));
extern void GetOp1Type ARGS((tTree op, type_rec type1, type_rec * yyP6));
extern void GetOp2Type ARGS((tTree op, type_rec t1, type_rec t2, type_rec * yyP7));
extern bool LegalAssignmentTypes ARGS((type_rec t1, type_rec t2));

extern void BeginTypes ();
extern void CloseTypes ();

# endif
