# ifndef yyTreeOps
# define yyTreeOps

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* TreeOps_Exit) ();

extern int TreeListLength ARGS((tTree t));
extern tTree TreeListGet ARGS((tTree list, int n));
extern tIdent TreeVarName ARGS((tTree var));
extern int IsVarInExp ARGS((tIdent name, tTree exp));
extern bool IsDeferredShape ARGS((tTree formals));
extern bool IsAssumedShape ARGS((tTree formals));
extern bool IsExplicitShape ARGS((tTree formals));
extern bool IsOverlappedShape ARGS((tTree t));
extern tIdent GetGenericId ARGS((tTree t));
extern tIdent MakeOperatorId ARGS((tTree t));
extern bool IsForallLoop ARGS((tTree loop));
extern bool IsIndepLoop ARGS((tTree loop));
extern bool IsIndepDoLoop ARGS((tTree loop));
extern int GetLayout ARGS((bool is_f77, int model));

extern void BeginTreeOps ();
extern void CloseTreeOps ();

# endif
