/*********************************************************************
*                                                                    *
*  Author      : Dr. Thomas Brandes, GMD, I1.LAB                     *
*  Date        : Mar 94                                              *
*  Last Update : Mar 94                                              *
*                                                                    *
*  Module      : SrcLines.h                                          *
*                                                                    *
*  Function    : Handling of Source Lines                            *
*                                                                    *
*********************************************************************/

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)       parameters
# else
# define ARGS(parameters)       ()
# endif

# include "stdio.h"
# include "global.h"

/*********************************************************************
*                                                                    *
*  Data Structures for exactly one source line                       *
*                                                                    *
*********************************************************************/

typedef struct {
     int counter;
     char content [MAX_LINE_LENGTH+1];
  } SourceLine;

/*********************************************************************
*                                                                    *
*  Reading in a buffer, the old line will also be used               *
*                                                                    *
*  inout:  FILE *f  for file of characters (with internal ptrs)      *
*  out  :  Buffer will be filled with characters                     *
*  in   :  Size specifies the maximal number of characters           *
*          that fits in the Buffer                                   *
*  inout:  LastLine is a line that has already been read and it      *
*          will contain new characters of f that are not in Buffer   *
*  out  :  NewLines specifies number of lines read in Buffer         *
*  out  :  specifies number of errors                                *
*                                                                    *
*    Result is number of characters filled in Buffer                 *
*                                                                    *
*********************************************************************/

extern int GetCompleteLine

  ARGS((FILE *f, char *Buffer, int Size, SourceLine *LastLine, int *NewLines));

extern bool LineError ();

extern char *LineErrorMsg ();

