# ifndef xySource
# define xySource

/**************************************************************************
*                                                                         *
*  List of File Names required for Error Messages                         *
*                                                                         *
**************************************************************************/

extern int SourceFileErrors;      /* global error counter */

extern int CurrentSourceLine ();

extern char *CurrentSourceName  ();

   /*  returns the name of the current file that is parsed */
   /*  Note: CurrentSourceName  is  GetSourceName (CurrentSourcePtr())   */

extern int CurrentSourcePtr ();

   /*  returns pointer to name of the current file that is parsed */

extern char *GetSourceName (/* int SourcePtr */);

   /*  returns name for arbitrary pointer *

/* code line and file ptr in one integer, 24 + 8 bit */

#define CodeLine(line)    ((CurrentSourcePtr() << 24) | line)
#define DecodeLine(line)  (line & ((1<<24)-1))
#define DecodeFile(line)  GetSourceName(line >> 24)

  /******************************************************
  *                                                     *
  *  GetPosition: For a position (line, col) the cor-   *
  *               responding absolut position is sought *
  *                                                     *
  ******************************************************/

extern int GetPosition (/* int line, int col */);


extern int	BeginSource	();

   /*
      int BeginSource (FileName)
	 char *	FileName;

      BeginSource is called from the scanner to open files.
      If not called input is read form standard input.
   */

extern int	GetLine		();

   /*
      int GetLine (File, Buffer, Size)
	 int		File;
	 char *		Buffer;
	 unsigned	Size;

      GetLine is called to fill a buffer starting at address 'Buffer'
      with a block of maximal 'Size' characters. Lines are terminated
      by newline characters (ASCII = 0xa). GetLine returns the number
      of characters transferred. Reasonable block sizes are between 128
      and 2048 or the length of a line. Smaller block sizes -
      especially block size 1 - will drastically slow down the scanner.
   */

extern void	CloseSource	();

   /*
      void CloseSource (File)
	 int		File;

      CloseSource is called from the scanner at end of file respectively
      at end of input. It can be used to close files.
   */

# endif
