# ifndef yyExpressions
# define yyExpressions

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* Expressions_Exit) ();

extern void GetIntConstValue ARGS((tTree exp, bool * found, int * val));
extern void GetConstDifference ARGS((tTree exp1, tTree exp2, bool * found, int * val));
extern tTree MakeNotExp ARGS((tTree e));
extern bool EqualExpression ARGS((tTree e1, tTree e2));
extern bool EqualIndexes ARGS((tTree indexes1, tTree indexes2));
extern tTree MakeConstant ARGS((int n));
extern tTree AddConstant ARGS((tTree exp, int c));
extern tTree MultConstant ARGS((tTree exp, int c));
extern tTree DivConstant ARGS((tTree exp, int c));
extern tTree MinusExpression ARGS((tTree exp));
extern tTree InverseExpression ARGS((tTree exp));
extern void ResolveExpression ARGS((tTree exp, bool * found, int * a, int * b, tTree * var));
extern void SliceIncrement ARGS((tTree exp, bool * yyP4, int * yyP3));
extern tTree MakeSliceExp ARGS((tTree start, tTree stop));
extern tTree MakeRangeExp ARGS((tTree start, tTree stop, tTree inc));
extern bool IsStride1 ARGS((tTree stride));

extern void BeginExpressions ();
extern void CloseExpressions ();

# endif
