# ifndef yyExpNormal
# define yyExpNormal

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definitions.h"

# line 29 "ExpNormal.puma"


#include "Nesting.h"          /* pointer to loop nest */
#include "Expressions.h"

#define MAXDIM 10

/*********************************************************************
*                                                                    * 
*    Normalization of an expression                                  *
*                                                                    *
*    For i, j:   I + 2*J - I + 3  ->  (3, 0, 2)                      *
*                                                                    *
*********************************************************************/

typedef struct
   { int vals[MAXDIM+1];
   } ExpNormRecord;

       /*****************************************************
       *                                                    *
       *  Exp = vals[1] * I1 + ... + vals[n] * In + vals[0] *
       *                                                    *
       *****************************************************/

void PrintNormRecord (/* char s[], ExpNormRecord e, tTree loops[], int n */);



extern void (* ExpNormal_Exit) ();

extern void ExpNormal ARGS((tTree e, ptree loops, int n, bool * yyP2, ExpNormRecord * yyP1));
extern bool ExpDifferent ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int ConstLoops));
extern void DiffUppBound ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, bool * yyP14, int * yyP13));
extern void DiffLowBound ARGS((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, bool * yyP16, int * yyP15));

extern void BeginExpNormal ();
extern void CloseExpNormal ();

# endif
