# ifndef yyDepGraph
# define yyDepGraph

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif


# ifndef bool
# define bool char
# endif
# define NoDepGraph (tDepGraph) 0L
# define kDepNode 1
# define kDepEdge 2

typedef unsigned char DepGraph_tKind;
typedef unsigned short DepGraph_tMark;
typedef unsigned short DepGraph_tLabel;
typedef union DepGraph_Node * tDepGraph;
typedef void (* DepGraph_tProcTree) ();
/* line 14 "fortran.dg" */


#include "pred.h"
#include "Sets.h"

/* Note : All Functions DepNode, DepEdge :
   mDepNode, mDepEdge, ...                   */

#define tDepNode tDepGraph
#define tDepEdge tDepGraph

#define DepNodeUse 0
#define DepNodeDef 1
#define DepNodeMod 2

#define MaxDepNode 500     /* only for one graph */
#define MaxDepEdge 1000    /* only for one graph */

typedef int DepNodeIndex;
      /* Index of a DepNode in a Graph : 1..MaxDepNode */

typedef int DepEdgeIndex;
      /* Index of a DepEdge in a Graph : 1..MaxDepEdge */

typedef tSet DepNodeSet;

void DepCreateGraph ( /* Tree N */ );

/* generates a new dependence graph for unit, identified by N
   dependence graph is opened                                  */

void DepCloseGraph ();

void DepDestroyGraph ( /* Tree N */ );

void DepOpenGraph (/* Tree N */);

/* Inserting Node or Edge in a opened dependence graph
   (at this time this must be the last created graph)    */

DepNodeIndex DepGraphNodeInsert ( /* tDepNode DN */);

DepEdgeIndex DepGraphEdgeInsert ( /* tDepEdge DE */);

tDepNode DepGraphGetNode ( /* dn : DepNodeIndex */ );
       /* the reverse to DepGraphNodeInsert */

tDepEdge DepGraphGetEdge ( /* DepEdgeIndex */ );
       /* the reverse to DepGraphEdgeInsert */

/* Queries for the nodes of a dependence graph */

void DepGraphAllNodes (/* int *count, DepNodeSet *Defs, *Uses */);
      /* all nodes of the opened dependence graph */

DepNodeIndex DepGraphSearchNode ( /* tTree access */ );
      /* searching with the ast for a variable access */

/* Queries for the edges of a dependence graph */

int DepGraphAllEdges ();
      /* returns number of edges in the openend dependence graph */

void DepGraphSearchEdge ( /* DepNodeIndex dn1, dn2; short *found;
                             DepEdgeIndex *de                     */ );
      /* searching edge (predicate) for given source and target */


# ifndef DepGraph_NodeHead
# define DepGraph_NodeHead
# endif
typedef struct { DepGraph_tKind yyKind; DepGraph_tMark yyMark; DepGraph_NodeHead } DepGraph_tNodeHead;
typedef struct { DepGraph_tNodeHead yyHead; tIdent Name; int NodeKind; tTree Access; tTree Stat; tTree OuterLoops; } yDepNode;
typedef struct { DepGraph_tNodeHead yyHead; int Source; int Target; Predicate Pred; } yDepEdge;

union DepGraph_Node {
 DepGraph_tKind Kind;
 DepGraph_tNodeHead yyHead;
 yDepNode DepNode;
 yDepEdge DepEdge;
};

extern tDepGraph DepGraphRoot;
extern unsigned long DepGraph_HeapUsed;
extern char * DepGraph_PoolFreePtr, * DepGraph_PoolMaxPtr;
extern unsigned short DepGraph_NodeSize [2 + 1];
extern char * DepGraph_NodeName [2 + 1];

extern void (* DepGraph_Exit) ();
extern tDepGraph DepGraph_Alloc ();
extern tDepGraph MakeDepGraph ARGS((DepGraph_tKind yyKind));
extern bool DepGraph_IsType ARGS((register tDepGraph yyt, register DepGraph_tKind yyKind));

extern tDepGraph mDepNode ARGS((tIdent pName, int pNodeKind, tTree pAccess, tTree pStat, tTree pOuterLoops));
extern tDepGraph mDepEdge ARGS((int pSource, int pTarget, Predicate pPred));

extern void BeginDepGraph ();
extern void CloseDepGraph ();

# endif
