# ifndef yyDefinitions
# define yyDefinitions

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif


# ifndef bool
# define bool char
# endif
# define NoDefinitions (tDefinitions) 0L
# define kScopes 1
# define kSCOPE_LIST 2
# define kSCOPE_EMPTY 3
# define kEntries 4
# define kENTRY_LIST 5
# define kENTRY_EMPTY 6
# define kObject 7
# define kVarObject 8
# define kTemplateObject 9
# define kRaggedObject 10
# define kTopologyObject 11
# define kTypeObject 12
# define kExternalObject 13
# define kProcObject 14
# define kFuncObject 15
# define kBlockObject 16
# define kModuleObject 17
# define kGenericObject 18
# define kCommonObject 19
# define kNameListObject 20
# define kVarUse 21
# define kDistribution 22
# define kDefaultDistribution 23
# define kReplicatedDistribution 24
# define kDeclDistribution 25
# define kNodeDistribution 26
# define kRangeDistribution 27
# define kAlignDistribution 28
# define kVarDescription 29
# define kVarDummy 30
# define kVarParameter 31
# define kVarLocal 32
# define kVarCommon 33
# define kDimList 34
# define kDIM_LIST 35
# define kDIM_EMPTY 36
# define kDimDescription 37
# define kSerialDimension 38
# define kDistributedDimension 39
# define kAlignedDimension 40
# define kMappedDimension 41
# define kReplicatedDimension 42
# define kEmbeddedDimension 43
# define kAlignDescription 44
# define kNoAlignment 45
# define kAlignment 46

typedef unsigned char Definitions_tKind;
typedef unsigned short Definitions_tMark;
typedef unsigned short Definitions_tLabel;
typedef union Definitions_Node * tDefinitions;
typedef void (* Definitions_tProcTree) ();
/* line 22 "definitions.cg" */


    /***********************************
    *  Some Constants used             *
    ************************************/

    /***********************************
    *   VarDummy (intent, _, _)        *
    ************************************/

#define IntentNo     0
#define IntentIn     1
#define IntentOut    2
#define IntentInOut  3

    /***********************************
    *   VarDummy (_, dyn, _)           *
    *   VarLocal (_, dyn, _)           *
    ***********************************/

# define arr_illegal      -1
# define arr_fixed_size    0
# define arr_automatic     1
# define arr_allocatable   2
# define arr_assumed_shape 3
# define arr_assumed_size  4

   /* values for the private attribute of objects */

    /***********************************
    *   Object (_, _, _, pkind)        *
    ***********************************/

# define Default 0
# define Public  1
# define Private 2

    /***********************************
    *   VarLocal (save, _, _)          *
    ***********************************/

# define IsSave    1

    /***********************************
    *   VarLocal (_, _, atts)          *
    ***********************************/

# define AttrTarget       1

    /***********************************
    *   CommonObject (..., sequence)   *
    ***********************************/

# define IsSequence   1
# define IsNoSequence 2 

   /* values for the kind of ProcObject, FuncObject */

    /*****************************************
    *   FuncObject     (_, _, _, _, kind, _) *
    *   ProcObject     (_, _, _, _, kind, _) *
    *   ExternalObject (_, _, _, _, kind, _) *
    *****************************************/

# define UserRoutine   0
# define DummyRoutine  1
# define ModuleRoutine 2

# define NoObject       NoDefinitions
# define NoEntries      NoDefinitions
# define NoDistribution NoDefinitions

# define tDistribution  tDefinitions  /* type for distributions            */
# define tObject        tDefinitions  /* type for object descriptors       */
# define tEntries       tDefinitions  /* type to represent sets of decls.  */
# define tScopes        tDefinitions  /* type to represent scopes          */

# include "Idents.h"
# include "Tree.h"
# include "global.h"     /* MAX_DIMENSIONS */

    /*****************************************
    *                                        *
    *  Arrays for distributed dimensions     *
    *                                        *
    *****************************************/

typedef struct {
     int no_dims;
     int DimsArray [MAX_DIMENSIONS];
     } DistributedDimensions;



# ifndef Definitions_NodeHead
# define Definitions_NodeHead
# endif
typedef struct { Definitions_tKind yyKind; Definitions_tMark yyMark; Definitions_NodeHead } Definitions_tNodeHead;
typedef struct { Definitions_tNodeHead yyHead; } yScopes;
typedef struct { Definitions_tNodeHead yyHead; tDefinitions Table; tDefinitions Hidden; } ySCOPE_LIST;
typedef struct { Definitions_tNodeHead yyHead; } ySCOPE_EMPTY;
typedef struct { Definitions_tNodeHead yyHead; } yEntries;
typedef struct { Definitions_tNodeHead yyHead; tDefinitions Elem; tDefinitions Next; } yENTRY_LIST;
typedef struct { Definitions_tNodeHead yyHead; } yENTRY_EMPTY;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; } yObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; tDefinitions Kind; bool trace; bool tree; int sequence; tTree select; tDefinitions uses; tDefinitions Dist; } yVarObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; tTree select; tDefinitions Dist; } yTemplateObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int depth; tDefinitions Levels; tDefinitions Dist; } yRaggedObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int rank; tTree target; int active; int defined; } yTopologyObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; tDefinitions Components; } yTypeObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int Kind; tDefinitions Declarations; } yExternalObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int Kind; tDefinitions Declarations; } yProcObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int Kind; tDefinitions Declarations; } yFuncObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int uses; tDefinitions Declarations; } yBlockObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; int uses; tDefinitions Declarations; } yModuleObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; tDefinitions Interfaces; } yGenericObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; tDefinitions CommonElements; int size; int main; int distributed_vars; int sequence; } yCommonObject;
typedef struct { Definitions_tNodeHead yyHead; tIdent Ident; tTree decl; int private; tObject in; } yNameListObject;
typedef struct { Definitions_tNodeHead yyHead; int ArrayUse; int ReadUse; int WriteUse; } yVarUse;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; } yDistribution;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; } yDefaultDistribution;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; } yReplicatedDistribution;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; tTree decl; } yDeclDistribution;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; tDefinitions top_obj; tDefinitions ArrayList; } yNodeDistribution;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; tDefinitions ArrayList; } yRangeDistribution;
typedef struct { Definitions_tNodeHead yyHead; int dynamic; int shared; int inherited; tDefinitions template_obj; tDefinitions TargetList; tDefinitions SourceList; } yAlignDistribution;
typedef struct { Definitions_tNodeHead yyHead; } yVarDescription;
typedef struct { Definitions_tNodeHead yyHead; int Intent; int dynamic; tTree function; bool optional; bool target; int layout; int pass_by; int map_to; } yVarDummy;
typedef struct { Definitions_tNodeHead yyHead; tTree Val; } yVarParameter;
typedef struct { Definitions_tNodeHead yyHead; int save; int dynamic; bool target; } yVarLocal;
typedef struct { Definitions_tNodeHead yyHead; tIdent Block; tDefinitions ref_obj; } yVarCommon;
typedef struct { Definitions_tNodeHead yyHead; } yDimList;
typedef struct { Definitions_tNodeHead yyHead; tDefinitions Elem; tDefinitions Next; } yDIM_LIST;
typedef struct { Definitions_tNodeHead yyHead; } yDIM_EMPTY;
typedef struct { Definitions_tNodeHead yyHead; int dimension; } yDimDescription;
typedef struct { Definitions_tNodeHead yyHead; int dimension; } ySerialDimension;
typedef struct { Definitions_tNodeHead yyHead; int dimension; int topology_dim; int kind; tTree size; tTree len; tTree map; } yDistributedDimension;
typedef struct { Definitions_tNodeHead yyHead; int dimension; int template_dim; tTree mult; tTree add; } yAlignedDimension;
typedef struct { Definitions_tNodeHead yyHead; int dimension; int template_dim; } yMappedDimension;
typedef struct { Definitions_tNodeHead yyHead; int dimension; } yReplicatedDimension;
typedef struct { Definitions_tNodeHead yyHead; int dimension; tTree val; } yEmbeddedDimension;
typedef struct { Definitions_tNodeHead yyHead; } yAlignDescription;
typedef struct { Definitions_tNodeHead yyHead; } yNoAlignment;
typedef struct { Definitions_tNodeHead yyHead; int mult; int add; } yAlignment;

union Definitions_Node {
 Definitions_tKind Kind;
 Definitions_tNodeHead yyHead;
 yScopes Scopes;
 ySCOPE_LIST SCOPE_LIST;
 ySCOPE_EMPTY SCOPE_EMPTY;
 yEntries Entries;
 yENTRY_LIST ENTRY_LIST;
 yENTRY_EMPTY ENTRY_EMPTY;
 yObject Object;
 yVarObject VarObject;
 yTemplateObject TemplateObject;
 yRaggedObject RaggedObject;
 yTopologyObject TopologyObject;
 yTypeObject TypeObject;
 yExternalObject ExternalObject;
 yProcObject ProcObject;
 yFuncObject FuncObject;
 yBlockObject BlockObject;
 yModuleObject ModuleObject;
 yGenericObject GenericObject;
 yCommonObject CommonObject;
 yNameListObject NameListObject;
 yVarUse VarUse;
 yDistribution Distribution;
 yDefaultDistribution DefaultDistribution;
 yReplicatedDistribution ReplicatedDistribution;
 yDeclDistribution DeclDistribution;
 yNodeDistribution NodeDistribution;
 yRangeDistribution RangeDistribution;
 yAlignDistribution AlignDistribution;
 yVarDescription VarDescription;
 yVarDummy VarDummy;
 yVarParameter VarParameter;
 yVarLocal VarLocal;
 yVarCommon VarCommon;
 yDimList DimList;
 yDIM_LIST DIM_LIST;
 yDIM_EMPTY DIM_EMPTY;
 yDimDescription DimDescription;
 ySerialDimension SerialDimension;
 yDistributedDimension DistributedDimension;
 yAlignedDimension AlignedDimension;
 yMappedDimension MappedDimension;
 yReplicatedDimension ReplicatedDimension;
 yEmbeddedDimension EmbeddedDimension;
 yAlignDescription AlignDescription;
 yNoAlignment NoAlignment;
 yAlignment Alignment;
};

extern tDefinitions DefinitionsRoot;
extern unsigned long Definitions_HeapUsed;
extern char * Definitions_PoolFreePtr, * Definitions_PoolMaxPtr;
extern unsigned short Definitions_NodeSize [46 + 1];
extern char * Definitions_NodeName [46 + 1];

extern void (* Definitions_Exit) ();
extern tDefinitions Definitions_Alloc ();
extern tDefinitions MakeDefinitions ARGS((Definitions_tKind yyKind));
extern bool Definitions_IsType ARGS((register tDefinitions yyt, register Definitions_tKind yyKind));

extern tDefinitions mScopes ARGS(());
extern tDefinitions mSCOPE_LIST ARGS((tDefinitions pTable, tDefinitions pHidden));
extern tDefinitions mSCOPE_EMPTY ARGS(());
extern tDefinitions mEntries ARGS(());
extern tDefinitions mENTRY_LIST ARGS((tDefinitions pElem, tDefinitions pNext));
extern tDefinitions mENTRY_EMPTY ARGS(());
extern tDefinitions mObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin));
extern tDefinitions mVarObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, tDefinitions pKind, bool ptrace, bool ptree, int psequence, tTree pselect, tDefinitions puses, tDefinitions pDist));
extern tDefinitions mTemplateObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, tTree pselect, tDefinitions pDist));
extern tDefinitions mRaggedObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int pdepth, tDefinitions pLevels, tDefinitions pDist));
extern tDefinitions mTopologyObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int prank, tTree ptarget, int pactive, int pdefined));
extern tDefinitions mTypeObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, tDefinitions pComponents));
extern tDefinitions mExternalObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int pKind, tDefinitions pDeclarations));
extern tDefinitions mProcObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int pKind, tDefinitions pDeclarations));
extern tDefinitions mFuncObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int pKind, tDefinitions pDeclarations));
extern tDefinitions mBlockObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int puses, tDefinitions pDeclarations));
extern tDefinitions mModuleObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, int puses, tDefinitions pDeclarations));
extern tDefinitions mGenericObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, tDefinitions pInterfaces));
extern tDefinitions mCommonObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin, tDefinitions pCommonElements, int psize, int pmain, int pdistributed_vars, int psequence));
extern tDefinitions mNameListObject ARGS((tIdent pIdent, tTree pdecl, int pprivate, tObject pin));
extern tDefinitions mVarUse ARGS((int pArrayUse, int pReadUse, int pWriteUse));
extern tDefinitions mDistribution ARGS((int pdynamic, int pshared, int pinherited));
extern tDefinitions mDefaultDistribution ARGS((int pdynamic, int pshared, int pinherited));
extern tDefinitions mReplicatedDistribution ARGS((int pdynamic, int pshared, int pinherited));
extern tDefinitions mDeclDistribution ARGS((int pdynamic, int pshared, int pinherited, tTree pdecl));
extern tDefinitions mNodeDistribution ARGS((int pdynamic, int pshared, int pinherited, tDefinitions ptop_obj, tDefinitions pArrayList));
extern tDefinitions mRangeDistribution ARGS((int pdynamic, int pshared, int pinherited, tDefinitions pArrayList));
extern tDefinitions mAlignDistribution ARGS((int pdynamic, int pshared, int pinherited, tDefinitions ptemplate_obj, tDefinitions pTargetList, tDefinitions pSourceList));
extern tDefinitions mVarDescription ARGS(());
extern tDefinitions mVarDummy ARGS((int pIntent, int pdynamic, tTree pfunction, bool poptional, bool ptarget, int playout, int ppass_by, int pmap_to));
extern tDefinitions mVarParameter ARGS((tTree pVal));
extern tDefinitions mVarLocal ARGS((int psave, int pdynamic, bool ptarget));
extern tDefinitions mVarCommon ARGS((tIdent pBlock, tDefinitions pref_obj));
extern tDefinitions mDimList ARGS(());
extern tDefinitions mDIM_LIST ARGS((tDefinitions pElem, tDefinitions pNext));
extern tDefinitions mDIM_EMPTY ARGS(());
extern tDefinitions mDimDescription ARGS((int pdimension));
extern tDefinitions mSerialDimension ARGS((int pdimension));
extern tDefinitions mDistributedDimension ARGS((int pdimension, int ptopology_dim, int pkind, tTree psize, tTree plen, tTree pmap));
extern tDefinitions mAlignedDimension ARGS((int pdimension, int ptemplate_dim, tTree pmult, tTree padd));
extern tDefinitions mMappedDimension ARGS((int pdimension, int ptemplate_dim));
extern tDefinitions mReplicatedDimension ARGS((int pdimension));
extern tDefinitions mEmbeddedDimension ARGS((int pdimension, tTree pval));
extern tDefinitions mAlignDescription ARGS(());
extern tDefinitions mNoAlignment ARGS(());
extern tDefinitions mAlignment ARGS((int pmult, int padd));

extern void BeginDefinitions ();
extern void CloseDefinitions ();

# endif
