# ifndef yyDefTable
# define yyDefTable

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* DefTable_Exit) ();

extern void NewScope ARGS(());
extern void OpenScope ARGS((tDefinitions Scope));
extern void CloseScope ARGS(());
extern tDefinitions GetCurrentScope ARGS(());
extern tDefinitions GetExternalEntries ARGS(());
extern tDefinitions GetIntrinsicEntries ARGS(());
extern tDefinitions GetUnitEntries ARGS(());
extern tDefinitions GetCommonEntries ARGS(());
extern void InsertUnitEntry ARGS((tDefinitions Obj));
extern void InsertExternalEntry ARGS((tDefinitions Obj));
extern void InsertCommonEntry ARGS((tDefinitions Obj));
extern void InsertEntry ARGS((tDefinitions Obj));
extern void ChangeEntry ARGS((tIdent Name, tDefinitions Obj));
extern tDefinitions GetDeclEntry ARGS((tIdent Ident, tDefinitions Decls));
extern tDefinitions GetLocalObject ARGS((tIdent Ident));
extern tDefinitions GetGlobalObject ARGS((tIdent Ident));
extern tDefinitions GetIntrinsicObject ARGS((tIdent Ident));
extern tDefinitions GetHPFLibrary ARGS(());
extern tDefinitions GetHPFLocalLibrary ARGS(());
extern tDefinitions GetHPFTaskLibrary ARGS(());
extern tDefinitions GetDefaultTopology ARGS((int rank));
extern tDefinitions RemoveHostAssociation ARGS(());
extern void ResetHostAssociation ARGS((tDefinitions HostAssociation));

extern void BeginDefTable ();
extern void CloseDefTable ();

# endif
