# ifndef yyChangeDefs
# define yyChangeDefs

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* ChangeDefs_Exit) ();

extern tDefinitions GetLocalVarEntity ARGS((tIdent name, int pos, tDefinitions unit));
extern void MakeObjType ARGS((tTree type, tDefinitions obj));
extern void MakeObjDimension ARGS((tTree indexes, tDefinitions obj));
extern void MakeObjParameter ARGS((tTree val, tDefinitions obj));
extern void MakeObjSave ARGS((tDefinitions v));
extern void MakeObjExternal ARGS((tDefinitions oldobj));
extern void MakeObjOptional ARGS((tDefinitions obj));
extern void MakeObjIntent ARGS((tDefinitions obj, int intent));
extern void MakeObjPublic ARGS((tDefinitions obj));
extern void MakeObjPrivate ARGS((tDefinitions obj));
extern void MakeObjAllocatable ARGS((tDefinitions obj));
extern void MakeObjPointer ARGS((tDefinitions obj));
extern void MakeObjTarget ARGS((tDefinitions obj));
extern void MakeObjCommon ARGS((tTree decl, tDefinitions obj));
extern void MakeObjSequential ARGS((tDefinitions v));
extern void MakeObjNoSequential ARGS((tDefinitions v));
extern void MakeObjShared ARGS((tDefinitions obj, int kind));
extern void MakeObjDynamic ARGS((tDefinitions obj));
extern void MakeObjTrace ARGS((tDefinitions obj));
extern void MakeObjTree ARGS((tDefinitions obj));
extern void MakeObjSelection ARGS((tDefinitions obj, tTree selection));
extern void MakeObjInherited ARGS((tDefinitions obj));
extern void MakeObjLayout ARGS((tStringRef kind, tDefinitions obj));
extern void MakeObjMapTo ARGS((tStringRef kind, tDefinitions obj));
extern void MakeObjPassBy ARGS((tStringRef kind, tDefinitions obj));
extern void MakeObjActive ARGS((tDefinitions obj));
extern tDefinitions GetFuncObject ARGS((tIdent name, tDefinitions unit));
extern tDefinitions GetProcObject ARGS((tIdent name, tDefinitions unit));
extern void SetExternalEntry ARGS((tDefinitions obj));

extern void BeginChangeDefs ();
extern void CloseChangeDefs ();

# endif
