# ifndef yyCallGraph
# define yyCallGraph

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif


# ifndef bool
# define bool char
# endif
# define NoCallGraph (tCallGraph) 0L
# define kCallGraph 1
# define kCallNode 2
# define kCallNodeList 3
# define kCallEdgeList 4

typedef unsigned char CallGraph_tKind;
typedef unsigned short CallGraph_tMark;
typedef unsigned short CallGraph_tLabel;
typedef union CallGraph_Node * tCallGraph;
typedef void (* CallGraph_tProcTree) ();
/* line 34 "fortran.call" */


#include "Tree.h"
#include "Definitions.h"

#define tCallNode tCallGraph;



# ifndef CallGraph_NodeHead
# define CallGraph_NodeHead
# endif
typedef struct { CallGraph_tKind yyKind; CallGraph_tMark yyMark; CallGraph_NodeHead } CallGraph_tNodeHead;
typedef struct { CallGraph_tNodeHead yyHead; tCallGraph UserNodes; tCallGraph IntrinsicNodes; tCallGraph ExternalNodes; } yCallGraph;
typedef struct { CallGraph_tNodeHead yyHead; tObject val; int unitkind; tCallGraph calling; tCallGraph called_by; } yCallNode;
typedef struct { CallGraph_tNodeHead yyHead; tCallGraph Elem; tCallGraph Next; } yCallNodeList;
typedef struct { CallGraph_tNodeHead yyHead; tCallGraph Node; int count; tCallGraph Next; } yCallEdgeList;

union CallGraph_Node {
 CallGraph_tKind Kind;
 CallGraph_tNodeHead yyHead;
 yCallGraph CallGraph;
 yCallNode CallNode;
 yCallNodeList CallNodeList;
 yCallEdgeList CallEdgeList;
};

extern tCallGraph CallGraphRoot;
extern unsigned long CallGraph_HeapUsed;
extern char * CallGraph_PoolFreePtr, * CallGraph_PoolMaxPtr;
extern unsigned short CallGraph_NodeSize [4 + 1];
extern char * CallGraph_NodeName [4 + 1];

extern void (* CallGraph_Exit) ();
extern tCallGraph CallGraph_Alloc ();
extern tCallGraph MakeCallGraph ARGS((CallGraph_tKind yyKind));
extern bool CallGraph_IsType ARGS((register tCallGraph yyt, register CallGraph_tKind yyKind));

extern tCallGraph mCallGraph ARGS((tCallGraph pUserNodes, tCallGraph pIntrinsicNodes, tCallGraph pExternalNodes));
extern tCallGraph mCallNode ARGS((tObject pval, int punitkind, tCallGraph pcalling, tCallGraph pcalled_by));
extern tCallGraph mCallNodeList ARGS((tCallGraph pElem, tCallGraph pNext));
extern tCallGraph mCallEdgeList ARGS((tCallGraph pNode, int pcount, tCallGraph pNext));

extern void WriteCallGraphNode ARGS((FILE * yyyf, tCallGraph yyt));
extern void WriteCallGraph ARGS((FILE * yyyf, tCallGraph yyt));
extern bool CheckCallGraph ARGS((tCallGraph yyt));
extern void BeginCallGraph ();
extern void CloseCallGraph ();

# endif
