# include "VectorMove.h"
# include "yyVectorMove.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 39 "VectorMove.puma"


# define MODULE "VectorMove"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "TreeOps.h"
# include "Rank.h"
# include "Shapes.h"
# include "Expressions.h"

# include "Invariant.h"     /* IsVarInExp, Resolve.., MakeVector */
# include "permutations.h"  /* handling for permuted expressions */

# undef DEBUG



static void yyExit () { Exit (1); }

void (* VectorMove_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VectorMove, routine %s failed\n", yyFunction);
 VectorMove_Exit ();
}

tTree VectorizeMovement ARGS((tTree t));
static void MakeVectorMovement ARGS((tTree body, tTree id, tTree slice, bool * yyP1));
static void ArrayVectorization ARGS((tTree id, tTree slice, tTree var1, tTree var2, Permutation perm, bool * done, Permutation * new_perm));
void FindLoopVar ARGS((tTree var, tTree id, bool * yyP4, int * yyP3, int * yyP2));
static void FindLoopVarInIndexes ARGS((tTree var, tTree id, bool * yyP7, int * yyP6, int * yyP5));
static void FindLoopVarIndex ARGS((tTree exp, tTree id, bool * yyP9, int * yyP8));
static void Substitute ARGS((tTree var, tTree id, int val, tTree slice));
void VectorizeVar ARGS((tTree var, tTree id, tTree slice));
static void VectorizeIndexes ARGS((tTree indexes, tTree id, tTree slice));
static tTree VectorizeExp ARGS((tTree elem, tTree id, tTree slice));
static void TryVectorization ARGS((tTree stmt, tTree id, tTree slice, bool * yyP10));
static bool ScatterCommonIdPosition ARGS((tTree stmt, tTree id));
static void ScatterSubstitute ARGS((tTree t, tTree id, tTree slice));
static void FindParamIdPosition ARGS((tTree t, tTree id, bool * yyP12, int * yyP11));
static void FindVarIdPosition ARGS((tTree t, tTree id, bool * yyP14, int * yyP13));
static void MergeResults ARGS((bool legal1, int pos1, bool legal2, int pos2, bool * yyP16, int * yyP15));
void MakeVectorVar ARGS((tTree var, tTree id, tTree slice, int * yyP17));

tTree VectorizeMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 84 "VectorMove.puma"
 {
  tTree result;
  bool done;
  {
# line 86 "VectorMove.puma"

# line 86 "VectorMove.puma"

# line 88 "VectorMove.puma"
 

     t->ACF_FORALL.FORALL_BODY = VectorizeMovement (t->ACF_FORALL.FORALL_BODY);

#ifdef DEBUG
     printf ("VectorizeMovement: body is \n");
     FileUnparse (stdout, t->ACF_FORALL.FORALL_BODY);
#endif

     

     MakeVectorMovement (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_ID, t->ACF_FORALL.FORALL_RANGE, &done);

#ifdef DEBUG
     if (done)
       printf ("VectorizeMovement: vectorization has been done \n");
     else
       printf ("VectorizeMovement: vectorization has not been done \n");
     FileUnparse (stdout, t->ACF_FORALL.FORALL_BODY);
#endif

     if (done)  
        result = t->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem;
      else
        { t->Kind = kACF_DO;      
          t->ACF_FORALL.FORALL_DEP_INFO = mSERIAL_INFO ();
          result = t;
        }

     tree_protocol ("movement has been vectorized to :\n", t);

   
  }
  {
   return result;
  }
 }

  }
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 123 "VectorMove.puma"
  {
# line 125 "VectorMove.puma"
 t->ACF_LIST.Elem = VectorizeMovement (t->ACF_LIST.Elem); 
  }
   return t;

  }
# line 129 "VectorMove.puma"
  {
# line 131 "VectorMove.puma"
   error_protocol ("Only one assignment in FORALL for VectorizeMovement");
  }
   return t;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kSCATTER_STMT) {
# line 135 "VectorMove.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
# line 139 "VectorMove.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 143 "VectorMove.puma"
   return t;

  }
  }
  }
  if (t->Kind == kACF_IF) {
# line 147 "VectorMove.puma"
   return t;

  }
# line 151 "VectorMove.puma"
  {
# line 152 "VectorMove.puma"
   failure_protocol (MODULE, "VectorizeMovement", t);
  }
   return t;

}

static void MakeVectorMovement
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree id, register tTree slice, register bool * yyP1)
# else
(body, id, slice, yyP1)
 register tTree body;
 register tTree id;
 register tTree slice;
 register bool * yyP1;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 172 "VectorMove.puma"
 {
  bool yyV1;
  {
# line 174 "VectorMove.puma"
   MakeVectorMovement (body->ACF_LIST.Elem, id, slice, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  }
  if (body->Kind == kACF_FORALL) {
  if (body->ACF_FORALL.FORALL_ID->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
# line 177 "VectorMove.puma"
 {
  bool yyV1;
  {
# line 184 "VectorMove.puma"
   if (! ((IsVarInExp (id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, body->ACF_FORALL.FORALL_RANGE) == 0))) goto yyL2;
  {
# line 188 "VectorMove.puma"
   MakeVectorMovement (body->ACF_FORALL.FORALL_BODY, id, slice, & yyV1);
  }
  }
   * yyP1 = yyV1;
   return;
 }
yyL2:;

  }
  }
  }
  if (body->Kind == kACF_BASIC) {
  if (body->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
  if (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE->Kind == kPERM_VAR) {
  if (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK->Kind == kNO_PARAM) {
# line 191 "VectorMove.puma"
 {
  bool yyV1;
  Permutation yyV2;
  {
# line 194 "VectorMove.puma"
   if (! ((TreeRank (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET) == TreeRank (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE->PERM_VAR.VAL)))) goto yyL3;
  {
# line 196 "VectorMove.puma"
   ArrayVectorization (id, slice, body->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET, body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE->PERM_VAR.VAL, body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE->PERM_VAR.perm, & yyV1, & yyV2);
# line 198 "VectorMove.puma"
   if (! ((yyV1 == true))) goto yyL3;
  {
# line 202 "VectorMove.puma"
 body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE->PERM_VAR.perm = yyV2; 
  }
  }
  }
   * yyP1 = yyV1;
   return;
 }
yyL3:;

  }
# line 205 "VectorMove.puma"
   * yyP1 = false;
   return;

  }
  if (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK->Kind == kNO_PARAM) {
# line 208 "VectorMove.puma"
 {
  bool yyV1;
  Permutation yyV2;
  {
# line 210 "VectorMove.puma"
   if (! ((TreeRank (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET) == TreeRank (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE)))) goto yyL5;
  {
# line 212 "VectorMove.puma"
   ArrayVectorization (id, slice, body->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET, body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE, make_id_permutation (TreeRank (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET)), & yyV1, & yyV2);
# line 215 "VectorMove.puma"
   if (! ((yyV1 == true))) goto yyL5;
  {
# line 219 "VectorMove.puma"
 if (!is_id_permutation (yyV2))
        body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE = mPERM_VAR (body->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE, yyV2);
   
  }
  }
  }
   * yyP1 = yyV1;
   return;
 }
yyL5:;

  }
# line 232 "VectorMove.puma"
 {
  bool yyV1;
  {
# line 234 "VectorMove.puma"
   TryVectorization (body->ACF_BASIC.BASIC_STMT, id, slice, & yyV1);
# line 235 "VectorMove.puma"
   if (! ((yyV1))) goto yyL7;
  }
   * yyP1 = yyV1;
   return;
 }
yyL7:;

  }
  if (body->ACF_BASIC.BASIC_STMT->Kind == kSCATTER_STMT) {
# line 226 "VectorMove.puma"
 {
  bool yyV1;
  {
# line 228 "VectorMove.puma"
   TryVectorization (body->ACF_BASIC.BASIC_STMT, id, slice, & yyV1);
# line 229 "VectorMove.puma"
   if (! ((yyV1))) goto yyL6;
  }
   * yyP1 = yyV1;
   return;
 }
yyL6:;

  }
  }
# line 238 "VectorMove.puma"
   * yyP1 = false;
   return;

;
}

static void ArrayVectorization
# if defined __STDC__ | defined __cplusplus
(register tTree id, register tTree slice, register tTree var1, register tTree var2, Permutation perm, register bool * done, Permutation * new_perm)
# else
(id, slice, var1, var2, perm, done, new_perm)
 register tTree id;
 register tTree slice;
 register tTree var1;
 register tTree var2;
 Permutation perm;
 register bool * done;
 Permutation * new_perm;
# endif
{
# line 257 "VectorMove.puma"
 {
  Permutation nperm;
  bool yyV1;
  int yyV2;
  int yyV3;
  bool yyV4;
  int yyV5;
  int yyV6;
  {
# line 259 "VectorMove.puma"

# line 261 "VectorMove.puma"
   FindLoopVar (var1, id, & yyV1, & yyV2, & yyV3);
# line 262 "VectorMove.puma"
   FindLoopVar (var2, id, & yyV4, & yyV5, & yyV6);
# line 264 "VectorMove.puma"
   if (! ((yyV1 && yyV4))) goto yyL1;
  {
# line 265 "VectorMove.puma"
   if (! (((yyV3 != 0) && (yyV6 != 0)))) goto yyL1;
  {
# line 267 "VectorMove.puma"
 

#ifdef DEBUG
     printf ("Left val = %d, right val = %d\n", yyV3, yyV6);
     printf ("Variable is "); FileUnparse (stdout, id); printf ("\n");
     printf ("Slice is    "); FileUnparse (stdout, slice); printf ("\n");
#endif
     Substitute (var1, id, yyV3, slice);
     Substitute (var2, id, yyV6, slice);

     

     nperm = extend_permutation (perm, yyV5+1, yyV2+1);

#ifdef DEBUG
     printf ("new permutation : \n");
     print_permutation (nperm);
#endif

   
  }
  }
  }
   * done = true;
   * new_perm = nperm;
   return;
 }
yyL1:;

# line 294 "VectorMove.puma"
   * done = false;
   * new_perm = perm;
   return;

;
}

void FindLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id, register bool * yyP4, register int * yyP3, register int * yyP2)
# else
(var, id, yyP4, yyP3, yyP2)
 register tTree var;
 register tTree id;
 register bool * yyP4;
 register int * yyP3;
 register int * yyP2;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 313 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 315 "VectorMove.puma"
   FindLoopVarInIndexes (var->INDEXED_VAR.IND_EXPS, id, & yyV1, & yyV2, & yyV3);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   * yyP2 = yyV3;
   return;
 }

  }
# line 318 "VectorMove.puma"
  {
# line 319 "VectorMove.puma"
   failure_protocol ("VectorMove", "FindLoopVar", var);
  }
   * yyP4 = false;
   * yyP3 = 0;
   * yyP2 = 0;
   return;

;
}

static void FindLoopVarInIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id, register bool * yyP7, register int * yyP6, register int * yyP5)
# else
(var, id, yyP7, yyP6, yyP5)
 register tTree var;
 register tTree id;
 register bool * yyP7;
 register int * yyP6;
 register int * yyP5;
# endif
{
  if (var->Kind == kBTE_LIST) {
  if (var->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (id->Kind == kLOOP_VAR) {
# line 324 "VectorMove.puma"
  {
# line 326 "VectorMove.puma"
   if (! ((IsVarInExp (id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, var->BTE_LIST.Elem) > 0))) goto yyL1;
  }
   * yyP7 = false;
   * yyP6 = 0;
   * yyP5 = 0;
   return;
yyL1:;

  }
# line 329 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 331 "VectorMove.puma"
   FindLoopVarInIndexes (var->BTE_LIST.Next, id, & yyV1, & yyV2, & yyV3);
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2 + 1;
   * yyP5 = yyV3;
   return;
 }

  }
# line 334 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  bool yyV4;
  int yyV5;
  {
# line 336 "VectorMove.puma"
   FindLoopVarInIndexes (var->BTE_LIST.Next, id, & yyV1, & yyV2, & yyV3);
# line 337 "VectorMove.puma"
   FindLoopVarIndex (var->BTE_LIST.Elem, id, & yyV4, & yyV5);
# line 339 "VectorMove.puma"
 yyV1 = yyV1 && yyV4;
 
     if (yyV1)

        { if (yyV3 == 0)

             { 

               yyV3     = yyV5; 
               yyV2 = 0;

             }

           else if (yyV5 == 0)

             { 

             }

           else

               yyV1 = false;    

        }
   
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   * yyP5 = yyV3;
   return;
 }

  }
  if (var->Kind == kBTE_EMPTY) {
# line 366 "VectorMove.puma"
   * yyP7 = true;
   * yyP6 = 0;
   * yyP5 = 0;
   return;

  }
;
}

static void FindLoopVarIndex
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register bool * yyP9, register int * yyP8)
# else
(exp, id, yyP9, yyP8)
 register tTree exp;
 register tTree id;
 register bool * yyP9;
 register int * yyP8;
# endif
{
# line 371 "VectorMove.puma"
 {
  bool found;
  int val;
  {
# line 373 "VectorMove.puma"

# line 374 "VectorMove.puma"

# line 376 "VectorMove.puma"
   ResolveLoopVar (exp, id, & found, & val);
  }
   * yyP9 = found;
   * yyP8 = val;
   return;
 }

;
}

static void Substitute
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id, register int val, register tTree slice)
# else
(var, id, val, slice)
 register tTree var;
 register tTree id;
 register int val;
 register tTree slice;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 392 "VectorMove.puma"
  {
# line 393 "VectorMove.puma"
   Substitute (var->INDEXED_VAR.IND_EXPS, id, val, slice);
  }
   return;

  }
  if (var->Kind == kBTE_LIST) {
  if (id->Kind == kLOOP_VAR) {
  if (slice->Kind == kSLICE_EXP) {
# line 396 "VectorMove.puma"
 {
  int m;
  tTree nstart;
  tTree nstop;
  tTree ninc;
  {
# line 399 "VectorMove.puma"

# line 401 "VectorMove.puma"
   m = IsVarInExp (id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, var->BTE_LIST.Elem);
# line 403 "VectorMove.puma"

#ifdef DEBUG
     printf ("Substitute in Index, index = "); FileUnparse (stdout, var->BTE_LIST.Elem); 
     printf ("\n");
     printf ("val = %d, slice = ", val); 
     FileUnparse (stdout, slice); printf ("\n");
     printf ("Index "); FileUnparse (stdout, id); printf (" appears %d\n", m);
#endif
   
# line 413 "VectorMove.puma"
   if (! (m > 0)) goto yyL2;
  {
# line 415 "VectorMove.puma"

# line 415 "VectorMove.puma"

# line 415 "VectorMove.puma"

# line 417 "VectorMove.puma"
 MakeVector (var->BTE_LIST.Elem, id, val, slice, &nstart, &nstop, &ninc);
     var->BTE_LIST.Elem   = mSLICE_EXP (nstart, nstop, ninc);
   
  }
  }
   return;
 }
yyL2:;

  }
  }
# line 422 "VectorMove.puma"
  {
# line 423 "VectorMove.puma"
   Substitute (var->BTE_LIST.Next, id, val, slice);
  }
   return;

  }
  if (var->Kind == kBTE_EMPTY) {
# line 426 "VectorMove.puma"
  {
# line 427 "VectorMove.puma"
   failure_protocol (MODULE, "Substitute", var);
  }
   return;

  }
;
}

void VectorizeVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id, register tTree slice)
# else
(var, id, slice)
 register tTree var;
 register tTree id;
 register tTree slice;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 441 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 443 "VectorMove.puma"
   FindLoopVar (var, id, & yyV1, & yyV2, & yyV3);
# line 444 "VectorMove.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 446 "VectorMove.puma"
 if (yyV3 != 0)
        Substitute (var, id, yyV3, slice);
   
  }
  }
   return;
 }
yyL1:;

# line 451 "VectorMove.puma"
  {
# line 453 "VectorMove.puma"
   VectorizeIndexes (var->INDEXED_VAR.IND_EXPS, id, slice);
# line 454 "VectorMove.puma"
   MakeFullShape (var);
  }
   return;

  }
;
}

static void VectorizeIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tTree id, register tTree slice)
# else
(indexes, id, slice)
 register tTree indexes;
 register tTree id;
 register tTree slice;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
# line 459 "VectorMove.puma"
  {
# line 460 "VectorMove.puma"
 indexes->BTE_LIST.Elem = VectorizeExp (indexes->BTE_LIST.Elem, id, slice); 
# line 461 "VectorMove.puma"
   VectorizeIndexes (indexes->BTE_LIST.Next, id, slice);
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 464 "VectorMove.puma"
   return;

  }
;
}

static tTree VectorizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree elem, register tTree id, register tTree slice)
# else
(elem, id, slice)
 register tTree elem;
 register tTree id;
 register tTree slice;
# endif
{
# line 469 "VectorMove.puma"
 {
  bool found;
  int val;
  tTree nstart;
  tTree nstop;
  tTree ninc;
  {
# line 471 "VectorMove.puma"

# line 472 "VectorMove.puma"

# line 474 "VectorMove.puma"
   ResolveLoopVar (elem, id, & found, & val);
# line 475 "VectorMove.puma"
   if (! ((found))) goto yyL1;
  {
# line 476 "VectorMove.puma"
   if (! ((val != 0))) goto yyL1;
  {
# line 478 "VectorMove.puma"

# line 478 "VectorMove.puma"

# line 478 "VectorMove.puma"

# line 480 "VectorMove.puma"
   MakeVector (elem, id, val, slice, & nstart, & nstop, & ninc);
  }
  }
  }
  {
   return mSLICE_EXP (nstart, nstop, ninc);
  }
 }
yyL1:;

# line 485 "VectorMove.puma"
  {
# line 486 "VectorMove.puma"
   if (! ((IsVarInExp (TreeVarName (id), elem)))) goto yyL2;
  }
   return mSLICE_EXP (mDUMMY_EXP (), mDUMMY_EXP (), mDUMMY_EXP ());
yyL2:;

# line 490 "VectorMove.puma"
   return elem;

}

static void TryVectorization
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree id, register tTree slice, register bool * yyP10)
# else
(stmt, id, slice, yyP10)
 register tTree stmt;
 register tTree id;
 register tTree slice;
 register bool * yyP10;
# endif
{
  if (stmt->Kind == kSCATTER_STMT) {
# line 506 "VectorMove.puma"
  {
# line 508 "VectorMove.puma"
   if (! ((ScatterCommonIdPosition (stmt, id)))) goto yyL1;
  {
# line 510 "VectorMove.puma"
   ScatterSubstitute (stmt->SCATTER_STMT.ARRAY, id, slice);
# line 511 "VectorMove.puma"
   ScatterSubstitute (stmt->SCATTER_STMT.INDEXES, id, slice);
# line 512 "VectorMove.puma"
   ScatterSubstitute (stmt->SCATTER_STMT.MASK, id, slice);
  }
  }
   * yyP10 = true;
   return;
yyL1:;

# line 515 "VectorMove.puma"
   * yyP10 = false;
   return;

  }
  if (stmt->Kind == kMOVE_STMT) {
# line 518 "VectorMove.puma"
   * yyP10 = false;
   return;

  }
;
}

static bool ScatterCommonIdPosition
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree id)
# else
(stmt, id)
 register tTree stmt;
 register tTree id;
# endif
{
  if (stmt->Kind == kSCATTER_STMT) {
# line 531 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  bool yyV5;
  int yyV6;
  bool yyV7;
  int yyV8;
  bool yyV9;
  int yyV10;
  {
# line 533 "VectorMove.puma"
   FindVarIdPosition (stmt->SCATTER_STMT.ARRAY, id, & yyV1, & yyV2);
# line 534 "VectorMove.puma"
   if (! ((yyV2 >= 0))) goto yyL1;
  {
# line 536 "VectorMove.puma"
   FindParamIdPosition (stmt->SCATTER_STMT.INDEXES, id, & yyV3, & yyV4);
# line 537 "VectorMove.puma"
   MergeResults (yyV1, yyV2, yyV3, yyV4, & yyV5, & yyV6);
# line 538 "VectorMove.puma"
   FindParamIdPosition (stmt->SCATTER_STMT.MASK, id, & yyV7, & yyV8);
# line 539 "VectorMove.puma"
   MergeResults (yyV7, yyV8, yyV5, yyV6, & yyV9, & yyV10);
# line 541 "VectorMove.puma"
   if (! ((yyV9))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

# line 544 "VectorMove.puma"
  {
# line 545 "VectorMove.puma"
   return false;
  }

  }
  return false;
}

static void ScatterSubstitute
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register tTree slice)
# else
(t, id, slice)
 register tTree t;
 register tTree id;
 register tTree slice;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
# line 556 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 558 "VectorMove.puma"
   FindLoopVar (t, id, & yyV1, & yyV2, & yyV3);
# line 559 "VectorMove.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 561 "VectorMove.puma"
   Substitute (t, id, yyV3, slice);
  }
  }
   return;
 }
yyL1:;

  }
  if (t->Kind == kCONST_EXP) {
# line 564 "VectorMove.puma"
   return;

  }
  if (t->Kind == kVAR_PARAM) {
# line 567 "VectorMove.puma"
  {
# line 569 "VectorMove.puma"
   ScatterSubstitute (t->VAR_PARAM.V, id, slice);
  }
   return;

  }
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 572 "VectorMove.puma"
  {
# line 574 "VectorMove.puma"
   ScatterSubstitute (t->BTP_LIST.Elem->VAR_PARAM.V, id, slice);
# line 575 "VectorMove.puma"
   ScatterSubstitute (t->BTP_LIST.Next, id, slice);
  }
   return;

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 578 "VectorMove.puma"
   return;

  }
  if (t->Kind == kNO_PARAM) {
# line 581 "VectorMove.puma"
   return;

  }
;
}

static void FindParamIdPosition
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register bool * yyP12, register int * yyP11)
# else
(t, id, yyP12, yyP11)
 register tTree t;
 register tTree id;
 register bool * yyP12;
 register int * yyP11;
# endif
{
  if (t->Kind == kBTP_EMPTY) {
# line 598 "VectorMove.puma"
   * yyP12 = true;
   * yyP11 = - 1;
   return;

  }
  if (t->Kind == kNO_PARAM) {
# line 601 "VectorMove.puma"
   * yyP12 = true;
   * yyP11 = - 1;
   return;

  }
  if (t->Kind == kBTP_LIST) {
# line 604 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  bool yyV5;
  int yyV6;
  {
# line 606 "VectorMove.puma"
   FindParamIdPosition (t->BTP_LIST.Elem, id, & yyV1, & yyV2);
# line 607 "VectorMove.puma"
   FindParamIdPosition (t->BTP_LIST.Next, id, & yyV3, & yyV4);
# line 608 "VectorMove.puma"
   MergeResults (yyV1, yyV2, yyV3, yyV4, & yyV5, & yyV6);
  }
   * yyP12 = yyV5;
   * yyP11 = yyV6;
   return;
 }

  }
  if (t->Kind == kVAR_PARAM) {
# line 611 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 613 "VectorMove.puma"
   FindVarIdPosition (t->VAR_PARAM.V, id, & yyV1, & yyV2);
  }
   * yyP12 = yyV1;
   * yyP11 = yyV2;
   return;
 }

  }
# line 616 "VectorMove.puma"
   * yyP12 = false;
   * yyP11 = 0;
   return;

;
}

static void FindVarIdPosition
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register bool * yyP14, register int * yyP13)
# else
(t, id, yyP14, yyP13)
 register tTree t;
 register tTree id;
 register bool * yyP14;
 register int * yyP13;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
# line 621 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 623 "VectorMove.puma"
   FindLoopVar (t, id, & yyV1, & yyV2, & yyV3);
# line 624 "VectorMove.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 625 "VectorMove.puma"
   if (! ((yyV3 != 0))) goto yyL1;
  }
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }
yyL1:;

  }
# line 630 "VectorMove.puma"
  {
# line 632 "VectorMove.puma"
   if (! ((TreeRank (t) == 0))) goto yyL2;
  {
# line 633 "VectorMove.puma"
   if (! ((! IsVarInExp (TreeVarName (id), t)))) goto yyL2;
  }
  }
   * yyP14 = true;
   * yyP13 = - 1;
   return;
yyL2:;

# line 636 "VectorMove.puma"
   * yyP14 = false;
   * yyP13 = 0;
   return;

;
}

static void MergeResults
# if defined __STDC__ | defined __cplusplus
(register bool legal1, register int pos1, register bool legal2, register int pos2, register bool * yyP16, register int * yyP15)
# else
(legal1, pos1, legal2, pos2, yyP16, yyP15)
 register bool legal1;
 register int pos1;
 register bool legal2;
 register int pos2;
 register bool * yyP16;
 register int * yyP15;
# endif
{
# line 648 "VectorMove.puma"
  {
# line 650 "VectorMove.puma"
   if (! ((legal1))) goto yyL1;
  {
# line 651 "VectorMove.puma"
   if (! ((legal2))) goto yyL1;
  {
# line 652 "VectorMove.puma"
   if (! ((pos2 == - 1))) goto yyL1;
  }
  }
  }
   * yyP16 = true;
   * yyP15 = pos1;
   return;
yyL1:;

# line 655 "VectorMove.puma"
  {
# line 657 "VectorMove.puma"
   if (! ((legal1))) goto yyL2;
  {
# line 658 "VectorMove.puma"
   if (! ((legal2))) goto yyL2;
  {
# line 659 "VectorMove.puma"
   if (! ((pos1 == - 1))) goto yyL2;
  }
  }
  }
   * yyP16 = true;
   * yyP15 = pos2;
   return;
yyL2:;

# line 662 "VectorMove.puma"
  {
# line 664 "VectorMove.puma"
   if (! ((legal1))) goto yyL3;
  {
# line 665 "VectorMove.puma"
   if (! ((legal2))) goto yyL3;
  {
# line 666 "VectorMove.puma"
   if (! ((pos1 == pos2))) goto yyL3;
  }
  }
  }
   * yyP16 = true;
   * yyP15 = pos1;
   return;
yyL3:;

# line 669 "VectorMove.puma"
   * yyP16 = false;
   * yyP15 = 0;
   return;

;
}

void MakeVectorVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id, register tTree slice, register int * yyP17)
# else
(var, id, slice, yyP17)
 register tTree var;
 register tTree id;
 register tTree slice;
 register int * yyP17;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 686 "VectorMove.puma"
   * yyP17 = 0;
   return;

  }
# line 689 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 691 "VectorMove.puma"
   FindLoopVar (var, id, & yyV1, & yyV2, & yyV3);
# line 692 "VectorMove.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 693 "VectorMove.puma"
   if (! ((yyV3 == 0))) goto yyL2;
  }
  }
   * yyP17 = 0;
   return;
 }
yyL2:;

# line 696 "VectorMove.puma"
 {
  bool yyV1;
  int yyV2;
  int yyV3;
  {
# line 698 "VectorMove.puma"
   FindLoopVar (var, id, & yyV1, & yyV2, & yyV3);
# line 699 "VectorMove.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 700 "VectorMove.puma"
   Substitute (var, id, yyV3, slice);
  }
  }
   * yyP17 = 1;
   return;
 }
yyL3:;

# line 703 "VectorMove.puma"
   * yyP17 = - 1;
   return;

;
}

void BeginVectorMove ()
{
}

void CloseVectorMove ()
{
}
