# include "VectorComm.h"
# include "yyVectorComm.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 20 "VectorComm.puma"


# define MODULE "VectorComm"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"
# include "VarDescriptor.h"
# include "ExpNormal.h"

tTree LoopNest [10];
tTree LowerBounds [10];
tTree UpperBounds [10];



static void yyExit () { Exit (1); }

void (* VectorComm_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VectorComm, routine %s failed\n", yyFunction);
 VectorComm_Exit ();
}

tTree VectorizeCommunication ARGS((tTree t));
static void DoIt ARGS((tTree t, int n));
static void LookAtIndexes ARGS((pvar vard, int depth));

tTree VectorizeCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 46 "VectorComm.puma"
  {
# line 48 "VectorComm.puma"
   printf ("Call of VectorizeCommunication\n");
# line 49 "VectorComm.puma"
   FileUnparse (stdout, t);
# line 51 "VectorComm.puma"
   DoIt (t, 0);
  }
   return t;

  }
# line 56 "VectorComm.puma"
  {
# line 57 "VectorComm.puma"
   failure_protocol (MODULE, "VectorizeCommunication", t);
  }
   return t;

}

static void DoIt
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int n)
# else
(t, n)
 register tTree t;
 register int n;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 63 "VectorComm.puma"
  {
# line 65 "VectorComm.puma"
 LoopNest[n] = t; 
     LowerBounds[n] = t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.START; 
     UpperBounds[n] = t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.STOP;
   
# line 70 "VectorComm.puma"
   DoIt (t->ACF_FORALL.FORALL_BODY, n + 1);
  }
   return;

  }
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 73 "VectorComm.puma"
  {
# line 75 "VectorComm.puma"
   DoIt (t->ACF_LIST.Elem, n);
  }
   return;

  }
  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK->Kind == kNO_PARAM) {
# line 78 "VectorComm.puma"
 {
  var_descriptor lhs_vard;
  var_descriptor rhs_vard;
  {
# line 80 "VectorComm.puma"
   printf ("innermost assignment (no of outer loops : %d)\n", n);
# line 81 "VectorComm.puma"
   FileUnparse (stdout, t);
# line 83 "VectorComm.puma"

# line 84 "VectorComm.puma"

# line 86 "VectorComm.puma"
   SetVarDescriptor (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET, & lhs_vard);
# line 87 "VectorComm.puma"
   SetVarDescriptor (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE, & rhs_vard);
# line 89 "VectorComm.puma"
   printf ("descriptor of lhs variable : \n");
# line 90 "VectorComm.puma"
   PrintVarDescriptor (& lhs_vard);
# line 91 "VectorComm.puma"
   LookAtIndexes (& lhs_vard, n);
# line 92 "VectorComm.puma"
   printf ("descriptor of rhs variable : \n");
# line 93 "VectorComm.puma"
   PrintVarDescriptor (& rhs_vard);
# line 94 "VectorComm.puma"
   LookAtIndexes (& rhs_vard, n);
  }
   return;
 }

  }
  }
  }
# line 97 "VectorComm.puma"
  {
# line 99 "VectorComm.puma"
   failure_protocol (MODULE, "DoIt", t);
  }
   return;

;
}

static void LookAtIndexes
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int depth)
# else
(vard, depth)
 pvar vard;
 register int depth;
# endif
{
# line 104 "VectorComm.puma"
  {
# line 106 "VectorComm.puma"
 int i, j;
     int rank;
     tTree exp;
     ExpNormRecord en;
     bool found;

     rank = vard->formal_rank;

     for (i=0; i<rank; i++)
       { exp = vard->actual_shape[i][0];
         printf ("index expression %d : ", i+1);
         FileUnparse (stdout, exp);
         printf ("\n");
         ExpNormal (exp, LoopNest, depth, &found, &en);

         if (found)

            { printf ("rormalized in %d loops: %d", depth, en.vals[0]);
              for (j=1; j<=depth;j++)
                printf (" + %d*I%d", en.vals[j], j);
              printf ("\n");
            } 

          else
           printf ("no expression normalization\n");
       }
   
  }
   return;

;
}

void BeginVectorComm ()
{
}

void CloseVectorComm ()
{
}
