# include "VarDescriptor.h"
# include "yyVarDescriptor.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 137 "VarDescriptor.puma"


# undef  DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "DefTable.h"
# include "Objects.h"

# include "Types.h"             /* type_rec, ...    */
# include "Rank.h"              /* */
# include "TreeOps.h"           /* */
# include "Distributions.h"     /* DimListLength, ... */
# include "Expressions.h"       /* MakeConstant, ... */
# include "ShowDefs.h"          /* SemFile, ...       */
# include "Unparse.h"

# define MODULE "VarDescriptor"

/***********************************************************
*                                                          *
*  FUNCTION GetFormalDim (*var_descripor, dim)  int        *
*                                                          *
*   GetFormalDim (A(2,3,1:4,1:5,1:3), 2) -> 4              *
*                                                          *
***********************************************************/

int LocalGetFormalDim (vard, dim)

var_descriptor *vard;
int dim;

{  int i, rank;
   int rank_pos;
   int index_dim;

   /* error handling at first */

   rank     = vard->actual_rank;

   if ((dim < 1) || (dim > rank))

     { printf ("illegal dimension %d (must be 1 - %d)\n", dim, rank);
       failure_protocol (MODULE, "GetFormalDim", NoTree);
     }

   rank     = vard->formal_rank;
   rank_pos = 0;

   index_dim = 0;

   for (i=0; i<rank; i++)

     { if (vard->actual_shape[i][0] != vard->actual_shape[i][1])

          { rank_pos += 1;
            if (rank_pos == dim) index_dim = i+1;
          }

     } /* for */

   return (index_dim);

} /* GetFormalDim */
 


static void yyExit () { Exit (1); }

void (* VarDescriptor_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VarDescriptor, routine %s failed\n", yyFunction);
 VarDescriptor_Exit ();
}

void SetVarDescriptor ARGS((tTree var, pvar vard));
void SetProcDescriptor ARGS((tTree t, pvar vard));
static void SetActualShape ARGS((tTree actuals, int n, pvar vard));
void SetVarObjDescriptor ARGS((pvar vard, tDefinitions obj, tTree rinfo));
static void SetTopObjDescriptor ARGS((pvar vard, tDefinitions obj));
static void SetObjectInfo ARGS((pvar vard, tDefinitions v, tTree rinfo));
static tDefinitions DistributionTemplate ARGS((tDefinitions d, tDefinitions v_obj));
static tDefinitions GetValidVarDistribution ARGS((tDefinitions def_dist, tTree reach_info));
static tDefinitions GetValidTempDistribution ARGS((tDefinitions def_dist, tTree reach_info));
static tTree GetValidVarShape ARGS((tTree formals, tTree reach_info));
static tTree GetValidTempShape ARGS((tTree formals, tTree reach_info));
static void SetTemplateInfo ARGS((pvar vard, tDefinitions tobj, tTree reach_def));
static void GetObjectBaseInfo ARGS((tDefinitions v, tIdent * yyP4, int * yyP3, tTree * yyP2, tDefinitions * yyP1));
static tTree GetObjectSelection ARGS((tDefinitions v));
static void SetAllocShape ARGS((tTree formals, tTree allocs, int n, pvar vard));
static void SetAlloc1Shape ARGS((tTree formal, tTree alloc, int n, pvar vard));
static void SetOverlap ARGS((tTree overlap, int n, pvar vard));
static void SetReplicated ARGS((pvar vard));
static void SetDistribution ARGS((tDefinitions d, pvar vard));
static void SetDistDimList ARGS((tDefinitions d, pvar vard));
static void SetSimpleDistribution ARGS((tDefinitions d, pvar vard));
static int NoDistributedDims ARGS((tDefinitions dlist));
static void SetAlignment ARGS((tDefinitions d, pvar tempd, pvar vard));
static void SetSourceAlignList ARGS((tDefinitions d, pvar tempd, pvar vard));
static void SetSourceAlignment ARGS((tDefinitions d, pvar tempd, pvar vard));
static void SetTargetAlignList ARGS((tDefinitions d, pvar tempd, pvar vard));
static void SetTargetAlignment ARGS((tDefinitions d, pvar tempd, pvar vard));
static void SetSelection ARGS((tTree s, pvar vard));
static void SetSelectionList ARGS((tTree s, pvar vard, int dim));
tTree MakeDescriptorVar ARGS((pvar vard));
static int source_of_tempdim ARGS((pvar vard, int tdim));
static int target_of_tempdim ARGS((pvar vard, int tdim));
static void SetTemplateObject ARGS((tTree v, tDefinitions tobj, tTree rinfo));
static tTree TranslateActual ARGS((tTree exp));
void PrintVarDescriptor ARGS((pvar vard));
static void PrintReachingInfo ARGS((tTree rinfo));
int GetFormalDim ARGS((pvar vard, int dim));

void SetVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar vard)
# else
(var, vard)
 register tTree var;
 pvar vard;
# endif
{
# line 268 "VarDescriptor.puma"
  {
# line 270 "VarDescriptor.puma"
 
#ifdef DEBUG
    printf ("SetVarDescripor : ");
    FileUnparse (stdout, var);
    printf ("\n");
#endif
  
# line 277 "VarDescriptor.puma"
   goto yyL1;
  }
yyL1:;

  if (var->Kind == kUSED_VAR) {
# line 280 "VarDescriptor.puma"
  {
# line 282 "VarDescriptor.puma"
 

    if ( (VarRank (var->USED_VAR.VARNAME->VAR_OBJ.Object) > 0) && (var->USED_VAR.VARNAME->VAR_OBJ.Reaching == NoTree) )
      { error_protocol ("used var without reaching info");
        tree_protocol ("used var is : ", var);
      }
  
# line 290 "VarDescriptor.puma"
   SetVarObjDescriptor (vard, var->USED_VAR.VARNAME->VAR_OBJ.Object, var->USED_VAR.VARNAME->VAR_OBJ.Reaching);
# line 292 "VarDescriptor.puma"
 vard->var_tree = var; 
  }
   return;

  }
  if (var->Kind == kLOOP_VAR) {
# line 295 "VarDescriptor.puma"
  {
# line 299 "VarDescriptor.puma"
   SetVarObjDescriptor (vard, var->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object, NoTree);
# line 301 "VarDescriptor.puma"
 vard->var_tree = var; 
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 304 "VarDescriptor.puma"
  {
# line 306 "VarDescriptor.puma"
   SetVarDescriptor (var->INDEXED_VAR.IND_VAR, vard);
# line 308 "VarDescriptor.puma"
 vard->var_tree = var;
    vard->actual_rank = 0;                
  
# line 312 "VarDescriptor.puma"
   SetActualShape (var->INDEXED_VAR.IND_EXPS, 1, vard);
  }
   return;

  }
  if (var->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 331 "VarDescriptor.puma"
  {
# line 335 "VarDescriptor.puma"
   SetVarObjDescriptor (vard, var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object, NoTree);
# line 337 "VarDescriptor.puma"
 vard->var_tree = var;
    vard->actual_rank = 0;
  
# line 341 "VarDescriptor.puma"
   SetActualShape (var->INDEXED_VAR.IND_EXPS, 1, vard);
  }
   return;

  }
  }
  if (var->Kind == kSELECTED_VAR) {
# line 315 "VarDescriptor.puma"
 {
  type_rec t;
  {
# line 317 "VarDescriptor.puma"
   SetVarDescriptor (var->SELECTED_VAR.SELEC_VAR, vard);
# line 319 "VarDescriptor.puma"

# line 321 "VarDescriptor.puma"
 

    GetTypeRecord (GetBaseType (GetObjectType (var->SELECTED_VAR.SELECTOR->REC_COMP.Object)), &t);

    vard->type_kind = t.type_kind;
    vard->type_size = t.type_size;

  
  }
   return;
 }

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 366 "VarDescriptor.puma"
  {
# line 368 "VarDescriptor.puma"
   SetVarDescriptor (var->SUBSTRING_VAR.IND_VAR, vard);
  }
   return;

  }
# line 373 "VarDescriptor.puma"
  {
# line 375 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetVarDescriptor", var);
  }
   return;

;
}

void SetProcDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar vard)
# else
(t, vard)
 register tTree t;
 pvar vard;
# endif
{
  if (t->Kind == kPROCESSOR_ARRAY) {
# line 388 "VarDescriptor.puma"
  {
# line 390 "VarDescriptor.puma"
   SetTopObjDescriptor (vard, t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object);
# line 392 "VarDescriptor.puma"
 vard->var_tree = t; 
  }
   return;

  }
  if (t->Kind == kPROCESSOR_SUBSET) {
# line 395 "VarDescriptor.puma"
  {
# line 397 "VarDescriptor.puma"
   SetTopObjDescriptor (vard, t->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Object);
# line 399 "VarDescriptor.puma"
 vard->actual_rank = 0;                
     vard->var_tree    = t;
     vard->var_obj     = t->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object;
   
# line 404 "VarDescriptor.puma"
   SetActualShape (t->PROCESSOR_SUBSET.SUBSCRIPTS, 1, vard);
  }
   return;

  }
# line 407 "VarDescriptor.puma"
  {
# line 409 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetProcDescriptor", t);
  }
   return;

;
}

static void SetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register int n, pvar vard)
# else
(actuals, n, vard)
 register tTree actuals;
 register int n;
 pvar vard;
# endif
{
  if (actuals->Kind == kBTE_EMPTY) {
# line 422 "VarDescriptor.puma"
   return;

  }
  if (actuals->Kind == kBTE_LIST) {
# line 425 "VarDescriptor.puma"
  {
# line 427 "VarDescriptor.puma"
   SetActualShape (actuals->BTE_LIST.Elem, n, vard);
# line 428 "VarDescriptor.puma"
   SetActualShape (actuals->BTE_LIST.Next, n + 1, vard);
  }
   return;

  }
# line 431 "VarDescriptor.puma"
 {
  int top_dim;
  {
# line 435 "VarDescriptor.puma"

# line 437 "VarDescriptor.puma"
 if (n > vard->formal_rank)
         failure_protocol (MODULE, "SetActualShape", actuals);

      top_dim = vard->topology_dim[n-1];
      if (top_dim > 0)
         vard->on_val[top_dim-1] = actuals;
    
# line 445 "VarDescriptor.puma"
   goto yyL3;
  }
 }
yyL3:;

  if (actuals->Kind == kSLICE_EXP) {
# line 448 "VarDescriptor.puma"
  {
# line 450 "VarDescriptor.puma"
 vard->actual_rank ++;
      vard->actual_shape[n-1][0] = actuals->SLICE_EXP.START;
      vard->actual_shape[n-1][1] = actuals->SLICE_EXP.STOP;
      vard->actual_shape[n-1][2] = actuals->SLICE_EXP.INC;
    
  }
   return;

  }
# line 457 "VarDescriptor.puma"
  {
# line 459 "VarDescriptor.puma"
 if (TreeRank (actuals) == 1)
         vard->actual_rank ++;
      vard->actual_shape[n-1][0] = actuals;
      vard->actual_shape[n-1][1] = actuals;
      vard->actual_shape[n-1][2] = NoTree;
    
  }
   return;

;
}

void SetVarObjDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions obj, register tTree rinfo)
# else
(vard, obj, rinfo)
 pvar vard;
 register tDefinitions obj;
 register tTree rinfo;
# endif
{
# line 475 "VarDescriptor.puma"
 {
  type_rec t;
  {
# line 477 "VarDescriptor.puma"

# line 479 "VarDescriptor.puma"
 int i;

    SetObjectInfo (vard, obj, rinfo);

    

    if (IsTemplate(obj))

      { t.type_kind = kDUMMY_TYPE;
        t.type_size = 0;
      }

     else  GetTypeRecord (GetBaseType (GetObjectType (obj)), &t);

    vard->type_kind = t.type_kind;
    vard->type_size = t.type_size;

    vard->actual_rank = vard->formal_rank;

    vard->var_tree = NoTree;
    vard->var_obj  = obj;
    
    for (i=0; i<vard->actual_rank; i++)

      { vard->actual_shape[i][0] = vard->alloc_shape[i][0];
        vard->actual_shape[i][1] = vard->alloc_shape[i][1];
        vard->actual_shape[i][2] = NoTree;
      };

    vard->reach_info = rinfo;

    vard->expanded = false;

  
  }
   return;
 }

;
}

static void SetTopObjDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions obj)
# else
(vard, obj)
 pvar vard;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTopologyObject) {
  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
# line 525 "VarDescriptor.puma"
  {
# line 527 "VarDescriptor.puma"
 int idim, rank;

    rank = TreeListLength (obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS);

    vard->formal_rank = rank;

    vard->template_obj = obj;   
    vard->template_rank = rank;
    vard->template_inherited = 0;

    vard->shared = 0;

    SetAllocShape (obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS, obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS, 1, vard);

    vard->topology_obj   = obj;
    vard->topology_rank  = rank;

    for (idim=0; idim<rank; idim++)

      { vard->distribution_kind [idim] = kBLOCK_DIM;
        vard->distribution_size [idim] = NoTree;
        vard->topology_dim [idim] = idim+1;
        vard->template_dim [idim] = idim+1; 
        vard->align_add [idim]    = 0;
        vard->align_mult [idim]   = 1;

        vard->formal_shape [idim][0] = vard->alloc_shape[idim][0];
        vard->formal_shape [idim][1] = vard->alloc_shape[idim][1];

        

        vard->on_index_dim [idim]    = idim+1;
        vard->on_temp_dim  [idim]    = idim+1;
        vard->on_kind      [idim]    = kBLOCK_DIM;
        vard->on_size      [idim]    = NoTree;
        vard->on_val       [idim]    = NoTree;
        vard->on_range     [idim][0] = vard->formal_shape[idim][0];
        vard->on_range     [idim][1] = vard->formal_shape[idim][1];

      }

    vard->type_kind = kDUMMY_TYPE;
    vard->type_size = 0;

    vard->actual_rank = vard->formal_rank;

    vard->var_tree = NoTree;
    vard->var_obj  = obj;

    for (idim=0; idim<vard->actual_rank; idim++)

      { vard->actual_shape[idim][0] = vard->alloc_shape[idim][0];
        vard->actual_shape[idim][1] = vard->alloc_shape[idim][1];
        vard->actual_shape[idim][2] = NoTree;
      };

    vard->reach_info = NoTree;
    vard->expanded = false;

  
  }
   return;

  }
  }
# line 589 "VarDescriptor.puma"
  {
# line 591 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetTopObjDescriptor", obj->Object.decl);
  }
   return;

;
}

static void SetObjectInfo
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions v, register tTree rinfo)
# else
(vard, v, rinfo)
 pvar vard;
 register tDefinitions v;
 register tTree rinfo;
# endif
{
# line 604 "VarDescriptor.puma"
 {
  tIdent yyV1;
  int yyV2;
  tTree yyV3;
  tDefinitions yyV4;
  tDefinitions t_obj;
  tDefinitions dist;
  {
# line 606 "VarDescriptor.puma"
   GetObjectBaseInfo (v, & yyV1, & yyV2, & yyV3, & yyV4);
# line 608 "VarDescriptor.puma"
 vard->formal_rank = yyV2;

     vard->template_obj   = v;      
     vard->template_rank  = yyV2;   
     vard->template_inherited = 0;

     vard->shared = 0;              

     

     if (yyV2 > 0)
        SetAllocShape (yyV3, GetValidVarShape (yyV3, rinfo), 1, vard);

   
# line 624 "VarDescriptor.puma"

# line 625 "VarDescriptor.puma"

# line 627 "VarDescriptor.puma"
   dist = GetValidVarDistribution (yyV4, rinfo);
# line 629 "VarDescriptor.puma"
   t_obj = DistributionTemplate (dist, v);
# line 631 "VarDescriptor.puma"
 if (t_obj == NoObject)

       { failure_protocol (MODULE, "SetObjectIno: no reach distr", v->Object.decl);
       }
 
      else if (t_obj == v)

       SetDistribution (dist, vard);

      else 

      { var_descriptor tempd;

        SetTemplateInfo (&tempd, t_obj, rinfo);
 
        SetAlignment (dist, &tempd, vard);
      }

   
# line 651 "VarDescriptor.puma"
   SetSelection (GetObjectSelection (v), vard);
  }
   return;
 }

;
}

static tDefinitions DistributionTemplate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions v_obj)
# else
(d, v_obj)
 register tDefinitions d;
 register tDefinitions v_obj;
# endif
{
# line 661 "VarDescriptor.puma"
  {
# line 663 "VarDescriptor.puma"
   if (! ((d == NoDefinitions))) goto yyL1;
  }
   return NoObject;
yyL1:;

  if (d->Kind == kAlignDistribution) {
# line 668 "VarDescriptor.puma"
   return d->AlignDistribution.template_obj;

  }
# line 673 "VarDescriptor.puma"
   return v_obj;

}

static tDefinitions GetValidVarDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def_dist, register tTree reach_info)
# else
(def_dist, reach_info)
 register tDefinitions def_dist;
 register tTree reach_info;
# endif
{
# line 691 "VarDescriptor.puma"
  {
# line 693 "VarDescriptor.puma"
   if (! ((! def_dist->Distribution.dynamic))) goto yyL1;
  }
   return def_dist;
yyL1:;

# line 698 "VarDescriptor.puma"
  {
# line 700 "VarDescriptor.puma"
   if (! ((reach_info == NoTree))) goto yyL2;
  }
   return def_dist;
yyL2:;

  if (reach_info->Kind == kREACHING_INFO) {
# line 705 "VarDescriptor.puma"
  {
# line 707 "VarDescriptor.puma"
   if (! ((reach_info->REACHING_INFO.var_distribution == NoDefinitions))) goto yyL3;
  }
   return def_dist;
yyL3:;

# line 712 "VarDescriptor.puma"
   return reach_info->REACHING_INFO.var_distribution;

  }
# line 717 "VarDescriptor.puma"
  {
# line 719 "VarDescriptor.puma"
   failure_protocol (MODULE, "GetValidVarDistribution", reach_info);
  }
   return def_dist;

}

static tDefinitions GetValidTempDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def_dist, register tTree reach_info)
# else
(def_dist, reach_info)
 register tDefinitions def_dist;
 register tTree reach_info;
# endif
{
# line 736 "VarDescriptor.puma"
  {
# line 738 "VarDescriptor.puma"
   if (! ((! def_dist->Distribution.dynamic))) goto yyL1;
  }
   return def_dist;
yyL1:;

# line 743 "VarDescriptor.puma"
  {
# line 745 "VarDescriptor.puma"
   if (! ((reach_info == NoTree))) goto yyL2;
  }
   return def_dist;
yyL2:;

  if (reach_info->Kind == kREACHING_INFO) {
# line 750 "VarDescriptor.puma"
  {
# line 752 "VarDescriptor.puma"
   if (! ((reach_info->REACHING_INFO.temp_distribution == NoDistribution))) goto yyL3;
  }
   return def_dist;
yyL3:;

# line 757 "VarDescriptor.puma"
   return reach_info->REACHING_INFO.temp_distribution;

  }
# line 762 "VarDescriptor.puma"
  {
# line 764 "VarDescriptor.puma"
   failure_protocol (MODULE, "GetValidTempDistribution", reach_info);
  }
   return def_dist;

}

static tTree GetValidVarShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree reach_info)
# else
(formals, reach_info)
 register tTree formals;
 register tTree reach_info;
# endif
{
# line 776 "VarDescriptor.puma"
  {
# line 778 "VarDescriptor.puma"
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   return formals;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
# line 783 "VarDescriptor.puma"
   return reach_info->REACHING_INFO.var_allocate;

  }
# line 788 "VarDescriptor.puma"
  {
# line 790 "VarDescriptor.puma"
   failure_protocol (MODULE, "GetValidVarShape", reach_info);
  }
   return formals;

}

static tTree GetValidTempShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree reach_info)
# else
(formals, reach_info)
 register tTree formals;
 register tTree reach_info;
# endif
{
# line 802 "VarDescriptor.puma"
  {
# line 804 "VarDescriptor.puma"
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   return formals;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
# line 809 "VarDescriptor.puma"
   return reach_info->REACHING_INFO.temp_allocate;

  }
# line 814 "VarDescriptor.puma"
  {
# line 816 "VarDescriptor.puma"
   failure_protocol (MODULE, "GetValidTempShape", reach_info);
  }
   return formals;

}

static void SetTemplateInfo
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions tobj, register tTree reach_def)
# else
(vard, tobj, reach_def)
 pvar vard;
 register tDefinitions tobj;
 register tTree reach_def;
# endif
{
# line 831 "VarDescriptor.puma"
 {
  tIdent yyV1;
  int yyV2;
  tTree yyV3;
  tDefinitions yyV4;
  {
# line 833 "VarDescriptor.puma"
   GetObjectBaseInfo (tobj, & yyV1, & yyV2, & yyV3, & yyV4);
# line 835 "VarDescriptor.puma"
 vard->formal_rank = yyV2;

     vard->template_obj   = tobj;     
     vard->template_rank  = yyV2;

     if (yyV2 > 0)
        SetAllocShape (yyV3, GetValidTempShape(yyV3, reach_def), 1, vard);

   
# line 845 "VarDescriptor.puma"
   SetDistribution (GetValidTempDistribution (yyV4, reach_def), vard);
# line 847 "VarDescriptor.puma"
   SetSelection (GetObjectSelection (tobj), vard);
  }
   return;
 }

;
}

static void GetObjectBaseInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register tIdent * yyP4, register int * yyP3, register tTree * yyP2, register tDefinitions * yyP1)
# else
(v, yyP4, yyP3, yyP2, yyP1)
 register tDefinitions v;
 register tIdent * yyP4;
 register int * yyP3;
 register tTree * yyP2;
 register tDefinitions * yyP1;
# endif
{
# line 858 "VarDescriptor.puma"
  {
# line 860 "VarDescriptor.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 862 "VarDescriptor.puma"
   failure_protocol (MODULE, "GetObjectBaseInfo (NoObject)", NoTree);
  }
  }
   * yyP4 = DefaultId ();
   * yyP3 = 0;
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;
yyL1:;

  if (v->Kind == kVarObject) {
# line 865 "VarDescriptor.puma"
  {
# line 867 "VarDescriptor.puma"
   if (! ((VarRank (v) == 0))) goto yyL2;
  }
   * yyP4 = v->VarObject.Ident;
   * yyP3 = 0;
   * yyP2 = NoTree;
   * yyP1 = v->VarObject.Dist;
   return;
yyL2:;

# line 870 "VarDescriptor.puma"
   * yyP4 = v->VarObject.Ident;
   * yyP3 = VarRank (v);
   * yyP2 = ArrayFormals (v);
   * yyP1 = v->VarObject.Dist;
   return;

  }
  if (v->Kind == kTemplateObject) {
# line 873 "VarDescriptor.puma"
  {
# line 875 "VarDescriptor.puma"
   if (! ((VarRank (v) == 0))) goto yyL4;
  }
   * yyP4 = v->TemplateObject.Ident;
   * yyP3 = 0;
   * yyP2 = NoTree;
   * yyP1 = v->TemplateObject.Dist;
   return;
yyL4:;

# line 878 "VarDescriptor.puma"
   * yyP4 = v->TemplateObject.Ident;
   * yyP3 = VarRank (v);
   * yyP2 = ArrayFormals (v);
   * yyP1 = v->TemplateObject.Dist;
   return;

  }
# line 882 "VarDescriptor.puma"
  {
# line 884 "VarDescriptor.puma"
   failure_protocol (MODULE, "GetObjectBaseInfo", v->Object.decl);
  }
   * yyP4 = v->Object.Ident;
   * yyP3 = 0;
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

;
}

static tTree GetObjectSelection
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
# line 897 "VarDescriptor.puma"
   return v->VarObject.select;

  }
  if (v->Kind == kTemplateObject) {
# line 902 "VarDescriptor.puma"
   return v->TemplateObject.select;

  }
# line 907 "VarDescriptor.puma"
   return NoTree;

}

static void SetAllocShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree allocs, register int n, pvar vard)
# else
(formals, allocs, n, vard)
 register tTree formals;
 register tTree allocs;
 register int n;
 pvar vard;
# endif
{
# line 925 "VarDescriptor.puma"
  {
# line 927 "VarDescriptor.puma"
   if (! ((allocs == NoTree))) goto yyL1;
  {
# line 929 "VarDescriptor.puma"
   SetAllocShape (formals, formals, n, vard);
  }
  }
   return;
yyL1:;

  if (formals->Kind == kSHAPE_EMPTY) {
# line 932 "VarDescriptor.puma"
  {
# line 934 "VarDescriptor.puma"
   if (! ((formals == allocs))) goto yyL2;
  }
   return;
yyL2:;

  if (allocs->Kind == kBTE_EMPTY) {
# line 937 "VarDescriptor.puma"
   return;

  }
  }
  if (formals->Kind == kSHAPE_LIST) {
# line 940 "VarDescriptor.puma"
  {
# line 942 "VarDescriptor.puma"
   if (! ((formals == allocs))) goto yyL4;
  {
# line 944 "VarDescriptor.puma"
   SetAlloc1Shape (formals->SHAPE_LIST.Elem, formals->SHAPE_LIST.Elem, n, vard);
# line 945 "VarDescriptor.puma"
   SetAllocShape (formals->SHAPE_LIST.Next, formals->SHAPE_LIST.Next, n + 1, vard);
  }
  }
   return;
yyL4:;

  if (allocs->Kind == kBTE_LIST) {
# line 948 "VarDescriptor.puma"
  {
# line 950 "VarDescriptor.puma"
   SetAlloc1Shape (formals->SHAPE_LIST.Elem, allocs->BTE_LIST.Elem, n, vard);
# line 951 "VarDescriptor.puma"
   SetAllocShape (formals->SHAPE_LIST.Next, allocs->BTE_LIST.Next, n + 1, vard);
  }
   return;

  }
  }
# line 954 "VarDescriptor.puma"
  {
# line 955 "VarDescriptor.puma"
   failure2_protocol (MODULE, "SetAllocShape", formals, allocs);
  }
   return;

;
}

static void SetAlloc1Shape
# if defined __STDC__ | defined __cplusplus
(register tTree formal, register tTree alloc, register int n, pvar vard)
# else
(formal, alloc, n, vard)
 register tTree formal;
 register tTree alloc;
 register int n;
 pvar vard;
# endif
{
  if (formal->Kind == kEXPLICIT_SHAPE) {
# line 964 "VarDescriptor.puma"
  {
# line 966 "VarDescriptor.puma"
   if (! ((alloc == formal))) goto yyL1;
  {
# line 968 "VarDescriptor.puma"
 vard->alloc_shape[n-1][0]  = formal->EXPLICIT_SHAPE.LOWER;
      vard->alloc_shape[n-1][1]  = formal->EXPLICIT_SHAPE.UPPER;
    
# line 972 "VarDescriptor.puma"
   SetOverlap (formal->EXPLICIT_SHAPE.Overlap, n, vard);
  }
  }
   return;
yyL1:;

  }
  if (Tree_IsType (formal, kSHAPE_SPEC)) {
# line 975 "VarDescriptor.puma"
  {
# line 977 "VarDescriptor.puma"
   if (! ((alloc == formal))) goto yyL2;
  {
# line 979 "VarDescriptor.puma"
 vard->alloc_shape[n-1][0] = NoTree;
      vard->alloc_shape[n-1][1] = NoTree;
    
# line 983 "VarDescriptor.puma"
   SetOverlap (formal->SHAPE_SPEC.Overlap, n, vard);
  }
  }
   return;
yyL2:;

  if (alloc->Kind == kSLICE_EXP) {
# line 986 "VarDescriptor.puma"
  {
# line 988 "VarDescriptor.puma"
 vard->alloc_shape[n-1][0] = alloc->SLICE_EXP.START;
      vard->alloc_shape[n-1][1] = alloc->SLICE_EXP.STOP;
    
# line 992 "VarDescriptor.puma"
   SetOverlap (formal->SHAPE_SPEC.Overlap, n, vard);
  }
   return;

  }
  }
# line 995 "VarDescriptor.puma"
  {
# line 997 "VarDescriptor.puma"
   failure2_protocol (MODULE, "SetAlloc1Shape", formal, alloc);
  }
   return;

;
}

static void SetOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree overlap, register int n, pvar vard)
# else
(overlap, n, vard)
 register tTree overlap;
 register int n;
 pvar vard;
# endif
{
  if (overlap->Kind == kOVERLAP_SPEC) {
# line 1006 "VarDescriptor.puma"
  {
# line 1008 "VarDescriptor.puma"
 vard->overlap[n-1][0]      = overlap->OVERLAP_SPEC.left_size;
      vard->overlap[n-1][1]      = overlap->OVERLAP_SPEC.right_size;
      vard->selections[n-1]       = 0;
    
  }
   return;

  }
;
}

static void SetReplicated
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 1024 "VarDescriptor.puma"
  {
# line 1026 "VarDescriptor.puma"
 int i;

     

     vard->topology_obj   = GetDefaultTopology (0);
     vard->topology_rank  = 0;

     for (i=0; i<vard->formal_rank; i++)

        { vard->distribution_kind[i] = kSERIAL_DIM;
          vard->distribution_size[i] = NoTree;
          vard->template_dim[i] = i+1;
          vard->topology_dim[i] = 0;
          vard->align_mult[i] = 1;
          vard->align_add[i] = 0;
          vard->formal_shape[i][0] = vard->alloc_shape[i][0];
          vard->formal_shape[i][1] = vard->alloc_shape[i][1];
        }
   
  }
   return;

;
}

static void SetDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard)
# else
(d, vard)
 register tDefinitions d;
 pvar vard;
# endif
{
# line 1050 "VarDescriptor.puma"
  {
# line 1052 "VarDescriptor.puma"
   if (! ((d == NoDefinitions))) goto yyL1;
  {
# line 1054 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetDistribution - no reaching", NoTree);
  }
  }
   return;
yyL1:;

# line 1057 "VarDescriptor.puma"
  {
# line 1059 "VarDescriptor.puma"
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL2;
  {
# line 1061 "VarDescriptor.puma"
   SetReplicated (vard);
  }
  }
   return;
yyL2:;

  if (d->Kind == kReplicatedDistribution) {
# line 1064 "VarDescriptor.puma"
  {
# line 1066 "VarDescriptor.puma"
   SetReplicated (vard);
  }
   return;

  }
  if (d->Kind == kNodeDistribution) {
# line 1069 "VarDescriptor.puma"
  {
# line 1074 "VarDescriptor.puma"
 vard->topology_obj   = d->NodeDistribution.top_obj;
     vard->shared         = d->NodeDistribution.shared;

     if (d->NodeDistribution.top_obj == NoObject)
        vard->topology_rank  = NoDistributedDims (d->NodeDistribution.ArrayList);
       else
        vard->topology_rank  = VarRank (d->NodeDistribution.top_obj);

     if (vard->topology_rank > MAX_TORUS_RANK)

       { printf ("too many distributed dimensions, max = %d\n", 
                 MAX_TORUS_RANK);
         failure_protocol (MODULE, "SetDistribution", NoTree);
       }
   
# line 1090 "VarDescriptor.puma"
   SetDistDimList (d->NodeDistribution.ArrayList, vard);
  }
   return;

  }
  if (d->Kind == kRangeDistribution) {
# line 1093 "VarDescriptor.puma"
  {
# line 1097 "VarDescriptor.puma"
 int i;

     vard->shared         = d->RangeDistribution.shared;
     vard->topology_obj   = NoObject;
     vard->topology_rank  = NoDistributedDims (d->RangeDistribution.ArrayList);

     if (vard->topology_rank > MAX_TORUS_RANK)

       { printf ("too many distributed dimensions, max = %d\n", 
                 MAX_TORUS_RANK);
         failure_protocol (MODULE, "SetDistribution", NoTree);
       }

     

     vard->template_inherited = 1;

     

     for (i=0; i<vard->formal_rank; i++)

        { vard->formal_shape[i][0] = NoTree;
          vard->formal_shape[i][1] = NoTree;

          vard->on_range     [i][0] = vard->formal_shape[i][0];
          vard->on_range     [i][1] = vard->formal_shape[i][1];
        }
   
# line 1127 "VarDescriptor.puma"
   SetDistDimList (d->RangeDistribution.ArrayList, vard);
  }
   return;

  }
  if (d->Kind == kDeclDistribution) {
# line 1130 "VarDescriptor.puma"
  {
# line 1131 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetDistribution (still decl)", NoTree);
  }
   return;

  }
  if (d->Kind == kAlignDistribution) {
# line 1134 "VarDescriptor.puma"
  {
# line 1135 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetDistribution (align illegal)", NoTree);
  }
   return;

  }
  if (d->Kind == kDefaultDistribution) {
# line 1138 "VarDescriptor.puma"
  {
# line 1139 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetDistribution (default dist)", NoTree);
  }
   return;

  }
# line 1142 "VarDescriptor.puma"
  {
# line 1143 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetDistribution", NoTree);
  }
   return;

;
}

static void SetDistDimList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard)
# else
(d, vard)
 register tDefinitions d;
 pvar vard;
# endif
{
  if (d->Kind == kDIM_EMPTY) {
# line 1154 "VarDescriptor.puma"
   return;

  }
  if (d->Kind == kDIM_LIST) {
# line 1157 "VarDescriptor.puma"
  {
# line 1159 "VarDescriptor.puma"
   SetSimpleDistribution (d->DIM_LIST.Elem, vard);
# line 1160 "VarDescriptor.puma"
   SetDistDimList (d->DIM_LIST.Next, vard);
  }
   return;

  }
# line 1163 "VarDescriptor.puma"
  {
# line 1165 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetDistDimList", NoTree);
  }
   return;

;
}

static void SetSimpleDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard)
# else
(d, vard)
 register tDefinitions d;
 pvar vard;
# endif
{
  if (d->Kind == kSerialDimension) {
# line 1176 "VarDescriptor.puma"
  {
# line 1178 "VarDescriptor.puma"
 vard->distribution_kind [d->SerialDimension.dimension-1] = kSERIAL_DIM; 
     vard->distribution_size [d->SerialDimension.dimension-1] = NoTree; 
     vard->topology_dim [d->SerialDimension.dimension-1] = 0; 
     vard->template_dim [d->SerialDimension.dimension-1] = 0; 
     vard->align_add [d->SerialDimension.dimension-1]    = 0; 
     vard->align_mult [d->SerialDimension.dimension-1]   = 1; 
     vard->formal_shape [d->SerialDimension.dimension-1][0] = vard->alloc_shape[d->SerialDimension.dimension-1][0];
     vard->formal_shape [d->SerialDimension.dimension-1][1] = vard->alloc_shape[d->SerialDimension.dimension-1][1]; 
   
  }
   return;

  }
  if (d->Kind == kDistributedDimension) {
# line 1189 "VarDescriptor.puma"
  {
# line 1191 "VarDescriptor.puma"
 vard->distribution_kind [d->DistributedDimension.dimension-1] = d->DistributedDimension.kind;
     vard->distribution_size [d->DistributedDimension.dimension-1] = d->DistributedDimension.size;
     vard->topology_dim [d->DistributedDimension.dimension-1] = d->DistributedDimension.topology_dim; 
     vard->template_dim [d->DistributedDimension.dimension-1] = d->DistributedDimension.dimension;      
     vard->align_add [d->DistributedDimension.dimension-1]    = 0; 
     vard->align_mult [d->DistributedDimension.dimension-1]   = 1; 

     vard->formal_shape [d->DistributedDimension.dimension-1][0] = vard->alloc_shape[d->DistributedDimension.dimension-1][0]; 
     vard->formal_shape [d->DistributedDimension.dimension-1][1] = vard->alloc_shape[d->DistributedDimension.dimension-1][1]; 

     

     vard->on_index_dim [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.dimension;
     vard->on_temp_dim  [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.dimension;
     vard->on_kind      [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.kind;
     vard->on_size      [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.size;
     vard->on_val       [d->DistributedDimension.topology_dim-1]    = NoTree;
     vard->on_range     [d->DistributedDimension.topology_dim-1][0] = vard->formal_shape[d->DistributedDimension.dimension-1][0];
     vard->on_range     [d->DistributedDimension.topology_dim-1][1] = vard->formal_shape[d->DistributedDimension.dimension-1][1];

   
  }
   return;

  }
# line 1214 "VarDescriptor.puma"
  {
# line 1216 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetSimpleDistribution", NoTree);
  }
   return;

;
}

static int NoDistributedDims
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dlist)
# else
(dlist)
 register tDefinitions dlist;
# endif
{
  if (dlist->Kind == kDIM_EMPTY) {
# line 1227 "VarDescriptor.puma"
   return 0;

  }
  if (dlist->Kind == kDIM_LIST) {
  if (dlist->DIM_LIST.Elem->Kind == kDistributedDimension) {
# line 1232 "VarDescriptor.puma"
   return NoDistributedDims (dlist->DIM_LIST.Next) + 1;

  }
# line 1237 "VarDescriptor.puma"
   return NoDistributedDims (dlist->DIM_LIST.Next);

  }
 yyAbort ("NoDistributedDims");
}

static void SetAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
# line 1252 "VarDescriptor.puma"
  {
# line 1254 "VarDescriptor.puma"
   if (! ((d == NoDefinitions))) goto yyL1;
  {
# line 1256 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetAlignment - no reaching", NoTree);
  }
  }
   return;
yyL1:;

  if (d->Kind == kAlignDistribution) {
# line 1259 "VarDescriptor.puma"
  {
# line 1262 "VarDescriptor.puma"
   if (! ((d->AlignDistribution.TargetList != d->AlignDistribution.SourceList))) goto yyL2;
  {
# line 1264 "VarDescriptor.puma"
 vard->topology_obj   = tempd->topology_obj;
     vard->topology_rank  = tempd->topology_rank;
     vard->template_obj   = d->AlignDistribution.template_obj;
     vard->template_rank  = VarRank (d->AlignDistribution.template_obj);
     vard->shared         = d->AlignDistribution.shared;
   
# line 1271 "VarDescriptor.puma"
   SetSourceAlignList (d->AlignDistribution.SourceList, tempd, vard);
# line 1272 "VarDescriptor.puma"
   SetTargetAlignList (d->AlignDistribution.TargetList, tempd, vard);
  }
  }
   return;
yyL2:;

  }
# line 1275 "VarDescriptor.puma"
  {
# line 1277 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetAlignment", NoTree);
  }
   return;

;
}

static void SetSourceAlignList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
  if (d->Kind == kDIM_EMPTY) {
# line 1288 "VarDescriptor.puma"
   return;

  }
  if (d->Kind == kDIM_LIST) {
# line 1291 "VarDescriptor.puma"
  {
# line 1293 "VarDescriptor.puma"
   SetSourceAlignment (d->DIM_LIST.Elem, tempd, vard);
# line 1294 "VarDescriptor.puma"
   SetSourceAlignList (d->DIM_LIST.Next, tempd, vard);
  }
   return;

  }
# line 1297 "VarDescriptor.puma"
  {
# line 1298 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetSourceAlignList", NoTree);
  }
   return;

;
}

static void SetSourceAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
  if (d->Kind == kSerialDimension) {
# line 1309 "VarDescriptor.puma"
  {
# line 1311 "VarDescriptor.puma"
 vard->distribution_kind [d->SerialDimension.dimension-1] = 0; 
     vard->distribution_size [d->SerialDimension.dimension-1] = NoTree; 
     vard->topology_dim [d->SerialDimension.dimension-1] = 0; 
     vard->template_dim [d->SerialDimension.dimension-1] = 0; 
     vard->align_add [d->SerialDimension.dimension-1]    = 0; 
     vard->align_mult [d->SerialDimension.dimension-1]   = 1; 
     vard->formal_shape [d->SerialDimension.dimension-1][0] = vard->alloc_shape[d->SerialDimension.dimension-1][0];
     vard->formal_shape [d->SerialDimension.dimension-1][1] = vard->alloc_shape[d->SerialDimension.dimension-1][1];
   
  }
   return;

  }
  if (d->Kind == kAlignedDimension) {
# line 1322 "VarDescriptor.puma"
  {
# line 1326 "VarDescriptor.puma"
 int kind;
     tTree size;     
     int selection;  
     int top_dim;
     bool found;
     int  val;

     kind      = tempd->distribution_kind [d->AlignedDimension.template_dim-1];
     size      = tempd->distribution_size [d->AlignedDimension.template_dim-1];
     top_dim   = tempd->topology_dim [d->AlignedDimension.template_dim-1];
     selection = tempd->selections [d->AlignedDimension.template_dim-1];

     vard->distribution_kind [d->AlignedDimension.dimension-1] = kind;
     vard->distribution_size [d->AlignedDimension.dimension-1] = size;

     vard->selections [d->AlignedDimension.dimension-1] = selection;

     vard->topology_dim [d->AlignedDimension.dimension-1] = top_dim; 
     vard->template_dim [d->AlignedDimension.dimension-1] = d->AlignedDimension.template_dim; 

     

     GetIntConstValue (d->AlignedDimension.add, &found, &val);
     vard->align_add  [d->AlignedDimension.dimension-1]   = val; 
     GetIntConstValue (d->AlignedDimension.mult, &found, &val);
     vard->align_mult [d->AlignedDimension.dimension-1]   = val; 

     vard->formal_shape [d->AlignedDimension.dimension-1][0] = tempd->formal_shape[d->AlignedDimension.template_dim-1][0];
     vard->formal_shape [d->AlignedDimension.dimension-1][1] = tempd->formal_shape[d->AlignedDimension.template_dim-1][1];

     if (top_dim > 0)

        { 

          vard->on_index_dim [top_dim-1]    = d->AlignedDimension.dimension;
          vard->on_temp_dim  [top_dim-1]    = d->AlignedDimension.template_dim;
          vard->on_kind      [top_dim-1]    = kind;
          vard->on_size      [top_dim-1]    = size;
          vard->on_val       [top_dim-1]    = NoTree;
          vard->on_range     [top_dim-1][0] = vard->formal_shape[d->AlignedDimension.dimension-1][0];
          vard->on_range     [top_dim-1][1] = vard->formal_shape[d->AlignedDimension.dimension-1][1];

        }
   
  }
   return;

  }
# line 1372 "VarDescriptor.puma"
  {
# line 1374 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetSourceAlignment", NoTree);
  }
   return;

;
}

static void SetTargetAlignList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
  if (d->Kind == kDIM_EMPTY) {
# line 1385 "VarDescriptor.puma"
   return;

  }
  if (d->Kind == kDIM_LIST) {
# line 1388 "VarDescriptor.puma"
  {
# line 1390 "VarDescriptor.puma"
   SetTargetAlignment (d->DIM_LIST.Elem, tempd, vard);
# line 1391 "VarDescriptor.puma"
   SetTargetAlignList (d->DIM_LIST.Next, tempd, vard);
  }
   return;

  }
# line 1394 "VarDescriptor.puma"
  {
# line 1396 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetTargetAlignList", NoTree);
  }
   return;

;
}

static void SetTargetAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
  if (d->Kind == kDistributedDimension) {
# line 1407 "VarDescriptor.puma"
   return;

  }
  if (d->Kind == kAlignedDimension) {
# line 1412 "VarDescriptor.puma"
   return;

  }
  if (d->Kind == kEmbeddedDimension) {
# line 1417 "VarDescriptor.puma"
  {
# line 1419 "VarDescriptor.puma"
 int kind;
    tTree size;
    int top_dim;

    kind    = tempd->distribution_kind [d->EmbeddedDimension.dimension-1];
    size    = tempd->distribution_size [d->EmbeddedDimension.dimension-1];
    top_dim = tempd->topology_dim [d->EmbeddedDimension.dimension-1];

    if (top_dim > 0)

     { 

       vard->on_index_dim [top_dim-1]    = 0;  
       vard->on_temp_dim  [top_dim-1]    = d->EmbeddedDimension.dimension;
       vard->on_kind      [top_dim-1]    = kind;
       vard->on_size      [top_dim-1]    = size;
       vard->on_val       [top_dim-1]    = d->EmbeddedDimension.val;
       vard->on_range     [top_dim-1][0] = tempd->alloc_shape[d->EmbeddedDimension.dimension-1][0];
       vard->on_range     [top_dim-1][1] = tempd->alloc_shape[d->EmbeddedDimension.dimension-1][1];

     }
  
  }
   return;

  }
  if (d->Kind == kReplicatedDimension) {
# line 1443 "VarDescriptor.puma"
  {
# line 1445 "VarDescriptor.puma"
 int kind;
    tTree size;
    int top_dim;

    kind    = tempd->distribution_kind [d->ReplicatedDimension.dimension-1];
    size    = tempd->distribution_size [d->ReplicatedDimension.dimension-1];
    top_dim = tempd->topology_dim [d->ReplicatedDimension.dimension-1];

    if (top_dim > 0)

     { 

       vard->on_index_dim [top_dim-1]    = 0;  
       vard->on_temp_dim  [top_dim-1]    = d->ReplicatedDimension.dimension;
       vard->on_kind      [top_dim-1]    = kind;
       vard->on_size      [top_dim-1]    = size;
       vard->on_val       [top_dim-1]    = NoTree;
       vard->on_range     [top_dim-1][0] = tempd->alloc_shape[d->ReplicatedDimension.dimension-1][0];
       vard->on_range     [top_dim-1][1] = tempd->alloc_shape[d->ReplicatedDimension.dimension-1][1];

     }
  
  }
   return;

  }
# line 1469 "VarDescriptor.puma"
  {
# line 1471 "VarDescriptor.puma"
   failure_protocol (MODULE, "SetTargetAlignment", NoTree);
  }
   return;

;
}

static void SetSelection
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar vard)
# else
(s, vard)
 register tTree s;
 pvar vard;
# endif
{
# line 1484 "VarDescriptor.puma"
  {
# line 1486 "VarDescriptor.puma"
   if (! ((s == NoTree))) goto yyL1;
  }
   return;
yyL1:;

# line 1489 "VarDescriptor.puma"
  {
# line 1491 "VarDescriptor.puma"
   SetSelectionList (s, vard, 1);
  }
   return;

;
}

static void SetSelectionList
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar vard, register int dim)
# else
(s, vard, dim)
 register tTree s;
 pvar vard;
 register int dim;
# endif
{
  if (s->Kind == kSELECT_LIST) {
# line 1496 "VarDescriptor.puma"
  {
# line 1500 "VarDescriptor.puma"
 if (s->SELECT_LIST.Elem->SELECT_SPEC.selector)
        vard->selections [dim-1] = s->SELECT_LIST.Elem->SELECT_SPEC.selector; 
   
# line 1504 "VarDescriptor.puma"
   SetSelectionList (s->SELECT_LIST.Next, vard, dim + 1);
  }
   return;

  }
  if (s->Kind == kSELECT_EMPTY) {
# line 1507 "VarDescriptor.puma"
   return;

  }
;
}

tTree MakeDescriptorVar
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 1542 "VarDescriptor.puma"
  {
# line 1544 "VarDescriptor.puma"
   if (! ((vard -> var_tree != NoTree))) goto yyL1;
  }
   return CopyTree (vard -> var_tree);
yyL1:;

# line 1549 "VarDescriptor.puma"
 {
  tTree var;
  {
# line 1551 "VarDescriptor.puma"
   if (! ((vard -> topology_obj != NoObject))) goto yyL2;
  {
# line 1555 "VarDescriptor.puma"
   if (! ((SameTopologyObject (vard -> topology_obj, GetDefaultTopology (0)) || SameTopologyObject (vard -> topology_obj, GetDefaultTopology (- 1))))) goto yyL2;
  {
# line 1559 "VarDescriptor.puma"
   if (! ((vard -> var_tree != NoTree))) goto yyL2;
  {
# line 1561 "VarDescriptor.puma"

# line 1563 "VarDescriptor.puma"
 if (vard->template_obj == NoObject)

       { var = mDUMMY_VAR (); }

     else

       { var = mVAR_OBJ (0, DefaultId());
         SetTemplateObject (var, vard->template_obj, vard->reach_info);
         var = mUSED_VAR (var);
       }
  
  }
  }
  }
  }
  {
   return var;
  }
 }
yyL2:;

# line 1578 "VarDescriptor.puma"
 {
  tTree var;
  {
# line 1580 "VarDescriptor.puma"

# line 1582 "VarDescriptor.puma"
 int tdim, rank;
    tTree il;
 
#ifdef DEBUG
    printf ("MakeDescriptorVar : \n");
    PrintVarDescriptor (vard);
#endif

    il = mBTE_EMPTY ();
 
    rank = vard->template_rank;
 
    for (tdim=rank; tdim>=1; tdim--)   
 
      { int idim, pdim;
        tTree index;

        idim = source_of_tempdim (vard, tdim);
        pdim = target_of_tempdim (vard, tdim);

        if (idim > 0)

           { int align_add, align_mult;
             tTree lb, ub, inc;

             lb  = vard->actual_shape[idim-1][0];
             ub  = vard->actual_shape[idim-1][1];
             inc = vard->actual_shape[idim-1][2];

             

             if (lb == NoTree) lb = mDUMMY_EXP ();
             if (ub == NoTree) ub = mDUMMY_EXP ();
             if (inc == NoTree) inc = mDUMMY_EXP ();

             align_add  = vard->align_add[idim-1];
             align_mult = vard->align_mult[idim-1];

             if (lb == ub)

                { index = TranslateActual (lb);
                  index = MultConstant (index, align_mult);
                  index = AddConstant  (index, align_add);
                }

              else
 
                { lb = MultConstant (lb, align_mult);
                  lb = AddConstant  (lb, align_add);
                  ub = MultConstant (ub, align_mult);
                  ub = AddConstant  (ub, align_add);

                  if (align_mult != 1)

                     { 
                       if (IsStride1 (inc))
                          inc = MakeConstant (align_mult);
                        else
                          inc = MultConstant (inc, align_mult);
                     }

                  index = mSLICE_EXP (lb, ub, inc);
                 
                } 
 
           } 

         else if (pdim > 0)

           { tTree val, range;

             val = vard->on_val [pdim-1];

             if (val == NoTree)
                index = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP(),mDUMMY_EXP());
               else
                index = CopyTree (val);
              
           }

         else 

           { 

             index = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP(),mDUMMY_EXP());

           }

        il = mBTE_LIST (index, il);

      }   

    if (vard->template_obj == NoObject)

       { var = mDUMMY_VAR (); }

     else

       { var = mVAR_OBJ (0, DefaultId());
         SetTemplateObject (var, vard->template_obj, vard->reach_info);
         var = mUSED_VAR (var);
       }
 
    var = mINDEXED_VAR (var, il);
 
  
  }
  {
   return var;
  }
 }

}

static int source_of_tempdim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int tdim)
# else
(vard, tdim)
 pvar vard;
 register int tdim;
# endif
{
# line 1698 "VarDescriptor.puma"
 {
  int idim;
  {
# line 1700 "VarDescriptor.puma"

# line 1702 "VarDescriptor.puma"
 int i, rank;

     idim = 0;
     rank = vard->formal_rank;
     for (i=0; i<rank; i++)
        if (vard->template_dim[i] == tdim)
           idim = i+1;
   
  }
  {
   return idim;
  }
 }

}

static int target_of_tempdim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int tdim)
# else
(vard, tdim)
 pvar vard;
 register int tdim;
# endif
{
# line 1720 "VarDescriptor.puma"
 {
  int pdim;
  {
# line 1722 "VarDescriptor.puma"

# line 1724 "VarDescriptor.puma"
 int i, rank;

     pdim = 0;
     rank = vard->topology_rank;
     for (i=0; i<rank; i++)
        if (vard->on_temp_dim[i] == tdim)
           pdim = i+1;
   
  }
  {
   return pdim;
  }
 }

}

static void SetTemplateObject
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tDefinitions tobj, register tTree rinfo)
# else
(v, tobj, rinfo)
 register tTree v;
 register tDefinitions tobj;
 register tTree rinfo;
# endif
{
  if (v->Kind == kVAR_OBJ) {
# line 1742 "VarDescriptor.puma"
  {
# line 1745 "VarDescriptor.puma"
   if (! ((rinfo == NoTree))) goto yyL1;
  {
# line 1747 "VarDescriptor.puma"
 v->VAR_OBJ.Ident     = tobj->Object.Ident;
     v->VAR_OBJ.Object      = tobj;
     v->VAR_OBJ.Reaching = NoTree;
   
  }
  }
   return;
yyL1:;

  if (rinfo->Kind == kREACHING_INFO) {
# line 1755 "VarDescriptor.puma"
  {
# line 1759 "VarDescriptor.puma"
 v->VAR_OBJ.Ident     = tobj->Object.Ident;
     v->VAR_OBJ.Object      = tobj;
     v->VAR_OBJ.Reaching = mREACHING_INFO (rinfo->REACHING_INFO.temp_allocate, rinfo->REACHING_INFO.temp_allocate, rinfo->REACHING_INFO.temp_distribution, rinfo->REACHING_INFO.temp_distribution);
   
  }
   return;

  }
  }
# line 1765 "VarDescriptor.puma"
  {
# line 1767 "VarDescriptor.puma"
   failure2_protocol (MODULE, "SetTemplateObject", v, rinfo);
  }
   return;

;
}

static tTree TranslateActual
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 1781 "VarDescriptor.puma"
  {
# line 1782 "VarDescriptor.puma"
   if (! ((exp == NoTree))) goto yyL1;
  }
   return exp;
yyL1:;

  if (exp->Kind == kLOOP_VAR) {
# line 1786 "VarDescriptor.puma"
   return mVAR_EXP (exp);

  }
# line 1790 "VarDescriptor.puma"
   return exp;

}

void PrintVarDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 1802 "VarDescriptor.puma"

int dim, rank;
char string[MAXID_LENGTH];

# line 1807 "VarDescriptor.puma"
  {
# line 1809 "VarDescriptor.puma"
 rank = vard->formal_rank;

    

    printf ("VarDescriptor of ");
    FileUnparse (stdout, vard->var_tree); 
    
    printf (" rank (actual=%d,formal=%d)", 
              vard->actual_rank, rank);
    if (vard->type_kind == kINTEGER_TYPE)
       printf (" INTEGER*%d\n", vard->type_size);
     else if (vard->type_kind == kREAL_TYPE)
       printf (" REAL*%d\n", vard->type_size);
     else if (vard->type_kind == kBOOLEAN_TYPE)
       printf (" LOGICAL*%d\n", vard->type_size);
     else if (vard->type_kind == kCOMPLEX_TYPE)
       printf (" COMPLEX*%d\n", vard->type_size);
     else 
       printf (" type kind = %d, size = %d\n", vard->type_kind,
                                               vard->type_size);

    printf ("  shared=%d, ", vard->shared);

    if (vard->template_obj == NoObject)

        printf ("no template ");

      else if (vard->template_obj == vard->var_obj)

        printf ("is own template");

      else
      
      { GetString (vard->template_obj->Object.Ident, string);
        printf ("aligned to template %s (rank=%d)",
                 string, vard->template_rank);
      }

    if (vard->topology_obj == NoObject)

        printf (" onto * (rank = %d)\n", vard->topology_rank);

      else
 
        { tIdent top_ident;

          top_ident = vard->topology_obj->Object.Ident;

          if (top_ident == DefaultId())

            printf (" onto default topology #%d\n", vard->topology_rank);

            else

             { GetString (vard->topology_obj->Object.Ident, string);
               printf (" onto topology %s (rank=%d)\n",
                        string, vard->topology_rank);
             }
        }

    for (dim=0; dim<rank; dim++)
      { printf ("  idim %d: ", dim+1);
        FileUnparse (stdout, vard->actual_shape[dim][0]);
        if (vard->actual_shape[dim][0] != vard->actual_shape[dim][1])
          { printf (":");
            FileUnparse (stdout, vard->actual_shape[dim][1]);
          }
        if (vard->actual_shape[dim][2] != NoTree)
          { printf (":");
            FileUnparse (stdout, vard->actual_shape[dim][2]);
          }

        if (vard->expanded)

           { 
             printf (" expanded to ");
             FileUnparse (stdout, vard->expand_shape[dim][0]);
             if (vard->expand_shape[dim][0] != vard->expand_shape[dim][1])
              { printf (":");
                FileUnparse (stdout, vard->expand_shape[dim][1]);
              }
           }

        

        printf (" (");
        FileUnparse (stdout, vard->alloc_shape[dim][0]);
        printf (":");
        FileUnparse (stdout, vard->alloc_shape[dim][1]);
        printf (")");

        

        printf (" align to tdim=%d : %d*I+%d (", 
                 vard->template_dim[dim], vard->align_mult[dim], 
                                          vard->align_add[dim]);

        FileUnparse (stdout, vard->formal_shape[dim][0]);
        printf (":");
        FileUnparse (stdout, vard->formal_shape[dim][1]);

        printf (") distr on pdim=%d", vard->topology_dim[dim]);

        if (vard->distribution_kind[dim] == kBLOCK_DIM) 
           printf (" block(k)");
        if (vard->distribution_kind[dim] == kGEN_BLOCK_DIM) 
           printf (" gen_block(ISIZE)");
        if (vard->distribution_kind[dim] == kSERIAL_DIM) 
           printf (" serial");
        if (vard->distribution_kind[dim] == kCYCLIC_DIM) 
           { printf (" cyclic(");
             FileUnparse (stdout, vard->distribution_size[dim]);
             printf (")");
           }
        if (vard->distribution_kind[dim] == kINDIRECT_DIM) 
           printf (" indirect(MAP)");
        if (vard->distribution_kind[dim] == kANY_BLOCK_DIM) 
           printf (" block()");
        if (vard->distribution_kind[dim] == kANY_CYCLIC_DIM) 
           printf (" cyclic()");
        if (vard->distribution_kind[dim] == kANY_GEN_BLOCK_DIM) 
           printf (" gen_block()");
        if (vard->distribution_kind[dim] == kANY_INDIRECT_DIM) 
           printf (" indirect()");
        if (vard->distribution_kind[dim] == kANY_DISTRIBUTED_DIM) 
           printf (" all");

        if (vard->selections[dim] & kSELECT_VECTOR)
           printf (" vector");
        if (vard->selections[dim] & kSELECT_NOVECTOR)
           printf (" novector");
        if (vard->selections[dim] & kSELECT_SHORT)
           printf (" short");
        if (vard->selections[dim] & kSELECT_EXPAND)
           printf (" expand");
        if (vard->selections[dim] & kSELECT_CONCUR)
           printf (" concur");
        if (vard->selections[dim] & kSELECT_NOCONCUR)
           printf (" noconcur");

        printf ("\n");
      }

    rank = vard->topology_rank;  

    for (dim=0; dim<rank; dim++)
     { printf ("  pdim %d : -> index_dim %d temp_dim %d", 
               dim+1, vard->on_index_dim[dim], vard->on_temp_dim[dim]);
       printf (" range : ");
       FileUnparse (stdout, vard->on_range[dim][0]);
       printf ("-");
       FileUnparse (stdout, vard->on_range[dim][1]);
       if (vard->on_val[dim] != NoTree)
         { printf (" on value : "); 
           FileUnparse (stdout, vard->on_val[dim]);
         }
       printf ("\n");
     }
   
  }
   return;

;
}

static void PrintReachingInfo
# if defined __STDC__ | defined __cplusplus
(register tTree rinfo)
# else
(rinfo)
 register tTree rinfo;
# endif
{
# line 1979 "VarDescriptor.puma"
  {
# line 1980 "VarDescriptor.puma"
   if (! ((rinfo == NoTree))) goto yyL1;
  {
# line 1982 "VarDescriptor.puma"
   printf ("no reaching info\n");
  }
  }
   return;
yyL1:;

  if (rinfo->Kind == kREACHING_INFO) {
# line 1985 "VarDescriptor.puma"
  {
# line 1987 "VarDescriptor.puma"
   printf ("reaching info \n ");
# line 1988 "VarDescriptor.puma"
   printf (" size var  ");
# line 1988 "VarDescriptor.puma"
   FileUnparse (stdout, rinfo->REACHING_INFO.var_allocate);
# line 1988 "VarDescriptor.puma"
   printf ("\n");
# line 1989 "VarDescriptor.puma"
   printf (" size temp ");
# line 1989 "VarDescriptor.puma"
   FileUnparse (stdout, rinfo->REACHING_INFO.temp_allocate);
# line 1989 "VarDescriptor.puma"
   printf ("\n");
# line 1991 "VarDescriptor.puma"
   SemFile = stdout;
# line 1993 "VarDescriptor.puma"
   printf (" dist var  ");
# line 1993 "VarDescriptor.puma"
   ShowDistribution (rinfo->REACHING_INFO.var_distribution);
# line 1993 "VarDescriptor.puma"
   printf ("\n");
# line 1994 "VarDescriptor.puma"
   printf (" dist temp ");
# line 1994 "VarDescriptor.puma"
   ShowDistribution (rinfo->REACHING_INFO.temp_distribution);
# line 1994 "VarDescriptor.puma"
   printf ("\n");
  }
   return;

  }
;
}

int GetFormalDim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim)
# else
(vard, dim)
 pvar vard;
 register int dim;
# endif
{
# line 2005 "VarDescriptor.puma"
   return LocalGetFormalDim (vard, dim);

}

void BeginVarDescriptor ()
{
}

void CloseVarDescriptor ()
{
}
