# include "VarComm.h"
# include "yyVarComm.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 35 "VarComm.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Nesting.h"
# include "ParNest.h"

# include "Descriptor.h"
# include "Extraction.h"

# include "IndShadow.h"
# include "MoveDescriptor.h"
# include "StrUnparse.h"
# include "Loops.h"

# define MODULE "VarComm"



static void yyExit () { Exit (1); }

void (* VarComm_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VarComm, routine %s failed\n", yyFunction);
 VarComm_Exit ();
}

bool IsLocalVarRead ARGS((tTree var, pvar home));
tTree CheckReadComm ARGS((tTree read_var, pvar home));
bool IsLocalVarWrite ARGS((tTree var, pvar home));
tTree CheckWriteComm ARGS((tTree write_var, pvar home));
bool IsLocalVarGlobal ARGS((tTree var, pvar home));
tTree CheckReductionComm ARGS((tTree red_var, pvar home));
static tTree CheckExtraction ARGS((tTree var, bool is_read));
static tTree CheckExtractionFrom ARGS((tTree var, bool is_read, tTree stmt));
static bool GoodCommunicationMask ARGS((tTree var, bool before));
static bool ExtractableMask ARGS((tTree stmt, tTree var, bool before));
static bool IsIfStmt ARGS((tTree stmt));
static bool IsRMAVar ARGS((tTree var));

bool IsLocalVarRead
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
# line 69 "VarComm.puma"
  {
# line 71 "VarComm.puma"
   return false;
  }

  }
# line 74 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 76 "VarComm.puma"

# line 78 "VarComm.puma"
   SetVarDescriptor (var, & vard);
# line 79 "VarComm.puma"
   if (! ((VDHasLocalCopy (home, & vard)))) goto yyL2;
  }
   return true;
 }
yyL2:;

# line 82 "VarComm.puma"
  {
# line 84 "VarComm.puma"
   if (! ((IsResidentVariable (var)))) goto yyL3;
  }
   return true;
yyL3:;

# line 87 "VarComm.puma"
  {
# line 89 "VarComm.puma"
   if (! ((IsNewVariable (var)))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

tTree CheckReadComm
# if defined __STDC__ | defined __cplusplus
(register tTree read_var, pvar home)
# else
(read_var, home)
 register tTree read_var;
 pvar home;
# endif
{
# line 105 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 107 "VarComm.puma"

# line 109 "VarComm.puma"
   SetVarDescriptor (read_var, & vard);
# line 110 "VarComm.puma"
   if (! ((VDHasLocalCopy (home, & vard)))) goto yyL1;
  }
  {
   return read_var;
  }
 }
yyL1:;

# line 115 "VarComm.puma"
  {
# line 117 "VarComm.puma"
   if (! ((IsResidentVariable (read_var)))) goto yyL2;
  {
# line 119 "VarComm.puma"
   tree_protocol ("NO COMMUNICATION (resident, read) needed for : ", read_var);
  }
  }
   return read_var;
yyL2:;

# line 124 "VarComm.puma"
  {
# line 126 "VarComm.puma"
   if (! ((IsNewVariable (read_var)))) goto yyL3;
  {
# line 128 "VarComm.puma"
   tree_protocol ("NO COMMUNICATION (resident, new) needed for : ", read_var);
  }
  }
   return read_var;
yyL3:;

# line 133 "VarComm.puma"
  {
# line 135 "VarComm.puma"
   if (! ((IsIndShadowVariable (read_var, home)))) goto yyL4;
  {
# line 137 "VarComm.puma"
   tree_protocol ("SHADOW COMMUNICATION (get) needed for : ", read_var);
  }
  }
   return read_var;
yyL4:;

# line 142 "VarComm.puma"
  {
# line 144 "VarComm.puma"
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, read_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (read %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
   return CheckExtraction (read_var, true);

}

bool IsLocalVarWrite
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
# line 166 "VarComm.puma"
  {
# line 168 "VarComm.puma"
   return false;
  }

  }
# line 171 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 173 "VarComm.puma"

# line 175 "VarComm.puma"
   SetVarDescriptor (var, & vard);
# line 176 "VarComm.puma"
   if (! ((VDIsSingleOwner (home, & vard)))) goto yyL2;
  }
   return true;
 }
yyL2:;

# line 179 "VarComm.puma"
  {
# line 181 "VarComm.puma"
   if (! ((IsNewVariable (var)))) goto yyL3;
  }
   return true;
yyL3:;

# line 184 "VarComm.puma"
  {
# line 186 "VarComm.puma"
   if (! ((IsResidentVariable (var)))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

tTree CheckWriteComm
# if defined __STDC__ | defined __cplusplus
(register tTree write_var, pvar home)
# else
(write_var, home)
 register tTree write_var;
 pvar home;
# endif
{
# line 204 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 206 "VarComm.puma"

# line 208 "VarComm.puma"
   SetVarDescriptor (write_var, & vard);
# line 209 "VarComm.puma"
   if (! ((VDIsSingleOwner (home, & vard)))) goto yyL1;
  }
  {
   return write_var;
  }
 }
yyL1:;

# line 218 "VarComm.puma"
  {
# line 220 "VarComm.puma"
   if (! ((IsNewVariable (write_var)))) goto yyL2;
  {
# line 222 "VarComm.puma"
   tree_protocol ("NO COMMUNICATION (write, new) for : ", write_var);
  }
  }
   return write_var;
yyL2:;

# line 227 "VarComm.puma"
  {
# line 233 "VarComm.puma"
   if (! ((IsResidentVariable (write_var)))) goto yyL3;
  {
# line 235 "VarComm.puma"
   tree_protocol ("NO COMMUNICATION (write, resident) for : ", write_var);
  }
  }
   return write_var;
yyL3:;

# line 240 "VarComm.puma"
  {
# line 242 "VarComm.puma"
   if (! ((IsIndShadowVariable (write_var, home)))) goto yyL4;
  {
# line 244 "VarComm.puma"
   tree_protocol ("SHADOW COMMUNICATION (write) needed for : ", write_var);
  }
  }
   return write_var;
yyL4:;

# line 249 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 255 "VarComm.puma"

# line 257 "VarComm.puma"
   SetVarDescriptor (write_var, & vard);
# line 258 "VarComm.puma"
   if (! ((VDIsOwner (home, & vard)))) goto yyL5;
  {
# line 260 "VarComm.puma"
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, write_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (broadcast %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
  }
  {
   return write_var;
  }
 }
yyL5:;

# line 273 "VarComm.puma"
  {
# line 275 "VarComm.puma"
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, write_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (write %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
   return CheckExtraction (write_var, false);

}

bool IsLocalVarGlobal
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
# line 297 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 299 "VarComm.puma"

# line 301 "VarComm.puma"
   SetVarDescriptor (var, & vard);
# line 302 "VarComm.puma"
   if (! ((VDIsOwner (home, & vard)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 305 "VarComm.puma"
  {
# line 307 "VarComm.puma"
   if (! ((IsNewVariable (var)))) goto yyL2;
  }
   return true;
yyL2:;

# line 310 "VarComm.puma"
  {
# line 312 "VarComm.puma"
   if (! ((IsResidentVariable (var)))) goto yyL3;
  }
   return true;
yyL3:;

  return false;
}

tTree CheckReductionComm
# if defined __STDC__ | defined __cplusplus
(register tTree red_var, pvar home)
# else
(red_var, home)
 register tTree red_var;
 pvar home;
# endif
{
# line 326 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 328 "VarComm.puma"

# line 330 "VarComm.puma"
   SetVarDescriptor (red_var, & vard);
# line 331 "VarComm.puma"
   if (! ((VDIsSingleOwner (home, & vard)))) goto yyL1;
  }
  {
   return red_var;
  }
 }
yyL1:;

# line 336 "VarComm.puma"
  {
# line 338 "VarComm.puma"
   if (! ((IsNewVariable (red_var)))) goto yyL2;
  {
# line 340 "VarComm.puma"
   warning_protocol ("reduction on NEW variable not possible");
  }
  }
   return red_var;
yyL2:;

# line 345 "VarComm.puma"
  {
# line 347 "VarComm.puma"
   if (! ((IsResidentVariable (red_var)))) goto yyL3;
  {
# line 349 "VarComm.puma"
   warning_protocol ("reduction on RESIDENT variable not possible");
  }
  }
   return red_var;
yyL3:;

# line 354 "VarComm.puma"
  {
# line 356 "VarComm.puma"
   if (! ((IsIndShadowVariable (red_var, home)))) goto yyL4;
  {
# line 358 "VarComm.puma"
   tree_protocol ("SHADOW COMMUNICATION (reduce) needed for : ", red_var);
  }
  }
   return red_var;
yyL4:;

# line 363 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 365 "VarComm.puma"

# line 367 "VarComm.puma"
   SetVarDescriptor (red_var, & vard);
# line 368 "VarComm.puma"
   if (! ((VDIsOwner (home, & vard)))) goto yyL5;
  {
# line 370 "VarComm.puma"
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, red_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (reduction %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
  }
  {
   return red_var;
  }
 }
yyL5:;

# line 399 "VarComm.puma"
  {
# line 401 "VarComm.puma"
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, red_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (scatter reduction %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
   return CheckExtraction (red_var, false);

}

static tTree CheckExtraction
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool is_read)
# else
(var, is_read)
 register tTree var;
 register bool is_read;
# endif
{
# line 441 "VarComm.puma"
 {
  tTree new_var;
  {
# line 443 "VarComm.puma"

# line 445 "VarComm.puma"
   if (! ((! IsExtractableVar (var, is_read, is_read)))) goto yyL1;
  {
# line 447 "VarComm.puma"
 stmt_protocol ("cannot extract communication (DEPENDENCES!!)");
     tree_protocol ("communication needed for ", var);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
  {
   return new_var;
  }
 }
yyL1:;

# line 461 "VarComm.puma"
 {
  tTree new_var;
  bool before;
  {
# line 463 "VarComm.puma"

# line 464 "VarComm.puma"

# line 466 "VarComm.puma"
   before = is_read;
# line 468 "VarComm.puma"
   if (! ((! GoodCommunicationMask (var, before)))) goto yyL2;
  {
# line 470 "VarComm.puma"
 stmt_protocol ("cannot extract communication (MASK!!)");
     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
  {
   return new_var;
  }
 }
yyL2:;

# line 482 "VarComm.puma"
 {
  tTree new_var;
  {
# line 484 "VarComm.puma"

# line 486 "VarComm.puma"
 int i, n;

     n = GetParNestingDepth ();

     new_var = var;

     for (i=1; i<=n; i++)

        new_var = CheckExtractionFrom (new_var, is_read, GetParNestACF(i));

   
  }
  {
   return new_var;
  }
 }

}

static tTree CheckExtractionFrom
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool is_read, register tTree stmt)
# else
(var, is_read, stmt)
 register tTree var;
 register bool is_read;
 register tTree stmt;
# endif
{
# line 512 "VarComm.puma"
  {
# line 514 "VarComm.puma"
   if (! ((var == NoTree))) goto yyL1;
  }
   return var;
yyL1:;

  if (var->Kind == kREMOTE_VAR) {
# line 519 "VarComm.puma"
   return var;

  }
  if (stmt->Kind == kACF_WHILE) {
# line 524 "VarComm.puma"
 {
  tTree new_var;
  {
# line 526 "VarComm.puma"

# line 528 "VarComm.puma"
 set_protocol_stmt (stmt);
     stmt_protocol ("cannot extract communication from DO WHILE loop");
     tree_protocol ("communication needed for : ", var);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  {
   return new_var;
  }
 }

  }
  if (stmt->Kind == kACF_FORALL) {
# line 539 "VarComm.puma"
 {
  tTree new_var;
  {
# line 541 "VarComm.puma"
   if (! ((! IsLoopInvariant (GetLoopSlice (stmt), GetParNestACF (1))))) goto yyL4;
  {
# line 543 "VarComm.puma"

# line 545 "VarComm.puma"
 tree_protocol ("cannot extract comm from FORALL loop (not rectangular)\n",
                     stmt);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
  {
   return new_var;
  }
 }
yyL4:;

  }
  if (stmt->Kind == kACF_DO) {
# line 555 "VarComm.puma"
 {
  tTree new_var;
  {
# line 557 "VarComm.puma"
   if (! ((! IsLoopInvariant (GetLoopSlice (stmt), GetParNestACF (1))))) goto yyL5;
  {
# line 559 "VarComm.puma"

# line 561 "VarComm.puma"
 tree_protocol ("cannot extract comm from DO loop (not rectangular):\n",
                    stmt);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
  {
   return new_var;
  }
 }
yyL5:;

  }
# line 573 "VarComm.puma"
   return var;

}

static bool GoodCommunicationMask
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool before)
# else
(var, before)
 register tTree var;
 register bool before;
# endif
{
# line 595 "VarComm.puma"
 {
  bool okay;
  {
# line 597 "VarComm.puma"

# line 599 "VarComm.puma"
 tTree SaveNest [50];
     int   i, n;
     int   masks;     

     okay  = true;
     n     = GetParNestingDepth ();
     masks = 0;    

     for (i=n; i>=1; i--)

        { tTree node;
          node = GetParNestACF (i);
          SaveNest[i-1] = node;
          DecParNesting (node);

          if (IsIfStmt (node))

           { if (masks) 

               { okay = false;  
                 stmt_protocol ("too many surrounding IF to extract comm");
               }

              else if (!ExtractableMask (node, var, before))
               
               { okay = false;
                 tree_protocol ("cannot extract mask of this IF stmt:\n", node);
               }

              else masks++;

           } 

        }

     

     for (i=1; i<=n; i++) IncParNesting (SaveNest[i-1]);

   
# line 640 "VarComm.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool ExtractableMask
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree var, register bool before)
# else
(stmt, var, before)
 register tTree stmt;
 register tTree var;
 register bool before;
# endif
{
  if (stmt->Kind == kACF_IF) {
  if (stmt->ACF_IF.IF_EXP->Kind == kVAR_EXP) {
# line 645 "VarComm.puma"
 {
  bool is_read;
  {
# line 647 "VarComm.puma"

# line 649 "VarComm.puma"
   is_read = true;
# line 651 "VarComm.puma"
   if (! ((IsExtractableVar (stmt->ACF_IF.IF_EXP->VAR_EXP.V, is_read, before)))) goto yyL1;
  }
   return true;
 }
yyL1:;

  }
# line 654 "VarComm.puma"
  {
# line 656 "VarComm.puma"
   return false;
  }

  }
  return false;
}

static bool IsIfStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_IF) {
# line 665 "VarComm.puma"
   return true;

  }
  return false;
}

static bool IsRMAVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 676 "VarComm.puma"
 {
  var_descriptor vard;
  {
# line 678 "VarComm.puma"

# line 680 "VarComm.puma"
   SetVarDescriptor (var, & vard);
# line 682 "VarComm.puma"
   if (! ((vard . shared == 2))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

void BeginVarComm ()
{
}

void CloseVarComm ()
{
}
