# include "UserFunctions.h"
# include "yyUserFunctions.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 20 "UserFunctions.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Types.h"      /* ...           */
# include "DefTable.h" 
# include "Transform.h"  /* ExpToVarParam */
# include "Inquiry.h" 
# include "Objects.h"    /* IsVar...      */

# include "Nesting.h"    /* GetCurrentUnitObj */

# define MODULE "UserFunctions"



static void yyExit () { Exit (1); }

void (* UserFunctions_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module UserFunctions, routine %s failed\n", yyFunction);
 UserFunctions_Exit ();
}

tTree TranslateUserFunction ARGS((tTree t));
static void ChangeFuncObject ARGS((tDefinitions p, tTree p_decl));
void ActualizeExpression ARGS((tTree exp, tTree call, bool * yyP2, tTree * yyP1));
static tDefinitions GetCalleeScope ARGS((tTree call));
static tTree GetCallFormals ARGS((tDefinitions pobj));
static tTree GetActualArgument ARGS((tDefinitions formal, tTree call));
static tTree Search ARGS((tIdent id, tTree formals, tTree actuals));
static tTree Replace ARGS((tTree exp, tTree param));
static tTree GetConstantValue ARGS((tDefinitions obj));

tTree TranslateUserFunction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_DECL) {
# line 49 "UserFunctions.puma"
 {
  tTree p_decl;
  {
# line 51 "UserFunctions.puma"

# line 53 "UserFunctions.puma"
 t->FUNC_DECL.FORMALS = mDECL_LIST (mVAR_PARAM_DECL (t->FUNC_DECL.RESULT_ID, 0, mDUMMY_TYPE ()), 
                           t->FUNC_DECL.FORMALS);
     p_decl = mPROC_DECL (t->FUNC_DECL.Ident, t->FUNC_DECL.Line, t->FUNC_DECL.FORMALS, t->FUNC_DECL.FUNC_BODY);

     p_decl->PROC_DECL.IsRecursive  = t->FUNC_DECL.IsRecursive;
     p_decl->PROC_DECL.IsPure       = t->FUNC_DECL.IsPure;
     p_decl->PROC_DECL.HPFExtrinsic = t->FUNC_DECL.HPFExtrinsic;

     

     p_decl->UNIT_NODE.Object = t->FUNC_DECL.Object;

   
# line 67 "UserFunctions.puma"
   ChangeFuncObject (t->FUNC_DECL.Object, p_decl);
  }
  {
   return p_decl;
  }
 }

  }
# line 72 "UserFunctions.puma"
  {
# line 73 "UserFunctions.puma"
   failure_protocol (MODULE, "TranslateUserFunction", t);
  }
   return NoTree;

}

static void ChangeFuncObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions p, register tTree p_decl)
# else
(p, p_decl)
 register tDefinitions p;
 register tTree p_decl;
# endif
{
# line 79 "UserFunctions.puma"
  {
# line 80 "UserFunctions.puma"
   if (! ((p == NoObject))) goto yyL1;
  {
# line 81 "UserFunctions.puma"
   failure_protocol (MODULE, "ChangeFuncObject: no object", p_decl);
  }
  }
   return;
yyL1:;

  if (p->Kind == kFuncObject) {
  if (p_decl->Kind == kPROC_DECL) {
# line 84 "UserFunctions.puma"
  {
# line 86 "UserFunctions.puma"
 p->FuncObject.decl  = p_decl;
     p->Kind = kProcObject; 
   
  }
   return;

  }
  }
# line 91 "UserFunctions.puma"
  {
# line 92 "UserFunctions.puma"
   failure_protocol (MODULE, "ChangeFuncObject: illegal object", p_decl);
  }
   return;

;
}

void ActualizeExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree call, register bool * yyP2, register tTree * yyP1)
# else
(exp, call, yyP2, yyP1)
 register tTree exp;
 register tTree call;
 register bool * yyP2;
 register tTree * yyP1;
# endif
{
# line 111 "UserFunctions.puma"
  {
# line 113 "UserFunctions.puma"
   if (! ((exp == NoTree))) goto yyL1;
  }
   * yyP2 = false;
   * yyP1 = NoTree;
   return;
yyL1:;


  switch (exp->Kind) {
  case kOP_EXP:
# line 118 "UserFunctions.puma"
 {
  tTree new;
  bool yyV1;
  tTree yyV2;
  bool yyV3;
  tTree yyV4;
  {
# line 120 "UserFunctions.puma"

# line 122 "UserFunctions.puma"
   ActualizeExpression (exp->OP_EXP.OPND1, call, & yyV1, & yyV2);
# line 123 "UserFunctions.puma"
   ActualizeExpression (exp->OP_EXP.OPND2, call, & yyV3, & yyV4);
# line 125 "UserFunctions.puma"
   new = mOP_EXP (CopyTree (exp->OP_EXP.EXP_OP), yyV2, yyV4);
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = new;
   return;
 }

  case kOP1_EXP:
# line 128 "UserFunctions.puma"
 {
  tTree new;
  bool yyV1;
  tTree yyV2;
  {
# line 130 "UserFunctions.puma"

# line 132 "UserFunctions.puma"
   ActualizeExpression (exp->OP1_EXP.OPND, call, & yyV1, & yyV2);
# line 134 "UserFunctions.puma"
   new = mOP1_EXP (CopyTree (exp->OP1_EXP.EXP_OP1), yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = new;
   return;
 }

  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kUSED_VAR) {
# line 137 "UserFunctions.puma"
 {
  tTree new;
  {
# line 141 "UserFunctions.puma"
   if (! ((GetDeclEntry (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, GetCalleeScope (call)) == exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object))) goto yyL4;
  {
# line 142 "UserFunctions.puma"
   if (! ((IsVarDummy (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL4;
  {
# line 144 "UserFunctions.puma"

# line 146 "UserFunctions.puma"
   new = Replace (exp, GetActualArgument (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object, call));
  }
  }
  }
   * yyP2 = true;
   * yyP1 = new;
   return;
 }
yyL4:;

# line 149 "UserFunctions.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 153 "UserFunctions.puma"
   if (! ((GetDeclEntry (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, GetCalleeScope (call)) == exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object))) goto yyL5;
  {
# line 154 "UserFunctions.puma"
   if (! ((IsVarParameter (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL5;
  {
# line 156 "UserFunctions.puma"
   ActualizeExpression (GetConstantValue (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object), call, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

# line 159 "UserFunctions.puma"
  {
# line 164 "UserFunctions.puma"
   if (! ((exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object == GetLocalObject (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident)))) goto yyL6;
  }
   * yyP2 = true;
   * yyP1 = CopyTree (exp);
   return;
yyL6:;

# line 167 "UserFunctions.puma"
   * yyP2 = false;
   * yyP1 = NoTree;
   return;

  }
  break;
  case kCONST_EXP:
# line 170 "UserFunctions.puma"
   * yyP2 = true;
   * yyP1 = CopyTree (exp);
   return;

  case kFUNC_CALL_EXP:
# line 173 "UserFunctions.puma"
 {
  tTree new;
  bool yyV1;
  tTree yyV2;
  {
# line 177 "UserFunctions.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL9;
  {
# line 179 "UserFunctions.puma"

# line 181 "UserFunctions.puma"
   ActualizeExpression (exp->FUNC_CALL_EXP.FUNC_PARAMS, call, & yyV1, & yyV2);
# line 183 "UserFunctions.puma"
   new = mFUNC_CALL_EXP (CopyTree (exp->FUNC_CALL_EXP.FUNC_ID), yyV2);
# line 187 "UserFunctions.puma"
   new = TranslateInquiryCall (new);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = new;
   return;
 }
yyL9:;

  break;
  case kBTP_LIST:
# line 190 "UserFunctions.puma"
 {
  tTree new;
  bool yyV1;
  tTree yyV2;
  bool yyV3;
  tTree yyV4;
  {
# line 192 "UserFunctions.puma"

# line 194 "UserFunctions.puma"
   ActualizeExpression (exp->BTP_LIST.Elem, call, & yyV1, & yyV2);
# line 195 "UserFunctions.puma"
   ActualizeExpression (exp->BTP_LIST.Next, call, & yyV3, & yyV4);
# line 197 "UserFunctions.puma"
   new = mBTP_LIST (yyV2, yyV4);
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = new;
   return;
 }

  case kBTP_EMPTY:
# line 200 "UserFunctions.puma"
   * yyP2 = true;
   * yyP1 = mBTP_EMPTY ();
   return;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
# line 203 "UserFunctions.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 205 "UserFunctions.puma"
   ActualizeExpression (exp->VAR_PARAM.V->ADDR.E, call, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = ExpToVarParam (yyV2);
   return;
 }

  }
# line 208 "UserFunctions.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 210 "UserFunctions.puma"
   ActualizeExpression (mVAR_EXP (exp->VAR_PARAM.V), call, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = ExpToVarParam (yyV2);
   return;
 }

  case kNO_PARAM:
# line 213 "UserFunctions.puma"
   * yyP2 = true;
   * yyP1 = CopyTree (exp);
   return;

  }

# line 216 "UserFunctions.puma"
   * yyP2 = false;
   * yyP1 = NoTree;
   return;

;
}

static tDefinitions GetCalleeScope
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kFUNC_CALL_EXP) {
  if (call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object->Kind == kFuncObject) {
# line 229 "UserFunctions.puma"
   return call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object->FuncObject.Declarations;

  }
  }
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_ID->PROC_OBJ.Object->Kind == kProcObject) {
# line 233 "UserFunctions.puma"
   return call->CALL_STMT.CALL_ID->PROC_OBJ.Object->ProcObject.Declarations;

  }
  }
# line 237 "UserFunctions.puma"
  {
# line 238 "UserFunctions.puma"
   failure_protocol (MODULE, "GetCalleeScope", call);
  }
   return NoDefinitions;

}

static tTree GetCallFormals
# if defined __STDC__ | defined __cplusplus
(register tDefinitions pobj)
# else
(pobj)
 register tDefinitions pobj;
# endif
{
  if (pobj->Kind == kFuncObject) {
  if (pobj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 252 "UserFunctions.puma"
   return pobj->FuncObject.decl->FUNC_DECL.FORMALS;

  }
  }
  if (pobj->Kind == kProcObject) {
  if (pobj->ProcObject.decl->Kind == kPROC_DECL) {
# line 256 "UserFunctions.puma"
   return pobj->ProcObject.decl->PROC_DECL.FORMALS;

  }
  }
# line 260 "UserFunctions.puma"
  {
# line 261 "UserFunctions.puma"
   failure_protocol (MODULE, "GetCallFormals", pobj->Object.decl);
  }
   return NoTree;

}

static tTree GetActualArgument
# if defined __STDC__ | defined __cplusplus
(register tDefinitions formal, register tTree call)
# else
(formal, call)
 register tDefinitions formal;
 register tTree call;
# endif
{
  if (call->Kind == kFUNC_CALL_EXP) {
# line 275 "UserFunctions.puma"
   return Search (formal->Object.Ident, GetCallFormals (call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object), call->FUNC_CALL_EXP.FUNC_PARAMS);

  }
  if (call->Kind == kCALL_STMT) {
# line 280 "UserFunctions.puma"
   return Search (formal->Object.Ident, GetCallFormals (call->CALL_STMT.CALL_ID->PROC_OBJ.Object), call->CALL_STMT.CALL_PARAMS);

  }
# line 285 "UserFunctions.puma"
  {
# line 286 "UserFunctions.puma"
   failure_protocol (MODULE, "GetActualArgument", call);
  }
   return NoTree;

}

static tTree Search
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree formals, register tTree actuals)
# else
(id, formals, actuals)
 register tIdent id;
 register tTree formals;
 register tTree actuals;
# endif
{
  if (formals->Kind == kDECL_LIST) {
  if (formals->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
  if (actuals->Kind == kBTP_LIST) {
# line 292 "UserFunctions.puma"
  {
# line 293 "UserFunctions.puma"
   if (! ((id == formals->DECL_LIST.Elem->VAR_PARAM_DECL.Ident))) goto yyL1;
  }
   return actuals->BTP_LIST.Elem;
yyL1:;

  }
  }
  if (actuals->Kind == kBTP_LIST) {
# line 297 "UserFunctions.puma"
   return Search (id, formals->DECL_LIST.Next, actuals->BTP_LIST.Next);

  }
  }
# line 301 "UserFunctions.puma"
  {
# line 302 "UserFunctions.puma"
   failure_protocol (MODULE, "Search", formals);
  }
   return NoTree;

}

static tTree Replace
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree param)
# else
(exp, param)
 register tTree exp;
 register tTree param;
# endif
{
  if (exp->Kind == kVAR_EXP) {
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 316 "UserFunctions.puma"
   return CopyTree (param->VAR_PARAM.V->ADDR.E);

  }
# line 320 "UserFunctions.puma"
   return mVAR_EXP (CopyTree (param->VAR_PARAM.V));

  }
  }
# line 324 "UserFunctions.puma"
  {
# line 325 "UserFunctions.puma"
   failure2_protocol (MODULE, "Replace", exp, param);
  }
   return NoTree;

}

static tTree GetConstantValue
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarParameter) {
# line 331 "UserFunctions.puma"
   return obj->VarObject.Kind->VarParameter.Val;

  }
  }
# line 335 "UserFunctions.puma"
  {
# line 336 "UserFunctions.puma"
   failure_protocol (MODULE, "GetConstantValue", obj->Object.decl);
  }
   return NoTree;

}

void BeginUserFunctions ()
{
}

void CloseUserFunctions ()
{
}
