# include "Unparse.h"
# include "yyUnparse.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 26 "FUnparse.puma"


# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"

# define IndentLength 3    /* indent for nested statements */

# define LineFlag    0     /* 1 prints line comments */
# define CombineFlag 0     /* 1 combines syntax      */

static FILE *f;
static int  indent;

char string[1024];  /* might be very long */

/***********************************************************************
*                                                                      *
*  PROCEDURE FileUnparse (FILE *ef, t : Tree)  - unparsing AST on file *
*                                                                      *
***********************************************************************/

void FileUnparse (ef, t)
FILE *ef;
tTree t;
{ FILE *h;
  h = f;      /* save local file pointer */
  f = ef;     /* set external file */
  Unparse (t);
  f = h;
}

void ind ()
{ int i;
  for (i=0;i<indent+6;i++)
     fprintf (f," ");
}

     /********************************************************
     *                                                       *
     ********************************************************/

void hpf_ind ()

{ int i;
  fprintf (f, "!hpf$ ");
  for (i=6;i<indent+6;i++) fprintf (f," ");

} /* hpf_ind */

     /********************************************************
     *                                                       *
     *  !$OMP      Open MP sm parallel directive             *
     *  !MIC$      CRAY MP sm parallel directive             *
     *  C$PAR .... shared memory parallelization directive   *
     *                                                       *
     ********************************************************/

void par_ind ()

{ int i;

  if (sm_parallelization == OPEN_MP) fprintf (f, "!$OMP ");
   else if (sm_parallelization == CRAY_MP) fprintf (f, "!MIC$ ");
   else fprintf (f, "C$PAR ");
  for (i=6;i<indent+6;i++) fprintf (f," ");

} /* par_ind */

     /********************************************************
     *                                                       *
     ********************************************************/

void adp_ind ()

{ int i;
  fprintf (f, "!ADP$ ");

  for (i=6;i<indent+6;i++) fprintf (f," ");
} /* adp_ind */

     /********************************************************
     *                                                       *
     ********************************************************/

void label_ind (label)
int label;
{ int i;
  char name[100];

  if (label == 0) 
     ind ();
   else if (label < 0)
     { /* label stands for a name */
       for (i=0; i<indent+6;i++)
         fprintf (f," ");
       GetString (-label, name);
       fprintf (f,"%s: ", name);
     }
   else 
     { fprintf (f,"%4d  ",label);
       for (i=0; i<indent;i++)
       fprintf (f," ");
     }
}

void IncIndent () { indent += IndentLength; }
void DecIndent () { indent -= IndentLength; }

void cont_ind ()
{ int i;
  fprintf (f,"     $");
  for (i=0; i<indent;i++)
     fprintf (f," ");
}

void LCR (line)
int line;
{ if (LineFlag)
     fprintf (f," ! line=%d\n", line);
    else
     fprintf (f,"\n");
} /* LCR */

void MyPrintString (f, str)
FILE *f;
char *str;
{ char *spos;
  spos = str;
  while (*spos != 0)
   { if (*spos == '\'')
       fprintf (f, "\'\'");
      else
       fprintf (f, "%c", *spos);
     spos++;
   }
}



static void yyExit () { Exit (1); }

void (* Unparse_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Unparse, routine %s failed\n", yyFunction);
 Unparse_Exit ();
}

void Unparse ARGS((tTree t));
static int Priority ARGS((tTree yyP1));
static void ComUnparse ARGS((tTree t));
static void UnparseElse ARGS((tTree t));
static void UnparseDoRange ARGS((tTree slice));
static void ExpUnparse ARGS((tTree t, int leftprio, int rightprio));
static void OpUnparse ARGS((tTree t));
static void FormatUnparse ARGS((tTree t));
static void LayoutUnparse ARGS((tTree t));
static void ProcSpecUnparse ARGS((tTree t));
static bool IsDeferredShape ARGS((tTree t));
static int UP_List_Length ARGS((tTree t));
static void FormalParamUnparse ARGS((tTree t));
static void ParamUnparse ARGS((tTree t));
static void AttributeUnparse ARGS((tTree t));
static void AlignSpecUnparse ARGS((tTree t));
static void UseNameUnparse ARGS((tTree t));
static void GenSpecUnparse ARGS((tTree t));
static void CaseSelectorUnparse ARGS((tTree t));
static void OnSpecUnparse ARGS((tTree ontop, tTree onlist));
static void OnListUnparse ARGS((tTree list));
static bool MoreParameters ARGS((tTree parameterlist));
static void StatusUnparse ARGS((tTree status));
static void OverlapUnparse ARGS((tTree overlap));
static void DepInfoUnparse ARGS((tTree info));
static void HomeInfoUnparse ARGS((tTree info));
static void VecInfoUnparse ARGS((tTree dep_info));
static void SizeUnparse ARGS((tTree size));
static void EndUnparse ARGS((tTree t));
static void PrefixUnparse ARGS((tTree t));
static void DspKindUnparse ARGS((int kind));
static void HPFBodyUnparse ARGS((int line, tTree body, int kind));
static void ResidentUnparse ARGS((tTree resident_vars));
static void NewUnparse ARGS((tTree new_vars));
static void ResolveACFHome ARGS((tTree home_body, tTree * yyP4, tTree * yyP3, tTree * yyP2));
static bool IsDummyParam ARGS((tTree param));
static void SMParUnparse ARGS((tTree red_vars, tTree shared_vars, tTree local_vars));
static void SMVarUnparse ARGS((int kind, tTree var_list, bool cont));
static bool EmptyList ARGS((tTree var_list));
static void SMGetParLoop ARGS((tTree body, bool * yyP6, tTree * yyP5));
static void SelectorUnparse ARGS((int selector));

void Unparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 185 "FUnparse.puma"
  {
# line 187 "FUnparse.puma"
   if (! ((t == NoTree))) goto yyL1;
  {
# line 188 "FUnparse.puma"
   fprintf (f, "<NoTree>");
  }
  }
   return;
yyL1:;


  switch (t->Kind) {
  case kCOMP_UNIT:
# line 191 "FUnparse.puma"
  {
# line 193 "FUnparse.puma"
   Unparse (t->COMP_UNIT.COMP_ELEMENTS);
  }
   return;

  case kUNIT_LIST:
# line 196 "FUnparse.puma"
  {
# line 198 "FUnparse.puma"
   Unparse (t->UNIT_LIST.Elem);
# line 199 "FUnparse.puma"
   Unparse (t->UNIT_LIST.Next);
  }
   return;

  case kUNIT_EMPTY:
# line 202 "FUnparse.puma"
   return;

  case kDECL_LIST:
  if (t->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 211 "FUnparse.puma"
  {
# line 213 "FUnparse.puma"
   GetString (t->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, string);
# line 214 "FUnparse.puma"
   fprintf (f, "%s ", string);
  }
   return;

  }
# line 217 "FUnparse.puma"
  {
# line 219 "FUnparse.puma"
   GetString (t->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, string);
# line 220 "FUnparse.puma"
   fprintf (f, "%s, ", string);
# line 221 "FUnparse.puma"
   Unparse (t->DECL_LIST.Next);
  }
   return;

  }
# line 224 "FUnparse.puma"
  {
# line 226 "FUnparse.puma"
   Unparse (t->DECL_LIST.Elem);
# line 227 "FUnparse.puma"
   Unparse (t->DECL_LIST.Next);
  }
   return;

  case kDECL_EMPTY:
# line 230 "FUnparse.puma"
   return;

  case kPROGRAM_DECL:
# line 239 "FUnparse.puma"
  {
# line 242 "FUnparse.puma"
   ind ();
# line 243 "FUnparse.puma"
   GetString (t->PROGRAM_DECL.Ident, string);
# line 244 "FUnparse.puma"
   fprintf (f, "program %s", string);
# line 245 "FUnparse.puma"
   LCR (t->PROGRAM_DECL.Line);
# line 246 "FUnparse.puma"
   Unparse (t->PROGRAM_DECL.PROGRAM_BODY);
# line 247 "FUnparse.puma"
   EndUnparse (t);
# line 248 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kPROC_DECL:
# line 251 "FUnparse.puma"
  {
# line 253 "FUnparse.puma"
   ind ();
# line 254 "FUnparse.puma"
   PrefixUnparse (t);
# line 255 "FUnparse.puma"
   GetString (t->PROC_DECL.Ident, string);
# line 256 "FUnparse.puma"
   fprintf (f, "subroutine %s (", string);
# line 257 "FUnparse.puma"
   FormalParamUnparse (t->PROC_DECL.FORMALS);
# line 258 "FUnparse.puma"
   fprintf (f, ")");
# line 259 "FUnparse.puma"
   LCR (t->PROC_DECL.Line);
# line 260 "FUnparse.puma"
   Unparse (t->PROC_DECL.PROC_BODY);
# line 261 "FUnparse.puma"
   EndUnparse (t);
# line 262 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kFUNC_DECL:
# line 265 "FUnparse.puma"
  {
# line 268 "FUnparse.puma"
   ind ();
# line 269 "FUnparse.puma"
   PrefixUnparse (t);
# line 270 "FUnparse.puma"
   GetString (t->FUNC_DECL.Ident, string);
# line 271 "FUnparse.puma"
   fprintf (f, "function %s (", string);
# line 272 "FUnparse.puma"
   FormalParamUnparse (t->FUNC_DECL.FORMALS);
# line 273 "FUnparse.puma"
   fprintf (f, ")");
# line 274 "FUnparse.puma"
 if (t->FUNC_DECL.RESULT_ID != DefaultId())
        {  GetString (t->FUNC_DECL.RESULT_ID, string);
           fprintf (f," RESULT (%s)", string);
        }
   
# line 279 "FUnparse.puma"
   LCR (t->FUNC_DECL.Line);
# line 280 "FUnparse.puma"
   Unparse (t->FUNC_DECL.FUNC_BODY);
# line 281 "FUnparse.puma"
   EndUnparse (t);
# line 282 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kMODULE_DECL:
# line 285 "FUnparse.puma"
  {
# line 287 "FUnparse.puma"
   ind ();
# line 288 "FUnparse.puma"
   GetString (t->MODULE_DECL.Ident, string);
# line 289 "FUnparse.puma"
   fprintf (f, "module %s\n", string);
# line 290 "FUnparse.puma"
   Unparse (t->MODULE_DECL.MODULE_BODY);
# line 291 "FUnparse.puma"
   EndUnparse (t);
# line 292 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kMODULE_PROC_DECL:
# line 295 "FUnparse.puma"
  {
# line 297 "FUnparse.puma"
   ind ();
# line 298 "FUnparse.puma"
   GetString (t->MODULE_PROC_DECL.Ident, string);
# line 299 "FUnparse.puma"
   fprintf (f, "module procedure %s\n", string);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 302 "FUnparse.puma"
  {
# line 304 "FUnparse.puma"
   ind ();
# line 305 "FUnparse.puma"
   GetString (t->BLOCK_DATA_DECL.Ident, string);
# line 306 "FUnparse.puma"
   fprintf (f, "block data %s\n", string);
# line 307 "FUnparse.puma"
   Unparse (t->BLOCK_DATA_DECL.DATA_BODY);
# line 308 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kSTMT_FUNC_DECL:
# line 311 "FUnparse.puma"
  {
# line 313 "FUnparse.puma"
   ind ();
# line 314 "FUnparse.puma"
   GetString (t->STMT_FUNC_DECL.Ident, string);
# line 315 "FUnparse.puma"
   fprintf (f, "%s (", string);
# line 316 "FUnparse.puma"
   Unparse (t->STMT_FUNC_DECL.FORMALS);
# line 317 "FUnparse.puma"
   fprintf (f, ") = ");
# line 318 "FUnparse.puma"
   Unparse (t->STMT_FUNC_DECL.FFUNC_BODY);
# line 319 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

  case kEXTERNAL_DECL:
# line 322 "FUnparse.puma"
  {
# line 324 "FUnparse.puma"
   ind ();
# line 325 "FUnparse.puma"
   GetString (t->EXTERNAL_DECL.Ident, string);
# line 326 "FUnparse.puma"
   fprintf (f, "external %s\n", string);
  }
   return;

  case kINTRINSIC_DECL:
# line 329 "FUnparse.puma"
  {
# line 331 "FUnparse.puma"
   ind ();
# line 332 "FUnparse.puma"
   GetString (t->INTRINSIC_DECL.Ident, string);
# line 333 "FUnparse.puma"
   fprintf (f, "intrinsic %s\n", string);
  }
   return;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
  if (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
# line 342 "FUnparse.puma"
  {
# line 344 "FUnparse.puma"
   ind ();
# line 346 "FUnparse.puma"
 if (FortranAllocatable() && IsDeferredShape (t->VAR_DECL.VAL))
     {  fprintf (f,"allocatable :: ");
        GetString (t->VAR_DECL.Ident, string);
        fprintf (f," %s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
     else
     {  fprintf (f,"dimension ");
        GetString (t->VAR_DECL.Ident, string);
        fprintf (f,"%s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
   
  }
   return;

  }
# line 365 "FUnparse.puma"
  {
# line 367 "FUnparse.puma"
   ind ();
# line 368 "FUnparse.puma"
   Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE);
# line 370 "FUnparse.puma"
 if (FortranAllocatable() && IsDeferredShape (t->VAR_DECL.VAL))
     {  fprintf (f,", allocatable :: ");
        GetString (t->VAR_DECL.Ident, string);
        fprintf (f," %s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
     else
     {  GetString (t->VAR_DECL.Ident, string);
        fprintf (f," %s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
   
  }
   return;

  }
# line 388 "FUnparse.puma"
  {
# line 390 "FUnparse.puma"
   ind ();
# line 391 "FUnparse.puma"
   Unparse (t->VAR_DECL.VAL);
# line 392 "FUnparse.puma"
   GetString (t->VAR_DECL.Ident, string);
# line 393 "FUnparse.puma"
   fprintf (f, " %s", string);
# line 394 "FUnparse.puma"
   LCR (t->VAR_DECL.Line);
  }
   return;

  case kVAR_PARAM_DECL:
# line 397 "FUnparse.puma"
  {
# line 399 "FUnparse.puma"
   ind ();
# line 400 "FUnparse.puma"
   Unparse (t->VAR_PARAM_DECL.VAL);
# line 401 "FUnparse.puma"
   GetString (t->VAR_PARAM_DECL.Ident, string);
# line 402 "FUnparse.puma"
   fprintf (f, " %s", string);
# line 403 "FUnparse.puma"
   LCR (t->VAR_PARAM_DECL.Line);
  }
   return;

  case kENTITY_DECL:
  if (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem->Kind == kTYPESPEC_DECL) {
# line 406 "FUnparse.puma"
  {
# line 408 "FUnparse.puma"
   ind ();
# line 409 "FUnparse.puma"
   Unparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
# line 410 "FUnparse.puma"
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Next);
# line 411 "FUnparse.puma"
   GetString (t->ENTITY_DECL.Ident, string);
# line 412 "FUnparse.puma"
   fprintf (f, " :: %s", string);
# line 413 "FUnparse.puma"
   LCR (t->ENTITY_DECL.Line);
  }
   return;

  }
# line 416 "FUnparse.puma"
  {
# line 418 "FUnparse.puma"
   fprintf (f, "!HPF$ ");
# line 419 "FUnparse.puma"
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem);
# line 420 "FUnparse.puma"
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Next);
# line 421 "FUnparse.puma"
   GetString (t->ENTITY_DECL.Ident, string);
# line 422 "FUnparse.puma"
   fprintf (f, " :: %s", string);
# line 423 "FUnparse.puma"
   LCR (t->ENTITY_DECL.Line);
  }
   return;

  case kTEMPLATE_DECL:
  if (t->TEMPLATE_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
# line 434 "FUnparse.puma"
  {
# line 436 "FUnparse.puma"
   GetString (t->TEMPLATE_DECL.Ident, string);
# line 437 "FUnparse.puma"
   fprintf (f, "!hpf$ template %s", string);
# line 438 "FUnparse.puma"
   LCR (t->TEMPLATE_DECL.Line);
  }
   return;

  }
# line 441 "FUnparse.puma"
  {
# line 443 "FUnparse.puma"
   GetString (t->TEMPLATE_DECL.Ident, string);
# line 444 "FUnparse.puma"
   fprintf (f, "!hpf$ template %s (", string);
# line 445 "FUnparse.puma"
   Unparse (t->TEMPLATE_DECL.DIMENSIONS);
# line 446 "FUnparse.puma"
   fprintf (f, ")");
# line 447 "FUnparse.puma"
   LCR (t->TEMPLATE_DECL.Line);
  }
   return;

  case kRAGGED_DECL:
# line 450 "FUnparse.puma"
  {
# line 452 "FUnparse.puma"
   GetString (t->RAGGED_DECL.Ident, string);
# line 453 "FUnparse.puma"
   fprintf (f, "!adp$ ragged %s (", string);
# line 454 "FUnparse.puma"
   Unparse (t->RAGGED_DECL.DIMENSIONS);
# line 455 "FUnparse.puma"
   fprintf (f, ")");
# line 456 "FUnparse.puma"
   LCR (t->RAGGED_DECL.Line);
  }
   return;

  case kPROCESSORS_DECL:
  if (t->PROCESSORS_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
# line 459 "FUnparse.puma"
  {
# line 461 "FUnparse.puma"
   GetString (t->PROCESSORS_DECL.Ident, string);
# line 462 "FUnparse.puma"
   fprintf (f, "!hpf$ processors %s", string);
# line 463 "FUnparse.puma"
   LCR (t->PROCESSORS_DECL.Line);
  }
   return;

  }
# line 466 "FUnparse.puma"
  {
# line 468 "FUnparse.puma"
   GetString (t->PROCESSORS_DECL.Ident, string);
# line 469 "FUnparse.puma"
   fprintf (f, "!hpf$ processors %s (", string);
# line 470 "FUnparse.puma"
   Unparse (t->PROCESSORS_DECL.DIMENSIONS);
# line 471 "FUnparse.puma"
   fprintf (f, ")");
# line 472 "FUnparse.puma"
   LCR (t->PROCESSORS_DECL.Line);
  }
   return;

  case kSUB_PROCS_DECL:
# line 475 "FUnparse.puma"
  {
# line 477 "FUnparse.puma"
   GetString (t->SUB_PROCS_DECL.Ident, string);
# line 478 "FUnparse.puma"
   fprintf (f, "!hpf$ sub_procs %s of ", string);
# line 479 "FUnparse.puma"
   Unparse (t->SUB_PROCS_DECL.TOP);
# line 480 "FUnparse.puma"
   fprintf (f, "(");
# line 481 "FUnparse.puma"
   Unparse (t->SUB_PROCS_DECL.DIMENSIONS);
# line 482 "FUnparse.puma"
   fprintf (f, ")");
# line 483 "FUnparse.puma"
   LCR (t->SUB_PROCS_DECL.Line);
  }
   return;

  case kIMPLICIT_DECL:
  if (t->IMPLICIT_DECL.TYPE->Kind == kDUMMY_TYPE) {
# line 486 "FUnparse.puma"
  {
# line 488 "FUnparse.puma"
   ind ();
# line 489 "FUnparse.puma"
   fprintf (f, "implicit none");
# line 490 "FUnparse.puma"
   LCR (t->IMPLICIT_DECL.Line);
  }
   return;

  }
# line 493 "FUnparse.puma"
  {
# line 495 "FUnparse.puma"
   ind ();
# line 496 "FUnparse.puma"
   fprintf (f, "implicit ");
# line 497 "FUnparse.puma"
   Unparse (t->IMPLICIT_DECL.TYPE);
# line 498 "FUnparse.puma"
   GetString (t->IMPLICIT_DECL.first, string);
# line 499 "FUnparse.puma"
   fprintf (f, " (%s-", string);
# line 500 "FUnparse.puma"
   GetString (t->IMPLICIT_DECL.last, string);
# line 501 "FUnparse.puma"
   fprintf (f, "%s)", string);
# line 502 "FUnparse.puma"
   LCR (t->IMPLICIT_DECL.Line);
  }
   return;

  case kCOMMON_DECL:
  if (t->COMMON_DECL.IDS->Kind == kDECL_EMPTY) {
# line 505 "FUnparse.puma"
   return;

  }
# line 510 "FUnparse.puma"
  {
# line 512 "FUnparse.puma"
   GetString (t->COMMON_DECL.Ident, string);
# line 513 "FUnparse.puma"
   ind ();
# line 514 "FUnparse.puma"
   fprintf (f, "common /%s/", string);
# line 515 "FUnparse.puma"
   ComUnparse (t->COMMON_DECL.IDS);
# line 516 "FUnparse.puma"
   LCR (t->COMMON_DECL.Line);
  }
   return;

  case kNAMELIST_DECL:
# line 519 "FUnparse.puma"
  {
# line 521 "FUnparse.puma"
   GetString (t->NAMELIST_DECL.Ident, string);
# line 522 "FUnparse.puma"
   ind ();
# line 523 "FUnparse.puma"
   fprintf (f, "namelist /%s/", string);
# line 524 "FUnparse.puma"
   ComUnparse (t->NAMELIST_DECL.IDS);
# line 525 "FUnparse.puma"
   LCR (t->NAMELIST_DECL.Line);
  }
   return;

  case kEQV_DECL:
# line 528 "FUnparse.puma"
  {
# line 530 "FUnparse.puma"
   ind ();
# line 531 "FUnparse.puma"
   fprintf (f, "equivalence (");
# line 532 "FUnparse.puma"
   Unparse (t->EQV_DECL.VARS);
# line 533 "FUnparse.puma"
   fprintf (f, ")");
# line 534 "FUnparse.puma"
   LCR (t->EQV_DECL.Line);
  }
   return;

  case kUSE_DECL:
  if (t->USE_DECL.RENAMINGS->Kind == kDECL_EMPTY) {
# line 543 "FUnparse.puma"
  {
# line 545 "FUnparse.puma"
   ind ();
# line 546 "FUnparse.puma"
   GetString (t->USE_DECL.use, string);
# line 547 "FUnparse.puma"
   fprintf (f, "use %s", string);
# line 548 "FUnparse.puma"
   LCR (t->USE_DECL.Line);
  }
   return;

  }
# line 551 "FUnparse.puma"
  {
# line 553 "FUnparse.puma"
   ind ();
# line 554 "FUnparse.puma"
   GetString (t->USE_DECL.use, string);
# line 555 "FUnparse.puma"
   fprintf (f, "use %s , ", string);
# line 556 "FUnparse.puma"
   UseNameUnparse (t->USE_DECL.RENAMINGS);
# line 557 "FUnparse.puma"
   LCR (t->USE_DECL.Line);
  }
   return;

  case kONLY_USE_DECL:
# line 560 "FUnparse.puma"
  {
# line 562 "FUnparse.puma"
   ind ();
# line 563 "FUnparse.puma"
   GetString (t->ONLY_USE_DECL.use, string);
# line 564 "FUnparse.puma"
   fprintf (f, "use %s only : ", string);
# line 565 "FUnparse.puma"
   UseNameUnparse (t->ONLY_USE_DECL.NAMES);
# line 566 "FUnparse.puma"
   LCR (t->ONLY_USE_DECL.Line);
  }
   return;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 575 "FUnparse.puma"
  {
# line 577 "FUnparse.puma"
   ind ();
# line 578 "FUnparse.puma"
   GetString (t->TYPE_DECL.Ident, string);
# line 579 "FUnparse.puma"
   fprintf (f, "type %s", string);
# line 580 "FUnparse.puma"
   LCR (t->TYPE_DECL.Line);
# line 581 "FUnparse.puma"
   IncIndent ();
# line 582 "FUnparse.puma"
   Unparse (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
# line 583 "FUnparse.puma"
   DecIndent ();
# line 584 "FUnparse.puma"
   ind ();
# line 585 "FUnparse.puma"
   fprintf (f, "end type\n");
  }
   return;

  }
  break;
  case kINTERFACE:
# line 594 "FUnparse.puma"
  {
# line 596 "FUnparse.puma"
   ind ();
# line 597 "FUnparse.puma"
   fprintf (f, "interface");
# line 598 "FUnparse.puma"
   GenSpecUnparse (t->INTERFACE.SPEC);
# line 599 "FUnparse.puma"
   LCR (t->INTERFACE.Line);
# line 600 "FUnparse.puma"
   IncIndent ();
# line 601 "FUnparse.puma"
   Unparse (t->INTERFACE.ITEMS);
# line 602 "FUnparse.puma"
   DecIndent ();
# line 603 "FUnparse.puma"
   ind ();
# line 604 "FUnparse.puma"
   fprintf (f, "end interface\n");
  }
   return;

  case kINTERFACE_DECL:
# line 607 "FUnparse.puma"
  {
# line 609 "FUnparse.puma"
   ind ();
# line 610 "FUnparse.puma"
   fprintf (f, "interface");
# line 611 "FUnparse.puma"
   GenSpecUnparse (t->INTERFACE_DECL.SPEC);
# line 612 "FUnparse.puma"
   LCR (t->INTERFACE_DECL.Line);
# line 613 "FUnparse.puma"
   IncIndent ();
# line 614 "FUnparse.puma"
   Unparse (t->INTERFACE_DECL.ITEMS);
# line 615 "FUnparse.puma"
   DecIndent ();
# line 616 "FUnparse.puma"
   ind ();
# line 617 "FUnparse.puma"
   fprintf (f, "end interface\n");
  }
   return;

  case kDIMENSION_DECL:
# line 626 "FUnparse.puma"
  {
# line 628 "FUnparse.puma"
   ind ();
# line 629 "FUnparse.puma"
   GetString (t->DIMENSION_DECL.Ident, string);
# line 630 "FUnparse.puma"
   fprintf (f, "dimension %s (", string);
# line 631 "FUnparse.puma"
   Unparse (t->DIMENSION_DECL.INDEXES);
# line 632 "FUnparse.puma"
   fprintf (f, ")");
# line 633 "FUnparse.puma"
   LCR (t->DIMENSION_DECL.Line);
  }
   return;

  case kPARAMETER_DECL:
# line 636 "FUnparse.puma"
  {
# line 638 "FUnparse.puma"
   ind ();
# line 639 "FUnparse.puma"
   GetString (t->PARAMETER_DECL.Ident, string);
# line 640 "FUnparse.puma"
   fprintf (f, "parameter (%s = ", string);
# line 641 "FUnparse.puma"
   Unparse (t->PARAMETER_DECL.VAL);
# line 642 "FUnparse.puma"
   fprintf (f, ")");
# line 643 "FUnparse.puma"
   LCR (t->PARAMETER_DECL.Line);
  }
   return;

  case kSAVE_DECL:
# line 646 "FUnparse.puma"
  {
# line 648 "FUnparse.puma"
   if (! ((t->SAVE_DECL.Ident == DefaultId ()))) goto yyL45;
  {
# line 650 "FUnparse.puma"
   ind ();
# line 651 "FUnparse.puma"
   fprintf (f, "save", string);
# line 652 "FUnparse.puma"
   LCR (t->SAVE_DECL.Line);
  }
  }
   return;
yyL45:;

# line 655 "FUnparse.puma"
  {
# line 657 "FUnparse.puma"
   ind ();
# line 658 "FUnparse.puma"
   GetString (t->SAVE_DECL.Ident, string);
# line 659 "FUnparse.puma"
   fprintf (f, "save %s", string);
# line 660 "FUnparse.puma"
   LCR (t->SAVE_DECL.Line);
  }
   return;

  case kINTENT_DECL:
# line 663 "FUnparse.puma"
  {
# line 665 "FUnparse.puma"
   ind ();
# line 666 "FUnparse.puma"
   GetString (t->INTENT_DECL.Ident, string);
# line 668 "FUnparse.puma"
 switch (t->INTENT_DECL.intent) {
       case IntentIn    : fprintf (f,"intent(in) %s", string); break;
       case IntentInOut : fprintf (f,"intent(inout) %s", string); break;
       case IntentOut   : fprintf (f,"intent(out) %s", string); break;
       default          : fprintf (f,"intent(???) %s", string); break;
     } 
   
# line 675 "FUnparse.puma"
   LCR (t->INTENT_DECL.Line);
  }
   return;

  case kOPTIONAL_DECL:
# line 678 "FUnparse.puma"
  {
# line 680 "FUnparse.puma"
   ind ();
# line 681 "FUnparse.puma"
   GetString (t->OPTIONAL_DECL.Ident, string);
# line 682 "FUnparse.puma"
   fprintf (f, "optional %s", string);
# line 683 "FUnparse.puma"
   LCR (t->OPTIONAL_DECL.Line);
  }
   return;

  case kTARGET_DECL:
# line 686 "FUnparse.puma"
  {
# line 688 "FUnparse.puma"
   ind ();
# line 689 "FUnparse.puma"
   GetString (t->TARGET_DECL.Ident, string);
# line 690 "FUnparse.puma"
   fprintf (f, "target %s", string);
# line 691 "FUnparse.puma"
   LCR (t->TARGET_DECL.Line);
  }
   return;

  case kPOINTER_DECL:
# line 694 "FUnparse.puma"
  {
# line 696 "FUnparse.puma"
   ind ();
# line 697 "FUnparse.puma"
   GetString (t->POINTER_DECL.Ident, string);
# line 698 "FUnparse.puma"
   fprintf (f, "pointer %s", string);
# line 699 "FUnparse.puma"
   LCR (t->POINTER_DECL.Line);
  }
   return;

  case kALLOCATABLE_DECL:
# line 702 "FUnparse.puma"
  {
# line 704 "FUnparse.puma"
   ind ();
# line 705 "FUnparse.puma"
   GetString (t->ALLOCATABLE_DECL.Ident, string);
# line 706 "FUnparse.puma"
   fprintf (f, "allocatable %s", string);
# line 707 "FUnparse.puma"
   LCR (t->ALLOCATABLE_DECL.Line);
  }
   return;

  case kPUBLIC_DECL:
# line 710 "FUnparse.puma"
  {
# line 712 "FUnparse.puma"
   ind ();
# line 713 "FUnparse.puma"
   GetString (t->PUBLIC_DECL.Ident, string);
# line 714 "FUnparse.puma"
   fprintf (f, "public %s", string);
# line 715 "FUnparse.puma"
   LCR (t->PUBLIC_DECL.Line);
  }
   return;

  case kPRIVATE_DECL:
# line 718 "FUnparse.puma"
  {
# line 720 "FUnparse.puma"
   ind ();
# line 721 "FUnparse.puma"
   GetString (t->PRIVATE_DECL.Ident, string);
# line 722 "FUnparse.puma"
   fprintf (f, "private %s", string);
# line 723 "FUnparse.puma"
   LCR (t->PRIVATE_DECL.Line);
  }
   return;

  case kALIGN_DECL:
  if (t->ALIGN_DECL.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
# line 726 "FUnparse.puma"
  {
# line 728 "FUnparse.puma"
   GetString (t->ALIGN_DECL.Ident, string);
# line 729 "FUnparse.puma"
   fprintf (f, "!hpf$ align %s with ", string);
# line 730 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
# line 731 "FUnparse.puma"
   LCR (t->ALIGN_DECL.Line);
  }
   return;

  }
# line 734 "FUnparse.puma"
  {
# line 736 "FUnparse.puma"
   GetString (t->ALIGN_DECL.Ident, string);
# line 737 "FUnparse.puma"
   fprintf (f, "!hpf$ align %s (", string);
# line 738 "FUnparse.puma"
   Unparse (t->ALIGN_DECL.ALIGN_SOURCE);
# line 739 "FUnparse.puma"
   fprintf (f, ") with ");
# line 740 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
# line 741 "FUnparse.puma"
   LCR (t->ALIGN_DECL.Line);
  }
   return;

  case kDYNAMIC_DECL:
# line 744 "FUnparse.puma"
  {
# line 746 "FUnparse.puma"
   GetString (t->DYNAMIC_DECL.Ident, string);
# line 747 "FUnparse.puma"
   fprintf (f, "!hpf$ dynamic %s", string);
# line 748 "FUnparse.puma"
   LCR (t->DYNAMIC_DECL.Line);
  }
   return;

  case kINHERIT_DECL:
# line 751 "FUnparse.puma"
  {
# line 753 "FUnparse.puma"
   GetString (t->INHERIT_DECL.Ident, string);
# line 754 "FUnparse.puma"
   fprintf (f, "!hpf$ inherit %s", string);
# line 755 "FUnparse.puma"
   LCR (t->INHERIT_DECL.Line);
  }
   return;

  case kRANGE_DECL:
# line 758 "FUnparse.puma"
  {
# line 760 "FUnparse.puma"
   GetString (t->RANGE_DECL.Ident, string);
# line 761 "FUnparse.puma"
   fprintf (f, "!hpf$ range %s ", string);
# line 762 "FUnparse.puma"
   Unparse (t->RANGE_DECL.RANGES);
# line 763 "FUnparse.puma"
   LCR (t->RANGE_DECL.Line);
  }
   return;

  case kRANGE_LIST:
  if (t->RANGE_LIST.Next->Kind == kRANGE_LIST) {
# line 766 "FUnparse.puma"
  {
# line 768 "FUnparse.puma"
   LayoutUnparse (t->RANGE_LIST.Elem);
# line 769 "FUnparse.puma"
   fprintf (f, " ");
# line 770 "FUnparse.puma"
   Unparse (t->RANGE_LIST.Next);
  }
   return;

  }
  if (t->RANGE_LIST.Next->Kind == kRANGE_EMPTY) {
# line 773 "FUnparse.puma"
  {
# line 775 "FUnparse.puma"
   LayoutUnparse (t->RANGE_LIST.Elem);
  }
   return;

  }
  break;
  case kDISTRIBUTE_DECL:
# line 778 "FUnparse.puma"
  {
# line 780 "FUnparse.puma"
   GetString (t->DISTRIBUTE_DECL.Ident, string);
# line 781 "FUnparse.puma"
   fprintf (f, "!hpf$ distribute %s ", string);
# line 782 "FUnparse.puma"
   LayoutUnparse (t->DISTRIBUTE_DECL.DISTRIBUTION);
# line 783 "FUnparse.puma"
   ProcSpecUnparse (t->DISTRIBUTE_DECL.TARGET);
# line 784 "FUnparse.puma"
   LCR (t->DISTRIBUTE_DECL.Line);
  }
   return;

  case kMAP_DECL:
# line 787 "FUnparse.puma"
  {
# line 789 "FUnparse.puma"
   GetString (t->MAP_DECL.Ident, string);
# line 790 "FUnparse.puma"
   fprintf (f, "!adp$ map %s to ", string);
# line 791 "FUnparse.puma"
   Unparse (t->MAP_DECL.MAP_TARGET);
# line 792 "FUnparse.puma"
   LCR (t->MAP_DECL.Line);
  }
   return;

  case kSHARED_DECL:
# line 795 "FUnparse.puma"
  {
# line 797 "FUnparse.puma"
   if (! ((t->SHARED_DECL.kind == 1))) goto yyL63;
  {
# line 799 "FUnparse.puma"
   GetString (t->SHARED_DECL.Ident, string);
# line 800 "FUnparse.puma"
   fprintf (f, "!adp$ shared %s\n", string);
  }
  }
   return;
yyL63:;

# line 803 "FUnparse.puma"
  {
# line 805 "FUnparse.puma"
   if (! ((t->SHARED_DECL.kind == 2))) goto yyL64;
  {
# line 807 "FUnparse.puma"
   GetString (t->SHARED_DECL.Ident, string);
# line 808 "FUnparse.puma"
   fprintf (f, "!adp$ rma %s\n", string);
  }
  }
   return;
yyL64:;

  break;
  case kTRACE_DECL:
# line 811 "FUnparse.puma"
  {
# line 813 "FUnparse.puma"
   GetString (t->TRACE_DECL.Ident, string);
# line 814 "FUnparse.puma"
   fprintf (f, "!adp$ trace %s\n", string);
  }
   return;

  case kTREE_DECL:
# line 817 "FUnparse.puma"
  {
# line 819 "FUnparse.puma"
   GetString (t->TREE_DECL.Ident, string);
# line 820 "FUnparse.puma"
   fprintf (f, "!adp$ tree %s\n", string);
  }
   return;

  case kSELECT_DECL:
# line 823 "FUnparse.puma"
  {
# line 825 "FUnparse.puma"
   GetString (t->SELECT_DECL.Ident, string);
# line 826 "FUnparse.puma"
   fprintf (f, "!adp$ select %s (", string);
# line 827 "FUnparse.puma"
   Unparse (t->SELECT_DECL.SELECTIONS);
# line 828 "FUnparse.puma"
   fprintf (f, ")\n");
  }
   return;

  case kSELECT_LIST:
  if (t->SELECT_LIST.Next->Kind == kSELECT_EMPTY) {
# line 831 "FUnparse.puma"
  {
# line 833 "FUnparse.puma"
   Unparse (t->SELECT_LIST.Elem);
  }
   return;

  }
# line 836 "FUnparse.puma"
  {
# line 838 "FUnparse.puma"
   Unparse (t->SELECT_LIST.Elem);
# line 839 "FUnparse.puma"
   fprintf (f, ",");
# line 840 "FUnparse.puma"
   Unparse (t->SELECT_LIST.Next);
  }
   return;

  case kSELECT_SPEC:
# line 843 "FUnparse.puma"
  {
# line 845 "FUnparse.puma"
   if (! ((! t->SELECT_SPEC.selector))) goto yyL70;
  {
# line 847 "FUnparse.puma"
   fprintf (f, "*");
  }
  }
   return;
yyL70:;

# line 850 "FUnparse.puma"
  {
# line 852 "FUnparse.puma"
   SelectorUnparse (t->SELECT_SPEC.selector);
  }
   return;

  case kOVERLAP_DECL:
# line 855 "FUnparse.puma"
  {
# line 857 "FUnparse.puma"
   GetString (t->OVERLAP_DECL.Ident, string);
# line 858 "FUnparse.puma"
   fprintf (f, "!hpf$ shadow %s (", string);
# line 859 "FUnparse.puma"
   Unparse (t->OVERLAP_DECL.OVERLAPS);
# line 860 "FUnparse.puma"
   fprintf (f, ")");
# line 861 "FUnparse.puma"
   LCR (t->OVERLAP_DECL.Line);
  }
   return;

  case kSEQUENCE_DECL:
# line 864 "FUnparse.puma"
  {
# line 866 "FUnparse.puma"
   ind ();
# line 867 "FUnparse.puma"
   GetString (t->SEQUENCE_DECL.Ident, string);
# line 868 "FUnparse.puma"
   fprintf (f, "sequence %s", string);
# line 869 "FUnparse.puma"
   LCR (t->SEQUENCE_DECL.Line);
  }
   return;

  case kHPF_SEQUENCE_DECL:
# line 872 "FUnparse.puma"
  {
# line 874 "FUnparse.puma"
   hpf_ind ();
# line 875 "FUnparse.puma"
   GetString (t->HPF_SEQUENCE_DECL.Ident, string);
# line 876 "FUnparse.puma"
   fprintf (f, "sequence %s", string);
# line 877 "FUnparse.puma"
   LCR (t->HPF_SEQUENCE_DECL.Line);
  }
   return;

  case kNOSEQUENCE_DECL:
# line 880 "FUnparse.puma"
  {
# line 882 "FUnparse.puma"
   hpf_ind ();
# line 883 "FUnparse.puma"
   GetString (t->NOSEQUENCE_DECL.Ident, string);
# line 884 "FUnparse.puma"
   fprintf (f, "no sequence %s", string);
# line 885 "FUnparse.puma"
   LCR (t->NOSEQUENCE_DECL.Line);
  }
   return;

  case kFORMAT_DECL:
# line 888 "FUnparse.puma"
  {
# line 890 "FUnparse.puma"
   label_ind (t->FORMAT_DECL.label);
# line 891 "FUnparse.puma"
   fprintf (f, "format ");
# line 892 "FUnparse.puma"
   FormatUnparse (t->FORMAT_DECL.FORMAT_PARAMS);
# line 893 "FUnparse.puma"
   LCR (t->FORMAT_DECL.Line);
  }
   return;

  case kDATA_DECL:
# line 896 "FUnparse.puma"
  {
# line 898 "FUnparse.puma"
   ind ();
# line 899 "FUnparse.puma"
   fprintf (f, "data ");
# line 900 "FUnparse.puma"
   Unparse (t->DATA_DECL.VARS);
# line 901 "FUnparse.puma"
   fprintf (f, " / ");
# line 902 "FUnparse.puma"
   Unparse (t->DATA_DECL.VALS);
# line 903 "FUnparse.puma"
   fprintf (f, " /");
# line 904 "FUnparse.puma"
   LCR (t->DATA_DECL.Line);
  }
   return;

  case kMAP_TO_DECL:
# line 907 "FUnparse.puma"
  {
# line 909 "FUnparse.puma"
   ind ();
# line 910 "FUnparse.puma"
   GetString (t->MAP_TO_DECL.Ident, string);
# line 911 "FUnparse.puma"
   fprintf (f, "map_to %s (", string);
# line 912 "FUnparse.puma"
   fprintf (f, "\'");
# line 913 "FUnparse.puma"
   StGetString (t->MAP_TO_DECL.kind, string);
# line 914 "FUnparse.puma"
   MyPrintString (f, string);
# line 915 "FUnparse.puma"
   fprintf (f, "\')");
# line 916 "FUnparse.puma"
   LCR (t->MAP_TO_DECL.Line);
  }
   return;

  case kLAYOUT_DECL:
# line 919 "FUnparse.puma"
  {
# line 921 "FUnparse.puma"
   ind ();
# line 922 "FUnparse.puma"
   GetString (t->LAYOUT_DECL.Ident, string);
# line 923 "FUnparse.puma"
   fprintf (f, "layout %s (", string);
# line 924 "FUnparse.puma"
   fprintf (f, "\'");
# line 925 "FUnparse.puma"
   StGetString (t->LAYOUT_DECL.kind, string);
# line 926 "FUnparse.puma"
   MyPrintString (f, string);
# line 927 "FUnparse.puma"
   fprintf (f, "\')");
# line 928 "FUnparse.puma"
   LCR (t->LAYOUT_DECL.Line);
  }
   return;

  case kPASS_BY_DECL:
# line 931 "FUnparse.puma"
  {
# line 933 "FUnparse.puma"
   ind ();
# line 934 "FUnparse.puma"
   GetString (t->PASS_BY_DECL.Ident, string);
# line 935 "FUnparse.puma"
   fprintf (f, "pass_by %s (", string);
# line 936 "FUnparse.puma"
   fprintf (f, "\'");
# line 937 "FUnparse.puma"
   StGetString (t->PASS_BY_DECL.kind, string);
# line 938 "FUnparse.puma"
   MyPrintString (f, string);
# line 939 "FUnparse.puma"
   fprintf (f, "\')\n");
# line 940 "FUnparse.puma"
   LCR (t->PASS_BY_DECL.Line);
  }
   return;

  case kBODY_NODE:
  if (t->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
# line 949 "FUnparse.puma"
  {
# line 951 "FUnparse.puma"
   Unparse (t->BODY_NODE.DECLS);
# line 952 "FUnparse.puma"
   Unparse (t->BODY_NODE.STATS);
# line 953 "FUnparse.puma"
   ind ();
# line 954 "FUnparse.puma"
   fprintf (f, "end");
  }
   return;

  }
# line 957 "FUnparse.puma"
  {
# line 959 "FUnparse.puma"
   Unparse (t->BODY_NODE.DECLS);
# line 960 "FUnparse.puma"
   Unparse (t->BODY_NODE.STATS);
# line 961 "FUnparse.puma"
   ind ();
# line 962 "FUnparse.puma"
   fprintf (f, "contains\n");
# line 963 "FUnparse.puma"
   Unparse (t->BODY_NODE.INTERNALS);
# line 964 "FUnparse.puma"
   ind ();
# line 965 "FUnparse.puma"
   fprintf (f, "end");
  }
   return;

  case kACF_LIST:
# line 968 "FUnparse.puma"
  {
# line 970 "FUnparse.puma"
   Unparse (t->ACF_LIST.Elem);
# line 971 "FUnparse.puma"
 if (t->ACF_LIST.Next != NoTree) Unparse (t->ACF_LIST.Next); 
  }
   return;

  case kACF_EMPTY:
# line 974 "FUnparse.puma"
   return;

  case kACF_BASIC:
# line 977 "FUnparse.puma"
  {
# line 979 "FUnparse.puma"
   label_ind (t->ACF_BASIC.Label);
# line 980 "FUnparse.puma"
   Unparse (t->ACF_BASIC.BASIC_STMT);
# line 981 "FUnparse.puma"
   LCR (t->ACF_BASIC.Line);
  }
   return;

  case kACF_DUMMY:
# line 984 "FUnparse.puma"
  {
# line 986 "FUnparse.puma"
   label_ind (t->ACF_DUMMY.Label);
# line 987 "FUnparse.puma"
   fprintf (f, "continue");
# line 988 "FUnparse.puma"
   LCR (t->ACF_DUMMY.Line);
  }
   return;

  case kACF_WHILE:
# line 991 "FUnparse.puma"
  {
# line 993 "FUnparse.puma"
   label_ind (t->ACF_WHILE.Label);
# line 994 "FUnparse.puma"
   fprintf (f, "do while (");
# line 995 "FUnparse.puma"
   Unparse (t->ACF_WHILE.WHILE_EXP);
# line 996 "FUnparse.puma"
   fprintf (f, ")");
# line 997 "FUnparse.puma"
   LCR (t->ACF_WHILE.Line);
# line 998 "FUnparse.puma"
   IncIndent ();
# line 999 "FUnparse.puma"
   Unparse (t->ACF_WHILE.WHILE_BODY);
# line 1000 "FUnparse.puma"
   DecIndent ();
# line 1001 "FUnparse.puma"
   ind ();
# line 1002 "FUnparse.puma"
   fprintf (f, "end do\n");
  }
   return;

  case kACF_DO:
  if (t->ACF_DO.DO_ID->Kind == kDUMMY_VAR) {
# line 1005 "FUnparse.puma"
  {
# line 1007 "FUnparse.puma"
   label_ind (t->ACF_DO.Label);
# line 1008 "FUnparse.puma"
   fprintf (f, "do (");
# line 1009 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_RANGE->SLICE_EXP.STOP);
# line 1010 "FUnparse.puma"
   fprintf (f, ") times");
# line 1011 "FUnparse.puma"
   LCR (t->ACF_DO.Line);
# line 1012 "FUnparse.puma"
   IncIndent ();
# line 1013 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_BODY);
# line 1014 "FUnparse.puma"
   DecIndent ();
# line 1015 "FUnparse.puma"
   ind ();
# line 1016 "FUnparse.puma"
   fprintf (f, "end do\n");
  }
   return;

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
# line 1019 "FUnparse.puma"
  {
# line 1021 "FUnparse.puma"
   if (! ((sm_parallelization == SGI_MP))) goto yyL89;
  {
# line 1023 "FUnparse.puma"
   par_ind ();
# line 1024 "FUnparse.puma"
   fprintf (f, "pdo\n");
# line 1025 "FUnparse.puma"
   label_ind (t->ACF_DO.Label);
# line 1026 "FUnparse.puma"
   fprintf (f, "do ");
# line 1027 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_ID);
# line 1028 "FUnparse.puma"
   fprintf (f, "=");
# line 1029 "FUnparse.puma"
   UnparseDoRange (t->ACF_DO.DO_RANGE);
# line 1030 "FUnparse.puma"
   LCR (t->ACF_DO.Line);
# line 1031 "FUnparse.puma"
   IncIndent ();
# line 1032 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_BODY);
# line 1033 "FUnparse.puma"
   DecIndent ();
# line 1034 "FUnparse.puma"
   ind ();
# line 1035 "FUnparse.puma"
   fprintf (f, "end do\n");
# line 1036 "FUnparse.puma"
   par_ind ();
# line 1037 "FUnparse.puma"
   fprintf (f, "end pdo\n");
  }
  }
   return;
yyL89:;

  }
# line 1040 "FUnparse.puma"
  {
# line 1042 "FUnparse.puma"
   VecInfoUnparse (t->ACF_DO.DO_DEP_INFO);
# line 1043 "FUnparse.puma"
   label_ind (t->ACF_DO.Label);
# line 1044 "FUnparse.puma"
   fprintf (f, "do ");
# line 1045 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_ID);
# line 1046 "FUnparse.puma"
   fprintf (f, "=");
# line 1047 "FUnparse.puma"
   UnparseDoRange (t->ACF_DO.DO_RANGE);
# line 1048 "FUnparse.puma"
   DepInfoUnparse (t->ACF_DO.DO_DEP_INFO);
# line 1049 "FUnparse.puma"
   HomeInfoUnparse (t->ACF_DO.DO_HOME_INFO);
# line 1050 "FUnparse.puma"
   LCR (t->ACF_DO.Line);
# line 1051 "FUnparse.puma"
   IncIndent ();
# line 1052 "FUnparse.puma"
   Unparse (t->ACF_DO.DO_BODY);
# line 1053 "FUnparse.puma"
   DecIndent ();
# line 1054 "FUnparse.puma"
   ind ();
# line 1055 "FUnparse.puma"
   fprintf (f, "end do\n");
  }
   return;

  case kACF_FORALL:
# line 1058 "FUnparse.puma"
  {
# line 1060 "FUnparse.puma"
   label_ind (t->ACF_FORALL.Label);
# line 1061 "FUnparse.puma"
   fprintf (f, "forall (");
# line 1062 "FUnparse.puma"
   Unparse (t->ACF_FORALL.FORALL_ID);
# line 1063 "FUnparse.puma"
   fprintf (f, "=");
# line 1064 "FUnparse.puma"
   Unparse (t->ACF_FORALL.FORALL_RANGE);
# line 1065 "FUnparse.puma"
   fprintf (f, ")");
# line 1066 "FUnparse.puma"
   DepInfoUnparse (t->ACF_FORALL.FORALL_DEP_INFO);
# line 1067 "FUnparse.puma"
   HomeInfoUnparse (t->ACF_FORALL.FORALL_HOME_INFO);
# line 1068 "FUnparse.puma"
   LCR (t->ACF_FORALL.Line);
# line 1069 "FUnparse.puma"
   IncIndent ();
# line 1070 "FUnparse.puma"
   Unparse (t->ACF_FORALL.FORALL_BODY);
# line 1071 "FUnparse.puma"
   DecIndent ();
# line 1072 "FUnparse.puma"
   ind ();
# line 1073 "FUnparse.puma"
   fprintf (f, "end forall\n");
  }
   return;

  case kACF_LOOP:
# line 1076 "FUnparse.puma"
  {
# line 1078 "FUnparse.puma"
   label_ind (t->ACF_LOOP.Label);
# line 1079 "FUnparse.puma"
   fprintf (f, "do while (.TRUE.)");
# line 1080 "FUnparse.puma"
   LCR (t->ACF_LOOP.Line);
# line 1081 "FUnparse.puma"
   IncIndent ();
# line 1082 "FUnparse.puma"
   Unparse (t->ACF_LOOP.LOOP_BODY);
# line 1083 "FUnparse.puma"
   DecIndent ();
# line 1084 "FUnparse.puma"
   ind ();
# line 1085 "FUnparse.puma"
   fprintf (f, "end do\n");
  }
   return;

  case kACF_IF:
# line 1088 "FUnparse.puma"
  {
# line 1090 "FUnparse.puma"
   label_ind (t->ACF_IF.Label);
# line 1091 "FUnparse.puma"
   fprintf (f, "if (");
# line 1092 "FUnparse.puma"
   Unparse (t->ACF_IF.IF_EXP);
# line 1093 "FUnparse.puma"
   fprintf (f, ") then");
# line 1094 "FUnparse.puma"
   LCR (t->ACF_IF.Line);
# line 1095 "FUnparse.puma"
   IncIndent ();
# line 1096 "FUnparse.puma"
   Unparse (t->ACF_IF.THEN_PART);
# line 1097 "FUnparse.puma"
   DecIndent ();
# line 1098 "FUnparse.puma"
   UnparseElse (t->ACF_IF.ELSE_PART);
# line 1099 "FUnparse.puma"
   ind ();
# line 1100 "FUnparse.puma"
   fprintf (f, "end if\n");
  }
   return;

  case kACF_WHERE:
  if (t->ACF_WHERE.FALSE_PART->Kind == kACF_EMPTY) {
# line 1103 "FUnparse.puma"
  {
# line 1105 "FUnparse.puma"
   label_ind (t->ACF_WHERE.Label);
# line 1106 "FUnparse.puma"
   fprintf (f, "where (");
# line 1107 "FUnparse.puma"
   Unparse (t->ACF_WHERE.WHERE_EXP);
# line 1108 "FUnparse.puma"
   fprintf (f, ")");
# line 1109 "FUnparse.puma"
   LCR (t->ACF_WHERE.Line);
# line 1110 "FUnparse.puma"
   IncIndent ();
# line 1111 "FUnparse.puma"
   Unparse (t->ACF_WHERE.TRUE_PART);
# line 1112 "FUnparse.puma"
   DecIndent ();
# line 1113 "FUnparse.puma"
   ind ();
# line 1114 "FUnparse.puma"
   fprintf (f, "end where\n");
  }
   return;

  }
# line 1117 "FUnparse.puma"
  {
# line 1119 "FUnparse.puma"
   label_ind (t->ACF_WHERE.Label);
# line 1120 "FUnparse.puma"
   fprintf (f, "where (");
# line 1121 "FUnparse.puma"
   Unparse (t->ACF_WHERE.WHERE_EXP);
# line 1122 "FUnparse.puma"
   fprintf (f, ")");
# line 1123 "FUnparse.puma"
   LCR (t->ACF_WHERE.Line);
# line 1124 "FUnparse.puma"
   IncIndent ();
# line 1125 "FUnparse.puma"
   Unparse (t->ACF_WHERE.TRUE_PART);
# line 1126 "FUnparse.puma"
   DecIndent ();
# line 1127 "FUnparse.puma"
   ind ();
# line 1128 "FUnparse.puma"
   fprintf (f, " elsewhere\n");
# line 1129 "FUnparse.puma"
   IncIndent ();
# line 1130 "FUnparse.puma"
   Unparse (t->ACF_WHERE.FALSE_PART);
# line 1131 "FUnparse.puma"
   DecIndent ();
# line 1132 "FUnparse.puma"
   ind ();
# line 1133 "FUnparse.puma"
   fprintf (f, "end where\n");
  }
   return;

  case kACF_CASE:
# line 1136 "FUnparse.puma"
  {
# line 1138 "FUnparse.puma"
   label_ind (t->ACF_CASE.Label);
# line 1139 "FUnparse.puma"
   fprintf (f, "select case (");
# line 1140 "FUnparse.puma"
   Unparse (t->ACF_CASE.CASE_EXP);
# line 1141 "FUnparse.puma"
   fprintf (f, ")");
# line 1142 "FUnparse.puma"
   LCR (t->ACF_CASE.Line);
# line 1143 "FUnparse.puma"
   IncIndent ();
# line 1144 "FUnparse.puma"
   Unparse (t->ACF_CASE.CASE_ALTS);
# line 1145 "FUnparse.puma"
   DecIndent ();
# line 1146 "FUnparse.puma"
   ind ();
# line 1147 "FUnparse.puma"
   fprintf (f, "end select\n");
  }
   return;

  case kACF_HOME:
# line 1150 "FUnparse.puma"
  {
# line 1153 "FUnparse.puma"
   fprintf (f, "!hpf$ ");
# line 1154 "FUnparse.puma"
   Unparse (t->ACF_HOME.HOME_VAR);
# line 1155 "FUnparse.puma"
 if (t->ACF_HOME.user_home) fprintf (f, " by user"); 
         else  fprintf (f, " by system");
   
# line 1158 "FUnparse.puma"
   HPFBodyUnparse (t->ACF_HOME.Line, t->ACF_HOME.HOME_BODY, 0);
  }
   return;

  case kON_PROC_CLAUSE:
# line 1161 "FUnparse.puma"
  {
# line 1163 "FUnparse.puma"
   fprintf (f, "on (");
# line 1164 "FUnparse.puma"
   Unparse (t->ON_PROC_CLAUSE.ON_PROC);
# line 1165 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kPROCESSOR_ARRAY:
# line 1170 "FUnparse.puma"
  {
# line 1172 "FUnparse.puma"
   GetString (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident, string);
# line 1173 "FUnparse.puma"
   fprintf (f, " %s", string);
  }
   return;

  case kPROCESSOR_SUBSET:
# line 1176 "FUnparse.puma"
  {
# line 1178 "FUnparse.puma"
   GetString (t->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Ident, string);
# line 1179 "FUnparse.puma"
   fprintf (f, "%s(", string);
# line 1180 "FUnparse.puma"
   Unparse (t->PROCESSOR_SUBSET.SUBSCRIPTS);
# line 1181 "FUnparse.puma"
   fprintf (f, ") = ");
# line 1182 "FUnparse.puma"
   GetString (t->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident, string);
# line 1183 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kON_VAR_CLAUSE:
# line 1186 "FUnparse.puma"
  {
# line 1188 "FUnparse.puma"
   fprintf (f, "on home (");
# line 1189 "FUnparse.puma"
   Unparse (t->ON_VAR_CLAUSE.ON_VAR);
# line 1190 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kON_ALL_CLAUSE:
# line 1193 "FUnparse.puma"
  {
# line 1195 "FUnparse.puma"
   fprintf (f, "on all");
  }
   return;

  case kON_HOST_CLAUSE:
# line 1198 "FUnparse.puma"
  {
# line 1200 "FUnparse.puma"
   fprintf (f, "on host");
  }
   return;

  case kACF_PARALLEL:
# line 1203 "FUnparse.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 1205 "FUnparse.puma"
   if (! (((sm_parallelization == SUN_MP) || (sm_parallelization == CRAY_MP)))) goto yyL104;
  {
# line 1207 "FUnparse.puma"
   SMGetParLoop (t->ACF_PARALLEL.PARALLEL_BODY, & yyV1, & yyV2);
# line 1209 "FUnparse.puma"
   if (! ((yyV1))) goto yyL104;
  {
# line 1211 "FUnparse.puma"
   par_ind ();
# line 1212 "FUnparse.puma"
   fprintf (f, "doall ");
# line 1213 "FUnparse.puma"
   SMParUnparse (t->ACF_PARALLEL.REDUCTION_VARS, t->ACF_PARALLEL.SHARED_VARS, t->ACF_PARALLEL.LOCAL_VARS);
# line 1214 "FUnparse.puma"
   fprintf (f, "\n");
# line 1215 "FUnparse.puma"
   Unparse (yyV2);
  }
  }
  }
   return;
 }
yyL104:;

# line 1218 "FUnparse.puma"
  {
# line 1220 "FUnparse.puma"
   par_ind ();
# line 1221 "FUnparse.puma"
   fprintf (f, "parallel ");
# line 1222 "FUnparse.puma"
   SMParUnparse (t->ACF_PARALLEL.REDUCTION_VARS, t->ACF_PARALLEL.SHARED_VARS, t->ACF_PARALLEL.LOCAL_VARS);
# line 1223 "FUnparse.puma"
   fprintf (f, "\n");
# line 1224 "FUnparse.puma"
   Unparse (t->ACF_PARALLEL.PARALLEL_BODY);
# line 1225 "FUnparse.puma"
   par_ind ();
# line 1226 "FUnparse.puma"
   fprintf (f, "end parallel\n");
  }
   return;

  case kACF_CRITICAL:
# line 1229 "FUnparse.puma"
  {
# line 1231 "FUnparse.puma"
   par_ind ();
# line 1232 "FUnparse.puma"
   fprintf (f, "critical section\n");
# line 1233 "FUnparse.puma"
   Unparse (t->ACF_CRITICAL.CRITICAL_BODY);
# line 1234 "FUnparse.puma"
   par_ind ();
# line 1235 "FUnparse.puma"
   fprintf (f, "end critical section\n");
  }
   return;

  case kACF_TASK_REGION:
# line 1238 "FUnparse.puma"
  {
# line 1240 "FUnparse.puma"
 if (t->ACF_TASK_REGION.task_flag)
         fprintf (f, "!hpf$ independent task_region\n");
       else
         fprintf (f, "!hpf$ task_region\n");
   
# line 1245 "FUnparse.puma"
   Unparse (t->ACF_TASK_REGION.TASK_BODY);
# line 1246 "FUnparse.puma"
   fprintf (f, "!hpf$ end task_region\n");
  }
   return;

  case kACF_NEW:
# line 1249 "FUnparse.puma"
  {
# line 1251 "FUnparse.puma"
   fprintf (f, "!hpf$ new (");
# line 1252 "FUnparse.puma"
   Unparse (t->ACF_NEW.NEW_VAR);
# line 1253 "FUnparse.puma"
   fprintf (f, ")");
# line 1254 "FUnparse.puma"
   HPFBodyUnparse (t->ACF_NEW.Line, t->ACF_NEW.NEW_BODY, 2);
  }
   return;

  case kACF_REDUCTION:
# line 1257 "FUnparse.puma"
  {
# line 1259 "FUnparse.puma"
   fprintf (f, "!hpf$ reduction (");
# line 1260 "FUnparse.puma"
   Unparse (t->ACF_REDUCTION.REDUCTION_VAR);
# line 1261 "FUnparse.puma"
   fprintf (f, ") op = ");
# line 1262 "FUnparse.puma"
   Unparse (t->ACF_REDUCTION.REDUCTION_FUNC);
# line 1263 "FUnparse.puma"
   fprintf (f, " via ");
# line 1264 "FUnparse.puma"
   Unparse (t->ACF_REDUCTION.REDUCTION_LVAR);
# line 1265 "FUnparse.puma"
 if (t->ACF_REDUCTION.is_zero) fprintf (f, " is 0 "); else fprintf (f, " can be not 0"); 
# line 1266 "FUnparse.puma"
   HPFBodyUnparse (t->ACF_REDUCTION.Line, t->ACF_REDUCTION.REDUCTION_BODY, 3);
  }
   return;

  case kACF_RESIDENT:
  if (t->ACF_RESIDENT.RESIDENT_VAR->Kind == kBTV_LIST) {
  if (t->ACF_RESIDENT.RESIDENT_VAR->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (t->ACF_RESIDENT.RESIDENT_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 1269 "FUnparse.puma"
  {
# line 1271 "FUnparse.puma"
   fprintf (f, "!hpf$ resident");
# line 1272 "FUnparse.puma"
   HPFBodyUnparse (t->ACF_RESIDENT.Line, t->ACF_RESIDENT.RESIDENT_BODY, 1);
  }
   return;

  }
  }
  }
# line 1275 "FUnparse.puma"
  {
# line 1277 "FUnparse.puma"
   fprintf (f, "!hpf$ resident(");
# line 1278 "FUnparse.puma"
   Unparse (t->ACF_RESIDENT.RESIDENT_VAR);
# line 1279 "FUnparse.puma"
   fprintf (f, ")");
# line 1280 "FUnparse.puma"
   HPFBodyUnparse (t->ACF_RESIDENT.Line, t->ACF_RESIDENT.RESIDENT_BODY, 1);
  }
   return;

  case kACF_ON:
# line 1283 "FUnparse.puma"
  {
# line 1285 "FUnparse.puma"
   label_ind (t->ACF_ON.Label);
# line 1286 "FUnparse.puma"
   fprintf (f, "on ");
# line 1287 "FUnparse.puma"
   OnSpecUnparse (t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS);
# line 1288 "FUnparse.puma"
   fprintf (f, "\n");
# line 1289 "FUnparse.puma"
   IncIndent ();
# line 1290 "FUnparse.puma"
   Unparse (t->ACF_ON.ON_BODY);
# line 1291 "FUnparse.puma"
   DecIndent ();
# line 1292 "FUnparse.puma"
   ind ();
# line 1293 "FUnparse.puma"
   fprintf (f, "end on\n");
  }
   return;

  case kACF_BARRIER:
# line 1296 "FUnparse.puma"
  {
# line 1298 "FUnparse.puma"
   label_ind (t->ACF_BARRIER.Label);
# line 1299 "FUnparse.puma"
   fprintf (f, "barrier (");
# line 1300 "FUnparse.puma"
   Unparse (t->ACF_BARRIER.BARRIER_VARS);
# line 1301 "FUnparse.puma"
   fprintf (f, ")\n");
  }
   return;

  case kACF_RM_READ:
# line 1304 "FUnparse.puma"
  {
# line 1306 "FUnparse.puma"
   label_ind (t->ACF_RM_READ.Label);
# line 1307 "FUnparse.puma"
   fprintf (f, "RMA read ");
# line 1308 "FUnparse.puma"
   Unparse (t->ACF_RM_READ.REMOTE_VAR);
# line 1309 "FUnparse.puma"
   fprintf (f, " into ");
# line 1310 "FUnparse.puma"
   Unparse (t->ACF_RM_READ.LOCAL_VAR);
# line 1311 "FUnparse.puma"
   LCR (t->ACF_RM_READ.Line);
  }
   return;

  case kACF_RM_WRITE:
# line 1314 "FUnparse.puma"
  {
# line 1316 "FUnparse.puma"
   if (! ((t->ACF_RM_WRITE.op == 0))) goto yyL115;
  {
# line 1318 "FUnparse.puma"
   label_ind (t->ACF_RM_WRITE.Label);
# line 1319 "FUnparse.puma"
   fprintf (f, "RMA write ");
# line 1320 "FUnparse.puma"
   Unparse (t->ACF_RM_WRITE.LOCAL_DATA);
# line 1321 "FUnparse.puma"
   fprintf (f, " into ");
# line 1322 "FUnparse.puma"
   Unparse (t->ACF_RM_WRITE.REMOTE_VAR);
# line 1323 "FUnparse.puma"
   LCR (t->ACF_RM_WRITE.Line);
  }
  }
   return;
yyL115:;

# line 1326 "FUnparse.puma"
  {
# line 1328 "FUnparse.puma"
   label_ind (t->ACF_RM_WRITE.Label);
# line 1329 "FUnparse.puma"
   fprintf (f, "RMA update (op = %d) ", t->ACF_RM_WRITE.op);
# line 1330 "FUnparse.puma"
   Unparse (t->ACF_RM_WRITE.LOCAL_DATA);
# line 1331 "FUnparse.puma"
   fprintf (f, " into ");
# line 1332 "FUnparse.puma"
   Unparse (t->ACF_RM_WRITE.REMOTE_VAR);
# line 1333 "FUnparse.puma"
   LCR (t->ACF_RM_WRITE.Line);
  }
   return;

  case kACF_MOVE:
# line 1336 "FUnparse.puma"
  {
# line 1338 "FUnparse.puma"
   fprintf (f, "C      movement\n");
# line 1339 "FUnparse.puma"
   label_ind (t->ACF_MOVE.Label);
# line 1340 "FUnparse.puma"
   Unparse (t->ACF_MOVE.MOVE_STMT);
# line 1341 "FUnparse.puma"
   LCR (t->ACF_MOVE.Line);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 1344 "FUnparse.puma"
  {
# line 1345 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_LIST.Elem);
# line 1346 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 1349 "FUnparse.puma"
   return;

  case kSELECTED_ACF_NODE:
  if (t->SELECTED_ACF_NODE.SELECT_LIST->Kind == kBTE_EMPTY) {
# line 1352 "FUnparse.puma"
  {
# line 1354 "FUnparse.puma"
   ind ();
# line 1355 "FUnparse.puma"
   fprintf (f, "case default \n");
# line 1356 "FUnparse.puma"
   IncIndent ();
# line 1357 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_NODE.SELECT_ACFS);
# line 1358 "FUnparse.puma"
   DecIndent ();
  }
   return;

  }
# line 1361 "FUnparse.puma"
  {
# line 1363 "FUnparse.puma"
   ind ();
# line 1364 "FUnparse.puma"
   fprintf (f, "case (");
# line 1365 "FUnparse.puma"
   CaseSelectorUnparse (t->SELECTED_ACF_NODE.SELECT_LIST);
# line 1366 "FUnparse.puma"
   fprintf (f, ")\n");
# line 1367 "FUnparse.puma"
   IncIndent ();
# line 1368 "FUnparse.puma"
   Unparse (t->SELECTED_ACF_NODE.SELECT_ACFS);
# line 1369 "FUnparse.puma"
   DecIndent ();
  }
   return;

  case kACF_ENTRY:
  if (t->ACF_ENTRY.ENTRY_DECL->Kind == kFUNC_DECL) {
# line 1372 "FUnparse.puma"
  {
# line 1374 "FUnparse.puma"
   label_ind (t->ACF_ENTRY.Label);
# line 1375 "FUnparse.puma"
   GetString (t->ACF_ENTRY.ENTRY_DECL->FUNC_DECL.Ident, string);
# line 1376 "FUnparse.puma"
   fprintf (f, "entry %s (", string);
# line 1377 "FUnparse.puma"
   Unparse (t->ACF_ENTRY.ENTRY_DECL->FUNC_DECL.FORMALS);
# line 1378 "FUnparse.puma"
   fprintf (f, ")");
# line 1379 "FUnparse.puma"
   LCR (t->ACF_ENTRY.Line);
  }
   return;

  }
  if (t->ACF_ENTRY.ENTRY_DECL->Kind == kPROC_DECL) {
# line 1382 "FUnparse.puma"
  {
# line 1384 "FUnparse.puma"
   label_ind (t->ACF_ENTRY.Label);
# line 1385 "FUnparse.puma"
   GetString (t->ACF_ENTRY.ENTRY_DECL->PROC_DECL.Ident, string);
# line 1386 "FUnparse.puma"
   fprintf (f, "entry %s (", string);
# line 1387 "FUnparse.puma"
   Unparse (t->ACF_ENTRY.ENTRY_DECL->PROC_DECL.FORMALS);
# line 1388 "FUnparse.puma"
   fprintf (f, ")");
# line 1389 "FUnparse.puma"
   LCR (t->ACF_ENTRY.Line);
  }
   return;

  }
  break;
  }


  switch (t->Kind) {
  case kACF_NODE:
  case kACF_WHERE:
  case kACF_REPEAT:
  case kACF_DO:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_RESIDENT:
  case kACF_UPDATE:
# line 1392 "FUnparse.puma"
  {
# line 1394 "FUnparse.puma"
   label_ind (t->ACF_NODE.Label);
# line 1395 "FUnparse.puma"
   fprintf (f, "Statement");
# line 1396 "FUnparse.puma"
   LCR (t->ACF_NODE.Line);
  }
   return;

  case kASSIGN_STMT:
# line 1407 "FUnparse.puma"
  {
# line 1409 "FUnparse.puma"
   Unparse (t->ASSIGN_STMT.ASSIGN_VAR);
# line 1410 "FUnparse.puma"
   fprintf (f, " = ");
# line 1411 "FUnparse.puma"
   Unparse (t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kPTR_ASSIGN_STMT:
# line 1414 "FUnparse.puma"
  {
# line 1416 "FUnparse.puma"
   Unparse (t->PTR_ASSIGN_STMT.ASSIGN_VAR);
# line 1417 "FUnparse.puma"
   fprintf (f, " => ");
# line 1418 "FUnparse.puma"
   Unparse (t->PTR_ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kLABEL_ASSIGN_STMT:
# line 1421 "FUnparse.puma"
  {
# line 1423 "FUnparse.puma"
   fprintf (f, "assign %d to ", t->LABEL_ASSIGN_STMT.assign_label);
# line 1424 "FUnparse.puma"
   Unparse (t->LABEL_ASSIGN_STMT.LABEL_VAR);
  }
   return;

  case kFORMAT_STMT:
# line 1427 "FUnparse.puma"
  {
# line 1429 "FUnparse.puma"
   fprintf (f, "FORMAT ");
# line 1430 "FUnparse.puma"
   FormatUnparse (t->FORMAT_STMT.FORMAT_PARAMS);
  }
   return;

  case kSTOP_STMT:
  if (t->STOP_STMT.STOP_CONST->Kind == kDUMMY_EXP) {
# line 1433 "FUnparse.puma"
  {
# line 1435 "FUnparse.puma"
   fprintf (f, "stop");
  }
   return;

  }
# line 1438 "FUnparse.puma"
  {
# line 1440 "FUnparse.puma"
   fprintf (f, "stop ");
# line 1441 "FUnparse.puma"
   Unparse (t->STOP_STMT.STOP_CONST);
  }
   return;

  case kEXIT_STMT:
# line 1444 "FUnparse.puma"
  {
# line 1446 "FUnparse.puma"
 if (t->EXIT_STMT.loopid == DefaultId ())
         fprintf (f,"exit");
       else
         { GetString (t->EXIT_STMT.loopid, string);
           fprintf (f,"exit %s", string);
         }
   
  }
   return;

  case kCYCLE_STMT:
# line 1455 "FUnparse.puma"
  {
# line 1457 "FUnparse.puma"
 if (t->CYCLE_STMT.loopid == DefaultId ())
        fprintf (f,"cycle");
       else
        { GetString (t->CYCLE_STMT.loopid, string);
          fprintf (f,"cycle %s", string);
        }
   
  }
   return;

  case kRETURN_STMT:
  if (t->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
# line 1466 "FUnparse.puma"
  {
# line 1468 "FUnparse.puma"
   fprintf (f, "return");
  }
   return;

  }
# line 1471 "FUnparse.puma"
  {
# line 1473 "FUnparse.puma"
   fprintf (f, "return ");
# line 1474 "FUnparse.puma"
   Unparse (t->RETURN_STMT.RETURN_EXP);
  }
   return;

  case kASS_GOTO_STMT:
  if (t->ASS_GOTO_STMT.LABELS->Kind == kLABEL_EMPTY) {
# line 1477 "FUnparse.puma"
  {
# line 1479 "FUnparse.puma"
   fprintf (f, "goto ");
# line 1480 "FUnparse.puma"
   Unparse (t->ASS_GOTO_STMT.GOTO_VAR);
  }
   return;

  }
# line 1483 "FUnparse.puma"
  {
# line 1485 "FUnparse.puma"
   fprintf (f, "goto ");
# line 1486 "FUnparse.puma"
   Unparse (t->ASS_GOTO_STMT.GOTO_VAR);
# line 1487 "FUnparse.puma"
   fprintf (f, " (");
# line 1488 "FUnparse.puma"
   Unparse (t->ASS_GOTO_STMT.LABELS);
# line 1489 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kGOTO_STMT:
# line 1492 "FUnparse.puma"
  {
# line 1494 "FUnparse.puma"
   fprintf (f, "goto %d", t->GOTO_STMT.GOTO_LABEL);
  }
   return;

  case kCOMP_GOTO_STMT:
# line 1497 "FUnparse.puma"
  {
# line 1499 "FUnparse.puma"
   fprintf (f, "goto (");
# line 1500 "FUnparse.puma"
   Unparse (t->COMP_GOTO_STMT.GOTO_LABELS);
# line 1501 "FUnparse.puma"
   fprintf (f, ") ");
# line 1502 "FUnparse.puma"
   Unparse (t->COMP_GOTO_STMT.GOTO_EXP);
  }
   return;

  case kLABEL_LIST:
  if (t->LABEL_LIST.Next->Kind == kLABEL_EMPTY) {
# line 1505 "FUnparse.puma"
  {
# line 1507 "FUnparse.puma"
   fprintf (f, "%d", t->LABEL_LIST.Elem);
  }
   return;

  }
# line 1510 "FUnparse.puma"
  {
# line 1512 "FUnparse.puma"
   fprintf (f, "%d, ", t->LABEL_LIST.Elem);
# line 1513 "FUnparse.puma"
   Unparse (t->LABEL_LIST.Next);
  }
   return;

  case kCOMP_IF_STMT:
# line 1516 "FUnparse.puma"
  {
# line 1518 "FUnparse.puma"
   fprintf (f, "if (");
# line 1519 "FUnparse.puma"
   Unparse (t->COMP_IF_STMT.IF_EXP);
# line 1520 "FUnparse.puma"
   fprintf (f, ") ");
# line 1521 "FUnparse.puma"
   fprintf (f, "%d , %d , %d", t->COMP_IF_STMT.IF_LT_LABEL, t->COMP_IF_STMT.IF_EQ_LABEL, t->COMP_IF_STMT.IF_GT_LABEL);
  }
   return;

  case kREDUCE_STMT:
# line 1524 "FUnparse.puma"
  {
# line 1526 "FUnparse.puma"
   GetString (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, string);
# line 1527 "FUnparse.puma"
   fprintf (f, "reduce (%s,", string);
# line 1528 "FUnparse.puma"
   ParamUnparse (t->REDUCE_STMT.RED_PARAMS);
# line 1529 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kCALL_STMT:
# line 1532 "FUnparse.puma"
  {
# line 1534 "FUnparse.puma"
   GetString (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, string);
# line 1535 "FUnparse.puma"
   fprintf (f, "call %s (", string);
# line 1536 "FUnparse.puma"
   ParamUnparse (t->CALL_STMT.CALL_PARAMS);
# line 1537 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kMOVE_STMT:
  if (t->MOVE_STMT.MASK->Kind == kNO_PARAM) {
# line 1540 "FUnparse.puma"
  {
# line 1542 "FUnparse.puma"
   Unparse (t->MOVE_STMT.TARGET);
# line 1543 "FUnparse.puma"
   fprintf (f, " = ");
# line 1544 "FUnparse.puma"
   Unparse (t->MOVE_STMT.SOURCE);
# line 1545 "FUnparse.puma"
   fprintf (f, " ! communication");
  }
   return;

  }
# line 1548 "FUnparse.puma"
  {
# line 1550 "FUnparse.puma"
   Unparse (t->MOVE_STMT.TARGET);
# line 1551 "FUnparse.puma"
   fprintf (f, " = ");
# line 1552 "FUnparse.puma"
   Unparse (t->MOVE_STMT.SOURCE);
# line 1553 "FUnparse.puma"
   fprintf (f, " for ");
# line 1554 "FUnparse.puma"
   Unparse (t->MOVE_STMT.MASK);
# line 1555 "FUnparse.puma"
   fprintf (f, " ! communication");
  }
   return;

  case kSCATTER_STMT:
# line 1558 "FUnparse.puma"
  {
# line 1560 "FUnparse.puma"
   GetString (t->SCATTER_STMT.func, string);
# line 1561 "FUnparse.puma"
   fprintf (f, "%s ", string);
# line 1562 "FUnparse.puma"
   Unparse (t->SCATTER_STMT.ARRAY);
# line 1563 "FUnparse.puma"
 if (t->SCATTER_STMT.func == IsIdent ("GET_SCATTER"))
        fprintf (f," from ");
      else
        fprintf (f," to ");
   
# line 1568 "FUnparse.puma"
   Unparse (t->SCATTER_STMT.BASE);
# line 1569 "FUnparse.puma"
   fprintf (f, "(");
# line 1570 "FUnparse.puma"
   ParamUnparse (t->SCATTER_STMT.INDEXES);
# line 1571 "FUnparse.puma"
   fprintf (f, ") with MASK = ");
# line 1572 "FUnparse.puma"
   Unparse (t->SCATTER_STMT.MASK);
  }
   return;

  case kREDUCTION_STMT:
# line 1575 "FUnparse.puma"
  {
# line 1577 "FUnparse.puma"
   fprintf (f, "reduction (");
# line 1578 "FUnparse.puma"
   Unparse (t->REDUCTION_STMT.REDFUNC);
# line 1579 "FUnparse.puma"
   fprintf (f, ",");
# line 1580 "FUnparse.puma"
   Unparse (t->REDUCTION_STMT.ELEMS);
# line 1581 "FUnparse.puma"
   fprintf (f, ") along ");
# line 1582 "FUnparse.puma"
   OnSpecUnparse (t->REDUCTION_STMT.RED_TOP, t->REDUCTION_STMT.RED_SPEC);
  }
   return;

  case kBROADCAST_STMT:
# line 1585 "FUnparse.puma"
  {
# line 1587 "FUnparse.puma"
   fprintf (f, "broadcast (");
# line 1588 "FUnparse.puma"
   Unparse (t->BROADCAST_STMT.ELEMS);
# line 1589 "FUnparse.puma"
   fprintf (f, ") from ");
# line 1590 "FUnparse.puma"
   OnSpecUnparse (t->BROADCAST_STMT.OWNER_TOP, t->BROADCAST_STMT.OWNER_SPEC);
  }
   return;

  case kALLOCATE_STMT:
# line 1593 "FUnparse.puma"
  {
# line 1595 "FUnparse.puma"
   fprintf (f, "allocate (");
# line 1596 "FUnparse.puma"
   Unparse (t->ALLOCATE_STMT.PARAMS);
# line 1597 "FUnparse.puma"
   StatusUnparse (t->ALLOCATE_STMT.STATUS);
# line 1598 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kDEALLOCATE_STMT:
# line 1601 "FUnparse.puma"
  {
# line 1603 "FUnparse.puma"
   fprintf (f, "deallocate (");
# line 1604 "FUnparse.puma"
   Unparse (t->DEALLOCATE_STMT.PARAMS);
# line 1605 "FUnparse.puma"
   StatusUnparse (t->DEALLOCATE_STMT.STATUS);
# line 1606 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kCREATE_DSP_STMT:
# line 1609 "FUnparse.puma"
  {
# line 1611 "FUnparse.puma"
   fprintf (f, "create_descriptor [");
# line 1612 "FUnparse.puma"
   DspKindUnparse (t->CREATE_DSP_STMT.flag);
# line 1613 "FUnparse.puma"
   fprintf (f, "] ", t->CREATE_DSP_STMT.flag);
# line 1614 "FUnparse.puma"
   Unparse (t->CREATE_DSP_STMT.VAR);
# line 1615 "FUnparse.puma"
   fprintf (f, "(");
# line 1616 "FUnparse.puma"
   Unparse (t->CREATE_DSP_STMT.SHAPE);
# line 1617 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kINHERIT_DSP_STMT:
# line 1620 "FUnparse.puma"
  {
# line 1622 "FUnparse.puma"
   fprintf (f, "inherit_descriptor [");
# line 1623 "FUnparse.puma"
   DspKindUnparse (t->INHERIT_DSP_STMT.flag);
# line 1624 "FUnparse.puma"
   fprintf (f, "] ", t->INHERIT_DSP_STMT.flag);
# line 1625 "FUnparse.puma"
   Unparse (t->INHERIT_DSP_STMT.VAR);
# line 1626 "FUnparse.puma"
   fprintf (f, "(");
# line 1627 "FUnparse.puma"
   Unparse (t->INHERIT_DSP_STMT.SHAPE);
# line 1628 "FUnparse.puma"
   fprintf (f, ") safe = %d", t->INHERIT_DSP_STMT.safety);
  }
   return;

  case kFREE_DSP_STMT:
# line 1631 "FUnparse.puma"
  {
# line 1633 "FUnparse.puma"
   fprintf (f, "free_descriptor [");
# line 1634 "FUnparse.puma"
   DspKindUnparse (t->FREE_DSP_STMT.flag);
# line 1635 "FUnparse.puma"
   fprintf (f, "] ", t->FREE_DSP_STMT.flag);
# line 1636 "FUnparse.puma"
   Unparse (t->FREE_DSP_STMT.VAR);
  }
   return;

  case kNULLIFY_STMT:
# line 1639 "FUnparse.puma"
  {
# line 1641 "FUnparse.puma"
   fprintf (f, "nullify (");
# line 1642 "FUnparse.puma"
   Unparse (t->NULLIFY_STMT.PARAMS);
# line 1643 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kREALIGN_STMT:
# line 1646 "FUnparse.puma"
  {
# line 1648 "FUnparse.puma"
   fprintf (f, "realign (");
# line 1649 "FUnparse.puma"
   Unparse (t->REALIGN_STMT.ALIGN_SOURCE);
# line 1650 "FUnparse.puma"
   fprintf (f, ") WITH ");
# line 1651 "FUnparse.puma"
   AlignSpecUnparse (t->REALIGN_STMT.ALIGN_TARGET);
# line 1652 "FUnparse.puma"
   fprintf (f, " :: ");
# line 1653 "FUnparse.puma"
   Unparse (t->REALIGN_STMT.ALIGNEE);
  }
   return;

  case kREDISTRIBUTE_STMT:
# line 1656 "FUnparse.puma"
  {
# line 1658 "FUnparse.puma"
   fprintf (f, "redistribute ");
# line 1659 "FUnparse.puma"
   Unparse (t->REDISTRIBUTE_STMT.DISTRIBUTEE);
# line 1660 "FUnparse.puma"
   LayoutUnparse (t->REDISTRIBUTE_STMT.DISTRIBUTION);
# line 1661 "FUnparse.puma"
   ProcSpecUnparse (t->REDISTRIBUTE_STMT.TARGET);
  }
   return;

  case kREG_SHADOW_GET:
# line 1664 "FUnparse.puma"
  {
# line 1666 "FUnparse.puma"
   fprintf (f, "overlap_get ");
# line 1667 "FUnparse.puma"
   Unparse (t->REG_SHADOW_GET.SHADOW_VAR);
# line 1668 "FUnparse.puma"
   fprintf (f, " BY [");
# line 1669 "FUnparse.puma"
   Unparse (t->REG_SHADOW_GET.SHADOW_SIZE);
# line 1670 "FUnparse.puma"
   fprintf (f, "]");
  }
   return;

  case kREG_SHADOW_PUT:
# line 1673 "FUnparse.puma"
  {
# line 1675 "FUnparse.puma"
   fprintf (f, "overlap_put (op = %d) ", t->REG_SHADOW_PUT.op);
# line 1676 "FUnparse.puma"
   Unparse (t->REG_SHADOW_PUT.SHADOW_VAR);
# line 1677 "FUnparse.puma"
   fprintf (f, " BY [");
# line 1678 "FUnparse.puma"
   Unparse (t->REG_SHADOW_PUT.SHADOW_SIZE);
# line 1679 "FUnparse.puma"
   fprintf (f, "]");
  }
   return;

  case kREG_SHADOW_SET:
# line 1682 "FUnparse.puma"
  {
# line 1684 "FUnparse.puma"
   fprintf (f, "overlap_set ");
# line 1685 "FUnparse.puma"
   Unparse (t->REG_SHADOW_SET.SHADOW_VAR);
# line 1686 "FUnparse.puma"
   fprintf (f, " BY [");
# line 1687 "FUnparse.puma"
   Unparse (t->REG_SHADOW_SET.SHADOW_SIZE);
# line 1688 "FUnparse.puma"
   fprintf (f, "] with ");
# line 1689 "FUnparse.puma"
   Unparse (t->REG_SHADOW_SET.VAL);
  }
   return;

  case kIND_SHADOW_CREATE:
# line 1692 "FUnparse.puma"
  {
# line 1694 "FUnparse.puma"
   fprintf (f, "create_shadow (id=%d) for ", t->IND_SHADOW_CREATE.id);
# line 1695 "FUnparse.puma"
   Unparse (t->IND_SHADOW_CREATE.SHADOW_VAR);
# line 1696 "FUnparse.puma"
   fprintf (f, " by ");
# line 1697 "FUnparse.puma"
   Unparse (t->IND_SHADOW_CREATE.INDEX_VAR);
# line 1698 "FUnparse.puma"
   fprintf (f, " <- ");
# line 1699 "FUnparse.puma"
   Unparse (t->IND_SHADOW_CREATE.MASK);
# line 1700 "FUnparse.puma"
   fprintf (f, " mask = ");
# line 1701 "FUnparse.puma"
   Unparse (t->IND_SHADOW_CREATE.TMP_INDEX_VAR);
  }
   return;

  case kIND_SHADOW_FREE:
# line 1704 "FUnparse.puma"
  {
# line 1706 "FUnparse.puma"
   fprintf (f, "free_shadow (id=%d) by ", t->IND_SHADOW_FREE.id);
# line 1707 "FUnparse.puma"
   Unparse (t->IND_SHADOW_FREE.INDEX_VAR);
  }
   return;

  case kIND_SHADOW_GET:
# line 1710 "FUnparse.puma"
  {
# line 1712 "FUnparse.puma"
   fprintf (f, "get_shadow (id=%d) for ", t->IND_SHADOW_GET.id);
# line 1713 "FUnparse.puma"
   Unparse (t->IND_SHADOW_GET.SHADOW_VAR);
  }
   return;

  case kIND_SHADOW_PUT:
# line 1716 "FUnparse.puma"
  {
# line 1718 "FUnparse.puma"
   fprintf (f, "put_shadow (id=%d, op=%d) for ", t->IND_SHADOW_PUT.id, t->IND_SHADOW_PUT.op);
# line 1719 "FUnparse.puma"
   Unparse (t->IND_SHADOW_PUT.SHADOW_VAR);
  }
   return;

  case kIND_SHADOW_SET:
# line 1722 "FUnparse.puma"
  {
# line 1724 "FUnparse.puma"
   fprintf (f, "set_shadow (id=%d) for ", t->IND_SHADOW_SET.id);
# line 1725 "FUnparse.puma"
   Unparse (t->IND_SHADOW_SET.SHADOW_VAR);
# line 1726 "FUnparse.puma"
   fprintf (f, " with ");
# line 1727 "FUnparse.puma"
   Unparse (t->IND_SHADOW_SET.VAL);
  }
   return;

  case kDIRTY_STMT:
# line 1730 "FUnparse.puma"
  {
# line 1732 "FUnparse.puma"
   fprintf (f, "dirty [");
# line 1733 "FUnparse.puma"
   Unparse (t->DIRTY_STMT.ELEMS);
# line 1734 "FUnparse.puma"
   fprintf (f, "]");
  }
   return;

  case kIO_STMT:
  if (t->IO_STMT.IO_ITEMS->Kind == kBTP_EMPTY) {
# line 1743 "FUnparse.puma"
  {
# line 1745 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("PRINT")))) goto yyL166;
  {
# line 1747 "FUnparse.puma"
   fprintf (f, "print ");
# line 1748 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
  }
  }
   return;
yyL166:;

  }
# line 1751 "FUnparse.puma"
  {
# line 1753 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("PRINT")))) goto yyL167;
  {
# line 1755 "FUnparse.puma"
   fprintf (f, "print ");
# line 1756 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1757 "FUnparse.puma"
   fprintf (f, ",");
# line 1758 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL167:;

  if (t->IO_STMT.IO_SPECS->Kind == kBTP_LIST) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1761 "FUnparse.puma"
  {
# line 1763 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL168;
  {
# line 1765 "FUnparse.puma"
   if (! ((IsDummyParam (t->IO_STMT.IO_SPECS->BTP_LIST.Elem)))) goto yyL168;
  {
# line 1767 "FUnparse.puma"
   fprintf (f, "read *, ");
# line 1768 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
  }
   return;
yyL168:;

  }
  }
# line 1771 "FUnparse.puma"
  {
# line 1773 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL169;
  {
# line 1775 "FUnparse.puma"
   fprintf (f, "read (");
# line 1776 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1777 "FUnparse.puma"
   fprintf (f, ") ");
# line 1778 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL169:;

# line 1781 "FUnparse.puma"
  {
# line 1783 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("WRITE")))) goto yyL170;
  {
# line 1785 "FUnparse.puma"
   fprintf (f, "write (");
# line 1786 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1787 "FUnparse.puma"
   fprintf (f, ") ");
# line 1788 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL170:;

# line 1791 "FUnparse.puma"
  {
# line 1793 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("OPEN")))) goto yyL171;
  {
# line 1795 "FUnparse.puma"
   fprintf (f, "open (");
# line 1796 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1797 "FUnparse.puma"
   fprintf (f, ") ");
# line 1798 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL171:;

# line 1801 "FUnparse.puma"
  {
# line 1803 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("CLOSE")))) goto yyL172;
  {
# line 1805 "FUnparse.puma"
   fprintf (f, "close (");
# line 1806 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1807 "FUnparse.puma"
   fprintf (f, ") ");
# line 1808 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL172:;

# line 1811 "FUnparse.puma"
  {
# line 1813 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("REWIND")))) goto yyL173;
  {
# line 1815 "FUnparse.puma"
   fprintf (f, "rewind (");
# line 1816 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1817 "FUnparse.puma"
   fprintf (f, ") ");
# line 1818 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL173:;

# line 1821 "FUnparse.puma"
  {
# line 1823 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("BACKSPACE")))) goto yyL174;
  {
# line 1825 "FUnparse.puma"
   fprintf (f, "backspace (");
# line 1826 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1827 "FUnparse.puma"
   fprintf (f, ") ");
# line 1828 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL174:;

# line 1831 "FUnparse.puma"
  {
# line 1833 "FUnparse.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("INQUIRE")))) goto yyL175;
  {
# line 1835 "FUnparse.puma"
   fprintf (f, "inquire (");
# line 1836 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_SPECS);
# line 1837 "FUnparse.puma"
   fprintf (f, ") ");
# line 1838 "FUnparse.puma"
   Unparse (t->IO_STMT.IO_ITEMS);
  }
  }
   return;
yyL175:;

# line 1841 "FUnparse.puma"
  {
# line 1843 "FUnparse.puma"
   GetString (t->IO_STMT.ID->PROC_OBJ.Ident, string);
# line 1844 "FUnparse.puma"
   fprintf (f, "%s is unknown io-statement", string);
  }
   return;

  case kBTP_LIST:
# line 1853 "FUnparse.puma"
  {
# line 1855 "FUnparse.puma"
   if (! ((MoreParameters (t->BTP_LIST.Next)))) goto yyL177;
  {
# line 1857 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
# line 1858 "FUnparse.puma"
   fprintf (f, ",");
# line 1859 "FUnparse.puma"
   Unparse (t->BTP_LIST.Next);
  }
  }
   return;
yyL177:;

# line 1862 "FUnparse.puma"
  {
# line 1863 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
  }
   return;

  case kBTP_EMPTY:
# line 1866 "FUnparse.puma"
   return;

  case kNO_PARAM:
# line 1869 "FUnparse.puma"
  {
# line 1871 "FUnparse.puma"
   if (! ((t->NO_PARAM.type == kSTRING_TYPE))) goto yyL180;
  {
# line 1872 "FUnparse.puma"
   fprintf (f, "%%val(1)");
  }
  }
   return;
yyL180:;

# line 1875 "FUnparse.puma"
  {
# line 1877 "FUnparse.puma"
   fprintf (f, "%%val(0)");
  }
   return;

  case kNAMED_PARAM:
# line 1880 "FUnparse.puma"
  {
# line 1881 "FUnparse.puma"
   GetString (t->NAMED_PARAM.Name, string);
# line 1882 "FUnparse.puma"
   fprintf (f, "%s=", string);
# line 1883 "FUnparse.puma"
   Unparse (t->NAMED_PARAM.VAL);
  }
   return;

  case kVAR_PARAM:
# line 1886 "FUnparse.puma"
  {
# line 1887 "FUnparse.puma"
   Unparse (t->VAR_PARAM.V);
  }
   return;

  case kVALUE_PARAM:
# line 1890 "FUnparse.puma"
  {
# line 1891 "FUnparse.puma"
   Unparse (t->VALUE_PARAM.E);
  }
   return;

  case kRETURN_PARAM:
# line 1894 "FUnparse.puma"
  {
# line 1895 "FUnparse.puma"
   fprintf (f, "*%d", t->RETURN_PARAM.label);
  }
   return;

  case kPROC_PARAM:
# line 1898 "FUnparse.puma"
  {
# line 1899 "FUnparse.puma"
   Unparse (t->PROC_PARAM.P);
  }
   return;

  case kFUNC_PARAM:
# line 1902 "FUnparse.puma"
  {
# line 1903 "FUnparse.puma"
   Unparse (t->FUNC_PARAM.F);
  }
   return;

  case kPROC_OBJ:
# line 1906 "FUnparse.puma"
  {
# line 1907 "FUnparse.puma"
   GetString (t->PROC_OBJ.Ident, string);
# line 1908 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 1917 "FUnparse.puma"
  {
# line 1919 "FUnparse.puma"
   Unparse (t->BTE_LIST.Elem);
  }
   return;

  }
# line 1922 "FUnparse.puma"
  {
# line 1924 "FUnparse.puma"
   Unparse (t->BTE_LIST.Elem);
# line 1925 "FUnparse.puma"
   fprintf (f, ",");
# line 1926 "FUnparse.puma"
   Unparse (t->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 1929 "FUnparse.puma"
   return;

  case kDUMMY_EXP:
# line 1932 "FUnparse.puma"
  {
# line 1932 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kCONST_EXP:
# line 1933 "FUnparse.puma"
  {
# line 1933 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kVAR_EXP:
# line 1934 "FUnparse.puma"
  {
# line 1934 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kOP_EXP:
# line 1935 "FUnparse.puma"
  {
# line 1935 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kOP1_EXP:
# line 1936 "FUnparse.puma"
  {
# line 1936 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kTYPE_EXP:
# line 1937 "FUnparse.puma"
  {
# line 1937 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kARRAY_EXP:
# line 1938 "FUnparse.puma"
  {
# line 1938 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kBOUND_EXP:
# line 1939 "FUnparse.puma"
  {
# line 1939 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kRANK_EXP:
# line 1940 "FUnparse.puma"
  {
# line 1940 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kSLICE_EXP:
# line 1941 "FUnparse.puma"
  {
# line 1941 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kFUNC_CALL_EXP:
# line 1942 "FUnparse.puma"
  {
# line 1942 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kDO_EXP:
# line 1943 "FUnparse.puma"
  {
# line 1943 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kNAMED_EXP:
# line 1944 "FUnparse.puma"
  {
# line 1944 "FUnparse.puma"
   ExpUnparse (t, 0, 0);
  }
   return;

  case kBOOL_CONSTANT:
  if (equalint (t->BOOL_CONSTANT.value, 1)) {
# line 1952 "FUnparse.puma"
  {
# line 1954 "FUnparse.puma"
   fprintf (f, ".TRUE.");
  }
   return;

  }
  if (equalint (t->BOOL_CONSTANT.value, 0)) {
# line 1957 "FUnparse.puma"
  {
# line 1959 "FUnparse.puma"
   fprintf (f, ".FALSE.");
  }
   return;

  }
  break;
  case kINT_CONSTANT:
# line 1962 "FUnparse.puma"
  {
# line 1964 "FUnparse.puma"
   fprintf (f, "%d", t->INT_CONSTANT.value);
  }
   return;

  case kREAL_CONSTANT:
# line 1967 "FUnparse.puma"
  {
# line 1969 "FUnparse.puma"
   StGetString (t->REAL_CONSTANT.value, string);
# line 1970 "FUnparse.puma"
   MyPrintString (f, string);
  }
   return;

  case kCOMPLEX_CONSTANT:
# line 1973 "FUnparse.puma"
  {
# line 1975 "FUnparse.puma"
   fprintf (f, "(");
# line 1976 "FUnparse.puma"
   StGetString (t->COMPLEX_CONSTANT.rvalue, string);
# line 1977 "FUnparse.puma"
   MyPrintString (f, string);
# line 1978 "FUnparse.puma"
   fprintf (f, ",");
# line 1979 "FUnparse.puma"
   StGetString (t->COMPLEX_CONSTANT.ivalue, string);
# line 1980 "FUnparse.puma"
   MyPrintString (f, string);
# line 1981 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSTRING_CONSTANT:
# line 1984 "FUnparse.puma"
  {
# line 1986 "FUnparse.puma"
   StGetString (t->STRING_CONSTANT.value, string);
# line 1987 "FUnparse.puma"
   fprintf (f, "\'");
# line 1988 "FUnparse.puma"
   MyPrintString (f, string);
# line 1989 "FUnparse.puma"
   fprintf (f, "\'");
  }
   return;

  case kBTV_LIST:
  if (t->BTV_LIST.Next->Kind == kBTV_LIST) {
# line 1998 "FUnparse.puma"
  {
# line 2000 "FUnparse.puma"
   Unparse (t->BTV_LIST.Elem);
# line 2001 "FUnparse.puma"
   fprintf (f, ",");
# line 2002 "FUnparse.puma"
   Unparse (t->BTV_LIST.Next);
  }
   return;

  }
  if (t->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 2005 "FUnparse.puma"
  {
# line 2007 "FUnparse.puma"
   Unparse (t->BTV_LIST.Elem);
  }
   return;

  }
  break;
  case kBTV_EMPTY:
# line 2010 "FUnparse.puma"
   return;

  case kLOOP_VAR:
# line 2013 "FUnparse.puma"
  {
# line 2015 "FUnparse.puma"
   Unparse (t->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kUSED_VAR:
# line 2018 "FUnparse.puma"
  {
# line 2020 "FUnparse.puma"
   Unparse (t->USED_VAR.VARNAME);
  }
   return;

  case kDUMMY_VAR:
# line 2023 "FUnparse.puma"
  {
# line 2025 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kREMOTE_VAR:
# line 2028 "FUnparse.puma"
  {
# line 2030 "FUnparse.puma"
   fprintf (f, "#");
# line 2031 "FUnparse.puma"
   Unparse (t->REMOTE_VAR.VAR);
  }
   return;

  case kINDEXED_VAR:
# line 2034 "FUnparse.puma"
  {
# line 2036 "FUnparse.puma"
   Unparse (t->INDEXED_VAR.IND_VAR);
# line 2037 "FUnparse.puma"
   fprintf (f, "(");
# line 2038 "FUnparse.puma"
   Unparse (t->INDEXED_VAR.IND_EXPS);
# line 2039 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSUBSTRING_VAR:
# line 2042 "FUnparse.puma"
  {
# line 2044 "FUnparse.puma"
   Unparse (t->SUBSTRING_VAR.IND_VAR);
# line 2045 "FUnparse.puma"
   fprintf (f, "(");
# line 2046 "FUnparse.puma"
   Unparse (t->SUBSTRING_VAR.IND_EXP);
# line 2047 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kADDR:
# line 2050 "FUnparse.puma"
  {
# line 2052 "FUnparse.puma"
   Unparse (t->ADDR.E);
  }
   return;

  case kSELECTED_VAR:
# line 2055 "FUnparse.puma"
  {
# line 2057 "FUnparse.puma"
   Unparse (t->SELECTED_VAR.SELEC_VAR);
# line 2058 "FUnparse.puma"
   fprintf (f, "%%");
# line 2059 "FUnparse.puma"
   Unparse (t->SELECTED_VAR.SELECTOR);
  }
   return;

  case kPERM_VAR:
# line 2062 "FUnparse.puma"
 {
  int i;
  {
# line 2064 "FUnparse.puma"

# line 2066 "FUnparse.puma"
   fprintf (f, "permute(");
# line 2067 "FUnparse.puma"
   Unparse (t->PERM_VAR.VAL);
# line 2068 "FUnparse.puma"
   fprintf (f, ",<");
# line 2069 "FUnparse.puma"
 for (i=1; i<=t->PERM_VAR.perm.n; i++) 
       { fprintf (f,"%d", t->PERM_VAR.perm.pa[i-1]);
         if (i<t->PERM_VAR.perm.n) fprintf (f,",");
       }
   
# line 2074 "FUnparse.puma"
   fprintf (f, ",>)");
  }
   return;
 }

  case kDO_VAR:
# line 2077 "FUnparse.puma"
  {
# line 2079 "FUnparse.puma"
   fprintf (f, "(");
# line 2080 "FUnparse.puma"
   Unparse (t->DO_VAR.BODY);
# line 2081 "FUnparse.puma"
   fprintf (f, ", ");
# line 2082 "FUnparse.puma"
   Unparse (t->DO_VAR.DO_ID);
# line 2083 "FUnparse.puma"
   fprintf (f, "=");
# line 2084 "FUnparse.puma"
   UnparseDoRange (t->DO_VAR.RANGE);
# line 2085 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSHAPE_LIST:
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_LIST) {
# line 2094 "FUnparse.puma"
  {
# line 2096 "FUnparse.puma"
   Unparse (t->SHAPE_LIST.Elem);
# line 2097 "FUnparse.puma"
   fprintf (f, ",");
# line 2098 "FUnparse.puma"
   Unparse (t->SHAPE_LIST.Next);
  }
   return;

  }
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
# line 2101 "FUnparse.puma"
  {
# line 2103 "FUnparse.puma"
   Unparse (t->SHAPE_LIST.Elem);
  }
   return;

  }
  break;
  case kTYPE_ID:
# line 2106 "FUnparse.puma"
  {
# line 2108 "FUnparse.puma"
   fprintf (f, "type (");
# line 2109 "FUnparse.puma"
   Unparse (t->TYPE_ID.ID);
# line 2110 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSTRING_TYPE:
  if (t->STRING_TYPE.LENGTH->Kind == kCONST_EXP) {
  if (t->STRING_TYPE.LENGTH->CONST_EXP.C->Kind == kINT_CONSTANT) {
  if (equalint (t->STRING_TYPE.LENGTH->CONST_EXP.C->INT_CONSTANT.value, - 1)) {
# line 2113 "FUnparse.puma"
  {
# line 2115 "FUnparse.puma"
   fprintf (f, "character*(*)");
  }
   return;

  }
  }
  }
  if (t->STRING_TYPE.LENGTH->Kind == kDUMMY_EXP) {
# line 2118 "FUnparse.puma"
  {
# line 2120 "FUnparse.puma"
   fprintf (f, "character*(*)");
  }
   return;

  }
# line 2123 "FUnparse.puma"
  {
# line 2125 "FUnparse.puma"
   fprintf (f, "character*");
# line 2126 "FUnparse.puma"
   Unparse (t->STRING_TYPE.LENGTH);
  }
   return;

  case kARRAY_TYPE:
# line 2129 "FUnparse.puma"
  {
# line 2131 "FUnparse.puma"
   Unparse (t->ARRAY_TYPE.ARRAY_COMP_TYPE);
# line 2132 "FUnparse.puma"
   fprintf (f, " (", string);
# line 2133 "FUnparse.puma"
   Unparse (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 2134 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kPOINTER_TYPE:
# line 2137 "FUnparse.puma"
  {
# line 2139 "FUnparse.puma"
   fprintf (f, "pointer ");
# line 2140 "FUnparse.puma"
   Unparse (t->POINTER_TYPE.PTR_COMP);
  }
   return;

  case kRECORD_TYPE:
# line 2143 "FUnparse.puma"
  {
# line 2145 "FUnparse.puma"
   fprintf (f, "type\n");
# line 2146 "FUnparse.puma"
   IncIndent ();
# line 2147 "FUnparse.puma"
   Unparse (t->RECORD_TYPE.COMPONENTS);
# line 2148 "FUnparse.puma"
   DecIndent ();
# line 2149 "FUnparse.puma"
   ind ();
# line 2150 "FUnparse.puma"
   fprintf (f, "end");
  }
   return;

  case kEXPLICIT_SHAPE:
# line 2153 "FUnparse.puma"
  {
# line 2155 "FUnparse.puma"
   Unparse (t->EXPLICIT_SHAPE.LOWER);
# line 2156 "FUnparse.puma"
   fprintf (f, ":");
# line 2157 "FUnparse.puma"
   Unparse (t->EXPLICIT_SHAPE.UPPER);
# line 2158 "FUnparse.puma"
   OverlapUnparse (t->EXPLICIT_SHAPE.Overlap);
  }
   return;

  case kDEFERRED_SHAPE:
# line 2161 "FUnparse.puma"
  {
# line 2163 "FUnparse.puma"
   fprintf (f, ":");
# line 2164 "FUnparse.puma"
   OverlapUnparse (t->DEFERRED_SHAPE.Overlap);
  }
   return;

  case kASSUMED_SHAPE:
# line 2167 "FUnparse.puma"
  {
# line 2169 "FUnparse.puma"
   Unparse (t->ASSUMED_SHAPE.LOWER);
# line 2170 "FUnparse.puma"
   fprintf (f, ":");
# line 2171 "FUnparse.puma"
   OverlapUnparse (t->ASSUMED_SHAPE.Overlap);
  }
   return;

  case kASSUMED_SIZE:
# line 2174 "FUnparse.puma"
  {
# line 2176 "FUnparse.puma"
   Unparse (t->ASSUMED_SIZE.LOWER);
# line 2177 "FUnparse.puma"
   fprintf (f, ":*");
# line 2178 "FUnparse.puma"
   OverlapUnparse (t->ASSUMED_SIZE.Overlap);
  }
   return;

  case kINTEGER_TYPE:
# line 2181 "FUnparse.puma"
  {
# line 2183 "FUnparse.puma"
   fprintf (f, "integer");
# line 2184 "FUnparse.puma"
   SizeUnparse (t->INTEGER_TYPE.SIZE);
  }
   return;

  case kBOOLEAN_TYPE:
# line 2187 "FUnparse.puma"
  {
# line 2189 "FUnparse.puma"
   fprintf (f, "logical");
# line 2190 "FUnparse.puma"
   SizeUnparse (t->BOOLEAN_TYPE.SIZE);
  }
   return;

  case kCOMPLEX_TYPE:
# line 2193 "FUnparse.puma"
  {
# line 2195 "FUnparse.puma"
   fprintf (f, "complex");
# line 2196 "FUnparse.puma"
   SizeUnparse (t->COMPLEX_TYPE.SIZE);
  }
   return;

  case kREAL_TYPE:
# line 2199 "FUnparse.puma"
  {
# line 2201 "FUnparse.puma"
   fprintf (f, "real");
# line 2202 "FUnparse.puma"
   SizeUnparse (t->REAL_TYPE.SIZE);
  }
   return;

  case kTYPE_OBJ:
# line 2205 "FUnparse.puma"
  {
# line 2207 "FUnparse.puma"
   GetString (t->TYPE_OBJ.Ident, string);
# line 2208 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kREC_COMP:
# line 2211 "FUnparse.puma"
  {
# line 2213 "FUnparse.puma"
   GetString (t->REC_COMP.Ident, string);
# line 2214 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kDUMMY_TYPE:
# line 2217 "FUnparse.puma"
   return;

  case kALIGN_TYPE:
# line 2220 "FUnparse.puma"
   return;

  case kVAR_OBJ:
# line 2223 "FUnparse.puma"
  {
# line 2225 "FUnparse.puma"
   GetString (t->VAR_OBJ.Ident, string);
# line 2226 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  case kTOP_OBJ:
# line 2229 "FUnparse.puma"
  {
# line 2231 "FUnparse.puma"
   GetString (t->TOP_OBJ.Ident, string);
# line 2232 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }

# line 2235 "FUnparse.puma"
  {
# line 2236 "FUnparse.puma"
   fprintf (f, "<unknown_structure>");
# line 2237 "FUnparse.puma"
   WriteTree (f, t);
  }
   return;

;
}

static int Priority
# if defined __STDC__ | defined __cplusplus
(register tTree yyP1)
# else
(yyP1)
 register tTree yyP1;
# endif
{

  switch (yyP1->Kind) {
  case kOP_DEFINED:
# line 2259 "FUnparse.puma"
   return 1;

  case kOP_EQV:
# line 2261 "FUnparse.puma"
   return 2;

  case kOP_NEQV:
# line 2262 "FUnparse.puma"
   return 2;

  case kOP_OR:
# line 2264 "FUnparse.puma"
   return 3;

  case kOP_XOR:
# line 2265 "FUnparse.puma"
   return 3;

  case kOP_AND:
# line 2267 "FUnparse.puma"
   return 4;

  case kOP1_NOT:
# line 2269 "FUnparse.puma"
   return 5;

  case kOP_EQ:
# line 2271 "FUnparse.puma"
   return 6;

  case kOP_NE:
# line 2272 "FUnparse.puma"
   return 6;

  case kOP_LE:
# line 2273 "FUnparse.puma"
   return 6;

  case kOP_LT:
# line 2274 "FUnparse.puma"
   return 6;

  case kOP_GE:
# line 2275 "FUnparse.puma"
   return 6;

  case kOP_GT:
# line 2276 "FUnparse.puma"
   return 6;

  case kOP_CONCAT:
# line 2278 "FUnparse.puma"
   return 7;

  case kOP_PLUS:
# line 2280 "FUnparse.puma"
   return 8;

  case kOP_MINUS:
# line 2281 "FUnparse.puma"
   return 8;

  case kOP1_SIGN:
# line 2282 "FUnparse.puma"
   return 8;

  case kOP1_PSIGN:
# line 2283 "FUnparse.puma"
   return 8;

  case kOP_TIMES:
# line 2285 "FUnparse.puma"
   return 9;

  case kOP_DIVIDE:
# line 2286 "FUnparse.puma"
   return 9;

  case kOP_EXPO:
# line 2288 "FUnparse.puma"
   return 10;

  }

 yyAbort ("Priority");
}

static void ComUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2298 "FUnparse.puma"
 char string [256]; 
  if (t->Kind == kDECL_EMPTY) {
# line 2300 "FUnparse.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 2303 "FUnparse.puma"
  {
# line 2305 "FUnparse.puma"
   ComUnparse (t->DECL_LIST.Elem);
  }
   return;

  }
# line 2308 "FUnparse.puma"
  {
# line 2310 "FUnparse.puma"
   ComUnparse (t->DECL_LIST.Elem);
# line 2311 "FUnparse.puma"
   fprintf (f, ",");
# line 2312 "FUnparse.puma"
   ComUnparse (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 2315 "FUnparse.puma"
  {
# line 2317 "FUnparse.puma"
   GetString (t->VAR_DECL.Ident, string);
# line 2318 "FUnparse.puma"
   fprintf (f, " %s (", string);
# line 2319 "FUnparse.puma"
   Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 2320 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
# line 2323 "FUnparse.puma"
  {
# line 2325 "FUnparse.puma"
   GetString (t->VAR_DECL.Ident, string);
# line 2326 "FUnparse.puma"
   fprintf (f, " %s", string);
  }
   return;

  }
# line 2329 "FUnparse.puma"
  {
# line 2330 "FUnparse.puma"
   fprintf (f, "<unknown_common_structure>");
  }
   return;

;
}

static void UnparseElse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_EMPTY) {
# line 2341 "FUnparse.puma"
   return;

  }
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_IF) {
  if (equalint (t->ACF_LIST.Elem->ACF_IF.Label, 0)) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 2347 "FUnparse.puma"
  {
# line 2351 "FUnparse.puma"
   ind ();
# line 2352 "FUnparse.puma"
   fprintf (f, " else if (");
# line 2353 "FUnparse.puma"
   Unparse (t->ACF_LIST.Elem->ACF_IF.IF_EXP);
# line 2354 "FUnparse.puma"
   fprintf (f, ") then");
# line 2355 "FUnparse.puma"
   LCR (t->ACF_LIST.Elem->ACF_IF.Line);
# line 2356 "FUnparse.puma"
   IncIndent ();
# line 2357 "FUnparse.puma"
   Unparse (t->ACF_LIST.Elem->ACF_IF.THEN_PART);
# line 2358 "FUnparse.puma"
   DecIndent ();
# line 2359 "FUnparse.puma"
   UnparseElse (t->ACF_LIST.Elem->ACF_IF.ELSE_PART);
  }
   return;

  }
  }
  }
  }
# line 2362 "FUnparse.puma"
  {
# line 2363 "FUnparse.puma"
   ind ();
# line 2364 "FUnparse.puma"
   fprintf (f, " else\n");
# line 2365 "FUnparse.puma"
   IncIndent ();
# line 2366 "FUnparse.puma"
   Unparse (t);
# line 2367 "FUnparse.puma"
   DecIndent ();
  }
   return;

;
}

static void UnparseDoRange
# if defined __STDC__ | defined __cplusplus
(register tTree slice)
# else
(slice)
 register tTree slice;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 2378 "FUnparse.puma"
  {
# line 2380 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.START);
# line 2381 "FUnparse.puma"
   fprintf (f, ",");
# line 2382 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.STOP);
  }
   return;

  }
# line 2385 "FUnparse.puma"
  {
# line 2387 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.START);
# line 2388 "FUnparse.puma"
   fprintf (f, ",");
# line 2389 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.STOP);
# line 2390 "FUnparse.puma"
   fprintf (f, ",");
# line 2391 "FUnparse.puma"
   Unparse (slice->SLICE_EXP.INC);
  }
   return;

  }
;
}

static void ExpUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int leftprio, register int rightprio)
# else
(t, leftprio, rightprio)
 register tTree t;
 register int leftprio;
 register int rightprio;
# endif
{
# line 2415 "FUnparse.puma"

char string [100];
int i;

# line 2420 "FUnparse.puma"
  {
# line 2421 "FUnparse.puma"
   if (! ((t == NoTree))) goto yyL1;
  {
# line 2422 "FUnparse.puma"
   fprintf (f, "<NoTree>");
  }
  }
   return;
yyL1:;


  switch (t->Kind) {
  case kOP_EXP:
# line 2425 "FUnparse.puma"
 {
  int myleftprio;
  int myrightprio;
  {
# line 2427 "FUnparse.puma"

# line 2428 "FUnparse.puma"

# line 2430 "FUnparse.puma"
   myleftprio = Priority (t->OP_EXP.EXP_OP);
# line 2431 "FUnparse.puma"
   myrightprio = myleftprio;
# line 2433 "FUnparse.puma"
 if (t->OP_EXP.EXP_OP->Kind == kOP_EXPO) myleftprio += 1; 
# line 2435 "FUnparse.puma"
 if ((leftprio >= myleftprio) || (rightprio > myrightprio))
      { fprintf (f, "(");
        ExpUnparse (t, 0, 0);
        fprintf (f, ")");
      }
     else
      { ExpUnparse (t->OP_EXP.OPND1, leftprio, myleftprio);
        OpUnparse (t->OP_EXP.EXP_OP);
        ExpUnparse (t->OP_EXP.OPND2, myrightprio, rightprio);
      }
    
  }
   return;
 }

  case kOP1_EXP:
# line 2448 "FUnparse.puma"
 {
  int priority;
  {
# line 2450 "FUnparse.puma"

# line 2452 "FUnparse.puma"
 if (t->OP1_EXP.EXP_OP1->Kind == kOP_DEFINED) priority = 12;
        else priority = Priority (t->OP1_EXP.EXP_OP1);
    
# line 2456 "FUnparse.puma"
 if ((leftprio >= priority) || (rightprio > priority))
      { fprintf (f, "(");
        ExpUnparse (t, 0, 0);
        fprintf (f, ")");
      }
     else
      { OpUnparse (t->OP1_EXP.EXP_OP1);
        ExpUnparse (t->OP1_EXP.OPND, priority, rightprio);
      }
    
  }
   return;
 }

  case kDUMMY_EXP:
# line 2468 "FUnparse.puma"
  {
# line 2469 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kCONST_EXP:
# line 2472 "FUnparse.puma"
  {
# line 2473 "FUnparse.puma"
   Unparse (t->CONST_EXP.C);
  }
   return;

  case kVAR_EXP:
# line 2476 "FUnparse.puma"
  {
# line 2477 "FUnparse.puma"
   Unparse (t->VAR_EXP.V);
  }
   return;

  case kTYPE_EXP:
# line 2480 "FUnparse.puma"
  {
# line 2481 "FUnparse.puma"
   GetString (t->TYPE_EXP.ID->TYPE_OBJ.Ident, string);
# line 2482 "FUnparse.puma"
   fprintf (f, "%s (", string);
# line 2483 "FUnparse.puma"
   Unparse (t->TYPE_EXP.ELEMENTS);
# line 2484 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kARRAY_EXP:
# line 2487 "FUnparse.puma"
  {
# line 2489 "FUnparse.puma"
   fprintf (f, "(/");
# line 2490 "FUnparse.puma"
   Unparse (t->ARRAY_EXP.ELEMENTS);
# line 2491 "FUnparse.puma"
   fprintf (f, "/)");
  }
   return;

  case kBOUND_EXP:
# line 2494 "FUnparse.puma"
  {
# line 2496 "FUnparse.puma"
 if (t->BOUND_EXP.local == 1)
        fprintf (f,"local_");
       else if (t->BOUND_EXP.local == 2)
        fprintf (f,"global_");

     if (t->BOUND_EXP.kind == 0)
        fprintf (f,"lbound(");
      else
        fprintf (f,"ubound(");
   
# line 2506 "FUnparse.puma"
   Unparse (t->BOUND_EXP.VAR);
# line 2507 "FUnparse.puma"
   fprintf (f, ",%d)", t->BOUND_EXP.dim);
  }
   return;

  case kRANK_EXP:
  if (equalint (t->RANK_EXP.kind, 0)) {
# line 2510 "FUnparse.puma"
  {
# line 2512 "FUnparse.puma"
   fprintf (f, "size(processors_shape())");
  }
   return;

  }
  if (equalint (t->RANK_EXP.kind, 1)) {
# line 2515 "FUnparse.puma"
  {
# line 2517 "FUnparse.puma"
   fprintf (f, "size (active_procs_shape ())");
  }
   return;

  }
  break;
  case kSLICE_EXP:
# line 2520 "FUnparse.puma"
  {
# line 2522 "FUnparse.puma"
 if (t->SLICE_EXP.START->Kind != kDUMMY_EXP)
         ExpUnparse (t->SLICE_EXP.START, 0, 0);           
# line 2524 "FUnparse.puma"
   fprintf (f, ":");
# line 2525 "FUnparse.puma"
 if (t->SLICE_EXP.STOP->Kind != kDUMMY_EXP)
         ExpUnparse (t->SLICE_EXP.STOP, 0, 0);           
# line 2527 "FUnparse.puma"
 if (t->SLICE_EXP.INC->Kind != kDUMMY_EXP)
       { fprintf (f,":");
         ExpUnparse (t->SLICE_EXP.INC,0,0);
       }                           
   
  }
   return;

  case kFUNC_CALL_EXP:
# line 2534 "FUnparse.puma"
  {
# line 2536 "FUnparse.puma"
   Unparse (t->FUNC_CALL_EXP.FUNC_ID);
# line 2537 "FUnparse.puma"
   fprintf (f, "(");
# line 2538 "FUnparse.puma"
   Unparse (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 2539 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kDO_EXP:
# line 2542 "FUnparse.puma"
  {
# line 2544 "FUnparse.puma"
   fprintf (f, "(");
# line 2545 "FUnparse.puma"
   Unparse (t->DO_EXP.BODY);
# line 2546 "FUnparse.puma"
   fprintf (f, ", ");
# line 2547 "FUnparse.puma"
   Unparse (t->DO_EXP.DO_ID);
# line 2548 "FUnparse.puma"
   fprintf (f, "=");
# line 2549 "FUnparse.puma"
   UnparseDoRange (t->DO_EXP.RANGE);
# line 2550 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kNAMED_EXP:
# line 2553 "FUnparse.puma"
  {
# line 2555 "FUnparse.puma"
   GetString (t->NAMED_EXP.Name, string);
# line 2556 "FUnparse.puma"
   fprintf (f, "%s=", string);
# line 2557 "FUnparse.puma"
   Unparse (t->NAMED_EXP.VAL);
  }
   return;

  }

# line 2560 "FUnparse.puma"
  {
# line 2562 "FUnparse.puma"
   fprintf (f, "<unknown_exp>");
  }
   return;

;
}

static void OpUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2567 "FUnparse.puma"

char string [100];


  switch (t->Kind) {
  case kOP_EQ:
# line 2571 "FUnparse.puma"
  {
# line 2571 "FUnparse.puma"
   fprintf (f, " .eq. ");
  }
   return;

  case kOP_NE:
# line 2572 "FUnparse.puma"
  {
# line 2572 "FUnparse.puma"
   fprintf (f, " .ne. ");
  }
   return;

  case kOP_LE:
# line 2573 "FUnparse.puma"
  {
# line 2573 "FUnparse.puma"
   fprintf (f, " .le. ");
  }
   return;

  case kOP_LT:
# line 2574 "FUnparse.puma"
  {
# line 2574 "FUnparse.puma"
   fprintf (f, " .lt. ");
  }
   return;

  case kOP_GE:
# line 2575 "FUnparse.puma"
  {
# line 2575 "FUnparse.puma"
   fprintf (f, " .ge. ");
  }
   return;

  case kOP_GT:
# line 2576 "FUnparse.puma"
  {
# line 2576 "FUnparse.puma"
   fprintf (f, " .gt. ");
  }
   return;

  case kOP_PLUS:
# line 2577 "FUnparse.puma"
  {
# line 2577 "FUnparse.puma"
   fprintf (f, "+");
  }
   return;

  case kOP_MINUS:
# line 2578 "FUnparse.puma"
  {
# line 2578 "FUnparse.puma"
   fprintf (f, "-");
  }
   return;

  case kOP_OR:
# line 2579 "FUnparse.puma"
  {
# line 2579 "FUnparse.puma"
   fprintf (f, " .or. ");
  }
   return;

  case kOP_XOR:
# line 2580 "FUnparse.puma"
  {
# line 2580 "FUnparse.puma"
   fprintf (f, " .xor. ");
  }
   return;

  case kOP_CONCAT:
# line 2581 "FUnparse.puma"
  {
# line 2581 "FUnparse.puma"
   fprintf (f, " //");
  }
   return;

  case kOP_TIMES:
# line 2582 "FUnparse.puma"
  {
# line 2582 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kOP_DIVIDE:
# line 2583 "FUnparse.puma"
  {
# line 2583 "FUnparse.puma"
   fprintf (f, "/");
  }
   return;

  case kOP_AND:
# line 2584 "FUnparse.puma"
  {
# line 2584 "FUnparse.puma"
   fprintf (f, " .and. ");
  }
   return;

  case kOP_EQV:
# line 2585 "FUnparse.puma"
  {
# line 2585 "FUnparse.puma"
   fprintf (f, " .eqv. ");
  }
   return;

  case kOP_NEQV:
# line 2586 "FUnparse.puma"
  {
# line 2586 "FUnparse.puma"
   fprintf (f, " .neqv. ");
  }
   return;

  case kOP_EXPO:
# line 2587 "FUnparse.puma"
  {
# line 2587 "FUnparse.puma"
   fprintf (f, "**");
  }
   return;

  case kOP1_NOT:
# line 2589 "FUnparse.puma"
  {
# line 2589 "FUnparse.puma"
   fprintf (f, " .not. ");
  }
   return;

  case kOP1_SIGN:
# line 2590 "FUnparse.puma"
  {
# line 2590 "FUnparse.puma"
   fprintf (f, "-");
  }
   return;

  case kOP1_PSIGN:
# line 2591 "FUnparse.puma"
  {
# line 2591 "FUnparse.puma"
   fprintf (f, "+");
  }
   return;

  case kOP_DEFINED:
# line 2593 "FUnparse.puma"
  {
# line 2595 "FUnparse.puma"
   GetString (t->OP_DEFINED.opname, string);
# line 2596 "FUnparse.puma"
   fprintf (f, " %s ", string);
  }
   return;

  }

# line 2599 "FUnparse.puma"
  {
# line 2601 "FUnparse.puma"
   fprintf (f, "<op?>");
  }
   return;

;
}

static void FormatUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2612 "FUnparse.puma"
 char string[2048]; 
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 2614 "FUnparse.puma"
  {
# line 2616 "FUnparse.puma"
   FormatUnparse (t->BTP_LIST.Elem);
  }
   return;

  }
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 2619 "FUnparse.puma"
  {
# line 2621 "FUnparse.puma"
   FormatUnparse (t->BTP_LIST.Elem);
# line 2622 "FUnparse.puma"
   fprintf (f, "\n", string);
# line 2623 "FUnparse.puma"
   cont_ind ();
# line 2624 "FUnparse.puma"
   FormatUnparse (t->BTP_LIST.Next);
  }
   return;

  }
  }
  if (t->Kind == kFORMAT_PARAM) {
# line 2627 "FUnparse.puma"
  {
# line 2629 "FUnparse.puma"
   StGetString (t->FORMAT_PARAM.S, string);
# line 2630 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
;
}

static void LayoutUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2641 "FUnparse.puma"
 char string[256]; 

  switch (t->Kind) {
  case kANY_DISTRIBUTION:
# line 2643 "FUnparse.puma"
  {
# line 2645 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kDEFAULT_DISTRIBUTION:
# line 2648 "FUnparse.puma"
   return;

  case kREPL_DISTRIBUTION:
# line 2651 "FUnparse.puma"
  {
# line 2653 "FUnparse.puma"
   fprintf (f, "(:replicated)");
  }
   return;

  case kNODE_DISTRIBUTION:
  if (equalint (t->NODE_DISTRIBUTION.is_descriptive, 0)) {
# line 2656 "FUnparse.puma"
  {
# line 2658 "FUnparse.puma"
   fprintf (f, "(");
# line 2659 "FUnparse.puma"
   LayoutUnparse (t->NODE_DISTRIBUTION.MAPPING);
# line 2660 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
  if (equalint (t->NODE_DISTRIBUTION.is_descriptive, 1)) {
# line 2663 "FUnparse.puma"
  {
# line 2665 "FUnparse.puma"
   fprintf (f, "* (");
# line 2666 "FUnparse.puma"
   LayoutUnparse (t->NODE_DISTRIBUTION.MAPPING);
# line 2667 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
  break;
  case kDIST_LIST:
  if (t->DIST_LIST.Next->Kind == kDIST_EMPTY) {
# line 2670 "FUnparse.puma"
  {
# line 2671 "FUnparse.puma"
   LayoutUnparse (t->DIST_LIST.Elem);
  }
   return;

  }
# line 2674 "FUnparse.puma"
  {
# line 2676 "FUnparse.puma"
   LayoutUnparse (t->DIST_LIST.Elem);
# line 2677 "FUnparse.puma"
   fprintf (f, ",");
# line 2678 "FUnparse.puma"
   LayoutUnparse (t->DIST_LIST.Next);
  }
   return;

  case kBLOCK_DISTRIBUTION:
  if (t->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 2681 "FUnparse.puma"
  {
# line 2683 "FUnparse.puma"
   fprintf (f, "block");
  }
   return;

  }
# line 2686 "FUnparse.puma"
  {
# line 2688 "FUnparse.puma"
   fprintf (f, "block(");
# line 2689 "FUnparse.puma"
   Unparse (t->BLOCK_DISTRIBUTION.SIZE);
# line 2690 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kCYCLIC_DISTRIBUTION:
  if (t->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 2693 "FUnparse.puma"
  {
# line 2695 "FUnparse.puma"
   fprintf (f, "cyclic");
  }
   return;

  }
# line 2698 "FUnparse.puma"
  {
# line 2700 "FUnparse.puma"
   fprintf (f, "cyclic(");
# line 2701 "FUnparse.puma"
   Unparse (t->CYCLIC_DISTRIBUTION.SIZE);
# line 2702 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kGEN_BLOCK_DISTRIBUTION:
# line 2705 "FUnparse.puma"
  {
# line 2707 "FUnparse.puma"
   fprintf (f, "gen_block(");
# line 2708 "FUnparse.puma"
   Unparse (t->GEN_BLOCK_DISTRIBUTION.ARRAY);
# line 2709 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kINDIRECT_DISTRIBUTION:
# line 2712 "FUnparse.puma"
  {
# line 2714 "FUnparse.puma"
   fprintf (f, "indirect(");
# line 2715 "FUnparse.puma"
   Unparse (t->INDIRECT_DISTRIBUTION.ARRAY);
# line 2716 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kARBITRARY_DISTRIBUTION:
# line 2719 "FUnparse.puma"
  {
# line 2721 "FUnparse.puma"
   fprintf (f, "arbitrary(");
# line 2722 "FUnparse.puma"
   Unparse (t->ARBITRARY_DISTRIBUTION.SIZE);
# line 2723 "FUnparse.puma"
   fprintf (f, ",");
# line 2724 "FUnparse.puma"
   Unparse (t->ARBITRARY_DISTRIBUTION.LENGTH);
# line 2725 "FUnparse.puma"
   fprintf (f, ",");
# line 2726 "FUnparse.puma"
   Unparse (t->ARBITRARY_DISTRIBUTION.MAP);
# line 2727 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kSERIAL_DISTRIBUTION:
# line 2730 "FUnparse.puma"
  {
# line 2732 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  case kANY_BLOCK_DISTRIBUTION:
# line 2735 "FUnparse.puma"
  {
# line 2737 "FUnparse.puma"
   fprintf (f, "block ()");
  }
   return;

  case kANY_CYCLIC_DISTRIBUTION:
# line 2740 "FUnparse.puma"
  {
# line 2742 "FUnparse.puma"
   fprintf (f, "cyclic ()");
  }
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
# line 2745 "FUnparse.puma"
  {
# line 2747 "FUnparse.puma"
   fprintf (f, "gen_block ()");
  }
   return;

  case kANY_INDIRECT_DISTRIBUTION:
# line 2750 "FUnparse.puma"
  {
# line 2752 "FUnparse.puma"
   fprintf (f, "indirect ()");
  }
   return;

  case kANY_DIM_DISTRIBUTION:
# line 2755 "FUnparse.puma"
  {
# line 2757 "FUnparse.puma"
   fprintf (f, "all");
  }
   return;

  }

# line 2760 "FUnparse.puma"
  {
# line 2761 "FUnparse.puma"
   fprintf (f, "<unknown-layout>");
  }
   return;

;
}

static void ProcSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2777 "FUnparse.puma"
 char string[256]; 
  if (t->Kind == kANY_PROCESSOR_ARRAY) {
# line 2779 "FUnparse.puma"
  {
# line 2781 "FUnparse.puma"
   fprintf (f, " onto *");
  }
   return;

  }
  if (t->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 2784 "FUnparse.puma"
   return;

  }
  if (t->Kind == kPROCESSOR_ARRAY) {
# line 2787 "FUnparse.puma"
  {
# line 2789 "FUnparse.puma"
   if (! (((t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident != DefaultId ()) || (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object == NoObject)))) goto yyL3;
  {
# line 2790 "FUnparse.puma"
   fprintf (f, " onto ");
# line 2791 "FUnparse.puma"
   Unparse (t->PROCESSOR_ARRAY.TOPNAME);
  }
  }
   return;
yyL3:;

  if (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object->Kind == kTopologyObject) {
# line 2794 "FUnparse.puma"
  {
# line 2796 "FUnparse.puma"
 

     if (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object->TopologyObject.rank == 0)
        fprintf (f," onto #all");
      else
        fprintf (f," onto #%d", t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object->TopologyObject.rank);
   
  }
   return;

  }
  }
  if (t->Kind == kPROCESSOR_SUBSET) {
# line 2805 "FUnparse.puma"
  {
# line 2807 "FUnparse.puma"
   fprintf (f, " onto ");
# line 2808 "FUnparse.puma"
   Unparse (t->PROCESSOR_SUBSET.FULLTOP);
# line 2809 "FUnparse.puma"
   fprintf (f, "(");
# line 2810 "FUnparse.puma"
   Unparse (t->PROCESSOR_SUBSET.SUBSCRIPTS);
# line 2811 "FUnparse.puma"
   fprintf (f, ") = ");
# line 2812 "FUnparse.puma"
   Unparse (t->PROCESSOR_SUBSET.SUBTOP);
  }
   return;

  }
# line 2815 "FUnparse.puma"
  {
# line 2816 "FUnparse.puma"
   fprintf (f, "<unknown-proc-spec>");
  }
   return;

;
}

static bool IsDeferredShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kARRAY_TYPE) {
# line 2827 "FUnparse.puma"
  {
# line 2829 "FUnparse.puma"
   if (! ((IsDeferredShape (t->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kSHAPE_LIST) {
# line 2832 "FUnparse.puma"
  {
# line 2834 "FUnparse.puma"
   if (! ((IsDeferredShape (t->SHAPE_LIST.Elem)))) goto yyL2;
  {
# line 2835 "FUnparse.puma"
   if (! ((IsDeferredShape (t->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (t->Kind == kSHAPE_EMPTY) {
# line 2838 "FUnparse.puma"
   return true;

  }
  if (t->Kind == kDEFERRED_SHAPE) {
# line 2841 "FUnparse.puma"
   return true;

  }
  return false;
}

static int UP_List_Length
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 2852 "FUnparse.puma"
   return (1 + UP_List_Length (t->DECL_LIST.Next));

  }
  if (t->Kind == kDECL_EMPTY) {
# line 2856 "FUnparse.puma"
   return 0;

  }
  if (t->Kind == kBTP_LIST) {
# line 2860 "FUnparse.puma"
   return (1 + UP_List_Length (t->BTP_LIST.Next));

  }
  if (t->Kind == kBTP_EMPTY) {
# line 2864 "FUnparse.puma"
   return 0;

  }
 yyAbort ("UP_List_Length");
}

static void FormalParamUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2876 "FUnparse.puma"
 
char string[256]; 

  if (t->Kind == kDECL_EMPTY) {
# line 2880 "FUnparse.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 2883 "FUnparse.puma"
  {
# line 2885 "FUnparse.puma"
   FormalParamUnparse (t->DECL_LIST.Elem);
  }
   return;

  }
# line 2888 "FUnparse.puma"
  {
# line 2890 "FUnparse.puma"
   FormalParamUnparse (t->DECL_LIST.Elem);
# line 2891 "FUnparse.puma"
   fprintf (f, ", ");
# line 2892 "FUnparse.puma"
 if (((UP_List_Length (t->DECL_LIST.Next) + 1) % 8) == 0)
         
         { fprintf (f, "\n");
           fprintf (f, "     $  ");
         }
    
# line 2898 "FUnparse.puma"
   FormalParamUnparse (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 2901 "FUnparse.puma"
  {
# line 2903 "FUnparse.puma"
   GetString (t->VAR_PARAM_DECL.Ident, string);
# line 2904 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
  if (t->Kind == kRET_PARAM_DECL) {
# line 2907 "FUnparse.puma"
  {
# line 2909 "FUnparse.puma"
   fprintf (f, "*");
  }
   return;

  }
# line 2912 "FUnparse.puma"
  {
# line 2913 "FUnparse.puma"
   fprintf (f, "<unknown_formal_param>");
  }
   return;

;
}

static void ParamUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2924 "FUnparse.puma"
 
char string[256]; 

  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 2928 "FUnparse.puma"
  {
# line 2929 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
# line 2930 "FUnparse.puma"
   fprintf (f, ",");
# line 2931 "FUnparse.puma"
 if (((UP_List_Length (t->BTP_LIST.Next) + 1) % 8) == 0)
            
            { fprintf (f, "\n");
              fprintf (f, "     $  ");
            }
        
# line 2937 "FUnparse.puma"
   ParamUnparse (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 2940 "FUnparse.puma"
  {
# line 2941 "FUnparse.puma"
   Unparse (t->BTP_LIST.Elem);
  }
   return;

  }
  }
;
}

static void AttributeUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 2954 "FUnparse.puma"
 
char string[256]; 


  switch (t->Kind) {
  case kDECL_EMPTY:
# line 2958 "FUnparse.puma"
   return;

  case kDECL_LIST:
# line 2961 "FUnparse.puma"
  {
# line 2962 "FUnparse.puma"
   fprintf (f, ", ");
# line 2963 "FUnparse.puma"
   AttributeUnparse (t->DECL_LIST.Elem);
# line 2964 "FUnparse.puma"
   AttributeUnparse (t->DECL_LIST.Next);
  }
   return;

  case kDIMENSION_DECL:
# line 2967 "FUnparse.puma"
  {
# line 2968 "FUnparse.puma"
   fprintf (f, "DIMENSION(");
# line 2969 "FUnparse.puma"
   Unparse (t->DIMENSION_DECL.INDEXES);
# line 2970 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kTYPESPEC_DECL:
# line 2973 "FUnparse.puma"
  {
# line 2974 "FUnparse.puma"
   Unparse (t->TYPESPEC_DECL.VAL);
  }
   return;

  case kINIT_DATA_DECL:
  if (t->INIT_DATA_DECL.VAL->Kind == kDUMMY_EXP) {
# line 2977 "FUnparse.puma"
  {
# line 2978 "FUnparse.puma"
   fprintf (f, "DATA");
  }
   return;

  }
# line 2981 "FUnparse.puma"
  {
# line 2982 "FUnparse.puma"
   fprintf (f, "INIT = ");
# line 2983 "FUnparse.puma"
   Unparse (t->INIT_DATA_DECL.VAL);
  }
   return;

  case kALLOCATABLE_DECL:
# line 2986 "FUnparse.puma"
  {
# line 2987 "FUnparse.puma"
   fprintf (f, "ALLOCATABLE");
  }
   return;

  case kEXTERNAL_DECL:
# line 2990 "FUnparse.puma"
  {
# line 2991 "FUnparse.puma"
   fprintf (f, "EXTERNAL");
  }
   return;

  case kINTENT_DECL:
# line 2994 "FUnparse.puma"
  {
# line 2996 "FUnparse.puma"
 switch (t->INTENT_DECL.intent) {
            case IntentIn    : fprintf (f,"INTENT(IN)"); break;
            case IntentInOut : fprintf (f,"INTENT(INOUT)"); break;
            case IntentOut   : fprintf (f,"INTENT(OUT)\n"); break;
            default          : fprintf (f,"INTENT(???)\n"); break;
          } 
        
  }
   return;

  case kINTRINSIC_DECL:
# line 3005 "FUnparse.puma"
  {
# line 3006 "FUnparse.puma"
   fprintf (f, "INTRINSIC");
  }
   return;

  case kOPTIONAL_DECL:
# line 3009 "FUnparse.puma"
  {
# line 3010 "FUnparse.puma"
   fprintf (f, "OPTIONAL");
  }
   return;

  case kPOINTER_DECL:
# line 3013 "FUnparse.puma"
  {
# line 3014 "FUnparse.puma"
   fprintf (f, "POINTER");
  }
   return;

  case kSAVE_DECL:
# line 3017 "FUnparse.puma"
  {
# line 3018 "FUnparse.puma"
   fprintf (f, "SAVE");
  }
   return;

  case kTARGET_DECL:
# line 3021 "FUnparse.puma"
  {
# line 3022 "FUnparse.puma"
   fprintf (f, "TARGET");
  }
   return;

  case kPARAMETER_DECL:
# line 3025 "FUnparse.puma"
  {
# line 3026 "FUnparse.puma"
   fprintf (f, "PARAMETER");
  }
   return;

  case kPUBLIC_DECL:
# line 3029 "FUnparse.puma"
  {
# line 3030 "FUnparse.puma"
   fprintf (f, "PUBLIC");
  }
   return;

  case kPRIVATE_DECL:
# line 3033 "FUnparse.puma"
  {
# line 3034 "FUnparse.puma"
   fprintf (f, "PRIVATE");
  }
   return;

  case kTEMPLATE_DECL:
  if (t->TEMPLATE_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
# line 3037 "FUnparse.puma"
  {
# line 3038 "FUnparse.puma"
   fprintf (f, "TEMPLATE");
  }
   return;

  }
# line 3041 "FUnparse.puma"
  {
# line 3042 "FUnparse.puma"
   fprintf (f, "TEMPLATE (");
# line 3043 "FUnparse.puma"
   Unparse (t->TEMPLATE_DECL.DIMENSIONS);
# line 3044 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kPROCESSORS_DECL:
  if (t->PROCESSORS_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
# line 3047 "FUnparse.puma"
  {
# line 3048 "FUnparse.puma"
   fprintf (f, "PROCESSORS");
  }
   return;

  }
# line 3051 "FUnparse.puma"
  {
# line 3052 "FUnparse.puma"
   fprintf (f, "PROCESSORS (");
# line 3053 "FUnparse.puma"
   Unparse (t->PROCESSORS_DECL.DIMENSIONS);
# line 3054 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  case kALIGN_DECL:
  if (t->ALIGN_DECL.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
# line 3057 "FUnparse.puma"
  {
# line 3058 "FUnparse.puma"
   fprintf (f, "ALIGN WITH ");
# line 3059 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
  }
   return;

  }
# line 3062 "FUnparse.puma"
  {
# line 3063 "FUnparse.puma"
   fprintf (f, "ALIGN (");
# line 3064 "FUnparse.puma"
   Unparse (t->ALIGN_DECL.ALIGN_SOURCE);
# line 3065 "FUnparse.puma"
   fprintf (f, ") WITH ");
# line 3066 "FUnparse.puma"
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
  }
   return;

  case kDYNAMIC_DECL:
# line 3069 "FUnparse.puma"
  {
# line 3070 "FUnparse.puma"
   fprintf (f, "DYNAMIC", string);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 3073 "FUnparse.puma"
  {
# line 3074 "FUnparse.puma"
   fprintf (f, "DISTRIBUTE ");
# line 3075 "FUnparse.puma"
   LayoutUnparse (t->DISTRIBUTE_DECL.DISTRIBUTION);
# line 3076 "FUnparse.puma"
   ProcSpecUnparse (t->DISTRIBUTE_DECL.TARGET);
  }
   return;

  }

# line 3079 "FUnparse.puma"
  {
# line 3080 "FUnparse.puma"
   fprintf (f, "<attribute>");
  }
   return;

;
}

static void AlignSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 3095 "FUnparse.puma"
 
char string[256]; 

  if (t->Kind == kALIGN_SPEC) {
  if (t->ALIGN_SPEC.SUBSCRIPTS->Kind == kBTE_EMPTY) {
# line 3099 "FUnparse.puma"
  {
# line 3100 "FUnparse.puma"
   GetString (t->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident, string);
# line 3101 "FUnparse.puma"
 if (t->ALIGN_SPEC.is_descriptive == 1)
         fprintf (f, "* ");
      fprintf (f, "%s", string);
    
  }
   return;

  }
# line 3107 "FUnparse.puma"
  {
# line 3108 "FUnparse.puma"
   GetString (t->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident, string);
# line 3109 "FUnparse.puma"
 if (t->ALIGN_SPEC.is_descriptive == 1)
         fprintf (f, "* ");
      fprintf (f, "%s(", string);
      Unparse (t->ALIGN_SPEC.SUBSCRIPTS);
      fprintf (f, ")");
    
  }
   return;

  }
# line 3117 "FUnparse.puma"
  {
# line 3118 "FUnparse.puma"
   fprintf (f, "<unknown_align_spec>");
  }
   return;

;
}

static void UseNameUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 3123 "FUnparse.puma"
 
char string[256]; 

  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
# line 3127 "FUnparse.puma"
  {
# line 3128 "FUnparse.puma"
   UseNameUnparse (t->DECL_LIST.Elem);
  }
   return;

  }
# line 3131 "FUnparse.puma"
  {
# line 3132 "FUnparse.puma"
   UseNameUnparse (t->DECL_LIST.Elem);
# line 3133 "FUnparse.puma"
   fprintf (f, ", ");
# line 3134 "FUnparse.puma"
   UseNameUnparse (t->DECL_LIST.Next);
  }
   return;

  }
  if (t->Kind == kPRIVATE_DECL) {
# line 3137 "FUnparse.puma"
  {
# line 3138 "FUnparse.puma"
   fprintf (f, "PRIVATE");
  }
   return;

  }
  if (t->Kind == kPUBLIC_DECL) {
# line 3141 "FUnparse.puma"
  {
# line 3142 "FUnparse.puma"
   fprintf (f, "PUBLIC");
  }
   return;

  }
  if (t->Kind == kNAME_DECL) {
# line 3145 "FUnparse.puma"
  {
# line 3146 "FUnparse.puma"
   GetString (t->NAME_DECL.Ident, string);
# line 3147 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
  if (t->Kind == kRENAME_DECL) {
# line 3149 "FUnparse.puma"
  {
# line 3150 "FUnparse.puma"
   GetString (t->RENAME_DECL.Ident, string);
# line 3151 "FUnparse.puma"
   fprintf (f, "%s => ", string);
# line 3152 "FUnparse.puma"
   GetString (t->RENAME_DECL.oldname, string);
# line 3153 "FUnparse.puma"
   fprintf (f, "%s", string);
  }
   return;

  }
;
}

static void GenSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 3158 "FUnparse.puma"
 
char string[256]; 

  if (t->Kind == kNO_GENERIC_SPEC) {
# line 3162 "FUnparse.puma"
   return;

  }
  if (t->Kind == kID_GENERIC_SPEC) {
# line 3165 "FUnparse.puma"
  {
# line 3166 "FUnparse.puma"
   GetString (t->ID_GENERIC_SPEC.name, string);
# line 3167 "FUnparse.puma"
   fprintf (f, " %s", string);
  }
   return;

  }
  if (t->Kind == kOP_GENERIC_SPEC) {
# line 3170 "FUnparse.puma"
  {
# line 3171 "FUnparse.puma"
   fprintf (f, " OPERATOR (");
# line 3172 "FUnparse.puma"
   OpUnparse (t->OP_GENERIC_SPEC.OPERATOR);
# line 3173 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
  if (t->Kind == kASSIGN_GENERIC_SPEC) {
# line 3176 "FUnparse.puma"
  {
# line 3177 "FUnparse.puma"
   fprintf (f, "ASSIGNMENT (=)");
  }
   return;

  }
;
}

static void CaseSelectorUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 3188 "FUnparse.puma"
  {
# line 3189 "FUnparse.puma"
   CaseSelectorUnparse (t->BTE_LIST.Elem);
  }
   return;

  }
# line 3192 "FUnparse.puma"
  {
# line 3193 "FUnparse.puma"
   CaseSelectorUnparse (t->BTE_LIST.Elem);
# line 3194 "FUnparse.puma"
   fprintf (f, ", ");
# line 3195 "FUnparse.puma"
   CaseSelectorUnparse (t->BTE_LIST.Next);
  }
   return;

  }
  if (t->Kind == kSLICE_EXP) {
  if (t->SLICE_EXP.START->Kind == kDUMMY_EXP) {
# line 3198 "FUnparse.puma"
  {
# line 3199 "FUnparse.puma"
   fprintf (f, ":");
# line 3200 "FUnparse.puma"
   Unparse (t->SLICE_EXP.STOP);
  }
   return;

  }
  if (t->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
# line 3203 "FUnparse.puma"
  {
# line 3204 "FUnparse.puma"
   Unparse (t->SLICE_EXP.START);
# line 3205 "FUnparse.puma"
   fprintf (f, ":");
  }
   return;

  }
# line 3208 "FUnparse.puma"
  {
# line 3209 "FUnparse.puma"
   Unparse (t->SLICE_EXP.START);
# line 3210 "FUnparse.puma"
   fprintf (f, ":");
# line 3211 "FUnparse.puma"
   Unparse (t->SLICE_EXP.STOP);
  }
   return;

  }
# line 3214 "FUnparse.puma"
  {
# line 3215 "FUnparse.puma"
   Unparse (t);
  }
   return;

;
}

static void OnSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree ontop, register tTree onlist)
# else
(ontop, onlist)
 register tTree ontop;
 register tTree onlist;
# endif
{
# line 3226 "FUnparse.puma"

char string[50];

# line 3230 "FUnparse.puma"
  {
# line 3232 "FUnparse.puma"
   if (! ((ontop == NoTree))) goto yyL1;
  {
# line 3234 "FUnparse.puma"
   fprintf (f, "(?)");
# line 3236 "FUnparse.puma"
   OnListUnparse (onlist);
  }
  }
   return;
yyL1:;

  if (ontop->Kind == kON_ALL) {
  if (onlist->Kind == kON_EMPTY) {
# line 3239 "FUnparse.puma"
  {
# line 3241 "FUnparse.puma"
   fprintf (f, "(all)");
  }
   return;

  }
  }
  if (ontop->Kind == kON_HOST) {
  if (onlist->Kind == kON_EMPTY) {
# line 3244 "FUnparse.puma"
  {
# line 3245 "FUnparse.puma"
   fprintf (f, "(host)");
  }
   return;

  }
  }
  if (ontop->Kind == kON_PROCS) {
# line 3248 "FUnparse.puma"
  {
# line 3250 "FUnparse.puma"
 GetString (ontop->ON_PROCS.topid->Object.Ident, string);
      fprintf (f, "(top %s (#%d))", string, ontop->ON_PROCS.topid->TopologyObject.rank);
    
# line 3253 "FUnparse.puma"
   OnListUnparse (onlist);
  }
   return;

  }
  if (ontop->Kind == kON_VAR) {
# line 3256 "FUnparse.puma"
  {
# line 3258 "FUnparse.puma"
 if (ontop->ON_VAR.topid == NoObject)
         fprintf (f, "(top *, ");
       else
         { GetString (ontop->ON_VAR.topid->Object.Ident, string);
           fprintf (f, "(top %s (#%d), ", string, ontop->ON_VAR.topid->TopologyObject.rank);
         }
      if (ontop->ON_VAR.tempid == NoObject)
         fprintf (f, "template *, ");
       else
         { GetString (ontop->ON_VAR.tempid->Object.Ident, string);
           fprintf (f, "template %s, ", string);
         }
      if (ontop->ON_VAR.arrayid == NoObject)
         fprintf (f, "array *)");
       else
         { GetString (ontop->ON_VAR.arrayid->Object.Ident, string);
           fprintf (f, "array %s)", string);
         }
    
# line 3277 "FUnparse.puma"
   OnListUnparse (onlist);
  }
   return;

  }
;
}

static void OnListUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
  if (list->Kind == kON_LIST) {
# line 3282 "FUnparse.puma"
  {
# line 3283 "FUnparse.puma"
   OnListUnparse (list->ON_LIST.Elem);
# line 3284 "FUnparse.puma"
   OnListUnparse (list->ON_LIST.Next);
  }
   return;

  }
  if (list->Kind == kON_EMPTY) {
# line 3287 "FUnparse.puma"
   return;

  }
  if (list->Kind == kON_SPEC) {
# line 3290 "FUnparse.puma"
  {
# line 3292 "FUnparse.puma"
   fprintf (f, "(%d:", list->ON_SPEC.top_dim);
# line 3293 "FUnparse.puma"
   Unparse (list->ON_SPEC.ON_VAL);
# line 3294 "FUnparse.puma"
   fprintf (f, ") ");
  }
   return;

  }
# line 3297 "FUnparse.puma"
  {
# line 3298 "FUnparse.puma"
   fprintf (f, "<on-spec>");
  }
   return;

;
}

static bool MoreParameters
# if defined __STDC__ | defined __cplusplus
(register tTree parameterlist)
# else
(parameterlist)
 register tTree parameterlist;
# endif
{
  if (parameterlist->Kind == kBTP_LIST) {
# line 3304 "FUnparse.puma"
   return true;

  }
  return false;
}

static void StatusUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree status)
# else
(status)
 register tTree status;
# endif
{
  if (status->Kind == kDUMMY_VAR) {
# line 3311 "FUnparse.puma"
   return;

  }
# line 3314 "FUnparse.puma"
  {
# line 3315 "FUnparse.puma"
   fprintf (f, ",STAT=");
# line 3316 "FUnparse.puma"
   Unparse (status);
  }
   return;

;
}

static void OverlapUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree overlap)
# else
(overlap)
 register tTree overlap;
# endif
{
  if (overlap->Kind == kOVERLAP_SPEC) {
  if (equalint (overlap->OVERLAP_SPEC.left_size, 0)) {
  if (equalint (overlap->OVERLAP_SPEC.right_size, 0)) {
# line 3321 "FUnparse.puma"
   return;

  }
  }
# line 3324 "FUnparse.puma"
  {
# line 3325 "FUnparse.puma"
   fprintf (f, "[%d:%d]", overlap->OVERLAP_SPEC.left_size, overlap->OVERLAP_SPEC.right_size);
  }
   return;

  }
;
}

static void DepInfoUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree info)
# else
(info)
 register tTree info;
# endif
{
  if (info->Kind == kSERIAL_INFO) {
# line 3338 "FUnparse.puma"
   return;

  }
  if (info->Kind == kPARDO_INFO) {
# line 3341 "FUnparse.puma"
  {
# line 3343 "FUnparse.puma"
   fprintf (f, "  ! parallel ");
  }
   return;

  }
  if (info->Kind == kINDEP_INFO) {
# line 3346 "FUnparse.puma"
  {
# line 3348 "FUnparse.puma"
 fprintf (f," ! independent");
     if (info->INDEP_INFO.user_independent)
        fprintf (f, " (user)");
       else
        fprintf (f, " (system)");
     if (info->INDEP_INFO.selection)
        { fprintf (f, ", select(");
          SelectorUnparse (info->INDEP_INFO.selection);
          fprintf (f, ")");
        }
   
  }
   return;

  }
;
}

static void HomeInfoUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree info)
# else
(info)
 register tTree info;
# endif
{
  if (info->Kind == kNO_HOME_INFO) {
# line 3371 "FUnparse.puma"
   return;

  }
  if (info->Kind == kCOMM_INFO) {
# line 3374 "FUnparse.puma"
  {
# line 3376 "FUnparse.puma"
 if (info->COMM_INFO.is_local)
        fprintf (f, ", resident");
     if (info->COMM_INFO.home_var != NoTree)
        { fprintf (f,", on ");
          Unparse (info->COMM_INFO.home_var);
        }
   
  }
   return;

  }
  if (info->Kind == kON_INFO) {
# line 3385 "FUnparse.puma"
  {
# line 3387 "FUnparse.puma"
 fprintf (f," ! on ");

     if (info->ON_INFO.on_id == NoObject)
        fprintf (f, "*");
      else
        { GetString (info->ON_INFO.on_id->Object.Ident, string);
          fprintf (f, "%s", string);
        }
     fprintf (f," dim = %d, %d+%d*I", info->ON_INFO.on_dim, info->ON_INFO.base, info->ON_INFO.stride);
   
  }
   return;

  }
# line 3399 "FUnparse.puma"
  {
# line 3401 "FUnparse.puma"
   fprintf (f, "<comm-info>");
  }
   return;

;
}

static void VecInfoUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree dep_info)
# else
(dep_info)
 register tTree dep_info;
# endif
{
  if (dep_info->Kind == kVECTOR_INFO) {
# line 3412 "FUnparse.puma"
  {
# line 3416 "FUnparse.puma"
   if (! ((dep_info->VECTOR_INFO.is_independent))) goto yyL1;
  {
# line 3418 "FUnparse.puma"
   fprintf (f, "!CDIR nodep");
# line 3420 "FUnparse.puma"
 if (dep_info->VECTOR_INFO.selection & kSELECT_NOVECTOR)
       fprintf (f, ", novector");
     if (dep_info->VECTOR_INFO.selection & kSELECT_SHORT)
       fprintf (f, ", shortloop");
     if (dep_info->VECTOR_INFO.selection & kSELECT_EXPAND)
       { if (dep_info->VECTOR_INFO.loop_cnt > 0)
            fprintf (f, ", expand=%d", dep_info->VECTOR_INFO.loop_cnt);
       } 
   
# line 3430 "FUnparse.puma"
   fprintf (f, "\n");
  }
  }
   return;
yyL1:;

# line 3433 "FUnparse.puma"
  {
# line 3437 "FUnparse.puma"
 if (dep_info->VECTOR_INFO.selection & kSELECT_NOVECTOR)
       fprintf (f, "!CDIR novector\n");
     if (dep_info->VECTOR_INFO.selection & kSELECT_SHORT)
       fprintf (f, "!CDIR shortloop\n");
     if (dep_info->VECTOR_INFO.selection & kSELECT_EXPAND)
       { if (dep_info->VECTOR_INFO.loop_cnt > 0)
            fprintf (f, "!CDIR expand=%d\n", dep_info->VECTOR_INFO.loop_cnt);
       } 
   
  }
   return;

  }
;
}

static void SizeUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
# line 3456 "FUnparse.puma"

char string[256];

  if (size->Kind == kCONST_EXP) {
  if (size->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 3460 "FUnparse.puma"
  {
# line 3461 "FUnparse.puma"
   if (! ((size->CONST_EXP.C->INT_CONSTANT.value >= 0))) goto yyL1;
  {
# line 3462 "FUnparse.puma"
   fprintf (f, "*%d", size->CONST_EXP.C->INT_CONSTANT.value);
  }
  }
   return;
yyL1:;

  }
  }
# line 3465 "FUnparse.puma"
  {
# line 3466 "FUnparse.puma"
   fprintf (f, "(KIND=");
# line 3467 "FUnparse.puma"
   ExpUnparse (size, 0, 0);
# line 3468 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

;
}

static void EndUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 3482 "FUnparse.puma"

/* string is used globally */

# line 3486 "FUnparse.puma"
  {
# line 3488 "FUnparse.puma"
   if (! ((target_language != FORTRAN_90))) goto yyL1;
  {
# line 3489 "FUnparse.puma"
   if (! ((target_language != FORTRAN_95))) goto yyL1;
  {
# line 3491 "FUnparse.puma"
   fprintf (f, "\n");
  }
  }
  }
   return;
yyL1:;

  if (t->Kind == kPROC_DECL) {
# line 3494 "FUnparse.puma"
  {
# line 3496 "FUnparse.puma"
   GetString (t->PROC_DECL.Ident, string);
# line 3497 "FUnparse.puma"
   fprintf (f, " SUBROUTINE %s\n", string);
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
# line 3500 "FUnparse.puma"
  {
# line 3502 "FUnparse.puma"
   GetString (t->FUNC_DECL.Ident, string);
# line 3503 "FUnparse.puma"
   fprintf (f, " FUNCTION %s\n", string);
  }
   return;

  }
  if (t->Kind == kPROGRAM_DECL) {
# line 3506 "FUnparse.puma"
  {
# line 3508 "FUnparse.puma"
   GetString (t->PROGRAM_DECL.Ident, string);
# line 3509 "FUnparse.puma"
   fprintf (f, " PROGRAM %s\n", string);
  }
   return;

  }
  if (t->Kind == kMODULE_DECL) {
# line 3512 "FUnparse.puma"
  {
# line 3514 "FUnparse.puma"
   GetString (t->MODULE_DECL.Ident, string);
# line 3515 "FUnparse.puma"
   fprintf (f, " MODULE %s\n", string);
  }
   return;

  }
# line 3518 "FUnparse.puma"
  {
# line 3519 "FUnparse.puma"
   fprintf (f, "\n");
  }
   return;

;
}

static void PrefixUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_DECL) {
# line 3532 "FUnparse.puma"
  {
# line 3534 "FUnparse.puma"
   if (! ((t->FUNC_DECL.IsRecursive))) goto yyL1;
  {
# line 3535 "FUnparse.puma"
   fprintf (f, "RECURSIVE ");
# line 3536 "FUnparse.puma"
   goto yyL1;
  }
  }
yyL1:;

# line 3539 "FUnparse.puma"
  {
# line 3541 "FUnparse.puma"
   if (! ((t->FUNC_DECL.IsPure))) goto yyL2;
  {
# line 3542 "FUnparse.puma"
   fprintf (f, "PURE ");
# line 3543 "FUnparse.puma"
   goto yyL2;
  }
  }
yyL2:;

# line 3546 "FUnparse.puma"
  {
# line 3548 "FUnparse.puma"
   if (! ((t->FUNC_DECL.HPFExtrinsic != DefaultId ()))) goto yyL3;
  {
# line 3549 "FUnparse.puma"
   GetString (t->FUNC_DECL.HPFExtrinsic, string);
# line 3550 "FUnparse.puma"
   fprintf (f, "EXTRINSIC (%s) ", string);
# line 3551 "FUnparse.puma"
   goto yyL3;
  }
  }
yyL3:;

  if (t->FUNC_DECL.RESULT_TYPE->Kind == kDUMMY_TYPE) {
# line 3554 "FUnparse.puma"
   return;

  }
# line 3557 "FUnparse.puma"
  {
# line 3559 "FUnparse.puma"
   Unparse (t->FUNC_DECL.RESULT_TYPE);
# line 3560 "FUnparse.puma"
   fprintf (f, " ");
  }
   return;

  }
  if (t->Kind == kPROC_DECL) {
# line 3563 "FUnparse.puma"
  {
# line 3565 "FUnparse.puma"
   if (! ((t->PROC_DECL.IsRecursive))) goto yyL6;
  {
# line 3566 "FUnparse.puma"
   fprintf (f, "RECURSIVE ");
# line 3567 "FUnparse.puma"
   goto yyL6;
  }
  }
yyL6:;

# line 3570 "FUnparse.puma"
  {
# line 3572 "FUnparse.puma"
   if (! ((t->PROC_DECL.IsPure))) goto yyL7;
  {
# line 3573 "FUnparse.puma"
   fprintf (f, "PURE ");
# line 3574 "FUnparse.puma"
   goto yyL7;
  }
  }
yyL7:;

# line 3577 "FUnparse.puma"
  {
# line 3579 "FUnparse.puma"
   if (! ((t->PROC_DECL.HPFExtrinsic != DefaultId ()))) goto yyL8;
  {
# line 3580 "FUnparse.puma"
   GetString (t->PROC_DECL.HPFExtrinsic, string);
# line 3581 "FUnparse.puma"
   fprintf (f, "EXTRINSIC (%s) ", string);
# line 3582 "FUnparse.puma"
   goto yyL8;
  }
  }
yyL8:;

  }
;
}

static void DspKindUnparse
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
# line 3595 "FUnparse.puma"
  {
# line 3596 "FUnparse.puma"
   if (! ((kind == kSTATIC_DSP))) goto yyL1;
  {
# line 3597 "FUnparse.puma"
   fprintf (f, "static_dsp");
  }
  }
   return;
yyL1:;

# line 3600 "FUnparse.puma"
  {
# line 3601 "FUnparse.puma"
   if (! ((kind == kALLOCATE_DSP))) goto yyL2;
  {
# line 3602 "FUnparse.puma"
   fprintf (f, "allocate_dsp");
  }
  }
   return;
yyL2:;

# line 3605 "FUnparse.puma"
  {
# line 3606 "FUnparse.puma"
   if (! ((kind == kTEMPLATE_DSP))) goto yyL3;
  {
# line 3607 "FUnparse.puma"
   fprintf (f, "template_dsp");
  }
  }
   return;
yyL3:;

# line 3610 "FUnparse.puma"
  {
# line 3611 "FUnparse.puma"
   if (! ((kind == kTOPOLOGY_DSP))) goto yyL4;
  {
# line 3612 "FUnparse.puma"
   fprintf (f, "topology_dsp");
  }
  }
   return;
yyL4:;

# line 3615 "FUnparse.puma"
  {
# line 3616 "FUnparse.puma"
   if (! ((kind == kDUMMY_DSP))) goto yyL5;
  {
# line 3617 "FUnparse.puma"
   fprintf (f, "dummy_dsp");
  }
  }
   return;
yyL5:;

# line 3620 "FUnparse.puma"
  {
# line 3621 "FUnparse.puma"
   if (! ((kind == kASSUMED_DSP))) goto yyL6;
  {
# line 3622 "FUnparse.puma"
   fprintf (f, "assumed_dsp");
  }
  }
   return;
yyL6:;

# line 3625 "FUnparse.puma"
  {
# line 3626 "FUnparse.puma"
   if (! ((kind == kLOCAL_DSP))) goto yyL7;
  {
# line 3627 "FUnparse.puma"
   fprintf (f, "local_dsp");
  }
  }
   return;
yyL7:;

# line 3630 "FUnparse.puma"
  {
# line 3631 "FUnparse.puma"
   fprintf (f, "?");
  }
   return;

;
}

static void HPFBodyUnparse
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree body, register int kind)
# else
(line, body, kind)
 register int line;
 register tTree body;
 register int kind;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 3648 "FUnparse.puma"
  {
# line 3650 "FUnparse.puma"
   LCR (line);
# line 3651 "FUnparse.puma"
   Unparse (body);
  }
   return;

  }
  }
# line 3654 "FUnparse.puma"
  {
# line 3656 "FUnparse.puma"
   fprintf (f, " begin");
# line 3657 "FUnparse.puma"
   LCR (line);
# line 3658 "FUnparse.puma"
   IncIndent ();
# line 3659 "FUnparse.puma"
   Unparse (body);
# line 3660 "FUnparse.puma"
   DecIndent ();
# line 3661 "FUnparse.puma"
 if (kind == 0)
          fprintf (f,"!hpf$ end on\n");
       else if (kind == 1)
          fprintf (f,"!hpf$ end resident\n");
       else if (kind == 2)
          fprintf (f,"!hpf$ end new\n");
       else
          fprintf (f,"!hpf$ end reduction\n");
    
  }
   return;

;
}

static void ResidentUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree resident_vars)
# else
(resident_vars)
 register tTree resident_vars;
# endif
{
# line 3680 "FUnparse.puma"
  {
# line 3681 "FUnparse.puma"
   if (! ((resident_vars == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (resident_vars->Kind == kBTV_LIST) {
  if (resident_vars->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (resident_vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 3684 "FUnparse.puma"
  {
# line 3686 "FUnparse.puma"
   fprintf (f, ", resident");
  }
   return;

  }
  }
# line 3689 "FUnparse.puma"
  {
# line 3691 "FUnparse.puma"
   fprintf (f, ", resident (");
# line 3692 "FUnparse.puma"
   Unparse (resident_vars);
# line 3693 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
;
}

static void NewUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree new_vars)
# else
(new_vars)
 register tTree new_vars;
# endif
{
# line 3698 "FUnparse.puma"
  {
# line 3699 "FUnparse.puma"
   if (! ((new_vars == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (new_vars->Kind == kBTV_EMPTY) {
# line 3702 "FUnparse.puma"
   return;

  }
  if (new_vars->Kind == kBTV_LIST) {
# line 3705 "FUnparse.puma"
  {
# line 3707 "FUnparse.puma"
   fprintf (f, ", new (");
# line 3708 "FUnparse.puma"
   Unparse (new_vars);
# line 3709 "FUnparse.puma"
   fprintf (f, ")");
  }
   return;

  }
;
}

static void ResolveACFHome
# if defined __STDC__ | defined __cplusplus
(register tTree home_body, register tTree * yyP4, register tTree * yyP3, register tTree * yyP2)
# else
(home_body, yyP4, yyP3, yyP2)
 register tTree home_body;
 register tTree * yyP4;
 register tTree * yyP3;
 register tTree * yyP2;
# endif
{
  if (home_body->Kind == kACF_LIST) {
  if (home_body->ACF_LIST.Elem->Kind == kACF_NEW) {
  if (home_body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 3721 "FUnparse.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 3725 "FUnparse.puma"
   ResolveACFHome (home_body->ACF_LIST.Elem->ACF_NEW.NEW_BODY, & yyV1, & yyV2, & yyV3);
# line 3727 "FUnparse.puma"
   if (! ((yyV3 == NoTree))) goto yyL1;
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   * yyP2 = home_body->ACF_LIST.Elem->ACF_NEW.NEW_VAR;
   return;
 }
yyL1:;

  }
  }
  if (home_body->ACF_LIST.Elem->Kind == kACF_RESIDENT) {
  if (home_body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 3730 "FUnparse.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 3735 "FUnparse.puma"
   ResolveACFHome (home_body->ACF_LIST.Elem->ACF_RESIDENT.RESIDENT_BODY, & yyV1, & yyV2, & yyV3);
# line 3737 "FUnparse.puma"
   if (! ((yyV2 == NoTree))) goto yyL2;
  }
   * yyP4 = yyV1;
   * yyP3 = home_body->ACF_LIST.Elem->ACF_RESIDENT.RESIDENT_VAR;
   * yyP2 = yyV3;
   return;
 }
yyL2:;

  }
  }
  }
# line 3740 "FUnparse.puma"
   * yyP4 = home_body;
   * yyP3 = NoTree;
   * yyP2 = NoTree;
   return;

;
}

static bool IsDummyParam
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
  if (param->VAR_PARAM.V->ADDR.E->Kind == kDUMMY_EXP) {
# line 3751 "FUnparse.puma"
   return true;

  }
  }
  }
  if (param->Kind == kVALUE_PARAM) {
  if (param->VALUE_PARAM.E->Kind == kDUMMY_EXP) {
# line 3754 "FUnparse.puma"
   return true;

  }
  }
  return false;
}

static void SMParUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree red_vars, register tTree shared_vars, register tTree local_vars)
# else
(red_vars, shared_vars, local_vars)
 register tTree red_vars;
 register tTree shared_vars;
 register tTree local_vars;
# endif
{
# line 3765 "FUnparse.puma"
 {
  bool cont;
  {
# line 3767 "FUnparse.puma"

# line 3769 "FUnparse.puma"
   cont = ! EmptyList (shared_vars) || ! EmptyList (local_vars);
# line 3770 "FUnparse.puma"
   SMVarUnparse (0, red_vars, cont);
# line 3771 "FUnparse.puma"
   cont = ! EmptyList (local_vars);
# line 3772 "FUnparse.puma"
   SMVarUnparse (1, shared_vars, cont);
# line 3773 "FUnparse.puma"
   cont = false;
# line 3774 "FUnparse.puma"
   SMVarUnparse (2, local_vars, cont);
  }
   return;
 }

;
}

static void SMVarUnparse
# if defined __STDC__ | defined __cplusplus
(register int kind, register tTree var_list, register bool cont)
# else
(kind, var_list, cont)
 register int kind;
 register tTree var_list;
 register bool cont;
# endif
{
# line 3779 "FUnparse.puma"
  {
# line 3781 "FUnparse.puma"
   if (! ((EmptyList (var_list)))) goto yyL1;
  }
   return;
yyL1:;

# line 3784 "FUnparse.puma"
  {
# line 3786 "FUnparse.puma"
 if (kind == 0) fprintf (f, "reduction(");
     if (kind == 1) fprintf (f, "shared(");
     if (kind == 2)
        { if (sm_parallelization == SGI_MP)
             fprintf (f, "local(");
            else
             fprintf (f, "private(");
        }
     Unparse (var_list);
     fprintf (f, ")");
     if (cont) fprintf (f, ", ");
   
  }
   return;

;
}

static bool EmptyList
# if defined __STDC__ | defined __cplusplus
(register tTree var_list)
# else
(var_list)
 register tTree var_list;
# endif
{
# line 3802 "FUnparse.puma"
  {
# line 3803 "FUnparse.puma"
   if (! ((var_list == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

  if (var_list->Kind == kBTV_EMPTY) {
# line 3806 "FUnparse.puma"
   return true;

  }
  return false;
}

static void SMGetParLoop
# if defined __STDC__ | defined __cplusplus
(register tTree body, register bool * yyP6, register tTree * yyP5)
# else
(body, yyP6, yyP5)
 register tTree body;
 register bool * yyP6;
 register tTree * yyP5;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_DO) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 3812 "FUnparse.puma"
   * yyP6 = true;
   * yyP5 = body->ACF_LIST.Elem;
   return;

  }
  }
  }
# line 3815 "FUnparse.puma"
   * yyP6 = false;
   * yyP5 = NoTree;
   return;

;
}

static void SelectorUnparse
# if defined __STDC__ | defined __cplusplus
(register int selector)
# else
(selector)
 register int selector;
# endif
{
# line 3820 "FUnparse.puma"
 {
  bool first;
  {
# line 3822 "FUnparse.puma"

# line 3824 "FUnparse.puma"
 first = true;  

     if (selector & kSELECT_NOVECTOR)
        { if (!first) fprintf (f,"/");
          fprintf (f, "novector"); first = false;
        }

     if (selector & kSELECT_SHORT)
        { if (!first) fprintf (f,"/");
          fprintf (f, "short"); first = false;
        }

     if (selector & kSELECT_EXPAND)
        { if (!first) fprintf (f,"/");
          fprintf (f, "expand"); first = false;
        }

     if (selector & kSELECT_CONCUR)
        { if (!first) fprintf (f,"/");
          fprintf (f, "concur"); first = false;
        }
   
  }
   return;
 }

;
}

void BeginUnparse ()
{
# line 167 "FUnparse.puma"

  f = fopen ("unparse.f","w");
  indent = 0;

}

void CloseUnparse ()
{
# line 173 "FUnparse.puma"

  fclose (f);

}
