# include "Types.h"
# include "yyTypes.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 78 "Types.puma"


# include "Idents.h"
# include "protocol.h"
# include "DefTable.h"
# include "Objects.h"
# include "protocol.h"
# include "Intrinsics.h"
# include "Expressions.h"

# define MODULE "Types"

void OutType 
# if defined __STDC__ | defined __cplusplus
(char *Str, type_rec t)
# else
(Str, t)
 char *Str;
 type_rec t;
# endif

{ switch (t.type_kind) {

  case kDUMMY_TYPE     : sprintf (Str, "no_type", t.type_size); break;
  case kINTEGER_TYPE   : sprintf (Str, "INTEGER*%d", t.type_size); break;
  case kBOOLEAN_TYPE   : sprintf (Str, "LOGICAL*%d", t.type_size); break;
  case kREAL_TYPE      : sprintf (Str, "REAL*%d", t.type_size); break;
  case kCOMPLEX_TYPE   : sprintf (Str, "COMPLEX*%d", t.type_size); break;
  case kSTRING_TYPE    : if (t.type_size == -1)
                            sprintf (Str, "CHARACTER*(*)", t.type_size);
                           else
                            sprintf (Str, "CHARACTER*%d", t.type_size);
                         break;
  case kTYPE_ID        : sprintf (Str, "TYPE (..)"); break;
  default              : sprintf (Str, "<type_kind=%d,size=%d>",
                                  t.type_kind, t.type_size); 
  }

} /* OutType */



static void yyExit () { Exit (1); }

void (* Types_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Types, routine %s failed\n", yyFunction);
 Types_Exit ();
}

tTree GetObjectType ARGS((tDefinitions obj));
tTree GetVariableType ARGS((tTree var));
tTree GetBaseType ARGS((tTree t));
static tTree VarType ARGS((tDefinitions v));
tTree TreeType ARGS((tTree var));
bool IsDummyType ARGS((tTree t));
bool IsArrayType ARGS((tTree type));
bool IsStringType ARGS((tTree type));
bool IsPointerType ARGS((tTree type));
int TreeSize ARGS((tTree t));
void GetExpType ARGS((tTree exp, type_rec * yyP1));
static void GetExpListType ARGS((tTree explist, type_rec * yyP2));
void GetParamType ARGS((tTree param, type_rec * yyP3));
static void GetParamListType ARGS((tTree explist, type_rec * yyP4));
void GetTypeRecord ARGS((tTree type, type_rec * yyP5));
void GetOp1Type ARGS((tTree op, type_rec type1, type_rec * yyP6));
void GetOp2Type ARGS((tTree op, type_rec t1, type_rec t2, type_rec * yyP7));
bool LegalAssignmentTypes ARGS((type_rec t1, type_rec t2));
static bool IsNumOp ARGS((tTree op));
static bool IsBoolOp ARGS((tTree op));
static bool IsRelOp ARGS((tTree op));
static void GetIntrFuncType ARGS((tIdent name, tTree params, type_rec * yyP8));
static void TypeCombination ARGS((type_rec type1, type_rec type2, type_rec * yyP9));
bool IsSubType ARGS((type_rec type1, type_rec type2));
bool SameTypeRecord ARGS((type_rec type1, type_rec type2));
static bool IsNumType ARGS((type_rec type));
static bool IsBoolType ARGS((type_rec type));
static bool IsStringTypeKind ARGS((type_rec type));
static void GetIntegerType ARGS((type_rec * yyP10));
static void GetRealType ARGS((int size, type_rec * yyP11));
static void GetComplexType ARGS((int size, type_rec * yyP12));
static void GetLogicalType ARGS((type_rec * yyP13));
static void GetStringType ARGS((type_rec * yyP14));
tTree GetTypeZero ARGS((tTree texp));
bool IsSameExpType ARGS((tTree t1, tTree t2));
bool IsSameBaseType ARGS((tTree t1, tTree t2));
int GetObjectSize ARGS((tDefinitions obj));
static int GetTypeSize ARGS((tTree type));
static int DerivedTypeSize ARGS((tDefinitions obj));
static int ComponentsSize ARGS((tDefinitions components));
static int FormalSize ARGS((tTree formals));
static int AddSizes ARGS((int size1, int size2));
static int MultSizes ARGS((int size1, int size2));
static int EvaluateSize ARGS((tTree size));
tTree ArrayFormals ARGS((tDefinitions v));
static tTree GetFormals ARGS((tTree type));

tTree GetObjectType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 137 "Types.puma"
  {
# line 138 "Types.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
# line 142 "Types.puma"
   return obj->VarObject.decl->VAR_DECL.VAL;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 147 "Types.puma"
   return obj->VarObject.decl->VAR_PARAM_DECL.VAL;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 152 "Types.puma"
  {
# line 154 "Types.puma"
   if (! ((obj->FuncObject.decl->FUNC_DECL.RESULT_ID == DefaultId ()))) goto yyL4;
  }
   return obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE;
yyL4:;

# line 159 "Types.puma"
   return GetObjectType (GetFuncVarObj (obj));

  }
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 164 "Types.puma"
   return obj->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE;

  }
  }
# line 168 "Types.puma"
  {
# line 169 "Types.puma"
   obj_protocol ("GetObjectType - this object has no type : ", obj);
  }
   return NoTree;

}

tTree GetVariableType
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_OBJ) {
# line 179 "Types.puma"
   return GetObjectType (var->VAR_OBJ.Object);

  }
  if (var->Kind == kUSED_VAR) {
# line 183 "Types.puma"
   return GetVariableType (var->USED_VAR.VARNAME);

  }
  if (var->Kind == kLOOP_VAR) {
# line 187 "Types.puma"
   return GetVariableType (var->LOOP_VAR.LOOP_VARNAME);

  }
  if (var->Kind == kINDEXED_VAR) {
# line 191 "Types.puma"
   return GetBaseType (GetVariableType (var->INDEXED_VAR.IND_VAR));

  }
  if (var->Kind == kSELECTED_VAR) {
# line 195 "Types.puma"
   return GetObjectType (var->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  }
# line 199 "Types.puma"
  {
# line 200 "Types.puma"
   failure_protocol (MODULE, "GetVariableType", var);
  }
   return NoTree;

}

tTree GetBaseType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 210 "Types.puma"
  {
# line 211 "Types.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return t;
yyL1:;


  switch (t->Kind) {
  case kDUMMY_TYPE:
# line 215 "Types.puma"
   return t;

  case kINTEGER_TYPE:
# line 219 "Types.puma"
   return t;

  case kREAL_TYPE:
# line 223 "Types.puma"
   return t;

  case kBOOLEAN_TYPE:
# line 227 "Types.puma"
   return t;

  case kCOMPLEX_TYPE:
# line 231 "Types.puma"
   return t;

  case kSTRING_TYPE:
# line 235 "Types.puma"
   return t;

  case kTYPE_ID:
# line 239 "Types.puma"
   return t;

  case kARRAY_TYPE:
# line 243 "Types.puma"
   return GetBaseType (t->ARRAY_TYPE.ARRAY_COMP_TYPE);

  case kPOINTER_TYPE:
# line 247 "Types.puma"
   return GetBaseType (t->POINTER_TYPE.PTR_COMP);

  }

# line 251 "Types.puma"
  {
# line 252 "Types.puma"
   failure_protocol (MODULE, "GetBaseType", t);
  }
   return NoTree;

}

static tTree VarType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 262 "Types.puma"
   return GetBaseType (GetObjectType (v));

}

tTree TreeType
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 268 "Types.puma"
   return GetBaseType (GetVariableType (var));

}

bool IsDummyType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDUMMY_TYPE) {
# line 280 "Types.puma"
   return true;

  }
  if (t->Kind == kALIGN_TYPE) {
# line 283 "Types.puma"
   return true;

  }
  if (t->Kind == kARRAY_TYPE) {
# line 286 "Types.puma"
  {
# line 287 "Types.puma"
   if (! ((IsDummyType (t->ARRAY_TYPE.ARRAY_COMP_TYPE)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (t->Kind == kPOINTER_TYPE) {
# line 290 "Types.puma"
  {
# line 291 "Types.puma"
   if (! ((IsDummyType (t->POINTER_TYPE.PTR_COMP)))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

bool IsArrayType
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
# line 302 "Types.puma"
  {
# line 303 "Types.puma"
   if (! ((type == NoTree))) goto yyL1;
  {
# line 304 "Types.puma"
   return false;
  }
  }
yyL1:;

  if (type->Kind == kARRAY_TYPE) {
# line 307 "Types.puma"
   return true;

  }
  if (type->Kind == kPOINTER_TYPE) {
# line 310 "Types.puma"
  {
# line 311 "Types.puma"
   if (! ((IsArrayType (type->POINTER_TYPE.PTR_COMP)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

bool IsStringType
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
# line 322 "Types.puma"
  {
# line 323 "Types.puma"
   if (! ((type == NoTree))) goto yyL1;
  {
# line 324 "Types.puma"
   return false;
  }
  }
yyL1:;

  if (type->Kind == kSTRING_TYPE) {
# line 327 "Types.puma"
   return true;

  }
  if (type->Kind == kPOINTER_TYPE) {
# line 330 "Types.puma"
  {
# line 331 "Types.puma"
   if (! ((IsStringType (type->POINTER_TYPE.PTR_COMP)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

bool IsPointerType
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
# line 342 "Types.puma"
  {
# line 343 "Types.puma"
   if (! ((type == NoTree))) goto yyL1;
  {
# line 344 "Types.puma"
   return false;
  }
  }
yyL1:;

  if (type->Kind == kPOINTER_TYPE) {
# line 347 "Types.puma"
   return true;

  }
  return false;
}

int TreeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kTYPE_NODE)) {
# line 358 "Types.puma"
 {
  type_rec yyV1;
  {
# line 360 "Types.puma"
   GetTypeRecord (t, & yyV1);
# line 362 "Types.puma"
 if (yyV1.type_kind == kTYPE_ID)
        yyV1.type_size = DerivedTypeSize ((tObject) yyV1.type_size);
    
  }
  {
   return yyV1 . type_size;
  }
 }

  }
# line 369 "Types.puma"
 {
  type_rec yyV1;
  {
# line 371 "Types.puma"
   GetExpType (t, & yyV1);
# line 373 "Types.puma"
 if (yyV1.type_kind == kTYPE_ID)
        yyV1.type_size = DerivedTypeSize ((tObject) yyV1.type_size);
    
  }
  {
   return yyV1 . type_size;
  }
 }

}

void GetExpType
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec * yyP1)
# else
(exp, yyP1)
 register tTree exp;
 type_rec * yyP1;
# endif
{

  switch (exp->Kind) {
  case kINDEXED_VAR:
# line 397 "Types.puma"
 {
  type_rec yyV1;
  {
# line 399 "Types.puma"
   GetExpType (exp->INDEXED_VAR.IND_VAR, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kSELECTED_VAR:
# line 402 "Types.puma"
 {
  type_rec yyV1;
  {
# line 404 "Types.puma"
   GetTypeRecord (VarType (exp->SELECTED_VAR.SELECTOR->REC_COMP.Object), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kSUBSTRING_VAR:
# line 407 "Types.puma"
 {
  type_rec yyV1;
  {
# line 409 "Types.puma"
   GetExpType (exp->SUBSTRING_VAR.IND_VAR, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kUSED_VAR:
# line 412 "Types.puma"
 {
  type_rec yyV1;
  {
# line 414 "Types.puma"
   GetTypeRecord (TreeType (exp), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kLOOP_VAR:
# line 417 "Types.puma"
 {
  type_rec yyV1;
  {
# line 419 "Types.puma"
   GetTypeRecord (TreeType (exp), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kVAR_EXP:
# line 422 "Types.puma"
 {
  type_rec yyV1;
  {
# line 424 "Types.puma"
   GetExpType (exp->VAR_EXP.V, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kPERM_EXP:
# line 427 "Types.puma"
 {
  type_rec yyV1;
  {
# line 429 "Types.puma"
   GetExpType (exp->PERM_EXP.VAL, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kADDR:
# line 432 "Types.puma"
 {
  type_rec yyV1;
  {
# line 434 "Types.puma"
   GetExpType (exp->ADDR.E, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kVAR_PARAM:
# line 437 "Types.puma"
 {
  type_rec yyV1;
  {
# line 439 "Types.puma"
   GetExpType (exp->VAR_PARAM.V, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kBT_PARAM:
  case kVALUE_PARAM:
  case kNAMED_PARAM:
  case kPROC_PARAM:
  case kFUNC_PARAM:
  case kFORMAT_PARAM:
  case kRETURN_PARAM:
  case kNO_PARAM:
# line 442 "Types.puma"
 {
  type_rec yyV1;
  {
# line 444 "Types.puma"
   GetParamType (exp, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kDO_EXP:
# line 447 "Types.puma"
 {
  type_rec yyV1;
  {
# line 449 "Types.puma"
   GetExpListType (exp->DO_EXP.BODY, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kARRAY_EXP:
# line 452 "Types.puma"
 {
  type_rec yyV1;
  {
# line 454 "Types.puma"
   GetExpListType (exp->ARRAY_EXP.ELEMENTS, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kSLICE_EXP:
# line 457 "Types.puma"
 {
  type_rec yyV1;
  {
# line 459 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kOP1_EXP:
# line 462 "Types.puma"
 {
  type_rec yyV1;
  type_rec yyV2;
  {
# line 464 "Types.puma"
   GetExpType (exp->OP1_EXP.OPND, & yyV1);
# line 465 "Types.puma"
   GetOp1Type (exp->OP1_EXP.EXP_OP1, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  case kOP_EXP:
# line 468 "Types.puma"
 {
  type_rec yyV1;
  type_rec yyV2;
  type_rec yyV3;
  {
# line 470 "Types.puma"
   GetExpType (exp->OP_EXP.OPND1, & yyV1);
# line 471 "Types.puma"
   GetExpType (exp->OP_EXP.OPND2, & yyV2);
# line 472 "Types.puma"
   GetOp2Type (exp->OP_EXP.EXP_OP, yyV1, yyV2, & yyV3);
  }
   * yyP1 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
# line 475 "Types.puma"
 {
  type_rec yyV1;
  {
# line 477 "Types.puma"
   if (! ((IsIntrCall (exp)))) goto yyL16;
  {
# line 479 "Types.puma"
   GetIntrFuncType (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1);
  }
  }
   * yyP1 = yyV1;
   return;
 }
yyL16:;

# line 482 "Types.puma"
 {
  type_rec yyV1;
  {
# line 486 "Types.puma"
   GetTypeRecord (VarType (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kBOUND_EXP:
# line 489 "Types.puma"
 {
  type_rec yyV1;
  {
# line 491 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kRANK_EXP:
# line 494 "Types.puma"
 {
  type_rec yyV1;
  {
# line 496 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kCONST_EXP:
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 499 "Types.puma"
 {
  type_rec yyV1;
  {
# line 501 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kBOOL_CONSTANT) {
# line 504 "Types.puma"
 {
  type_rec yyV1;
  {
# line 506 "Types.puma"
   GetLogicalType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kREAL_CONSTANT) {
# line 509 "Types.puma"
 {
  type_rec yyV1;
  {
# line 511 "Types.puma"
   GetRealType (exp->CONST_EXP.C->REAL_CONSTANT.kind, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kCOMPLEX_CONSTANT) {
# line 514 "Types.puma"
 {
  type_rec yyV1;
  {
# line 516 "Types.puma"
   GetComplexType (2 * default_real_size, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kSTRING_CONSTANT) {
# line 519 "Types.puma"
 {
  type_rec yyV1;
  {
# line 521 "Types.puma"
   GetStringType (& yyV1);
# line 522 "Types.puma"
 yyV1.type_size = LengthSt (exp->CONST_EXP.C->STRING_CONSTANT.value);  
  }
   * yyP1 = yyV1;
   return;
 }

  }
  break;
  case kTYPE_EXP:
# line 525 "Types.puma"
 {
  type_rec rtype;
  {
# line 527 "Types.puma"

# line 529 "Types.puma"
 rtype.type_kind = kTYPE_ID;
     rtype.type_size = (int) exp->TYPE_EXP.ID->TYPE_OBJ.Object;   
   
  }
   * yyP1 = rtype;
   return;
 }

  case kDUMMY_EXP:
# line 534 "Types.puma"
 {
  type_rec rtype;
  {
# line 536 "Types.puma"

# line 538 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP1 = rtype;
   return;
 }

  }

# line 543 "Types.puma"
 {
  type_rec yyV1;
  {
# line 545 "Types.puma"
   GetRealType (default_real_size, & yyV1);
# line 547 "Types.puma"
   failure_protocol (MODULE, "GetExpType", exp);
  }
   * yyP1 = yyV1;
   return;
 }

;
}

static void GetExpListType
# if defined __STDC__ | defined __cplusplus
(register tTree explist, type_rec * yyP2)
# else
(explist, yyP2)
 register tTree explist;
 type_rec * yyP2;
# endif
{
  if (explist->Kind == kBTE_EMPTY) {
# line 566 "Types.puma"
 {
  type_rec rtype;
  {
# line 568 "Types.puma"

# line 570 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP2 = rtype;
   return;
 }

  }
  if (explist->Kind == kBTE_LIST) {
  if (explist->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 575 "Types.puma"
 {
  type_rec yyV1;
  {
# line 577 "Types.puma"
   GetExpType (explist->BTE_LIST.Elem, & yyV1);
  }
   * yyP2 = yyV1;
   return;
 }

  }
# line 580 "Types.puma"
 {
  type_rec yyV1;
  type_rec yyV2;
  type_rec yyV3;
  {
# line 582 "Types.puma"
   GetExpType (explist->BTE_LIST.Elem, & yyV1);
# line 583 "Types.puma"
   GetExpListType (explist->BTE_LIST.Next, & yyV2);
# line 585 "Types.puma"
   TypeCombination (yyV1, yyV2, & yyV3);
  }
   * yyP2 = yyV3;
   return;
 }

  }
# line 588 "Types.puma"
 {
  type_rec yyV1;
  {
# line 590 "Types.puma"
   failure_protocol (MODULE, "GetExpListType", explist);
# line 591 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP2 = yyV1;
   return;
 }

;
}

void GetParamType
# if defined __STDC__ | defined __cplusplus
(register tTree param, type_rec * yyP3)
# else
(param, yyP3)
 register tTree param;
 type_rec * yyP3;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 602 "Types.puma"
 {
  type_rec yyV1;
  {
# line 604 "Types.puma"
   GetExpType (param->VAR_PARAM.V->ADDR.E, & yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
# line 607 "Types.puma"
 {
  type_rec yyV1;
  {
# line 609 "Types.puma"
   GetExpType (param->VAR_PARAM.V, & yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
  if (param->Kind == kNO_PARAM) {
# line 612 "Types.puma"
 {
  type_rec rtype;
  {
# line 614 "Types.puma"

# line 616 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP3 = rtype;
   return;
 }

  }
  if (param->Kind == kFUNC_PARAM) {
# line 621 "Types.puma"
 {
  type_rec rtype;
  {
# line 623 "Types.puma"

# line 625 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP3 = rtype;
   return;
 }

  }
  if (param->Kind == kPROC_PARAM) {
# line 630 "Types.puma"
 {
  type_rec rtype;
  {
# line 632 "Types.puma"

# line 634 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP3 = rtype;
   return;
 }

  }
  if (param->Kind == kRETURN_PARAM) {
# line 639 "Types.puma"
 {
  type_rec yyV1;
  {
# line 641 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
# line 644 "Types.puma"
 {
  type_rec rtype;
  {
# line 646 "Types.puma"

# line 648 "Types.puma"
   failure_protocol (MODULE, "GetParamType", param);
  }
   * yyP3 = rtype;
   return;
 }

;
}

static void GetParamListType
# if defined __STDC__ | defined __cplusplus
(register tTree explist, type_rec * yyP4)
# else
(explist, yyP4)
 register tTree explist;
 type_rec * yyP4;
# endif
{
  if (explist->Kind == kBTP_EMPTY) {
# line 661 "Types.puma"
 {
  type_rec rtype;
  {
# line 663 "Types.puma"

# line 665 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP4 = rtype;
   return;
 }

  }
  if (explist->Kind == kBTP_LIST) {
  if (explist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 670 "Types.puma"
 {
  type_rec yyV1;
  {
# line 672 "Types.puma"
   GetParamType (explist->BTP_LIST.Elem, & yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

  }
# line 675 "Types.puma"
 {
  type_rec yyV1;
  type_rec yyV2;
  type_rec yyV3;
  {
# line 677 "Types.puma"
   GetParamType (explist->BTP_LIST.Elem, & yyV1);
# line 678 "Types.puma"
   GetParamListType (explist->BTP_LIST.Next, & yyV2);
# line 679 "Types.puma"
   TypeCombination (yyV1, yyV2, & yyV3);
  }
   * yyP4 = yyV3;
   return;
 }

  }
# line 682 "Types.puma"
 {
  type_rec yyV1;
  {
# line 684 "Types.puma"
   failure_protocol (MODULE, "GetParamListType", explist);
# line 685 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

;
}

void GetTypeRecord
# if defined __STDC__ | defined __cplusplus
(register tTree type, type_rec * yyP5)
# else
(type, yyP5)
 register tTree type;
 type_rec * yyP5;
# endif
{
# line 698 "Types.puma"
 {
  type_rec rtype;
  {
# line 700 "Types.puma"
   if (! ((type == NoTree))) goto yyL1;
  {
# line 702 "Types.puma"

# line 704 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
  }
   * yyP5 = rtype;
   return;
 }
yyL1:;


  switch (type->Kind) {
  case kINTEGER_TYPE:
# line 709 "Types.puma"
 {
  type_rec rtype;
  {
# line 711 "Types.puma"

# line 713 "Types.puma"
 rtype.type_kind = kINTEGER_TYPE;
     rtype.type_size = EvaluateSize (type->INTEGER_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kREAL_TYPE:
# line 718 "Types.puma"
 {
  type_rec rtype;
  {
# line 720 "Types.puma"

# line 722 "Types.puma"
 rtype.type_kind = kREAL_TYPE;
     rtype.type_size = EvaluateSize (type->REAL_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kCOMPLEX_TYPE:
# line 727 "Types.puma"
 {
  type_rec rtype;
  {
# line 729 "Types.puma"

# line 731 "Types.puma"
 rtype.type_kind = kCOMPLEX_TYPE;
     rtype.type_size = EvaluateSize (type->COMPLEX_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kBOOLEAN_TYPE:
# line 736 "Types.puma"
 {
  type_rec rtype;
  {
# line 738 "Types.puma"

# line 740 "Types.puma"
 rtype.type_kind = kBOOLEAN_TYPE;
     rtype.type_size = EvaluateSize (type->BOOLEAN_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kSTRING_TYPE:
# line 745 "Types.puma"
 {
  type_rec rtype;
  bool found;
  int val;
  {
# line 747 "Types.puma"

# line 748 "Types.puma"

# line 749 "Types.puma"

# line 751 "Types.puma"
   GetIntConstValue (type->STRING_TYPE.LENGTH, & found, & val);
# line 753 "Types.puma"
 rtype.type_kind = kSTRING_TYPE;
     rtype.type_size = -1;           
     if (found)
        rtype.type_size = val;
   
  }
   * yyP5 = rtype;
   return;
 }

  case kDUMMY_TYPE:
# line 760 "Types.puma"
 {
  type_rec rtype;
  {
# line 762 "Types.puma"

# line 764 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP5 = rtype;
   return;
 }

  case kTYPE_ID:
# line 769 "Types.puma"
 {
  type_rec rtype;
  {
# line 771 "Types.puma"

# line 773 "Types.puma"
 rtype.type_kind = kTYPE_ID;
     rtype.type_size = (int) type->TYPE_ID.ID->TYPE_OBJ.Object;
   
  }
   * yyP5 = rtype;
   return;
 }

  }

# line 778 "Types.puma"
 {
  type_rec rtype;
  {
# line 780 "Types.puma"

# line 781 "Types.puma"
   error_protocol ("could not get the type");
# line 782 "Types.puma"
   tree_protocol ("this is the unknown type : ", type);
  }
   * yyP5 = rtype;
   return;
 }

;
}

void GetOp1Type
# if defined __STDC__ | defined __cplusplus
(register tTree op, type_rec type1, type_rec * yyP6)
# else
(op, type1, yyP6)
 register tTree op;
 type_rec type1;
 type_rec * yyP6;
# endif
{
  if (op->Kind == kOP1_NOT) {
# line 793 "Types.puma"
  {
# line 795 "Types.puma"
   if (! ((IsBoolType (type1)))) goto yyL1;
  }
   * yyP6 = type1;
   return;
yyL1:;

  }
  if (op->Kind == kOP1_SIGN) {
# line 798 "Types.puma"
  {
# line 800 "Types.puma"
   if (! ((IsNumType (type1)))) goto yyL2;
  }
   * yyP6 = type1;
   return;
yyL2:;

  }
  if (op->Kind == kOP1_PSIGN) {
# line 803 "Types.puma"
  {
# line 805 "Types.puma"
   if (! ((IsNumType (type1)))) goto yyL3;
  }
   * yyP6 = type1;
   return;
yyL3:;

  }
# line 808 "Types.puma"
 {
  type_rec rtype;
  {
# line 810 "Types.puma"

# line 812 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
    rtype.type_size = 0;
  
  }
   * yyP6 = rtype;
   return;
 }

;
}

void GetOp2Type
# if defined __STDC__ | defined __cplusplus
(register tTree op, type_rec t1, type_rec t2, type_rec * yyP7)
# else
(op, t1, t2, yyP7)
 register tTree op;
 type_rec t1;
 type_rec t2;
 type_rec * yyP7;
# endif
{
# line 825 "Types.puma"
 {
  type_rec yyV1;
  {
# line 827 "Types.puma"
   if (! ((IsNumOp (op)))) goto yyL1;
  {
# line 829 "Types.puma"
   if (! ((IsNumType (t1)))) goto yyL1;
  {
# line 830 "Types.puma"
   if (! ((IsNumType (t2)))) goto yyL1;
  {
# line 832 "Types.puma"
   TypeCombination (t1, t2, & yyV1);
  }
  }
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL1:;

# line 835 "Types.puma"
  {
# line 837 "Types.puma"
   if (! ((IsBoolOp (op)))) goto yyL2;
  {
# line 839 "Types.puma"
   if (! ((IsBoolType (t1)))) goto yyL2;
  {
# line 840 "Types.puma"
   if (! ((IsBoolType (t2)))) goto yyL2;
  }
  }
  }
   * yyP7 = t1;
   return;
yyL2:;

# line 843 "Types.puma"
 {
  type_rec yyV1;
  {
# line 845 "Types.puma"
   if (! ((IsRelOp (op)))) goto yyL3;
  {
# line 847 "Types.puma"
   if (! ((IsNumType (t1)))) goto yyL3;
  {
# line 848 "Types.puma"
   if (! ((IsNumType (t2)))) goto yyL3;
  {
# line 850 "Types.puma"
   GetLogicalType (& yyV1);
  }
  }
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL3:;

# line 853 "Types.puma"
 {
  type_rec yyV1;
  {
# line 855 "Types.puma"
   if (! ((IsRelOp (op)))) goto yyL4;
  {
# line 857 "Types.puma"
   if (! ((IsStringTypeKind (t1)))) goto yyL4;
  {
# line 858 "Types.puma"
   if (! ((IsStringTypeKind (t2)))) goto yyL4;
  {
# line 860 "Types.puma"
   GetLogicalType (& yyV1);
  }
  }
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL4:;

  if (op->Kind == kOP_CONCAT) {
# line 863 "Types.puma"
  {
# line 865 "Types.puma"
   if (! ((IsStringTypeKind (t1)))) goto yyL5;
  {
# line 866 "Types.puma"
   if (! ((IsStringTypeKind (t2)))) goto yyL5;
  {
# line 868 "Types.puma"
 if ((t2.type_size == -1) || (t1.type_size == -1))
       t1.type_size = -1;
     else
       t1.type_size = t1.type_size + t2.type_size;
  
  }
  }
  }
   * yyP7 = t1;
   return;
yyL5:;

  }
# line 875 "Types.puma"
 {
  type_rec rtype;
  {
# line 877 "Types.puma"

# line 879 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
    rtype.type_size = 0;
  
  }
   * yyP7 = rtype;
   return;
 }

;
}

bool LegalAssignmentTypes
# if defined __STDC__ | defined __cplusplus
(type_rec t1, type_rec t2)
# else
(t1, t2)
 type_rec t1;
 type_rec t2;
# endif
{
# line 892 "Types.puma"
  {
# line 894 "Types.puma"
   if (! ((IsNumType (t1)))) goto yyL1;
  {
# line 895 "Types.puma"
   if (! ((IsNumType (t2)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 898 "Types.puma"
  {
# line 900 "Types.puma"
   if (! ((IsBoolType (t1)))) goto yyL2;
  {
# line 901 "Types.puma"
   if (! ((IsBoolType (t2)))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 904 "Types.puma"
  {
# line 906 "Types.puma"
   if (! ((IsStringTypeKind (t1)))) goto yyL3;
  {
# line 907 "Types.puma"
   if (! ((IsStringTypeKind (t2)))) goto yyL3;
  }
  }
   return true;
yyL3:;

# line 910 "Types.puma"
  {
# line 912 "Types.puma"
   if (! ((t1 . type_kind == kTYPE_ID))) goto yyL4;
  {
# line 913 "Types.puma"
   if (! ((t2 . type_kind == kTYPE_ID))) goto yyL4;
  {
# line 914 "Types.puma"
   if (! ((t1 . type_size == t2 . type_size))) goto yyL4;
  }
  }
  }
   return true;
yyL4:;

  return false;
}

static bool IsNumOp
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_PLUS) {
# line 927 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_MINUS) {
# line 928 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_TIMES) {
# line 929 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_DIVIDE) {
# line 930 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_EXPO) {
# line 931 "Types.puma"
   return true;

  }
  return false;
}

static bool IsBoolOp
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_EQV) {
# line 943 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_NEQV) {
# line 944 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_OR) {
# line 945 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_XOR) {
# line 946 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_AND) {
# line 947 "Types.puma"
   return true;

  }
  return false;
}

static bool IsRelOp
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_EQ) {
# line 959 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_LE) {
# line 960 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_GE) {
# line 961 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_NE) {
# line 962 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_LT) {
# line 963 "Types.puma"
   return true;

  }
  if (op->Kind == kOP_GT) {
# line 964 "Types.puma"
   return true;

  }
  return false;
}

static void GetIntrFuncType
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params, type_rec * yyP8)
# else
(name, params, yyP8)
 register tIdent name;
 register tTree params;
 type_rec * yyP8;
# endif
{
# line 984 "Types.puma"
 {
  type_rec yyV1;
  {
# line 986 "Types.puma"
   if (! (((name == IsIdent ("MAX")) || (name == IsIdent ("MIN"))))) goto yyL1;
  {
# line 987 "Types.puma"
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL1:;

# line 990 "Types.puma"
 {
  type_rec yyV1;
  {
# line 992 "Types.puma"
   if (! (((name == IsIdent ("MAX0")) || (name == IsIdent ("MIN0"))))) goto yyL2;
  {
# line 993 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL2:;

# line 996 "Types.puma"
 {
  type_rec yyV1;
  {
# line 998 "Types.puma"
   if (! (((name == IsIdent ("AMAX1")) || (name == IsIdent ("AMIN1"))))) goto yyL3;
  {
# line 999 "Types.puma"
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL3:;

# line 1002 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1004 "Types.puma"
   if (! (((name == IsIdent ("DMAX1", 5)) || (name == IsIdent ("DMIN1"))))) goto yyL4;
  {
# line 1005 "Types.puma"
   GetRealType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL4:;

# line 1008 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1010 "Types.puma"
   if (! (((name == IsIdent ("AMAX0")) || (name == IsIdent ("AMAX0"))))) goto yyL5;
  {
# line 1011 "Types.puma"
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL5:;

# line 1014 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1016 "Types.puma"
   if (! (((name == IsIdent ("MAX1")) || (name == IsIdent ("MIN1"))))) goto yyL6;
  {
# line 1017 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL6:;

# line 1047 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1049 "Types.puma"
   if (! (((name == IsIdent ("AINT")) || (name == IsIdent ("ANINT")) || (name == IsIdent ("CONJG")) || (name == IsIdent ("DIM")) || (name == IsIdent ("MOD")) || (name == IsIdent ("SIGN"))))) goto yyL7;
  {
# line 1057 "Types.puma"
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL7:;

# line 1060 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1062 "Types.puma"
   if (! (((name == IsIdent ("IDIM")) || (name == IsIdent ("ISIGN")) || (name == IsIdent ("MOD"))))) goto yyL8;
  {
# line 1066 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL8:;

# line 1069 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1071 "Types.puma"
   if (! (((name == IsIdent ("AINT")) || (name == IsIdent ("ANINT")) || (name == IsIdent ("DIM")) || (name == IsIdent ("AMOD")) || (name == IsIdent ("SIGN"))))) goto yyL9;
  {
# line 1078 "Types.puma"
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL9:;

# line 1081 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1083 "Types.puma"
   if (! (((name == IsIdent ("DINT")) || (name == IsIdent ("DNINT")) || (name == IsIdent ("DDIM")) || (name == IsIdent ("DMOD")) || (name == IsIdent ("DSIGN"))))) goto yyL10;
  {
# line 1090 "Types.puma"
   GetRealType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL10:;

# line 1093 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1095 "Types.puma"
   if (! ((name == IsIdent ("DCONJG")))) goto yyL11;
  {
# line 1097 "Types.puma"
   GetComplexType (4 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL11:;

# line 1158 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1160 "Types.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kMATHEMATICAL))) goto yyL12;
  {
# line 1162 "Types.puma"
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL12:;

  if (params->Kind == kBTP_LIST) {
# line 1199 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1201 "Types.puma"
   if (! ((name == IsIdent ("ABS")))) goto yyL13;
  {
# line 1203 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
# line 1207 "Types.puma"
 if (yyV1.type_kind == kCOMPLEX_TYPE)

       { yyV1.type_kind = kREAL_TYPE;
         yyV1.type_size = yyV1.type_size / 2;
       }
   
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL13:;

  }
# line 1215 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1217 "Types.puma"
   if (! (((name == IsIdent ("IABS")) || (name == IsIdent ("INT")) || (name == IsIdent ("IFIX")) || (name == IsIdent ("IDINT")) || (name == IsIdent ("NINT")) || (name == IsIdent ("IDNINT"))))) goto yyL14;
  {
# line 1225 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL14:;

# line 1228 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1230 "Types.puma"
   if (! (((name == IsIdent ("ABS")) || (name == IsIdent ("CABS")) || (name == IsIdent ("AIMAG")) || (name == IsIdent ("REAL")) || (name == IsIdent ("FLOAT")) || (name == IsIdent ("SNGL"))))) goto yyL15;
  {
# line 1238 "Types.puma"
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL15:;

# line 1241 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1243 "Types.puma"
   if (! (((name == IsIdent ("DABS")) || (name == IsIdent ("CDABS")) || (name == IsIdent ("DIMAG")) || (name == IsIdent ("DBLE")) || (name == IsIdent ("DPROD"))))) goto yyL16;
  {
# line 1250 "Types.puma"
   GetRealType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL16:;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
# line 1253 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1255 "Types.puma"
   if (! ((name == IsIdent ("CMPLX")))) goto yyL17;
  {
# line 1256 "Types.puma"
   GetComplexType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL17:;

  }
# line 1259 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1261 "Types.puma"
   if (! ((name == IsIdent ("CMPLX")))) goto yyL18;
  {
# line 1262 "Types.puma"
   GetParamType (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL18:;

  }
  }
  }
# line 1265 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1267 "Types.puma"
   if (! ((name == IsIdent ("DCMPLX")))) goto yyL19;
  {
# line 1268 "Types.puma"
   GetComplexType (4 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL19:;

# line 1290 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1292 "Types.puma"
   if (! (((name == IsIdent ("CHAR")) || (name == IsIdent ("ACHAR"))))) goto yyL20;
  {
# line 1293 "Types.puma"
   GetStringType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL20:;

# line 1296 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1298 "Types.puma"
   if (! (((name == IsIdent ("LGE")) || (name == IsIdent ("LGT")) || (name == IsIdent ("LLE")) || (name == IsIdent ("LLT"))))) goto yyL21;
  {
# line 1303 "Types.puma"
   GetLogicalType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL21:;

# line 1306 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1308 "Types.puma"
   if (! (((name == IsIdent ("ICHAR")) || (name == IsIdent ("IACHAR")) || (name == IsIdent ("LEN")) || (name == IsIdent ("LEN_TRIM")) || (name == IsIdent ("VERIFY")) || (name == IsIdent ("INDEX"))))) goto yyL22;
  {
# line 1315 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL22:;

# line 1333 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1335 "Types.puma"
   if (! ((name == IsIdent ("EXPONENT")))) goto yyL23;
  {
# line 1337 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL23:;

# line 1350 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1352 "Types.puma"
   if (! ((name == IsIdent ("BTEST")))) goto yyL24;
  {
# line 1353 "Types.puma"
   GetLogicalType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL24:;

# line 1362 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1364 "Types.puma"
   if (! ((name == IsIdent ("TRIM")))) goto yyL25;
  {
# line 1365 "Types.puma"
   GetStringType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL25:;

  if (params->Kind == kBTP_LIST) {
# line 1374 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1376 "Types.puma"
   if (! ((IntrFuncElemental (name)))) goto yyL26;
  {
# line 1377 "Types.puma"
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL26:;

# line 1386 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1388 "Types.puma"
   if (! ((name == IsIdent ("COUNT")))) goto yyL27;
  {
# line 1389 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL27:;

# line 1392 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1394 "Types.puma"
   if (! ((IntrFuncRed (name)))) goto yyL28;
  {
# line 1395 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL28:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 1398 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1400 "Types.puma"
   if (! ((name == IsIdent ("COUNT_PREFIX")))) goto yyL29;
  {
# line 1401 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL29:;

# line 1404 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1406 "Types.puma"
   if (! ((name == IsIdent ("COUNT_SUFFIX")))) goto yyL30;
  {
# line 1407 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL30:;

# line 1410 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1412 "Types.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL31;
  {
# line 1413 "Types.puma"
   GetParamType (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL31:;

  }
# line 1416 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1418 "Types.puma"
   if (! ((IntrFuncScan (name)))) goto yyL32;
  {
# line 1419 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL32:;

  }
# line 1422 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1423 "Types.puma"
   if (! ((IntrFuncLocRed (name)))) goto yyL33;
  {
# line 1424 "Types.puma"
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL33:;

 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
# line 1427 "Types.puma"
  {
# line 1428 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
# line 1431 "Types.puma"
  {
# line 1432 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
  if (params->Kind == kBTP_LIST) {
# line 1435 "Types.puma"
  {
# line 1436 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
  if (params->Kind == kBTP_LIST) {
# line 1439 "Types.puma"
  {
# line 1440 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
# line 1443 "Types.puma"
  {
# line 1444 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
# line 1447 "Types.puma"
  {
# line 1448 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("LBOUND"))) {
# line 1451 "Types.puma"
  {
# line 1452 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("UBOUND"))) {
# line 1455 "Types.puma"
  {
# line 1456 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SIZE"))) {
# line 1459 "Types.puma"
  {
# line 1460 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
# line 1463 "Types.puma"
  {
# line 1464 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
# line 1467 "Types.puma"
  {
# line 1468 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
# line 1471 "Types.puma"
  {
# line 1472 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ALLOCATED"))) {
# line 1475 "Types.puma"
  {
# line 1476 "Types.puma"
   GetLogicalType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ASSOCIATED"))) {
# line 1479 "Types.puma"
  {
# line 1480 "Types.puma"
   GetLogicalType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
# line 1483 "Types.puma"
  {
# line 1484 "Types.puma"
   GetLogicalType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("NUMBER_OF_PROCESSORS"))) {
# line 1487 "Types.puma"
  {
# line 1488 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ACTIVE_NUM_PROCS"))) {
# line 1491 "Types.puma"
  {
# line 1492 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("MY_PROCESSOR"))) {
# line 1495 "Types.puma"
  {
# line 1496 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_LBOUND"))) {
# line 1499 "Types.puma"
  {
# line 1500 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_UBOUND"))) {
# line 1503 "Types.puma"
  {
# line 1504 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_SIZE"))) {
# line 1507 "Types.puma"
  {
# line 1508 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_SHAPE"))) {
# line 1511 "Types.puma"
  {
# line 1512 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("KIND"))) {
# line 1515 "Types.puma"
  {
# line 1516 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("DIGITS"))) {
# line 1519 "Types.puma"
  {
# line 1520 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("EPSILON"))) {
  if (params->Kind == kBTP_LIST) {
# line 1523 "Types.puma"
  {
# line 1525 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("HUGE"))) {
  if (params->Kind == kBTP_LIST) {
# line 1528 "Types.puma"
  {
# line 1530 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("TINY"))) {
  if (params->Kind == kBTP_LIST) {
# line 1533 "Types.puma"
  {
# line 1535 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("MINEXPONENT"))) {
# line 1538 "Types.puma"
  {
# line 1539 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("MAXEXPONENT"))) {
# line 1542 "Types.puma"
  {
# line 1543 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("PRECISION"))) {
# line 1546 "Types.puma"
  {
# line 1547 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("RADIX"))) {
# line 1550 "Types.puma"
  {
# line 1551 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("RANGE"))) {
# line 1554 "Types.puma"
  {
# line 1555 "Types.puma"
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
  if (params->Kind == kBTP_LIST) {
# line 1564 "Types.puma"
 {
  type_rec yyV1;
  {
# line 1565 "Types.puma"
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;
 }

  }
# line 1568 "Types.puma"
 {
  type_rec rtype;
  {
# line 1570 "Types.puma"

# line 1572 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE; 
# line 1574 "Types.puma"
   obj_protocol ("no type for this intrinsic object : ", GetIntrinsicObject (name));
  }
   * yyP8 = rtype;
   return;
 }

;
}

static void TypeCombination
# if defined __STDC__ | defined __cplusplus
(type_rec type1, type_rec type2, type_rec * yyP9)
# else
(type1, type2, yyP9)
 type_rec type1;
 type_rec type2;
 type_rec * yyP9;
# endif
{
# line 1593 "Types.puma"
  {
# line 1595 "Types.puma"
   if (! ((SameTypeRecord (type1, type2)))) goto yyL1;
  }
   * yyP9 = type1;
   return;
yyL1:;

# line 1598 "Types.puma"
  {
# line 1600 "Types.puma"
   if (! ((IsSubType (type1, type2)))) goto yyL2;
  }
   * yyP9 = type2;
   return;
yyL2:;

# line 1603 "Types.puma"
  {
# line 1605 "Types.puma"
   if (! ((IsSubType (type2, type1)))) goto yyL3;
  }
   * yyP9 = type1;
   return;
yyL3:;

# line 1608 "Types.puma"
 {
  type_rec rtype;
  {
# line 1610 "Types.puma"

# line 1612 "Types.puma"
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP9 = rtype;
   return;
 }

;
}

bool IsSubType
# if defined __STDC__ | defined __cplusplus
(type_rec type1, type_rec type2)
# else
(type1, type2)
 type_rec type1;
 type_rec type2;
# endif
{
# line 1627 "Types.puma"
  {
# line 1628 "Types.puma"
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL1;
  {
# line 1629 "Types.puma"
   if (! ((type1 . type_kind == kTYPE_ID))) goto yyL1;
  {
# line 1630 "Types.puma"
   if (! ((type1 . type_size == type2 . type_size))) goto yyL1;
  }
  }
  }
   return true;
yyL1:;

# line 1633 "Types.puma"
  {
# line 1634 "Types.puma"
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL2;
  {
# line 1635 "Types.puma"
   if (! ((type1 . type_kind != kTYPE_ID))) goto yyL2;
  {
# line 1636 "Types.puma"
   if (! ((type1 . type_size <= type2 . type_size))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

# line 1639 "Types.puma"
  {
# line 1640 "Types.puma"
   if (! ((type1 . type_kind == kDUMMY_TYPE))) goto yyL3;
  }
   return true;
yyL3:;

# line 1643 "Types.puma"
  {
# line 1644 "Types.puma"
   if (! ((type1 . type_kind == kINTEGER_TYPE))) goto yyL4;
  {
# line 1645 "Types.puma"
   if (! ((type2 . type_kind == kREAL_TYPE))) goto yyL4;
  }
  }
   return true;
yyL4:;

# line 1648 "Types.puma"
  {
# line 1649 "Types.puma"
   if (! ((type1 . type_kind == kINTEGER_TYPE))) goto yyL5;
  {
# line 1650 "Types.puma"
   if (! ((type2 . type_kind == kCOMPLEX_TYPE))) goto yyL5;
  }
  }
   return true;
yyL5:;

# line 1653 "Types.puma"
  {
# line 1654 "Types.puma"
   if (! ((type1 . type_kind == kREAL_TYPE))) goto yyL6;
  {
# line 1655 "Types.puma"
   if (! ((type2 . type_kind == kCOMPLEX_TYPE))) goto yyL6;
  }
  }
   return true;
yyL6:;

  return false;
}

bool SameTypeRecord
# if defined __STDC__ | defined __cplusplus
(type_rec type1, type_rec type2)
# else
(type1, type2)
 type_rec type1;
 type_rec type2;
# endif
{
# line 1668 "Types.puma"
  {
# line 1670 "Types.puma"
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL1;
  {
# line 1671 "Types.puma"
   if (! ((type1 . type_size == type2 . type_size))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 1674 "Types.puma"
  {
# line 1676 "Types.puma"
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL2;
  {
# line 1677 "Types.puma"
   if (! ((type1 . type_kind == kSTRING_TYPE))) goto yyL2;
  }
  }
   return true;
yyL2:;

  return false;
}

static bool IsNumType
# if defined __STDC__ | defined __cplusplus
(type_rec type)
# else
(type)
 type_rec type;
# endif
{
# line 1683 "Types.puma"
  {
# line 1684 "Types.puma"
   if (! ((type . type_kind == kINTEGER_TYPE))) goto yyL1;
  }
   return true;
yyL1:;

# line 1687 "Types.puma"
  {
# line 1688 "Types.puma"
   if (! ((type . type_kind == kREAL_TYPE))) goto yyL2;
  }
   return true;
yyL2:;

# line 1691 "Types.puma"
  {
# line 1692 "Types.puma"
   if (! ((type . type_kind == kCOMPLEX_TYPE))) goto yyL3;
  }
   return true;
yyL3:;

  return false;
}

static bool IsBoolType
# if defined __STDC__ | defined __cplusplus
(type_rec type)
# else
(type)
 type_rec type;
# endif
{
# line 1697 "Types.puma"
  {
# line 1698 "Types.puma"
   if (! ((type . type_kind == kBOOLEAN_TYPE))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

static bool IsStringTypeKind
# if defined __STDC__ | defined __cplusplus
(type_rec type)
# else
(type)
 type_rec type;
# endif
{
# line 1703 "Types.puma"
  {
# line 1704 "Types.puma"
   if (! ((type . type_kind == kSTRING_TYPE))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

static void GetIntegerType
# if defined __STDC__ | defined __cplusplus
(type_rec * yyP10)
# else
(yyP10)
 type_rec * yyP10;
# endif
{
# line 1715 "Types.puma"
 {
  type_rec rtype;
  {
# line 1717 "Types.puma"

# line 1719 "Types.puma"
 rtype.type_kind = kINTEGER_TYPE;
    rtype.type_size = default_int_size;
  
  }
   * yyP10 = rtype;
   return;
 }

;
}

static void GetRealType
# if defined __STDC__ | defined __cplusplus
(register int size, type_rec * yyP11)
# else
(size, yyP11)
 register int size;
 type_rec * yyP11;
# endif
{
# line 1726 "Types.puma"
 {
  type_rec rtype;
  {
# line 1728 "Types.puma"

# line 1730 "Types.puma"
 rtype.type_kind = kREAL_TYPE;
    rtype.type_size = size;
  
  }
   * yyP11 = rtype;
   return;
 }

;
}

static void GetComplexType
# if defined __STDC__ | defined __cplusplus
(register int size, type_rec * yyP12)
# else
(size, yyP12)
 register int size;
 type_rec * yyP12;
# endif
{
# line 1737 "Types.puma"
 {
  type_rec rtype;
  {
# line 1739 "Types.puma"

# line 1741 "Types.puma"
 rtype.type_kind = kCOMPLEX_TYPE;
    rtype.type_size = size;
  
  }
   * yyP12 = rtype;
   return;
 }

;
}

static void GetLogicalType
# if defined __STDC__ | defined __cplusplus
(type_rec * yyP13)
# else
(yyP13)
 type_rec * yyP13;
# endif
{
# line 1748 "Types.puma"
 {
  type_rec rtype;
  {
# line 1750 "Types.puma"

# line 1752 "Types.puma"
 rtype.type_kind = kBOOLEAN_TYPE;
    rtype.type_size = default_int_size;
  
  }
   * yyP13 = rtype;
   return;
 }

;
}

static void GetStringType
# if defined __STDC__ | defined __cplusplus
(type_rec * yyP14)
# else
(yyP14)
 type_rec * yyP14;
# endif
{
# line 1759 "Types.puma"
 {
  type_rec rtype;
  {
# line 1761 "Types.puma"

# line 1763 "Types.puma"
 rtype.type_kind = kSTRING_TYPE;
    rtype.type_size = -1;            
  
  }
   * yyP14 = rtype;
   return;
 }

;
}

tTree GetTypeZero
# if defined __STDC__ | defined __cplusplus
(register tTree texp)
# else
(texp)
 register tTree texp;
# endif
{
# line 1776 "Types.puma"
 {
  type_rec yyV1;
  tTree zero;
  {
# line 1778 "Types.puma"
   GetExpType (texp, & yyV1);
# line 1780 "Types.puma"

# line 1782 "Types.puma"
 zero = NoTree;

     switch (yyV1.type_kind) {

     case kINTEGER_TYPE :  zero = mCONST_EXP (mINT_CONSTANT (0));
                           break;
     case kBOOLEAN_TYPE :  zero = mCONST_EXP (mBOOL_CONSTANT (false));
                           break;
     case kREAL_TYPE : if (yyV1.type_size == default_real_size)
                          zero = mCONST_EXP (mREAL_CONSTANT (PutString("0.0",3),
                                                           default_real_size));
                    if (yyV1.type_size == 2*default_real_size)
                       zero = mCONST_EXP (mREAL_CONSTANT (PutString("0.0d0",5),
                                                         2*default_real_size));
                    break;

     case kCOMPLEX_TYPE : if (yyV1.type_size == 2*default_real_size)

                    zero = mCONST_EXP (mCOMPLEX_CONSTANT (PutString("0.0",3),
                                                          PutString("0.0",3)));
                    break;

     case kSTRING_TYPE : error_protocol ("strings not supported here");
                         zero = mCONST_EXP (mSTRING_CONSTANT(
                                             PutString (" ", 1)));
                         break;

       } 

      if (zero == NoTree)
        {  error_protocol ("zero value for the type not found");
           tree_protocol  ("needed for ", texp);
           zero = mCONST_EXP (mINT_CONSTANT (0));
        }

    
  }
  {
   return zero;
  }
 }

}

bool IsSameExpType
# if defined __STDC__ | defined __cplusplus
(register tTree t1, register tTree t2)
# else
(t1, t2)
 register tTree t1;
 register tTree t2;
# endif
{
# line 1831 "Types.puma"
 {
  type_rec yyV1;
  type_rec yyV2;
  {
# line 1833 "Types.puma"
   GetExpType (t1, & yyV1);
# line 1834 "Types.puma"
   GetExpType (t2, & yyV2);
# line 1835 "Types.puma"
   if (! ((yyV1 . type_kind == yyV2 . type_kind))) goto yyL1;
  {
# line 1836 "Types.puma"
   if (! ((yyV1 . type_size == yyV2 . type_size))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  return false;
}

bool IsSameBaseType
# if defined __STDC__ | defined __cplusplus
(register tTree t1, register tTree t2)
# else
(t1, t2)
 register tTree t1;
 register tTree t2;
# endif
{
# line 1841 "Types.puma"

char msg[150];

# line 1845 "Types.puma"
 {
  type_rec yyV1;
  type_rec yyV2;
  {
# line 1847 "Types.puma"
   GetTypeRecord (t1, & yyV1);
# line 1848 "Types.puma"
   GetTypeRecord (t2, & yyV2);
# line 1857 "Types.puma"
   if (! ((yyV1 . type_kind == yyV2 . type_kind))) goto yyL1;
  {
# line 1858 "Types.puma"
   if (! ((yyV1 . type_size == yyV2 . type_size))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  return false;
}

int GetObjectSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1875 "Types.puma"
   return GetTypeSize (GetObjectType (obj));

}

static int GetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
# line 1886 "Types.puma"
  {
# line 1887 "Types.puma"
   if (! ((type == NoTree))) goto yyL1;
  }
   return - 1;
yyL1:;


  switch (type->Kind) {
  case kINTEGER_TYPE:
# line 1891 "Types.puma"
   return EvaluateSize (type->INTEGER_TYPE.SIZE);

  case kREAL_TYPE:
# line 1896 "Types.puma"
   return EvaluateSize (type->REAL_TYPE.SIZE);

  case kCOMPLEX_TYPE:
# line 1901 "Types.puma"
   return EvaluateSize (type->COMPLEX_TYPE.SIZE);

  case kBOOLEAN_TYPE:
# line 1906 "Types.puma"
   return EvaluateSize (type->BOOLEAN_TYPE.SIZE);

  case kSTRING_TYPE:
# line 1911 "Types.puma"
   return EvaluateSize (type->STRING_TYPE.LENGTH);

  case kDUMMY_TYPE:
# line 1916 "Types.puma"
   return - 1;

  case kTYPE_ID:
# line 1921 "Types.puma"
   return DerivedTypeSize (type->TYPE_ID.ID->TYPE_OBJ.Object);

  case kPOINTER_TYPE:
# line 1926 "Types.puma"
   return default_addr_size;

  case kARRAY_TYPE:
# line 1931 "Types.puma"
   return MultSizes (FormalSize (type->ARRAY_TYPE.ARRAY_INDEX_TYPES), GetTypeSize (type->ARRAY_TYPE.ARRAY_COMP_TYPE));

  }

# line 1936 "Types.puma"
  {
# line 1937 "Types.puma"
   failure_protocol (MODULE, "GetTypeSize", type);
  }
   return - 1;

}

static int DerivedTypeSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTypeObject) {
# line 1949 "Types.puma"
 {
  int size;
  {
# line 1951 "Types.puma"

# line 1953 "Types.puma"
   size = ComponentsSize (obj->TypeObject.Components);
  }
  {
   return size;
  }
 }

  }
 yyAbort ("DerivedTypeSize");
}

static int ComponentsSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions components)
# else
(components)
 register tDefinitions components;
# endif
{
  if (components->Kind == kENTRY_LIST) {
# line 1960 "Types.puma"
   return AddSizes (ComponentsSize (components->ENTRY_LIST.Next), GetObjectSize (components->ENTRY_LIST.Elem));

  }
  if (components->Kind == kENTRY_EMPTY) {
# line 1964 "Types.puma"
   return 0;

  }
 yyAbort ("ComponentsSize");
}

static int FormalSize
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_LIST) {
# line 1974 "Types.puma"
   return MultSizes (FormalSize (formals->SHAPE_LIST.Elem), FormalSize (formals->SHAPE_LIST.Next));

  }
  if (formals->Kind == kSHAPE_EMPTY) {
# line 1978 "Types.puma"
   return 1;

  }
  if (formals->Kind == kEXPLICIT_SHAPE) {
# line 1982 "Types.puma"
 {
  int val1;
  int val2;
  bool found;
  {
# line 1984 "Types.puma"

# line 1985 "Types.puma"

# line 1986 "Types.puma"

# line 1988 "Types.puma"
   GetIntConstValue (formals->EXPLICIT_SHAPE.LOWER, & found, & val1);
# line 1989 "Types.puma"
   if (! ((found))) goto yyL3;
  {
# line 1990 "Types.puma"
   GetIntConstValue (formals->EXPLICIT_SHAPE.UPPER, & found, & val2);
# line 1991 "Types.puma"
   if (! ((found))) goto yyL3;
  }
  }
  {
   return val2 - val1 + 1;
  }
 }
yyL3:;

  }
  if (Tree_IsType (formals, kSHAPE_SPEC)) {
# line 1995 "Types.puma"
   return - 1;

  }
 yyAbort ("FormalSize");
}

static int AddSizes
# if defined __STDC__ | defined __cplusplus
(register int size1, register int size2)
# else
(size1, size2)
 register int size1;
 register int size2;
# endif
{
# line 2005 "Types.puma"
  {
# line 2006 "Types.puma"
   if (! ((size1 == - 1))) goto yyL1;
  }
   return - 1;
yyL1:;

# line 2010 "Types.puma"
  {
# line 2011 "Types.puma"
   if (! ((size2 == - 1))) goto yyL2;
  }
   return - 1;
yyL2:;

# line 2015 "Types.puma"
   return size1 + size2;

}

static int MultSizes
# if defined __STDC__ | defined __cplusplus
(register int size1, register int size2)
# else
(size1, size2)
 register int size1;
 register int size2;
# endif
{
# line 2026 "Types.puma"
  {
# line 2027 "Types.puma"
   if (! ((size1 == - 1))) goto yyL1;
  }
   return - 1;
yyL1:;

# line 2031 "Types.puma"
  {
# line 2032 "Types.puma"
   if (! ((size2 == - 1))) goto yyL2;
  }
   return - 1;
yyL2:;

# line 2036 "Types.puma"
   return size1 * size2;

}

static int EvaluateSize
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
# line 2049 "Types.puma"
 {
  bool found;
  int val;
  {
# line 2051 "Types.puma"

# line 2052 "Types.puma"

# line 2054 "Types.puma"
   GetIntConstValue (size, & found, & val);
# line 2055 "Types.puma"
   if (! ((found))) goto yyL1;
  }
  {
   return val;
  }
 }
yyL1:;

# line 2059 "Types.puma"
   return - 1;

}

tTree ArrayFormals
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 2071 "Types.puma"
  {
# line 2072 "Types.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 2073 "Types.puma"
   failure_protocol (MODULE, "ArrayFormals: no object", NoTree);
  }
  }
   return NoTree;
yyL1:;

  if (v->Kind == kTemplateObject) {
  if (v->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 2077 "Types.puma"
   return v->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS;

  }
  }
  if (v->Kind == kRaggedObject) {
  if (v->RaggedObject.decl->Kind == kRAGGED_DECL) {
# line 2082 "Types.puma"
   return v->RaggedObject.decl->RAGGED_DECL.DIMENSIONS;

  }
  }
# line 2087 "Types.puma"
 {
  tTree type;
  {
# line 2089 "Types.puma"

# line 2091 "Types.puma"
   type = GetObjectType (v);
# line 2093 "Types.puma"
   if (! ((IsArrayType (type)))) goto yyL4;
  }
  {
   return GetFormals (type);
  }
 }
yyL4:;

# line 2098 "Types.puma"
  {
# line 2099 "Types.puma"
   failure_protocol (MODULE, "ArrayFormals not array", v->Object.decl);
  }
   return NoTree;

}

static tTree GetFormals
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kARRAY_TYPE) {
# line 2105 "Types.puma"
   return type->ARRAY_TYPE.ARRAY_INDEX_TYPES;

  }
  if (type->Kind == kPOINTER_TYPE) {
# line 2106 "Types.puma"
   return GetFormals (type->POINTER_TYPE.PTR_COMP);

  }
 yyAbort ("GetFormals");
}

void BeginTypes ()
{
}

void CloseTypes ()
{
}
