# include "TreeOps.h"
# include "yyTreeOps.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 41 "TreeOps.puma"


# define MODULE "TreeOps"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"



static void yyExit () { Exit (1); }

void (* TreeOps_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TreeOps, routine %s failed\n", yyFunction);
 TreeOps_Exit ();
}

int TreeListLength ARGS((tTree t));
tTree TreeListGet ARGS((tTree list, int n));
tIdent TreeVarName ARGS((tTree var));
tIdent GetGenericId ARGS((tTree t));
tIdent MakeOperatorId ARGS((tTree t));
bool IsDeferredShape ARGS((tTree formals));
bool IsAssumedShape ARGS((tTree formals));
bool IsExplicitShape ARGS((tTree formals));
bool IsOverlappedShape ARGS((tTree t));
static void GetDimOverlap ARGS((tTree formal, int * yyP2, int * yyP1));
int IsVarInExp ARGS((tIdent name, tTree exp));
bool IsForallLoop ARGS((tTree loop));
bool IsIndepLoop ARGS((tTree loop));
bool IsIndepDoLoop ARGS((tTree loop));
int GetLayout ARGS((bool is_f77, int model));

int TreeListLength
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 61 "TreeOps.puma"
  {
# line 62 "TreeOps.puma"
   if (! (t == NoTree)) goto yyL1;
  }
   return 0;
yyL1:;


  switch (t->Kind) {
  case kACF_LIST:
# line 66 "TreeOps.puma"
   return 1 + TreeListLength (t->ACF_LIST.Next);

  case kACF_EMPTY:
# line 70 "TreeOps.puma"
   return 0;

  case kBTE_LIST:
# line 74 "TreeOps.puma"
   return 1 + TreeListLength (t->BTE_LIST.Next);

  case kBTE_EMPTY:
# line 78 "TreeOps.puma"
   return 0;

  case kBTV_LIST:
# line 82 "TreeOps.puma"
   return (1 + TreeListLength (t->BTV_LIST.Next));

  case kBTV_EMPTY:
# line 86 "TreeOps.puma"
   return 0;

  case kBTP_LIST:
# line 90 "TreeOps.puma"
   return (1 + TreeListLength (t->BTP_LIST.Next));

  case kBTP_EMPTY:
# line 94 "TreeOps.puma"
   return 0;

  case kSHAPE_LIST:
# line 98 "TreeOps.puma"
   return (1 + TreeListLength (t->SHAPE_LIST.Next));

  case kSHAPE_EMPTY:
# line 102 "TreeOps.puma"
   return 0;

  case kDECL_LIST:
# line 106 "TreeOps.puma"
   return (1 + TreeListLength (t->DECL_LIST.Next));

  case kDECL_EMPTY:
# line 110 "TreeOps.puma"
   return 0;

  case kUNIT_LIST:
# line 114 "TreeOps.puma"
   return (1 + TreeListLength (t->UNIT_LIST.Next));

  case kUNIT_EMPTY:
# line 118 "TreeOps.puma"
   return 0;

  case kDIST_LIST:
# line 122 "TreeOps.puma"
   return (1 + TreeListLength (t->DIST_LIST.Next));

  case kDIST_EMPTY:
# line 126 "TreeOps.puma"
   return 0;

  case kON_LIST:
# line 130 "TreeOps.puma"
   return (1 + TreeListLength (t->ON_LIST.Next));

  case kON_EMPTY:
# line 134 "TreeOps.puma"
   return 0;

  case kSELECT_LIST:
# line 138 "TreeOps.puma"
   return (1 + TreeListLength (t->SELECT_LIST.Next));

  case kSELECT_EMPTY:
# line 142 "TreeOps.puma"
   return 0;

  }

# line 146 "TreeOps.puma"
  {
# line 147 "TreeOps.puma"
   failure_protocol ("Objects", "TreeListLength", t);
  }
   return 0;

}

tTree TreeListGet
# if defined __STDC__ | defined __cplusplus
(register tTree list, register int n)
# else
(list, n)
 register tTree list;
 register int n;
# endif
{
# line 159 "TreeOps.puma"
  {
# line 160 "TreeOps.puma"
   if (! ((n <= 0))) goto yyL1;
  {
# line 161 "TreeOps.puma"
   failure_protocol ("Types", "TreeListGet (n<=0)", list);
  }
  }
   return list;
yyL1:;

  if (list->Kind == kSHAPE_LIST) {
  if (equalint (n, 1)) {
# line 167 "TreeOps.puma"
   return list->SHAPE_LIST.Elem;

  }
# line 171 "TreeOps.puma"
   return TreeListGet (list->SHAPE_LIST.Next, n - 1);

  }
  if (list->Kind == kBTE_LIST) {
  if (equalint (n, 1)) {
# line 175 "TreeOps.puma"
   return list->BTE_LIST.Elem;

  }
# line 179 "TreeOps.puma"
   return TreeListGet (list->BTE_LIST.Next, n - 1);

  }
# line 183 "TreeOps.puma"
  {
# line 184 "TreeOps.puma"
   failure_protocol (MODULE, "TreeListGet", list);
  }
   return list;

}

tIdent TreeVarName
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{

  switch (var->Kind) {
  case kVAR_OBJ:
# line 196 "TreeOps.puma"
   return var->VAR_OBJ.Ident;

  case kUSED_VAR:
# line 200 "TreeOps.puma"
   return TreeVarName (var->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 204 "TreeOps.puma"
   return TreeVarName (var->LOOP_VAR.LOOP_VARNAME);

  case kVAR_PARAM:
# line 208 "TreeOps.puma"
   return TreeVarName (var->VAR_PARAM.V);

  case kVAR_EXP:
# line 212 "TreeOps.puma"
   return TreeVarName (var->VAR_EXP.V);

  case kSUBSTRING_VAR:
# line 216 "TreeOps.puma"
   return TreeVarName (var->SUBSTRING_VAR.IND_VAR);

  case kINDEXED_VAR:
# line 220 "TreeOps.puma"
   return TreeVarName (var->INDEXED_VAR.IND_VAR);

  case kSELECTED_VAR:
# line 224 "TreeOps.puma"
   return TreeVarName (var->SELECTED_VAR.SELEC_VAR);

  case kREMOTE_VAR:
# line 228 "TreeOps.puma"
   return TreeVarName (var->REMOTE_VAR.VAR);

  }

# line 232 "TreeOps.puma"
  {
# line 233 "TreeOps.puma"
   failure_protocol (MODULE, "TreeVarName", var);
  }
   return DefaultId ();

}

tIdent GetGenericId
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kID_GENERIC_SPEC) {
# line 245 "TreeOps.puma"
   return t->ID_GENERIC_SPEC.name;

  }
  if (t->Kind == kOP_GENERIC_SPEC) {
# line 250 "TreeOps.puma"
   return MakeOperatorId (t->OP_GENERIC_SPEC.OPERATOR);

  }
  if (t->Kind == kASSIGN_GENERIC_SPEC) {
# line 255 "TreeOps.puma"
   return MakeIdent ("=", 1);

  }
  if (t->Kind == kNO_GENERIC_SPEC) {
# line 260 "TreeOps.puma"
   return DefaultId ();

  }
# line 265 "TreeOps.puma"
  {
# line 266 "TreeOps.puma"
   failure_protocol (MODULE, "GetGenericId", t);
  }
   return DefaultId ();

}

tIdent MakeOperatorId
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kOP_EQ:
# line 278 "TreeOps.puma"
   return MakeIdent (".eq.", 4);

  case kOP_NE:
# line 279 "TreeOps.puma"
   return MakeIdent (".ne.", 4);

  case kOP_LE:
# line 280 "TreeOps.puma"
   return MakeIdent (".le.", 4);

  case kOP_LT:
# line 281 "TreeOps.puma"
   return MakeIdent (".lt.", 4);

  case kOP_GE:
# line 282 "TreeOps.puma"
   return MakeIdent (".ge.", 4);

  case kOP_GT:
# line 283 "TreeOps.puma"
   return MakeIdent (".gt.", 4);

  case kOP_PLUS:
# line 285 "TreeOps.puma"
   return MakeIdent ("+", 1);

  case kOP_MINUS:
# line 286 "TreeOps.puma"
   return MakeIdent ("-", 1);

  case kOP_OR:
# line 287 "TreeOps.puma"
   return MakeIdent (".or.", 4);

  case kOP_XOR:
# line 288 "TreeOps.puma"
   return MakeIdent (".xor.", 5);

  case kOP_CONCAT:
# line 289 "TreeOps.puma"
   return MakeIdent ("//", 2);

  case kOP_TIMES:
# line 290 "TreeOps.puma"
   return MakeIdent ("*", 1);

  case kOP_DIVIDE:
# line 291 "TreeOps.puma"
   return MakeIdent ("/", 1);

  case kOP_AND:
# line 292 "TreeOps.puma"
   return MakeIdent (".and.", 5);

  case kOP_EQV:
# line 293 "TreeOps.puma"
   return MakeIdent (".eqv.", 5);

  case kOP_NEQV:
# line 294 "TreeOps.puma"
   return MakeIdent (".neqv.", 6);

  case kOP_EXPO:
# line 295 "TreeOps.puma"
   return MakeIdent ("**", 2);

  case kOP1_NOT:
# line 297 "TreeOps.puma"
   return MakeIdent (".not.", 5);

  case kOP1_SIGN:
# line 298 "TreeOps.puma"
   return MakeIdent ("-", 1);

  case kOP1_PSIGN:
# line 299 "TreeOps.puma"
   return MakeIdent ("+", 1);

  case kOP_DEFINED:
# line 301 "TreeOps.puma"
   return t->OP_DEFINED.opname;

  }

# line 303 "TreeOps.puma"
  {
# line 304 "TreeOps.puma"
   failure_protocol (MODULE, "MakeOperatorId", t);
  }
   return DefaultId ();

}

bool IsDeferredShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_EMPTY) {
# line 316 "TreeOps.puma"
   return true;

  }
  if (formals->Kind == kSHAPE_LIST) {
# line 319 "TreeOps.puma"
  {
# line 320 "TreeOps.puma"
   if (! ((IsDeferredShape (formals->SHAPE_LIST.Elem)))) goto yyL2;
  {
# line 321 "TreeOps.puma"
   if (! ((IsDeferredShape (formals->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (formals->Kind == kDEFERRED_SHAPE) {
# line 324 "TreeOps.puma"
   return true;

  }
  return false;
}

bool IsAssumedShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_EMPTY) {
# line 335 "TreeOps.puma"
   return true;

  }
  if (formals->Kind == kSHAPE_LIST) {
# line 338 "TreeOps.puma"
  {
# line 339 "TreeOps.puma"
   if (! ((IsAssumedShape (formals->SHAPE_LIST.Elem)))) goto yyL2;
  {
# line 340 "TreeOps.puma"
   if (! ((IsAssumedShape (formals->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (formals->Kind == kDEFERRED_SHAPE) {
# line 343 "TreeOps.puma"
   return true;

  }
  if (formals->Kind == kASSUMED_SHAPE) {
# line 346 "TreeOps.puma"
   return true;

  }
  return false;
}

bool IsExplicitShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_EMPTY) {
# line 357 "TreeOps.puma"
   return true;

  }
  if (formals->Kind == kSHAPE_LIST) {
# line 360 "TreeOps.puma"
  {
# line 361 "TreeOps.puma"
   if (! ((IsExplicitShape (formals->SHAPE_LIST.Elem)))) goto yyL2;
  {
# line 362 "TreeOps.puma"
   if (! ((IsExplicitShape (formals->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (formals->Kind == kEXPLICIT_SHAPE) {
# line 365 "TreeOps.puma"
   return true;

  }
  return false;
}

bool IsOverlappedShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHAPE_LIST) {
# line 376 "TreeOps.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 378 "TreeOps.puma"
   GetDimOverlap (t->SHAPE_LIST.Elem, & yyV1, & yyV2);
# line 379 "TreeOps.puma"
   if (! ((yyV1 + yyV2 > 0))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 382 "TreeOps.puma"
  {
# line 383 "TreeOps.puma"
   if (! ((IsOverlappedShape (t->SHAPE_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static void GetDimOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree formal, register int * yyP2, register int * yyP1)
# else
(formal, yyP2, yyP1)
 register tTree formal;
 register int * yyP2;
 register int * yyP1;
# endif
{
  if (formal->Kind == kOVERLAP_SPEC) {
# line 394 "TreeOps.puma"
   * yyP2 = formal->OVERLAP_SPEC.left_size;
   * yyP1 = formal->OVERLAP_SPEC.right_size;
   return;

  }
  if (Tree_IsType (formal, kSHAPE_SPEC)) {
# line 397 "TreeOps.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 399 "TreeOps.puma"
   GetDimOverlap (formal->SHAPE_SPEC.Overlap, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 402 "TreeOps.puma"
  {
# line 403 "TreeOps.puma"
   failure_protocol (MODULE, "GetDimOverlap", formal);
  }
   * yyP2 = 0;
   * yyP1 = 0;
   return;

;
}

int IsVarInExp
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree exp)
# else
(name, exp)
 register tIdent name;
 register tTree exp;
# endif
{
# line 416 "TreeOps.puma"
  {
# line 418 "TreeOps.puma"
   if (! ((exp == NoTree))) goto yyL1;
  }
   return 0;
yyL1:;


  switch (exp->Kind) {
  case kVAR_OBJ:
# line 422 "TreeOps.puma"
  {
# line 424 "TreeOps.puma"
   if (! ((name == exp->VAR_OBJ.Ident))) goto yyL2;
  }
   return 1;
yyL2:;

# line 428 "TreeOps.puma"
   return 0;

  case kUSED_VAR:
# line 433 "TreeOps.puma"
   return IsVarInExp (name, exp->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 437 "TreeOps.puma"
   return IsVarInExp (name, exp->LOOP_VAR.LOOP_VARNAME);

  case kINDEXED_VAR:
# line 441 "TreeOps.puma"
   return (IsVarInExp (name, exp->INDEXED_VAR.IND_VAR) + IsVarInExp (name, exp->INDEXED_VAR.IND_EXPS));

  case kSELECTED_VAR:
# line 445 "TreeOps.puma"
   return IsVarInExp (name, exp->SELECTED_VAR.SELEC_VAR);

  case kSUBSTRING_VAR:
# line 449 "TreeOps.puma"
   return (IsVarInExp (name, exp->SUBSTRING_VAR.IND_VAR) + IsVarInExp (name, exp->SUBSTRING_VAR.IND_EXP));

  case kBTV_LIST:
# line 453 "TreeOps.puma"
   return (IsVarInExp (name, exp->BTV_LIST.Elem) + IsVarInExp (name, exp->BTV_LIST.Next));

  case kBTV_EMPTY:
# line 457 "TreeOps.puma"
   return 0;

  case kVAR_EXP:
# line 461 "TreeOps.puma"
   return IsVarInExp (name, exp->VAR_EXP.V);

  case kBTE_LIST:
# line 465 "TreeOps.puma"
   return (IsVarInExp (name, exp->BTE_LIST.Elem) + IsVarInExp (name, exp->BTE_LIST.Next));

  case kBTE_EMPTY:
# line 469 "TreeOps.puma"
   return 0;

  case kSLICE_EXP:
# line 473 "TreeOps.puma"
   return (IsVarInExp (name, exp->SLICE_EXP.START) + IsVarInExp (name, exp->SLICE_EXP.STOP) + IsVarInExp (name, exp->SLICE_EXP.INC));

  case kDUMMY_EXP:
# line 478 "TreeOps.puma"
   return 0;

  case kCONST_EXP:
# line 482 "TreeOps.puma"
   return 0;

  case kADDR:
# line 486 "TreeOps.puma"
   return (IsVarInExp (name, exp->ADDR.E));

  case kOP_EXP:
# line 490 "TreeOps.puma"
   return (IsVarInExp (name, exp->OP_EXP.OPND1) + IsVarInExp (name, exp->OP_EXP.OPND2));

  case kOP1_EXP:
# line 494 "TreeOps.puma"
   return (IsVarInExp (name, exp->OP1_EXP.OPND));

  case kDO_EXP:
# line 498 "TreeOps.puma"
   return IsVarInExp (name, exp->DO_EXP.BODY) + IsVarInExp (name, exp->DO_EXP.BODY);

  case kPERM_EXP:
# line 502 "TreeOps.puma"
   return IsVarInExp (name, exp->PERM_EXP.VAL);

  case kARRAY_EXP:
# line 506 "TreeOps.puma"
   return IsVarInExp (name, exp->ARRAY_EXP.ELEMENTS);

  case kTYPE_EXP:
# line 510 "TreeOps.puma"
   return IsVarInExp (name, exp->TYPE_EXP.ELEMENTS);

  case kBOUND_EXP:
# line 514 "TreeOps.puma"
   return 0;

  case kRANK_EXP:
# line 518 "TreeOps.puma"
   return 0;

  case kFUNC_CALL_EXP:
# line 522 "TreeOps.puma"
   return IsVarInExp (name, exp->FUNC_CALL_EXP.FUNC_PARAMS);

  case kBTP_LIST:
# line 526 "TreeOps.puma"
   return (IsVarInExp (name, exp->BTP_LIST.Elem) + IsVarInExp (name, exp->BTP_LIST.Next));

  case kBTP_EMPTY:
# line 530 "TreeOps.puma"
   return 0;

  case kVAR_PARAM:
# line 534 "TreeOps.puma"
   return (IsVarInExp (name, exp->VAR_PARAM.V));

  case kNO_PARAM:
# line 538 "TreeOps.puma"
   return 0;

  case kFUNC_PARAM:
# line 542 "TreeOps.puma"
   return 0;

  case kPROC_PARAM:
# line 546 "TreeOps.puma"
   return 0;

  }

# line 550 "TreeOps.puma"
  {
# line 551 "TreeOps.puma"
   failure_protocol (MODULE, "IsVarInExp", exp);
  }
   return 0;

}

bool IsForallLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
# line 563 "TreeOps.puma"
   return true;

  }
  return false;
}

bool IsIndepLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 568 "TreeOps.puma"
   return true;

  }
  }
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_DEP_INFO->Kind == kINDEP_INFO) {
# line 571 "TreeOps.puma"
   return true;

  }
  }
  return false;
}

bool IsIndepDoLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 576 "TreeOps.puma"
   return true;

  }
  }
  return false;
}

int GetLayout
# if defined __STDC__ | defined __cplusplus
(register bool is_f77, register int model)
# else
(is_f77, model)
 register bool is_f77;
 register int model;
# endif
{
# line 587 "TreeOps.puma"
  {
# line 589 "TreeOps.puma"
   if (! ((! is_f77))) goto yyL1;
  {
# line 590 "TreeOps.puma"
   if (! ((model == HPF_SERIAL))) goto yyL1;
  }
  }
   return kHPF_SERIAL_LAYOUT;
yyL1:;

# line 595 "TreeOps.puma"
  {
# line 597 "TreeOps.puma"
   if (! ((! is_f77))) goto yyL2;
  {
# line 598 "TreeOps.puma"
   if (! ((model == HPF_LOCAL))) goto yyL2;
  }
  }
   return kHPF_LOCAL_LAYOUT;
yyL2:;

# line 603 "TreeOps.puma"
  {
# line 605 "TreeOps.puma"
   if (! ((! is_f77))) goto yyL3;
  }
   return kHPF_GLOBAL_LAYOUT;
yyL3:;

# line 612 "TreeOps.puma"
  {
# line 614 "TreeOps.puma"
   if (! ((model == HPF_LOCAL))) goto yyL4;
  }
   return kF77_LOCAL_LAYOUT;
yyL4:;

# line 620 "TreeOps.puma"
   return kF77_SERIAL_LAYOUT;

}

void BeginTreeOps ()
{
}

void CloseTreeOps ()
{
}
