# include "Tree.inc"

typedef tTree * yyPtrtTree;

FILE * yyf;

void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kCOMP_UNIT:
yyMark (yyt->COMP_UNIT.COMP_ELEMENTS);
yyt = yyt->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_LIST:
yyMark (yyt->UNIT_LIST.Elem);
yyt = yyt->UNIT_LIST.Next; break;
case kMODULE_DECL:
yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL:
yyMark (yyt->PROGRAM_DECL.FORMALS);
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL:
yyMark (yyt->PROC_DECL.FORMALS);
yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL:
yyMark (yyt->FUNC_DECL.FORMALS);
yyMark (yyt->FUNC_DECL.FUNC_BODY);
yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL:
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE:
yyMark (yyt->INTERFACE.SPEC);
yyt = yyt->INTERFACE.ITEMS; break;
case kBODY_NODE:
yyMark (yyt->BODY_NODE.DECLS);
yyMark (yyt->BODY_NODE.STATS);
yyt = yyt->BODY_NODE.INTERNALS; break;
case kINTEGER_TYPE:
yyt = yyt->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE:
yyt = yyt->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE:
yyt = yyt->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE:
yyt = yyt->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE:
yyt = yyt->STRING_TYPE.LENGTH; break;
case kTYPE_ID:
yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE:
yyMark (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE:
yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE:
yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC:
yyt = yyt->SHAPE_SPEC.Overlap; break;
case kEXPLICIT_SHAPE:
yyMark (yyt->EXPLICIT_SHAPE.Overlap);
yyMark (yyt->EXPLICIT_SHAPE.LOWER);
yyt = yyt->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE:
yyMark (yyt->ASSUMED_SHAPE.Overlap);
yyt = yyt->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE:
yyt = yyt->DEFERRED_SHAPE.Overlap; break;
case kASSUMED_SIZE:
yyMark (yyt->ASSUMED_SIZE.Overlap);
yyt = yyt->ASSUMED_SIZE.LOWER; break;
case kSHAPE_LIST:
yyMark (yyt->SHAPE_LIST.Elem);
yyt = yyt->SHAPE_LIST.Next; break;
case kTYPE_DECL:
yyt = yyt->TYPE_DECL.VAL; break;
case kENTITY_DECL:
yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL:
yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL:
yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL:
yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL:
yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL:
yyt = yyt->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL:
yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL:
yyMark (yyt->SUB_PROCS_DECL.TOP);
yyt = yyt->SUB_PROCS_DECL.DIMENSIONS; break;
case kRANGE_DECL:
yyt = yyt->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL:
yyMark (yyt->STMT_FUNC_DECL.FORMALS);
yyMark (yyt->STMT_FUNC_DECL.RESULT_TYPE);
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL:
yyMark (yyt->INTERFACE_DECL.SPEC);
yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL:
yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kIMPLICIT_DECL:
yyt = yyt->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL:
yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL:
yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL:
yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL:
yyMark (yyt->DATA_DECL.VARS);
yyt = yyt->DATA_DECL.VALS; break;
case kFORMAT_DECL:
yyt = yyt->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL:
yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL:
yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL:
yyt = yyt->TYPESPEC_DECL.VAL; break;
case kPARAMETER_DECL:
yyt = yyt->PARAMETER_DECL.VAL; break;
case kDISTRIBUTE_DECL:
yyMark (yyt->DISTRIBUTE_DECL.DISTRIBUTION);
yyt = yyt->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL:
yyMark (yyt->ALIGN_DECL.ALIGN_SOURCE);
yyt = yyt->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL:
yyt = yyt->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL:
yyt = yyt->OVERLAP_DECL.OVERLAPS; break;
case kSELECT_DECL:
yyt = yyt->SELECT_DECL.SELECTIONS; break;
case kDECL_LIST:
yyMark (yyt->DECL_LIST.Elem);
yyt = yyt->DECL_LIST.Next; break;
case kRANGE_LIST:
yyMark (yyt->RANGE_LIST.Elem);
yyt = yyt->RANGE_LIST.Next; break;
case kSELECT_LIST:
yyMark (yyt->SELECT_LIST.Elem);
yyt = yyt->SELECT_LIST.Next; break;
case kNODE_DISTRIBUTION:
yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_LIST:
yyMark (yyt->DIST_LIST.Elem);
yyt = yyt->DIST_LIST.Next; break;
case kBLOCK_DISTRIBUTION:
yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION:
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION:
yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION:
yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION:
yyMark (yyt->ARBITRARY_DISTRIBUTION.SIZE);
yyMark (yyt->ARBITRARY_DISTRIBUTION.LENGTH);
yyt = yyt->ARBITRARY_DISTRIBUTION.MAP; break;
case kPROCESSOR_ARRAY:
yyt = yyt->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET:
yyMark (yyt->PROCESSOR_SUBSET.SUBTOP);
yyMark (yyt->PROCESSOR_SUBSET.FULLTOP);
yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC:
yyMark (yyt->ALIGN_SPEC.TEMPNAME);
yyt = yyt->ALIGN_SPEC.SUBSCRIPTS; break;
case kOP_GENERIC_SPEC:
yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kACF_LIST:
yyMark (yyt->ACF_LIST.Elem);
yyt = yyt->ACF_LIST.Next; break;
case kACF_BASIC:
yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF:
yyMark (yyt->ACF_IF.IF_EXP);
yyMark (yyt->ACF_IF.THEN_PART);
yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE:
yyMark (yyt->ACF_WHERE.WHERE_EXP);
yyMark (yyt->ACF_WHERE.TRUE_PART);
yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_CASE:
yyMark (yyt->ACF_CASE.CASE_EXP);
yyt = yyt->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE:
yyMark (yyt->ACF_WHILE.WHILE_EXP);
yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT:
yyMark (yyt->ACF_REPEAT.REPEAT_BODY);
yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP:
yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO:
yyMark (yyt->ACF_DO.DO_ID);
yyMark (yyt->ACF_DO.DO_RANGE);
yyMark (yyt->ACF_DO.DO_BODY);
yyMark (yyt->ACF_DO.DO_DEP_INFO);
yyt = yyt->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL:
yyMark (yyt->ACF_FORALL.FORALL_ID);
yyMark (yyt->ACF_FORALL.FORALL_RANGE);
yyMark (yyt->ACF_FORALL.FORALL_BODY);
yyMark (yyt->ACF_FORALL.FORALL_DEP_INFO);
yyt = yyt->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH:
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY:
yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME:
yyMark (yyt->ACF_HOME.HOME_VAR);
yyt = yyt->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT:
yyMark (yyt->ACF_RESIDENT.RESIDENT_VAR);
yyt = yyt->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW:
yyMark (yyt->ACF_NEW.NEW_VAR);
yyt = yyt->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION:
yyMark (yyt->ACF_REDUCTION.REDUCTION_VAR);
yyMark (yyt->ACF_REDUCTION.REDUCTION_LVAR);
yyMark (yyt->ACF_REDUCTION.REDUCTION_FUNC);
yyt = yyt->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION:
yyt = yyt->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL:
yyMark (yyt->ACF_PARALLEL.REDUCTION_VARS);
yyMark (yyt->ACF_PARALLEL.SHARED_VARS);
yyMark (yyt->ACF_PARALLEL.LOCAL_VARS);
yyt = yyt->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL:
yyt = yyt->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON:
yyMark (yyt->ACF_ON.ON_HOME);
yyMark (yyt->ACF_ON.ON_SPECS);
yyt = yyt->ACF_ON.ON_BODY; break;
case kACF_RM_READ:
yyMark (yyt->ACF_RM_READ.LOCAL_VAR);
yyt = yyt->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE:
yyMark (yyt->ACF_RM_WRITE.REMOTE_VAR);
yyt = yyt->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE:
yyt = yyt->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER:
yyt = yyt->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE:
yyt = yyt->ACF_UPDATE.OVERLAP_VAR; break;
case kON_VAR_CLAUSE:
yyt = yyt->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE:
yyt = yyt->ON_PROC_CLAUSE.ON_PROC; break;
case kON_LIST:
yyMark (yyt->ON_LIST.Elem);
yyt = yyt->ON_LIST.Next; break;
case kON_SPEC:
yyt = yyt->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_LIST:
yyMark (yyt->SELECTED_ACF_LIST.Elem);
yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE:
yyMark (yyt->SELECTED_ACF_NODE.SELECT_LIST);
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kASSIGN_STMT:
yyMark (yyt->ASSIGN_STMT.ASSIGN_VAR);
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT:
yyMark (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT:
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT:
yyMark (yyt->CALL_STMT.CALL_ID);
yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT:
yyMark (yyt->IO_STMT.ID);
yyMark (yyt->IO_STMT.IO_SPECS);
yyt = yyt->IO_STMT.IO_ITEMS; break;
case kASS_GOTO_STMT:
yyMark (yyt->ASS_GOTO_STMT.GOTO_VAR);
yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT:
yyMark (yyt->COMP_GOTO_STMT.GOTO_LABELS);
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT:
yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT:
yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT:
yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kSTOP_STMT:
yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT:
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT:
yyMark (yyt->INHERIT_DSP_STMT.VAR);
yyt = yyt->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT:
yyMark (yyt->CREATE_DSP_STMT.VAR);
yyt = yyt->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT:
yyt = yyt->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT:
yyMark (yyt->ALLOCATE_STMT.PARAMS);
yyt = yyt->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT:
yyMark (yyt->DEALLOCATE_STMT.PARAMS);
yyt = yyt->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT:
yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT:
yyMark (yyt->REDUCE_STMT.RED_FUNC);
yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT:
yyMark (yyt->MOVE_STMT.TARGET);
yyMark (yyt->MOVE_STMT.SOURCE);
yyt = yyt->MOVE_STMT.MASK; break;
case kSCATTER_STMT:
yyMark (yyt->SCATTER_STMT.ARRAY);
yyMark (yyt->SCATTER_STMT.BASE);
yyMark (yyt->SCATTER_STMT.INDEXES);
yyt = yyt->SCATTER_STMT.MASK; break;
case kREALIGN_STMT:
yyMark (yyt->REALIGN_STMT.ALIGNEE);
yyMark (yyt->REALIGN_STMT.ALIGN_SOURCE);
yyt = yyt->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT:
yyMark (yyt->REDISTRIBUTE_STMT.DISTRIBUTEE);
yyMark (yyt->REDISTRIBUTE_STMT.DISTRIBUTION);
yyt = yyt->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET:
yyMark (yyt->REG_SHADOW_GET.SHADOW_VAR);
yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT:
yyMark (yyt->REG_SHADOW_PUT.SHADOW_VAR);
yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET:
yyMark (yyt->REG_SHADOW_SET.SHADOW_VAR);
yyMark (yyt->REG_SHADOW_SET.SHADOW_SIZE);
yyt = yyt->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE:
yyMark (yyt->IND_SHADOW_CREATE.SHADOW_VAR);
yyMark (yyt->IND_SHADOW_CREATE.INDEX_VAR);
yyMark (yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR);
yyt = yyt->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE:
yyt = yyt->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET:
yyt = yyt->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT:
yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET:
yyMark (yyt->IND_SHADOW_SET.SHADOW_VAR);
yyt = yyt->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT:
yyMark (yyt->BROADCAST_STMT.ELEMS);
yyMark (yyt->BROADCAST_STMT.OWNER_TOP);
yyt = yyt->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT:
yyMark (yyt->REDUCTION_STMT.REDFUNC);
yyMark (yyt->REDUCTION_STMT.ELEMS);
yyMark (yyt->REDUCTION_STMT.RED_TOP);
yyt = yyt->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT:
yyt = yyt->DIRTY_STMT.ELEMS; break;
case kLABEL_LIST:
yyt = yyt->LABEL_LIST.Next; break;
case kCONST_EXP:
yyt = yyt->CONST_EXP.C; break;
case kOP_EXP:
yyMark (yyt->OP_EXP.EXP_OP);
yyMark (yyt->OP_EXP.OPND1);
yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP:
yyMark (yyt->OP1_EXP.EXP_OP1);
yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP:
yyMark (yyt->SLICE_EXP.START);
yyMark (yyt->SLICE_EXP.STOP);
yyt = yyt->SLICE_EXP.INC; break;
case kVAR_EXP:
yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP:
yyMark (yyt->FUNC_CALL_EXP.FUNC_ID);
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP:
yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP:
yyMark (yyt->DO_EXP.DO_ID);
yyMark (yyt->DO_EXP.RANGE);
yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP:
yyMark (yyt->TYPE_EXP.ID);
yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP:
yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP:
yyt = yyt->PERM_EXP.VAL; break;
case kBOUND_EXP:
yyt = yyt->BOUND_EXP.VAR; break;
case kBTE_LIST:
yyMark (yyt->BTE_LIST.Elem);
yyt = yyt->BTE_LIST.Next; break;
case kUSED_VAR:
yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR:
yyMark (yyt->INDEXED_VAR.IND_VAR);
yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR:
yyMark (yyt->SUBSTRING_VAR.IND_VAR);
yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR:
yyMark (yyt->SELECTED_VAR.SELEC_VAR);
yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR:
yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR:
yyt = yyt->PERM_VAR.VAL; break;
case kADDR:
yyt = yyt->ADDR.E; break;
case kDO_VAR:
yyMark (yyt->DO_VAR.DO_ID);
yyMark (yyt->DO_VAR.RANGE);
yyt = yyt->DO_VAR.BODY; break;
case kREMOTE_VAR:
yyt = yyt->REMOTE_VAR.VAR; break;
case kBTV_LIST:
yyMark (yyt->BTV_LIST.Elem);
yyt = yyt->BTV_LIST.Next; break;
case kVAR_PARAM:
yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM:
yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM:
yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM:
yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM:
yyt = yyt->FUNC_PARAM.F; break;
case kBTP_LIST:
yyMark (yyt->BTP_LIST.Elem);
yyt = yyt->BTP_LIST.Next; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tTree yyTreeStore [yyInitTreeStoreSize];
tTree * yyTreeStorePtr = yyTreeStore;
int yyLabelCount;
short yyRecursionLevel = 0;

Tree_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tTree));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteTree ();

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static void yyWriteAdr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree) (void) fputs ("NoTree", yyf);
 else yyWriteHex ((unsigned char *) & yyt, sizeof (yyt));
 yyWriteNl ();
}

static void yWriteNodeCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("COMP_ELEMENTS"); yyWriteAdr (yyt->COMP_UNIT.COMP_ELEMENTS);
 yyWriteSelector ("USED_ELEMENTS"); yyWriteAdr (yyt->COMP_UNIT.USED_ELEMENTS);
}

static void yWriteNodeUNIT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->UNIT_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->UNIT_LIST.Next);
}

static void yWriteNodeUNIT_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->UNIT_NODE.Ident) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->UNIT_NODE.Line) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->UNIT_NODE.Object) yyWriteNl ();
}

static void yWriteNodeMODULE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("MODULE_BODY"); yyWriteAdr (yyt->MODULE_DECL.MODULE_BODY);
}

static void yWriteNodePROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->PROGRAM_DECL.FORMALS);
 yyWriteSelector ("PROGRAM_BODY"); yyWriteAdr (yyt->PROGRAM_DECL.PROGRAM_BODY);
}

static void yWriteNodePROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->PROC_DECL.FORMALS);
 yyWriteSelector ("PROC_BODY"); yyWriteAdr (yyt->PROC_DECL.PROC_BODY);
 yyWriteSelector ("IsRecursive"); writebool (yyt->PROC_DECL.IsRecursive) yyWriteNl ();
 yyWriteSelector ("IsPure"); writebool (yyt->PROC_DECL.IsPure) yyWriteNl ();
 yyWriteSelector ("HPFExtrinsic"); writetIdent (yyt->PROC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteNodeFUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->FUNC_DECL.FORMALS);
 yyWriteSelector ("FUNC_BODY"); yyWriteAdr (yyt->FUNC_DECL.FUNC_BODY);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->FUNC_DECL.RESULT_TYPE);
 yyWriteSelector ("RESULT_ID"); writetIdent (yyt->FUNC_DECL.RESULT_ID) yyWriteNl ();
 yyWriteSelector ("IsRecursive"); writebool (yyt->FUNC_DECL.IsRecursive) yyWriteNl ();
 yyWriteSelector ("IsPure"); writebool (yyt->FUNC_DECL.IsPure) yyWriteNl ();
 yyWriteSelector ("HPFExtrinsic"); writetIdent (yyt->FUNC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteNodeMODULE_PROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
}

static void yWriteNodeBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("DATA_BODY"); yyWriteAdr (yyt->BLOCK_DATA_DECL.DATA_BODY);
}

static void yWriteNodeINTERFACE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("SPEC"); yyWriteAdr (yyt->INTERFACE.SPEC);
 yyWriteSelector ("ITEMS"); yyWriteAdr (yyt->INTERFACE.ITEMS);
}

static void yWriteNodeBODY_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DECLS"); yyWriteAdr (yyt->BODY_NODE.DECLS);
 yyWriteSelector ("STATS"); yyWriteAdr (yyt->BODY_NODE.STATS);
 yyWriteSelector ("INTERNALS"); yyWriteAdr (yyt->BODY_NODE.INTERNALS);
}

static void yWriteNodeINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->INTEGER_TYPE.SIZE);
}

static void yWriteNodeREAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->REAL_TYPE.SIZE);
}

static void yWriteNodeBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->BOOLEAN_TYPE.SIZE);
}

static void yWriteNodeCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->COMPLEX_TYPE.SIZE);
}

static void yWriteNodeSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LENGTH"); yyWriteAdr (yyt->STRING_TYPE.LENGTH);
}

static void yWriteNodeTYPE_ID
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->TYPE_ID.ID);
}

static void yWriteNodeARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY_INDEX_TYPES"); yyWriteAdr (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
 yyWriteSelector ("ARRAY_COMP_TYPE"); yyWriteAdr (yyt->ARRAY_TYPE.ARRAY_COMP_TYPE);
}

static void yWriteNodeRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->RECORD_TYPE.Name) yyWriteNl ();
 yyWriteSelector ("COMPONENTS"); yyWriteAdr (yyt->RECORD_TYPE.COMPONENTS);
}

static void yWriteNodePOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PTR_COMP"); yyWriteAdr (yyt->POINTER_TYPE.PTR_COMP);
}

static void yWriteNodeSHAPE_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Overlap"); yyWriteAdr (yyt->SHAPE_SPEC.Overlap);
}

static void yWriteNodeEXPLICIT_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->EXPLICIT_SHAPE.LOWER);
 yyWriteSelector ("UPPER"); yyWriteAdr (yyt->EXPLICIT_SHAPE.UPPER);
}

static void yWriteNodeASSUMED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->ASSUMED_SHAPE.LOWER);
}

static void yWriteNodeDEFERRED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
}

static void yWriteNodeASSUMED_SIZE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->ASSUMED_SIZE.LOWER);
}

static void yWriteNodeSHAPE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SHAPE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SHAPE_LIST.Next);
}

static void yWriteNodeDECL_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->DECL_NODE.Ident) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->DECL_NODE.Line) yyWriteNl ();
}

static void yWriteNodeTYPE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->TYPE_DECL.VAL);
}

static void yWriteNodeNAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeRENAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("oldname"); writetIdent (yyt->RENAME_DECL.oldname) yyWriteNl ();
}

static void yWriteNodeENTITY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("ATTRIBUTES"); yyWriteAdr (yyt->ENTITY_DECL.ATTRIBUTES);
}

static void yWriteNodeVAR_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAR_DECL.VAL);
}

static void yWriteNodeCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("IDS"); yyWriteAdr (yyt->COMMON_DECL.IDS);
}

static void yWriteNodeNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("IDS"); yyWriteAdr (yyt->NAMELIST_DECL.IDS);
}

static void yWriteNodeTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->TEMPLATE_DECL.DIMENSIONS);
}

static void yWriteNodeRAGGED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->RAGGED_DECL.DIMENSIONS);
}

static void yWriteNodePROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->PROCESSORS_DECL.DIMENSIONS);
}

static void yWriteNodeSUB_PROCS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("TOP"); yyWriteAdr (yyt->SUB_PROCS_DECL.TOP);
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->SUB_PROCS_DECL.DIMENSIONS);
}

static void yWriteNodeINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeRANGE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("RANGES"); yyWriteAdr (yyt->RANGE_DECL.RANGES);
}

static void yWriteNodeSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->STMT_FUNC_DECL.FORMALS);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->STMT_FUNC_DECL.RESULT_TYPE);
 yyWriteSelector ("FFUNC_BODY"); yyWriteAdr (yyt->STMT_FUNC_DECL.FFUNC_BODY);
}

static void yWriteNodeINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("SPEC"); yyWriteAdr (yyt->INTERFACE_DECL.SPEC);
 yyWriteSelector ("ITEMS"); yyWriteAdr (yyt->INTERFACE_DECL.ITEMS);
}

static void yWriteNodeVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAR_PARAM_DECL.VAL);
}

static void yWriteNodeRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("first"); writetIdent (yyt->IMPLICIT_DECL.first) yyWriteNl ();
 yyWriteSelector ("last"); writetIdent (yyt->IMPLICIT_DECL.last) yyWriteNl ();
 yyWriteSelector ("TYPE"); yyWriteAdr (yyt->IMPLICIT_DECL.TYPE);
}

static void yWriteNodeUSE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("use"); writetIdent (yyt->USE_DECL.use) yyWriteNl ();
 yyWriteSelector ("RENAMINGS"); yyWriteAdr (yyt->USE_DECL.RENAMINGS);
}

static void yWriteNodeONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("use"); writetIdent (yyt->ONLY_USE_DECL.use) yyWriteNl ();
 yyWriteSelector ("NAMES"); yyWriteAdr (yyt->ONLY_USE_DECL.NAMES);
}

static void yWriteNodeEQV_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VARS"); yyWriteAdr (yyt->EQV_DECL.VARS);
}

static void yWriteNodeDATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VARS"); yyWriteAdr (yyt->DATA_DECL.VARS);
 yyWriteSelector ("VALS"); yyWriteAdr (yyt->DATA_DECL.VALS);
}

static void yWriteNodeFORMAT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("label"); writeint (yyt->FORMAT_DECL.label) yyWriteNl ();
 yyWriteSelector ("FORMAT_PARAMS"); yyWriteAdr (yyt->FORMAT_DECL.FORMAT_PARAMS);
}

static void yWriteNodeDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("INDEXES"); yyWriteAdr (yyt->DIMENSION_DECL.INDEXES);
}

static void yWriteNodeINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->INIT_DATA_DECL.VAL);
}

static void yWriteNodeTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->TYPESPEC_DECL.VAL);
}

static void yWriteNodeALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeINTENT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("intent"); writeint (yyt->INTENT_DECL.intent) yyWriteNl ();
}

static void yWriteNodeINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("generic"); writetIdent (yyt->INTRINSIC_DECL.generic) yyWriteNl ();
 yyWriteSelector ("class"); writeint (yyt->INTRINSIC_DECL.class) yyWriteNl ();
 yyWriteSelector ("kind"); writeint (yyt->INTRINSIC_DECL.kind) yyWriteNl ();
}

static void yWriteNodeOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePOINTER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSAVE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTARGET_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PARAMETER_DECL.VAL);
}

static void yWriteNodePUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DISTRIBUTION"); yyWriteAdr (yyt->DISTRIBUTE_DECL.DISTRIBUTION);
 yyWriteSelector ("TARGET"); yyWriteAdr (yyt->DISTRIBUTE_DECL.TARGET);
}

static void yWriteNodeALIGN_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("ALIGN_SOURCE"); yyWriteAdr (yyt->ALIGN_DECL.ALIGN_SOURCE);
 yyWriteSelector ("ALIGN_TARGET"); yyWriteAdr (yyt->ALIGN_DECL.ALIGN_TARGET);
}

static void yWriteNodeMAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("MAP_TARGET"); yyWriteAdr (yyt->MAP_DECL.MAP_TARGET);
}

static void yWriteNodeOVERLAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("OVERLAPS"); yyWriteAdr (yyt->OVERLAP_DECL.OVERLAPS);
}

static void yWriteNodeSHARED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writeint (yyt->SHARED_DECL.kind) yyWriteNl ();
}

static void yWriteNodeDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTRACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTREE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSELECT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("SELECTIONS"); yyWriteAdr (yyt->SELECT_DECL.SELECTIONS);
}

static void yWriteNodeHPF_SEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeLAYOUT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writetStringRef (yyt->LAYOUT_DECL.kind) yyWriteNl ();
}

static void yWriteNodePASS_BY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writetStringRef (yyt->PASS_BY_DECL.kind) yyWriteNl ();
}

static void yWriteNodeMAP_TO_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writetStringRef (yyt->MAP_TO_DECL.kind) yyWriteNl ();
}

static void yWriteNodeDECL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->DECL_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->DECL_LIST.Next);
}

static void yWriteNodeRANGE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->RANGE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->RANGE_LIST.Next);
}

static void yWriteNodeSELECT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SELECT_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SELECT_LIST.Next);
}

static void yWriteNodeSELECT_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("selector"); writeint (yyt->SELECT_SPEC.selector) yyWriteNl ();
}

static void yWriteNodeDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("is_descriptive"); writeint (yyt->DISTRIBUTION_SPEC.is_descriptive) yyWriteNl ();
}

static void yWriteNodeANY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
}

static void yWriteNodeDEFAULT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
}

static void yWriteNodeREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
}

static void yWriteNodeNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
 yyWriteSelector ("MAPPING"); yyWriteAdr (yyt->NODE_DISTRIBUTION.MAPPING);
}

static void yWriteNodeDIST_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->DIST_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->DIST_LIST.Next);
}

static void yWriteNodeBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->BLOCK_DISTRIBUTION.SIZE);
}

static void yWriteNodeCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->CYCLIC_DISTRIBUTION.SIZE);
}

static void yWriteNodeGEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->GEN_BLOCK_DISTRIBUTION.ARRAY);
}

static void yWriteNodeINDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->INDIRECT_DISTRIBUTION.ARRAY);
}

static void yWriteNodeARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->ARBITRARY_DISTRIBUTION.SIZE);
 yyWriteSelector ("LENGTH"); yyWriteAdr (yyt->ARBITRARY_DISTRIBUTION.LENGTH);
 yyWriteSelector ("MAP"); yyWriteAdr (yyt->ARBITRARY_DISTRIBUTION.MAP);
}

static void yWriteNodePROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("TOPNAME"); yyWriteAdr (yyt->PROCESSOR_ARRAY.TOPNAME);
}

static void yWriteNodePROCESSOR_SUBSET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SUBTOP"); yyWriteAdr (yyt->PROCESSOR_SUBSET.SUBTOP);
 yyWriteSelector ("FULLTOP"); yyWriteAdr (yyt->PROCESSOR_SUBSET.FULLTOP);
 yyWriteSelector ("SUBSCRIPTS"); yyWriteAdr (yyt->PROCESSOR_SUBSET.SUBSCRIPTS);
}

static void yWriteNodeALIGN_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("is_descriptive"); writeint (yyt->ALIGN_SPEC.is_descriptive) yyWriteNl ();
 yyWriteSelector ("TEMPNAME"); yyWriteAdr (yyt->ALIGN_SPEC.TEMPNAME);
 yyWriteSelector ("SUBSCRIPTS"); yyWriteAdr (yyt->ALIGN_SPEC.SUBSCRIPTS);
}

static void yWriteNodeID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("name"); writetIdent (yyt->ID_GENERIC_SPEC.name) yyWriteNl ();
}

static void yWriteNodeOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("OPERATOR"); yyWriteAdr (yyt->OP_GENERIC_SPEC.OPERATOR);
}

static void yWriteNodeACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->ACF_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->ACF_LIST.Next);
}

static void yWriteNodeACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Label"); writeint (yyt->ACF_NODE.Label) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->ACF_NODE.Line) yyWriteNl ();
}

static void yWriteNodeACF_DUMMY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
}

static void yWriteNodeACF_BASIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("BASIC_STMT"); yyWriteAdr (yyt->ACF_BASIC.BASIC_STMT);
}

static void yWriteNodeACF_IF
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("IF_EXP"); yyWriteAdr (yyt->ACF_IF.IF_EXP);
 yyWriteSelector ("THEN_PART"); yyWriteAdr (yyt->ACF_IF.THEN_PART);
 yyWriteSelector ("ELSE_PART"); yyWriteAdr (yyt->ACF_IF.ELSE_PART);
}

static void yWriteNodeACF_WHERE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WHERE_EXP"); yyWriteAdr (yyt->ACF_WHERE.WHERE_EXP);
 yyWriteSelector ("TRUE_PART"); yyWriteAdr (yyt->ACF_WHERE.TRUE_PART);
 yyWriteSelector ("FALSE_PART"); yyWriteAdr (yyt->ACF_WHERE.FALSE_PART);
}

static void yWriteNodeACF_CASE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("CASE_EXP"); yyWriteAdr (yyt->ACF_CASE.CASE_EXP);
 yyWriteSelector ("CASE_ALTS"); yyWriteAdr (yyt->ACF_CASE.CASE_ALTS);
}

static void yWriteNodeACF_WHILE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WHILE_EXP"); yyWriteAdr (yyt->ACF_WHILE.WHILE_EXP);
 yyWriteSelector ("WHILE_BODY"); yyWriteAdr (yyt->ACF_WHILE.WHILE_BODY);
}

static void yWriteNodeACF_REPEAT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("REPEAT_BODY"); yyWriteAdr (yyt->ACF_REPEAT.REPEAT_BODY);
 yyWriteSelector ("REPEAT_EXP"); yyWriteAdr (yyt->ACF_REPEAT.REPEAT_EXP);
}

static void yWriteNodeACF_LOOP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("LOOP_BODY"); yyWriteAdr (yyt->ACF_LOOP.LOOP_BODY);
}

static void yWriteNodeACF_DO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->ACF_DO.DO_ID);
 yyWriteSelector ("DO_RANGE"); yyWriteAdr (yyt->ACF_DO.DO_RANGE);
 yyWriteSelector ("DO_BODY"); yyWriteAdr (yyt->ACF_DO.DO_BODY);
 yyWriteSelector ("DO_DEP_INFO"); yyWriteAdr (yyt->ACF_DO.DO_DEP_INFO);
 yyWriteSelector ("DO_HOME_INFO"); yyWriteAdr (yyt->ACF_DO.DO_HOME_INFO);
}

static void yWriteNodeACF_FORALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("FORALL_ID"); yyWriteAdr (yyt->ACF_FORALL.FORALL_ID);
 yyWriteSelector ("FORALL_RANGE"); yyWriteAdr (yyt->ACF_FORALL.FORALL_RANGE);
 yyWriteSelector ("FORALL_BODY"); yyWriteAdr (yyt->ACF_FORALL.FORALL_BODY);
 yyWriteSelector ("FORALL_DEP_INFO"); yyWriteAdr (yyt->ACF_FORALL.FORALL_DEP_INFO);
 yyWriteSelector ("FORALL_HOME_INFO"); yyWriteAdr (yyt->ACF_FORALL.FORALL_HOME_INFO);
}

static void yWriteNodeACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("FLOW_NODES"); yyWriteAdr (yyt->ACF_FLOW_GRAPH.FLOW_NODES);
}

static void yWriteNodeACF_ENTRY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ENTRY_DECL"); yyWriteAdr (yyt->ACF_ENTRY.ENTRY_DECL);
}

static void yWriteNodeACF_HOME
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("HOME_VAR"); yyWriteAdr (yyt->ACF_HOME.HOME_VAR);
 yyWriteSelector ("user_home"); writebool (yyt->ACF_HOME.user_home) yyWriteNl ();
 yyWriteSelector ("HOME_BODY"); yyWriteAdr (yyt->ACF_HOME.HOME_BODY);
}

static void yWriteNodeACF_RESIDENT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("RESIDENT_VAR"); yyWriteAdr (yyt->ACF_RESIDENT.RESIDENT_VAR);
 yyWriteSelector ("RESIDENT_BODY"); yyWriteAdr (yyt->ACF_RESIDENT.RESIDENT_BODY);
}

static void yWriteNodeACF_NEW
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("NEW_VAR"); yyWriteAdr (yyt->ACF_NEW.NEW_VAR);
 yyWriteSelector ("NEW_BODY"); yyWriteAdr (yyt->ACF_NEW.NEW_BODY);
}

static void yWriteNodeACF_REDUCTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("is_zero"); writebool (yyt->ACF_REDUCTION.is_zero) yyWriteNl ();
 yyWriteSelector ("REDUCTION_VAR"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_VAR);
 yyWriteSelector ("REDUCTION_LVAR"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_LVAR);
 yyWriteSelector ("REDUCTION_FUNC"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_FUNC);
 yyWriteSelector ("REDUCTION_BODY"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_BODY);
}

static void yWriteNodeACF_TASK_REGION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("task_flag"); writeint (yyt->ACF_TASK_REGION.task_flag) yyWriteNl ();
 yyWriteSelector ("TASK_BODY"); yyWriteAdr (yyt->ACF_TASK_REGION.TASK_BODY);
}

static void yWriteNodeACF_PARALLEL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("REDUCTION_VARS"); yyWriteAdr (yyt->ACF_PARALLEL.REDUCTION_VARS);
 yyWriteSelector ("SHARED_VARS"); yyWriteAdr (yyt->ACF_PARALLEL.SHARED_VARS);
 yyWriteSelector ("LOCAL_VARS"); yyWriteAdr (yyt->ACF_PARALLEL.LOCAL_VARS);
 yyWriteSelector ("PARALLEL_BODY"); yyWriteAdr (yyt->ACF_PARALLEL.PARALLEL_BODY);
}

static void yWriteNodeACF_CRITICAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("CRITICAL_BODY"); yyWriteAdr (yyt->ACF_CRITICAL.CRITICAL_BODY);
}

static void yWriteNodeACF_ON
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ON_HOME"); yyWriteAdr (yyt->ACF_ON.ON_HOME);
 yyWriteSelector ("ON_SPECS"); yyWriteAdr (yyt->ACF_ON.ON_SPECS);
 yyWriteSelector ("ON_BODY"); yyWriteAdr (yyt->ACF_ON.ON_BODY);
}

static void yWriteNodeACF_RM_READ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("LOCAL_VAR"); yyWriteAdr (yyt->ACF_RM_READ.LOCAL_VAR);
 yyWriteSelector ("REMOTE_VAR"); yyWriteAdr (yyt->ACF_RM_READ.REMOTE_VAR);
}

static void yWriteNodeACF_RM_WRITE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("op"); writeint (yyt->ACF_RM_WRITE.op) yyWriteNl ();
 yyWriteSelector ("REMOTE_VAR"); yyWriteAdr (yyt->ACF_RM_WRITE.REMOTE_VAR);
 yyWriteSelector ("LOCAL_DATA"); yyWriteAdr (yyt->ACF_RM_WRITE.LOCAL_DATA);
}

static void yWriteNodeACF_MOVE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("MOVE_STMT"); yyWriteAdr (yyt->ACF_MOVE.MOVE_STMT);
}

static void yWriteNodeACF_BARRIER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("BARRIER_VARS"); yyWriteAdr (yyt->ACF_BARRIER.BARRIER_VARS);
}

static void yWriteNodeACF_UPDATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("OVERLAP_VAR"); yyWriteAdr (yyt->ACF_UPDATE.OVERLAP_VAR);
}

static void yWriteNodeON_VAR_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ON_VAR"); yyWriteAdr (yyt->ON_VAR_CLAUSE.ON_VAR);
}

static void yWriteNodeON_PROC_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ON_PROC"); yyWriteAdr (yyt->ON_PROC_CLAUSE.ON_PROC);
}

static void yWriteNodeON_PROCS
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("topid"); writetObject (yyt->ON_PROCS.topid) yyWriteNl ();
}

static void yWriteNodeON_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("topid"); writetObject (yyt->ON_VAR.topid) yyWriteNl ();
 yyWriteSelector ("tempid"); writetObject (yyt->ON_VAR.tempid) yyWriteNl ();
 yyWriteSelector ("arrayid"); writetObject (yyt->ON_VAR.arrayid) yyWriteNl ();
}

static void yWriteNodeON_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->ON_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->ON_LIST.Next);
}

static void yWriteNodeON_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("top_dim"); writeint (yyt->ON_SPEC.top_dim) yyWriteNl ();
 yyWriteSelector ("temp_dim"); writeint (yyt->ON_SPEC.temp_dim) yyWriteNl ();
 yyWriteSelector ("array_dim"); writeint (yyt->ON_SPEC.array_dim) yyWriteNl ();
 yyWriteSelector ("ON_VAL"); yyWriteAdr (yyt->ON_SPEC.ON_VAL);
}

static void yWriteNodeSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SELECTED_ACF_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SELECTED_ACF_LIST.Next);
}

static void yWriteNodeSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELECT_LIST"); yyWriteAdr (yyt->SELECTED_ACF_NODE.SELECT_LIST);
 yyWriteSelector ("SELECT_ACFS"); yyWriteAdr (yyt->SELECTED_ACF_NODE.SELECT_ACFS);
}

static void yWriteNodeASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_VAR"); yyWriteAdr (yyt->ASSIGN_STMT.ASSIGN_VAR);
 yyWriteSelector ("ASSIGN_EXP"); yyWriteAdr (yyt->ASSIGN_STMT.ASSIGN_EXP);
}

static void yWriteNodePTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_VAR"); yyWriteAdr (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
 yyWriteSelector ("ASSIGN_EXP"); yyWriteAdr (yyt->PTR_ASSIGN_STMT.ASSIGN_EXP);
}

static void yWriteNodeLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("assign_label"); writeint (yyt->LABEL_ASSIGN_STMT.assign_label) yyWriteNl ();
 yyWriteSelector ("LABEL_VAR"); yyWriteAdr (yyt->LABEL_ASSIGN_STMT.LABEL_VAR);
}

static void yWriteNodeCALL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("CALL_ID"); yyWriteAdr (yyt->CALL_STMT.CALL_ID);
 yyWriteSelector ("CALL_PARAMS"); yyWriteAdr (yyt->CALL_STMT.CALL_PARAMS);
}

static void yWriteNodeIO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->IO_STMT.ID);
 yyWriteSelector ("IO_SPECS"); yyWriteAdr (yyt->IO_STMT.IO_SPECS);
 yyWriteSelector ("IO_ITEMS"); yyWriteAdr (yyt->IO_STMT.IO_ITEMS);
}

static void yWriteNodeGOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_LABEL"); writeint (yyt->GOTO_STMT.GOTO_LABEL) yyWriteNl ();
}

static void yWriteNodeASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_VAR"); yyWriteAdr (yyt->ASS_GOTO_STMT.GOTO_VAR);
 yyWriteSelector ("LABELS"); yyWriteAdr (yyt->ASS_GOTO_STMT.LABELS);
}

static void yWriteNodeCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_LABELS"); yyWriteAdr (yyt->COMP_GOTO_STMT.GOTO_LABELS);
 yyWriteSelector ("GOTO_EXP"); yyWriteAdr (yyt->COMP_GOTO_STMT.GOTO_EXP);
}

static void yWriteNodeCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IF_EXP"); yyWriteAdr (yyt->COMP_IF_STMT.IF_EXP);
 yyWriteSelector ("IF_LT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_LT_LABEL) yyWriteNl ();
 yyWriteSelector ("IF_EQ_LABEL"); writeint (yyt->COMP_IF_STMT.IF_EQ_LABEL) yyWriteNl ();
 yyWriteSelector ("IF_GT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_GT_LABEL) yyWriteNl ();
}

static void yWriteNodeRETURN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("RETURN_EXP"); yyWriteAdr (yyt->RETURN_STMT.RETURN_EXP);
}

static void yWriteNodePAUSE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PAUSE_CONST"); yyWriteAdr (yyt->PAUSE_STMT.PAUSE_CONST);
}

static void yWriteNodeEXIT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("loopid"); writetIdent (yyt->EXIT_STMT.loopid) yyWriteNl ();
}

static void yWriteNodeCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("loopid"); writetIdent (yyt->CYCLE_STMT.loopid) yyWriteNl ();
}

static void yWriteNodeSTOP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("STOP_CONST"); yyWriteAdr (yyt->STOP_STMT.STOP_CONST);
}

static void yWriteNodeFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FORMAT_PARAMS"); yyWriteAdr (yyt->FORMAT_STMT.FORMAT_PARAMS);
}

static void yWriteNodeINHERIT_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->INHERIT_DSP_STMT.VAR);
 yyWriteSelector ("SHAPE"); yyWriteAdr (yyt->INHERIT_DSP_STMT.SHAPE);
 yyWriteSelector ("flag"); writeint (yyt->INHERIT_DSP_STMT.flag) yyWriteNl ();
 yyWriteSelector ("safety"); writeint (yyt->INHERIT_DSP_STMT.safety) yyWriteNl ();
}

static void yWriteNodeCREATE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->CREATE_DSP_STMT.VAR);
 yyWriteSelector ("SHAPE"); yyWriteAdr (yyt->CREATE_DSP_STMT.SHAPE);
 yyWriteSelector ("flag"); writeint (yyt->CREATE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteNodeFREE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->FREE_DSP_STMT.VAR);
 yyWriteSelector ("flag"); writeint (yyt->FREE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteNodeALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->ALLOCATE_STMT.PARAMS);
 yyWriteSelector ("STATUS"); yyWriteAdr (yyt->ALLOCATE_STMT.STATUS);
}

static void yWriteNodeDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->DEALLOCATE_STMT.PARAMS);
 yyWriteSelector ("STATUS"); yyWriteAdr (yyt->DEALLOCATE_STMT.STATUS);
}

static void yWriteNodeNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->NULLIFY_STMT.PARAMS);
}

static void yWriteNodeREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("RED_FUNC"); yyWriteAdr (yyt->REDUCE_STMT.RED_FUNC);
 yyWriteSelector ("RED_PARAMS"); yyWriteAdr (yyt->REDUCE_STMT.RED_PARAMS);
}

static void yWriteNodeMOVE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("TARGET"); yyWriteAdr (yyt->MOVE_STMT.TARGET);
 yyWriteSelector ("SOURCE"); yyWriteAdr (yyt->MOVE_STMT.SOURCE);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->MOVE_STMT.MASK);
}

static void yWriteNodeSCATTER_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("func"); writetIdent (yyt->SCATTER_STMT.func) yyWriteNl ();
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->SCATTER_STMT.ARRAY);
 yyWriteSelector ("BASE"); yyWriteAdr (yyt->SCATTER_STMT.BASE);
 yyWriteSelector ("INDEXES"); yyWriteAdr (yyt->SCATTER_STMT.INDEXES);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->SCATTER_STMT.MASK);
}

static void yWriteNodeREALIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ALIGNEE"); yyWriteAdr (yyt->REALIGN_STMT.ALIGNEE);
 yyWriteSelector ("ALIGN_SOURCE"); yyWriteAdr (yyt->REALIGN_STMT.ALIGN_SOURCE);
 yyWriteSelector ("ALIGN_TARGET"); yyWriteAdr (yyt->REALIGN_STMT.ALIGN_TARGET);
 yyWriteSelector ("distribution"); writetDefinitions (yyt->REALIGN_STMT.distribution) yyWriteNl ();
}

static void yWriteNodeREDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DISTRIBUTEE"); yyWriteAdr (yyt->REDISTRIBUTE_STMT.DISTRIBUTEE);
 yyWriteSelector ("DISTRIBUTION"); yyWriteAdr (yyt->REDISTRIBUTE_STMT.DISTRIBUTION);
 yyWriteSelector ("TARGET"); yyWriteAdr (yyt->REDISTRIBUTE_STMT.TARGET);
 yyWriteSelector ("distribution"); writetDefinitions (yyt->REDISTRIBUTE_STMT.distribution) yyWriteNl ();
}

static void yWriteNodeREG_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->REG_SHADOW_GET.SHADOW_VAR);
 yyWriteSelector ("SHADOW_SIZE"); yyWriteAdr (yyt->REG_SHADOW_GET.SHADOW_SIZE);
}

static void yWriteNodeREG_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("op"); writeint (yyt->REG_SHADOW_PUT.op) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->REG_SHADOW_PUT.SHADOW_VAR);
 yyWriteSelector ("SHADOW_SIZE"); yyWriteAdr (yyt->REG_SHADOW_PUT.SHADOW_SIZE);
}

static void yWriteNodeREG_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->REG_SHADOW_SET.SHADOW_VAR);
 yyWriteSelector ("SHADOW_SIZE"); yyWriteAdr (yyt->REG_SHADOW_SET.SHADOW_SIZE);
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->REG_SHADOW_SET.VAL);
}

static void yWriteNodeIND_SHADOW_CREATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_CREATE.id) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_CREATE.SHADOW_VAR);
 yyWriteSelector ("INDEX_VAR"); yyWriteAdr (yyt->IND_SHADOW_CREATE.INDEX_VAR);
 yyWriteSelector ("TMP_INDEX_VAR"); yyWriteAdr (yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->IND_SHADOW_CREATE.MASK);
}

static void yWriteNodeIND_SHADOW_FREE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_FREE.id) yyWriteNl ();
 yyWriteSelector ("INDEX_VAR"); yyWriteAdr (yyt->IND_SHADOW_FREE.INDEX_VAR);
}

static void yWriteNodeIND_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_GET.id) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_GET.SHADOW_VAR);
}

static void yWriteNodeIND_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_PUT.id) yyWriteNl ();
 yyWriteSelector ("op"); writeint (yyt->IND_SHADOW_PUT.op) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_PUT.SHADOW_VAR);
}

static void yWriteNodeIND_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_SET.id) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_SET.SHADOW_VAR);
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->IND_SHADOW_SET.VAL);
}

static void yWriteNodeBROADCAST_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMS"); yyWriteAdr (yyt->BROADCAST_STMT.ELEMS);
 yyWriteSelector ("OWNER_TOP"); yyWriteAdr (yyt->BROADCAST_STMT.OWNER_TOP);
 yyWriteSelector ("OWNER_SPEC"); yyWriteAdr (yyt->BROADCAST_STMT.OWNER_SPEC);
}

static void yWriteNodeREDUCTION_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("REDFUNC"); yyWriteAdr (yyt->REDUCTION_STMT.REDFUNC);
 yyWriteSelector ("ELEMS"); yyWriteAdr (yyt->REDUCTION_STMT.ELEMS);
 yyWriteSelector ("RED_TOP"); yyWriteAdr (yyt->REDUCTION_STMT.RED_TOP);
 yyWriteSelector ("RED_SPEC"); yyWriteAdr (yyt->REDUCTION_STMT.RED_SPEC);
}

static void yWriteNodeDIRTY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMS"); yyWriteAdr (yyt->DIRTY_STMT.ELEMS);
}

static void yWriteNodeLABEL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); writeint (yyt->LABEL_LIST.Elem) yyWriteNl ();
 yyWriteSelector ("Next"); yyWriteAdr (yyt->LABEL_LIST.Next);
}

static void yWriteNodeOP_DEFINED
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("opname"); writetIdent (yyt->OP_DEFINED.opname) yyWriteNl ();
}

static void yWriteNodeCONST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("C"); yyWriteAdr (yyt->CONST_EXP.C);
}

static void yWriteNodeOP_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("EXP_OP"); yyWriteAdr (yyt->OP_EXP.EXP_OP);
 yyWriteSelector ("OPND1"); yyWriteAdr (yyt->OP_EXP.OPND1);
 yyWriteSelector ("OPND2"); yyWriteAdr (yyt->OP_EXP.OPND2);
}

static void yWriteNodeOP1_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("EXP_OP1"); yyWriteAdr (yyt->OP1_EXP.EXP_OP1);
 yyWriteSelector ("OPND"); yyWriteAdr (yyt->OP1_EXP.OPND);
}

static void yWriteNodeSLICE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("START"); yyWriteAdr (yyt->SLICE_EXP.START);
 yyWriteSelector ("STOP"); yyWriteAdr (yyt->SLICE_EXP.STOP);
 yyWriteSelector ("INC"); yyWriteAdr (yyt->SLICE_EXP.INC);
}

static void yWriteNodeVAR_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("V"); yyWriteAdr (yyt->VAR_EXP.V);
}

static void yWriteNodeFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FUNC_ID"); yyWriteAdr (yyt->FUNC_CALL_EXP.FUNC_ID);
 yyWriteSelector ("FUNC_PARAMS"); yyWriteAdr (yyt->FUNC_CALL_EXP.FUNC_PARAMS);
}

static void yWriteNodeNAMED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->NAMED_EXP.Name) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->NAMED_EXP.VAL);
}

static void yWriteNodeDO_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->DO_EXP.DO_ID);
 yyWriteSelector ("RANGE"); yyWriteAdr (yyt->DO_EXP.RANGE);
 yyWriteSelector ("BODY"); yyWriteAdr (yyt->DO_EXP.BODY);
}

static void yWriteNodeTYPE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->TYPE_EXP.ID);
 yyWriteSelector ("ELEMENTS"); yyWriteAdr (yyt->TYPE_EXP.ELEMENTS);
}

static void yWriteNodeARRAY_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMENTS"); yyWriteAdr (yyt->ARRAY_EXP.ELEMENTS);
}

static void yWriteNodePERM_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PERM_EXP.VAL);
 yyWriteSelector ("perm"); writePermutation (yyt->PERM_EXP.perm) yyWriteNl ();
}

static void yWriteNodeBOUND_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->BOUND_EXP.VAR);
 yyWriteSelector ("dim"); writeint (yyt->BOUND_EXP.dim) yyWriteNl ();
 yyWriteSelector ("kind"); writeint (yyt->BOUND_EXP.kind) yyWriteNl ();
 yyWriteSelector ("local"); writeint (yyt->BOUND_EXP.local) yyWriteNl ();
}

static void yWriteNodeRANK_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("kind"); writeint (yyt->RANK_EXP.kind) yyWriteNl ();
}

static void yWriteNodeBTE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTE_LIST.Next);
}

static void yWriteNodeUSED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VARNAME"); yyWriteAdr (yyt->USED_VAR.VARNAME);
}

static void yWriteNodeINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_VAR"); yyWriteAdr (yyt->INDEXED_VAR.IND_VAR);
 yyWriteSelector ("IND_EXPS"); yyWriteAdr (yyt->INDEXED_VAR.IND_EXPS);
}

static void yWriteNodeSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_VAR"); yyWriteAdr (yyt->SUBSTRING_VAR.IND_VAR);
 yyWriteSelector ("IND_EXP"); yyWriteAdr (yyt->SUBSTRING_VAR.IND_EXP);
}

static void yWriteNodeSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELEC_VAR"); yyWriteAdr (yyt->SELECTED_VAR.SELEC_VAR);
 yyWriteSelector ("SELECTOR"); yyWriteAdr (yyt->SELECTED_VAR.SELECTOR);
}

static void yWriteNodeLOOP_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LOOP_VARNAME"); yyWriteAdr (yyt->LOOP_VAR.LOOP_VARNAME);
}

static void yWriteNodePERM_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PERM_VAR.VAL);
 yyWriteSelector ("perm"); writePermutation (yyt->PERM_VAR.perm) yyWriteNl ();
}

static void yWriteNodeADDR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("E"); yyWriteAdr (yyt->ADDR.E);
}

static void yWriteNodeDO_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->DO_VAR.DO_ID);
 yyWriteSelector ("RANGE"); yyWriteAdr (yyt->DO_VAR.RANGE);
 yyWriteSelector ("BODY"); yyWriteAdr (yyt->DO_VAR.BODY);
}

static void yWriteNodeREMOTE_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->REMOTE_VAR.VAR);
}

static void yWriteNodeBTV_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTV_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTV_LIST.Next);
}

static void yWriteNodeVAR_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("V"); yyWriteAdr (yyt->VAR_PARAM.V);
 yyWriteSelector ("formal"); writetDefinitions (yyt->VAR_PARAM.formal) yyWriteNl ();
 yyWriteSelector ("intent"); writeint (yyt->VAR_PARAM.intent) yyWriteNl ();
 yyWriteSelector ("layout"); writeint (yyt->VAR_PARAM.layout) yyWriteNl ();
 yyWriteSelector ("pass_by"); writeint (yyt->VAR_PARAM.pass_by) yyWriteNl ();
 yyWriteSelector ("trace"); writeint (yyt->VAR_PARAM.trace) yyWriteNl ();
}

static void yWriteNodeVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("E"); yyWriteAdr (yyt->VALUE_PARAM.E);
}

static void yWriteNodeNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->NAMED_PARAM.Name) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->NAMED_PARAM.VAL);
}

static void yWriteNodePROC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("P"); yyWriteAdr (yyt->PROC_PARAM.P);
}

static void yWriteNodeFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("F"); yyWriteAdr (yyt->FUNC_PARAM.F);
}

static void yWriteNodeFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("S"); writetStringRef (yyt->FORMAT_PARAM.S) yyWriteNl ();
}

static void yWriteNodeRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("label"); writeint (yyt->RETURN_PARAM.label) yyWriteNl ();
}

static void yWriteNodeNO_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("type"); writeint (yyt->NO_PARAM.type) yyWriteNl ();
}

static void yWriteNodeBTP_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTP_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTP_LIST.Next);
}

static void yWriteNodeBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writeint (yyt->BOOL_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writeint (yyt->INT_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->REAL_CONSTANT.value) yyWriteNl ();
 yyWriteSelector ("kind"); writeint (yyt->REAL_CONSTANT.kind) yyWriteNl ();
}

static void yWriteNodeSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->STRING_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("rvalue"); writetStringRef (yyt->COMPLEX_CONSTANT.rvalue) yyWriteNl ();
 yyWriteSelector ("ivalue"); writetStringRef (yyt->COMPLEX_CONSTANT.ivalue) yyWriteNl ();
}

static void yWriteNodePROC_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->PROC_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->PROC_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeVAR_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Pos"); writeint (yyt->VAR_OBJ.Pos) yyWriteNl ();
 yyWriteSelector ("Ident"); writetIdent (yyt->VAR_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->VAR_OBJ.Object) yyWriteNl ();
 yyWriteSelector ("Reaching"); writetReaching (yyt->VAR_OBJ.Reaching) yyWriteNl ();
}

static void yWriteNodeTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TYPE_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TYPE_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeREC_COMP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->REC_COMP.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->REC_COMP.Object) yyWriteNl ();
}

static void yWriteNodeTOP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TOP_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TOP_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeTEMP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TEMP_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TEMP_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeOVERLAP_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("left_size"); writeint (yyt->OVERLAP_SPEC.left_size) yyWriteNl ();
 yyWriteSelector ("right_size"); writeint (yyt->OVERLAP_SPEC.right_size) yyWriteNl ();
 yyWriteSelector ("left_update"); writeint (yyt->OVERLAP_SPEC.left_update) yyWriteNl ();
 yyWriteSelector ("right_update"); writeint (yyt->OVERLAP_SPEC.right_update) yyWriteNl ();
}

static void yWriteNodeINDEP_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("user_independent"); writebool (yyt->INDEP_INFO.user_independent) yyWriteNl ();
 yyWriteSelector ("selection"); writeint (yyt->INDEP_INFO.selection) yyWriteNl ();
 yyWriteSelector ("red_vars"); writeInfoTree (yyt->INDEP_INFO.red_vars) yyWriteNl ();
 yyWriteSelector ("new_vars"); writeInfoTree (yyt->INDEP_INFO.new_vars) yyWriteNl ();
}

static void yWriteNodeVECTOR_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("is_independent"); writebool (yyt->VECTOR_INFO.is_independent) yyWriteNl ();
 yyWriteSelector ("selection"); writeint (yyt->VECTOR_INFO.selection) yyWriteNl ();
 yyWriteSelector ("loop_cnt"); writeint (yyt->VECTOR_INFO.loop_cnt) yyWriteNl ();
 yyWriteSelector ("independent_vars"); writeInfoTree (yyt->VECTOR_INFO.independent_vars) yyWriteNl ();
}

static void yWriteNodeCOMM_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("home_var"); writeInfoTree (yyt->COMM_INFO.home_var) yyWriteNl ();
 yyWriteSelector ("is_local"); writebool (yyt->COMM_INFO.is_local) yyWriteNl ();
}

static void yWriteNodeON_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("on_id"); writetObject (yyt->ON_INFO.on_id) yyWriteNl ();
 yyWriteSelector ("on_dim"); writeint (yyt->ON_INFO.on_dim) yyWriteNl ();
 yyWriteSelector ("base"); writeint (yyt->ON_INFO.base) yyWriteNl ();
 yyWriteSelector ("stride"); writeint (yyt->ON_INFO.stride) yyWriteNl ();
}

static void yWriteNodePARALLEL_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("reduction_vars"); writeInfoTree (yyt->PARALLEL_INFO.reduction_vars) yyWriteNl ();
 yyWriteSelector ("home_var"); writeInfoTree (yyt->PARALLEL_INFO.home_var) yyWriteNl ();
 yyWriteSelector ("new_vars"); writeInfoTree (yyt->PARALLEL_INFO.new_vars) yyWriteNl ();
 yyWriteSelector ("resident_vars"); writeInfoTree (yyt->PARALLEL_INFO.resident_vars) yyWriteNl ();
}

static void yWriteNodeREACHING_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("var_allocate"); writeInfoTree (yyt->REACHING_INFO.var_allocate) yyWriteNl ();
 yyWriteSelector ("temp_allocate"); writeInfoTree (yyt->REACHING_INFO.temp_allocate) yyWriteNl ();
 yyWriteSelector ("var_distribution"); writetDefinitions (yyt->REACHING_INFO.var_distribution) yyWriteNl ();
 yyWriteSelector ("temp_distribution"); writetDefinitions (yyt->REACHING_INFO.temp_distribution) yyWriteNl ();
}

void WriteTreeNode
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyt == NoTree) { (void) fputs ("NoTree\n", yyf); return; }

 switch (yyt->Kind) {
case kCOMP_UNIT: (void) fputs (Tree_NodeName [kCOMP_UNIT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_UNIT (yyt); break;
case kUNIT_NODE_LIST: (void) fputs (Tree_NodeName [kUNIT_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kUNIT_EMPTY: (void) fputs (Tree_NodeName [kUNIT_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kUNIT_LIST: (void) fputs (Tree_NodeName [kUNIT_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUNIT_LIST (yyt); break;
case kUNIT_NODE: (void) fputs (Tree_NodeName [kUNIT_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUNIT_NODE (yyt); break;
case kMODULE_DECL: (void) fputs (Tree_NodeName [kMODULE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMODULE_DECL (yyt); break;
case kPROGRAM_DECL: (void) fputs (Tree_NodeName [kPROGRAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROGRAM_DECL (yyt); break;
case kPROC_DECL: (void) fputs (Tree_NodeName [kPROC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_DECL (yyt); break;
case kFUNC_DECL: (void) fputs (Tree_NodeName [kFUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_DECL (yyt); break;
case kMODULE_PROC_DECL: (void) fputs (Tree_NodeName [kMODULE_PROC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMODULE_PROC_DECL (yyt); break;
case kBLOCK_DATA_DECL: (void) fputs (Tree_NodeName [kBLOCK_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBLOCK_DATA_DECL (yyt); break;
case kINTERFACE: (void) fputs (Tree_NodeName [kINTERFACE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTERFACE (yyt); break;
case kBODY_NODE: (void) fputs (Tree_NodeName [kBODY_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBODY_NODE (yyt); break;
case kTYPE_NODE: (void) fputs (Tree_NodeName [kTYPE_NODE], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_TYPE: (void) fputs (Tree_NodeName [kDUMMY_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kALIGN_TYPE: (void) fputs (Tree_NodeName [kALIGN_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kINTEGER_TYPE: (void) fputs (Tree_NodeName [kINTEGER_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTEGER_TYPE (yyt); break;
case kREAL_TYPE: (void) fputs (Tree_NodeName [kREAL_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREAL_TYPE (yyt); break;
case kBOOLEAN_TYPE: (void) fputs (Tree_NodeName [kBOOLEAN_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOOLEAN_TYPE (yyt); break;
case kCOMPLEX_TYPE: (void) fputs (Tree_NodeName [kCOMPLEX_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMPLEX_TYPE (yyt); break;
case kSTRING_TYPE: (void) fputs (Tree_NodeName [kSTRING_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTRING_TYPE (yyt); break;
case kTYPE_ID: (void) fputs (Tree_NodeName [kTYPE_ID], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_ID (yyt); break;
case kARRAY_TYPE: (void) fputs (Tree_NodeName [kARRAY_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY_TYPE (yyt); break;
case kRECORD_TYPE: (void) fputs (Tree_NodeName [kRECORD_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRECORD_TYPE (yyt); break;
case kPOINTER_TYPE: (void) fputs (Tree_NodeName [kPOINTER_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOINTER_TYPE (yyt); break;
case kSHAPE_SPEC: (void) fputs (Tree_NodeName [kSHAPE_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSHAPE_SPEC (yyt); break;
case kEXPLICIT_SHAPE: (void) fputs (Tree_NodeName [kEXPLICIT_SHAPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXPLICIT_SHAPE (yyt); break;
case kASSUMED_SHAPE: (void) fputs (Tree_NodeName [kASSUMED_SHAPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSUMED_SHAPE (yyt); break;
case kDEFERRED_SHAPE: (void) fputs (Tree_NodeName [kDEFERRED_SHAPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEFERRED_SHAPE (yyt); break;
case kASSUMED_SIZE: (void) fputs (Tree_NodeName [kASSUMED_SIZE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSUMED_SIZE (yyt); break;
case kSHAPE_SPEC_LIST: (void) fputs (Tree_NodeName [kSHAPE_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSHAPE_EMPTY: (void) fputs (Tree_NodeName [kSHAPE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSHAPE_LIST: (void) fputs (Tree_NodeName [kSHAPE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSHAPE_LIST (yyt); break;
case kDECL_NODE: (void) fputs (Tree_NodeName [kDECL_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDECL_NODE (yyt); break;
case kTYPE_DECL: (void) fputs (Tree_NodeName [kTYPE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_DECL (yyt); break;
case kNAME_DECL: (void) fputs (Tree_NodeName [kNAME_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAME_DECL (yyt); break;
case kRENAME_DECL: (void) fputs (Tree_NodeName [kRENAME_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRENAME_DECL (yyt); break;
case kENTITY_DECL: (void) fputs (Tree_NodeName [kENTITY_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeENTITY_DECL (yyt); break;
case kVAR_DECL: (void) fputs (Tree_NodeName [kVAR_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_DECL (yyt); break;
case kCOMMON_DECL: (void) fputs (Tree_NodeName [kCOMMON_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMMON_DECL (yyt); break;
case kNAMELIST_DECL: (void) fputs (Tree_NodeName [kNAMELIST_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMELIST_DECL (yyt); break;
case kTEMPLATE_DECL: (void) fputs (Tree_NodeName [kTEMPLATE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTEMPLATE_DECL (yyt); break;
case kRAGGED_DECL: (void) fputs (Tree_NodeName [kRAGGED_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRAGGED_DECL (yyt); break;
case kPROCESSORS_DECL: (void) fputs (Tree_NodeName [kPROCESSORS_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSORS_DECL (yyt); break;
case kSUB_PROCS_DECL: (void) fputs (Tree_NodeName [kSUB_PROCS_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSUB_PROCS_DECL (yyt); break;
case kINHERIT_DECL: (void) fputs (Tree_NodeName [kINHERIT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINHERIT_DECL (yyt); break;
case kRANGE_DECL: (void) fputs (Tree_NodeName [kRANGE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRANGE_DECL (yyt); break;
case kSTMT_FUNC_DECL: (void) fputs (Tree_NodeName [kSTMT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTMT_FUNC_DECL (yyt); break;
case kINTERFACE_DECL: (void) fputs (Tree_NodeName [kINTERFACE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTERFACE_DECL (yyt); break;
case kVAR_PARAM_DECL: (void) fputs (Tree_NodeName [kVAR_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_PARAM_DECL (yyt); break;
case kRET_PARAM_DECL: (void) fputs (Tree_NodeName [kRET_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRET_PARAM_DECL (yyt); break;
case kIMPLICIT_DECL: (void) fputs (Tree_NodeName [kIMPLICIT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIMPLICIT_DECL (yyt); break;
case kUSE_DECL: (void) fputs (Tree_NodeName [kUSE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSE_DECL (yyt); break;
case kONLY_USE_DECL: (void) fputs (Tree_NodeName [kONLY_USE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeONLY_USE_DECL (yyt); break;
case kEQV_DECL: (void) fputs (Tree_NodeName [kEQV_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEQV_DECL (yyt); break;
case kDATA_DECL: (void) fputs (Tree_NodeName [kDATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDATA_DECL (yyt); break;
case kFORMAT_DECL: (void) fputs (Tree_NodeName [kFORMAT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_DECL (yyt); break;
case kDIMENSION_DECL: (void) fputs (Tree_NodeName [kDIMENSION_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIMENSION_DECL (yyt); break;
case kINIT_DATA_DECL: (void) fputs (Tree_NodeName [kINIT_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINIT_DATA_DECL (yyt); break;
case kTYPESPEC_DECL: (void) fputs (Tree_NodeName [kTYPESPEC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPESPEC_DECL (yyt); break;
case kALLOCATABLE_DECL: (void) fputs (Tree_NodeName [kALLOCATABLE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALLOCATABLE_DECL (yyt); break;
case kEXTERNAL_DECL: (void) fputs (Tree_NodeName [kEXTERNAL_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXTERNAL_DECL (yyt); break;
case kINTENT_DECL: (void) fputs (Tree_NodeName [kINTENT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTENT_DECL (yyt); break;
case kINTRINSIC_DECL: (void) fputs (Tree_NodeName [kINTRINSIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTRINSIC_DECL (yyt); break;
case kOPTIONAL_DECL: (void) fputs (Tree_NodeName [kOPTIONAL_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOPTIONAL_DECL (yyt); break;
case kPOINTER_DECL: (void) fputs (Tree_NodeName [kPOINTER_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOINTER_DECL (yyt); break;
case kSAVE_DECL: (void) fputs (Tree_NodeName [kSAVE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSAVE_DECL (yyt); break;
case kTARGET_DECL: (void) fputs (Tree_NodeName [kTARGET_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTARGET_DECL (yyt); break;
case kPARAMETER_DECL: (void) fputs (Tree_NodeName [kPARAMETER_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePARAMETER_DECL (yyt); break;
case kPUBLIC_DECL: (void) fputs (Tree_NodeName [kPUBLIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePUBLIC_DECL (yyt); break;
case kPRIVATE_DECL: (void) fputs (Tree_NodeName [kPRIVATE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePRIVATE_DECL (yyt); break;
case kSEQUENCE_DECL: (void) fputs (Tree_NodeName [kSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSEQUENCE_DECL (yyt); break;
case kDISTRIBUTE_DECL: (void) fputs (Tree_NodeName [kDISTRIBUTE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDISTRIBUTE_DECL (yyt); break;
case kALIGN_DECL: (void) fputs (Tree_NodeName [kALIGN_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALIGN_DECL (yyt); break;
case kMAP_DECL: (void) fputs (Tree_NodeName [kMAP_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMAP_DECL (yyt); break;
case kOVERLAP_DECL: (void) fputs (Tree_NodeName [kOVERLAP_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOVERLAP_DECL (yyt); break;
case kSHARED_DECL: (void) fputs (Tree_NodeName [kSHARED_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSHARED_DECL (yyt); break;
case kDYNAMIC_DECL: (void) fputs (Tree_NodeName [kDYNAMIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDYNAMIC_DECL (yyt); break;
case kTRACE_DECL: (void) fputs (Tree_NodeName [kTRACE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTRACE_DECL (yyt); break;
case kTREE_DECL: (void) fputs (Tree_NodeName [kTREE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTREE_DECL (yyt); break;
case kSELECT_DECL: (void) fputs (Tree_NodeName [kSELECT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECT_DECL (yyt); break;
case kHPF_SEQUENCE_DECL: (void) fputs (Tree_NodeName [kHPF_SEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeHPF_SEQUENCE_DECL (yyt); break;
case kNOSEQUENCE_DECL: (void) fputs (Tree_NodeName [kNOSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNOSEQUENCE_DECL (yyt); break;
case kLAYOUT_DECL: (void) fputs (Tree_NodeName [kLAYOUT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLAYOUT_DECL (yyt); break;
case kPASS_BY_DECL: (void) fputs (Tree_NodeName [kPASS_BY_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePASS_BY_DECL (yyt); break;
case kMAP_TO_DECL: (void) fputs (Tree_NodeName [kMAP_TO_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMAP_TO_DECL (yyt); break;
case kDECL_NODE_LIST: (void) fputs (Tree_NodeName [kDECL_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kDECL_EMPTY: (void) fputs (Tree_NodeName [kDECL_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kDECL_LIST: (void) fputs (Tree_NodeName [kDECL_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDECL_LIST (yyt); break;
case kRANGE_SPEC_LIST: (void) fputs (Tree_NodeName [kRANGE_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kRANGE_EMPTY: (void) fputs (Tree_NodeName [kRANGE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kRANGE_LIST: (void) fputs (Tree_NodeName [kRANGE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRANGE_LIST (yyt); break;
case kSELECT_SPEC_LIST: (void) fputs (Tree_NodeName [kSELECT_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECT_EMPTY: (void) fputs (Tree_NodeName [kSELECT_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECT_LIST: (void) fputs (Tree_NodeName [kSELECT_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECT_LIST (yyt); break;
case kSELECT_SPEC: (void) fputs (Tree_NodeName [kSELECT_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECT_SPEC (yyt); break;
case kDISTRIBUTION_SPEC: (void) fputs (Tree_NodeName [kDISTRIBUTION_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDISTRIBUTION_SPEC (yyt); break;
case kANY_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeANY_DISTRIBUTION (yyt); break;
case kDEFAULT_DISTRIBUTION: (void) fputs (Tree_NodeName [kDEFAULT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEFAULT_DISTRIBUTION (yyt); break;
case kREPL_DISTRIBUTION: (void) fputs (Tree_NodeName [kREPL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREPL_DISTRIBUTION (yyt); break;
case kNODE_DISTRIBUTION: (void) fputs (Tree_NodeName [kNODE_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNODE_DISTRIBUTION (yyt); break;
case kDIST_FORMAT_LIST: (void) fputs (Tree_NodeName [kDIST_FORMAT_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_EMPTY: (void) fputs (Tree_NodeName [kDIST_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_LIST: (void) fputs (Tree_NodeName [kDIST_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIST_LIST (yyt); break;
case kDISTRIBUTION_FORMAT: (void) fputs (Tree_NodeName [kDISTRIBUTION_FORMAT], yyf); (void) fputc ('\n', yyf);
 break;
case kBLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kBLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBLOCK_DISTRIBUTION (yyt); break;
case kCYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kCYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCYCLIC_DISTRIBUTION (yyt); break;
case kGEN_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kGEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeGEN_BLOCK_DISTRIBUTION (yyt); break;
case kINDIRECT_DISTRIBUTION: (void) fputs (Tree_NodeName [kINDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDIRECT_DISTRIBUTION (yyt); break;
case kARBITRARY_DISTRIBUTION: (void) fputs (Tree_NodeName [kARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARBITRARY_DISTRIBUTION (yyt); break;
case kSERIAL_DISTRIBUTION: (void) fputs (Tree_NodeName [kSERIAL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_CYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_CYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_GEN_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_GEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_INDIRECT_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_INDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_ARBITRARY_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_ARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_DIM_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_DIM_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kPROCESSOR_SPEC: (void) fputs (Tree_NodeName [kPROCESSOR_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kANY_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
 break;
case kDEFAULT_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kDEFAULT_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
 break;
case kPROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kPROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSOR_ARRAY (yyt); break;
case kPROCESSOR_SUBSET: (void) fputs (Tree_NodeName [kPROCESSOR_SUBSET], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSOR_SUBSET (yyt); break;
case kALIGN_SPEC: (void) fputs (Tree_NodeName [kALIGN_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALIGN_SPEC (yyt); break;
case kGENERIC_SPEC: (void) fputs (Tree_NodeName [kGENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kNO_GENERIC_SPEC: (void) fputs (Tree_NodeName [kNO_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kID_GENERIC_SPEC: (void) fputs (Tree_NodeName [kID_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeID_GENERIC_SPEC (yyt); break;
case kOP_GENERIC_SPEC: (void) fputs (Tree_NodeName [kOP_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_GENERIC_SPEC (yyt); break;
case kASSIGN_GENERIC_SPEC: (void) fputs (Tree_NodeName [kASSIGN_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_NODE_LIST: (void) fputs (Tree_NodeName [kACF_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_EMPTY: (void) fputs (Tree_NodeName [kACF_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_LIST: (void) fputs (Tree_NodeName [kACF_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_LIST (yyt); break;
case kACF_NODE: (void) fputs (Tree_NodeName [kACF_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_NODE (yyt); break;
case kACF_DUMMY: (void) fputs (Tree_NodeName [kACF_DUMMY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DUMMY (yyt); break;
case kACF_BASIC: (void) fputs (Tree_NodeName [kACF_BASIC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_BASIC (yyt); break;
case kACF_IF: (void) fputs (Tree_NodeName [kACF_IF], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_IF (yyt); break;
case kACF_WHERE: (void) fputs (Tree_NodeName [kACF_WHERE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WHERE (yyt); break;
case kACF_CASE: (void) fputs (Tree_NodeName [kACF_CASE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_CASE (yyt); break;
case kACF_WHILE: (void) fputs (Tree_NodeName [kACF_WHILE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WHILE (yyt); break;
case kACF_REPEAT: (void) fputs (Tree_NodeName [kACF_REPEAT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_REPEAT (yyt); break;
case kACF_LOOP: (void) fputs (Tree_NodeName [kACF_LOOP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_LOOP (yyt); break;
case kACF_DO: (void) fputs (Tree_NodeName [kACF_DO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DO (yyt); break;
case kACF_FORALL: (void) fputs (Tree_NodeName [kACF_FORALL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_FORALL (yyt); break;
case kACF_FLOW_GRAPH: (void) fputs (Tree_NodeName [kACF_FLOW_GRAPH], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_FLOW_GRAPH (yyt); break;
case kACF_ENTRY: (void) fputs (Tree_NodeName [kACF_ENTRY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ENTRY (yyt); break;
case kACF_HOME: (void) fputs (Tree_NodeName [kACF_HOME], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_HOME (yyt); break;
case kACF_RESIDENT: (void) fputs (Tree_NodeName [kACF_RESIDENT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_RESIDENT (yyt); break;
case kACF_NEW: (void) fputs (Tree_NodeName [kACF_NEW], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_NEW (yyt); break;
case kACF_REDUCTION: (void) fputs (Tree_NodeName [kACF_REDUCTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_REDUCTION (yyt); break;
case kACF_TASK_REGION: (void) fputs (Tree_NodeName [kACF_TASK_REGION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_TASK_REGION (yyt); break;
case kACF_PARALLEL: (void) fputs (Tree_NodeName [kACF_PARALLEL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_PARALLEL (yyt); break;
case kACF_CRITICAL: (void) fputs (Tree_NodeName [kACF_CRITICAL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_CRITICAL (yyt); break;
case kACF_ON: (void) fputs (Tree_NodeName [kACF_ON], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ON (yyt); break;
case kACF_RM_READ: (void) fputs (Tree_NodeName [kACF_RM_READ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_RM_READ (yyt); break;
case kACF_RM_WRITE: (void) fputs (Tree_NodeName [kACF_RM_WRITE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_RM_WRITE (yyt); break;
case kACF_MOVE: (void) fputs (Tree_NodeName [kACF_MOVE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_MOVE (yyt); break;
case kACF_BARRIER: (void) fputs (Tree_NodeName [kACF_BARRIER], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_BARRIER (yyt); break;
case kACF_UPDATE: (void) fputs (Tree_NodeName [kACF_UPDATE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_UPDATE (yyt); break;
case kACF_FLOW_KIND: (void) fputs (Tree_NodeName [kACF_FLOW_KIND], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_COMPLEX_FLOW: (void) fputs (Tree_NodeName [kACF_COMPLEX_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_INTERVAL_FLOW: (void) fputs (Tree_NodeName [kACF_INTERVAL_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_SIMPLE_FLOW: (void) fputs (Tree_NodeName [kACF_SIMPLE_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kON_CLAUSE: (void) fputs (Tree_NodeName [kON_CLAUSE], yyf); (void) fputc ('\n', yyf);
 break;
case kON_HOST_CLAUSE: (void) fputs (Tree_NodeName [kON_HOST_CLAUSE], yyf); (void) fputc ('\n', yyf);
 break;
case kON_ALL_CLAUSE: (void) fputs (Tree_NodeName [kON_ALL_CLAUSE], yyf); (void) fputc ('\n', yyf);
 break;
case kON_VAR_CLAUSE: (void) fputs (Tree_NodeName [kON_VAR_CLAUSE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_VAR_CLAUSE (yyt); break;
case kON_PROC_CLAUSE: (void) fputs (Tree_NodeName [kON_PROC_CLAUSE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_PROC_CLAUSE (yyt); break;
case kON_TOPOLOGY: (void) fputs (Tree_NodeName [kON_TOPOLOGY], yyf); (void) fputc ('\n', yyf);
 break;
case kON_ALL: (void) fputs (Tree_NodeName [kON_ALL], yyf); (void) fputc ('\n', yyf);
 break;
case kON_HOST: (void) fputs (Tree_NodeName [kON_HOST], yyf); (void) fputc ('\n', yyf);
 break;
case kON_PROCS: (void) fputs (Tree_NodeName [kON_PROCS], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_PROCS (yyt); break;
case kON_VAR: (void) fputs (Tree_NodeName [kON_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_VAR (yyt); break;
case kON_SPEC_LIST: (void) fputs (Tree_NodeName [kON_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kON_EMPTY: (void) fputs (Tree_NodeName [kON_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kON_LIST: (void) fputs (Tree_NodeName [kON_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_LIST (yyt); break;
case kON_SPEC: (void) fputs (Tree_NodeName [kON_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_SPEC (yyt); break;
case kSELECTED_ACF_NODE_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_EMPTY: (void) fputs (Tree_NodeName [kSELECTED_ACF_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_ACF_LIST (yyt); break;
case kSELECTED_ACF_NODE: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_ACF_NODE (yyt); break;
case kBT_STMT: (void) fputs (Tree_NodeName [kBT_STMT], yyf); (void) fputc ('\n', yyf);
 break;
case kASSIGN_STMT: (void) fputs (Tree_NodeName [kASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSIGN_STMT (yyt); break;
case kPTR_ASSIGN_STMT: (void) fputs (Tree_NodeName [kPTR_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodePTR_ASSIGN_STMT (yyt); break;
case kLABEL_ASSIGN_STMT: (void) fputs (Tree_NodeName [kLABEL_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLABEL_ASSIGN_STMT (yyt); break;
case kCALL_STMT: (void) fputs (Tree_NodeName [kCALL_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCALL_STMT (yyt); break;
case kIO_STMT: (void) fputs (Tree_NodeName [kIO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIO_STMT (yyt); break;
case kGOTO_STMT: (void) fputs (Tree_NodeName [kGOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeGOTO_STMT (yyt); break;
case kASS_GOTO_STMT: (void) fputs (Tree_NodeName [kASS_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASS_GOTO_STMT (yyt); break;
case kCOMP_GOTO_STMT: (void) fputs (Tree_NodeName [kCOMP_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_GOTO_STMT (yyt); break;
case kCOMP_IF_STMT: (void) fputs (Tree_NodeName [kCOMP_IF_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_IF_STMT (yyt); break;
case kRETURN_STMT: (void) fputs (Tree_NodeName [kRETURN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRETURN_STMT (yyt); break;
case kPAUSE_STMT: (void) fputs (Tree_NodeName [kPAUSE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodePAUSE_STMT (yyt); break;
case kEXIT_STMT: (void) fputs (Tree_NodeName [kEXIT_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXIT_STMT (yyt); break;
case kCYCLE_STMT: (void) fputs (Tree_NodeName [kCYCLE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCYCLE_STMT (yyt); break;
case kSTOP_STMT: (void) fputs (Tree_NodeName [kSTOP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTOP_STMT (yyt); break;
case kFORMAT_STMT: (void) fputs (Tree_NodeName [kFORMAT_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_STMT (yyt); break;
case kINHERIT_DSP_STMT: (void) fputs (Tree_NodeName [kINHERIT_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINHERIT_DSP_STMT (yyt); break;
case kCREATE_DSP_STMT: (void) fputs (Tree_NodeName [kCREATE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCREATE_DSP_STMT (yyt); break;
case kFREE_DSP_STMT: (void) fputs (Tree_NodeName [kFREE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFREE_DSP_STMT (yyt); break;
case kALLOCATE_STMT: (void) fputs (Tree_NodeName [kALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALLOCATE_STMT (yyt); break;
case kDEALLOCATE_STMT: (void) fputs (Tree_NodeName [kDEALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEALLOCATE_STMT (yyt); break;
case kNULLIFY_STMT: (void) fputs (Tree_NodeName [kNULLIFY_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNULLIFY_STMT (yyt); break;
case kREDUCE_STMT: (void) fputs (Tree_NodeName [kREDUCE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDUCE_STMT (yyt); break;
case kMOVE_STMT: (void) fputs (Tree_NodeName [kMOVE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMOVE_STMT (yyt); break;
case kSCATTER_STMT: (void) fputs (Tree_NodeName [kSCATTER_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSCATTER_STMT (yyt); break;
case kREALIGN_STMT: (void) fputs (Tree_NodeName [kREALIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREALIGN_STMT (yyt); break;
case kREDISTRIBUTE_STMT: (void) fputs (Tree_NodeName [kREDISTRIBUTE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDISTRIBUTE_STMT (yyt); break;
case kREG_SHADOW_GET: (void) fputs (Tree_NodeName [kREG_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREG_SHADOW_GET (yyt); break;
case kREG_SHADOW_PUT: (void) fputs (Tree_NodeName [kREG_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREG_SHADOW_PUT (yyt); break;
case kREG_SHADOW_SET: (void) fputs (Tree_NodeName [kREG_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREG_SHADOW_SET (yyt); break;
case kIND_SHADOW_CREATE: (void) fputs (Tree_NodeName [kIND_SHADOW_CREATE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_CREATE (yyt); break;
case kIND_SHADOW_FREE: (void) fputs (Tree_NodeName [kIND_SHADOW_FREE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_FREE (yyt); break;
case kIND_SHADOW_GET: (void) fputs (Tree_NodeName [kIND_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_GET (yyt); break;
case kIND_SHADOW_PUT: (void) fputs (Tree_NodeName [kIND_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_PUT (yyt); break;
case kIND_SHADOW_SET: (void) fputs (Tree_NodeName [kIND_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_SET (yyt); break;
case kBROADCAST_STMT: (void) fputs (Tree_NodeName [kBROADCAST_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBROADCAST_STMT (yyt); break;
case kREDUCTION_STMT: (void) fputs (Tree_NodeName [kREDUCTION_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDUCTION_STMT (yyt); break;
case kDIRTY_STMT: (void) fputs (Tree_NodeName [kDIRTY_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIRTY_STMT (yyt); break;
case kLABEL_USE_LIST: (void) fputs (Tree_NodeName [kLABEL_USE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kLABEL_EMPTY: (void) fputs (Tree_NodeName [kLABEL_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kLABEL_LIST: (void) fputs (Tree_NodeName [kLABEL_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLABEL_LIST (yyt); break;
case kOP: (void) fputs (Tree_NodeName [kOP], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EQ: (void) fputs (Tree_NodeName [kOP_EQ], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_NE: (void) fputs (Tree_NodeName [kOP_NE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LT: (void) fputs (Tree_NodeName [kOP_LT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_GT: (void) fputs (Tree_NodeName [kOP_GT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_GE: (void) fputs (Tree_NodeName [kOP_GE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LE: (void) fputs (Tree_NodeName [kOP_LE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_PLUS: (void) fputs (Tree_NodeName [kOP_PLUS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_MINUS: (void) fputs (Tree_NodeName [kOP_MINUS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_XOR: (void) fputs (Tree_NodeName [kOP_XOR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_OR: (void) fputs (Tree_NodeName [kOP_OR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_CONCAT: (void) fputs (Tree_NodeName [kOP_CONCAT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_TIMES: (void) fputs (Tree_NodeName [kOP_TIMES], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DIVIDE: (void) fputs (Tree_NodeName [kOP_DIVIDE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_AND: (void) fputs (Tree_NodeName [kOP_AND], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EQV: (void) fputs (Tree_NodeName [kOP_EQV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_NEQV: (void) fputs (Tree_NodeName [kOP_NEQV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EXPO: (void) fputs (Tree_NodeName [kOP_EXPO], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DEFINED: (void) fputs (Tree_NodeName [kOP_DEFINED], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_DEFINED (yyt); break;
case kOP_ASSIGN: (void) fputs (Tree_NodeName [kOP_ASSIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_NOT: (void) fputs (Tree_NodeName [kOP1_NOT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_SIGN: (void) fputs (Tree_NodeName [kOP1_SIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_PSIGN: (void) fputs (Tree_NodeName [kOP1_PSIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kBT_EXP: (void) fputs (Tree_NodeName [kBT_EXP], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_EXP: (void) fputs (Tree_NodeName [kDUMMY_EXP], yyf); (void) fputc ('\n', yyf);
 break;
case kCONST_EXP: (void) fputs (Tree_NodeName [kCONST_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCONST_EXP (yyt); break;
case kOP_EXP: (void) fputs (Tree_NodeName [kOP_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_EXP (yyt); break;
case kOP1_EXP: (void) fputs (Tree_NodeName [kOP1_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP1_EXP (yyt); break;
case kSLICE_EXP: (void) fputs (Tree_NodeName [kSLICE_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSLICE_EXP (yyt); break;
case kVAR_EXP: (void) fputs (Tree_NodeName [kVAR_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_EXP (yyt); break;
case kFUNC_CALL_EXP: (void) fputs (Tree_NodeName [kFUNC_CALL_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_CALL_EXP (yyt); break;
case kNAMED_EXP: (void) fputs (Tree_NodeName [kNAMED_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMED_EXP (yyt); break;
case kDO_EXP: (void) fputs (Tree_NodeName [kDO_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDO_EXP (yyt); break;
case kTYPE_EXP: (void) fputs (Tree_NodeName [kTYPE_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_EXP (yyt); break;
case kARRAY_EXP: (void) fputs (Tree_NodeName [kARRAY_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY_EXP (yyt); break;
case kPERM_EXP: (void) fputs (Tree_NodeName [kPERM_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodePERM_EXP (yyt); break;
case kBOUND_EXP: (void) fputs (Tree_NodeName [kBOUND_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOUND_EXP (yyt); break;
case kRANK_EXP: (void) fputs (Tree_NodeName [kRANK_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRANK_EXP (yyt); break;
case kBT_EXP_LIST: (void) fputs (Tree_NodeName [kBT_EXP_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTE_EMPTY: (void) fputs (Tree_NodeName [kBTE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTE_LIST: (void) fputs (Tree_NodeName [kBTE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTE_LIST (yyt); break;
case kBT_VAR: (void) fputs (Tree_NodeName [kBT_VAR], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_VAR: (void) fputs (Tree_NodeName [kDUMMY_VAR], yyf); (void) fputc ('\n', yyf);
 break;
case kUSED_VAR: (void) fputs (Tree_NodeName [kUSED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSED_VAR (yyt); break;
case kINDEXED_VAR: (void) fputs (Tree_NodeName [kINDEXED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEXED_VAR (yyt); break;
case kSUBSTRING_VAR: (void) fputs (Tree_NodeName [kSUBSTRING_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSUBSTRING_VAR (yyt); break;
case kSELECTED_VAR: (void) fputs (Tree_NodeName [kSELECTED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_VAR (yyt); break;
case kLOOP_VAR: (void) fputs (Tree_NodeName [kLOOP_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLOOP_VAR (yyt); break;
case kPERM_VAR: (void) fputs (Tree_NodeName [kPERM_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodePERM_VAR (yyt); break;
case kADDR: (void) fputs (Tree_NodeName [kADDR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeADDR (yyt); break;
case kDO_VAR: (void) fputs (Tree_NodeName [kDO_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDO_VAR (yyt); break;
case kREMOTE_VAR: (void) fputs (Tree_NodeName [kREMOTE_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREMOTE_VAR (yyt); break;
case kBT_VAR_LIST: (void) fputs (Tree_NodeName [kBT_VAR_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTV_EMPTY: (void) fputs (Tree_NodeName [kBTV_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTV_LIST: (void) fputs (Tree_NodeName [kBTV_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTV_LIST (yyt); break;
case kBT_PARAM: (void) fputs (Tree_NodeName [kBT_PARAM], yyf); (void) fputc ('\n', yyf);
 break;
case kVAR_PARAM: (void) fputs (Tree_NodeName [kVAR_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_PARAM (yyt); break;
case kVALUE_PARAM: (void) fputs (Tree_NodeName [kVALUE_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVALUE_PARAM (yyt); break;
case kNAMED_PARAM: (void) fputs (Tree_NodeName [kNAMED_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMED_PARAM (yyt); break;
case kPROC_PARAM: (void) fputs (Tree_NodeName [kPROC_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_PARAM (yyt); break;
case kFUNC_PARAM: (void) fputs (Tree_NodeName [kFUNC_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_PARAM (yyt); break;
case kFORMAT_PARAM: (void) fputs (Tree_NodeName [kFORMAT_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_PARAM (yyt); break;
case kRETURN_PARAM: (void) fputs (Tree_NodeName [kRETURN_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRETURN_PARAM (yyt); break;
case kNO_PARAM: (void) fputs (Tree_NodeName [kNO_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNO_PARAM (yyt); break;
case kBT_PARAM_LIST: (void) fputs (Tree_NodeName [kBT_PARAM_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTP_EMPTY: (void) fputs (Tree_NodeName [kBTP_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTP_LIST: (void) fputs (Tree_NodeName [kBTP_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTP_LIST (yyt); break;
case kCONSTANT: (void) fputs (Tree_NodeName [kCONSTANT], yyf); (void) fputc ('\n', yyf);
 break;
case kBOOL_CONSTANT: (void) fputs (Tree_NodeName [kBOOL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOOL_CONSTANT (yyt); break;
case kINT_CONSTANT: (void) fputs (Tree_NodeName [kINT_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINT_CONSTANT (yyt); break;
case kREAL_CONSTANT: (void) fputs (Tree_NodeName [kREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREAL_CONSTANT (yyt); break;
case kSTRING_CONSTANT: (void) fputs (Tree_NodeName [kSTRING_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTRING_CONSTANT (yyt); break;
case kCOMPLEX_CONSTANT: (void) fputs (Tree_NodeName [kCOMPLEX_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMPLEX_CONSTANT (yyt); break;
case kPROC_OBJ: (void) fputs (Tree_NodeName [kPROC_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_OBJ (yyt); break;
case kVAR_OBJ: (void) fputs (Tree_NodeName [kVAR_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_OBJ (yyt); break;
case kTYPE_OBJ: (void) fputs (Tree_NodeName [kTYPE_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_OBJ (yyt); break;
case kREC_COMP: (void) fputs (Tree_NodeName [kREC_COMP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREC_COMP (yyt); break;
case kTOP_OBJ: (void) fputs (Tree_NodeName [kTOP_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTOP_OBJ (yyt); break;
case kTEMP_OBJ: (void) fputs (Tree_NodeName [kTEMP_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTEMP_OBJ (yyt); break;
case kOVERLAP_SPEC: (void) fputs (Tree_NodeName [kOVERLAP_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOVERLAP_SPEC (yyt); break;
case kDEPENDENCE_INFO: (void) fputs (Tree_NodeName [kDEPENDENCE_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kSERIAL_INFO: (void) fputs (Tree_NodeName [kSERIAL_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kINDEP_INFO: (void) fputs (Tree_NodeName [kINDEP_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEP_INFO (yyt); break;
case kVECTOR_INFO: (void) fputs (Tree_NodeName [kVECTOR_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVECTOR_INFO (yyt); break;
case kPARDO_INFO: (void) fputs (Tree_NodeName [kPARDO_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kHOME_INFO: (void) fputs (Tree_NodeName [kHOME_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kNO_HOME_INFO: (void) fputs (Tree_NodeName [kNO_HOME_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kCOMM_INFO: (void) fputs (Tree_NodeName [kCOMM_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMM_INFO (yyt); break;
case kON_INFO: (void) fputs (Tree_NodeName [kON_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_INFO (yyt); break;
case kPARALLEL_INFO: (void) fputs (Tree_NodeName [kPARALLEL_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodePARALLEL_INFO (yyt); break;
case kREACHING_INFO: (void) fputs (Tree_NodeName [kREACHING_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREACHING_INFO (yyt); break;
 default: ;
 }
}

static short yyIndentLevel;

void WriteTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteTree (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tTree yyt)
# else
 (yys, yyt) char * yys; tTree yyt;
# endif
{ yyIndentSelector (yys); writetTree (yyt) }

static void yWriteCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_UNIT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("COMP_ELEMENTS", yyt->COMP_UNIT.COMP_ELEMENTS);
}

static void yWriteUNIT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUNIT_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->UNIT_LIST.Elem);
}

static void yWriteUNIT_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUNIT_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->UNIT_NODE.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->UNIT_NODE.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->UNIT_NODE.Object) yyWriteNl ();
}

static void yWriteMODULE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMODULE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MODULE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MODULE_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->MODULE_DECL.Object) yyWriteNl ();
}

static void yWritePROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROGRAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROGRAM_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PROGRAM_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROGRAM_DECL.Object) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->PROGRAM_DECL.FORMALS);
}

static void yWritePROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PROC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROC_DECL.Object) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->PROC_DECL.FORMALS);
 yyIndentSelector ("IsRecursive"); writebool (yyt->PROC_DECL.IsRecursive) yyWriteNl ();
 yyIndentSelector ("IsPure"); writebool (yyt->PROC_DECL.IsPure) yyWriteNl ();
 yyIndentSelector ("HPFExtrinsic"); writetIdent (yyt->PROC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteFUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->FUNC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->FUNC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->FUNC_DECL.Object) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->FUNC_DECL.FORMALS);
 yyIndentSelectorTree ("FUNC_BODY", yyt->FUNC_DECL.FUNC_BODY);
 yyIndentSelector ("RESULT_ID"); writetIdent (yyt->FUNC_DECL.RESULT_ID) yyWriteNl ();
 yyIndentSelector ("IsRecursive"); writebool (yyt->FUNC_DECL.IsRecursive) yyWriteNl ();
 yyIndentSelector ("IsPure"); writebool (yyt->FUNC_DECL.IsPure) yyWriteNl ();
 yyIndentSelector ("HPFExtrinsic"); writetIdent (yyt->FUNC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteMODULE_PROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMODULE_PROC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MODULE_PROC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MODULE_PROC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->MODULE_PROC_DECL.Object) yyWriteNl ();
}

static void yWriteBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBLOCK_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->BLOCK_DATA_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->BLOCK_DATA_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->BLOCK_DATA_DECL.Object) yyWriteNl ();
}

static void yWriteINTERFACE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTERFACE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTERFACE.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTERFACE.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->INTERFACE.Object) yyWriteNl ();
 yyIndentSelectorTree ("SPEC", yyt->INTERFACE.SPEC);
}

static void yWriteBODY_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBODY_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DECLS", yyt->BODY_NODE.DECLS);
 yyIndentSelectorTree ("STATS", yyt->BODY_NODE.STATS);
}

static void yWriteINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTEGER_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteREAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREAL_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOOLEAN_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMPLEX_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTRING_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteTYPE_ID
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_ID], yyf); (void) fputc ('\n', yyf);
}

static void yWriteARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ARRAY_INDEX_TYPES", yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
}

static void yWriteRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRECORD_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->RECORD_TYPE.Name) yyWriteNl ();
}

static void yWritePOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOINTER_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteSHAPE_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSHAPE_SPEC], yyf); (void) fputc ('\n', yyf);
}

static void yWriteEXPLICIT_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXPLICIT_SHAPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Overlap", yyt->EXPLICIT_SHAPE.Overlap);
 yyIndentSelectorTree ("LOWER", yyt->EXPLICIT_SHAPE.LOWER);
}

static void yWriteASSUMED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSUMED_SHAPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Overlap", yyt->ASSUMED_SHAPE.Overlap);
}

static void yWriteDEFERRED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEFERRED_SHAPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteASSUMED_SIZE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSUMED_SIZE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Overlap", yyt->ASSUMED_SIZE.Overlap);
}

static void yWriteSHAPE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSHAPE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SHAPE_LIST.Elem);
}

static void yWriteDECL_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDECL_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DECL_NODE.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DECL_NODE.Line) yyWriteNl ();
}

static void yWriteTYPE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TYPE_DECL.Line) yyWriteNl ();
}

static void yWriteNAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAME_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->NAME_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->NAME_DECL.Line) yyWriteNl ();
}

static void yWriteRENAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRENAME_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RENAME_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RENAME_DECL.Line) yyWriteNl ();
 yyIndentSelector ("oldname"); writetIdent (yyt->RENAME_DECL.oldname) yyWriteNl ();
}

static void yWriteENTITY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kENTITY_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ENTITY_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ENTITY_DECL.Line) yyWriteNl ();
}

static void yWriteVAR_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->VAR_DECL.Line) yyWriteNl ();
}

static void yWriteCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMMON_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->COMMON_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->COMMON_DECL.Line) yyWriteNl ();
}

static void yWriteNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMELIST_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->NAMELIST_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->NAMELIST_DECL.Line) yyWriteNl ();
}

static void yWriteTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTEMPLATE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TEMPLATE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TEMPLATE_DECL.Line) yyWriteNl ();
}

static void yWriteRAGGED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRAGGED_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RAGGED_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RAGGED_DECL.Line) yyWriteNl ();
}

static void yWritePROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSORS_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROCESSORS_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PROCESSORS_DECL.Line) yyWriteNl ();
}

static void yWriteSUB_PROCS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSUB_PROCS_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SUB_PROCS_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SUB_PROCS_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("TOP", yyt->SUB_PROCS_DECL.TOP);
}

static void yWriteINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINHERIT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INHERIT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INHERIT_DECL.Line) yyWriteNl ();
}

static void yWriteRANGE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRANGE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RANGE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RANGE_DECL.Line) yyWriteNl ();
}

static void yWriteSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTMT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->STMT_FUNC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->STMT_FUNC_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->STMT_FUNC_DECL.FORMALS);
 yyIndentSelectorTree ("RESULT_TYPE", yyt->STMT_FUNC_DECL.RESULT_TYPE);
}

static void yWriteINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTERFACE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTERFACE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTERFACE_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("SPEC", yyt->INTERFACE_DECL.SPEC);
}

static void yWriteVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_PARAM_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->VAR_PARAM_DECL.Line) yyWriteNl ();
}

static void yWriteRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRET_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RET_PARAM_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RET_PARAM_DECL.Line) yyWriteNl ();
}

static void yWriteIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIMPLICIT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->IMPLICIT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->IMPLICIT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("first"); writetIdent (yyt->IMPLICIT_DECL.first) yyWriteNl ();
 yyIndentSelector ("last"); writetIdent (yyt->IMPLICIT_DECL.last) yyWriteNl ();
}

static void yWriteUSE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->USE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->USE_DECL.Line) yyWriteNl ();
 yyIndentSelector ("use"); writetIdent (yyt->USE_DECL.use) yyWriteNl ();
}

static void yWriteONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kONLY_USE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ONLY_USE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ONLY_USE_DECL.Line) yyWriteNl ();
 yyIndentSelector ("use"); writetIdent (yyt->ONLY_USE_DECL.use) yyWriteNl ();
}

static void yWriteEQV_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEQV_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->EQV_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->EQV_DECL.Line) yyWriteNl ();
}

static void yWriteDATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DATA_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DATA_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("VARS", yyt->DATA_DECL.VARS);
}

static void yWriteFORMAT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->FORMAT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->FORMAT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("label"); writeint (yyt->FORMAT_DECL.label) yyWriteNl ();
}

static void yWriteDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIMENSION_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DIMENSION_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DIMENSION_DECL.Line) yyWriteNl ();
}

static void yWriteINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINIT_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INIT_DATA_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INIT_DATA_DECL.Line) yyWriteNl ();
}

static void yWriteTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPESPEC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPESPEC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TYPESPEC_DECL.Line) yyWriteNl ();
}

static void yWriteALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALLOCATABLE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ALLOCATABLE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ALLOCATABLE_DECL.Line) yyWriteNl ();
}

static void yWriteEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXTERNAL_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->EXTERNAL_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->EXTERNAL_DECL.Line) yyWriteNl ();
}

static void yWriteINTENT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTENT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTENT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTENT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("intent"); writeint (yyt->INTENT_DECL.intent) yyWriteNl ();
}

static void yWriteINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTRINSIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTRINSIC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTRINSIC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("generic"); writetIdent (yyt->INTRINSIC_DECL.generic) yyWriteNl ();
 yyIndentSelector ("class"); writeint (yyt->INTRINSIC_DECL.class) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->INTRINSIC_DECL.kind) yyWriteNl ();
}

static void yWriteOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOPTIONAL_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->OPTIONAL_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->OPTIONAL_DECL.Line) yyWriteNl ();
}

static void yWritePOINTER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOINTER_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->POINTER_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->POINTER_DECL.Line) yyWriteNl ();
}

static void yWriteSAVE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSAVE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SAVE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SAVE_DECL.Line) yyWriteNl ();
}

static void yWriteTARGET_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTARGET_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TARGET_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TARGET_DECL.Line) yyWriteNl ();
}

static void yWritePARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPARAMETER_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PARAMETER_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PARAMETER_DECL.Line) yyWriteNl ();
}

static void yWritePUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPUBLIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PUBLIC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PUBLIC_DECL.Line) yyWriteNl ();
}

static void yWritePRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPRIVATE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PRIVATE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PRIVATE_DECL.Line) yyWriteNl ();
}

static void yWriteSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SEQUENCE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SEQUENCE_DECL.Line) yyWriteNl ();
}

static void yWriteDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDISTRIBUTE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DISTRIBUTE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DISTRIBUTE_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("DISTRIBUTION", yyt->DISTRIBUTE_DECL.DISTRIBUTION);
}

static void yWriteALIGN_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALIGN_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ALIGN_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ALIGN_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("ALIGN_SOURCE", yyt->ALIGN_DECL.ALIGN_SOURCE);
}

static void yWriteMAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMAP_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MAP_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MAP_DECL.Line) yyWriteNl ();
}

static void yWriteOVERLAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOVERLAP_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->OVERLAP_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->OVERLAP_DECL.Line) yyWriteNl ();
}

static void yWriteSHARED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSHARED_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SHARED_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SHARED_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->SHARED_DECL.kind) yyWriteNl ();
}

static void yWriteDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDYNAMIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DYNAMIC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DYNAMIC_DECL.Line) yyWriteNl ();
}

static void yWriteTRACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTRACE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TRACE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TRACE_DECL.Line) yyWriteNl ();
}

static void yWriteTREE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTREE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TREE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TREE_DECL.Line) yyWriteNl ();
}

static void yWriteSELECT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SELECT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SELECT_DECL.Line) yyWriteNl ();
}

static void yWriteHPF_SEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kHPF_SEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->HPF_SEQUENCE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->HPF_SEQUENCE_DECL.Line) yyWriteNl ();
}

static void yWriteNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNOSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->NOSEQUENCE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->NOSEQUENCE_DECL.Line) yyWriteNl ();
}

static void yWriteLAYOUT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLAYOUT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->LAYOUT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->LAYOUT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writetStringRef (yyt->LAYOUT_DECL.kind) yyWriteNl ();
}

static void yWritePASS_BY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPASS_BY_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PASS_BY_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PASS_BY_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writetStringRef (yyt->PASS_BY_DECL.kind) yyWriteNl ();
}

static void yWriteMAP_TO_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMAP_TO_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MAP_TO_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MAP_TO_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writetStringRef (yyt->MAP_TO_DECL.kind) yyWriteNl ();
}

static void yWriteDECL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDECL_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->DECL_LIST.Elem);
}

static void yWriteRANGE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRANGE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->RANGE_LIST.Elem);
}

static void yWriteSELECT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECT_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SELECT_LIST.Elem);
}

static void yWriteSELECT_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECT_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("selector"); writeint (yyt->SELECT_SPEC.selector) yyWriteNl ();
}

static void yWriteDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDISTRIBUTION_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->DISTRIBUTION_SPEC.is_descriptive) yyWriteNl ();
}

static void yWriteANY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kANY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->ANY_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteDEFAULT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEFAULT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->DEFAULT_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREPL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->REPL_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNODE_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->NODE_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteDIST_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIST_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->DIST_LIST.Elem);
}

static void yWriteBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteGEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kGEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SIZE", yyt->ARBITRARY_DISTRIBUTION.SIZE);
 yyIndentSelectorTree ("LENGTH", yyt->ARBITRARY_DISTRIBUTION.LENGTH);
}

static void yWritePROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
}

static void yWritePROCESSOR_SUBSET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSOR_SUBSET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SUBTOP", yyt->PROCESSOR_SUBSET.SUBTOP);
 yyIndentSelectorTree ("FULLTOP", yyt->PROCESSOR_SUBSET.FULLTOP);
}

static void yWriteALIGN_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALIGN_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->ALIGN_SPEC.is_descriptive) yyWriteNl ();
 yyIndentSelectorTree ("TEMPNAME", yyt->ALIGN_SPEC.TEMPNAME);
}

static void yWriteID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kID_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("name"); writetIdent (yyt->ID_GENERIC_SPEC.name) yyWriteNl ();
}

static void yWriteOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
}

static void yWriteACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->ACF_LIST.Elem);
}

static void yWriteACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_NODE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_NODE.Line) yyWriteNl ();
}

static void yWriteACF_DUMMY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DUMMY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DUMMY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DUMMY.Line) yyWriteNl ();
}

static void yWriteACF_BASIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_BASIC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_BASIC.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_BASIC.Line) yyWriteNl ();
}

static void yWriteACF_IF
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_IF], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_IF.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_IF.Line) yyWriteNl ();
 yyIndentSelectorTree ("IF_EXP", yyt->ACF_IF.IF_EXP);
 yyIndentSelectorTree ("THEN_PART", yyt->ACF_IF.THEN_PART);
}

static void yWriteACF_WHERE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WHERE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WHERE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WHERE.Line) yyWriteNl ();
 yyIndentSelectorTree ("WHERE_EXP", yyt->ACF_WHERE.WHERE_EXP);
 yyIndentSelectorTree ("TRUE_PART", yyt->ACF_WHERE.TRUE_PART);
}

static void yWriteACF_CASE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_CASE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_CASE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_CASE.Line) yyWriteNl ();
 yyIndentSelectorTree ("CASE_EXP", yyt->ACF_CASE.CASE_EXP);
}

static void yWriteACF_WHILE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WHILE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WHILE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WHILE.Line) yyWriteNl ();
 yyIndentSelectorTree ("WHILE_EXP", yyt->ACF_WHILE.WHILE_EXP);
}

static void yWriteACF_REPEAT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_REPEAT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_REPEAT.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_REPEAT.Line) yyWriteNl ();
 yyIndentSelectorTree ("REPEAT_BODY", yyt->ACF_REPEAT.REPEAT_BODY);
}

static void yWriteACF_LOOP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_LOOP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_LOOP.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_LOOP.Line) yyWriteNl ();
}

static void yWriteACF_DO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DO.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DO.Line) yyWriteNl ();
 yyIndentSelectorTree ("DO_ID", yyt->ACF_DO.DO_ID);
 yyIndentSelectorTree ("DO_RANGE", yyt->ACF_DO.DO_RANGE);
 yyIndentSelectorTree ("DO_BODY", yyt->ACF_DO.DO_BODY);
 yyIndentSelectorTree ("DO_DEP_INFO", yyt->ACF_DO.DO_DEP_INFO);
}

static void yWriteACF_FORALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_FORALL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_FORALL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_FORALL.Line) yyWriteNl ();
 yyIndentSelectorTree ("FORALL_ID", yyt->ACF_FORALL.FORALL_ID);
 yyIndentSelectorTree ("FORALL_RANGE", yyt->ACF_FORALL.FORALL_RANGE);
 yyIndentSelectorTree ("FORALL_BODY", yyt->ACF_FORALL.FORALL_BODY);
 yyIndentSelectorTree ("FORALL_DEP_INFO", yyt->ACF_FORALL.FORALL_DEP_INFO);
}

static void yWriteACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_FLOW_GRAPH], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_FLOW_GRAPH.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_FLOW_GRAPH.Line) yyWriteNl ();
}

static void yWriteACF_ENTRY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ENTRY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ENTRY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ENTRY.Line) yyWriteNl ();
}

static void yWriteACF_HOME
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_HOME], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_HOME.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_HOME.Line) yyWriteNl ();
 yyIndentSelectorTree ("HOME_VAR", yyt->ACF_HOME.HOME_VAR);
 yyIndentSelector ("user_home"); writebool (yyt->ACF_HOME.user_home) yyWriteNl ();
}

static void yWriteACF_RESIDENT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_RESIDENT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_RESIDENT.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_RESIDENT.Line) yyWriteNl ();
 yyIndentSelectorTree ("RESIDENT_VAR", yyt->ACF_RESIDENT.RESIDENT_VAR);
}

static void yWriteACF_NEW
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_NEW], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_NEW.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_NEW.Line) yyWriteNl ();
 yyIndentSelectorTree ("NEW_VAR", yyt->ACF_NEW.NEW_VAR);
}

static void yWriteACF_REDUCTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_REDUCTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_REDUCTION.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_REDUCTION.Line) yyWriteNl ();
 yyIndentSelector ("is_zero"); writebool (yyt->ACF_REDUCTION.is_zero) yyWriteNl ();
 yyIndentSelectorTree ("REDUCTION_VAR", yyt->ACF_REDUCTION.REDUCTION_VAR);
 yyIndentSelectorTree ("REDUCTION_LVAR", yyt->ACF_REDUCTION.REDUCTION_LVAR);
 yyIndentSelectorTree ("REDUCTION_FUNC", yyt->ACF_REDUCTION.REDUCTION_FUNC);
}

static void yWriteACF_TASK_REGION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_TASK_REGION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_TASK_REGION.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_TASK_REGION.Line) yyWriteNl ();
 yyIndentSelector ("task_flag"); writeint (yyt->ACF_TASK_REGION.task_flag) yyWriteNl ();
}

static void yWriteACF_PARALLEL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_PARALLEL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_PARALLEL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_PARALLEL.Line) yyWriteNl ();
 yyIndentSelectorTree ("REDUCTION_VARS", yyt->ACF_PARALLEL.REDUCTION_VARS);
 yyIndentSelectorTree ("SHARED_VARS", yyt->ACF_PARALLEL.SHARED_VARS);
 yyIndentSelectorTree ("LOCAL_VARS", yyt->ACF_PARALLEL.LOCAL_VARS);
}

static void yWriteACF_CRITICAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_CRITICAL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_CRITICAL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_CRITICAL.Line) yyWriteNl ();
}

static void yWriteACF_ON
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ON], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ON.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ON.Line) yyWriteNl ();
 yyIndentSelectorTree ("ON_HOME", yyt->ACF_ON.ON_HOME);
 yyIndentSelectorTree ("ON_SPECS", yyt->ACF_ON.ON_SPECS);
}

static void yWriteACF_RM_READ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_RM_READ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_RM_READ.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_RM_READ.Line) yyWriteNl ();
 yyIndentSelectorTree ("LOCAL_VAR", yyt->ACF_RM_READ.LOCAL_VAR);
}

static void yWriteACF_RM_WRITE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_RM_WRITE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_RM_WRITE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_RM_WRITE.Line) yyWriteNl ();
 yyIndentSelector ("op"); writeint (yyt->ACF_RM_WRITE.op) yyWriteNl ();
 yyIndentSelectorTree ("REMOTE_VAR", yyt->ACF_RM_WRITE.REMOTE_VAR);
}

static void yWriteACF_MOVE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_MOVE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_MOVE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_MOVE.Line) yyWriteNl ();
}

static void yWriteACF_BARRIER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_BARRIER], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_BARRIER.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_BARRIER.Line) yyWriteNl ();
}

static void yWriteACF_UPDATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_UPDATE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_UPDATE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_UPDATE.Line) yyWriteNl ();
}

static void yWriteON_VAR_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_VAR_CLAUSE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteON_PROC_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_PROC_CLAUSE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteON_PROCS
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_PROCS], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("topid"); writetObject (yyt->ON_PROCS.topid) yyWriteNl ();
}

static void yWriteON_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("topid"); writetObject (yyt->ON_VAR.topid) yyWriteNl ();
 yyIndentSelector ("tempid"); writetObject (yyt->ON_VAR.tempid) yyWriteNl ();
 yyIndentSelector ("arrayid"); writetObject (yyt->ON_VAR.arrayid) yyWriteNl ();
}

static void yWriteON_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->ON_LIST.Elem);
}

static void yWriteON_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("top_dim"); writeint (yyt->ON_SPEC.top_dim) yyWriteNl ();
 yyIndentSelector ("temp_dim"); writeint (yyt->ON_SPEC.temp_dim) yyWriteNl ();
 yyIndentSelector ("array_dim"); writeint (yyt->ON_SPEC.array_dim) yyWriteNl ();
}

static void yWriteSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_ACF_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SELECTED_ACF_LIST.Elem);
}

static void yWriteSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELECT_LIST", yyt->SELECTED_ACF_NODE.SELECT_LIST);
}

static void yWriteASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_VAR", yyt->ASSIGN_STMT.ASSIGN_VAR);
}

static void yWritePTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPTR_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_VAR", yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
}

static void yWriteLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLABEL_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("assign_label"); writeint (yyt->LABEL_ASSIGN_STMT.assign_label) yyWriteNl ();
}

static void yWriteCALL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCALL_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("CALL_ID", yyt->CALL_STMT.CALL_ID);
}

static void yWriteIO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->IO_STMT.ID);
 yyIndentSelectorTree ("IO_SPECS", yyt->IO_STMT.IO_SPECS);
}

static void yWriteGOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kGOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("GOTO_LABEL"); writeint (yyt->GOTO_STMT.GOTO_LABEL) yyWriteNl ();
}

static void yWriteASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASS_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("GOTO_VAR", yyt->ASS_GOTO_STMT.GOTO_VAR);
}

static void yWriteCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("GOTO_LABELS", yyt->COMP_GOTO_STMT.GOTO_LABELS);
}

static void yWriteCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_IF_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("IF_LT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_LT_LABEL) yyWriteNl ();
 yyIndentSelector ("IF_EQ_LABEL"); writeint (yyt->COMP_IF_STMT.IF_EQ_LABEL) yyWriteNl ();
 yyIndentSelector ("IF_GT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_GT_LABEL) yyWriteNl ();
}

static void yWriteRETURN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRETURN_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWritePAUSE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPAUSE_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteEXIT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXIT_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("loopid"); writetIdent (yyt->EXIT_STMT.loopid) yyWriteNl ();
}

static void yWriteCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCYCLE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("loopid"); writetIdent (yyt->CYCLE_STMT.loopid) yyWriteNl ();
}

static void yWriteSTOP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTOP_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINHERIT_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINHERIT_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("VAR", yyt->INHERIT_DSP_STMT.VAR);
 yyIndentSelector ("flag"); writeint (yyt->INHERIT_DSP_STMT.flag) yyWriteNl ();
 yyIndentSelector ("safety"); writeint (yyt->INHERIT_DSP_STMT.safety) yyWriteNl ();
}

static void yWriteCREATE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCREATE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("VAR", yyt->CREATE_DSP_STMT.VAR);
 yyIndentSelector ("flag"); writeint (yyt->CREATE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteFREE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFREE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("flag"); writeint (yyt->FREE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("PARAMS", yyt->ALLOCATE_STMT.PARAMS);
}

static void yWriteDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("PARAMS", yyt->DEALLOCATE_STMT.PARAMS);
}

static void yWriteNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNULLIFY_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDUCE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("RED_FUNC", yyt->REDUCE_STMT.RED_FUNC);
}

static void yWriteMOVE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMOVE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("TARGET", yyt->MOVE_STMT.TARGET);
 yyIndentSelectorTree ("SOURCE", yyt->MOVE_STMT.SOURCE);
}

static void yWriteSCATTER_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSCATTER_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("func"); writetIdent (yyt->SCATTER_STMT.func) yyWriteNl ();
 yyIndentSelectorTree ("ARRAY", yyt->SCATTER_STMT.ARRAY);
 yyIndentSelectorTree ("BASE", yyt->SCATTER_STMT.BASE);
 yyIndentSelectorTree ("INDEXES", yyt->SCATTER_STMT.INDEXES);
}

static void yWriteREALIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREALIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ALIGNEE", yyt->REALIGN_STMT.ALIGNEE);
 yyIndentSelectorTree ("ALIGN_SOURCE", yyt->REALIGN_STMT.ALIGN_SOURCE);
 yyIndentSelector ("distribution"); writetDefinitions (yyt->REALIGN_STMT.distribution) yyWriteNl ();
}

static void yWriteREDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDISTRIBUTE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DISTRIBUTEE", yyt->REDISTRIBUTE_STMT.DISTRIBUTEE);
 yyIndentSelectorTree ("DISTRIBUTION", yyt->REDISTRIBUTE_STMT.DISTRIBUTION);
 yyIndentSelector ("distribution"); writetDefinitions (yyt->REDISTRIBUTE_STMT.distribution) yyWriteNl ();
}

static void yWriteREG_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREG_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SHADOW_VAR", yyt->REG_SHADOW_GET.SHADOW_VAR);
}

static void yWriteREG_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREG_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("op"); writeint (yyt->REG_SHADOW_PUT.op) yyWriteNl ();
 yyIndentSelectorTree ("SHADOW_VAR", yyt->REG_SHADOW_PUT.SHADOW_VAR);
}

static void yWriteREG_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREG_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SHADOW_VAR", yyt->REG_SHADOW_SET.SHADOW_VAR);
 yyIndentSelectorTree ("SHADOW_SIZE", yyt->REG_SHADOW_SET.SHADOW_SIZE);
}

static void yWriteIND_SHADOW_CREATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_CREATE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_CREATE.id) yyWriteNl ();
 yyIndentSelectorTree ("SHADOW_VAR", yyt->IND_SHADOW_CREATE.SHADOW_VAR);
 yyIndentSelectorTree ("INDEX_VAR", yyt->IND_SHADOW_CREATE.INDEX_VAR);
 yyIndentSelectorTree ("TMP_INDEX_VAR", yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR);
}

static void yWriteIND_SHADOW_FREE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_FREE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_FREE.id) yyWriteNl ();
}

static void yWriteIND_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_GET.id) yyWriteNl ();
}

static void yWriteIND_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_PUT.id) yyWriteNl ();
 yyIndentSelector ("op"); writeint (yyt->IND_SHADOW_PUT.op) yyWriteNl ();
}

static void yWriteIND_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_SET.id) yyWriteNl ();
 yyIndentSelectorTree ("SHADOW_VAR", yyt->IND_SHADOW_SET.SHADOW_VAR);
}

static void yWriteBROADCAST_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBROADCAST_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ELEMS", yyt->BROADCAST_STMT.ELEMS);
 yyIndentSelectorTree ("OWNER_TOP", yyt->BROADCAST_STMT.OWNER_TOP);
}

static void yWriteREDUCTION_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDUCTION_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("REDFUNC", yyt->REDUCTION_STMT.REDFUNC);
 yyIndentSelectorTree ("ELEMS", yyt->REDUCTION_STMT.ELEMS);
 yyIndentSelectorTree ("RED_TOP", yyt->REDUCTION_STMT.RED_TOP);
}

static void yWriteDIRTY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIRTY_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteLABEL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLABEL_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Elem"); writeint (yyt->LABEL_LIST.Elem) yyWriteNl ();
}

static void yWriteOP_DEFINED
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_DEFINED], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("opname"); writetIdent (yyt->OP_DEFINED.opname) yyWriteNl ();
}

static void yWriteCONST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCONST_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteOP_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("EXP_OP", yyt->OP_EXP.EXP_OP);
 yyIndentSelectorTree ("OPND1", yyt->OP_EXP.OPND1);
}

static void yWriteOP1_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP1_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("EXP_OP1", yyt->OP1_EXP.EXP_OP1);
}

static void yWriteSLICE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSLICE_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("START", yyt->SLICE_EXP.START);
 yyIndentSelectorTree ("STOP", yyt->SLICE_EXP.STOP);
}

static void yWriteVAR_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_CALL_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("FUNC_ID", yyt->FUNC_CALL_EXP.FUNC_ID);
}

static void yWriteNAMED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMED_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMED_EXP.Name) yyWriteNl ();
}

static void yWriteDO_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDO_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DO_ID", yyt->DO_EXP.DO_ID);
 yyIndentSelectorTree ("RANGE", yyt->DO_EXP.RANGE);
}

static void yWriteTYPE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->TYPE_EXP.ID);
}

static void yWriteARRAY_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWritePERM_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPERM_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("perm"); writePermutation (yyt->PERM_EXP.perm) yyWriteNl ();
}

static void yWriteBOUND_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOUND_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("dim"); writeint (yyt->BOUND_EXP.dim) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->BOUND_EXP.kind) yyWriteNl ();
 yyIndentSelector ("local"); writeint (yyt->BOUND_EXP.local) yyWriteNl ();
}

static void yWriteRANK_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRANK_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("kind"); writeint (yyt->RANK_EXP.kind) yyWriteNl ();
}

static void yWriteBTE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTE_LIST.Elem);
}

static void yWriteUSED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSED_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEXED_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_VAR", yyt->INDEXED_VAR.IND_VAR);
}

static void yWriteSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSUBSTRING_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_VAR", yyt->SUBSTRING_VAR.IND_VAR);
}

static void yWriteSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELEC_VAR", yyt->SELECTED_VAR.SELEC_VAR);
}

static void yWriteLOOP_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLOOP_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWritePERM_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPERM_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("perm"); writePermutation (yyt->PERM_VAR.perm) yyWriteNl ();
}

static void yWriteADDR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kADDR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteDO_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDO_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DO_ID", yyt->DO_VAR.DO_ID);
 yyIndentSelectorTree ("RANGE", yyt->DO_VAR.RANGE);
}

static void yWriteREMOTE_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREMOTE_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBTV_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTV_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTV_LIST.Elem);
}

static void yWriteVAR_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("formal"); writetDefinitions (yyt->VAR_PARAM.formal) yyWriteNl ();
 yyIndentSelector ("intent"); writeint (yyt->VAR_PARAM.intent) yyWriteNl ();
 yyIndentSelector ("layout"); writeint (yyt->VAR_PARAM.layout) yyWriteNl ();
 yyIndentSelector ("pass_by"); writeint (yyt->VAR_PARAM.pass_by) yyWriteNl ();
 yyIndentSelector ("trace"); writeint (yyt->VAR_PARAM.trace) yyWriteNl ();
}

static void yWriteVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVALUE_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMED_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMED_PARAM.Name) yyWriteNl ();
}

static void yWritePROC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("S"); writetStringRef (yyt->FORMAT_PARAM.S) yyWriteNl ();
}

static void yWriteRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRETURN_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("label"); writeint (yyt->RETURN_PARAM.label) yyWriteNl ();
}

static void yWriteNO_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNO_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("type"); writeint (yyt->NO_PARAM.type) yyWriteNl ();
}

static void yWriteBTP_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTP_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTP_LIST.Elem);
}

static void yWriteBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOOL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writeint (yyt->BOOL_CONSTANT.value) yyWriteNl ();
}

static void yWriteINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINT_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writeint (yyt->INT_CONSTANT.value) yyWriteNl ();
}

static void yWriteREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->REAL_CONSTANT.value) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->REAL_CONSTANT.kind) yyWriteNl ();
}

static void yWriteSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTRING_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->STRING_CONSTANT.value) yyWriteNl ();
}

static void yWriteCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMPLEX_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("rvalue"); writetStringRef (yyt->COMPLEX_CONSTANT.rvalue) yyWriteNl ();
 yyIndentSelector ("ivalue"); writetStringRef (yyt->COMPLEX_CONSTANT.ivalue) yyWriteNl ();
}

static void yWritePROC_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROC_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROC_OBJ.Object) yyWriteNl ();
}

static void yWriteVAR_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writeint (yyt->VAR_OBJ.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->VAR_OBJ.Object) yyWriteNl ();
 yyIndentSelector ("Reaching"); writetReaching (yyt->VAR_OBJ.Reaching) yyWriteNl ();
}

static void yWriteTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPE_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TYPE_OBJ.Object) yyWriteNl ();
}

static void yWriteREC_COMP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREC_COMP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->REC_COMP.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->REC_COMP.Object) yyWriteNl ();
}

static void yWriteTOP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTOP_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TOP_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TOP_OBJ.Object) yyWriteNl ();
}

static void yWriteTEMP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTEMP_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TEMP_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TEMP_OBJ.Object) yyWriteNl ();
}

static void yWriteOVERLAP_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOVERLAP_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("left_size"); writeint (yyt->OVERLAP_SPEC.left_size) yyWriteNl ();
 yyIndentSelector ("right_size"); writeint (yyt->OVERLAP_SPEC.right_size) yyWriteNl ();
 yyIndentSelector ("left_update"); writeint (yyt->OVERLAP_SPEC.left_update) yyWriteNl ();
 yyIndentSelector ("right_update"); writeint (yyt->OVERLAP_SPEC.right_update) yyWriteNl ();
}

static void yWriteINDEP_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEP_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("user_independent"); writebool (yyt->INDEP_INFO.user_independent) yyWriteNl ();
 yyIndentSelector ("selection"); writeint (yyt->INDEP_INFO.selection) yyWriteNl ();
 yyIndentSelector ("red_vars"); writeInfoTree (yyt->INDEP_INFO.red_vars) yyWriteNl ();
 yyIndentSelector ("new_vars"); writeInfoTree (yyt->INDEP_INFO.new_vars) yyWriteNl ();
}

static void yWriteVECTOR_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVECTOR_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_independent"); writebool (yyt->VECTOR_INFO.is_independent) yyWriteNl ();
 yyIndentSelector ("selection"); writeint (yyt->VECTOR_INFO.selection) yyWriteNl ();
 yyIndentSelector ("loop_cnt"); writeint (yyt->VECTOR_INFO.loop_cnt) yyWriteNl ();
 yyIndentSelector ("independent_vars"); writeInfoTree (yyt->VECTOR_INFO.independent_vars) yyWriteNl ();
}

static void yWriteCOMM_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMM_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("home_var"); writeInfoTree (yyt->COMM_INFO.home_var) yyWriteNl ();
 yyIndentSelector ("is_local"); writebool (yyt->COMM_INFO.is_local) yyWriteNl ();
}

static void yWriteON_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("on_id"); writetObject (yyt->ON_INFO.on_id) yyWriteNl ();
 yyIndentSelector ("on_dim"); writeint (yyt->ON_INFO.on_dim) yyWriteNl ();
 yyIndentSelector ("base"); writeint (yyt->ON_INFO.base) yyWriteNl ();
 yyIndentSelector ("stride"); writeint (yyt->ON_INFO.stride) yyWriteNl ();
}

static void yWritePARALLEL_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPARALLEL_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("reduction_vars"); writeInfoTree (yyt->PARALLEL_INFO.reduction_vars) yyWriteNl ();
 yyIndentSelector ("home_var"); writeInfoTree (yyt->PARALLEL_INFO.home_var) yyWriteNl ();
 yyIndentSelector ("new_vars"); writeInfoTree (yyt->PARALLEL_INFO.new_vars) yyWriteNl ();
 yyIndentSelector ("resident_vars"); writeInfoTree (yyt->PARALLEL_INFO.resident_vars) yyWriteNl ();
}

static void yWriteREACHING_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREACHING_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("var_allocate"); writeInfoTree (yyt->REACHING_INFO.var_allocate) yyWriteNl ();
 yyIndentSelector ("temp_allocate"); writeInfoTree (yyt->REACHING_INFO.temp_allocate) yyWriteNl ();
 yyIndentSelector ("var_distribution"); writetDefinitions (yyt->REACHING_INFO.var_distribution) yyWriteNl ();
 yyIndentSelector ("temp_distribution"); writetDefinitions (yyt->REACHING_INFO.temp_distribution) yyWriteNl ();
}

static void yyWriteTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoTree) { (void) fputs (" NoTree\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kCOMP_UNIT: yWriteCOMP_UNIT (yyt); yyIndentSelector ("USED_ELEMENTS"); yyt = yyt->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_NODE_LIST: (void) fputs (Tree_NodeName [kUNIT_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUNIT_EMPTY: (void) fputs (Tree_NodeName [kUNIT_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUNIT_LIST: yWriteUNIT_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->UNIT_LIST.Next; break;
case kUNIT_NODE: yWriteUNIT_NODE (yyt); goto yyExit;
case kMODULE_DECL: yWriteMODULE_DECL (yyt); yyIndentSelector ("MODULE_BODY"); yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL: yWritePROGRAM_DECL (yyt); yyIndentSelector ("PROGRAM_BODY"); yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL: yWritePROC_DECL (yyt); yyIndentSelector ("PROC_BODY"); yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL: yWriteFUNC_DECL (yyt); yyIndentSelector ("RESULT_TYPE"); yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kMODULE_PROC_DECL: yWriteMODULE_PROC_DECL (yyt); goto yyExit;
case kBLOCK_DATA_DECL: yWriteBLOCK_DATA_DECL (yyt); yyIndentSelector ("DATA_BODY"); yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE: yWriteINTERFACE (yyt); yyIndentSelector ("ITEMS"); yyt = yyt->INTERFACE.ITEMS; break;
case kBODY_NODE: yWriteBODY_NODE (yyt); yyIndentSelector ("INTERNALS"); yyt = yyt->BODY_NODE.INTERNALS; break;
case kTYPE_NODE: (void) fputs (Tree_NodeName [kTYPE_NODE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_TYPE: (void) fputs (Tree_NodeName [kDUMMY_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kALIGN_TYPE: (void) fputs (Tree_NodeName [kALIGN_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kINTEGER_TYPE: yWriteINTEGER_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE: yWriteREAL_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE: yWriteBOOLEAN_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE: yWriteCOMPLEX_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE: yWriteSTRING_TYPE (yyt); yyIndentSelector ("LENGTH"); yyt = yyt->STRING_TYPE.LENGTH; break;
case kTYPE_ID: yWriteTYPE_ID (yyt); yyIndentSelector ("ID"); yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE: yWriteARRAY_TYPE (yyt); yyIndentSelector ("ARRAY_COMP_TYPE"); yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE: yWriteRECORD_TYPE (yyt); yyIndentSelector ("COMPONENTS"); yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE: yWritePOINTER_TYPE (yyt); yyIndentSelector ("PTR_COMP"); yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC: yWriteSHAPE_SPEC (yyt); yyIndentSelector ("Overlap"); yyt = yyt->SHAPE_SPEC.Overlap; break;
case kEXPLICIT_SHAPE: yWriteEXPLICIT_SHAPE (yyt); yyIndentSelector ("UPPER"); yyt = yyt->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE: yWriteASSUMED_SHAPE (yyt); yyIndentSelector ("LOWER"); yyt = yyt->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE: yWriteDEFERRED_SHAPE (yyt); yyIndentSelector ("Overlap"); yyt = yyt->DEFERRED_SHAPE.Overlap; break;
case kASSUMED_SIZE: yWriteASSUMED_SIZE (yyt); yyIndentSelector ("LOWER"); yyt = yyt->ASSUMED_SIZE.LOWER; break;
case kSHAPE_SPEC_LIST: (void) fputs (Tree_NodeName [kSHAPE_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSHAPE_EMPTY: (void) fputs (Tree_NodeName [kSHAPE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSHAPE_LIST: yWriteSHAPE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SHAPE_LIST.Next; break;
case kDECL_NODE: yWriteDECL_NODE (yyt); goto yyExit;
case kTYPE_DECL: yWriteTYPE_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->TYPE_DECL.VAL; break;
case kNAME_DECL: yWriteNAME_DECL (yyt); goto yyExit;
case kRENAME_DECL: yWriteRENAME_DECL (yyt); goto yyExit;
case kENTITY_DECL: yWriteENTITY_DECL (yyt); yyIndentSelector ("ATTRIBUTES"); yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL: yWriteVAR_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL: yWriteCOMMON_DECL (yyt); yyIndentSelector ("IDS"); yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL: yWriteNAMELIST_DECL (yyt); yyIndentSelector ("IDS"); yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL: yWriteTEMPLATE_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL: yWriteRAGGED_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL: yWritePROCESSORS_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL: yWriteSUB_PROCS_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->SUB_PROCS_DECL.DIMENSIONS; break;
case kINHERIT_DECL: yWriteINHERIT_DECL (yyt); goto yyExit;
case kRANGE_DECL: yWriteRANGE_DECL (yyt); yyIndentSelector ("RANGES"); yyt = yyt->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL: yWriteSTMT_FUNC_DECL (yyt); yyIndentSelector ("FFUNC_BODY"); yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL: yWriteINTERFACE_DECL (yyt); yyIndentSelector ("ITEMS"); yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL: yWriteVAR_PARAM_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kRET_PARAM_DECL: yWriteRET_PARAM_DECL (yyt); goto yyExit;
case kIMPLICIT_DECL: yWriteIMPLICIT_DECL (yyt); yyIndentSelector ("TYPE"); yyt = yyt->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL: yWriteUSE_DECL (yyt); yyIndentSelector ("RENAMINGS"); yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL: yWriteONLY_USE_DECL (yyt); yyIndentSelector ("NAMES"); yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL: yWriteEQV_DECL (yyt); yyIndentSelector ("VARS"); yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL: yWriteDATA_DECL (yyt); yyIndentSelector ("VALS"); yyt = yyt->DATA_DECL.VALS; break;
case kFORMAT_DECL: yWriteFORMAT_DECL (yyt); yyIndentSelector ("FORMAT_PARAMS"); yyt = yyt->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL: yWriteDIMENSION_DECL (yyt); yyIndentSelector ("INDEXES"); yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL: yWriteINIT_DATA_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL: yWriteTYPESPEC_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->TYPESPEC_DECL.VAL; break;
case kALLOCATABLE_DECL: yWriteALLOCATABLE_DECL (yyt); goto yyExit;
case kEXTERNAL_DECL: yWriteEXTERNAL_DECL (yyt); goto yyExit;
case kINTENT_DECL: yWriteINTENT_DECL (yyt); goto yyExit;
case kINTRINSIC_DECL: yWriteINTRINSIC_DECL (yyt); goto yyExit;
case kOPTIONAL_DECL: yWriteOPTIONAL_DECL (yyt); goto yyExit;
case kPOINTER_DECL: yWritePOINTER_DECL (yyt); goto yyExit;
case kSAVE_DECL: yWriteSAVE_DECL (yyt); goto yyExit;
case kTARGET_DECL: yWriteTARGET_DECL (yyt); goto yyExit;
case kPARAMETER_DECL: yWritePARAMETER_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->PARAMETER_DECL.VAL; break;
case kPUBLIC_DECL: yWritePUBLIC_DECL (yyt); goto yyExit;
case kPRIVATE_DECL: yWritePRIVATE_DECL (yyt); goto yyExit;
case kSEQUENCE_DECL: yWriteSEQUENCE_DECL (yyt); goto yyExit;
case kDISTRIBUTE_DECL: yWriteDISTRIBUTE_DECL (yyt); yyIndentSelector ("TARGET"); yyt = yyt->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL: yWriteALIGN_DECL (yyt); yyIndentSelector ("ALIGN_TARGET"); yyt = yyt->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL: yWriteMAP_DECL (yyt); yyIndentSelector ("MAP_TARGET"); yyt = yyt->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL: yWriteOVERLAP_DECL (yyt); yyIndentSelector ("OVERLAPS"); yyt = yyt->OVERLAP_DECL.OVERLAPS; break;
case kSHARED_DECL: yWriteSHARED_DECL (yyt); goto yyExit;
case kDYNAMIC_DECL: yWriteDYNAMIC_DECL (yyt); goto yyExit;
case kTRACE_DECL: yWriteTRACE_DECL (yyt); goto yyExit;
case kTREE_DECL: yWriteTREE_DECL (yyt); goto yyExit;
case kSELECT_DECL: yWriteSELECT_DECL (yyt); yyIndentSelector ("SELECTIONS"); yyt = yyt->SELECT_DECL.SELECTIONS; break;
case kHPF_SEQUENCE_DECL: yWriteHPF_SEQUENCE_DECL (yyt); goto yyExit;
case kNOSEQUENCE_DECL: yWriteNOSEQUENCE_DECL (yyt); goto yyExit;
case kLAYOUT_DECL: yWriteLAYOUT_DECL (yyt); goto yyExit;
case kPASS_BY_DECL: yWritePASS_BY_DECL (yyt); goto yyExit;
case kMAP_TO_DECL: yWriteMAP_TO_DECL (yyt); goto yyExit;
case kDECL_NODE_LIST: (void) fputs (Tree_NodeName [kDECL_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDECL_EMPTY: (void) fputs (Tree_NodeName [kDECL_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDECL_LIST: yWriteDECL_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->DECL_LIST.Next; break;
case kRANGE_SPEC_LIST: (void) fputs (Tree_NodeName [kRANGE_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRANGE_EMPTY: (void) fputs (Tree_NodeName [kRANGE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRANGE_LIST: yWriteRANGE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->RANGE_LIST.Next; break;
case kSELECT_SPEC_LIST: (void) fputs (Tree_NodeName [kSELECT_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECT_EMPTY: (void) fputs (Tree_NodeName [kSELECT_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECT_LIST: yWriteSELECT_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SELECT_LIST.Next; break;
case kSELECT_SPEC: yWriteSELECT_SPEC (yyt); goto yyExit;
case kDISTRIBUTION_SPEC: yWriteDISTRIBUTION_SPEC (yyt); goto yyExit;
case kANY_DISTRIBUTION: yWriteANY_DISTRIBUTION (yyt); goto yyExit;
case kDEFAULT_DISTRIBUTION: yWriteDEFAULT_DISTRIBUTION (yyt); goto yyExit;
case kREPL_DISTRIBUTION: yWriteREPL_DISTRIBUTION (yyt); goto yyExit;
case kNODE_DISTRIBUTION: yWriteNODE_DISTRIBUTION (yyt); yyIndentSelector ("MAPPING"); yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_FORMAT_LIST: (void) fputs (Tree_NodeName [kDIST_FORMAT_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_EMPTY: (void) fputs (Tree_NodeName [kDIST_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_LIST: yWriteDIST_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->DIST_LIST.Next; break;
case kDISTRIBUTION_FORMAT: (void) fputs (Tree_NodeName [kDISTRIBUTION_FORMAT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBLOCK_DISTRIBUTION: yWriteBLOCK_DISTRIBUTION (yyt); yyIndentSelector ("SIZE"); yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION: yWriteCYCLIC_DISTRIBUTION (yyt); yyIndentSelector ("SIZE"); yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION: yWriteGEN_BLOCK_DISTRIBUTION (yyt); yyIndentSelector ("ARRAY"); yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION: yWriteINDIRECT_DISTRIBUTION (yyt); yyIndentSelector ("ARRAY"); yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION: yWriteARBITRARY_DISTRIBUTION (yyt); yyIndentSelector ("MAP"); yyt = yyt->ARBITRARY_DISTRIBUTION.MAP; break;
case kSERIAL_DISTRIBUTION: (void) fputs (Tree_NodeName [kSERIAL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_CYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_CYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_GEN_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_GEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_INDIRECT_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_INDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_ARBITRARY_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_ARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_DIM_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_DIM_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kPROCESSOR_SPEC: (void) fputs (Tree_NodeName [kPROCESSOR_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kANY_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDEFAULT_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kDEFAULT_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kPROCESSOR_ARRAY: yWritePROCESSOR_ARRAY (yyt); yyIndentSelector ("TOPNAME"); yyt = yyt->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET: yWritePROCESSOR_SUBSET (yyt); yyIndentSelector ("SUBSCRIPTS"); yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC: yWriteALIGN_SPEC (yyt); yyIndentSelector ("SUBSCRIPTS"); yyt = yyt->ALIGN_SPEC.SUBSCRIPTS; break;
case kGENERIC_SPEC: (void) fputs (Tree_NodeName [kGENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNO_GENERIC_SPEC: (void) fputs (Tree_NodeName [kNO_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kID_GENERIC_SPEC: yWriteID_GENERIC_SPEC (yyt); goto yyExit;
case kOP_GENERIC_SPEC: yWriteOP_GENERIC_SPEC (yyt); yyIndentSelector ("OPERATOR"); yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kASSIGN_GENERIC_SPEC: (void) fputs (Tree_NodeName [kASSIGN_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_NODE_LIST: (void) fputs (Tree_NodeName [kACF_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_EMPTY: (void) fputs (Tree_NodeName [kACF_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_LIST: yWriteACF_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->ACF_LIST.Next; break;
case kACF_NODE: yWriteACF_NODE (yyt); goto yyExit;
case kACF_DUMMY: yWriteACF_DUMMY (yyt); goto yyExit;
case kACF_BASIC: yWriteACF_BASIC (yyt); yyIndentSelector ("BASIC_STMT"); yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF: yWriteACF_IF (yyt); yyIndentSelector ("ELSE_PART"); yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE: yWriteACF_WHERE (yyt); yyIndentSelector ("FALSE_PART"); yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_CASE: yWriteACF_CASE (yyt); yyIndentSelector ("CASE_ALTS"); yyt = yyt->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE: yWriteACF_WHILE (yyt); yyIndentSelector ("WHILE_BODY"); yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT: yWriteACF_REPEAT (yyt); yyIndentSelector ("REPEAT_EXP"); yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP: yWriteACF_LOOP (yyt); yyIndentSelector ("LOOP_BODY"); yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO: yWriteACF_DO (yyt); yyIndentSelector ("DO_HOME_INFO"); yyt = yyt->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL: yWriteACF_FORALL (yyt); yyIndentSelector ("FORALL_HOME_INFO"); yyt = yyt->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH: yWriteACF_FLOW_GRAPH (yyt); yyIndentSelector ("FLOW_NODES"); yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY: yWriteACF_ENTRY (yyt); yyIndentSelector ("ENTRY_DECL"); yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME: yWriteACF_HOME (yyt); yyIndentSelector ("HOME_BODY"); yyt = yyt->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT: yWriteACF_RESIDENT (yyt); yyIndentSelector ("RESIDENT_BODY"); yyt = yyt->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW: yWriteACF_NEW (yyt); yyIndentSelector ("NEW_BODY"); yyt = yyt->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION: yWriteACF_REDUCTION (yyt); yyIndentSelector ("REDUCTION_BODY"); yyt = yyt->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION: yWriteACF_TASK_REGION (yyt); yyIndentSelector ("TASK_BODY"); yyt = yyt->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL: yWriteACF_PARALLEL (yyt); yyIndentSelector ("PARALLEL_BODY"); yyt = yyt->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL: yWriteACF_CRITICAL (yyt); yyIndentSelector ("CRITICAL_BODY"); yyt = yyt->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON: yWriteACF_ON (yyt); yyIndentSelector ("ON_BODY"); yyt = yyt->ACF_ON.ON_BODY; break;
case kACF_RM_READ: yWriteACF_RM_READ (yyt); yyIndentSelector ("REMOTE_VAR"); yyt = yyt->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE: yWriteACF_RM_WRITE (yyt); yyIndentSelector ("LOCAL_DATA"); yyt = yyt->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE: yWriteACF_MOVE (yyt); yyIndentSelector ("MOVE_STMT"); yyt = yyt->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER: yWriteACF_BARRIER (yyt); yyIndentSelector ("BARRIER_VARS"); yyt = yyt->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE: yWriteACF_UPDATE (yyt); yyIndentSelector ("OVERLAP_VAR"); yyt = yyt->ACF_UPDATE.OVERLAP_VAR; break;
case kACF_FLOW_KIND: (void) fputs (Tree_NodeName [kACF_FLOW_KIND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_COMPLEX_FLOW: (void) fputs (Tree_NodeName [kACF_COMPLEX_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_INTERVAL_FLOW: (void) fputs (Tree_NodeName [kACF_INTERVAL_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_SIMPLE_FLOW: (void) fputs (Tree_NodeName [kACF_SIMPLE_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_CLAUSE: (void) fputs (Tree_NodeName [kON_CLAUSE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_HOST_CLAUSE: (void) fputs (Tree_NodeName [kON_HOST_CLAUSE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_ALL_CLAUSE: (void) fputs (Tree_NodeName [kON_ALL_CLAUSE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_VAR_CLAUSE: yWriteON_VAR_CLAUSE (yyt); yyIndentSelector ("ON_VAR"); yyt = yyt->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE: yWriteON_PROC_CLAUSE (yyt); yyIndentSelector ("ON_PROC"); yyt = yyt->ON_PROC_CLAUSE.ON_PROC; break;
case kON_TOPOLOGY: (void) fputs (Tree_NodeName [kON_TOPOLOGY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_ALL: (void) fputs (Tree_NodeName [kON_ALL], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_HOST: (void) fputs (Tree_NodeName [kON_HOST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_PROCS: yWriteON_PROCS (yyt); goto yyExit;
case kON_VAR: yWriteON_VAR (yyt); goto yyExit;
case kON_SPEC_LIST: (void) fputs (Tree_NodeName [kON_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_EMPTY: (void) fputs (Tree_NodeName [kON_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_LIST: yWriteON_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->ON_LIST.Next; break;
case kON_SPEC: yWriteON_SPEC (yyt); yyIndentSelector ("ON_VAL"); yyt = yyt->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_NODE_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_EMPTY: (void) fputs (Tree_NodeName [kSELECTED_ACF_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_LIST: yWriteSELECTED_ACF_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE: yWriteSELECTED_ACF_NODE (yyt); yyIndentSelector ("SELECT_ACFS"); yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kBT_STMT: (void) fputs (Tree_NodeName [kBT_STMT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kASSIGN_STMT: yWriteASSIGN_STMT (yyt); yyIndentSelector ("ASSIGN_EXP"); yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT: yWritePTR_ASSIGN_STMT (yyt); yyIndentSelector ("ASSIGN_EXP"); yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT: yWriteLABEL_ASSIGN_STMT (yyt); yyIndentSelector ("LABEL_VAR"); yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT: yWriteCALL_STMT (yyt); yyIndentSelector ("CALL_PARAMS"); yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT: yWriteIO_STMT (yyt); yyIndentSelector ("IO_ITEMS"); yyt = yyt->IO_STMT.IO_ITEMS; break;
case kGOTO_STMT: yWriteGOTO_STMT (yyt); goto yyExit;
case kASS_GOTO_STMT: yWriteASS_GOTO_STMT (yyt); yyIndentSelector ("LABELS"); yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT: yWriteCOMP_GOTO_STMT (yyt); yyIndentSelector ("GOTO_EXP"); yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT: yWriteCOMP_IF_STMT (yyt); yyIndentSelector ("IF_EXP"); yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT: yWriteRETURN_STMT (yyt); yyIndentSelector ("RETURN_EXP"); yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT: yWritePAUSE_STMT (yyt); yyIndentSelector ("PAUSE_CONST"); yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kEXIT_STMT: yWriteEXIT_STMT (yyt); goto yyExit;
case kCYCLE_STMT: yWriteCYCLE_STMT (yyt); goto yyExit;
case kSTOP_STMT: yWriteSTOP_STMT (yyt); yyIndentSelector ("STOP_CONST"); yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT: yWriteFORMAT_STMT (yyt); yyIndentSelector ("FORMAT_PARAMS"); yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT: yWriteINHERIT_DSP_STMT (yyt); yyIndentSelector ("SHAPE"); yyt = yyt->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT: yWriteCREATE_DSP_STMT (yyt); yyIndentSelector ("SHAPE"); yyt = yyt->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT: yWriteFREE_DSP_STMT (yyt); yyIndentSelector ("VAR"); yyt = yyt->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT: yWriteALLOCATE_STMT (yyt); yyIndentSelector ("STATUS"); yyt = yyt->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT: yWriteDEALLOCATE_STMT (yyt); yyIndentSelector ("STATUS"); yyt = yyt->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT: yWriteNULLIFY_STMT (yyt); yyIndentSelector ("PARAMS"); yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT: yWriteREDUCE_STMT (yyt); yyIndentSelector ("RED_PARAMS"); yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT: yWriteMOVE_STMT (yyt); yyIndentSelector ("MASK"); yyt = yyt->MOVE_STMT.MASK; break;
case kSCATTER_STMT: yWriteSCATTER_STMT (yyt); yyIndentSelector ("MASK"); yyt = yyt->SCATTER_STMT.MASK; break;
case kREALIGN_STMT: yWriteREALIGN_STMT (yyt); yyIndentSelector ("ALIGN_TARGET"); yyt = yyt->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT: yWriteREDISTRIBUTE_STMT (yyt); yyIndentSelector ("TARGET"); yyt = yyt->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET: yWriteREG_SHADOW_GET (yyt); yyIndentSelector ("SHADOW_SIZE"); yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT: yWriteREG_SHADOW_PUT (yyt); yyIndentSelector ("SHADOW_SIZE"); yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET: yWriteREG_SHADOW_SET (yyt); yyIndentSelector ("VAL"); yyt = yyt->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE: yWriteIND_SHADOW_CREATE (yyt); yyIndentSelector ("MASK"); yyt = yyt->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE: yWriteIND_SHADOW_FREE (yyt); yyIndentSelector ("INDEX_VAR"); yyt = yyt->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET: yWriteIND_SHADOW_GET (yyt); yyIndentSelector ("SHADOW_VAR"); yyt = yyt->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT: yWriteIND_SHADOW_PUT (yyt); yyIndentSelector ("SHADOW_VAR"); yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET: yWriteIND_SHADOW_SET (yyt); yyIndentSelector ("VAL"); yyt = yyt->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT: yWriteBROADCAST_STMT (yyt); yyIndentSelector ("OWNER_SPEC"); yyt = yyt->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT: yWriteREDUCTION_STMT (yyt); yyIndentSelector ("RED_SPEC"); yyt = yyt->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT: yWriteDIRTY_STMT (yyt); yyIndentSelector ("ELEMS"); yyt = yyt->DIRTY_STMT.ELEMS; break;
case kLABEL_USE_LIST: (void) fputs (Tree_NodeName [kLABEL_USE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLABEL_EMPTY: (void) fputs (Tree_NodeName [kLABEL_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLABEL_LIST: yWriteLABEL_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->LABEL_LIST.Next; break;
case kOP: (void) fputs (Tree_NodeName [kOP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EQ: (void) fputs (Tree_NodeName [kOP_EQ], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_NE: (void) fputs (Tree_NodeName [kOP_NE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LT: (void) fputs (Tree_NodeName [kOP_LT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_GT: (void) fputs (Tree_NodeName [kOP_GT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_GE: (void) fputs (Tree_NodeName [kOP_GE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LE: (void) fputs (Tree_NodeName [kOP_LE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_PLUS: (void) fputs (Tree_NodeName [kOP_PLUS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_MINUS: (void) fputs (Tree_NodeName [kOP_MINUS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_XOR: (void) fputs (Tree_NodeName [kOP_XOR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_OR: (void) fputs (Tree_NodeName [kOP_OR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_CONCAT: (void) fputs (Tree_NodeName [kOP_CONCAT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_TIMES: (void) fputs (Tree_NodeName [kOP_TIMES], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DIVIDE: (void) fputs (Tree_NodeName [kOP_DIVIDE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_AND: (void) fputs (Tree_NodeName [kOP_AND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EQV: (void) fputs (Tree_NodeName [kOP_EQV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_NEQV: (void) fputs (Tree_NodeName [kOP_NEQV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EXPO: (void) fputs (Tree_NodeName [kOP_EXPO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DEFINED: yWriteOP_DEFINED (yyt); goto yyExit;
case kOP_ASSIGN: (void) fputs (Tree_NodeName [kOP_ASSIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_NOT: (void) fputs (Tree_NodeName [kOP1_NOT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_SIGN: (void) fputs (Tree_NodeName [kOP1_SIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_PSIGN: (void) fputs (Tree_NodeName [kOP1_PSIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBT_EXP: (void) fputs (Tree_NodeName [kBT_EXP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_EXP: (void) fputs (Tree_NodeName [kDUMMY_EXP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCONST_EXP: yWriteCONST_EXP (yyt); yyIndentSelector ("C"); yyt = yyt->CONST_EXP.C; break;
case kOP_EXP: yWriteOP_EXP (yyt); yyIndentSelector ("OPND2"); yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP: yWriteOP1_EXP (yyt); yyIndentSelector ("OPND"); yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP: yWriteSLICE_EXP (yyt); yyIndentSelector ("INC"); yyt = yyt->SLICE_EXP.INC; break;
case kVAR_EXP: yWriteVAR_EXP (yyt); yyIndentSelector ("V"); yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP: yWriteFUNC_CALL_EXP (yyt); yyIndentSelector ("FUNC_PARAMS"); yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP: yWriteNAMED_EXP (yyt); yyIndentSelector ("VAL"); yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP: yWriteDO_EXP (yyt); yyIndentSelector ("BODY"); yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP: yWriteTYPE_EXP (yyt); yyIndentSelector ("ELEMENTS"); yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP: yWriteARRAY_EXP (yyt); yyIndentSelector ("ELEMENTS"); yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP: yWritePERM_EXP (yyt); yyIndentSelector ("VAL"); yyt = yyt->PERM_EXP.VAL; break;
case kBOUND_EXP: yWriteBOUND_EXP (yyt); yyIndentSelector ("VAR"); yyt = yyt->BOUND_EXP.VAR; break;
case kRANK_EXP: yWriteRANK_EXP (yyt); goto yyExit;
case kBT_EXP_LIST: (void) fputs (Tree_NodeName [kBT_EXP_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTE_EMPTY: (void) fputs (Tree_NodeName [kBTE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTE_LIST: yWriteBTE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTE_LIST.Next; break;
case kBT_VAR: (void) fputs (Tree_NodeName [kBT_VAR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_VAR: (void) fputs (Tree_NodeName [kDUMMY_VAR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUSED_VAR: yWriteUSED_VAR (yyt); yyIndentSelector ("VARNAME"); yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR: yWriteINDEXED_VAR (yyt); yyIndentSelector ("IND_EXPS"); yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR: yWriteSUBSTRING_VAR (yyt); yyIndentSelector ("IND_EXP"); yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR: yWriteSELECTED_VAR (yyt); yyIndentSelector ("SELECTOR"); yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR: yWriteLOOP_VAR (yyt); yyIndentSelector ("LOOP_VARNAME"); yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR: yWritePERM_VAR (yyt); yyIndentSelector ("VAL"); yyt = yyt->PERM_VAR.VAL; break;
case kADDR: yWriteADDR (yyt); yyIndentSelector ("E"); yyt = yyt->ADDR.E; break;
case kDO_VAR: yWriteDO_VAR (yyt); yyIndentSelector ("BODY"); yyt = yyt->DO_VAR.BODY; break;
case kREMOTE_VAR: yWriteREMOTE_VAR (yyt); yyIndentSelector ("VAR"); yyt = yyt->REMOTE_VAR.VAR; break;
case kBT_VAR_LIST: (void) fputs (Tree_NodeName [kBT_VAR_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTV_EMPTY: (void) fputs (Tree_NodeName [kBTV_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTV_LIST: yWriteBTV_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTV_LIST.Next; break;
case kBT_PARAM: (void) fputs (Tree_NodeName [kBT_PARAM], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kVAR_PARAM: yWriteVAR_PARAM (yyt); yyIndentSelector ("V"); yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM: yWriteVALUE_PARAM (yyt); yyIndentSelector ("E"); yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM: yWriteNAMED_PARAM (yyt); yyIndentSelector ("VAL"); yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM: yWritePROC_PARAM (yyt); yyIndentSelector ("P"); yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM: yWriteFUNC_PARAM (yyt); yyIndentSelector ("F"); yyt = yyt->FUNC_PARAM.F; break;
case kFORMAT_PARAM: yWriteFORMAT_PARAM (yyt); goto yyExit;
case kRETURN_PARAM: yWriteRETURN_PARAM (yyt); goto yyExit;
case kNO_PARAM: yWriteNO_PARAM (yyt); goto yyExit;
case kBT_PARAM_LIST: (void) fputs (Tree_NodeName [kBT_PARAM_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTP_EMPTY: (void) fputs (Tree_NodeName [kBTP_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTP_LIST: yWriteBTP_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTP_LIST.Next; break;
case kCONSTANT: (void) fputs (Tree_NodeName [kCONSTANT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBOOL_CONSTANT: yWriteBOOL_CONSTANT (yyt); goto yyExit;
case kINT_CONSTANT: yWriteINT_CONSTANT (yyt); goto yyExit;
case kREAL_CONSTANT: yWriteREAL_CONSTANT (yyt); goto yyExit;
case kSTRING_CONSTANT: yWriteSTRING_CONSTANT (yyt); goto yyExit;
case kCOMPLEX_CONSTANT: yWriteCOMPLEX_CONSTANT (yyt); goto yyExit;
case kPROC_OBJ: yWritePROC_OBJ (yyt); goto yyExit;
case kVAR_OBJ: yWriteVAR_OBJ (yyt); goto yyExit;
case kTYPE_OBJ: yWriteTYPE_OBJ (yyt); goto yyExit;
case kREC_COMP: yWriteREC_COMP (yyt); goto yyExit;
case kTOP_OBJ: yWriteTOP_OBJ (yyt); goto yyExit;
case kTEMP_OBJ: yWriteTEMP_OBJ (yyt); goto yyExit;
case kOVERLAP_SPEC: yWriteOVERLAP_SPEC (yyt); goto yyExit;
case kDEPENDENCE_INFO: (void) fputs (Tree_NodeName [kDEPENDENCE_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSERIAL_INFO: (void) fputs (Tree_NodeName [kSERIAL_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kINDEP_INFO: yWriteINDEP_INFO (yyt); goto yyExit;
case kVECTOR_INFO: yWriteVECTOR_INFO (yyt); goto yyExit;
case kPARDO_INFO: (void) fputs (Tree_NodeName [kPARDO_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kHOME_INFO: (void) fputs (Tree_NodeName [kHOME_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNO_HOME_INFO: (void) fputs (Tree_NodeName [kNO_HOME_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCOMM_INFO: yWriteCOMM_INFO (yyt); goto yyExit;
case kON_INFO: yWriteON_INFO (yyt); goto yyExit;
case kPARALLEL_INFO: yWritePARALLEL_INFO (yyt); goto yyExit;
case kREACHING_INFO: yWriteREACHING_INFO (yyt); goto yyExit;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

