# include "Tree.inc"

tTree mCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
(tTree pCOMP_ELEMENTS, tTree pUSED_ELEMENTS)
# else
(pCOMP_ELEMENTS, pUSED_ELEMENTS)
tTree pCOMP_ELEMENTS;
tTree pUSED_ELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_UNIT])
 yyt->Kind = kCOMP_UNIT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_UNIT.COMP_ELEMENTS = pCOMP_ELEMENTS;
 yyt->COMP_UNIT.USED_ELEMENTS = pUSED_ELEMENTS;
 return yyt;
}

tTree mUNIT_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_NODE_LIST])
 yyt->Kind = kUNIT_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUNIT_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_EMPTY])
 yyt->Kind = kUNIT_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUNIT_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_LIST])
 yyt->Kind = kUNIT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->UNIT_LIST.Elem = pElem;
 yyt->UNIT_LIST.Next = pNext;
 return yyt;
}

tTree mUNIT_NODE
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_NODE])
 yyt->Kind = kUNIT_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->UNIT_NODE.Ident = pIdent;
 yyt->UNIT_NODE.Line = pLine;
 begintDefinitions(yyt->UNIT_NODE.Object)
 return yyt;
}

tTree mMODULE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pMODULE_BODY)
# else
(pIdent, pLine, pMODULE_BODY)
tIdent pIdent;
int pLine;
tTree pMODULE_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMODULE_DECL])
 yyt->Kind = kMODULE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MODULE_DECL.Ident = pIdent;
 yyt->MODULE_DECL.Line = pLine;
 begintDefinitions(yyt->MODULE_DECL.Object)
 yyt->MODULE_DECL.MODULE_BODY = pMODULE_BODY;
 return yyt;
}

tTree mPROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pPROGRAM_BODY)
# else
(pIdent, pLine, pFORMALS, pPROGRAM_BODY)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pPROGRAM_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROGRAM_DECL])
 yyt->Kind = kPROGRAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROGRAM_DECL.Ident = pIdent;
 yyt->PROGRAM_DECL.Line = pLine;
 begintDefinitions(yyt->PROGRAM_DECL.Object)
 yyt->PROGRAM_DECL.FORMALS = pFORMALS;
 yyt->PROGRAM_DECL.PROGRAM_BODY = pPROGRAM_BODY;
 return yyt;
}

tTree mPROC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pPROC_BODY)
# else
(pIdent, pLine, pFORMALS, pPROC_BODY)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pPROC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_DECL])
 yyt->Kind = kPROC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_DECL.Ident = pIdent;
 yyt->PROC_DECL.Line = pLine;
 begintDefinitions(yyt->PROC_DECL.Object)
 yyt->PROC_DECL.FORMALS = pFORMALS;
 yyt->PROC_DECL.PROC_BODY = pPROC_BODY;
 beginbool(yyt->PROC_DECL.IsRecursive)
 beginbool(yyt->PROC_DECL.IsPure)
 begintIdent(yyt->PROC_DECL.HPFExtrinsic)
 return yyt;
}

tTree mFUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pFUNC_BODY, tTree pRESULT_TYPE, tIdent pRESULT_ID)
# else
(pIdent, pLine, pFORMALS, pFUNC_BODY, pRESULT_TYPE, pRESULT_ID)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pFUNC_BODY;
tTree pRESULT_TYPE;
tIdent pRESULT_ID;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_DECL])
 yyt->Kind = kFUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_DECL.Ident = pIdent;
 yyt->FUNC_DECL.Line = pLine;
 begintDefinitions(yyt->FUNC_DECL.Object)
 yyt->FUNC_DECL.FORMALS = pFORMALS;
 yyt->FUNC_DECL.FUNC_BODY = pFUNC_BODY;
 yyt->FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 yyt->FUNC_DECL.RESULT_ID = pRESULT_ID;
 beginbool(yyt->FUNC_DECL.IsRecursive)
 beginbool(yyt->FUNC_DECL.IsPure)
 begintIdent(yyt->FUNC_DECL.HPFExtrinsic)
 return yyt;
}

tTree mMODULE_PROC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMODULE_PROC_DECL])
 yyt->Kind = kMODULE_PROC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MODULE_PROC_DECL.Ident = pIdent;
 yyt->MODULE_PROC_DECL.Line = pLine;
 begintDefinitions(yyt->MODULE_PROC_DECL.Object)
 return yyt;
}

tTree mBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDATA_BODY)
# else
(pIdent, pLine, pDATA_BODY)
tIdent pIdent;
int pLine;
tTree pDATA_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBLOCK_DATA_DECL])
 yyt->Kind = kBLOCK_DATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BLOCK_DATA_DECL.Ident = pIdent;
 yyt->BLOCK_DATA_DECL.Line = pLine;
 begintDefinitions(yyt->BLOCK_DATA_DECL.Object)
 yyt->BLOCK_DATA_DECL.DATA_BODY = pDATA_BODY;
 return yyt;
}

tTree mINTERFACE
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pSPEC, tTree pITEMS)
# else
(pIdent, pLine, pSPEC, pITEMS)
tIdent pIdent;
int pLine;
tTree pSPEC;
tTree pITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTERFACE])
 yyt->Kind = kINTERFACE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTERFACE.Ident = pIdent;
 yyt->INTERFACE.Line = pLine;
 begintDefinitions(yyt->INTERFACE.Object)
 yyt->INTERFACE.SPEC = pSPEC;
 yyt->INTERFACE.ITEMS = pITEMS;
 return yyt;
}

tTree mBODY_NODE
# if defined __STDC__ | defined __cplusplus
(tTree pDECLS, tTree pSTATS, tTree pINTERNALS)
# else
(pDECLS, pSTATS, pINTERNALS)
tTree pDECLS;
tTree pSTATS;
tTree pINTERNALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBODY_NODE])
 yyt->Kind = kBODY_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BODY_NODE.DECLS = pDECLS;
 yyt->BODY_NODE.STATS = pSTATS;
 yyt->BODY_NODE.INTERNALS = pINTERNALS;
 return yyt;
}

tTree mTYPE_NODE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_NODE])
 yyt->Kind = kTYPE_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_TYPE])
 yyt->Kind = kDUMMY_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mALIGN_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_TYPE])
 yyt->Kind = kALIGN_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTEGER_TYPE])
 yyt->Kind = kINTEGER_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTEGER_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mREAL_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREAL_TYPE])
 yyt->Kind = kREAL_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REAL_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOOLEAN_TYPE])
 yyt->Kind = kBOOLEAN_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOOLEAN_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMPLEX_TYPE])
 yyt->Kind = kCOMPLEX_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMPLEX_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pLENGTH)
# else
(pLENGTH)
tTree pLENGTH;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTRING_TYPE])
 yyt->Kind = kSTRING_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STRING_TYPE.LENGTH = pLENGTH;
 return yyt;
}

tTree mTYPE_ID
# if defined __STDC__ | defined __cplusplus
(tTree pID)
# else
(pID)
tTree pID;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_ID])
 yyt->Kind = kTYPE_ID;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_ID.ID = pID;
 return yyt;
}

tTree mARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY_INDEX_TYPES, tTree pARRAY_COMP_TYPE)
# else
(pARRAY_INDEX_TYPES, pARRAY_COMP_TYPE)
tTree pARRAY_INDEX_TYPES;
tTree pARRAY_COMP_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY_TYPE])
 yyt->Kind = kARRAY_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES = pARRAY_INDEX_TYPES;
 yyt->ARRAY_TYPE.ARRAY_COMP_TYPE = pARRAY_COMP_TYPE;
 return yyt;
}

tTree mRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pCOMPONENTS)
# else
(pName, pCOMPONENTS)
tIdent pName;
tTree pCOMPONENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRECORD_TYPE])
 yyt->Kind = kRECORD_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RECORD_TYPE.Name = pName;
 yyt->RECORD_TYPE.COMPONENTS = pCOMPONENTS;
 return yyt;
}

tTree mPOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pPTR_COMP)
# else
(pPTR_COMP)
tTree pPTR_COMP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOINTER_TYPE])
 yyt->Kind = kPOINTER_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POINTER_TYPE.PTR_COMP = pPTR_COMP;
 return yyt;
}

tTree mSHAPE_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_SPEC])
 yyt->Kind = kSHAPE_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->SHAPE_SPEC.Overlap)
 return yyt;
}

tTree mEXPLICIT_SHAPE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER, tTree pUPPER)
# else
(pLOWER, pUPPER)
tTree pLOWER;
tTree pUPPER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXPLICIT_SHAPE])
 yyt->Kind = kEXPLICIT_SHAPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->EXPLICIT_SHAPE.Overlap)
 yyt->EXPLICIT_SHAPE.LOWER = pLOWER;
 yyt->EXPLICIT_SHAPE.UPPER = pUPPER;
 return yyt;
}

tTree mASSUMED_SHAPE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER)
# else
(pLOWER)
tTree pLOWER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSUMED_SHAPE])
 yyt->Kind = kASSUMED_SHAPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->ASSUMED_SHAPE.Overlap)
 yyt->ASSUMED_SHAPE.LOWER = pLOWER;
 return yyt;
}

tTree mDEFERRED_SHAPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEFERRED_SHAPE])
 yyt->Kind = kDEFERRED_SHAPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->DEFERRED_SHAPE.Overlap)
 return yyt;
}

tTree mASSUMED_SIZE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER)
# else
(pLOWER)
tTree pLOWER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSUMED_SIZE])
 yyt->Kind = kASSUMED_SIZE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->ASSUMED_SIZE.Overlap)
 yyt->ASSUMED_SIZE.LOWER = pLOWER;
 return yyt;
}

tTree mSHAPE_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_SPEC_LIST])
 yyt->Kind = kSHAPE_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSHAPE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_EMPTY])
 yyt->Kind = kSHAPE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSHAPE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_LIST])
 yyt->Kind = kSHAPE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SHAPE_LIST.Elem = pElem;
 yyt->SHAPE_LIST.Next = pNext;
 return yyt;
}

tTree mDECL_NODE
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_NODE])
 yyt->Kind = kDECL_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DECL_NODE.Ident = pIdent;
 yyt->DECL_NODE.Line = pLine;
 return yyt;
}

tTree mTYPE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_DECL])
 yyt->Kind = kTYPE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_DECL.Ident = pIdent;
 yyt->TYPE_DECL.Line = pLine;
 yyt->TYPE_DECL.VAL = pVAL;
 return yyt;
}

tTree mNAME_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAME_DECL])
 yyt->Kind = kNAME_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAME_DECL.Ident = pIdent;
 yyt->NAME_DECL.Line = pLine;
 return yyt;
}

tTree mRENAME_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent poldname)
# else
(pIdent, pLine, poldname)
tIdent pIdent;
int pLine;
tIdent poldname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRENAME_DECL])
 yyt->Kind = kRENAME_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RENAME_DECL.Ident = pIdent;
 yyt->RENAME_DECL.Line = pLine;
 yyt->RENAME_DECL.oldname = poldname;
 return yyt;
}

tTree mENTITY_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pATTRIBUTES)
# else
(pIdent, pLine, pATTRIBUTES)
tIdent pIdent;
int pLine;
tTree pATTRIBUTES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kENTITY_DECL])
 yyt->Kind = kENTITY_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ENTITY_DECL.Ident = pIdent;
 yyt->ENTITY_DECL.Line = pLine;
 yyt->ENTITY_DECL.ATTRIBUTES = pATTRIBUTES;
 return yyt;
}

tTree mVAR_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_DECL])
 yyt->Kind = kVAR_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_DECL.Ident = pIdent;
 yyt->VAR_DECL.Line = pLine;
 yyt->VAR_DECL.VAL = pVAL;
 return yyt;
}

tTree mCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pIDS)
# else
(pIdent, pLine, pIDS)
tIdent pIdent;
int pLine;
tTree pIDS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMMON_DECL])
 yyt->Kind = kCOMMON_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMMON_DECL.Ident = pIdent;
 yyt->COMMON_DECL.Line = pLine;
 yyt->COMMON_DECL.IDS = pIDS;
 return yyt;
}

tTree mNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pIDS)
# else
(pIdent, pLine, pIDS)
tIdent pIdent;
int pLine;
tTree pIDS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMELIST_DECL])
 yyt->Kind = kNAMELIST_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMELIST_DECL.Ident = pIdent;
 yyt->NAMELIST_DECL.Line = pLine;
 yyt->NAMELIST_DECL.IDS = pIDS;
 return yyt;
}

tTree mTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDIMENSIONS)
# else
(pIdent, pLine, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTEMPLATE_DECL])
 yyt->Kind = kTEMPLATE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TEMPLATE_DECL.Ident = pIdent;
 yyt->TEMPLATE_DECL.Line = pLine;
 yyt->TEMPLATE_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mRAGGED_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDIMENSIONS)
# else
(pIdent, pLine, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRAGGED_DECL])
 yyt->Kind = kRAGGED_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RAGGED_DECL.Ident = pIdent;
 yyt->RAGGED_DECL.Line = pLine;
 yyt->RAGGED_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mPROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDIMENSIONS)
# else
(pIdent, pLine, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSORS_DECL])
 yyt->Kind = kPROCESSORS_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSORS_DECL.Ident = pIdent;
 yyt->PROCESSORS_DECL.Line = pLine;
 yyt->PROCESSORS_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mSUB_PROCS_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pTOP, tTree pDIMENSIONS)
# else
(pIdent, pLine, pTOP, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pTOP;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSUB_PROCS_DECL])
 yyt->Kind = kSUB_PROCS_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SUB_PROCS_DECL.Ident = pIdent;
 yyt->SUB_PROCS_DECL.Line = pLine;
 yyt->SUB_PROCS_DECL.TOP = pTOP;
 yyt->SUB_PROCS_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINHERIT_DECL])
 yyt->Kind = kINHERIT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INHERIT_DECL.Ident = pIdent;
 yyt->INHERIT_DECL.Line = pLine;
 return yyt;
}

tTree mRANGE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pRANGES)
# else
(pIdent, pLine, pRANGES)
tIdent pIdent;
int pLine;
tTree pRANGES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_DECL])
 yyt->Kind = kRANGE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RANGE_DECL.Ident = pIdent;
 yyt->RANGE_DECL.Line = pLine;
 yyt->RANGE_DECL.RANGES = pRANGES;
 return yyt;
}

tTree mSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pRESULT_TYPE, tTree pFFUNC_BODY)
# else
(pIdent, pLine, pFORMALS, pRESULT_TYPE, pFFUNC_BODY)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pRESULT_TYPE;
tTree pFFUNC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTMT_FUNC_DECL])
 yyt->Kind = kSTMT_FUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STMT_FUNC_DECL.Ident = pIdent;
 yyt->STMT_FUNC_DECL.Line = pLine;
 yyt->STMT_FUNC_DECL.FORMALS = pFORMALS;
 yyt->STMT_FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 yyt->STMT_FUNC_DECL.FFUNC_BODY = pFFUNC_BODY;
 return yyt;
}

tTree mINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pSPEC, tTree pITEMS)
# else
(pIdent, pLine, pSPEC, pITEMS)
tIdent pIdent;
int pLine;
tTree pSPEC;
tTree pITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTERFACE_DECL])
 yyt->Kind = kINTERFACE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTERFACE_DECL.Ident = pIdent;
 yyt->INTERFACE_DECL.Line = pLine;
 yyt->INTERFACE_DECL.SPEC = pSPEC;
 yyt->INTERFACE_DECL.ITEMS = pITEMS;
 return yyt;
}

tTree mVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_PARAM_DECL])
 yyt->Kind = kVAR_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_PARAM_DECL.Ident = pIdent;
 yyt->VAR_PARAM_DECL.Line = pLine;
 yyt->VAR_PARAM_DECL.VAL = pVAL;
 return yyt;
}

tTree mRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRET_PARAM_DECL])
 yyt->Kind = kRET_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RET_PARAM_DECL.Ident = pIdent;
 yyt->RET_PARAM_DECL.Line = pLine;
 return yyt;
}

tTree mIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent pfirst, tIdent plast, tTree pTYPE)
# else
(pIdent, pLine, pfirst, plast, pTYPE)
tIdent pIdent;
int pLine;
tIdent pfirst;
tIdent plast;
tTree pTYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIMPLICIT_DECL])
 yyt->Kind = kIMPLICIT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IMPLICIT_DECL.Ident = pIdent;
 yyt->IMPLICIT_DECL.Line = pLine;
 yyt->IMPLICIT_DECL.first = pfirst;
 yyt->IMPLICIT_DECL.last = plast;
 yyt->IMPLICIT_DECL.TYPE = pTYPE;
 return yyt;
}

tTree mUSE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent puse, tTree pRENAMINGS)
# else
(pIdent, pLine, puse, pRENAMINGS)
tIdent pIdent;
int pLine;
tIdent puse;
tTree pRENAMINGS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSE_DECL])
 yyt->Kind = kUSE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USE_DECL.Ident = pIdent;
 yyt->USE_DECL.Line = pLine;
 yyt->USE_DECL.use = puse;
 yyt->USE_DECL.RENAMINGS = pRENAMINGS;
 return yyt;
}

tTree mONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent puse, tTree pNAMES)
# else
(pIdent, pLine, puse, pNAMES)
tIdent pIdent;
int pLine;
tIdent puse;
tTree pNAMES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kONLY_USE_DECL])
 yyt->Kind = kONLY_USE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ONLY_USE_DECL.Ident = pIdent;
 yyt->ONLY_USE_DECL.Line = pLine;
 yyt->ONLY_USE_DECL.use = puse;
 yyt->ONLY_USE_DECL.NAMES = pNAMES;
 return yyt;
}

tTree mEQV_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVARS)
# else
(pIdent, pLine, pVARS)
tIdent pIdent;
int pLine;
tTree pVARS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEQV_DECL])
 yyt->Kind = kEQV_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EQV_DECL.Ident = pIdent;
 yyt->EQV_DECL.Line = pLine;
 yyt->EQV_DECL.VARS = pVARS;
 return yyt;
}

tTree mDATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVARS, tTree pVALS)
# else
(pIdent, pLine, pVARS, pVALS)
tIdent pIdent;
int pLine;
tTree pVARS;
tTree pVALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDATA_DECL])
 yyt->Kind = kDATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DATA_DECL.Ident = pIdent;
 yyt->DATA_DECL.Line = pLine;
 yyt->DATA_DECL.VARS = pVARS;
 yyt->DATA_DECL.VALS = pVALS;
 return yyt;
}

tTree mFORMAT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, int plabel, tTree pFORMAT_PARAMS)
# else
(pIdent, pLine, plabel, pFORMAT_PARAMS)
tIdent pIdent;
int pLine;
int plabel;
tTree pFORMAT_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_DECL])
 yyt->Kind = kFORMAT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_DECL.Ident = pIdent;
 yyt->FORMAT_DECL.Line = pLine;
 yyt->FORMAT_DECL.label = plabel;
 yyt->FORMAT_DECL.FORMAT_PARAMS = pFORMAT_PARAMS;
 return yyt;
}

tTree mDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pINDEXES)
# else
(pIdent, pLine, pINDEXES)
tIdent pIdent;
int pLine;
tTree pINDEXES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIMENSION_DECL])
 yyt->Kind = kDIMENSION_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIMENSION_DECL.Ident = pIdent;
 yyt->DIMENSION_DECL.Line = pLine;
 yyt->DIMENSION_DECL.INDEXES = pINDEXES;
 return yyt;
}

tTree mINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINIT_DATA_DECL])
 yyt->Kind = kINIT_DATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INIT_DATA_DECL.Ident = pIdent;
 yyt->INIT_DATA_DECL.Line = pLine;
 yyt->INIT_DATA_DECL.VAL = pVAL;
 return yyt;
}

tTree mTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPESPEC_DECL])
 yyt->Kind = kTYPESPEC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPESPEC_DECL.Ident = pIdent;
 yyt->TYPESPEC_DECL.Line = pLine;
 yyt->TYPESPEC_DECL.VAL = pVAL;
 return yyt;
}

tTree mALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALLOCATABLE_DECL])
 yyt->Kind = kALLOCATABLE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALLOCATABLE_DECL.Ident = pIdent;
 yyt->ALLOCATABLE_DECL.Line = pLine;
 return yyt;
}

tTree mEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXTERNAL_DECL])
 yyt->Kind = kEXTERNAL_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXTERNAL_DECL.Ident = pIdent;
 yyt->EXTERNAL_DECL.Line = pLine;
 return yyt;
}

tTree mINTENT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, int pintent)
# else
(pIdent, pLine, pintent)
tIdent pIdent;
int pLine;
int pintent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTENT_DECL])
 yyt->Kind = kINTENT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTENT_DECL.Ident = pIdent;
 yyt->INTENT_DECL.Line = pLine;
 yyt->INTENT_DECL.intent = pintent;
 return yyt;
}

tTree mINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent pgeneric, int pclass, int pkind)
# else
(pIdent, pLine, pgeneric, pclass, pkind)
tIdent pIdent;
int pLine;
tIdent pgeneric;
int pclass;
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTRINSIC_DECL])
 yyt->Kind = kINTRINSIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTRINSIC_DECL.Ident = pIdent;
 yyt->INTRINSIC_DECL.Line = pLine;
 yyt->INTRINSIC_DECL.generic = pgeneric;
 yyt->INTRINSIC_DECL.class = pclass;
 yyt->INTRINSIC_DECL.kind = pkind;
 return yyt;
}

tTree mOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOPTIONAL_DECL])
 yyt->Kind = kOPTIONAL_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OPTIONAL_DECL.Ident = pIdent;
 yyt->OPTIONAL_DECL.Line = pLine;
 return yyt;
}

tTree mPOINTER_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOINTER_DECL])
 yyt->Kind = kPOINTER_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POINTER_DECL.Ident = pIdent;
 yyt->POINTER_DECL.Line = pLine;
 return yyt;
}

tTree mSAVE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSAVE_DECL])
 yyt->Kind = kSAVE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SAVE_DECL.Ident = pIdent;
 yyt->SAVE_DECL.Line = pLine;
 return yyt;
}

tTree mTARGET_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTARGET_DECL])
 yyt->Kind = kTARGET_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TARGET_DECL.Ident = pIdent;
 yyt->TARGET_DECL.Line = pLine;
 return yyt;
}

tTree mPARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARAMETER_DECL])
 yyt->Kind = kPARAMETER_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PARAMETER_DECL.Ident = pIdent;
 yyt->PARAMETER_DECL.Line = pLine;
 yyt->PARAMETER_DECL.VAL = pVAL;
 return yyt;
}

tTree mPUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPUBLIC_DECL])
 yyt->Kind = kPUBLIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PUBLIC_DECL.Ident = pIdent;
 yyt->PUBLIC_DECL.Line = pLine;
 return yyt;
}

tTree mPRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPRIVATE_DECL])
 yyt->Kind = kPRIVATE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PRIVATE_DECL.Ident = pIdent;
 yyt->PRIVATE_DECL.Line = pLine;
 return yyt;
}

tTree mSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSEQUENCE_DECL])
 yyt->Kind = kSEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SEQUENCE_DECL.Ident = pIdent;
 yyt->SEQUENCE_DECL.Line = pLine;
 return yyt;
}

tTree mDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDISTRIBUTION, tTree pTARGET)
# else
(pIdent, pLine, pDISTRIBUTION, pTARGET)
tIdent pIdent;
int pLine;
tTree pDISTRIBUTION;
tTree pTARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTE_DECL])
 yyt->Kind = kDISTRIBUTE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DISTRIBUTE_DECL.Ident = pIdent;
 yyt->DISTRIBUTE_DECL.Line = pLine;
 yyt->DISTRIBUTE_DECL.DISTRIBUTION = pDISTRIBUTION;
 yyt->DISTRIBUTE_DECL.TARGET = pTARGET;
 return yyt;
}

tTree mALIGN_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pALIGN_SOURCE, tTree pALIGN_TARGET)
# else
(pIdent, pLine, pALIGN_SOURCE, pALIGN_TARGET)
tIdent pIdent;
int pLine;
tTree pALIGN_SOURCE;
tTree pALIGN_TARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_DECL])
 yyt->Kind = kALIGN_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALIGN_DECL.Ident = pIdent;
 yyt->ALIGN_DECL.Line = pLine;
 yyt->ALIGN_DECL.ALIGN_SOURCE = pALIGN_SOURCE;
 yyt->ALIGN_DECL.ALIGN_TARGET = pALIGN_TARGET;
 return yyt;
}

tTree mMAP_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pMAP_TARGET)
# else
(pIdent, pLine, pMAP_TARGET)
tIdent pIdent;
int pLine;
tTree pMAP_TARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMAP_DECL])
 yyt->Kind = kMAP_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MAP_DECL.Ident = pIdent;
 yyt->MAP_DECL.Line = pLine;
 yyt->MAP_DECL.MAP_TARGET = pMAP_TARGET;
 return yyt;
}

tTree mOVERLAP_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pOVERLAPS)
# else
(pIdent, pLine, pOVERLAPS)
tIdent pIdent;
int pLine;
tTree pOVERLAPS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOVERLAP_DECL])
 yyt->Kind = kOVERLAP_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OVERLAP_DECL.Ident = pIdent;
 yyt->OVERLAP_DECL.Line = pLine;
 yyt->OVERLAP_DECL.OVERLAPS = pOVERLAPS;
 return yyt;
}

tTree mSHARED_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, int pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHARED_DECL])
 yyt->Kind = kSHARED_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SHARED_DECL.Ident = pIdent;
 yyt->SHARED_DECL.Line = pLine;
 yyt->SHARED_DECL.kind = pkind;
 return yyt;
}

tTree mDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDYNAMIC_DECL])
 yyt->Kind = kDYNAMIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DYNAMIC_DECL.Ident = pIdent;
 yyt->DYNAMIC_DECL.Line = pLine;
 return yyt;
}

tTree mTRACE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTRACE_DECL])
 yyt->Kind = kTRACE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TRACE_DECL.Ident = pIdent;
 yyt->TRACE_DECL.Line = pLine;
 return yyt;
}

tTree mTREE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTREE_DECL])
 yyt->Kind = kTREE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TREE_DECL.Ident = pIdent;
 yyt->TREE_DECL.Line = pLine;
 return yyt;
}

tTree mSELECT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pSELECTIONS)
# else
(pIdent, pLine, pSELECTIONS)
tIdent pIdent;
int pLine;
tTree pSELECTIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_DECL])
 yyt->Kind = kSELECT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECT_DECL.Ident = pIdent;
 yyt->SELECT_DECL.Line = pLine;
 yyt->SELECT_DECL.SELECTIONS = pSELECTIONS;
 return yyt;
}

tTree mHPF_SEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kHPF_SEQUENCE_DECL])
 yyt->Kind = kHPF_SEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->HPF_SEQUENCE_DECL.Ident = pIdent;
 yyt->HPF_SEQUENCE_DECL.Line = pLine;
 return yyt;
}

tTree mNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNOSEQUENCE_DECL])
 yyt->Kind = kNOSEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NOSEQUENCE_DECL.Ident = pIdent;
 yyt->NOSEQUENCE_DECL.Line = pLine;
 return yyt;
}

tTree mLAYOUT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tStringRef pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
tStringRef pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLAYOUT_DECL])
 yyt->Kind = kLAYOUT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LAYOUT_DECL.Ident = pIdent;
 yyt->LAYOUT_DECL.Line = pLine;
 yyt->LAYOUT_DECL.kind = pkind;
 return yyt;
}

tTree mPASS_BY_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tStringRef pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
tStringRef pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPASS_BY_DECL])
 yyt->Kind = kPASS_BY_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PASS_BY_DECL.Ident = pIdent;
 yyt->PASS_BY_DECL.Line = pLine;
 yyt->PASS_BY_DECL.kind = pkind;
 return yyt;
}

tTree mMAP_TO_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tStringRef pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
tStringRef pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMAP_TO_DECL])
 yyt->Kind = kMAP_TO_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MAP_TO_DECL.Ident = pIdent;
 yyt->MAP_TO_DECL.Line = pLine;
 yyt->MAP_TO_DECL.kind = pkind;
 return yyt;
}

tTree mDECL_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_NODE_LIST])
 yyt->Kind = kDECL_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDECL_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_EMPTY])
 yyt->Kind = kDECL_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDECL_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_LIST])
 yyt->Kind = kDECL_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DECL_LIST.Elem = pElem;
 yyt->DECL_LIST.Next = pNext;
 return yyt;
}

tTree mRANGE_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_SPEC_LIST])
 yyt->Kind = kRANGE_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mRANGE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_EMPTY])
 yyt->Kind = kRANGE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mRANGE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_LIST])
 yyt->Kind = kRANGE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RANGE_LIST.Elem = pElem;
 yyt->RANGE_LIST.Next = pNext;
 return yyt;
}

tTree mSELECT_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_SPEC_LIST])
 yyt->Kind = kSELECT_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECT_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_EMPTY])
 yyt->Kind = kSELECT_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECT_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_LIST])
 yyt->Kind = kSELECT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECT_LIST.Elem = pElem;
 yyt->SELECT_LIST.Next = pNext;
 return yyt;
}

tTree mSELECT_SPEC
# if defined __STDC__ | defined __cplusplus
(int pselector)
# else
(pselector)
int pselector;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_SPEC])
 yyt->Kind = kSELECT_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECT_SPEC.selector = pselector;
 return yyt;
}

tTree mDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTION_SPEC])
 yyt->Kind = kDISTRIBUTION_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DISTRIBUTION_SPEC.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mANY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_DISTRIBUTION])
 yyt->Kind = kANY_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ANY_DISTRIBUTION.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mDEFAULT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEFAULT_DISTRIBUTION])
 yyt->Kind = kDEFAULT_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DEFAULT_DISTRIBUTION.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREPL_DISTRIBUTION])
 yyt->Kind = kREPL_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REPL_DISTRIBUTION.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive, tTree pMAPPING)
# else
(pis_descriptive, pMAPPING)
int pis_descriptive;
tTree pMAPPING;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNODE_DISTRIBUTION])
 yyt->Kind = kNODE_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NODE_DISTRIBUTION.is_descriptive = pis_descriptive;
 yyt->NODE_DISTRIBUTION.MAPPING = pMAPPING;
 return yyt;
}

tTree mDIST_FORMAT_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_FORMAT_LIST])
 yyt->Kind = kDIST_FORMAT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_EMPTY])
 yyt->Kind = kDIST_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_LIST])
 yyt->Kind = kDIST_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIST_LIST.Elem = pElem;
 yyt->DIST_LIST.Next = pNext;
 return yyt;
}

tTree mDISTRIBUTION_FORMAT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTION_FORMAT])
 yyt->Kind = kDISTRIBUTION_FORMAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBLOCK_DISTRIBUTION])
 yyt->Kind = kBLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BLOCK_DISTRIBUTION.SIZE = pSIZE;
 return yyt;
}

tTree mCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCYCLIC_DISTRIBUTION])
 yyt->Kind = kCYCLIC_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CYCLIC_DISTRIBUTION.SIZE = pSIZE;
 return yyt;
}

tTree mGEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY)
# else
(pARRAY)
tTree pARRAY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGEN_BLOCK_DISTRIBUTION])
 yyt->Kind = kGEN_BLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->GEN_BLOCK_DISTRIBUTION.ARRAY = pARRAY;
 return yyt;
}

tTree mINDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY)
# else
(pARRAY)
tTree pARRAY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDIRECT_DISTRIBUTION])
 yyt->Kind = kINDIRECT_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDIRECT_DISTRIBUTION.ARRAY = pARRAY;
 return yyt;
}

tTree mARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE, tTree pLENGTH, tTree pMAP)
# else
(pSIZE, pLENGTH, pMAP)
tTree pSIZE;
tTree pLENGTH;
tTree pMAP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARBITRARY_DISTRIBUTION])
 yyt->Kind = kARBITRARY_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARBITRARY_DISTRIBUTION.SIZE = pSIZE;
 yyt->ARBITRARY_DISTRIBUTION.LENGTH = pLENGTH;
 yyt->ARBITRARY_DISTRIBUTION.MAP = pMAP;
 return yyt;
}

tTree mSERIAL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSERIAL_DISTRIBUTION])
 yyt->Kind = kSERIAL_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_BLOCK_DISTRIBUTION])
 yyt->Kind = kANY_BLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_CYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_CYCLIC_DISTRIBUTION])
 yyt->Kind = kANY_CYCLIC_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_GEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_GEN_BLOCK_DISTRIBUTION])
 yyt->Kind = kANY_GEN_BLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_INDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_INDIRECT_DISTRIBUTION])
 yyt->Kind = kANY_INDIRECT_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_ARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_ARBITRARY_DISTRIBUTION])
 yyt->Kind = kANY_ARBITRARY_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_DIM_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_DIM_DISTRIBUTION])
 yyt->Kind = kANY_DIM_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mPROCESSOR_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSOR_SPEC])
 yyt->Kind = kPROCESSOR_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_PROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_PROCESSOR_ARRAY])
 yyt->Kind = kANY_PROCESSOR_ARRAY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDEFAULT_PROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEFAULT_PROCESSOR_ARRAY])
 yyt->Kind = kDEFAULT_PROCESSOR_ARRAY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mPROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
(tTree pTOPNAME)
# else
(pTOPNAME)
tTree pTOPNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSOR_ARRAY])
 yyt->Kind = kPROCESSOR_ARRAY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSOR_ARRAY.TOPNAME = pTOPNAME;
 return yyt;
}

tTree mPROCESSOR_SUBSET
# if defined __STDC__ | defined __cplusplus
(tTree pSUBTOP, tTree pFULLTOP, tTree pSUBSCRIPTS)
# else
(pSUBTOP, pFULLTOP, pSUBSCRIPTS)
tTree pSUBTOP;
tTree pFULLTOP;
tTree pSUBSCRIPTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSOR_SUBSET])
 yyt->Kind = kPROCESSOR_SUBSET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSOR_SUBSET.SUBTOP = pSUBTOP;
 yyt->PROCESSOR_SUBSET.FULLTOP = pFULLTOP;
 yyt->PROCESSOR_SUBSET.SUBSCRIPTS = pSUBSCRIPTS;
 return yyt;
}

tTree mALIGN_SPEC
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive, tTree pTEMPNAME, tTree pSUBSCRIPTS)
# else
(pis_descriptive, pTEMPNAME, pSUBSCRIPTS)
int pis_descriptive;
tTree pTEMPNAME;
tTree pSUBSCRIPTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_SPEC])
 yyt->Kind = kALIGN_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALIGN_SPEC.is_descriptive = pis_descriptive;
 yyt->ALIGN_SPEC.TEMPNAME = pTEMPNAME;
 yyt->ALIGN_SPEC.SUBSCRIPTS = pSUBSCRIPTS;
 return yyt;
}

tTree mGENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGENERIC_SPEC])
 yyt->Kind = kGENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mNO_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_GENERIC_SPEC])
 yyt->Kind = kNO_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
(tIdent pname)
# else
(pname)
tIdent pname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kID_GENERIC_SPEC])
 yyt->Kind = kID_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ID_GENERIC_SPEC.name = pname;
 return yyt;
}

tTree mOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
(tTree pOPERATOR)
# else
(pOPERATOR)
tTree pOPERATOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GENERIC_SPEC])
 yyt->Kind = kOP_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_GENERIC_SPEC.OPERATOR = pOPERATOR;
 return yyt;
}

tTree mASSIGN_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_GENERIC_SPEC])
 yyt->Kind = kASSIGN_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NODE_LIST])
 yyt->Kind = kACF_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_EMPTY])
 yyt->Kind = kACF_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_LIST])
 yyt->Kind = kACF_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ACF_LIST.Elem = pElem;
 yyt->ACF_LIST.Next = pNext;
 return yyt;
}

tTree mACF_NODE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NODE])
 yyt->Kind = kACF_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_NODE.Label)
 beginint(yyt->ACF_NODE.Line)
 return yyt;
}

tTree mACF_DUMMY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DUMMY])
 yyt->Kind = kACF_DUMMY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DUMMY.Label)
 beginint(yyt->ACF_DUMMY.Line)
 return yyt;
}

tTree mACF_BASIC
# if defined __STDC__ | defined __cplusplus
(tTree pBASIC_STMT)
# else
(pBASIC_STMT)
tTree pBASIC_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_BASIC])
 yyt->Kind = kACF_BASIC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_BASIC.Label)
 beginint(yyt->ACF_BASIC.Line)
 yyt->ACF_BASIC.BASIC_STMT = pBASIC_STMT;
 return yyt;
}

tTree mACF_IF
# if defined __STDC__ | defined __cplusplus
(tTree pIF_EXP, tTree pTHEN_PART, tTree pELSE_PART)
# else
(pIF_EXP, pTHEN_PART, pELSE_PART)
tTree pIF_EXP;
tTree pTHEN_PART;
tTree pELSE_PART;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_IF])
 yyt->Kind = kACF_IF;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_IF.Label)
 beginint(yyt->ACF_IF.Line)
 yyt->ACF_IF.IF_EXP = pIF_EXP;
 yyt->ACF_IF.THEN_PART = pTHEN_PART;
 yyt->ACF_IF.ELSE_PART = pELSE_PART;
 return yyt;
}

tTree mACF_WHERE
# if defined __STDC__ | defined __cplusplus
(tTree pWHERE_EXP, tTree pTRUE_PART, tTree pFALSE_PART)
# else
(pWHERE_EXP, pTRUE_PART, pFALSE_PART)
tTree pWHERE_EXP;
tTree pTRUE_PART;
tTree pFALSE_PART;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WHERE])
 yyt->Kind = kACF_WHERE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WHERE.Label)
 beginint(yyt->ACF_WHERE.Line)
 yyt->ACF_WHERE.WHERE_EXP = pWHERE_EXP;
 yyt->ACF_WHERE.TRUE_PART = pTRUE_PART;
 yyt->ACF_WHERE.FALSE_PART = pFALSE_PART;
 return yyt;
}

tTree mACF_CASE
# if defined __STDC__ | defined __cplusplus
(tTree pCASE_EXP, tTree pCASE_ALTS)
# else
(pCASE_EXP, pCASE_ALTS)
tTree pCASE_EXP;
tTree pCASE_ALTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_CASE])
 yyt->Kind = kACF_CASE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_CASE.Label)
 beginint(yyt->ACF_CASE.Line)
 yyt->ACF_CASE.CASE_EXP = pCASE_EXP;
 yyt->ACF_CASE.CASE_ALTS = pCASE_ALTS;
 return yyt;
}

tTree mACF_WHILE
# if defined __STDC__ | defined __cplusplus
(tTree pWHILE_EXP, tTree pWHILE_BODY)
# else
(pWHILE_EXP, pWHILE_BODY)
tTree pWHILE_EXP;
tTree pWHILE_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WHILE])
 yyt->Kind = kACF_WHILE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WHILE.Label)
 beginint(yyt->ACF_WHILE.Line)
 yyt->ACF_WHILE.WHILE_EXP = pWHILE_EXP;
 yyt->ACF_WHILE.WHILE_BODY = pWHILE_BODY;
 return yyt;
}

tTree mACF_REPEAT
# if defined __STDC__ | defined __cplusplus
(tTree pREPEAT_BODY, tTree pREPEAT_EXP)
# else
(pREPEAT_BODY, pREPEAT_EXP)
tTree pREPEAT_BODY;
tTree pREPEAT_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_REPEAT])
 yyt->Kind = kACF_REPEAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_REPEAT.Label)
 beginint(yyt->ACF_REPEAT.Line)
 yyt->ACF_REPEAT.REPEAT_BODY = pREPEAT_BODY;
 yyt->ACF_REPEAT.REPEAT_EXP = pREPEAT_EXP;
 return yyt;
}

tTree mACF_LOOP
# if defined __STDC__ | defined __cplusplus
(tTree pLOOP_BODY)
# else
(pLOOP_BODY)
tTree pLOOP_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_LOOP])
 yyt->Kind = kACF_LOOP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_LOOP.Label)
 beginint(yyt->ACF_LOOP.Line)
 yyt->ACF_LOOP.LOOP_BODY = pLOOP_BODY;
 return yyt;
}

tTree mACF_DO
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pDO_RANGE, tTree pDO_BODY, tTree pDO_DEP_INFO, tTree pDO_HOME_INFO)
# else
(pDO_ID, pDO_RANGE, pDO_BODY, pDO_DEP_INFO, pDO_HOME_INFO)
tTree pDO_ID;
tTree pDO_RANGE;
tTree pDO_BODY;
tTree pDO_DEP_INFO;
tTree pDO_HOME_INFO;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DO])
 yyt->Kind = kACF_DO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DO.Label)
 beginint(yyt->ACF_DO.Line)
 yyt->ACF_DO.DO_ID = pDO_ID;
 yyt->ACF_DO.DO_RANGE = pDO_RANGE;
 yyt->ACF_DO.DO_BODY = pDO_BODY;
 yyt->ACF_DO.DO_DEP_INFO = pDO_DEP_INFO;
 yyt->ACF_DO.DO_HOME_INFO = pDO_HOME_INFO;
 return yyt;
}

tTree mACF_FORALL
# if defined __STDC__ | defined __cplusplus
(tTree pFORALL_ID, tTree pFORALL_RANGE, tTree pFORALL_BODY, tTree pFORALL_DEP_INFO, tTree pFORALL_HOME_INFO)
# else
(pFORALL_ID, pFORALL_RANGE, pFORALL_BODY, pFORALL_DEP_INFO, pFORALL_HOME_INFO)
tTree pFORALL_ID;
tTree pFORALL_RANGE;
tTree pFORALL_BODY;
tTree pFORALL_DEP_INFO;
tTree pFORALL_HOME_INFO;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FORALL])
 yyt->Kind = kACF_FORALL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_FORALL.Label)
 beginint(yyt->ACF_FORALL.Line)
 yyt->ACF_FORALL.FORALL_ID = pFORALL_ID;
 yyt->ACF_FORALL.FORALL_RANGE = pFORALL_RANGE;
 yyt->ACF_FORALL.FORALL_BODY = pFORALL_BODY;
 yyt->ACF_FORALL.FORALL_DEP_INFO = pFORALL_DEP_INFO;
 yyt->ACF_FORALL.FORALL_HOME_INFO = pFORALL_HOME_INFO;
 return yyt;
}

tTree mACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
(tTree pFLOW_NODES)
# else
(pFLOW_NODES)
tTree pFLOW_NODES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FLOW_GRAPH])
 yyt->Kind = kACF_FLOW_GRAPH;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_FLOW_GRAPH.Label)
 beginint(yyt->ACF_FLOW_GRAPH.Line)
 yyt->ACF_FLOW_GRAPH.FLOW_NODES = pFLOW_NODES;
 return yyt;
}

tTree mACF_ENTRY
# if defined __STDC__ | defined __cplusplus
(tTree pENTRY_DECL)
# else
(pENTRY_DECL)
tTree pENTRY_DECL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ENTRY])
 yyt->Kind = kACF_ENTRY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ENTRY.Label)
 beginint(yyt->ACF_ENTRY.Line)
 yyt->ACF_ENTRY.ENTRY_DECL = pENTRY_DECL;
 return yyt;
}

tTree mACF_HOME
# if defined __STDC__ | defined __cplusplus
(tTree pHOME_VAR, bool puser_home, tTree pHOME_BODY)
# else
(pHOME_VAR, puser_home, pHOME_BODY)
tTree pHOME_VAR;
bool puser_home;
tTree pHOME_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_HOME])
 yyt->Kind = kACF_HOME;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_HOME.Label)
 beginint(yyt->ACF_HOME.Line)
 yyt->ACF_HOME.HOME_VAR = pHOME_VAR;
 yyt->ACF_HOME.user_home = puser_home;
 yyt->ACF_HOME.HOME_BODY = pHOME_BODY;
 return yyt;
}

tTree mACF_RESIDENT
# if defined __STDC__ | defined __cplusplus
(tTree pRESIDENT_VAR, tTree pRESIDENT_BODY)
# else
(pRESIDENT_VAR, pRESIDENT_BODY)
tTree pRESIDENT_VAR;
tTree pRESIDENT_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_RESIDENT])
 yyt->Kind = kACF_RESIDENT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_RESIDENT.Label)
 beginint(yyt->ACF_RESIDENT.Line)
 yyt->ACF_RESIDENT.RESIDENT_VAR = pRESIDENT_VAR;
 yyt->ACF_RESIDENT.RESIDENT_BODY = pRESIDENT_BODY;
 return yyt;
}

tTree mACF_NEW
# if defined __STDC__ | defined __cplusplus
(tTree pNEW_VAR, tTree pNEW_BODY)
# else
(pNEW_VAR, pNEW_BODY)
tTree pNEW_VAR;
tTree pNEW_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NEW])
 yyt->Kind = kACF_NEW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_NEW.Label)
 beginint(yyt->ACF_NEW.Line)
 yyt->ACF_NEW.NEW_VAR = pNEW_VAR;
 yyt->ACF_NEW.NEW_BODY = pNEW_BODY;
 return yyt;
}

tTree mACF_REDUCTION
# if defined __STDC__ | defined __cplusplus
(bool pis_zero, tTree pREDUCTION_VAR, tTree pREDUCTION_LVAR, tTree pREDUCTION_FUNC, tTree pREDUCTION_BODY)
# else
(pis_zero, pREDUCTION_VAR, pREDUCTION_LVAR, pREDUCTION_FUNC, pREDUCTION_BODY)
bool pis_zero;
tTree pREDUCTION_VAR;
tTree pREDUCTION_LVAR;
tTree pREDUCTION_FUNC;
tTree pREDUCTION_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_REDUCTION])
 yyt->Kind = kACF_REDUCTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_REDUCTION.Label)
 beginint(yyt->ACF_REDUCTION.Line)
 yyt->ACF_REDUCTION.is_zero = pis_zero;
 yyt->ACF_REDUCTION.REDUCTION_VAR = pREDUCTION_VAR;
 yyt->ACF_REDUCTION.REDUCTION_LVAR = pREDUCTION_LVAR;
 yyt->ACF_REDUCTION.REDUCTION_FUNC = pREDUCTION_FUNC;
 yyt->ACF_REDUCTION.REDUCTION_BODY = pREDUCTION_BODY;
 return yyt;
}

tTree mACF_TASK_REGION
# if defined __STDC__ | defined __cplusplus
(int ptask_flag, tTree pTASK_BODY)
# else
(ptask_flag, pTASK_BODY)
int ptask_flag;
tTree pTASK_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_TASK_REGION])
 yyt->Kind = kACF_TASK_REGION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_TASK_REGION.Label)
 beginint(yyt->ACF_TASK_REGION.Line)
 yyt->ACF_TASK_REGION.task_flag = ptask_flag;
 yyt->ACF_TASK_REGION.TASK_BODY = pTASK_BODY;
 return yyt;
}

tTree mACF_PARALLEL
# if defined __STDC__ | defined __cplusplus
(tTree pREDUCTION_VARS, tTree pSHARED_VARS, tTree pLOCAL_VARS, tTree pPARALLEL_BODY)
# else
(pREDUCTION_VARS, pSHARED_VARS, pLOCAL_VARS, pPARALLEL_BODY)
tTree pREDUCTION_VARS;
tTree pSHARED_VARS;
tTree pLOCAL_VARS;
tTree pPARALLEL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_PARALLEL])
 yyt->Kind = kACF_PARALLEL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_PARALLEL.Label)
 beginint(yyt->ACF_PARALLEL.Line)
 yyt->ACF_PARALLEL.REDUCTION_VARS = pREDUCTION_VARS;
 yyt->ACF_PARALLEL.SHARED_VARS = pSHARED_VARS;
 yyt->ACF_PARALLEL.LOCAL_VARS = pLOCAL_VARS;
 yyt->ACF_PARALLEL.PARALLEL_BODY = pPARALLEL_BODY;
 return yyt;
}

tTree mACF_CRITICAL
# if defined __STDC__ | defined __cplusplus
(tTree pCRITICAL_BODY)
# else
(pCRITICAL_BODY)
tTree pCRITICAL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_CRITICAL])
 yyt->Kind = kACF_CRITICAL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_CRITICAL.Label)
 beginint(yyt->ACF_CRITICAL.Line)
 yyt->ACF_CRITICAL.CRITICAL_BODY = pCRITICAL_BODY;
 return yyt;
}

tTree mACF_ON
# if defined __STDC__ | defined __cplusplus
(tTree pON_HOME, tTree pON_SPECS, tTree pON_BODY)
# else
(pON_HOME, pON_SPECS, pON_BODY)
tTree pON_HOME;
tTree pON_SPECS;
tTree pON_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ON])
 yyt->Kind = kACF_ON;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ON.Label)
 beginint(yyt->ACF_ON.Line)
 yyt->ACF_ON.ON_HOME = pON_HOME;
 yyt->ACF_ON.ON_SPECS = pON_SPECS;
 yyt->ACF_ON.ON_BODY = pON_BODY;
 return yyt;
}

tTree mACF_RM_READ
# if defined __STDC__ | defined __cplusplus
(tTree pLOCAL_VAR, tTree pREMOTE_VAR)
# else
(pLOCAL_VAR, pREMOTE_VAR)
tTree pLOCAL_VAR;
tTree pREMOTE_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_RM_READ])
 yyt->Kind = kACF_RM_READ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_RM_READ.Label)
 beginint(yyt->ACF_RM_READ.Line)
 yyt->ACF_RM_READ.LOCAL_VAR = pLOCAL_VAR;
 yyt->ACF_RM_READ.REMOTE_VAR = pREMOTE_VAR;
 return yyt;
}

tTree mACF_RM_WRITE
# if defined __STDC__ | defined __cplusplus
(int pop, tTree pREMOTE_VAR, tTree pLOCAL_DATA)
# else
(pop, pREMOTE_VAR, pLOCAL_DATA)
int pop;
tTree pREMOTE_VAR;
tTree pLOCAL_DATA;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_RM_WRITE])
 yyt->Kind = kACF_RM_WRITE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_RM_WRITE.Label)
 beginint(yyt->ACF_RM_WRITE.Line)
 yyt->ACF_RM_WRITE.op = pop;
 yyt->ACF_RM_WRITE.REMOTE_VAR = pREMOTE_VAR;
 yyt->ACF_RM_WRITE.LOCAL_DATA = pLOCAL_DATA;
 return yyt;
}

tTree mACF_MOVE
# if defined __STDC__ | defined __cplusplus
(tTree pMOVE_STMT)
# else
(pMOVE_STMT)
tTree pMOVE_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_MOVE])
 yyt->Kind = kACF_MOVE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_MOVE.Label)
 beginint(yyt->ACF_MOVE.Line)
 yyt->ACF_MOVE.MOVE_STMT = pMOVE_STMT;
 return yyt;
}

tTree mACF_BARRIER
# if defined __STDC__ | defined __cplusplus
(tTree pBARRIER_VARS)
# else
(pBARRIER_VARS)
tTree pBARRIER_VARS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_BARRIER])
 yyt->Kind = kACF_BARRIER;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_BARRIER.Label)
 beginint(yyt->ACF_BARRIER.Line)
 yyt->ACF_BARRIER.BARRIER_VARS = pBARRIER_VARS;
 return yyt;
}

tTree mACF_UPDATE
# if defined __STDC__ | defined __cplusplus
(tTree pOVERLAP_VAR)
# else
(pOVERLAP_VAR)
tTree pOVERLAP_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_UPDATE])
 yyt->Kind = kACF_UPDATE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_UPDATE.Label)
 beginint(yyt->ACF_UPDATE.Line)
 yyt->ACF_UPDATE.OVERLAP_VAR = pOVERLAP_VAR;
 return yyt;
}

tTree mACF_FLOW_KIND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FLOW_KIND])
 yyt->Kind = kACF_FLOW_KIND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_COMPLEX_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_COMPLEX_FLOW])
 yyt->Kind = kACF_COMPLEX_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_INTERVAL_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_INTERVAL_FLOW])
 yyt->Kind = kACF_INTERVAL_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_SIMPLE_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_SIMPLE_FLOW])
 yyt->Kind = kACF_SIMPLE_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_CLAUSE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_CLAUSE])
 yyt->Kind = kON_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_HOST_CLAUSE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_HOST_CLAUSE])
 yyt->Kind = kON_HOST_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_ALL_CLAUSE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_ALL_CLAUSE])
 yyt->Kind = kON_ALL_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_VAR_CLAUSE
# if defined __STDC__ | defined __cplusplus
(tTree pON_VAR)
# else
(pON_VAR)
tTree pON_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_VAR_CLAUSE])
 yyt->Kind = kON_VAR_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_VAR_CLAUSE.ON_VAR = pON_VAR;
 return yyt;
}

tTree mON_PROC_CLAUSE
# if defined __STDC__ | defined __cplusplus
(tTree pON_PROC)
# else
(pON_PROC)
tTree pON_PROC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_PROC_CLAUSE])
 yyt->Kind = kON_PROC_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_PROC_CLAUSE.ON_PROC = pON_PROC;
 return yyt;
}

tTree mON_TOPOLOGY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_TOPOLOGY])
 yyt->Kind = kON_TOPOLOGY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_ALL
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_ALL])
 yyt->Kind = kON_ALL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_HOST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_HOST])
 yyt->Kind = kON_HOST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_PROCS
# if defined __STDC__ | defined __cplusplus
(tObject ptopid)
# else
(ptopid)
tObject ptopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_PROCS])
 yyt->Kind = kON_PROCS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_PROCS.topid = ptopid;
 return yyt;
}

tTree mON_VAR
# if defined __STDC__ | defined __cplusplus
(tObject ptopid, tObject ptempid, tObject parrayid)
# else
(ptopid, ptempid, parrayid)
tObject ptopid;
tObject ptempid;
tObject parrayid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_VAR])
 yyt->Kind = kON_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_VAR.topid = ptopid;
 yyt->ON_VAR.tempid = ptempid;
 yyt->ON_VAR.arrayid = parrayid;
 return yyt;
}

tTree mON_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_SPEC_LIST])
 yyt->Kind = kON_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_EMPTY])
 yyt->Kind = kON_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_LIST])
 yyt->Kind = kON_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_LIST.Elem = pElem;
 yyt->ON_LIST.Next = pNext;
 return yyt;
}

tTree mON_SPEC
# if defined __STDC__ | defined __cplusplus
(int ptop_dim, int ptemp_dim, int parray_dim, tTree pON_VAL)
# else
(ptop_dim, ptemp_dim, parray_dim, pON_VAL)
int ptop_dim;
int ptemp_dim;
int parray_dim;
tTree pON_VAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_SPEC])
 yyt->Kind = kON_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_SPEC.top_dim = ptop_dim;
 yyt->ON_SPEC.temp_dim = ptemp_dim;
 yyt->ON_SPEC.array_dim = parray_dim;
 yyt->ON_SPEC.ON_VAL = pON_VAL;
 return yyt;
}

tTree mSELECTED_ACF_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_NODE_LIST])
 yyt->Kind = kSELECTED_ACF_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_EMPTY])
 yyt->Kind = kSELECTED_ACF_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_LIST])
 yyt->Kind = kSELECTED_ACF_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_ACF_LIST.Elem = pElem;
 yyt->SELECTED_ACF_LIST.Next = pNext;
 return yyt;
}

tTree mSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
(tTree pSELECT_LIST, tTree pSELECT_ACFS)
# else
(pSELECT_LIST, pSELECT_ACFS)
tTree pSELECT_LIST;
tTree pSELECT_ACFS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_NODE])
 yyt->Kind = kSELECTED_ACF_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_ACF_NODE.SELECT_LIST = pSELECT_LIST;
 yyt->SELECTED_ACF_NODE.SELECT_ACFS = pSELECT_ACFS;
 return yyt;
}

tTree mBT_STMT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_STMT])
 yyt->Kind = kBT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_VAR, tTree pASSIGN_EXP)
# else
(pASSIGN_VAR, pASSIGN_EXP)
tTree pASSIGN_VAR;
tTree pASSIGN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_STMT])
 yyt->Kind = kASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASSIGN_STMT.ASSIGN_VAR = pASSIGN_VAR;
 yyt->ASSIGN_STMT.ASSIGN_EXP = pASSIGN_EXP;
 return yyt;
}

tTree mPTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_VAR, tTree pASSIGN_EXP)
# else
(pASSIGN_VAR, pASSIGN_EXP)
tTree pASSIGN_VAR;
tTree pASSIGN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPTR_ASSIGN_STMT])
 yyt->Kind = kPTR_ASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PTR_ASSIGN_STMT.ASSIGN_VAR = pASSIGN_VAR;
 yyt->PTR_ASSIGN_STMT.ASSIGN_EXP = pASSIGN_EXP;
 return yyt;
}

tTree mLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(int passign_label, tTree pLABEL_VAR)
# else
(passign_label, pLABEL_VAR)
int passign_label;
tTree pLABEL_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_ASSIGN_STMT])
 yyt->Kind = kLABEL_ASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LABEL_ASSIGN_STMT.assign_label = passign_label;
 yyt->LABEL_ASSIGN_STMT.LABEL_VAR = pLABEL_VAR;
 return yyt;
}

tTree mCALL_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pCALL_ID, tTree pCALL_PARAMS)
# else
(pCALL_ID, pCALL_PARAMS)
tTree pCALL_ID;
tTree pCALL_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCALL_STMT])
 yyt->Kind = kCALL_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CALL_STMT.CALL_ID = pCALL_ID;
 yyt->CALL_STMT.CALL_PARAMS = pCALL_PARAMS;
 return yyt;
}

tTree mIO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pIO_SPECS, tTree pIO_ITEMS)
# else
(pID, pIO_SPECS, pIO_ITEMS)
tTree pID;
tTree pIO_SPECS;
tTree pIO_ITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIO_STMT])
 yyt->Kind = kIO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IO_STMT.ID = pID;
 yyt->IO_STMT.IO_SPECS = pIO_SPECS;
 yyt->IO_STMT.IO_ITEMS = pIO_ITEMS;
 return yyt;
}

tTree mGOTO_STMT
# if defined __STDC__ | defined __cplusplus
(int pGOTO_LABEL)
# else
(pGOTO_LABEL)
int pGOTO_LABEL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGOTO_STMT])
 yyt->Kind = kGOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->GOTO_STMT.GOTO_LABEL = pGOTO_LABEL;
 return yyt;
}

tTree mASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pGOTO_VAR, tTree pLABELS)
# else
(pGOTO_VAR, pLABELS)
tTree pGOTO_VAR;
tTree pLABELS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASS_GOTO_STMT])
 yyt->Kind = kASS_GOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASS_GOTO_STMT.GOTO_VAR = pGOTO_VAR;
 yyt->ASS_GOTO_STMT.LABELS = pLABELS;
 return yyt;
}

tTree mCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pGOTO_LABELS, tTree pGOTO_EXP)
# else
(pGOTO_LABELS, pGOTO_EXP)
tTree pGOTO_LABELS;
tTree pGOTO_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_GOTO_STMT])
 yyt->Kind = kCOMP_GOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_GOTO_STMT.GOTO_LABELS = pGOTO_LABELS;
 yyt->COMP_GOTO_STMT.GOTO_EXP = pGOTO_EXP;
 return yyt;
}

tTree mCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pIF_EXP, int pIF_LT_LABEL, int pIF_EQ_LABEL, int pIF_GT_LABEL)
# else
(pIF_EXP, pIF_LT_LABEL, pIF_EQ_LABEL, pIF_GT_LABEL)
tTree pIF_EXP;
int pIF_LT_LABEL;
int pIF_EQ_LABEL;
int pIF_GT_LABEL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_IF_STMT])
 yyt->Kind = kCOMP_IF_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_IF_STMT.IF_EXP = pIF_EXP;
 yyt->COMP_IF_STMT.IF_LT_LABEL = pIF_LT_LABEL;
 yyt->COMP_IF_STMT.IF_EQ_LABEL = pIF_EQ_LABEL;
 yyt->COMP_IF_STMT.IF_GT_LABEL = pIF_GT_LABEL;
 return yyt;
}

tTree mRETURN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pRETURN_EXP)
# else
(pRETURN_EXP)
tTree pRETURN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRETURN_STMT])
 yyt->Kind = kRETURN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RETURN_STMT.RETURN_EXP = pRETURN_EXP;
 return yyt;
}

tTree mPAUSE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPAUSE_CONST)
# else
(pPAUSE_CONST)
tTree pPAUSE_CONST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPAUSE_STMT])
 yyt->Kind = kPAUSE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PAUSE_STMT.PAUSE_CONST = pPAUSE_CONST;
 return yyt;
}

tTree mEXIT_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent ploopid)
# else
(ploopid)
tIdent ploopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXIT_STMT])
 yyt->Kind = kEXIT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXIT_STMT.loopid = ploopid;
 return yyt;
}

tTree mCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent ploopid)
# else
(ploopid)
tIdent ploopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCYCLE_STMT])
 yyt->Kind = kCYCLE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CYCLE_STMT.loopid = ploopid;
 return yyt;
}

tTree mSTOP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pSTOP_CONST)
# else
(pSTOP_CONST)
tTree pSTOP_CONST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTOP_STMT])
 yyt->Kind = kSTOP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STOP_STMT.STOP_CONST = pSTOP_CONST;
 return yyt;
}

tTree mFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pFORMAT_PARAMS)
# else
(pFORMAT_PARAMS)
tTree pFORMAT_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_STMT])
 yyt->Kind = kFORMAT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_STMT.FORMAT_PARAMS = pFORMAT_PARAMS;
 return yyt;
}

tTree mINHERIT_DSP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, tTree pSHAPE, int pflag, int psafety)
# else
(pVAR, pSHAPE, pflag, psafety)
tTree pVAR;
tTree pSHAPE;
int pflag;
int psafety;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINHERIT_DSP_STMT])
 yyt->Kind = kINHERIT_DSP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INHERIT_DSP_STMT.VAR = pVAR;
 yyt->INHERIT_DSP_STMT.SHAPE = pSHAPE;
 yyt->INHERIT_DSP_STMT.flag = pflag;
 yyt->INHERIT_DSP_STMT.safety = psafety;
 return yyt;
}

tTree mCREATE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, tTree pSHAPE, int pflag)
# else
(pVAR, pSHAPE, pflag)
tTree pVAR;
tTree pSHAPE;
int pflag;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCREATE_DSP_STMT])
 yyt->Kind = kCREATE_DSP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CREATE_DSP_STMT.VAR = pVAR;
 yyt->CREATE_DSP_STMT.SHAPE = pSHAPE;
 yyt->CREATE_DSP_STMT.flag = pflag;
 return yyt;
}

tTree mFREE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, int pflag)
# else
(pVAR, pflag)
tTree pVAR;
int pflag;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFREE_DSP_STMT])
 yyt->Kind = kFREE_DSP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FREE_DSP_STMT.VAR = pVAR;
 yyt->FREE_DSP_STMT.flag = pflag;
 return yyt;
}

tTree mALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS, tTree pSTATUS)
# else
(pPARAMS, pSTATUS)
tTree pPARAMS;
tTree pSTATUS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALLOCATE_STMT])
 yyt->Kind = kALLOCATE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALLOCATE_STMT.PARAMS = pPARAMS;
 yyt->ALLOCATE_STMT.STATUS = pSTATUS;
 return yyt;
}

tTree mDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS, tTree pSTATUS)
# else
(pPARAMS, pSTATUS)
tTree pPARAMS;
tTree pSTATUS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEALLOCATE_STMT])
 yyt->Kind = kDEALLOCATE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DEALLOCATE_STMT.PARAMS = pPARAMS;
 yyt->DEALLOCATE_STMT.STATUS = pSTATUS;
 return yyt;
}

tTree mNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS)
# else
(pPARAMS)
tTree pPARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNULLIFY_STMT])
 yyt->Kind = kNULLIFY_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NULLIFY_STMT.PARAMS = pPARAMS;
 return yyt;
}

tTree mREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pRED_FUNC, tTree pRED_PARAMS)
# else
(pRED_FUNC, pRED_PARAMS)
tTree pRED_FUNC;
tTree pRED_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDUCE_STMT])
 yyt->Kind = kREDUCE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDUCE_STMT.RED_FUNC = pRED_FUNC;
 yyt->REDUCE_STMT.RED_PARAMS = pRED_PARAMS;
 return yyt;
}

tTree mMOVE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pTARGET, tTree pSOURCE, tTree pMASK)
# else
(pTARGET, pSOURCE, pMASK)
tTree pTARGET;
tTree pSOURCE;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMOVE_STMT])
 yyt->Kind = kMOVE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MOVE_STMT.TARGET = pTARGET;
 yyt->MOVE_STMT.SOURCE = pSOURCE;
 yyt->MOVE_STMT.MASK = pMASK;
 return yyt;
}

tTree mSCATTER_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent pfunc, tTree pARRAY, tTree pBASE, tTree pINDEXES, tTree pMASK)
# else
(pfunc, pARRAY, pBASE, pINDEXES, pMASK)
tIdent pfunc;
tTree pARRAY;
tTree pBASE;
tTree pINDEXES;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSCATTER_STMT])
 yyt->Kind = kSCATTER_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SCATTER_STMT.func = pfunc;
 yyt->SCATTER_STMT.ARRAY = pARRAY;
 yyt->SCATTER_STMT.BASE = pBASE;
 yyt->SCATTER_STMT.INDEXES = pINDEXES;
 yyt->SCATTER_STMT.MASK = pMASK;
 return yyt;
}

tTree mREALIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pALIGNEE, tTree pALIGN_SOURCE, tTree pALIGN_TARGET)
# else
(pALIGNEE, pALIGN_SOURCE, pALIGN_TARGET)
tTree pALIGNEE;
tTree pALIGN_SOURCE;
tTree pALIGN_TARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREALIGN_STMT])
 yyt->Kind = kREALIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REALIGN_STMT.ALIGNEE = pALIGNEE;
 yyt->REALIGN_STMT.ALIGN_SOURCE = pALIGN_SOURCE;
 yyt->REALIGN_STMT.ALIGN_TARGET = pALIGN_TARGET;
 begintDefinitions(yyt->REALIGN_STMT.distribution)
 return yyt;
}

tTree mREDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pDISTRIBUTEE, tTree pDISTRIBUTION, tTree pTARGET)
# else
(pDISTRIBUTEE, pDISTRIBUTION, pTARGET)
tTree pDISTRIBUTEE;
tTree pDISTRIBUTION;
tTree pTARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDISTRIBUTE_STMT])
 yyt->Kind = kREDISTRIBUTE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDISTRIBUTE_STMT.DISTRIBUTEE = pDISTRIBUTEE;
 yyt->REDISTRIBUTE_STMT.DISTRIBUTION = pDISTRIBUTION;
 yyt->REDISTRIBUTE_STMT.TARGET = pTARGET;
 begintDefinitions(yyt->REDISTRIBUTE_STMT.distribution)
 return yyt;
}

tTree mREG_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
(tTree pSHADOW_VAR, tTree pSHADOW_SIZE)
# else
(pSHADOW_VAR, pSHADOW_SIZE)
tTree pSHADOW_VAR;
tTree pSHADOW_SIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREG_SHADOW_GET])
 yyt->Kind = kREG_SHADOW_GET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REG_SHADOW_GET.SHADOW_VAR = pSHADOW_VAR;
 yyt->REG_SHADOW_GET.SHADOW_SIZE = pSHADOW_SIZE;
 return yyt;
}

tTree mREG_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
(int pop, tTree pSHADOW_VAR, tTree pSHADOW_SIZE)
# else
(pop, pSHADOW_VAR, pSHADOW_SIZE)
int pop;
tTree pSHADOW_VAR;
tTree pSHADOW_SIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREG_SHADOW_PUT])
 yyt->Kind = kREG_SHADOW_PUT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REG_SHADOW_PUT.op = pop;
 yyt->REG_SHADOW_PUT.SHADOW_VAR = pSHADOW_VAR;
 yyt->REG_SHADOW_PUT.SHADOW_SIZE = pSHADOW_SIZE;
 return yyt;
}

tTree mREG_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
(tTree pSHADOW_VAR, tTree pSHADOW_SIZE, tTree pVAL)
# else
(pSHADOW_VAR, pSHADOW_SIZE, pVAL)
tTree pSHADOW_VAR;
tTree pSHADOW_SIZE;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREG_SHADOW_SET])
 yyt->Kind = kREG_SHADOW_SET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REG_SHADOW_SET.SHADOW_VAR = pSHADOW_VAR;
 yyt->REG_SHADOW_SET.SHADOW_SIZE = pSHADOW_SIZE;
 yyt->REG_SHADOW_SET.VAL = pVAL;
 return yyt;
}

tTree mIND_SHADOW_CREATE
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pSHADOW_VAR, tTree pINDEX_VAR, tTree pTMP_INDEX_VAR, tTree pMASK)
# else
(pid, pSHADOW_VAR, pINDEX_VAR, pTMP_INDEX_VAR, pMASK)
int pid;
tTree pSHADOW_VAR;
tTree pINDEX_VAR;
tTree pTMP_INDEX_VAR;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_CREATE])
 yyt->Kind = kIND_SHADOW_CREATE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_CREATE.id = pid;
 yyt->IND_SHADOW_CREATE.SHADOW_VAR = pSHADOW_VAR;
 yyt->IND_SHADOW_CREATE.INDEX_VAR = pINDEX_VAR;
 yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR = pTMP_INDEX_VAR;
 yyt->IND_SHADOW_CREATE.MASK = pMASK;
 return yyt;
}

tTree mIND_SHADOW_FREE
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pINDEX_VAR)
# else
(pid, pINDEX_VAR)
int pid;
tTree pINDEX_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_FREE])
 yyt->Kind = kIND_SHADOW_FREE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_FREE.id = pid;
 yyt->IND_SHADOW_FREE.INDEX_VAR = pINDEX_VAR;
 return yyt;
}

tTree mIND_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pSHADOW_VAR)
# else
(pid, pSHADOW_VAR)
int pid;
tTree pSHADOW_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_GET])
 yyt->Kind = kIND_SHADOW_GET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_GET.id = pid;
 yyt->IND_SHADOW_GET.SHADOW_VAR = pSHADOW_VAR;
 return yyt;
}

tTree mIND_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
(int pid, int pop, tTree pSHADOW_VAR)
# else
(pid, pop, pSHADOW_VAR)
int pid;
int pop;
tTree pSHADOW_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_PUT])
 yyt->Kind = kIND_SHADOW_PUT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_PUT.id = pid;
 yyt->IND_SHADOW_PUT.op = pop;
 yyt->IND_SHADOW_PUT.SHADOW_VAR = pSHADOW_VAR;
 return yyt;
}

tTree mIND_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pSHADOW_VAR, tTree pVAL)
# else
(pid, pSHADOW_VAR, pVAL)
int pid;
tTree pSHADOW_VAR;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_SET])
 yyt->Kind = kIND_SHADOW_SET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_SET.id = pid;
 yyt->IND_SHADOW_SET.SHADOW_VAR = pSHADOW_VAR;
 yyt->IND_SHADOW_SET.VAL = pVAL;
 return yyt;
}

tTree mBROADCAST_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pELEMS, tTree pOWNER_TOP, tTree pOWNER_SPEC)
# else
(pELEMS, pOWNER_TOP, pOWNER_SPEC)
tTree pELEMS;
tTree pOWNER_TOP;
tTree pOWNER_SPEC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBROADCAST_STMT])
 yyt->Kind = kBROADCAST_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BROADCAST_STMT.ELEMS = pELEMS;
 yyt->BROADCAST_STMT.OWNER_TOP = pOWNER_TOP;
 yyt->BROADCAST_STMT.OWNER_SPEC = pOWNER_SPEC;
 return yyt;
}

tTree mREDUCTION_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pREDFUNC, tTree pELEMS, tTree pRED_TOP, tTree pRED_SPEC)
# else
(pREDFUNC, pELEMS, pRED_TOP, pRED_SPEC)
tTree pREDFUNC;
tTree pELEMS;
tTree pRED_TOP;
tTree pRED_SPEC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDUCTION_STMT])
 yyt->Kind = kREDUCTION_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDUCTION_STMT.REDFUNC = pREDFUNC;
 yyt->REDUCTION_STMT.ELEMS = pELEMS;
 yyt->REDUCTION_STMT.RED_TOP = pRED_TOP;
 yyt->REDUCTION_STMT.RED_SPEC = pRED_SPEC;
 return yyt;
}

tTree mDIRTY_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pELEMS)
# else
(pELEMS)
tTree pELEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIRTY_STMT])
 yyt->Kind = kDIRTY_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIRTY_STMT.ELEMS = pELEMS;
 return yyt;
}

tTree mLABEL_USE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_USE_LIST])
 yyt->Kind = kLABEL_USE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mLABEL_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_EMPTY])
 yyt->Kind = kLABEL_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mLABEL_LIST
# if defined __STDC__ | defined __cplusplus
(int pElem, tTree pNext)
# else
(pElem, pNext)
int pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_LIST])
 yyt->Kind = kLABEL_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LABEL_LIST.Elem = pElem;
 yyt->LABEL_LIST.Next = pNext;
 return yyt;
}

tTree mOP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP])
 yyt->Kind = kOP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EQ
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EQ])
 yyt->Kind = kOP_EQ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_NE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_NE])
 yyt->Kind = kOP_NE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LT])
 yyt->Kind = kOP_LT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_GT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GT])
 yyt->Kind = kOP_GT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_GE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GE])
 yyt->Kind = kOP_GE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LE])
 yyt->Kind = kOP_LE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_PLUS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_PLUS])
 yyt->Kind = kOP_PLUS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_MINUS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_MINUS])
 yyt->Kind = kOP_MINUS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_XOR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_XOR])
 yyt->Kind = kOP_XOR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_OR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_OR])
 yyt->Kind = kOP_OR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_CONCAT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_CONCAT])
 yyt->Kind = kOP_CONCAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_TIMES
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_TIMES])
 yyt->Kind = kOP_TIMES;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DIVIDE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DIVIDE])
 yyt->Kind = kOP_DIVIDE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_AND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_AND])
 yyt->Kind = kOP_AND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EQV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EQV])
 yyt->Kind = kOP_EQV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_NEQV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_NEQV])
 yyt->Kind = kOP_NEQV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EXPO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EXPO])
 yyt->Kind = kOP_EXPO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DEFINED
# if defined __STDC__ | defined __cplusplus
(tIdent popname)
# else
(popname)
tIdent popname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DEFINED])
 yyt->Kind = kOP_DEFINED;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_DEFINED.opname = popname;
 return yyt;
}

tTree mOP_ASSIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_ASSIGN])
 yyt->Kind = kOP_ASSIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_NOT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_NOT])
 yyt->Kind = kOP1_NOT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_SIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_SIGN])
 yyt->Kind = kOP1_SIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_PSIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_PSIGN])
 yyt->Kind = kOP1_PSIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBT_EXP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_EXP])
 yyt->Kind = kBT_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_EXP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_EXP])
 yyt->Kind = kDUMMY_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mCONST_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pC)
# else
(pC)
tTree pC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCONST_EXP])
 yyt->Kind = kCONST_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CONST_EXP.C = pC;
 return yyt;
}

tTree mOP_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pEXP_OP, tTree pOPND1, tTree pOPND2)
# else
(pEXP_OP, pOPND1, pOPND2)
tTree pEXP_OP;
tTree pOPND1;
tTree pOPND2;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EXP])
 yyt->Kind = kOP_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_EXP.EXP_OP = pEXP_OP;
 yyt->OP_EXP.OPND1 = pOPND1;
 yyt->OP_EXP.OPND2 = pOPND2;
 return yyt;
}

tTree mOP1_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pEXP_OP1, tTree pOPND)
# else
(pEXP_OP1, pOPND)
tTree pEXP_OP1;
tTree pOPND;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_EXP])
 yyt->Kind = kOP1_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP1_EXP.EXP_OP1 = pEXP_OP1;
 yyt->OP1_EXP.OPND = pOPND;
 return yyt;
}

tTree mSLICE_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pSTART, tTree pSTOP, tTree pINC)
# else
(pSTART, pSTOP, pINC)
tTree pSTART;
tTree pSTOP;
tTree pINC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSLICE_EXP])
 yyt->Kind = kSLICE_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SLICE_EXP.START = pSTART;
 yyt->SLICE_EXP.STOP = pSTOP;
 yyt->SLICE_EXP.INC = pINC;
 return yyt;
}

tTree mVAR_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pV)
# else
(pV)
tTree pV;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_EXP])
 yyt->Kind = kVAR_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_EXP.V = pV;
 return yyt;
}

tTree mFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pFUNC_ID, tTree pFUNC_PARAMS)
# else
(pFUNC_ID, pFUNC_PARAMS)
tTree pFUNC_ID;
tTree pFUNC_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_CALL_EXP])
 yyt->Kind = kFUNC_CALL_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_CALL_EXP.FUNC_ID = pFUNC_ID;
 yyt->FUNC_CALL_EXP.FUNC_PARAMS = pFUNC_PARAMS;
 return yyt;
}

tTree mNAMED_EXP
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pVAL)
# else
(pName, pVAL)
tIdent pName;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMED_EXP])
 yyt->Kind = kNAMED_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMED_EXP.Name = pName;
 yyt->NAMED_EXP.VAL = pVAL;
 return yyt;
}

tTree mDO_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pRANGE, tTree pBODY)
# else
(pDO_ID, pRANGE, pBODY)
tTree pDO_ID;
tTree pRANGE;
tTree pBODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDO_EXP])
 yyt->Kind = kDO_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DO_EXP.DO_ID = pDO_ID;
 yyt->DO_EXP.RANGE = pRANGE;
 yyt->DO_EXP.BODY = pBODY;
 return yyt;
}

tTree mTYPE_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pELEMENTS)
# else
(pID, pELEMENTS)
tTree pID;
tTree pELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_EXP])
 yyt->Kind = kTYPE_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_EXP.ID = pID;
 yyt->TYPE_EXP.ELEMENTS = pELEMENTS;
 return yyt;
}

tTree mARRAY_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pELEMENTS)
# else
(pELEMENTS)
tTree pELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY_EXP])
 yyt->Kind = kARRAY_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY_EXP.ELEMENTS = pELEMENTS;
 return yyt;
}

tTree mPERM_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pVAL, Permutation pperm)
# else
(pVAL, pperm)
tTree pVAL;
Permutation pperm;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPERM_EXP])
 yyt->Kind = kPERM_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PERM_EXP.VAL = pVAL;
 yyt->PERM_EXP.perm = pperm;
 return yyt;
}

tTree mBOUND_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, int pdim, int pkind, int plocal)
# else
(pVAR, pdim, pkind, plocal)
tTree pVAR;
int pdim;
int pkind;
int plocal;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOUND_EXP])
 yyt->Kind = kBOUND_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOUND_EXP.VAR = pVAR;
 yyt->BOUND_EXP.dim = pdim;
 yyt->BOUND_EXP.kind = pkind;
 yyt->BOUND_EXP.local = plocal;
 return yyt;
}

tTree mRANK_EXP
# if defined __STDC__ | defined __cplusplus
(int pkind)
# else
(pkind)
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANK_EXP])
 yyt->Kind = kRANK_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RANK_EXP.kind = pkind;
 return yyt;
}

tTree mBT_EXP_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_EXP_LIST])
 yyt->Kind = kBT_EXP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTE_EMPTY])
 yyt->Kind = kBTE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTE_LIST])
 yyt->Kind = kBTE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTE_LIST.Elem = pElem;
 yyt->BTE_LIST.Next = pNext;
 return yyt;
}

tTree mBT_VAR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_VAR])
 yyt->Kind = kBT_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_VAR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_VAR])
 yyt->Kind = kDUMMY_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUSED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVARNAME)
# else
(pVARNAME)
tTree pVARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSED_VAR])
 yyt->Kind = kUSED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USED_VAR.VARNAME = pVARNAME;
 return yyt;
}

tTree mINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pIND_VAR, tTree pIND_EXPS)
# else
(pIND_VAR, pIND_EXPS)
tTree pIND_VAR;
tTree pIND_EXPS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEXED_VAR])
 yyt->Kind = kINDEXED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEXED_VAR.IND_VAR = pIND_VAR;
 yyt->INDEXED_VAR.IND_EXPS = pIND_EXPS;
 return yyt;
}

tTree mSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pIND_VAR, tTree pIND_EXP)
# else
(pIND_VAR, pIND_EXP)
tTree pIND_VAR;
tTree pIND_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSUBSTRING_VAR])
 yyt->Kind = kSUBSTRING_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SUBSTRING_VAR.IND_VAR = pIND_VAR;
 yyt->SUBSTRING_VAR.IND_EXP = pIND_EXP;
 return yyt;
}

tTree mSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pSELEC_VAR, tTree pSELECTOR)
# else
(pSELEC_VAR, pSELECTOR)
tTree pSELEC_VAR;
tTree pSELECTOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_VAR])
 yyt->Kind = kSELECTED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_VAR.SELEC_VAR = pSELEC_VAR;
 yyt->SELECTED_VAR.SELECTOR = pSELECTOR;
 return yyt;
}

tTree mLOOP_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pLOOP_VARNAME)
# else
(pLOOP_VARNAME)
tTree pLOOP_VARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLOOP_VAR])
 yyt->Kind = kLOOP_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LOOP_VAR.LOOP_VARNAME = pLOOP_VARNAME;
 return yyt;
}

tTree mPERM_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVAL, Permutation pperm)
# else
(pVAL, pperm)
tTree pVAL;
Permutation pperm;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPERM_VAR])
 yyt->Kind = kPERM_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PERM_VAR.VAL = pVAL;
 yyt->PERM_VAR.perm = pperm;
 return yyt;
}

tTree mADDR
# if defined __STDC__ | defined __cplusplus
(tTree pE)
# else
(pE)
tTree pE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kADDR])
 yyt->Kind = kADDR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ADDR.E = pE;
 return yyt;
}

tTree mDO_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pRANGE, tTree pBODY)
# else
(pDO_ID, pRANGE, pBODY)
tTree pDO_ID;
tTree pRANGE;
tTree pBODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDO_VAR])
 yyt->Kind = kDO_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DO_VAR.DO_ID = pDO_ID;
 yyt->DO_VAR.RANGE = pRANGE;
 yyt->DO_VAR.BODY = pBODY;
 return yyt;
}

tTree mREMOTE_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVAR)
# else
(pVAR)
tTree pVAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREMOTE_VAR])
 yyt->Kind = kREMOTE_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REMOTE_VAR.VAR = pVAR;
 return yyt;
}

tTree mBT_VAR_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_VAR_LIST])
 yyt->Kind = kBT_VAR_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTV_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTV_EMPTY])
 yyt->Kind = kBTV_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTV_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTV_LIST])
 yyt->Kind = kBTV_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTV_LIST.Elem = pElem;
 yyt->BTV_LIST.Next = pNext;
 return yyt;
}

tTree mBT_PARAM
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_PARAM])
 yyt->Kind = kBT_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mVAR_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pV)
# else
(pV)
tTree pV;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_PARAM])
 yyt->Kind = kVAR_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_PARAM.V = pV;
 begintDefinitions(yyt->VAR_PARAM.formal)
 beginint(yyt->VAR_PARAM.intent)
 beginint(yyt->VAR_PARAM.layout)
 beginint(yyt->VAR_PARAM.pass_by)
 beginint(yyt->VAR_PARAM.trace)
 return yyt;
}

tTree mVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pE)
# else
(pE)
tTree pE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVALUE_PARAM])
 yyt->Kind = kVALUE_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VALUE_PARAM.E = pE;
 return yyt;
}

tTree mNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pVAL)
# else
(pName, pVAL)
tIdent pName;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMED_PARAM])
 yyt->Kind = kNAMED_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMED_PARAM.Name = pName;
 yyt->NAMED_PARAM.VAL = pVAL;
 return yyt;
}

tTree mPROC_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pP)
# else
(pP)
tTree pP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_PARAM])
 yyt->Kind = kPROC_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_PARAM.P = pP;
 return yyt;
}

tTree mFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pF)
# else
(pF)
tTree pF;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_PARAM])
 yyt->Kind = kFUNC_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_PARAM.F = pF;
 return yyt;
}

tTree mFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
(tStringRef pS)
# else
(pS)
tStringRef pS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_PARAM])
 yyt->Kind = kFORMAT_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_PARAM.S = pS;
 return yyt;
}

tTree mRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
(int plabel)
# else
(plabel)
int plabel;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRETURN_PARAM])
 yyt->Kind = kRETURN_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RETURN_PARAM.label = plabel;
 return yyt;
}

tTree mNO_PARAM
# if defined __STDC__ | defined __cplusplus
(int ptype)
# else
(ptype)
int ptype;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_PARAM])
 yyt->Kind = kNO_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NO_PARAM.type = ptype;
 return yyt;
}

tTree mBT_PARAM_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_PARAM_LIST])
 yyt->Kind = kBT_PARAM_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTP_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTP_EMPTY])
 yyt->Kind = kBTP_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTP_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTP_LIST])
 yyt->Kind = kBTP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTP_LIST.Elem = pElem;
 yyt->BTP_LIST.Next = pNext;
 return yyt;
}

tTree mCONSTANT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCONSTANT])
 yyt->Kind = kCONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(int pvalue)
# else
(pvalue)
int pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOOL_CONSTANT])
 yyt->Kind = kBOOL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOOL_CONSTANT.value = pvalue;
 return yyt;
}

tTree mINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
(int pvalue)
# else
(pvalue)
int pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINT_CONSTANT])
 yyt->Kind = kINT_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INT_CONSTANT.value = pvalue;
 return yyt;
}

tTree mREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue, int pkind)
# else
(pvalue, pkind)
tStringRef pvalue;
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREAL_CONSTANT])
 yyt->Kind = kREAL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REAL_CONSTANT.value = pvalue;
 yyt->REAL_CONSTANT.kind = pkind;
 return yyt;
}

tTree mSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue)
# else
(pvalue)
tStringRef pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTRING_CONSTANT])
 yyt->Kind = kSTRING_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STRING_CONSTANT.value = pvalue;
 return yyt;
}

tTree mCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef prvalue, tStringRef pivalue)
# else
(prvalue, pivalue)
tStringRef prvalue;
tStringRef pivalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMPLEX_CONSTANT])
 yyt->Kind = kCOMPLEX_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMPLEX_CONSTANT.rvalue = prvalue;
 yyt->COMPLEX_CONSTANT.ivalue = pivalue;
 return yyt;
}

tTree mPROC_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_OBJ])
 yyt->Kind = kPROC_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_OBJ.Ident = pIdent;
 begintDefinitions(yyt->PROC_OBJ.Object)
 return yyt;
}

tTree mVAR_OBJ
# if defined __STDC__ | defined __cplusplus
(int pPos, tIdent pIdent)
# else
(pPos, pIdent)
int pPos;
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_OBJ])
 yyt->Kind = kVAR_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_OBJ.Pos = pPos;
 yyt->VAR_OBJ.Ident = pIdent;
 begintDefinitions(yyt->VAR_OBJ.Object)
 begintReaching(yyt->VAR_OBJ.Reaching)
 return yyt;
}

tTree mTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_OBJ])
 yyt->Kind = kTYPE_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TYPE_OBJ.Object)
 return yyt;
}

tTree mREC_COMP
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREC_COMP])
 yyt->Kind = kREC_COMP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REC_COMP.Ident = pIdent;
 begintDefinitions(yyt->REC_COMP.Object)
 return yyt;
}

tTree mTOP_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTOP_OBJ])
 yyt->Kind = kTOP_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TOP_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TOP_OBJ.Object)
 return yyt;
}

tTree mTEMP_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTEMP_OBJ])
 yyt->Kind = kTEMP_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TEMP_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TEMP_OBJ.Object)
 return yyt;
}

tTree mOVERLAP_SPEC
# if defined __STDC__ | defined __cplusplus
(int pleft_size, int pright_size, int pleft_update, int pright_update)
# else
(pleft_size, pright_size, pleft_update, pright_update)
int pleft_size;
int pright_size;
int pleft_update;
int pright_update;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOVERLAP_SPEC])
 yyt->Kind = kOVERLAP_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OVERLAP_SPEC.left_size = pleft_size;
 yyt->OVERLAP_SPEC.right_size = pright_size;
 yyt->OVERLAP_SPEC.left_update = pleft_update;
 yyt->OVERLAP_SPEC.right_update = pright_update;
 return yyt;
}

tTree mDEPENDENCE_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEPENDENCE_INFO])
 yyt->Kind = kDEPENDENCE_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSERIAL_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSERIAL_INFO])
 yyt->Kind = kSERIAL_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mINDEP_INFO
# if defined __STDC__ | defined __cplusplus
(bool puser_independent, int pselection, InfoTree pred_vars, InfoTree pnew_vars)
# else
(puser_independent, pselection, pred_vars, pnew_vars)
bool puser_independent;
int pselection;
InfoTree pred_vars;
InfoTree pnew_vars;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEP_INFO])
 yyt->Kind = kINDEP_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEP_INFO.user_independent = puser_independent;
 yyt->INDEP_INFO.selection = pselection;
 yyt->INDEP_INFO.red_vars = pred_vars;
 yyt->INDEP_INFO.new_vars = pnew_vars;
 return yyt;
}

tTree mVECTOR_INFO
# if defined __STDC__ | defined __cplusplus
(bool pis_independent, int pselection, int ploop_cnt, InfoTree pindependent_vars)
# else
(pis_independent, pselection, ploop_cnt, pindependent_vars)
bool pis_independent;
int pselection;
int ploop_cnt;
InfoTree pindependent_vars;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVECTOR_INFO])
 yyt->Kind = kVECTOR_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VECTOR_INFO.is_independent = pis_independent;
 yyt->VECTOR_INFO.selection = pselection;
 yyt->VECTOR_INFO.loop_cnt = ploop_cnt;
 yyt->VECTOR_INFO.independent_vars = pindependent_vars;
 return yyt;
}

tTree mPARDO_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARDO_INFO])
 yyt->Kind = kPARDO_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mHOME_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kHOME_INFO])
 yyt->Kind = kHOME_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mNO_HOME_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_HOME_INFO])
 yyt->Kind = kNO_HOME_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mCOMM_INFO
# if defined __STDC__ | defined __cplusplus
(InfoTree phome_var, bool pis_local)
# else
(phome_var, pis_local)
InfoTree phome_var;
bool pis_local;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMM_INFO])
 yyt->Kind = kCOMM_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMM_INFO.home_var = phome_var;
 yyt->COMM_INFO.is_local = pis_local;
 return yyt;
}

tTree mON_INFO
# if defined __STDC__ | defined __cplusplus
(tObject pon_id, int pon_dim, int pbase, int pstride)
# else
(pon_id, pon_dim, pbase, pstride)
tObject pon_id;
int pon_dim;
int pbase;
int pstride;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_INFO])
 yyt->Kind = kON_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_INFO.on_id = pon_id;
 yyt->ON_INFO.on_dim = pon_dim;
 yyt->ON_INFO.base = pbase;
 yyt->ON_INFO.stride = pstride;
 return yyt;
}

tTree mPARALLEL_INFO
# if defined __STDC__ | defined __cplusplus
(InfoTree preduction_vars, InfoTree phome_var, InfoTree pnew_vars, InfoTree president_vars)
# else
(preduction_vars, phome_var, pnew_vars, president_vars)
InfoTree preduction_vars;
InfoTree phome_var;
InfoTree pnew_vars;
InfoTree president_vars;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARALLEL_INFO])
 yyt->Kind = kPARALLEL_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PARALLEL_INFO.reduction_vars = preduction_vars;
 yyt->PARALLEL_INFO.home_var = phome_var;
 yyt->PARALLEL_INFO.new_vars = pnew_vars;
 yyt->PARALLEL_INFO.resident_vars = president_vars;
 return yyt;
}

tTree mREACHING_INFO
# if defined __STDC__ | defined __cplusplus
(InfoTree pvar_allocate, InfoTree ptemp_allocate, tDefinitions pvar_distribution, tDefinitions ptemp_distribution)
# else
(pvar_allocate, ptemp_allocate, pvar_distribution, ptemp_distribution)
InfoTree pvar_allocate;
InfoTree ptemp_allocate;
tDefinitions pvar_distribution;
tDefinitions ptemp_distribution;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREACHING_INFO])
 yyt->Kind = kREACHING_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REACHING_INFO.var_allocate = pvar_allocate;
 yyt->REACHING_INFO.temp_allocate = ptemp_allocate;
 yyt->REACHING_INFO.var_distribution = pvar_distribution;
 yyt->REACHING_INFO.temp_distribution = ptemp_distribution;
 return yyt;
}
