# include "Tree.h"
# define yyALLOC(ptr, size)	if ((ptr = (tTree) Tree_PoolFreePtr) >= (tTree) Tree_PoolMaxPtr) \
  ptr = Tree_Alloc (); \
  Tree_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include <stdio.h>
# include "yyTree.w"
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
}
# else
# include <stdio.h>
# include "yyTree.w"
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
# endif

/* line 152 "ast.cg" */


/* very important: default for VAR_OBJ, PROC_OBJ, ... required */

# define begintDefinitions(a)   a = NoDefinitions;

# define begintReaching(a)      a = NoTree;

/* very important: default for Label, Line at ACF_NODE required */

# define beginint(a)            a = 0;

# define beginbool(a)           a = false;

# define begintIdent(a)         a = DefaultId();

  /*********************************************************************
  *                                                                    *
  *   puttStringRef(a), gettStringRef(a)                               *
  *                                                                    *
  *   - otherwise PutTree/GetTree will not work correctly              *
  *                                                                    *
  *********************************************************************/

/* very important: for writing/reading Trees from files */

# define puttStringRef(a)       MyPutStringRef (yyf, a);
# define gettStringRef(a)       a = MyGetStringRef (yyf);

# define getInfoTree(a)         a = NoTree;
# define putInfoTree(a)         ;

# define gettDefinitions(a)     a = NoObject;
# define puttDefinitions(a)     ;

void MyPutStringRef (yyf, t)
FILE *yyf;
tStringRef t;

{ char string[256];
  int  length;
  int  i;

  StGetString (t, string);
  length = strlen (string);

  fwrite (&length, sizeof(length), 1, yyf);

  for (i=0; i<length; i++)
    (void) fputc (string[i], yyf);

} /* MyPutStringRef */

tStringRef MyGetStringRef (yyf)
FILE *yyf;

{ char string[256];
  int  length;
  int  i;

  fread (&length, sizeof(length), 1, yyf);

  for (i=0; i<length; i++)
    string[i] = fgetc (yyf);

  return PutString (string, length);

} /* MyGetStringRef */



static void yyExit () { Exit (1); }

void (* Tree_Exit) () = yyExit;

# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tTree TreeRoot;
unsigned long Tree_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoTree;
char * Tree_PoolFreePtr	= (char *) NoTree;
char * Tree_PoolMaxPtr	= (char *) NoTree;
static unsigned short yyMaxSize	= 0;
unsigned short Tree_NodeSize [311 + 1] = { 0,
 sizeof (yCOMP_UNIT),
 sizeof (yUNIT_NODE_LIST),
 sizeof (yUNIT_EMPTY),
 sizeof (yUNIT_LIST),
 sizeof (yUNIT_NODE),
 sizeof (yMODULE_DECL),
 sizeof (yPROGRAM_DECL),
 sizeof (yPROC_DECL),
 sizeof (yFUNC_DECL),
 sizeof (yMODULE_PROC_DECL),
 sizeof (yBLOCK_DATA_DECL),
 sizeof (yINTERFACE),
 sizeof (yBODY_NODE),
 sizeof (yTYPE_NODE),
 sizeof (yDUMMY_TYPE),
 sizeof (yALIGN_TYPE),
 sizeof (yINTEGER_TYPE),
 sizeof (yREAL_TYPE),
 sizeof (yBOOLEAN_TYPE),
 sizeof (yCOMPLEX_TYPE),
 sizeof (ySTRING_TYPE),
 sizeof (yTYPE_ID),
 sizeof (yARRAY_TYPE),
 sizeof (yRECORD_TYPE),
 sizeof (yPOINTER_TYPE),
 sizeof (ySHAPE_SPEC),
 sizeof (yEXPLICIT_SHAPE),
 sizeof (yASSUMED_SHAPE),
 sizeof (yDEFERRED_SHAPE),
 sizeof (yASSUMED_SIZE),
 sizeof (ySHAPE_SPEC_LIST),
 sizeof (ySHAPE_EMPTY),
 sizeof (ySHAPE_LIST),
 sizeof (yDECL_NODE),
 sizeof (yTYPE_DECL),
 sizeof (yNAME_DECL),
 sizeof (yRENAME_DECL),
 sizeof (yENTITY_DECL),
 sizeof (yVAR_DECL),
 sizeof (yCOMMON_DECL),
 sizeof (yNAMELIST_DECL),
 sizeof (yTEMPLATE_DECL),
 sizeof (yRAGGED_DECL),
 sizeof (yPROCESSORS_DECL),
 sizeof (ySUB_PROCS_DECL),
 sizeof (yINHERIT_DECL),
 sizeof (yRANGE_DECL),
 sizeof (ySTMT_FUNC_DECL),
 sizeof (yINTERFACE_DECL),
 sizeof (yVAR_PARAM_DECL),
 sizeof (yRET_PARAM_DECL),
 sizeof (yIMPLICIT_DECL),
 sizeof (yUSE_DECL),
 sizeof (yONLY_USE_DECL),
 sizeof (yEQV_DECL),
 sizeof (yDATA_DECL),
 sizeof (yFORMAT_DECL),
 sizeof (yDIMENSION_DECL),
 sizeof (yINIT_DATA_DECL),
 sizeof (yTYPESPEC_DECL),
 sizeof (yALLOCATABLE_DECL),
 sizeof (yEXTERNAL_DECL),
 sizeof (yINTENT_DECL),
 sizeof (yINTRINSIC_DECL),
 sizeof (yOPTIONAL_DECL),
 sizeof (yPOINTER_DECL),
 sizeof (ySAVE_DECL),
 sizeof (yTARGET_DECL),
 sizeof (yPARAMETER_DECL),
 sizeof (yPUBLIC_DECL),
 sizeof (yPRIVATE_DECL),
 sizeof (ySEQUENCE_DECL),
 sizeof (yDISTRIBUTE_DECL),
 sizeof (yALIGN_DECL),
 sizeof (yMAP_DECL),
 sizeof (yOVERLAP_DECL),
 sizeof (ySHARED_DECL),
 sizeof (yDYNAMIC_DECL),
 sizeof (yTRACE_DECL),
 sizeof (yTREE_DECL),
 sizeof (ySELECT_DECL),
 sizeof (yHPF_SEQUENCE_DECL),
 sizeof (yNOSEQUENCE_DECL),
 sizeof (yLAYOUT_DECL),
 sizeof (yPASS_BY_DECL),
 sizeof (yMAP_TO_DECL),
 sizeof (yDECL_NODE_LIST),
 sizeof (yDECL_EMPTY),
 sizeof (yDECL_LIST),
 sizeof (yRANGE_SPEC_LIST),
 sizeof (yRANGE_EMPTY),
 sizeof (yRANGE_LIST),
 sizeof (ySELECT_SPEC_LIST),
 sizeof (ySELECT_EMPTY),
 sizeof (ySELECT_LIST),
 sizeof (ySELECT_SPEC),
 sizeof (yDISTRIBUTION_SPEC),
 sizeof (yANY_DISTRIBUTION),
 sizeof (yDEFAULT_DISTRIBUTION),
 sizeof (yREPL_DISTRIBUTION),
 sizeof (yNODE_DISTRIBUTION),
 sizeof (yDIST_FORMAT_LIST),
 sizeof (yDIST_EMPTY),
 sizeof (yDIST_LIST),
 sizeof (yDISTRIBUTION_FORMAT),
 sizeof (yBLOCK_DISTRIBUTION),
 sizeof (yCYCLIC_DISTRIBUTION),
 sizeof (yGEN_BLOCK_DISTRIBUTION),
 sizeof (yINDIRECT_DISTRIBUTION),
 sizeof (yARBITRARY_DISTRIBUTION),
 sizeof (ySERIAL_DISTRIBUTION),
 sizeof (yANY_BLOCK_DISTRIBUTION),
 sizeof (yANY_CYCLIC_DISTRIBUTION),
 sizeof (yANY_GEN_BLOCK_DISTRIBUTION),
 sizeof (yANY_INDIRECT_DISTRIBUTION),
 sizeof (yANY_ARBITRARY_DISTRIBUTION),
 sizeof (yANY_DIM_DISTRIBUTION),
 sizeof (yPROCESSOR_SPEC),
 sizeof (yANY_PROCESSOR_ARRAY),
 sizeof (yDEFAULT_PROCESSOR_ARRAY),
 sizeof (yPROCESSOR_ARRAY),
 sizeof (yPROCESSOR_SUBSET),
 sizeof (yALIGN_SPEC),
 sizeof (yGENERIC_SPEC),
 sizeof (yNO_GENERIC_SPEC),
 sizeof (yID_GENERIC_SPEC),
 sizeof (yOP_GENERIC_SPEC),
 sizeof (yASSIGN_GENERIC_SPEC),
 sizeof (yACF_NODE_LIST),
 sizeof (yACF_EMPTY),
 sizeof (yACF_LIST),
 sizeof (yACF_NODE),
 sizeof (yACF_DUMMY),
 sizeof (yACF_BASIC),
 sizeof (yACF_IF),
 sizeof (yACF_WHERE),
 sizeof (yACF_CASE),
 sizeof (yACF_WHILE),
 sizeof (yACF_REPEAT),
 sizeof (yACF_LOOP),
 sizeof (yACF_DO),
 sizeof (yACF_FORALL),
 sizeof (yACF_FLOW_GRAPH),
 sizeof (yACF_ENTRY),
 sizeof (yACF_HOME),
 sizeof (yACF_RESIDENT),
 sizeof (yACF_NEW),
 sizeof (yACF_REDUCTION),
 sizeof (yACF_TASK_REGION),
 sizeof (yACF_PARALLEL),
 sizeof (yACF_CRITICAL),
 sizeof (yACF_ON),
 sizeof (yACF_RM_READ),
 sizeof (yACF_RM_WRITE),
 sizeof (yACF_MOVE),
 sizeof (yACF_BARRIER),
 sizeof (yACF_UPDATE),
 sizeof (yACF_FLOW_KIND),
 sizeof (yACF_COMPLEX_FLOW),
 sizeof (yACF_INTERVAL_FLOW),
 sizeof (yACF_SIMPLE_FLOW),
 sizeof (yON_CLAUSE),
 sizeof (yON_HOST_CLAUSE),
 sizeof (yON_ALL_CLAUSE),
 sizeof (yON_VAR_CLAUSE),
 sizeof (yON_PROC_CLAUSE),
 sizeof (yON_TOPOLOGY),
 sizeof (yON_ALL),
 sizeof (yON_HOST),
 sizeof (yON_PROCS),
 sizeof (yON_VAR),
 sizeof (yON_SPEC_LIST),
 sizeof (yON_EMPTY),
 sizeof (yON_LIST),
 sizeof (yON_SPEC),
 sizeof (ySELECTED_ACF_NODE_LIST),
 sizeof (ySELECTED_ACF_EMPTY),
 sizeof (ySELECTED_ACF_LIST),
 sizeof (ySELECTED_ACF_NODE),
 sizeof (yBT_STMT),
 sizeof (yASSIGN_STMT),
 sizeof (yPTR_ASSIGN_STMT),
 sizeof (yLABEL_ASSIGN_STMT),
 sizeof (yCALL_STMT),
 sizeof (yIO_STMT),
 sizeof (yGOTO_STMT),
 sizeof (yASS_GOTO_STMT),
 sizeof (yCOMP_GOTO_STMT),
 sizeof (yCOMP_IF_STMT),
 sizeof (yRETURN_STMT),
 sizeof (yPAUSE_STMT),
 sizeof (yEXIT_STMT),
 sizeof (yCYCLE_STMT),
 sizeof (ySTOP_STMT),
 sizeof (yFORMAT_STMT),
 sizeof (yINHERIT_DSP_STMT),
 sizeof (yCREATE_DSP_STMT),
 sizeof (yFREE_DSP_STMT),
 sizeof (yALLOCATE_STMT),
 sizeof (yDEALLOCATE_STMT),
 sizeof (yNULLIFY_STMT),
 sizeof (yREDUCE_STMT),
 sizeof (yMOVE_STMT),
 sizeof (ySCATTER_STMT),
 sizeof (yREALIGN_STMT),
 sizeof (yREDISTRIBUTE_STMT),
 sizeof (yREG_SHADOW_GET),
 sizeof (yREG_SHADOW_PUT),
 sizeof (yREG_SHADOW_SET),
 sizeof (yIND_SHADOW_CREATE),
 sizeof (yIND_SHADOW_FREE),
 sizeof (yIND_SHADOW_GET),
 sizeof (yIND_SHADOW_PUT),
 sizeof (yIND_SHADOW_SET),
 sizeof (yBROADCAST_STMT),
 sizeof (yREDUCTION_STMT),
 sizeof (yDIRTY_STMT),
 sizeof (yLABEL_USE_LIST),
 sizeof (yLABEL_EMPTY),
 sizeof (yLABEL_LIST),
 sizeof (yOP),
 sizeof (yOP_EQ),
 sizeof (yOP_NE),
 sizeof (yOP_LT),
 sizeof (yOP_GT),
 sizeof (yOP_GE),
 sizeof (yOP_LE),
 sizeof (yOP_PLUS),
 sizeof (yOP_MINUS),
 sizeof (yOP_XOR),
 sizeof (yOP_OR),
 sizeof (yOP_CONCAT),
 sizeof (yOP_TIMES),
 sizeof (yOP_DIVIDE),
 sizeof (yOP_AND),
 sizeof (yOP_EQV),
 sizeof (yOP_NEQV),
 sizeof (yOP_EXPO),
 sizeof (yOP_DEFINED),
 sizeof (yOP_ASSIGN),
 sizeof (yOP1_NOT),
 sizeof (yOP1_SIGN),
 sizeof (yOP1_PSIGN),
 sizeof (yBT_EXP),
 sizeof (yDUMMY_EXP),
 sizeof (yCONST_EXP),
 sizeof (yOP_EXP),
 sizeof (yOP1_EXP),
 sizeof (ySLICE_EXP),
 sizeof (yVAR_EXP),
 sizeof (yFUNC_CALL_EXP),
 sizeof (yNAMED_EXP),
 sizeof (yDO_EXP),
 sizeof (yTYPE_EXP),
 sizeof (yARRAY_EXP),
 sizeof (yPERM_EXP),
 sizeof (yBOUND_EXP),
 sizeof (yRANK_EXP),
 sizeof (yBT_EXP_LIST),
 sizeof (yBTE_EMPTY),
 sizeof (yBTE_LIST),
 sizeof (yBT_VAR),
 sizeof (yDUMMY_VAR),
 sizeof (yUSED_VAR),
 sizeof (yINDEXED_VAR),
 sizeof (ySUBSTRING_VAR),
 sizeof (ySELECTED_VAR),
 sizeof (yLOOP_VAR),
 sizeof (yPERM_VAR),
 sizeof (yADDR),
 sizeof (yDO_VAR),
 sizeof (yREMOTE_VAR),
 sizeof (yBT_VAR_LIST),
 sizeof (yBTV_EMPTY),
 sizeof (yBTV_LIST),
 sizeof (yBT_PARAM),
 sizeof (yVAR_PARAM),
 sizeof (yVALUE_PARAM),
 sizeof (yNAMED_PARAM),
 sizeof (yPROC_PARAM),
 sizeof (yFUNC_PARAM),
 sizeof (yFORMAT_PARAM),
 sizeof (yRETURN_PARAM),
 sizeof (yNO_PARAM),
 sizeof (yBT_PARAM_LIST),
 sizeof (yBTP_EMPTY),
 sizeof (yBTP_LIST),
 sizeof (yCONSTANT),
 sizeof (yBOOL_CONSTANT),
 sizeof (yINT_CONSTANT),
 sizeof (yREAL_CONSTANT),
 sizeof (ySTRING_CONSTANT),
 sizeof (yCOMPLEX_CONSTANT),
 sizeof (yPROC_OBJ),
 sizeof (yVAR_OBJ),
 sizeof (yTYPE_OBJ),
 sizeof (yREC_COMP),
 sizeof (yTOP_OBJ),
 sizeof (yTEMP_OBJ),
 sizeof (yOVERLAP_SPEC),
 sizeof (yDEPENDENCE_INFO),
 sizeof (ySERIAL_INFO),
 sizeof (yINDEP_INFO),
 sizeof (yVECTOR_INFO),
 sizeof (yPARDO_INFO),
 sizeof (yHOME_INFO),
 sizeof (yNO_HOME_INFO),
 sizeof (yCOMM_INFO),
 sizeof (yON_INFO),
 sizeof (yPARALLEL_INFO),
 sizeof (yREACHING_INFO),
};
char * Tree_NodeName [311 + 1] = {
 "NoTree",
 "COMP_UNIT",
 "UNIT_NODE_LIST",
 "UNIT_EMPTY",
 "UNIT_LIST",
 "UNIT_NODE",
 "MODULE_DECL",
 "PROGRAM_DECL",
 "PROC_DECL",
 "FUNC_DECL",
 "MODULE_PROC_DECL",
 "BLOCK_DATA_DECL",
 "INTERFACE",
 "BODY_NODE",
 "TYPE_NODE",
 "DUMMY_TYPE",
 "ALIGN_TYPE",
 "INTEGER_TYPE",
 "REAL_TYPE",
 "BOOLEAN_TYPE",
 "COMPLEX_TYPE",
 "STRING_TYPE",
 "TYPE_ID",
 "ARRAY_TYPE",
 "RECORD_TYPE",
 "POINTER_TYPE",
 "SHAPE_SPEC",
 "EXPLICIT_SHAPE",
 "ASSUMED_SHAPE",
 "DEFERRED_SHAPE",
 "ASSUMED_SIZE",
 "SHAPE_SPEC_LIST",
 "SHAPE_EMPTY",
 "SHAPE_LIST",
 "DECL_NODE",
 "TYPE_DECL",
 "NAME_DECL",
 "RENAME_DECL",
 "ENTITY_DECL",
 "VAR_DECL",
 "COMMON_DECL",
 "NAMELIST_DECL",
 "TEMPLATE_DECL",
 "RAGGED_DECL",
 "PROCESSORS_DECL",
 "SUB_PROCS_DECL",
 "INHERIT_DECL",
 "RANGE_DECL",
 "STMT_FUNC_DECL",
 "INTERFACE_DECL",
 "VAR_PARAM_DECL",
 "RET_PARAM_DECL",
 "IMPLICIT_DECL",
 "USE_DECL",
 "ONLY_USE_DECL",
 "EQV_DECL",
 "DATA_DECL",
 "FORMAT_DECL",
 "DIMENSION_DECL",
 "INIT_DATA_DECL",
 "TYPESPEC_DECL",
 "ALLOCATABLE_DECL",
 "EXTERNAL_DECL",
 "INTENT_DECL",
 "INTRINSIC_DECL",
 "OPTIONAL_DECL",
 "POINTER_DECL",
 "SAVE_DECL",
 "TARGET_DECL",
 "PARAMETER_DECL",
 "PUBLIC_DECL",
 "PRIVATE_DECL",
 "SEQUENCE_DECL",
 "DISTRIBUTE_DECL",
 "ALIGN_DECL",
 "MAP_DECL",
 "OVERLAP_DECL",
 "SHARED_DECL",
 "DYNAMIC_DECL",
 "TRACE_DECL",
 "TREE_DECL",
 "SELECT_DECL",
 "HPF_SEQUENCE_DECL",
 "NOSEQUENCE_DECL",
 "LAYOUT_DECL",
 "PASS_BY_DECL",
 "MAP_TO_DECL",
 "DECL_NODE_LIST",
 "DECL_EMPTY",
 "DECL_LIST",
 "RANGE_SPEC_LIST",
 "RANGE_EMPTY",
 "RANGE_LIST",
 "SELECT_SPEC_LIST",
 "SELECT_EMPTY",
 "SELECT_LIST",
 "SELECT_SPEC",
 "DISTRIBUTION_SPEC",
 "ANY_DISTRIBUTION",
 "DEFAULT_DISTRIBUTION",
 "REPL_DISTRIBUTION",
 "NODE_DISTRIBUTION",
 "DIST_FORMAT_LIST",
 "DIST_EMPTY",
 "DIST_LIST",
 "DISTRIBUTION_FORMAT",
 "BLOCK_DISTRIBUTION",
 "CYCLIC_DISTRIBUTION",
 "GEN_BLOCK_DISTRIBUTION",
 "INDIRECT_DISTRIBUTION",
 "ARBITRARY_DISTRIBUTION",
 "SERIAL_DISTRIBUTION",
 "ANY_BLOCK_DISTRIBUTION",
 "ANY_CYCLIC_DISTRIBUTION",
 "ANY_GEN_BLOCK_DISTRIBUTION",
 "ANY_INDIRECT_DISTRIBUTION",
 "ANY_ARBITRARY_DISTRIBUTION",
 "ANY_DIM_DISTRIBUTION",
 "PROCESSOR_SPEC",
 "ANY_PROCESSOR_ARRAY",
 "DEFAULT_PROCESSOR_ARRAY",
 "PROCESSOR_ARRAY",
 "PROCESSOR_SUBSET",
 "ALIGN_SPEC",
 "GENERIC_SPEC",
 "NO_GENERIC_SPEC",
 "ID_GENERIC_SPEC",
 "OP_GENERIC_SPEC",
 "ASSIGN_GENERIC_SPEC",
 "ACF_NODE_LIST",
 "ACF_EMPTY",
 "ACF_LIST",
 "ACF_NODE",
 "ACF_DUMMY",
 "ACF_BASIC",
 "ACF_IF",
 "ACF_WHERE",
 "ACF_CASE",
 "ACF_WHILE",
 "ACF_REPEAT",
 "ACF_LOOP",
 "ACF_DO",
 "ACF_FORALL",
 "ACF_FLOW_GRAPH",
 "ACF_ENTRY",
 "ACF_HOME",
 "ACF_RESIDENT",
 "ACF_NEW",
 "ACF_REDUCTION",
 "ACF_TASK_REGION",
 "ACF_PARALLEL",
 "ACF_CRITICAL",
 "ACF_ON",
 "ACF_RM_READ",
 "ACF_RM_WRITE",
 "ACF_MOVE",
 "ACF_BARRIER",
 "ACF_UPDATE",
 "ACF_FLOW_KIND",
 "ACF_COMPLEX_FLOW",
 "ACF_INTERVAL_FLOW",
 "ACF_SIMPLE_FLOW",
 "ON_CLAUSE",
 "ON_HOST_CLAUSE",
 "ON_ALL_CLAUSE",
 "ON_VAR_CLAUSE",
 "ON_PROC_CLAUSE",
 "ON_TOPOLOGY",
 "ON_ALL",
 "ON_HOST",
 "ON_PROCS",
 "ON_VAR",
 "ON_SPEC_LIST",
 "ON_EMPTY",
 "ON_LIST",
 "ON_SPEC",
 "SELECTED_ACF_NODE_LIST",
 "SELECTED_ACF_EMPTY",
 "SELECTED_ACF_LIST",
 "SELECTED_ACF_NODE",
 "BT_STMT",
 "ASSIGN_STMT",
 "PTR_ASSIGN_STMT",
 "LABEL_ASSIGN_STMT",
 "CALL_STMT",
 "IO_STMT",
 "GOTO_STMT",
 "ASS_GOTO_STMT",
 "COMP_GOTO_STMT",
 "COMP_IF_STMT",
 "RETURN_STMT",
 "PAUSE_STMT",
 "EXIT_STMT",
 "CYCLE_STMT",
 "STOP_STMT",
 "FORMAT_STMT",
 "INHERIT_DSP_STMT",
 "CREATE_DSP_STMT",
 "FREE_DSP_STMT",
 "ALLOCATE_STMT",
 "DEALLOCATE_STMT",
 "NULLIFY_STMT",
 "REDUCE_STMT",
 "MOVE_STMT",
 "SCATTER_STMT",
 "REALIGN_STMT",
 "REDISTRIBUTE_STMT",
 "REG_SHADOW_GET",
 "REG_SHADOW_PUT",
 "REG_SHADOW_SET",
 "IND_SHADOW_CREATE",
 "IND_SHADOW_FREE",
 "IND_SHADOW_GET",
 "IND_SHADOW_PUT",
 "IND_SHADOW_SET",
 "BROADCAST_STMT",
 "REDUCTION_STMT",
 "DIRTY_STMT",
 "LABEL_USE_LIST",
 "LABEL_EMPTY",
 "LABEL_LIST",
 "OP",
 "OP_EQ",
 "OP_NE",
 "OP_LT",
 "OP_GT",
 "OP_GE",
 "OP_LE",
 "OP_PLUS",
 "OP_MINUS",
 "OP_XOR",
 "OP_OR",
 "OP_CONCAT",
 "OP_TIMES",
 "OP_DIVIDE",
 "OP_AND",
 "OP_EQV",
 "OP_NEQV",
 "OP_EXPO",
 "OP_DEFINED",
 "OP_ASSIGN",
 "OP1_NOT",
 "OP1_SIGN",
 "OP1_PSIGN",
 "BT_EXP",
 "DUMMY_EXP",
 "CONST_EXP",
 "OP_EXP",
 "OP1_EXP",
 "SLICE_EXP",
 "VAR_EXP",
 "FUNC_CALL_EXP",
 "NAMED_EXP",
 "DO_EXP",
 "TYPE_EXP",
 "ARRAY_EXP",
 "PERM_EXP",
 "BOUND_EXP",
 "RANK_EXP",
 "BT_EXP_LIST",
 "BTE_EMPTY",
 "BTE_LIST",
 "BT_VAR",
 "DUMMY_VAR",
 "USED_VAR",
 "INDEXED_VAR",
 "SUBSTRING_VAR",
 "SELECTED_VAR",
 "LOOP_VAR",
 "PERM_VAR",
 "ADDR",
 "DO_VAR",
 "REMOTE_VAR",
 "BT_VAR_LIST",
 "BTV_EMPTY",
 "BTV_LIST",
 "BT_PARAM",
 "VAR_PARAM",
 "VALUE_PARAM",
 "NAMED_PARAM",
 "PROC_PARAM",
 "FUNC_PARAM",
 "FORMAT_PARAM",
 "RETURN_PARAM",
 "NO_PARAM",
 "BT_PARAM_LIST",
 "BTP_EMPTY",
 "BTP_LIST",
 "CONSTANT",
 "BOOL_CONSTANT",
 "INT_CONSTANT",
 "REAL_CONSTANT",
 "STRING_CONSTANT",
 "COMPLEX_CONSTANT",
 "PROC_OBJ",
 "VAR_OBJ",
 "TYPE_OBJ",
 "REC_COMP",
 "TOP_OBJ",
 "TEMP_OBJ",
 "OVERLAP_SPEC",
 "DEPENDENCE_INFO",
 "SERIAL_INFO",
 "INDEP_INFO",
 "VECTOR_INFO",
 "PARDO_INFO",
 "HOME_INFO",
 "NO_HOME_INFO",
 "COMM_INFO",
 "ON_INFO",
 "PARALLEL_INFO",
 "REACHING_INFO",
};
static Tree_tKind yyTypeRange [311 + 1] = { 0,
 kCOMP_UNIT,
 kUNIT_LIST,
 kUNIT_EMPTY,
 kUNIT_LIST,
 kINTERFACE,
 kMODULE_DECL,
 kPROGRAM_DECL,
 kPROC_DECL,
 kFUNC_DECL,
 kMODULE_PROC_DECL,
 kBLOCK_DATA_DECL,
 kINTERFACE,
 kBODY_NODE,
 kPOINTER_TYPE,
 kDUMMY_TYPE,
 kALIGN_TYPE,
 kINTEGER_TYPE,
 kREAL_TYPE,
 kBOOLEAN_TYPE,
 kCOMPLEX_TYPE,
 kSTRING_TYPE,
 kTYPE_ID,
 kARRAY_TYPE,
 kRECORD_TYPE,
 kPOINTER_TYPE,
 kASSUMED_SIZE,
 kEXPLICIT_SHAPE,
 kASSUMED_SHAPE,
 kDEFERRED_SHAPE,
 kASSUMED_SIZE,
 kSHAPE_LIST,
 kSHAPE_EMPTY,
 kSHAPE_LIST,
 kMAP_TO_DECL,
 kTYPE_DECL,
 kNAME_DECL,
 kRENAME_DECL,
 kENTITY_DECL,
 kVAR_DECL,
 kCOMMON_DECL,
 kNAMELIST_DECL,
 kTEMPLATE_DECL,
 kRAGGED_DECL,
 kPROCESSORS_DECL,
 kSUB_PROCS_DECL,
 kINHERIT_DECL,
 kRANGE_DECL,
 kSTMT_FUNC_DECL,
 kINTERFACE_DECL,
 kVAR_PARAM_DECL,
 kRET_PARAM_DECL,
 kIMPLICIT_DECL,
 kUSE_DECL,
 kONLY_USE_DECL,
 kEQV_DECL,
 kDATA_DECL,
 kFORMAT_DECL,
 kDIMENSION_DECL,
 kINIT_DATA_DECL,
 kTYPESPEC_DECL,
 kALLOCATABLE_DECL,
 kEXTERNAL_DECL,
 kINTENT_DECL,
 kINTRINSIC_DECL,
 kOPTIONAL_DECL,
 kPOINTER_DECL,
 kSAVE_DECL,
 kTARGET_DECL,
 kPARAMETER_DECL,
 kPUBLIC_DECL,
 kPRIVATE_DECL,
 kSEQUENCE_DECL,
 kDISTRIBUTE_DECL,
 kALIGN_DECL,
 kMAP_DECL,
 kOVERLAP_DECL,
 kSHARED_DECL,
 kDYNAMIC_DECL,
 kTRACE_DECL,
 kTREE_DECL,
 kSELECT_DECL,
 kHPF_SEQUENCE_DECL,
 kNOSEQUENCE_DECL,
 kLAYOUT_DECL,
 kPASS_BY_DECL,
 kMAP_TO_DECL,
 kDECL_LIST,
 kDECL_EMPTY,
 kDECL_LIST,
 kRANGE_LIST,
 kRANGE_EMPTY,
 kRANGE_LIST,
 kSELECT_LIST,
 kSELECT_EMPTY,
 kSELECT_LIST,
 kSELECT_SPEC,
 kNODE_DISTRIBUTION,
 kANY_DISTRIBUTION,
 kDEFAULT_DISTRIBUTION,
 kREPL_DISTRIBUTION,
 kNODE_DISTRIBUTION,
 kDIST_LIST,
 kDIST_EMPTY,
 kDIST_LIST,
 kANY_DIM_DISTRIBUTION,
 kBLOCK_DISTRIBUTION,
 kCYCLIC_DISTRIBUTION,
 kGEN_BLOCK_DISTRIBUTION,
 kINDIRECT_DISTRIBUTION,
 kARBITRARY_DISTRIBUTION,
 kSERIAL_DISTRIBUTION,
 kANY_BLOCK_DISTRIBUTION,
 kANY_CYCLIC_DISTRIBUTION,
 kANY_GEN_BLOCK_DISTRIBUTION,
 kANY_INDIRECT_DISTRIBUTION,
 kANY_ARBITRARY_DISTRIBUTION,
 kANY_DIM_DISTRIBUTION,
 kPROCESSOR_SUBSET,
 kANY_PROCESSOR_ARRAY,
 kDEFAULT_PROCESSOR_ARRAY,
 kPROCESSOR_ARRAY,
 kPROCESSOR_SUBSET,
 kALIGN_SPEC,
 kASSIGN_GENERIC_SPEC,
 kNO_GENERIC_SPEC,
 kID_GENERIC_SPEC,
 kOP_GENERIC_SPEC,
 kASSIGN_GENERIC_SPEC,
 kACF_LIST,
 kACF_EMPTY,
 kACF_LIST,
 kACF_UPDATE,
 kACF_DUMMY,
 kACF_BASIC,
 kACF_IF,
 kACF_WHERE,
 kACF_CASE,
 kACF_WHILE,
 kACF_REPEAT,
 kACF_LOOP,
 kACF_DO,
 kACF_FORALL,
 kACF_FLOW_GRAPH,
 kACF_ENTRY,
 kACF_HOME,
 kACF_RESIDENT,
 kACF_NEW,
 kACF_REDUCTION,
 kACF_TASK_REGION,
 kACF_PARALLEL,
 kACF_CRITICAL,
 kACF_ON,
 kACF_RM_READ,
 kACF_RM_WRITE,
 kACF_MOVE,
 kACF_BARRIER,
 kACF_UPDATE,
 kACF_SIMPLE_FLOW,
 kACF_COMPLEX_FLOW,
 kACF_INTERVAL_FLOW,
 kACF_SIMPLE_FLOW,
 kON_PROC_CLAUSE,
 kON_HOST_CLAUSE,
 kON_ALL_CLAUSE,
 kON_VAR_CLAUSE,
 kON_PROC_CLAUSE,
 kON_VAR,
 kON_ALL,
 kON_HOST,
 kON_PROCS,
 kON_VAR,
 kON_LIST,
 kON_EMPTY,
 kON_LIST,
 kON_SPEC,
 kSELECTED_ACF_LIST,
 kSELECTED_ACF_EMPTY,
 kSELECTED_ACF_LIST,
 kSELECTED_ACF_NODE,
 kDIRTY_STMT,
 kASSIGN_STMT,
 kPTR_ASSIGN_STMT,
 kLABEL_ASSIGN_STMT,
 kCALL_STMT,
 kIO_STMT,
 kGOTO_STMT,
 kASS_GOTO_STMT,
 kCOMP_GOTO_STMT,
 kCOMP_IF_STMT,
 kRETURN_STMT,
 kPAUSE_STMT,
 kEXIT_STMT,
 kCYCLE_STMT,
 kSTOP_STMT,
 kFORMAT_STMT,
 kINHERIT_DSP_STMT,
 kCREATE_DSP_STMT,
 kFREE_DSP_STMT,
 kALLOCATE_STMT,
 kDEALLOCATE_STMT,
 kNULLIFY_STMT,
 kREDUCE_STMT,
 kMOVE_STMT,
 kSCATTER_STMT,
 kREALIGN_STMT,
 kREDISTRIBUTE_STMT,
 kREG_SHADOW_GET,
 kREG_SHADOW_PUT,
 kREG_SHADOW_SET,
 kIND_SHADOW_CREATE,
 kIND_SHADOW_FREE,
 kIND_SHADOW_GET,
 kIND_SHADOW_PUT,
 kIND_SHADOW_SET,
 kBROADCAST_STMT,
 kREDUCTION_STMT,
 kDIRTY_STMT,
 kLABEL_LIST,
 kLABEL_EMPTY,
 kLABEL_LIST,
 kOP1_PSIGN,
 kOP_EQ,
 kOP_NE,
 kOP_LT,
 kOP_GT,
 kOP_GE,
 kOP_LE,
 kOP_PLUS,
 kOP_MINUS,
 kOP_XOR,
 kOP_OR,
 kOP_CONCAT,
 kOP_TIMES,
 kOP_DIVIDE,
 kOP_AND,
 kOP_EQV,
 kOP_NEQV,
 kOP_EXPO,
 kOP_DEFINED,
 kOP_ASSIGN,
 kOP1_NOT,
 kOP1_SIGN,
 kOP1_PSIGN,
 kRANK_EXP,
 kDUMMY_EXP,
 kCONST_EXP,
 kOP_EXP,
 kOP1_EXP,
 kSLICE_EXP,
 kVAR_EXP,
 kFUNC_CALL_EXP,
 kNAMED_EXP,
 kDO_EXP,
 kTYPE_EXP,
 kARRAY_EXP,
 kPERM_EXP,
 kBOUND_EXP,
 kRANK_EXP,
 kBTE_LIST,
 kBTE_EMPTY,
 kBTE_LIST,
 kREMOTE_VAR,
 kDUMMY_VAR,
 kUSED_VAR,
 kINDEXED_VAR,
 kSUBSTRING_VAR,
 kSELECTED_VAR,
 kLOOP_VAR,
 kPERM_VAR,
 kADDR,
 kDO_VAR,
 kREMOTE_VAR,
 kBTV_LIST,
 kBTV_EMPTY,
 kBTV_LIST,
 kNO_PARAM,
 kVAR_PARAM,
 kVALUE_PARAM,
 kNAMED_PARAM,
 kPROC_PARAM,
 kFUNC_PARAM,
 kFORMAT_PARAM,
 kRETURN_PARAM,
 kNO_PARAM,
 kBTP_LIST,
 kBTP_EMPTY,
 kBTP_LIST,
 kCOMPLEX_CONSTANT,
 kBOOL_CONSTANT,
 kINT_CONSTANT,
 kREAL_CONSTANT,
 kSTRING_CONSTANT,
 kCOMPLEX_CONSTANT,
 kPROC_OBJ,
 kVAR_OBJ,
 kTYPE_OBJ,
 kREC_COMP,
 kTOP_OBJ,
 kTEMP_OBJ,
 kOVERLAP_SPEC,
 kPARDO_INFO,
 kSERIAL_INFO,
 kINDEP_INFO,
 kVECTOR_INFO,
 kPARDO_INFO,
 kON_INFO,
 kNO_HOME_INFO,
 kCOMM_INFO,
 kON_INFO,
 kPARALLEL_INFO,
 kREACHING_INFO,
};

tTree Tree_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 311; i ++) {
   Tree_NodeSize [i] = (Tree_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (Tree_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 Tree_PoolFreePtr = yyBlockList->yyBlock;
 Tree_PoolMaxPtr = Tree_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 Tree_HeapUsed += yyBlockSize;
 return (tTree) Tree_PoolFreePtr;
}

tTree MakeTree
# if defined __STDC__ | defined __cplusplus
 (Tree_tKind yyKind)
# else
 (yyKind) Tree_tKind yyKind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

bool Tree_IsType
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt, register Tree_tKind yyKind)
# else
 (yyt, yyKind) register tTree yyt; register Tree_tKind yyKind;
# endif
{
 return yyt != NoTree && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}


tTree mCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
(tTree pCOMP_ELEMENTS, tTree pUSED_ELEMENTS)
# else
(pCOMP_ELEMENTS, pUSED_ELEMENTS)
tTree pCOMP_ELEMENTS;
tTree pUSED_ELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_UNIT])
 yyt->Kind = kCOMP_UNIT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_UNIT.COMP_ELEMENTS = pCOMP_ELEMENTS;
 yyt->COMP_UNIT.USED_ELEMENTS = pUSED_ELEMENTS;
 return yyt;
}

tTree mUNIT_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_NODE_LIST])
 yyt->Kind = kUNIT_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUNIT_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_EMPTY])
 yyt->Kind = kUNIT_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUNIT_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_LIST])
 yyt->Kind = kUNIT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->UNIT_LIST.Elem = pElem;
 yyt->UNIT_LIST.Next = pNext;
 return yyt;
}

tTree mUNIT_NODE
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUNIT_NODE])
 yyt->Kind = kUNIT_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->UNIT_NODE.Ident = pIdent;
 yyt->UNIT_NODE.Line = pLine;
 begintDefinitions(yyt->UNIT_NODE.Object)
 return yyt;
}

tTree mMODULE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pMODULE_BODY)
# else
(pIdent, pLine, pMODULE_BODY)
tIdent pIdent;
int pLine;
tTree pMODULE_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMODULE_DECL])
 yyt->Kind = kMODULE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MODULE_DECL.Ident = pIdent;
 yyt->MODULE_DECL.Line = pLine;
 begintDefinitions(yyt->MODULE_DECL.Object)
 yyt->MODULE_DECL.MODULE_BODY = pMODULE_BODY;
 return yyt;
}

tTree mPROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pPROGRAM_BODY)
# else
(pIdent, pLine, pFORMALS, pPROGRAM_BODY)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pPROGRAM_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROGRAM_DECL])
 yyt->Kind = kPROGRAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROGRAM_DECL.Ident = pIdent;
 yyt->PROGRAM_DECL.Line = pLine;
 begintDefinitions(yyt->PROGRAM_DECL.Object)
 yyt->PROGRAM_DECL.FORMALS = pFORMALS;
 yyt->PROGRAM_DECL.PROGRAM_BODY = pPROGRAM_BODY;
 return yyt;
}

tTree mPROC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pPROC_BODY)
# else
(pIdent, pLine, pFORMALS, pPROC_BODY)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pPROC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_DECL])
 yyt->Kind = kPROC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_DECL.Ident = pIdent;
 yyt->PROC_DECL.Line = pLine;
 begintDefinitions(yyt->PROC_DECL.Object)
 yyt->PROC_DECL.FORMALS = pFORMALS;
 yyt->PROC_DECL.PROC_BODY = pPROC_BODY;
 beginbool(yyt->PROC_DECL.IsRecursive)
 beginbool(yyt->PROC_DECL.IsPure)
 begintIdent(yyt->PROC_DECL.HPFExtrinsic)
 return yyt;
}

tTree mFUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pFUNC_BODY, tTree pRESULT_TYPE, tIdent pRESULT_ID)
# else
(pIdent, pLine, pFORMALS, pFUNC_BODY, pRESULT_TYPE, pRESULT_ID)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pFUNC_BODY;
tTree pRESULT_TYPE;
tIdent pRESULT_ID;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_DECL])
 yyt->Kind = kFUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_DECL.Ident = pIdent;
 yyt->FUNC_DECL.Line = pLine;
 begintDefinitions(yyt->FUNC_DECL.Object)
 yyt->FUNC_DECL.FORMALS = pFORMALS;
 yyt->FUNC_DECL.FUNC_BODY = pFUNC_BODY;
 yyt->FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 yyt->FUNC_DECL.RESULT_ID = pRESULT_ID;
 beginbool(yyt->FUNC_DECL.IsRecursive)
 beginbool(yyt->FUNC_DECL.IsPure)
 begintIdent(yyt->FUNC_DECL.HPFExtrinsic)
 return yyt;
}

tTree mMODULE_PROC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMODULE_PROC_DECL])
 yyt->Kind = kMODULE_PROC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MODULE_PROC_DECL.Ident = pIdent;
 yyt->MODULE_PROC_DECL.Line = pLine;
 begintDefinitions(yyt->MODULE_PROC_DECL.Object)
 return yyt;
}

tTree mBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDATA_BODY)
# else
(pIdent, pLine, pDATA_BODY)
tIdent pIdent;
int pLine;
tTree pDATA_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBLOCK_DATA_DECL])
 yyt->Kind = kBLOCK_DATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BLOCK_DATA_DECL.Ident = pIdent;
 yyt->BLOCK_DATA_DECL.Line = pLine;
 begintDefinitions(yyt->BLOCK_DATA_DECL.Object)
 yyt->BLOCK_DATA_DECL.DATA_BODY = pDATA_BODY;
 return yyt;
}

tTree mINTERFACE
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pSPEC, tTree pITEMS)
# else
(pIdent, pLine, pSPEC, pITEMS)
tIdent pIdent;
int pLine;
tTree pSPEC;
tTree pITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTERFACE])
 yyt->Kind = kINTERFACE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTERFACE.Ident = pIdent;
 yyt->INTERFACE.Line = pLine;
 begintDefinitions(yyt->INTERFACE.Object)
 yyt->INTERFACE.SPEC = pSPEC;
 yyt->INTERFACE.ITEMS = pITEMS;
 return yyt;
}

tTree mBODY_NODE
# if defined __STDC__ | defined __cplusplus
(tTree pDECLS, tTree pSTATS, tTree pINTERNALS)
# else
(pDECLS, pSTATS, pINTERNALS)
tTree pDECLS;
tTree pSTATS;
tTree pINTERNALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBODY_NODE])
 yyt->Kind = kBODY_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BODY_NODE.DECLS = pDECLS;
 yyt->BODY_NODE.STATS = pSTATS;
 yyt->BODY_NODE.INTERNALS = pINTERNALS;
 return yyt;
}

tTree mTYPE_NODE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_NODE])
 yyt->Kind = kTYPE_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_TYPE])
 yyt->Kind = kDUMMY_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mALIGN_TYPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_TYPE])
 yyt->Kind = kALIGN_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTEGER_TYPE])
 yyt->Kind = kINTEGER_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTEGER_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mREAL_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREAL_TYPE])
 yyt->Kind = kREAL_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REAL_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOOLEAN_TYPE])
 yyt->Kind = kBOOLEAN_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOOLEAN_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMPLEX_TYPE])
 yyt->Kind = kCOMPLEX_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMPLEX_TYPE.SIZE = pSIZE;
 return yyt;
}

tTree mSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pLENGTH)
# else
(pLENGTH)
tTree pLENGTH;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTRING_TYPE])
 yyt->Kind = kSTRING_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STRING_TYPE.LENGTH = pLENGTH;
 return yyt;
}

tTree mTYPE_ID
# if defined __STDC__ | defined __cplusplus
(tTree pID)
# else
(pID)
tTree pID;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_ID])
 yyt->Kind = kTYPE_ID;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_ID.ID = pID;
 return yyt;
}

tTree mARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY_INDEX_TYPES, tTree pARRAY_COMP_TYPE)
# else
(pARRAY_INDEX_TYPES, pARRAY_COMP_TYPE)
tTree pARRAY_INDEX_TYPES;
tTree pARRAY_COMP_TYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY_TYPE])
 yyt->Kind = kARRAY_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES = pARRAY_INDEX_TYPES;
 yyt->ARRAY_TYPE.ARRAY_COMP_TYPE = pARRAY_COMP_TYPE;
 return yyt;
}

tTree mRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pCOMPONENTS)
# else
(pName, pCOMPONENTS)
tIdent pName;
tTree pCOMPONENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRECORD_TYPE])
 yyt->Kind = kRECORD_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RECORD_TYPE.Name = pName;
 yyt->RECORD_TYPE.COMPONENTS = pCOMPONENTS;
 return yyt;
}

tTree mPOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
(tTree pPTR_COMP)
# else
(pPTR_COMP)
tTree pPTR_COMP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOINTER_TYPE])
 yyt->Kind = kPOINTER_TYPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POINTER_TYPE.PTR_COMP = pPTR_COMP;
 return yyt;
}

tTree mSHAPE_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_SPEC])
 yyt->Kind = kSHAPE_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->SHAPE_SPEC.Overlap)
 return yyt;
}

tTree mEXPLICIT_SHAPE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER, tTree pUPPER)
# else
(pLOWER, pUPPER)
tTree pLOWER;
tTree pUPPER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXPLICIT_SHAPE])
 yyt->Kind = kEXPLICIT_SHAPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->EXPLICIT_SHAPE.Overlap)
 yyt->EXPLICIT_SHAPE.LOWER = pLOWER;
 yyt->EXPLICIT_SHAPE.UPPER = pUPPER;
 return yyt;
}

tTree mASSUMED_SHAPE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER)
# else
(pLOWER)
tTree pLOWER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSUMED_SHAPE])
 yyt->Kind = kASSUMED_SHAPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->ASSUMED_SHAPE.Overlap)
 yyt->ASSUMED_SHAPE.LOWER = pLOWER;
 return yyt;
}

tTree mDEFERRED_SHAPE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEFERRED_SHAPE])
 yyt->Kind = kDEFERRED_SHAPE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->DEFERRED_SHAPE.Overlap)
 return yyt;
}

tTree mASSUMED_SIZE
# if defined __STDC__ | defined __cplusplus
(tTree pLOWER)
# else
(pLOWER)
tTree pLOWER;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSUMED_SIZE])
 yyt->Kind = kASSUMED_SIZE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 begintTree(yyt->ASSUMED_SIZE.Overlap)
 yyt->ASSUMED_SIZE.LOWER = pLOWER;
 return yyt;
}

tTree mSHAPE_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_SPEC_LIST])
 yyt->Kind = kSHAPE_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSHAPE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_EMPTY])
 yyt->Kind = kSHAPE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSHAPE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHAPE_LIST])
 yyt->Kind = kSHAPE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SHAPE_LIST.Elem = pElem;
 yyt->SHAPE_LIST.Next = pNext;
 return yyt;
}

tTree mDECL_NODE
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_NODE])
 yyt->Kind = kDECL_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DECL_NODE.Ident = pIdent;
 yyt->DECL_NODE.Line = pLine;
 return yyt;
}

tTree mTYPE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_DECL])
 yyt->Kind = kTYPE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_DECL.Ident = pIdent;
 yyt->TYPE_DECL.Line = pLine;
 yyt->TYPE_DECL.VAL = pVAL;
 return yyt;
}

tTree mNAME_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAME_DECL])
 yyt->Kind = kNAME_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAME_DECL.Ident = pIdent;
 yyt->NAME_DECL.Line = pLine;
 return yyt;
}

tTree mRENAME_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent poldname)
# else
(pIdent, pLine, poldname)
tIdent pIdent;
int pLine;
tIdent poldname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRENAME_DECL])
 yyt->Kind = kRENAME_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RENAME_DECL.Ident = pIdent;
 yyt->RENAME_DECL.Line = pLine;
 yyt->RENAME_DECL.oldname = poldname;
 return yyt;
}

tTree mENTITY_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pATTRIBUTES)
# else
(pIdent, pLine, pATTRIBUTES)
tIdent pIdent;
int pLine;
tTree pATTRIBUTES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kENTITY_DECL])
 yyt->Kind = kENTITY_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ENTITY_DECL.Ident = pIdent;
 yyt->ENTITY_DECL.Line = pLine;
 yyt->ENTITY_DECL.ATTRIBUTES = pATTRIBUTES;
 return yyt;
}

tTree mVAR_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_DECL])
 yyt->Kind = kVAR_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_DECL.Ident = pIdent;
 yyt->VAR_DECL.Line = pLine;
 yyt->VAR_DECL.VAL = pVAL;
 return yyt;
}

tTree mCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pIDS)
# else
(pIdent, pLine, pIDS)
tIdent pIdent;
int pLine;
tTree pIDS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMMON_DECL])
 yyt->Kind = kCOMMON_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMMON_DECL.Ident = pIdent;
 yyt->COMMON_DECL.Line = pLine;
 yyt->COMMON_DECL.IDS = pIDS;
 return yyt;
}

tTree mNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pIDS)
# else
(pIdent, pLine, pIDS)
tIdent pIdent;
int pLine;
tTree pIDS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMELIST_DECL])
 yyt->Kind = kNAMELIST_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMELIST_DECL.Ident = pIdent;
 yyt->NAMELIST_DECL.Line = pLine;
 yyt->NAMELIST_DECL.IDS = pIDS;
 return yyt;
}

tTree mTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDIMENSIONS)
# else
(pIdent, pLine, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTEMPLATE_DECL])
 yyt->Kind = kTEMPLATE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TEMPLATE_DECL.Ident = pIdent;
 yyt->TEMPLATE_DECL.Line = pLine;
 yyt->TEMPLATE_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mRAGGED_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDIMENSIONS)
# else
(pIdent, pLine, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRAGGED_DECL])
 yyt->Kind = kRAGGED_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RAGGED_DECL.Ident = pIdent;
 yyt->RAGGED_DECL.Line = pLine;
 yyt->RAGGED_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mPROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDIMENSIONS)
# else
(pIdent, pLine, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSORS_DECL])
 yyt->Kind = kPROCESSORS_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSORS_DECL.Ident = pIdent;
 yyt->PROCESSORS_DECL.Line = pLine;
 yyt->PROCESSORS_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mSUB_PROCS_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pTOP, tTree pDIMENSIONS)
# else
(pIdent, pLine, pTOP, pDIMENSIONS)
tIdent pIdent;
int pLine;
tTree pTOP;
tTree pDIMENSIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSUB_PROCS_DECL])
 yyt->Kind = kSUB_PROCS_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SUB_PROCS_DECL.Ident = pIdent;
 yyt->SUB_PROCS_DECL.Line = pLine;
 yyt->SUB_PROCS_DECL.TOP = pTOP;
 yyt->SUB_PROCS_DECL.DIMENSIONS = pDIMENSIONS;
 return yyt;
}

tTree mINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINHERIT_DECL])
 yyt->Kind = kINHERIT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INHERIT_DECL.Ident = pIdent;
 yyt->INHERIT_DECL.Line = pLine;
 return yyt;
}

tTree mRANGE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pRANGES)
# else
(pIdent, pLine, pRANGES)
tIdent pIdent;
int pLine;
tTree pRANGES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_DECL])
 yyt->Kind = kRANGE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RANGE_DECL.Ident = pIdent;
 yyt->RANGE_DECL.Line = pLine;
 yyt->RANGE_DECL.RANGES = pRANGES;
 return yyt;
}

tTree mSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pFORMALS, tTree pRESULT_TYPE, tTree pFFUNC_BODY)
# else
(pIdent, pLine, pFORMALS, pRESULT_TYPE, pFFUNC_BODY)
tIdent pIdent;
int pLine;
tTree pFORMALS;
tTree pRESULT_TYPE;
tTree pFFUNC_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTMT_FUNC_DECL])
 yyt->Kind = kSTMT_FUNC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STMT_FUNC_DECL.Ident = pIdent;
 yyt->STMT_FUNC_DECL.Line = pLine;
 yyt->STMT_FUNC_DECL.FORMALS = pFORMALS;
 yyt->STMT_FUNC_DECL.RESULT_TYPE = pRESULT_TYPE;
 yyt->STMT_FUNC_DECL.FFUNC_BODY = pFFUNC_BODY;
 return yyt;
}

tTree mINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pSPEC, tTree pITEMS)
# else
(pIdent, pLine, pSPEC, pITEMS)
tIdent pIdent;
int pLine;
tTree pSPEC;
tTree pITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTERFACE_DECL])
 yyt->Kind = kINTERFACE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTERFACE_DECL.Ident = pIdent;
 yyt->INTERFACE_DECL.Line = pLine;
 yyt->INTERFACE_DECL.SPEC = pSPEC;
 yyt->INTERFACE_DECL.ITEMS = pITEMS;
 return yyt;
}

tTree mVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_PARAM_DECL])
 yyt->Kind = kVAR_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_PARAM_DECL.Ident = pIdent;
 yyt->VAR_PARAM_DECL.Line = pLine;
 yyt->VAR_PARAM_DECL.VAL = pVAL;
 return yyt;
}

tTree mRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRET_PARAM_DECL])
 yyt->Kind = kRET_PARAM_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RET_PARAM_DECL.Ident = pIdent;
 yyt->RET_PARAM_DECL.Line = pLine;
 return yyt;
}

tTree mIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent pfirst, tIdent plast, tTree pTYPE)
# else
(pIdent, pLine, pfirst, plast, pTYPE)
tIdent pIdent;
int pLine;
tIdent pfirst;
tIdent plast;
tTree pTYPE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIMPLICIT_DECL])
 yyt->Kind = kIMPLICIT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IMPLICIT_DECL.Ident = pIdent;
 yyt->IMPLICIT_DECL.Line = pLine;
 yyt->IMPLICIT_DECL.first = pfirst;
 yyt->IMPLICIT_DECL.last = plast;
 yyt->IMPLICIT_DECL.TYPE = pTYPE;
 return yyt;
}

tTree mUSE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent puse, tTree pRENAMINGS)
# else
(pIdent, pLine, puse, pRENAMINGS)
tIdent pIdent;
int pLine;
tIdent puse;
tTree pRENAMINGS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSE_DECL])
 yyt->Kind = kUSE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USE_DECL.Ident = pIdent;
 yyt->USE_DECL.Line = pLine;
 yyt->USE_DECL.use = puse;
 yyt->USE_DECL.RENAMINGS = pRENAMINGS;
 return yyt;
}

tTree mONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent puse, tTree pNAMES)
# else
(pIdent, pLine, puse, pNAMES)
tIdent pIdent;
int pLine;
tIdent puse;
tTree pNAMES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kONLY_USE_DECL])
 yyt->Kind = kONLY_USE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ONLY_USE_DECL.Ident = pIdent;
 yyt->ONLY_USE_DECL.Line = pLine;
 yyt->ONLY_USE_DECL.use = puse;
 yyt->ONLY_USE_DECL.NAMES = pNAMES;
 return yyt;
}

tTree mEQV_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVARS)
# else
(pIdent, pLine, pVARS)
tIdent pIdent;
int pLine;
tTree pVARS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEQV_DECL])
 yyt->Kind = kEQV_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EQV_DECL.Ident = pIdent;
 yyt->EQV_DECL.Line = pLine;
 yyt->EQV_DECL.VARS = pVARS;
 return yyt;
}

tTree mDATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVARS, tTree pVALS)
# else
(pIdent, pLine, pVARS, pVALS)
tIdent pIdent;
int pLine;
tTree pVARS;
tTree pVALS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDATA_DECL])
 yyt->Kind = kDATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DATA_DECL.Ident = pIdent;
 yyt->DATA_DECL.Line = pLine;
 yyt->DATA_DECL.VARS = pVARS;
 yyt->DATA_DECL.VALS = pVALS;
 return yyt;
}

tTree mFORMAT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, int plabel, tTree pFORMAT_PARAMS)
# else
(pIdent, pLine, plabel, pFORMAT_PARAMS)
tIdent pIdent;
int pLine;
int plabel;
tTree pFORMAT_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_DECL])
 yyt->Kind = kFORMAT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_DECL.Ident = pIdent;
 yyt->FORMAT_DECL.Line = pLine;
 yyt->FORMAT_DECL.label = plabel;
 yyt->FORMAT_DECL.FORMAT_PARAMS = pFORMAT_PARAMS;
 return yyt;
}

tTree mDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pINDEXES)
# else
(pIdent, pLine, pINDEXES)
tIdent pIdent;
int pLine;
tTree pINDEXES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIMENSION_DECL])
 yyt->Kind = kDIMENSION_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIMENSION_DECL.Ident = pIdent;
 yyt->DIMENSION_DECL.Line = pLine;
 yyt->DIMENSION_DECL.INDEXES = pINDEXES;
 return yyt;
}

tTree mINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINIT_DATA_DECL])
 yyt->Kind = kINIT_DATA_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INIT_DATA_DECL.Ident = pIdent;
 yyt->INIT_DATA_DECL.Line = pLine;
 yyt->INIT_DATA_DECL.VAL = pVAL;
 return yyt;
}

tTree mTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPESPEC_DECL])
 yyt->Kind = kTYPESPEC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPESPEC_DECL.Ident = pIdent;
 yyt->TYPESPEC_DECL.Line = pLine;
 yyt->TYPESPEC_DECL.VAL = pVAL;
 return yyt;
}

tTree mALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALLOCATABLE_DECL])
 yyt->Kind = kALLOCATABLE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALLOCATABLE_DECL.Ident = pIdent;
 yyt->ALLOCATABLE_DECL.Line = pLine;
 return yyt;
}

tTree mEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXTERNAL_DECL])
 yyt->Kind = kEXTERNAL_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXTERNAL_DECL.Ident = pIdent;
 yyt->EXTERNAL_DECL.Line = pLine;
 return yyt;
}

tTree mINTENT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, int pintent)
# else
(pIdent, pLine, pintent)
tIdent pIdent;
int pLine;
int pintent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTENT_DECL])
 yyt->Kind = kINTENT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTENT_DECL.Ident = pIdent;
 yyt->INTENT_DECL.Line = pLine;
 yyt->INTENT_DECL.intent = pintent;
 return yyt;
}

tTree mINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tIdent pgeneric, int pclass, int pkind)
# else
(pIdent, pLine, pgeneric, pclass, pkind)
tIdent pIdent;
int pLine;
tIdent pgeneric;
int pclass;
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINTRINSIC_DECL])
 yyt->Kind = kINTRINSIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INTRINSIC_DECL.Ident = pIdent;
 yyt->INTRINSIC_DECL.Line = pLine;
 yyt->INTRINSIC_DECL.generic = pgeneric;
 yyt->INTRINSIC_DECL.class = pclass;
 yyt->INTRINSIC_DECL.kind = pkind;
 return yyt;
}

tTree mOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOPTIONAL_DECL])
 yyt->Kind = kOPTIONAL_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OPTIONAL_DECL.Ident = pIdent;
 yyt->OPTIONAL_DECL.Line = pLine;
 return yyt;
}

tTree mPOINTER_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPOINTER_DECL])
 yyt->Kind = kPOINTER_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->POINTER_DECL.Ident = pIdent;
 yyt->POINTER_DECL.Line = pLine;
 return yyt;
}

tTree mSAVE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSAVE_DECL])
 yyt->Kind = kSAVE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SAVE_DECL.Ident = pIdent;
 yyt->SAVE_DECL.Line = pLine;
 return yyt;
}

tTree mTARGET_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTARGET_DECL])
 yyt->Kind = kTARGET_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TARGET_DECL.Ident = pIdent;
 yyt->TARGET_DECL.Line = pLine;
 return yyt;
}

tTree mPARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pVAL)
# else
(pIdent, pLine, pVAL)
tIdent pIdent;
int pLine;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARAMETER_DECL])
 yyt->Kind = kPARAMETER_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PARAMETER_DECL.Ident = pIdent;
 yyt->PARAMETER_DECL.Line = pLine;
 yyt->PARAMETER_DECL.VAL = pVAL;
 return yyt;
}

tTree mPUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPUBLIC_DECL])
 yyt->Kind = kPUBLIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PUBLIC_DECL.Ident = pIdent;
 yyt->PUBLIC_DECL.Line = pLine;
 return yyt;
}

tTree mPRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPRIVATE_DECL])
 yyt->Kind = kPRIVATE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PRIVATE_DECL.Ident = pIdent;
 yyt->PRIVATE_DECL.Line = pLine;
 return yyt;
}

tTree mSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSEQUENCE_DECL])
 yyt->Kind = kSEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SEQUENCE_DECL.Ident = pIdent;
 yyt->SEQUENCE_DECL.Line = pLine;
 return yyt;
}

tTree mDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pDISTRIBUTION, tTree pTARGET)
# else
(pIdent, pLine, pDISTRIBUTION, pTARGET)
tIdent pIdent;
int pLine;
tTree pDISTRIBUTION;
tTree pTARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTE_DECL])
 yyt->Kind = kDISTRIBUTE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DISTRIBUTE_DECL.Ident = pIdent;
 yyt->DISTRIBUTE_DECL.Line = pLine;
 yyt->DISTRIBUTE_DECL.DISTRIBUTION = pDISTRIBUTION;
 yyt->DISTRIBUTE_DECL.TARGET = pTARGET;
 return yyt;
}

tTree mALIGN_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pALIGN_SOURCE, tTree pALIGN_TARGET)
# else
(pIdent, pLine, pALIGN_SOURCE, pALIGN_TARGET)
tIdent pIdent;
int pLine;
tTree pALIGN_SOURCE;
tTree pALIGN_TARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_DECL])
 yyt->Kind = kALIGN_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALIGN_DECL.Ident = pIdent;
 yyt->ALIGN_DECL.Line = pLine;
 yyt->ALIGN_DECL.ALIGN_SOURCE = pALIGN_SOURCE;
 yyt->ALIGN_DECL.ALIGN_TARGET = pALIGN_TARGET;
 return yyt;
}

tTree mMAP_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pMAP_TARGET)
# else
(pIdent, pLine, pMAP_TARGET)
tIdent pIdent;
int pLine;
tTree pMAP_TARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMAP_DECL])
 yyt->Kind = kMAP_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MAP_DECL.Ident = pIdent;
 yyt->MAP_DECL.Line = pLine;
 yyt->MAP_DECL.MAP_TARGET = pMAP_TARGET;
 return yyt;
}

tTree mOVERLAP_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pOVERLAPS)
# else
(pIdent, pLine, pOVERLAPS)
tIdent pIdent;
int pLine;
tTree pOVERLAPS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOVERLAP_DECL])
 yyt->Kind = kOVERLAP_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OVERLAP_DECL.Ident = pIdent;
 yyt->OVERLAP_DECL.Line = pLine;
 yyt->OVERLAP_DECL.OVERLAPS = pOVERLAPS;
 return yyt;
}

tTree mSHARED_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, int pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSHARED_DECL])
 yyt->Kind = kSHARED_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SHARED_DECL.Ident = pIdent;
 yyt->SHARED_DECL.Line = pLine;
 yyt->SHARED_DECL.kind = pkind;
 return yyt;
}

tTree mDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDYNAMIC_DECL])
 yyt->Kind = kDYNAMIC_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DYNAMIC_DECL.Ident = pIdent;
 yyt->DYNAMIC_DECL.Line = pLine;
 return yyt;
}

tTree mTRACE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTRACE_DECL])
 yyt->Kind = kTRACE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TRACE_DECL.Ident = pIdent;
 yyt->TRACE_DECL.Line = pLine;
 return yyt;
}

tTree mTREE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTREE_DECL])
 yyt->Kind = kTREE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TREE_DECL.Ident = pIdent;
 yyt->TREE_DECL.Line = pLine;
 return yyt;
}

tTree mSELECT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tTree pSELECTIONS)
# else
(pIdent, pLine, pSELECTIONS)
tIdent pIdent;
int pLine;
tTree pSELECTIONS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_DECL])
 yyt->Kind = kSELECT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECT_DECL.Ident = pIdent;
 yyt->SELECT_DECL.Line = pLine;
 yyt->SELECT_DECL.SELECTIONS = pSELECTIONS;
 return yyt;
}

tTree mHPF_SEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kHPF_SEQUENCE_DECL])
 yyt->Kind = kHPF_SEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->HPF_SEQUENCE_DECL.Ident = pIdent;
 yyt->HPF_SEQUENCE_DECL.Line = pLine;
 return yyt;
}

tTree mNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine)
# else
(pIdent, pLine)
tIdent pIdent;
int pLine;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNOSEQUENCE_DECL])
 yyt->Kind = kNOSEQUENCE_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NOSEQUENCE_DECL.Ident = pIdent;
 yyt->NOSEQUENCE_DECL.Line = pLine;
 return yyt;
}

tTree mLAYOUT_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tStringRef pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
tStringRef pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLAYOUT_DECL])
 yyt->Kind = kLAYOUT_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LAYOUT_DECL.Ident = pIdent;
 yyt->LAYOUT_DECL.Line = pLine;
 yyt->LAYOUT_DECL.kind = pkind;
 return yyt;
}

tTree mPASS_BY_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tStringRef pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
tStringRef pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPASS_BY_DECL])
 yyt->Kind = kPASS_BY_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PASS_BY_DECL.Ident = pIdent;
 yyt->PASS_BY_DECL.Line = pLine;
 yyt->PASS_BY_DECL.kind = pkind;
 return yyt;
}

tTree mMAP_TO_DECL
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent, int pLine, tStringRef pkind)
# else
(pIdent, pLine, pkind)
tIdent pIdent;
int pLine;
tStringRef pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMAP_TO_DECL])
 yyt->Kind = kMAP_TO_DECL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MAP_TO_DECL.Ident = pIdent;
 yyt->MAP_TO_DECL.Line = pLine;
 yyt->MAP_TO_DECL.kind = pkind;
 return yyt;
}

tTree mDECL_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_NODE_LIST])
 yyt->Kind = kDECL_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDECL_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_EMPTY])
 yyt->Kind = kDECL_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDECL_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDECL_LIST])
 yyt->Kind = kDECL_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DECL_LIST.Elem = pElem;
 yyt->DECL_LIST.Next = pNext;
 return yyt;
}

tTree mRANGE_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_SPEC_LIST])
 yyt->Kind = kRANGE_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mRANGE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_EMPTY])
 yyt->Kind = kRANGE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mRANGE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANGE_LIST])
 yyt->Kind = kRANGE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RANGE_LIST.Elem = pElem;
 yyt->RANGE_LIST.Next = pNext;
 return yyt;
}

tTree mSELECT_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_SPEC_LIST])
 yyt->Kind = kSELECT_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECT_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_EMPTY])
 yyt->Kind = kSELECT_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECT_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_LIST])
 yyt->Kind = kSELECT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECT_LIST.Elem = pElem;
 yyt->SELECT_LIST.Next = pNext;
 return yyt;
}

tTree mSELECT_SPEC
# if defined __STDC__ | defined __cplusplus
(int pselector)
# else
(pselector)
int pselector;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECT_SPEC])
 yyt->Kind = kSELECT_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECT_SPEC.selector = pselector;
 return yyt;
}

tTree mDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTION_SPEC])
 yyt->Kind = kDISTRIBUTION_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DISTRIBUTION_SPEC.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mANY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_DISTRIBUTION])
 yyt->Kind = kANY_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ANY_DISTRIBUTION.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mDEFAULT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEFAULT_DISTRIBUTION])
 yyt->Kind = kDEFAULT_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DEFAULT_DISTRIBUTION.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive)
# else
(pis_descriptive)
int pis_descriptive;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREPL_DISTRIBUTION])
 yyt->Kind = kREPL_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REPL_DISTRIBUTION.is_descriptive = pis_descriptive;
 return yyt;
}

tTree mNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive, tTree pMAPPING)
# else
(pis_descriptive, pMAPPING)
int pis_descriptive;
tTree pMAPPING;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNODE_DISTRIBUTION])
 yyt->Kind = kNODE_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NODE_DISTRIBUTION.is_descriptive = pis_descriptive;
 yyt->NODE_DISTRIBUTION.MAPPING = pMAPPING;
 return yyt;
}

tTree mDIST_FORMAT_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_FORMAT_LIST])
 yyt->Kind = kDIST_FORMAT_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_EMPTY])
 yyt->Kind = kDIST_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDIST_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIST_LIST])
 yyt->Kind = kDIST_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIST_LIST.Elem = pElem;
 yyt->DIST_LIST.Next = pNext;
 return yyt;
}

tTree mDISTRIBUTION_FORMAT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDISTRIBUTION_FORMAT])
 yyt->Kind = kDISTRIBUTION_FORMAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBLOCK_DISTRIBUTION])
 yyt->Kind = kBLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BLOCK_DISTRIBUTION.SIZE = pSIZE;
 return yyt;
}

tTree mCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE)
# else
(pSIZE)
tTree pSIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCYCLIC_DISTRIBUTION])
 yyt->Kind = kCYCLIC_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CYCLIC_DISTRIBUTION.SIZE = pSIZE;
 return yyt;
}

tTree mGEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY)
# else
(pARRAY)
tTree pARRAY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGEN_BLOCK_DISTRIBUTION])
 yyt->Kind = kGEN_BLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->GEN_BLOCK_DISTRIBUTION.ARRAY = pARRAY;
 return yyt;
}

tTree mINDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pARRAY)
# else
(pARRAY)
tTree pARRAY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDIRECT_DISTRIBUTION])
 yyt->Kind = kINDIRECT_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDIRECT_DISTRIBUTION.ARRAY = pARRAY;
 return yyt;
}

tTree mARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
(tTree pSIZE, tTree pLENGTH, tTree pMAP)
# else
(pSIZE, pLENGTH, pMAP)
tTree pSIZE;
tTree pLENGTH;
tTree pMAP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARBITRARY_DISTRIBUTION])
 yyt->Kind = kARBITRARY_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARBITRARY_DISTRIBUTION.SIZE = pSIZE;
 yyt->ARBITRARY_DISTRIBUTION.LENGTH = pLENGTH;
 yyt->ARBITRARY_DISTRIBUTION.MAP = pMAP;
 return yyt;
}

tTree mSERIAL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSERIAL_DISTRIBUTION])
 yyt->Kind = kSERIAL_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_BLOCK_DISTRIBUTION])
 yyt->Kind = kANY_BLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_CYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_CYCLIC_DISTRIBUTION])
 yyt->Kind = kANY_CYCLIC_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_GEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_GEN_BLOCK_DISTRIBUTION])
 yyt->Kind = kANY_GEN_BLOCK_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_INDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_INDIRECT_DISTRIBUTION])
 yyt->Kind = kANY_INDIRECT_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_ARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_ARBITRARY_DISTRIBUTION])
 yyt->Kind = kANY_ARBITRARY_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_DIM_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_DIM_DISTRIBUTION])
 yyt->Kind = kANY_DIM_DISTRIBUTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mPROCESSOR_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSOR_SPEC])
 yyt->Kind = kPROCESSOR_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mANY_PROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kANY_PROCESSOR_ARRAY])
 yyt->Kind = kANY_PROCESSOR_ARRAY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDEFAULT_PROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEFAULT_PROCESSOR_ARRAY])
 yyt->Kind = kDEFAULT_PROCESSOR_ARRAY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mPROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
(tTree pTOPNAME)
# else
(pTOPNAME)
tTree pTOPNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSOR_ARRAY])
 yyt->Kind = kPROCESSOR_ARRAY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSOR_ARRAY.TOPNAME = pTOPNAME;
 return yyt;
}

tTree mPROCESSOR_SUBSET
# if defined __STDC__ | defined __cplusplus
(tTree pSUBTOP, tTree pFULLTOP, tTree pSUBSCRIPTS)
# else
(pSUBTOP, pFULLTOP, pSUBSCRIPTS)
tTree pSUBTOP;
tTree pFULLTOP;
tTree pSUBSCRIPTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROCESSOR_SUBSET])
 yyt->Kind = kPROCESSOR_SUBSET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROCESSOR_SUBSET.SUBTOP = pSUBTOP;
 yyt->PROCESSOR_SUBSET.FULLTOP = pFULLTOP;
 yyt->PROCESSOR_SUBSET.SUBSCRIPTS = pSUBSCRIPTS;
 return yyt;
}

tTree mALIGN_SPEC
# if defined __STDC__ | defined __cplusplus
(int pis_descriptive, tTree pTEMPNAME, tTree pSUBSCRIPTS)
# else
(pis_descriptive, pTEMPNAME, pSUBSCRIPTS)
int pis_descriptive;
tTree pTEMPNAME;
tTree pSUBSCRIPTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALIGN_SPEC])
 yyt->Kind = kALIGN_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALIGN_SPEC.is_descriptive = pis_descriptive;
 yyt->ALIGN_SPEC.TEMPNAME = pTEMPNAME;
 yyt->ALIGN_SPEC.SUBSCRIPTS = pSUBSCRIPTS;
 return yyt;
}

tTree mGENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGENERIC_SPEC])
 yyt->Kind = kGENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mNO_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_GENERIC_SPEC])
 yyt->Kind = kNO_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
(tIdent pname)
# else
(pname)
tIdent pname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kID_GENERIC_SPEC])
 yyt->Kind = kID_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ID_GENERIC_SPEC.name = pname;
 return yyt;
}

tTree mOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
(tTree pOPERATOR)
# else
(pOPERATOR)
tTree pOPERATOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GENERIC_SPEC])
 yyt->Kind = kOP_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_GENERIC_SPEC.OPERATOR = pOPERATOR;
 return yyt;
}

tTree mASSIGN_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_GENERIC_SPEC])
 yyt->Kind = kASSIGN_GENERIC_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NODE_LIST])
 yyt->Kind = kACF_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_EMPTY])
 yyt->Kind = kACF_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_LIST])
 yyt->Kind = kACF_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ACF_LIST.Elem = pElem;
 yyt->ACF_LIST.Next = pNext;
 return yyt;
}

tTree mACF_NODE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NODE])
 yyt->Kind = kACF_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_NODE.Label)
 beginint(yyt->ACF_NODE.Line)
 return yyt;
}

tTree mACF_DUMMY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DUMMY])
 yyt->Kind = kACF_DUMMY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DUMMY.Label)
 beginint(yyt->ACF_DUMMY.Line)
 return yyt;
}

tTree mACF_BASIC
# if defined __STDC__ | defined __cplusplus
(tTree pBASIC_STMT)
# else
(pBASIC_STMT)
tTree pBASIC_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_BASIC])
 yyt->Kind = kACF_BASIC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_BASIC.Label)
 beginint(yyt->ACF_BASIC.Line)
 yyt->ACF_BASIC.BASIC_STMT = pBASIC_STMT;
 return yyt;
}

tTree mACF_IF
# if defined __STDC__ | defined __cplusplus
(tTree pIF_EXP, tTree pTHEN_PART, tTree pELSE_PART)
# else
(pIF_EXP, pTHEN_PART, pELSE_PART)
tTree pIF_EXP;
tTree pTHEN_PART;
tTree pELSE_PART;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_IF])
 yyt->Kind = kACF_IF;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_IF.Label)
 beginint(yyt->ACF_IF.Line)
 yyt->ACF_IF.IF_EXP = pIF_EXP;
 yyt->ACF_IF.THEN_PART = pTHEN_PART;
 yyt->ACF_IF.ELSE_PART = pELSE_PART;
 return yyt;
}

tTree mACF_WHERE
# if defined __STDC__ | defined __cplusplus
(tTree pWHERE_EXP, tTree pTRUE_PART, tTree pFALSE_PART)
# else
(pWHERE_EXP, pTRUE_PART, pFALSE_PART)
tTree pWHERE_EXP;
tTree pTRUE_PART;
tTree pFALSE_PART;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WHERE])
 yyt->Kind = kACF_WHERE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WHERE.Label)
 beginint(yyt->ACF_WHERE.Line)
 yyt->ACF_WHERE.WHERE_EXP = pWHERE_EXP;
 yyt->ACF_WHERE.TRUE_PART = pTRUE_PART;
 yyt->ACF_WHERE.FALSE_PART = pFALSE_PART;
 return yyt;
}

tTree mACF_CASE
# if defined __STDC__ | defined __cplusplus
(tTree pCASE_EXP, tTree pCASE_ALTS)
# else
(pCASE_EXP, pCASE_ALTS)
tTree pCASE_EXP;
tTree pCASE_ALTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_CASE])
 yyt->Kind = kACF_CASE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_CASE.Label)
 beginint(yyt->ACF_CASE.Line)
 yyt->ACF_CASE.CASE_EXP = pCASE_EXP;
 yyt->ACF_CASE.CASE_ALTS = pCASE_ALTS;
 return yyt;
}

tTree mACF_WHILE
# if defined __STDC__ | defined __cplusplus
(tTree pWHILE_EXP, tTree pWHILE_BODY)
# else
(pWHILE_EXP, pWHILE_BODY)
tTree pWHILE_EXP;
tTree pWHILE_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_WHILE])
 yyt->Kind = kACF_WHILE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_WHILE.Label)
 beginint(yyt->ACF_WHILE.Line)
 yyt->ACF_WHILE.WHILE_EXP = pWHILE_EXP;
 yyt->ACF_WHILE.WHILE_BODY = pWHILE_BODY;
 return yyt;
}

tTree mACF_REPEAT
# if defined __STDC__ | defined __cplusplus
(tTree pREPEAT_BODY, tTree pREPEAT_EXP)
# else
(pREPEAT_BODY, pREPEAT_EXP)
tTree pREPEAT_BODY;
tTree pREPEAT_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_REPEAT])
 yyt->Kind = kACF_REPEAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_REPEAT.Label)
 beginint(yyt->ACF_REPEAT.Line)
 yyt->ACF_REPEAT.REPEAT_BODY = pREPEAT_BODY;
 yyt->ACF_REPEAT.REPEAT_EXP = pREPEAT_EXP;
 return yyt;
}

tTree mACF_LOOP
# if defined __STDC__ | defined __cplusplus
(tTree pLOOP_BODY)
# else
(pLOOP_BODY)
tTree pLOOP_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_LOOP])
 yyt->Kind = kACF_LOOP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_LOOP.Label)
 beginint(yyt->ACF_LOOP.Line)
 yyt->ACF_LOOP.LOOP_BODY = pLOOP_BODY;
 return yyt;
}

tTree mACF_DO
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pDO_RANGE, tTree pDO_BODY, tTree pDO_DEP_INFO, tTree pDO_HOME_INFO)
# else
(pDO_ID, pDO_RANGE, pDO_BODY, pDO_DEP_INFO, pDO_HOME_INFO)
tTree pDO_ID;
tTree pDO_RANGE;
tTree pDO_BODY;
tTree pDO_DEP_INFO;
tTree pDO_HOME_INFO;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_DO])
 yyt->Kind = kACF_DO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_DO.Label)
 beginint(yyt->ACF_DO.Line)
 yyt->ACF_DO.DO_ID = pDO_ID;
 yyt->ACF_DO.DO_RANGE = pDO_RANGE;
 yyt->ACF_DO.DO_BODY = pDO_BODY;
 yyt->ACF_DO.DO_DEP_INFO = pDO_DEP_INFO;
 yyt->ACF_DO.DO_HOME_INFO = pDO_HOME_INFO;
 return yyt;
}

tTree mACF_FORALL
# if defined __STDC__ | defined __cplusplus
(tTree pFORALL_ID, tTree pFORALL_RANGE, tTree pFORALL_BODY, tTree pFORALL_DEP_INFO, tTree pFORALL_HOME_INFO)
# else
(pFORALL_ID, pFORALL_RANGE, pFORALL_BODY, pFORALL_DEP_INFO, pFORALL_HOME_INFO)
tTree pFORALL_ID;
tTree pFORALL_RANGE;
tTree pFORALL_BODY;
tTree pFORALL_DEP_INFO;
tTree pFORALL_HOME_INFO;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FORALL])
 yyt->Kind = kACF_FORALL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_FORALL.Label)
 beginint(yyt->ACF_FORALL.Line)
 yyt->ACF_FORALL.FORALL_ID = pFORALL_ID;
 yyt->ACF_FORALL.FORALL_RANGE = pFORALL_RANGE;
 yyt->ACF_FORALL.FORALL_BODY = pFORALL_BODY;
 yyt->ACF_FORALL.FORALL_DEP_INFO = pFORALL_DEP_INFO;
 yyt->ACF_FORALL.FORALL_HOME_INFO = pFORALL_HOME_INFO;
 return yyt;
}

tTree mACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
(tTree pFLOW_NODES)
# else
(pFLOW_NODES)
tTree pFLOW_NODES;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FLOW_GRAPH])
 yyt->Kind = kACF_FLOW_GRAPH;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_FLOW_GRAPH.Label)
 beginint(yyt->ACF_FLOW_GRAPH.Line)
 yyt->ACF_FLOW_GRAPH.FLOW_NODES = pFLOW_NODES;
 return yyt;
}

tTree mACF_ENTRY
# if defined __STDC__ | defined __cplusplus
(tTree pENTRY_DECL)
# else
(pENTRY_DECL)
tTree pENTRY_DECL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ENTRY])
 yyt->Kind = kACF_ENTRY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ENTRY.Label)
 beginint(yyt->ACF_ENTRY.Line)
 yyt->ACF_ENTRY.ENTRY_DECL = pENTRY_DECL;
 return yyt;
}

tTree mACF_HOME
# if defined __STDC__ | defined __cplusplus
(tTree pHOME_VAR, bool puser_home, tTree pHOME_BODY)
# else
(pHOME_VAR, puser_home, pHOME_BODY)
tTree pHOME_VAR;
bool puser_home;
tTree pHOME_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_HOME])
 yyt->Kind = kACF_HOME;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_HOME.Label)
 beginint(yyt->ACF_HOME.Line)
 yyt->ACF_HOME.HOME_VAR = pHOME_VAR;
 yyt->ACF_HOME.user_home = puser_home;
 yyt->ACF_HOME.HOME_BODY = pHOME_BODY;
 return yyt;
}

tTree mACF_RESIDENT
# if defined __STDC__ | defined __cplusplus
(tTree pRESIDENT_VAR, tTree pRESIDENT_BODY)
# else
(pRESIDENT_VAR, pRESIDENT_BODY)
tTree pRESIDENT_VAR;
tTree pRESIDENT_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_RESIDENT])
 yyt->Kind = kACF_RESIDENT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_RESIDENT.Label)
 beginint(yyt->ACF_RESIDENT.Line)
 yyt->ACF_RESIDENT.RESIDENT_VAR = pRESIDENT_VAR;
 yyt->ACF_RESIDENT.RESIDENT_BODY = pRESIDENT_BODY;
 return yyt;
}

tTree mACF_NEW
# if defined __STDC__ | defined __cplusplus
(tTree pNEW_VAR, tTree pNEW_BODY)
# else
(pNEW_VAR, pNEW_BODY)
tTree pNEW_VAR;
tTree pNEW_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_NEW])
 yyt->Kind = kACF_NEW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_NEW.Label)
 beginint(yyt->ACF_NEW.Line)
 yyt->ACF_NEW.NEW_VAR = pNEW_VAR;
 yyt->ACF_NEW.NEW_BODY = pNEW_BODY;
 return yyt;
}

tTree mACF_REDUCTION
# if defined __STDC__ | defined __cplusplus
(bool pis_zero, tTree pREDUCTION_VAR, tTree pREDUCTION_LVAR, tTree pREDUCTION_FUNC, tTree pREDUCTION_BODY)
# else
(pis_zero, pREDUCTION_VAR, pREDUCTION_LVAR, pREDUCTION_FUNC, pREDUCTION_BODY)
bool pis_zero;
tTree pREDUCTION_VAR;
tTree pREDUCTION_LVAR;
tTree pREDUCTION_FUNC;
tTree pREDUCTION_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_REDUCTION])
 yyt->Kind = kACF_REDUCTION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_REDUCTION.Label)
 beginint(yyt->ACF_REDUCTION.Line)
 yyt->ACF_REDUCTION.is_zero = pis_zero;
 yyt->ACF_REDUCTION.REDUCTION_VAR = pREDUCTION_VAR;
 yyt->ACF_REDUCTION.REDUCTION_LVAR = pREDUCTION_LVAR;
 yyt->ACF_REDUCTION.REDUCTION_FUNC = pREDUCTION_FUNC;
 yyt->ACF_REDUCTION.REDUCTION_BODY = pREDUCTION_BODY;
 return yyt;
}

tTree mACF_TASK_REGION
# if defined __STDC__ | defined __cplusplus
(int ptask_flag, tTree pTASK_BODY)
# else
(ptask_flag, pTASK_BODY)
int ptask_flag;
tTree pTASK_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_TASK_REGION])
 yyt->Kind = kACF_TASK_REGION;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_TASK_REGION.Label)
 beginint(yyt->ACF_TASK_REGION.Line)
 yyt->ACF_TASK_REGION.task_flag = ptask_flag;
 yyt->ACF_TASK_REGION.TASK_BODY = pTASK_BODY;
 return yyt;
}

tTree mACF_PARALLEL
# if defined __STDC__ | defined __cplusplus
(tTree pREDUCTION_VARS, tTree pSHARED_VARS, tTree pLOCAL_VARS, tTree pPARALLEL_BODY)
# else
(pREDUCTION_VARS, pSHARED_VARS, pLOCAL_VARS, pPARALLEL_BODY)
tTree pREDUCTION_VARS;
tTree pSHARED_VARS;
tTree pLOCAL_VARS;
tTree pPARALLEL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_PARALLEL])
 yyt->Kind = kACF_PARALLEL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_PARALLEL.Label)
 beginint(yyt->ACF_PARALLEL.Line)
 yyt->ACF_PARALLEL.REDUCTION_VARS = pREDUCTION_VARS;
 yyt->ACF_PARALLEL.SHARED_VARS = pSHARED_VARS;
 yyt->ACF_PARALLEL.LOCAL_VARS = pLOCAL_VARS;
 yyt->ACF_PARALLEL.PARALLEL_BODY = pPARALLEL_BODY;
 return yyt;
}

tTree mACF_CRITICAL
# if defined __STDC__ | defined __cplusplus
(tTree pCRITICAL_BODY)
# else
(pCRITICAL_BODY)
tTree pCRITICAL_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_CRITICAL])
 yyt->Kind = kACF_CRITICAL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_CRITICAL.Label)
 beginint(yyt->ACF_CRITICAL.Line)
 yyt->ACF_CRITICAL.CRITICAL_BODY = pCRITICAL_BODY;
 return yyt;
}

tTree mACF_ON
# if defined __STDC__ | defined __cplusplus
(tTree pON_HOME, tTree pON_SPECS, tTree pON_BODY)
# else
(pON_HOME, pON_SPECS, pON_BODY)
tTree pON_HOME;
tTree pON_SPECS;
tTree pON_BODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_ON])
 yyt->Kind = kACF_ON;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_ON.Label)
 beginint(yyt->ACF_ON.Line)
 yyt->ACF_ON.ON_HOME = pON_HOME;
 yyt->ACF_ON.ON_SPECS = pON_SPECS;
 yyt->ACF_ON.ON_BODY = pON_BODY;
 return yyt;
}

tTree mACF_RM_READ
# if defined __STDC__ | defined __cplusplus
(tTree pLOCAL_VAR, tTree pREMOTE_VAR)
# else
(pLOCAL_VAR, pREMOTE_VAR)
tTree pLOCAL_VAR;
tTree pREMOTE_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_RM_READ])
 yyt->Kind = kACF_RM_READ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_RM_READ.Label)
 beginint(yyt->ACF_RM_READ.Line)
 yyt->ACF_RM_READ.LOCAL_VAR = pLOCAL_VAR;
 yyt->ACF_RM_READ.REMOTE_VAR = pREMOTE_VAR;
 return yyt;
}

tTree mACF_RM_WRITE
# if defined __STDC__ | defined __cplusplus
(int pop, tTree pREMOTE_VAR, tTree pLOCAL_DATA)
# else
(pop, pREMOTE_VAR, pLOCAL_DATA)
int pop;
tTree pREMOTE_VAR;
tTree pLOCAL_DATA;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_RM_WRITE])
 yyt->Kind = kACF_RM_WRITE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_RM_WRITE.Label)
 beginint(yyt->ACF_RM_WRITE.Line)
 yyt->ACF_RM_WRITE.op = pop;
 yyt->ACF_RM_WRITE.REMOTE_VAR = pREMOTE_VAR;
 yyt->ACF_RM_WRITE.LOCAL_DATA = pLOCAL_DATA;
 return yyt;
}

tTree mACF_MOVE
# if defined __STDC__ | defined __cplusplus
(tTree pMOVE_STMT)
# else
(pMOVE_STMT)
tTree pMOVE_STMT;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_MOVE])
 yyt->Kind = kACF_MOVE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_MOVE.Label)
 beginint(yyt->ACF_MOVE.Line)
 yyt->ACF_MOVE.MOVE_STMT = pMOVE_STMT;
 return yyt;
}

tTree mACF_BARRIER
# if defined __STDC__ | defined __cplusplus
(tTree pBARRIER_VARS)
# else
(pBARRIER_VARS)
tTree pBARRIER_VARS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_BARRIER])
 yyt->Kind = kACF_BARRIER;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_BARRIER.Label)
 beginint(yyt->ACF_BARRIER.Line)
 yyt->ACF_BARRIER.BARRIER_VARS = pBARRIER_VARS;
 return yyt;
}

tTree mACF_UPDATE
# if defined __STDC__ | defined __cplusplus
(tTree pOVERLAP_VAR)
# else
(pOVERLAP_VAR)
tTree pOVERLAP_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_UPDATE])
 yyt->Kind = kACF_UPDATE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 beginint(yyt->ACF_UPDATE.Label)
 beginint(yyt->ACF_UPDATE.Line)
 yyt->ACF_UPDATE.OVERLAP_VAR = pOVERLAP_VAR;
 return yyt;
}

tTree mACF_FLOW_KIND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_FLOW_KIND])
 yyt->Kind = kACF_FLOW_KIND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_COMPLEX_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_COMPLEX_FLOW])
 yyt->Kind = kACF_COMPLEX_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_INTERVAL_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_INTERVAL_FLOW])
 yyt->Kind = kACF_INTERVAL_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mACF_SIMPLE_FLOW
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kACF_SIMPLE_FLOW])
 yyt->Kind = kACF_SIMPLE_FLOW;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_CLAUSE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_CLAUSE])
 yyt->Kind = kON_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_HOST_CLAUSE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_HOST_CLAUSE])
 yyt->Kind = kON_HOST_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_ALL_CLAUSE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_ALL_CLAUSE])
 yyt->Kind = kON_ALL_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_VAR_CLAUSE
# if defined __STDC__ | defined __cplusplus
(tTree pON_VAR)
# else
(pON_VAR)
tTree pON_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_VAR_CLAUSE])
 yyt->Kind = kON_VAR_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_VAR_CLAUSE.ON_VAR = pON_VAR;
 return yyt;
}

tTree mON_PROC_CLAUSE
# if defined __STDC__ | defined __cplusplus
(tTree pON_PROC)
# else
(pON_PROC)
tTree pON_PROC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_PROC_CLAUSE])
 yyt->Kind = kON_PROC_CLAUSE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_PROC_CLAUSE.ON_PROC = pON_PROC;
 return yyt;
}

tTree mON_TOPOLOGY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_TOPOLOGY])
 yyt->Kind = kON_TOPOLOGY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_ALL
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_ALL])
 yyt->Kind = kON_ALL;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_HOST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_HOST])
 yyt->Kind = kON_HOST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_PROCS
# if defined __STDC__ | defined __cplusplus
(tObject ptopid)
# else
(ptopid)
tObject ptopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_PROCS])
 yyt->Kind = kON_PROCS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_PROCS.topid = ptopid;
 return yyt;
}

tTree mON_VAR
# if defined __STDC__ | defined __cplusplus
(tObject ptopid, tObject ptempid, tObject parrayid)
# else
(ptopid, ptempid, parrayid)
tObject ptopid;
tObject ptempid;
tObject parrayid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_VAR])
 yyt->Kind = kON_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_VAR.topid = ptopid;
 yyt->ON_VAR.tempid = ptempid;
 yyt->ON_VAR.arrayid = parrayid;
 return yyt;
}

tTree mON_SPEC_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_SPEC_LIST])
 yyt->Kind = kON_SPEC_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_EMPTY])
 yyt->Kind = kON_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mON_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_LIST])
 yyt->Kind = kON_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_LIST.Elem = pElem;
 yyt->ON_LIST.Next = pNext;
 return yyt;
}

tTree mON_SPEC
# if defined __STDC__ | defined __cplusplus
(int ptop_dim, int ptemp_dim, int parray_dim, tTree pON_VAL)
# else
(ptop_dim, ptemp_dim, parray_dim, pON_VAL)
int ptop_dim;
int ptemp_dim;
int parray_dim;
tTree pON_VAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_SPEC])
 yyt->Kind = kON_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_SPEC.top_dim = ptop_dim;
 yyt->ON_SPEC.temp_dim = ptemp_dim;
 yyt->ON_SPEC.array_dim = parray_dim;
 yyt->ON_SPEC.ON_VAL = pON_VAL;
 return yyt;
}

tTree mSELECTED_ACF_NODE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_NODE_LIST])
 yyt->Kind = kSELECTED_ACF_NODE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_EMPTY])
 yyt->Kind = kSELECTED_ACF_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_LIST])
 yyt->Kind = kSELECTED_ACF_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_ACF_LIST.Elem = pElem;
 yyt->SELECTED_ACF_LIST.Next = pNext;
 return yyt;
}

tTree mSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
(tTree pSELECT_LIST, tTree pSELECT_ACFS)
# else
(pSELECT_LIST, pSELECT_ACFS)
tTree pSELECT_LIST;
tTree pSELECT_ACFS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_ACF_NODE])
 yyt->Kind = kSELECTED_ACF_NODE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_ACF_NODE.SELECT_LIST = pSELECT_LIST;
 yyt->SELECTED_ACF_NODE.SELECT_ACFS = pSELECT_ACFS;
 return yyt;
}

tTree mBT_STMT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_STMT])
 yyt->Kind = kBT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_VAR, tTree pASSIGN_EXP)
# else
(pASSIGN_VAR, pASSIGN_EXP)
tTree pASSIGN_VAR;
tTree pASSIGN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASSIGN_STMT])
 yyt->Kind = kASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASSIGN_STMT.ASSIGN_VAR = pASSIGN_VAR;
 yyt->ASSIGN_STMT.ASSIGN_EXP = pASSIGN_EXP;
 return yyt;
}

tTree mPTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pASSIGN_VAR, tTree pASSIGN_EXP)
# else
(pASSIGN_VAR, pASSIGN_EXP)
tTree pASSIGN_VAR;
tTree pASSIGN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPTR_ASSIGN_STMT])
 yyt->Kind = kPTR_ASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PTR_ASSIGN_STMT.ASSIGN_VAR = pASSIGN_VAR;
 yyt->PTR_ASSIGN_STMT.ASSIGN_EXP = pASSIGN_EXP;
 return yyt;
}

tTree mLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
(int passign_label, tTree pLABEL_VAR)
# else
(passign_label, pLABEL_VAR)
int passign_label;
tTree pLABEL_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_ASSIGN_STMT])
 yyt->Kind = kLABEL_ASSIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LABEL_ASSIGN_STMT.assign_label = passign_label;
 yyt->LABEL_ASSIGN_STMT.LABEL_VAR = pLABEL_VAR;
 return yyt;
}

tTree mCALL_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pCALL_ID, tTree pCALL_PARAMS)
# else
(pCALL_ID, pCALL_PARAMS)
tTree pCALL_ID;
tTree pCALL_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCALL_STMT])
 yyt->Kind = kCALL_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CALL_STMT.CALL_ID = pCALL_ID;
 yyt->CALL_STMT.CALL_PARAMS = pCALL_PARAMS;
 return yyt;
}

tTree mIO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pIO_SPECS, tTree pIO_ITEMS)
# else
(pID, pIO_SPECS, pIO_ITEMS)
tTree pID;
tTree pIO_SPECS;
tTree pIO_ITEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIO_STMT])
 yyt->Kind = kIO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IO_STMT.ID = pID;
 yyt->IO_STMT.IO_SPECS = pIO_SPECS;
 yyt->IO_STMT.IO_ITEMS = pIO_ITEMS;
 return yyt;
}

tTree mGOTO_STMT
# if defined __STDC__ | defined __cplusplus
(int pGOTO_LABEL)
# else
(pGOTO_LABEL)
int pGOTO_LABEL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kGOTO_STMT])
 yyt->Kind = kGOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->GOTO_STMT.GOTO_LABEL = pGOTO_LABEL;
 return yyt;
}

tTree mASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pGOTO_VAR, tTree pLABELS)
# else
(pGOTO_VAR, pLABELS)
tTree pGOTO_VAR;
tTree pLABELS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kASS_GOTO_STMT])
 yyt->Kind = kASS_GOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ASS_GOTO_STMT.GOTO_VAR = pGOTO_VAR;
 yyt->ASS_GOTO_STMT.LABELS = pLABELS;
 return yyt;
}

tTree mCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pGOTO_LABELS, tTree pGOTO_EXP)
# else
(pGOTO_LABELS, pGOTO_EXP)
tTree pGOTO_LABELS;
tTree pGOTO_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_GOTO_STMT])
 yyt->Kind = kCOMP_GOTO_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_GOTO_STMT.GOTO_LABELS = pGOTO_LABELS;
 yyt->COMP_GOTO_STMT.GOTO_EXP = pGOTO_EXP;
 return yyt;
}

tTree mCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pIF_EXP, int pIF_LT_LABEL, int pIF_EQ_LABEL, int pIF_GT_LABEL)
# else
(pIF_EXP, pIF_LT_LABEL, pIF_EQ_LABEL, pIF_GT_LABEL)
tTree pIF_EXP;
int pIF_LT_LABEL;
int pIF_EQ_LABEL;
int pIF_GT_LABEL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMP_IF_STMT])
 yyt->Kind = kCOMP_IF_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMP_IF_STMT.IF_EXP = pIF_EXP;
 yyt->COMP_IF_STMT.IF_LT_LABEL = pIF_LT_LABEL;
 yyt->COMP_IF_STMT.IF_EQ_LABEL = pIF_EQ_LABEL;
 yyt->COMP_IF_STMT.IF_GT_LABEL = pIF_GT_LABEL;
 return yyt;
}

tTree mRETURN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pRETURN_EXP)
# else
(pRETURN_EXP)
tTree pRETURN_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRETURN_STMT])
 yyt->Kind = kRETURN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RETURN_STMT.RETURN_EXP = pRETURN_EXP;
 return yyt;
}

tTree mPAUSE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPAUSE_CONST)
# else
(pPAUSE_CONST)
tTree pPAUSE_CONST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPAUSE_STMT])
 yyt->Kind = kPAUSE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PAUSE_STMT.PAUSE_CONST = pPAUSE_CONST;
 return yyt;
}

tTree mEXIT_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent ploopid)
# else
(ploopid)
tIdent ploopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kEXIT_STMT])
 yyt->Kind = kEXIT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->EXIT_STMT.loopid = ploopid;
 return yyt;
}

tTree mCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent ploopid)
# else
(ploopid)
tIdent ploopid;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCYCLE_STMT])
 yyt->Kind = kCYCLE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CYCLE_STMT.loopid = ploopid;
 return yyt;
}

tTree mSTOP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pSTOP_CONST)
# else
(pSTOP_CONST)
tTree pSTOP_CONST;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTOP_STMT])
 yyt->Kind = kSTOP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STOP_STMT.STOP_CONST = pSTOP_CONST;
 return yyt;
}

tTree mFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pFORMAT_PARAMS)
# else
(pFORMAT_PARAMS)
tTree pFORMAT_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_STMT])
 yyt->Kind = kFORMAT_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_STMT.FORMAT_PARAMS = pFORMAT_PARAMS;
 return yyt;
}

tTree mINHERIT_DSP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, tTree pSHAPE, int pflag, int psafety)
# else
(pVAR, pSHAPE, pflag, psafety)
tTree pVAR;
tTree pSHAPE;
int pflag;
int psafety;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINHERIT_DSP_STMT])
 yyt->Kind = kINHERIT_DSP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INHERIT_DSP_STMT.VAR = pVAR;
 yyt->INHERIT_DSP_STMT.SHAPE = pSHAPE;
 yyt->INHERIT_DSP_STMT.flag = pflag;
 yyt->INHERIT_DSP_STMT.safety = psafety;
 return yyt;
}

tTree mCREATE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, tTree pSHAPE, int pflag)
# else
(pVAR, pSHAPE, pflag)
tTree pVAR;
tTree pSHAPE;
int pflag;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCREATE_DSP_STMT])
 yyt->Kind = kCREATE_DSP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CREATE_DSP_STMT.VAR = pVAR;
 yyt->CREATE_DSP_STMT.SHAPE = pSHAPE;
 yyt->CREATE_DSP_STMT.flag = pflag;
 return yyt;
}

tTree mFREE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, int pflag)
# else
(pVAR, pflag)
tTree pVAR;
int pflag;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFREE_DSP_STMT])
 yyt->Kind = kFREE_DSP_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FREE_DSP_STMT.VAR = pVAR;
 yyt->FREE_DSP_STMT.flag = pflag;
 return yyt;
}

tTree mALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS, tTree pSTATUS)
# else
(pPARAMS, pSTATUS)
tTree pPARAMS;
tTree pSTATUS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kALLOCATE_STMT])
 yyt->Kind = kALLOCATE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ALLOCATE_STMT.PARAMS = pPARAMS;
 yyt->ALLOCATE_STMT.STATUS = pSTATUS;
 return yyt;
}

tTree mDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS, tTree pSTATUS)
# else
(pPARAMS, pSTATUS)
tTree pPARAMS;
tTree pSTATUS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEALLOCATE_STMT])
 yyt->Kind = kDEALLOCATE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DEALLOCATE_STMT.PARAMS = pPARAMS;
 yyt->DEALLOCATE_STMT.STATUS = pSTATUS;
 return yyt;
}

tTree mNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pPARAMS)
# else
(pPARAMS)
tTree pPARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNULLIFY_STMT])
 yyt->Kind = kNULLIFY_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NULLIFY_STMT.PARAMS = pPARAMS;
 return yyt;
}

tTree mREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pRED_FUNC, tTree pRED_PARAMS)
# else
(pRED_FUNC, pRED_PARAMS)
tTree pRED_FUNC;
tTree pRED_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDUCE_STMT])
 yyt->Kind = kREDUCE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDUCE_STMT.RED_FUNC = pRED_FUNC;
 yyt->REDUCE_STMT.RED_PARAMS = pRED_PARAMS;
 return yyt;
}

tTree mMOVE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pTARGET, tTree pSOURCE, tTree pMASK)
# else
(pTARGET, pSOURCE, pMASK)
tTree pTARGET;
tTree pSOURCE;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kMOVE_STMT])
 yyt->Kind = kMOVE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->MOVE_STMT.TARGET = pTARGET;
 yyt->MOVE_STMT.SOURCE = pSOURCE;
 yyt->MOVE_STMT.MASK = pMASK;
 return yyt;
}

tTree mSCATTER_STMT
# if defined __STDC__ | defined __cplusplus
(tIdent pfunc, tTree pARRAY, tTree pBASE, tTree pINDEXES, tTree pMASK)
# else
(pfunc, pARRAY, pBASE, pINDEXES, pMASK)
tIdent pfunc;
tTree pARRAY;
tTree pBASE;
tTree pINDEXES;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSCATTER_STMT])
 yyt->Kind = kSCATTER_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SCATTER_STMT.func = pfunc;
 yyt->SCATTER_STMT.ARRAY = pARRAY;
 yyt->SCATTER_STMT.BASE = pBASE;
 yyt->SCATTER_STMT.INDEXES = pINDEXES;
 yyt->SCATTER_STMT.MASK = pMASK;
 return yyt;
}

tTree mREALIGN_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pALIGNEE, tTree pALIGN_SOURCE, tTree pALIGN_TARGET)
# else
(pALIGNEE, pALIGN_SOURCE, pALIGN_TARGET)
tTree pALIGNEE;
tTree pALIGN_SOURCE;
tTree pALIGN_TARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREALIGN_STMT])
 yyt->Kind = kREALIGN_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REALIGN_STMT.ALIGNEE = pALIGNEE;
 yyt->REALIGN_STMT.ALIGN_SOURCE = pALIGN_SOURCE;
 yyt->REALIGN_STMT.ALIGN_TARGET = pALIGN_TARGET;
 begintDefinitions(yyt->REALIGN_STMT.distribution)
 return yyt;
}

tTree mREDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pDISTRIBUTEE, tTree pDISTRIBUTION, tTree pTARGET)
# else
(pDISTRIBUTEE, pDISTRIBUTION, pTARGET)
tTree pDISTRIBUTEE;
tTree pDISTRIBUTION;
tTree pTARGET;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDISTRIBUTE_STMT])
 yyt->Kind = kREDISTRIBUTE_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDISTRIBUTE_STMT.DISTRIBUTEE = pDISTRIBUTEE;
 yyt->REDISTRIBUTE_STMT.DISTRIBUTION = pDISTRIBUTION;
 yyt->REDISTRIBUTE_STMT.TARGET = pTARGET;
 begintDefinitions(yyt->REDISTRIBUTE_STMT.distribution)
 return yyt;
}

tTree mREG_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
(tTree pSHADOW_VAR, tTree pSHADOW_SIZE)
# else
(pSHADOW_VAR, pSHADOW_SIZE)
tTree pSHADOW_VAR;
tTree pSHADOW_SIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREG_SHADOW_GET])
 yyt->Kind = kREG_SHADOW_GET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REG_SHADOW_GET.SHADOW_VAR = pSHADOW_VAR;
 yyt->REG_SHADOW_GET.SHADOW_SIZE = pSHADOW_SIZE;
 return yyt;
}

tTree mREG_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
(int pop, tTree pSHADOW_VAR, tTree pSHADOW_SIZE)
# else
(pop, pSHADOW_VAR, pSHADOW_SIZE)
int pop;
tTree pSHADOW_VAR;
tTree pSHADOW_SIZE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREG_SHADOW_PUT])
 yyt->Kind = kREG_SHADOW_PUT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REG_SHADOW_PUT.op = pop;
 yyt->REG_SHADOW_PUT.SHADOW_VAR = pSHADOW_VAR;
 yyt->REG_SHADOW_PUT.SHADOW_SIZE = pSHADOW_SIZE;
 return yyt;
}

tTree mREG_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
(tTree pSHADOW_VAR, tTree pSHADOW_SIZE, tTree pVAL)
# else
(pSHADOW_VAR, pSHADOW_SIZE, pVAL)
tTree pSHADOW_VAR;
tTree pSHADOW_SIZE;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREG_SHADOW_SET])
 yyt->Kind = kREG_SHADOW_SET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REG_SHADOW_SET.SHADOW_VAR = pSHADOW_VAR;
 yyt->REG_SHADOW_SET.SHADOW_SIZE = pSHADOW_SIZE;
 yyt->REG_SHADOW_SET.VAL = pVAL;
 return yyt;
}

tTree mIND_SHADOW_CREATE
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pSHADOW_VAR, tTree pINDEX_VAR, tTree pTMP_INDEX_VAR, tTree pMASK)
# else
(pid, pSHADOW_VAR, pINDEX_VAR, pTMP_INDEX_VAR, pMASK)
int pid;
tTree pSHADOW_VAR;
tTree pINDEX_VAR;
tTree pTMP_INDEX_VAR;
tTree pMASK;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_CREATE])
 yyt->Kind = kIND_SHADOW_CREATE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_CREATE.id = pid;
 yyt->IND_SHADOW_CREATE.SHADOW_VAR = pSHADOW_VAR;
 yyt->IND_SHADOW_CREATE.INDEX_VAR = pINDEX_VAR;
 yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR = pTMP_INDEX_VAR;
 yyt->IND_SHADOW_CREATE.MASK = pMASK;
 return yyt;
}

tTree mIND_SHADOW_FREE
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pINDEX_VAR)
# else
(pid, pINDEX_VAR)
int pid;
tTree pINDEX_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_FREE])
 yyt->Kind = kIND_SHADOW_FREE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_FREE.id = pid;
 yyt->IND_SHADOW_FREE.INDEX_VAR = pINDEX_VAR;
 return yyt;
}

tTree mIND_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pSHADOW_VAR)
# else
(pid, pSHADOW_VAR)
int pid;
tTree pSHADOW_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_GET])
 yyt->Kind = kIND_SHADOW_GET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_GET.id = pid;
 yyt->IND_SHADOW_GET.SHADOW_VAR = pSHADOW_VAR;
 return yyt;
}

tTree mIND_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
(int pid, int pop, tTree pSHADOW_VAR)
# else
(pid, pop, pSHADOW_VAR)
int pid;
int pop;
tTree pSHADOW_VAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_PUT])
 yyt->Kind = kIND_SHADOW_PUT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_PUT.id = pid;
 yyt->IND_SHADOW_PUT.op = pop;
 yyt->IND_SHADOW_PUT.SHADOW_VAR = pSHADOW_VAR;
 return yyt;
}

tTree mIND_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
(int pid, tTree pSHADOW_VAR, tTree pVAL)
# else
(pid, pSHADOW_VAR, pVAL)
int pid;
tTree pSHADOW_VAR;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kIND_SHADOW_SET])
 yyt->Kind = kIND_SHADOW_SET;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->IND_SHADOW_SET.id = pid;
 yyt->IND_SHADOW_SET.SHADOW_VAR = pSHADOW_VAR;
 yyt->IND_SHADOW_SET.VAL = pVAL;
 return yyt;
}

tTree mBROADCAST_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pELEMS, tTree pOWNER_TOP, tTree pOWNER_SPEC)
# else
(pELEMS, pOWNER_TOP, pOWNER_SPEC)
tTree pELEMS;
tTree pOWNER_TOP;
tTree pOWNER_SPEC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBROADCAST_STMT])
 yyt->Kind = kBROADCAST_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BROADCAST_STMT.ELEMS = pELEMS;
 yyt->BROADCAST_STMT.OWNER_TOP = pOWNER_TOP;
 yyt->BROADCAST_STMT.OWNER_SPEC = pOWNER_SPEC;
 return yyt;
}

tTree mREDUCTION_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pREDFUNC, tTree pELEMS, tTree pRED_TOP, tTree pRED_SPEC)
# else
(pREDFUNC, pELEMS, pRED_TOP, pRED_SPEC)
tTree pREDFUNC;
tTree pELEMS;
tTree pRED_TOP;
tTree pRED_SPEC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREDUCTION_STMT])
 yyt->Kind = kREDUCTION_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REDUCTION_STMT.REDFUNC = pREDFUNC;
 yyt->REDUCTION_STMT.ELEMS = pELEMS;
 yyt->REDUCTION_STMT.RED_TOP = pRED_TOP;
 yyt->REDUCTION_STMT.RED_SPEC = pRED_SPEC;
 return yyt;
}

tTree mDIRTY_STMT
# if defined __STDC__ | defined __cplusplus
(tTree pELEMS)
# else
(pELEMS)
tTree pELEMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDIRTY_STMT])
 yyt->Kind = kDIRTY_STMT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DIRTY_STMT.ELEMS = pELEMS;
 return yyt;
}

tTree mLABEL_USE_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_USE_LIST])
 yyt->Kind = kLABEL_USE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mLABEL_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_EMPTY])
 yyt->Kind = kLABEL_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mLABEL_LIST
# if defined __STDC__ | defined __cplusplus
(int pElem, tTree pNext)
# else
(pElem, pNext)
int pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLABEL_LIST])
 yyt->Kind = kLABEL_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LABEL_LIST.Elem = pElem;
 yyt->LABEL_LIST.Next = pNext;
 return yyt;
}

tTree mOP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP])
 yyt->Kind = kOP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EQ
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EQ])
 yyt->Kind = kOP_EQ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_NE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_NE])
 yyt->Kind = kOP_NE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LT])
 yyt->Kind = kOP_LT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_GT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GT])
 yyt->Kind = kOP_GT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_GE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_GE])
 yyt->Kind = kOP_GE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_LE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_LE])
 yyt->Kind = kOP_LE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_PLUS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_PLUS])
 yyt->Kind = kOP_PLUS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_MINUS
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_MINUS])
 yyt->Kind = kOP_MINUS;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_XOR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_XOR])
 yyt->Kind = kOP_XOR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_OR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_OR])
 yyt->Kind = kOP_OR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_CONCAT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_CONCAT])
 yyt->Kind = kOP_CONCAT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_TIMES
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_TIMES])
 yyt->Kind = kOP_TIMES;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DIVIDE
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DIVIDE])
 yyt->Kind = kOP_DIVIDE;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_AND
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_AND])
 yyt->Kind = kOP_AND;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EQV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EQV])
 yyt->Kind = kOP_EQV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_NEQV
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_NEQV])
 yyt->Kind = kOP_NEQV;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_EXPO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EXPO])
 yyt->Kind = kOP_EXPO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP_DEFINED
# if defined __STDC__ | defined __cplusplus
(tIdent popname)
# else
(popname)
tIdent popname;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_DEFINED])
 yyt->Kind = kOP_DEFINED;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_DEFINED.opname = popname;
 return yyt;
}

tTree mOP_ASSIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_ASSIGN])
 yyt->Kind = kOP_ASSIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_NOT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_NOT])
 yyt->Kind = kOP1_NOT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_SIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_SIGN])
 yyt->Kind = kOP1_SIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mOP1_PSIGN
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_PSIGN])
 yyt->Kind = kOP1_PSIGN;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBT_EXP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_EXP])
 yyt->Kind = kBT_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_EXP
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_EXP])
 yyt->Kind = kDUMMY_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mCONST_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pC)
# else
(pC)
tTree pC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCONST_EXP])
 yyt->Kind = kCONST_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->CONST_EXP.C = pC;
 return yyt;
}

tTree mOP_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pEXP_OP, tTree pOPND1, tTree pOPND2)
# else
(pEXP_OP, pOPND1, pOPND2)
tTree pEXP_OP;
tTree pOPND1;
tTree pOPND2;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP_EXP])
 yyt->Kind = kOP_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP_EXP.EXP_OP = pEXP_OP;
 yyt->OP_EXP.OPND1 = pOPND1;
 yyt->OP_EXP.OPND2 = pOPND2;
 return yyt;
}

tTree mOP1_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pEXP_OP1, tTree pOPND)
# else
(pEXP_OP1, pOPND)
tTree pEXP_OP1;
tTree pOPND;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOP1_EXP])
 yyt->Kind = kOP1_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OP1_EXP.EXP_OP1 = pEXP_OP1;
 yyt->OP1_EXP.OPND = pOPND;
 return yyt;
}

tTree mSLICE_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pSTART, tTree pSTOP, tTree pINC)
# else
(pSTART, pSTOP, pINC)
tTree pSTART;
tTree pSTOP;
tTree pINC;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSLICE_EXP])
 yyt->Kind = kSLICE_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SLICE_EXP.START = pSTART;
 yyt->SLICE_EXP.STOP = pSTOP;
 yyt->SLICE_EXP.INC = pINC;
 return yyt;
}

tTree mVAR_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pV)
# else
(pV)
tTree pV;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_EXP])
 yyt->Kind = kVAR_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_EXP.V = pV;
 return yyt;
}

tTree mFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pFUNC_ID, tTree pFUNC_PARAMS)
# else
(pFUNC_ID, pFUNC_PARAMS)
tTree pFUNC_ID;
tTree pFUNC_PARAMS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_CALL_EXP])
 yyt->Kind = kFUNC_CALL_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_CALL_EXP.FUNC_ID = pFUNC_ID;
 yyt->FUNC_CALL_EXP.FUNC_PARAMS = pFUNC_PARAMS;
 return yyt;
}

tTree mNAMED_EXP
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pVAL)
# else
(pName, pVAL)
tIdent pName;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMED_EXP])
 yyt->Kind = kNAMED_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMED_EXP.Name = pName;
 yyt->NAMED_EXP.VAL = pVAL;
 return yyt;
}

tTree mDO_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pRANGE, tTree pBODY)
# else
(pDO_ID, pRANGE, pBODY)
tTree pDO_ID;
tTree pRANGE;
tTree pBODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDO_EXP])
 yyt->Kind = kDO_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DO_EXP.DO_ID = pDO_ID;
 yyt->DO_EXP.RANGE = pRANGE;
 yyt->DO_EXP.BODY = pBODY;
 return yyt;
}

tTree mTYPE_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pID, tTree pELEMENTS)
# else
(pID, pELEMENTS)
tTree pID;
tTree pELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_EXP])
 yyt->Kind = kTYPE_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_EXP.ID = pID;
 yyt->TYPE_EXP.ELEMENTS = pELEMENTS;
 return yyt;
}

tTree mARRAY_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pELEMENTS)
# else
(pELEMENTS)
tTree pELEMENTS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kARRAY_EXP])
 yyt->Kind = kARRAY_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ARRAY_EXP.ELEMENTS = pELEMENTS;
 return yyt;
}

tTree mPERM_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pVAL, Permutation pperm)
# else
(pVAL, pperm)
tTree pVAL;
Permutation pperm;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPERM_EXP])
 yyt->Kind = kPERM_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PERM_EXP.VAL = pVAL;
 yyt->PERM_EXP.perm = pperm;
 return yyt;
}

tTree mBOUND_EXP
# if defined __STDC__ | defined __cplusplus
(tTree pVAR, int pdim, int pkind, int plocal)
# else
(pVAR, pdim, pkind, plocal)
tTree pVAR;
int pdim;
int pkind;
int plocal;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOUND_EXP])
 yyt->Kind = kBOUND_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOUND_EXP.VAR = pVAR;
 yyt->BOUND_EXP.dim = pdim;
 yyt->BOUND_EXP.kind = pkind;
 yyt->BOUND_EXP.local = plocal;
 return yyt;
}

tTree mRANK_EXP
# if defined __STDC__ | defined __cplusplus
(int pkind)
# else
(pkind)
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRANK_EXP])
 yyt->Kind = kRANK_EXP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RANK_EXP.kind = pkind;
 return yyt;
}

tTree mBT_EXP_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_EXP_LIST])
 yyt->Kind = kBT_EXP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTE_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTE_EMPTY])
 yyt->Kind = kBTE_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTE_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTE_LIST])
 yyt->Kind = kBTE_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTE_LIST.Elem = pElem;
 yyt->BTE_LIST.Next = pNext;
 return yyt;
}

tTree mBT_VAR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_VAR])
 yyt->Kind = kBT_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mDUMMY_VAR
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDUMMY_VAR])
 yyt->Kind = kDUMMY_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mUSED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVARNAME)
# else
(pVARNAME)
tTree pVARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kUSED_VAR])
 yyt->Kind = kUSED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->USED_VAR.VARNAME = pVARNAME;
 return yyt;
}

tTree mINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pIND_VAR, tTree pIND_EXPS)
# else
(pIND_VAR, pIND_EXPS)
tTree pIND_VAR;
tTree pIND_EXPS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEXED_VAR])
 yyt->Kind = kINDEXED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEXED_VAR.IND_VAR = pIND_VAR;
 yyt->INDEXED_VAR.IND_EXPS = pIND_EXPS;
 return yyt;
}

tTree mSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pIND_VAR, tTree pIND_EXP)
# else
(pIND_VAR, pIND_EXP)
tTree pIND_VAR;
tTree pIND_EXP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSUBSTRING_VAR])
 yyt->Kind = kSUBSTRING_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SUBSTRING_VAR.IND_VAR = pIND_VAR;
 yyt->SUBSTRING_VAR.IND_EXP = pIND_EXP;
 return yyt;
}

tTree mSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pSELEC_VAR, tTree pSELECTOR)
# else
(pSELEC_VAR, pSELECTOR)
tTree pSELEC_VAR;
tTree pSELECTOR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSELECTED_VAR])
 yyt->Kind = kSELECTED_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->SELECTED_VAR.SELEC_VAR = pSELEC_VAR;
 yyt->SELECTED_VAR.SELECTOR = pSELECTOR;
 return yyt;
}

tTree mLOOP_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pLOOP_VARNAME)
# else
(pLOOP_VARNAME)
tTree pLOOP_VARNAME;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kLOOP_VAR])
 yyt->Kind = kLOOP_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->LOOP_VAR.LOOP_VARNAME = pLOOP_VARNAME;
 return yyt;
}

tTree mPERM_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVAL, Permutation pperm)
# else
(pVAL, pperm)
tTree pVAL;
Permutation pperm;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPERM_VAR])
 yyt->Kind = kPERM_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PERM_VAR.VAL = pVAL;
 yyt->PERM_VAR.perm = pperm;
 return yyt;
}

tTree mADDR
# if defined __STDC__ | defined __cplusplus
(tTree pE)
# else
(pE)
tTree pE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kADDR])
 yyt->Kind = kADDR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ADDR.E = pE;
 return yyt;
}

tTree mDO_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pDO_ID, tTree pRANGE, tTree pBODY)
# else
(pDO_ID, pRANGE, pBODY)
tTree pDO_ID;
tTree pRANGE;
tTree pBODY;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDO_VAR])
 yyt->Kind = kDO_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->DO_VAR.DO_ID = pDO_ID;
 yyt->DO_VAR.RANGE = pRANGE;
 yyt->DO_VAR.BODY = pBODY;
 return yyt;
}

tTree mREMOTE_VAR
# if defined __STDC__ | defined __cplusplus
(tTree pVAR)
# else
(pVAR)
tTree pVAR;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREMOTE_VAR])
 yyt->Kind = kREMOTE_VAR;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REMOTE_VAR.VAR = pVAR;
 return yyt;
}

tTree mBT_VAR_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_VAR_LIST])
 yyt->Kind = kBT_VAR_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTV_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTV_EMPTY])
 yyt->Kind = kBTV_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTV_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTV_LIST])
 yyt->Kind = kBTV_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTV_LIST.Elem = pElem;
 yyt->BTV_LIST.Next = pNext;
 return yyt;
}

tTree mBT_PARAM
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_PARAM])
 yyt->Kind = kBT_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mVAR_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pV)
# else
(pV)
tTree pV;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_PARAM])
 yyt->Kind = kVAR_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_PARAM.V = pV;
 begintDefinitions(yyt->VAR_PARAM.formal)
 beginint(yyt->VAR_PARAM.intent)
 beginint(yyt->VAR_PARAM.layout)
 beginint(yyt->VAR_PARAM.pass_by)
 beginint(yyt->VAR_PARAM.trace)
 return yyt;
}

tTree mVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pE)
# else
(pE)
tTree pE;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVALUE_PARAM])
 yyt->Kind = kVALUE_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VALUE_PARAM.E = pE;
 return yyt;
}

tTree mNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
(tIdent pName, tTree pVAL)
# else
(pName, pVAL)
tIdent pName;
tTree pVAL;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNAMED_PARAM])
 yyt->Kind = kNAMED_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NAMED_PARAM.Name = pName;
 yyt->NAMED_PARAM.VAL = pVAL;
 return yyt;
}

tTree mPROC_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pP)
# else
(pP)
tTree pP;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_PARAM])
 yyt->Kind = kPROC_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_PARAM.P = pP;
 return yyt;
}

tTree mFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
(tTree pF)
# else
(pF)
tTree pF;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFUNC_PARAM])
 yyt->Kind = kFUNC_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FUNC_PARAM.F = pF;
 return yyt;
}

tTree mFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
(tStringRef pS)
# else
(pS)
tStringRef pS;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kFORMAT_PARAM])
 yyt->Kind = kFORMAT_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->FORMAT_PARAM.S = pS;
 return yyt;
}

tTree mRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
(int plabel)
# else
(plabel)
int plabel;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kRETURN_PARAM])
 yyt->Kind = kRETURN_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->RETURN_PARAM.label = plabel;
 return yyt;
}

tTree mNO_PARAM
# if defined __STDC__ | defined __cplusplus
(int ptype)
# else
(ptype)
int ptype;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_PARAM])
 yyt->Kind = kNO_PARAM;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->NO_PARAM.type = ptype;
 return yyt;
}

tTree mBT_PARAM_LIST
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBT_PARAM_LIST])
 yyt->Kind = kBT_PARAM_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTP_EMPTY
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTP_EMPTY])
 yyt->Kind = kBTP_EMPTY;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBTP_LIST
# if defined __STDC__ | defined __cplusplus
(tTree pElem, tTree pNext)
# else
(pElem, pNext)
tTree pElem;
tTree pNext;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBTP_LIST])
 yyt->Kind = kBTP_LIST;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BTP_LIST.Elem = pElem;
 yyt->BTP_LIST.Next = pNext;
 return yyt;
}

tTree mCONSTANT
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCONSTANT])
 yyt->Kind = kCONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(int pvalue)
# else
(pvalue)
int pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kBOOL_CONSTANT])
 yyt->Kind = kBOOL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->BOOL_CONSTANT.value = pvalue;
 return yyt;
}

tTree mINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
(int pvalue)
# else
(pvalue)
int pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINT_CONSTANT])
 yyt->Kind = kINT_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INT_CONSTANT.value = pvalue;
 return yyt;
}

tTree mREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue, int pkind)
# else
(pvalue, pkind)
tStringRef pvalue;
int pkind;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREAL_CONSTANT])
 yyt->Kind = kREAL_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REAL_CONSTANT.value = pvalue;
 yyt->REAL_CONSTANT.kind = pkind;
 return yyt;
}

tTree mSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef pvalue)
# else
(pvalue)
tStringRef pvalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSTRING_CONSTANT])
 yyt->Kind = kSTRING_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->STRING_CONSTANT.value = pvalue;
 return yyt;
}

tTree mCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
(tStringRef prvalue, tStringRef pivalue)
# else
(prvalue, pivalue)
tStringRef prvalue;
tStringRef pivalue;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMPLEX_CONSTANT])
 yyt->Kind = kCOMPLEX_CONSTANT;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMPLEX_CONSTANT.rvalue = prvalue;
 yyt->COMPLEX_CONSTANT.ivalue = pivalue;
 return yyt;
}

tTree mPROC_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPROC_OBJ])
 yyt->Kind = kPROC_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PROC_OBJ.Ident = pIdent;
 begintDefinitions(yyt->PROC_OBJ.Object)
 return yyt;
}

tTree mVAR_OBJ
# if defined __STDC__ | defined __cplusplus
(int pPos, tIdent pIdent)
# else
(pPos, pIdent)
int pPos;
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVAR_OBJ])
 yyt->Kind = kVAR_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VAR_OBJ.Pos = pPos;
 yyt->VAR_OBJ.Ident = pIdent;
 begintDefinitions(yyt->VAR_OBJ.Object)
 begintReaching(yyt->VAR_OBJ.Reaching)
 return yyt;
}

tTree mTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTYPE_OBJ])
 yyt->Kind = kTYPE_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TYPE_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TYPE_OBJ.Object)
 return yyt;
}

tTree mREC_COMP
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREC_COMP])
 yyt->Kind = kREC_COMP;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REC_COMP.Ident = pIdent;
 begintDefinitions(yyt->REC_COMP.Object)
 return yyt;
}

tTree mTOP_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTOP_OBJ])
 yyt->Kind = kTOP_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TOP_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TOP_OBJ.Object)
 return yyt;
}

tTree mTEMP_OBJ
# if defined __STDC__ | defined __cplusplus
(tIdent pIdent)
# else
(pIdent)
tIdent pIdent;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kTEMP_OBJ])
 yyt->Kind = kTEMP_OBJ;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->TEMP_OBJ.Ident = pIdent;
 begintDefinitions(yyt->TEMP_OBJ.Object)
 return yyt;
}

tTree mOVERLAP_SPEC
# if defined __STDC__ | defined __cplusplus
(int pleft_size, int pright_size, int pleft_update, int pright_update)
# else
(pleft_size, pright_size, pleft_update, pright_update)
int pleft_size;
int pright_size;
int pleft_update;
int pright_update;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kOVERLAP_SPEC])
 yyt->Kind = kOVERLAP_SPEC;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->OVERLAP_SPEC.left_size = pleft_size;
 yyt->OVERLAP_SPEC.right_size = pright_size;
 yyt->OVERLAP_SPEC.left_update = pleft_update;
 yyt->OVERLAP_SPEC.right_update = pright_update;
 return yyt;
}

tTree mDEPENDENCE_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kDEPENDENCE_INFO])
 yyt->Kind = kDEPENDENCE_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mSERIAL_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kSERIAL_INFO])
 yyt->Kind = kSERIAL_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mINDEP_INFO
# if defined __STDC__ | defined __cplusplus
(bool puser_independent, int pselection, InfoTree pred_vars, InfoTree pnew_vars)
# else
(puser_independent, pselection, pred_vars, pnew_vars)
bool puser_independent;
int pselection;
InfoTree pred_vars;
InfoTree pnew_vars;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kINDEP_INFO])
 yyt->Kind = kINDEP_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->INDEP_INFO.user_independent = puser_independent;
 yyt->INDEP_INFO.selection = pselection;
 yyt->INDEP_INFO.red_vars = pred_vars;
 yyt->INDEP_INFO.new_vars = pnew_vars;
 return yyt;
}

tTree mVECTOR_INFO
# if defined __STDC__ | defined __cplusplus
(bool pis_independent, int pselection, int ploop_cnt, InfoTree pindependent_vars)
# else
(pis_independent, pselection, ploop_cnt, pindependent_vars)
bool pis_independent;
int pselection;
int ploop_cnt;
InfoTree pindependent_vars;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kVECTOR_INFO])
 yyt->Kind = kVECTOR_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->VECTOR_INFO.is_independent = pis_independent;
 yyt->VECTOR_INFO.selection = pselection;
 yyt->VECTOR_INFO.loop_cnt = ploop_cnt;
 yyt->VECTOR_INFO.independent_vars = pindependent_vars;
 return yyt;
}

tTree mPARDO_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARDO_INFO])
 yyt->Kind = kPARDO_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mHOME_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kHOME_INFO])
 yyt->Kind = kHOME_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mNO_HOME_INFO
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kNO_HOME_INFO])
 yyt->Kind = kNO_HOME_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 return yyt;
}

tTree mCOMM_INFO
# if defined __STDC__ | defined __cplusplus
(InfoTree phome_var, bool pis_local)
# else
(phome_var, pis_local)
InfoTree phome_var;
bool pis_local;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kCOMM_INFO])
 yyt->Kind = kCOMM_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->COMM_INFO.home_var = phome_var;
 yyt->COMM_INFO.is_local = pis_local;
 return yyt;
}

tTree mON_INFO
# if defined __STDC__ | defined __cplusplus
(tObject pon_id, int pon_dim, int pbase, int pstride)
# else
(pon_id, pon_dim, pbase, pstride)
tObject pon_id;
int pon_dim;
int pbase;
int pstride;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kON_INFO])
 yyt->Kind = kON_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->ON_INFO.on_id = pon_id;
 yyt->ON_INFO.on_dim = pon_dim;
 yyt->ON_INFO.base = pbase;
 yyt->ON_INFO.stride = pstride;
 return yyt;
}

tTree mPARALLEL_INFO
# if defined __STDC__ | defined __cplusplus
(InfoTree preduction_vars, InfoTree phome_var, InfoTree pnew_vars, InfoTree president_vars)
# else
(preduction_vars, phome_var, pnew_vars, president_vars)
InfoTree preduction_vars;
InfoTree phome_var;
InfoTree pnew_vars;
InfoTree president_vars;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kPARALLEL_INFO])
 yyt->Kind = kPARALLEL_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->PARALLEL_INFO.reduction_vars = preduction_vars;
 yyt->PARALLEL_INFO.home_var = phome_var;
 yyt->PARALLEL_INFO.new_vars = pnew_vars;
 yyt->PARALLEL_INFO.resident_vars = president_vars;
 return yyt;
}

tTree mREACHING_INFO
# if defined __STDC__ | defined __cplusplus
(InfoTree pvar_allocate, InfoTree ptemp_allocate, tDefinitions pvar_distribution, tDefinitions ptemp_distribution)
# else
(pvar_allocate, ptemp_allocate, pvar_distribution, ptemp_distribution)
InfoTree pvar_allocate;
InfoTree ptemp_allocate;
tDefinitions pvar_distribution;
tDefinitions ptemp_distribution;
# endif
{
 register tTree yyt;
 yyALLOC (yyt, Tree_NodeSize [kREACHING_INFO])
 yyt->Kind = kREACHING_INFO;
 yyt->yyHead.yyMark = 0;
 yyt->yyHead.yyParent = NoTree;
 yyt->REACHING_INFO.var_allocate = pvar_allocate;
 yyt->REACHING_INFO.temp_allocate = ptemp_allocate;
 yyt->REACHING_INFO.var_distribution = pvar_distribution;
 yyt->REACHING_INFO.temp_distribution = ptemp_distribution;
 return yyt;
}

typedef tTree * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoTree || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kCOMP_UNIT:
yyMark (yyt->COMP_UNIT.COMP_ELEMENTS);
yyt = yyt->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_LIST:
yyMark (yyt->UNIT_LIST.Elem);
yyt = yyt->UNIT_LIST.Next; break;
case kMODULE_DECL:
yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL:
yyMark (yyt->PROGRAM_DECL.FORMALS);
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL:
yyMark (yyt->PROC_DECL.FORMALS);
yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL:
yyMark (yyt->FUNC_DECL.FORMALS);
yyMark (yyt->FUNC_DECL.FUNC_BODY);
yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL:
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE:
yyMark (yyt->INTERFACE.SPEC);
yyt = yyt->INTERFACE.ITEMS; break;
case kBODY_NODE:
yyMark (yyt->BODY_NODE.DECLS);
yyMark (yyt->BODY_NODE.STATS);
yyt = yyt->BODY_NODE.INTERNALS; break;
case kINTEGER_TYPE:
yyt = yyt->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE:
yyt = yyt->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE:
yyt = yyt->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE:
yyt = yyt->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE:
yyt = yyt->STRING_TYPE.LENGTH; break;
case kTYPE_ID:
yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE:
yyMark (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE:
yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE:
yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC:
yyt = yyt->SHAPE_SPEC.Overlap; break;
case kEXPLICIT_SHAPE:
yyMark (yyt->EXPLICIT_SHAPE.Overlap);
yyMark (yyt->EXPLICIT_SHAPE.LOWER);
yyt = yyt->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE:
yyMark (yyt->ASSUMED_SHAPE.Overlap);
yyt = yyt->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE:
yyt = yyt->DEFERRED_SHAPE.Overlap; break;
case kASSUMED_SIZE:
yyMark (yyt->ASSUMED_SIZE.Overlap);
yyt = yyt->ASSUMED_SIZE.LOWER; break;
case kSHAPE_LIST:
yyMark (yyt->SHAPE_LIST.Elem);
yyt = yyt->SHAPE_LIST.Next; break;
case kTYPE_DECL:
yyt = yyt->TYPE_DECL.VAL; break;
case kENTITY_DECL:
yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL:
yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL:
yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL:
yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL:
yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL:
yyt = yyt->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL:
yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL:
yyMark (yyt->SUB_PROCS_DECL.TOP);
yyt = yyt->SUB_PROCS_DECL.DIMENSIONS; break;
case kRANGE_DECL:
yyt = yyt->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL:
yyMark (yyt->STMT_FUNC_DECL.FORMALS);
yyMark (yyt->STMT_FUNC_DECL.RESULT_TYPE);
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL:
yyMark (yyt->INTERFACE_DECL.SPEC);
yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL:
yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kIMPLICIT_DECL:
yyt = yyt->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL:
yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL:
yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL:
yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL:
yyMark (yyt->DATA_DECL.VARS);
yyt = yyt->DATA_DECL.VALS; break;
case kFORMAT_DECL:
yyt = yyt->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL:
yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL:
yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL:
yyt = yyt->TYPESPEC_DECL.VAL; break;
case kPARAMETER_DECL:
yyt = yyt->PARAMETER_DECL.VAL; break;
case kDISTRIBUTE_DECL:
yyMark (yyt->DISTRIBUTE_DECL.DISTRIBUTION);
yyt = yyt->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL:
yyMark (yyt->ALIGN_DECL.ALIGN_SOURCE);
yyt = yyt->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL:
yyt = yyt->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL:
yyt = yyt->OVERLAP_DECL.OVERLAPS; break;
case kSELECT_DECL:
yyt = yyt->SELECT_DECL.SELECTIONS; break;
case kDECL_LIST:
yyMark (yyt->DECL_LIST.Elem);
yyt = yyt->DECL_LIST.Next; break;
case kRANGE_LIST:
yyMark (yyt->RANGE_LIST.Elem);
yyt = yyt->RANGE_LIST.Next; break;
case kSELECT_LIST:
yyMark (yyt->SELECT_LIST.Elem);
yyt = yyt->SELECT_LIST.Next; break;
case kNODE_DISTRIBUTION:
yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_LIST:
yyMark (yyt->DIST_LIST.Elem);
yyt = yyt->DIST_LIST.Next; break;
case kBLOCK_DISTRIBUTION:
yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION:
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION:
yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION:
yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION:
yyMark (yyt->ARBITRARY_DISTRIBUTION.SIZE);
yyMark (yyt->ARBITRARY_DISTRIBUTION.LENGTH);
yyt = yyt->ARBITRARY_DISTRIBUTION.MAP; break;
case kPROCESSOR_ARRAY:
yyt = yyt->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET:
yyMark (yyt->PROCESSOR_SUBSET.SUBTOP);
yyMark (yyt->PROCESSOR_SUBSET.FULLTOP);
yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC:
yyMark (yyt->ALIGN_SPEC.TEMPNAME);
yyt = yyt->ALIGN_SPEC.SUBSCRIPTS; break;
case kOP_GENERIC_SPEC:
yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kACF_LIST:
yyMark (yyt->ACF_LIST.Elem);
yyt = yyt->ACF_LIST.Next; break;
case kACF_BASIC:
yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF:
yyMark (yyt->ACF_IF.IF_EXP);
yyMark (yyt->ACF_IF.THEN_PART);
yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE:
yyMark (yyt->ACF_WHERE.WHERE_EXP);
yyMark (yyt->ACF_WHERE.TRUE_PART);
yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_CASE:
yyMark (yyt->ACF_CASE.CASE_EXP);
yyt = yyt->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE:
yyMark (yyt->ACF_WHILE.WHILE_EXP);
yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT:
yyMark (yyt->ACF_REPEAT.REPEAT_BODY);
yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP:
yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO:
yyMark (yyt->ACF_DO.DO_ID);
yyMark (yyt->ACF_DO.DO_RANGE);
yyMark (yyt->ACF_DO.DO_BODY);
yyMark (yyt->ACF_DO.DO_DEP_INFO);
yyt = yyt->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL:
yyMark (yyt->ACF_FORALL.FORALL_ID);
yyMark (yyt->ACF_FORALL.FORALL_RANGE);
yyMark (yyt->ACF_FORALL.FORALL_BODY);
yyMark (yyt->ACF_FORALL.FORALL_DEP_INFO);
yyt = yyt->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH:
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY:
yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME:
yyMark (yyt->ACF_HOME.HOME_VAR);
yyt = yyt->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT:
yyMark (yyt->ACF_RESIDENT.RESIDENT_VAR);
yyt = yyt->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW:
yyMark (yyt->ACF_NEW.NEW_VAR);
yyt = yyt->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION:
yyMark (yyt->ACF_REDUCTION.REDUCTION_VAR);
yyMark (yyt->ACF_REDUCTION.REDUCTION_LVAR);
yyMark (yyt->ACF_REDUCTION.REDUCTION_FUNC);
yyt = yyt->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION:
yyt = yyt->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL:
yyMark (yyt->ACF_PARALLEL.REDUCTION_VARS);
yyMark (yyt->ACF_PARALLEL.SHARED_VARS);
yyMark (yyt->ACF_PARALLEL.LOCAL_VARS);
yyt = yyt->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL:
yyt = yyt->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON:
yyMark (yyt->ACF_ON.ON_HOME);
yyMark (yyt->ACF_ON.ON_SPECS);
yyt = yyt->ACF_ON.ON_BODY; break;
case kACF_RM_READ:
yyMark (yyt->ACF_RM_READ.LOCAL_VAR);
yyt = yyt->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE:
yyMark (yyt->ACF_RM_WRITE.REMOTE_VAR);
yyt = yyt->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE:
yyt = yyt->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER:
yyt = yyt->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE:
yyt = yyt->ACF_UPDATE.OVERLAP_VAR; break;
case kON_VAR_CLAUSE:
yyt = yyt->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE:
yyt = yyt->ON_PROC_CLAUSE.ON_PROC; break;
case kON_LIST:
yyMark (yyt->ON_LIST.Elem);
yyt = yyt->ON_LIST.Next; break;
case kON_SPEC:
yyt = yyt->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_LIST:
yyMark (yyt->SELECTED_ACF_LIST.Elem);
yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE:
yyMark (yyt->SELECTED_ACF_NODE.SELECT_LIST);
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kASSIGN_STMT:
yyMark (yyt->ASSIGN_STMT.ASSIGN_VAR);
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT:
yyMark (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT:
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT:
yyMark (yyt->CALL_STMT.CALL_ID);
yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT:
yyMark (yyt->IO_STMT.ID);
yyMark (yyt->IO_STMT.IO_SPECS);
yyt = yyt->IO_STMT.IO_ITEMS; break;
case kASS_GOTO_STMT:
yyMark (yyt->ASS_GOTO_STMT.GOTO_VAR);
yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT:
yyMark (yyt->COMP_GOTO_STMT.GOTO_LABELS);
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT:
yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT:
yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT:
yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kSTOP_STMT:
yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT:
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT:
yyMark (yyt->INHERIT_DSP_STMT.VAR);
yyt = yyt->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT:
yyMark (yyt->CREATE_DSP_STMT.VAR);
yyt = yyt->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT:
yyt = yyt->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT:
yyMark (yyt->ALLOCATE_STMT.PARAMS);
yyt = yyt->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT:
yyMark (yyt->DEALLOCATE_STMT.PARAMS);
yyt = yyt->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT:
yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT:
yyMark (yyt->REDUCE_STMT.RED_FUNC);
yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT:
yyMark (yyt->MOVE_STMT.TARGET);
yyMark (yyt->MOVE_STMT.SOURCE);
yyt = yyt->MOVE_STMT.MASK; break;
case kSCATTER_STMT:
yyMark (yyt->SCATTER_STMT.ARRAY);
yyMark (yyt->SCATTER_STMT.BASE);
yyMark (yyt->SCATTER_STMT.INDEXES);
yyt = yyt->SCATTER_STMT.MASK; break;
case kREALIGN_STMT:
yyMark (yyt->REALIGN_STMT.ALIGNEE);
yyMark (yyt->REALIGN_STMT.ALIGN_SOURCE);
yyt = yyt->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT:
yyMark (yyt->REDISTRIBUTE_STMT.DISTRIBUTEE);
yyMark (yyt->REDISTRIBUTE_STMT.DISTRIBUTION);
yyt = yyt->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET:
yyMark (yyt->REG_SHADOW_GET.SHADOW_VAR);
yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT:
yyMark (yyt->REG_SHADOW_PUT.SHADOW_VAR);
yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET:
yyMark (yyt->REG_SHADOW_SET.SHADOW_VAR);
yyMark (yyt->REG_SHADOW_SET.SHADOW_SIZE);
yyt = yyt->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE:
yyMark (yyt->IND_SHADOW_CREATE.SHADOW_VAR);
yyMark (yyt->IND_SHADOW_CREATE.INDEX_VAR);
yyMark (yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR);
yyt = yyt->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE:
yyt = yyt->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET:
yyt = yyt->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT:
yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET:
yyMark (yyt->IND_SHADOW_SET.SHADOW_VAR);
yyt = yyt->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT:
yyMark (yyt->BROADCAST_STMT.ELEMS);
yyMark (yyt->BROADCAST_STMT.OWNER_TOP);
yyt = yyt->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT:
yyMark (yyt->REDUCTION_STMT.REDFUNC);
yyMark (yyt->REDUCTION_STMT.ELEMS);
yyMark (yyt->REDUCTION_STMT.RED_TOP);
yyt = yyt->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT:
yyt = yyt->DIRTY_STMT.ELEMS; break;
case kLABEL_LIST:
yyt = yyt->LABEL_LIST.Next; break;
case kCONST_EXP:
yyt = yyt->CONST_EXP.C; break;
case kOP_EXP:
yyMark (yyt->OP_EXP.EXP_OP);
yyMark (yyt->OP_EXP.OPND1);
yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP:
yyMark (yyt->OP1_EXP.EXP_OP1);
yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP:
yyMark (yyt->SLICE_EXP.START);
yyMark (yyt->SLICE_EXP.STOP);
yyt = yyt->SLICE_EXP.INC; break;
case kVAR_EXP:
yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP:
yyMark (yyt->FUNC_CALL_EXP.FUNC_ID);
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP:
yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP:
yyMark (yyt->DO_EXP.DO_ID);
yyMark (yyt->DO_EXP.RANGE);
yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP:
yyMark (yyt->TYPE_EXP.ID);
yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP:
yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP:
yyt = yyt->PERM_EXP.VAL; break;
case kBOUND_EXP:
yyt = yyt->BOUND_EXP.VAR; break;
case kBTE_LIST:
yyMark (yyt->BTE_LIST.Elem);
yyt = yyt->BTE_LIST.Next; break;
case kUSED_VAR:
yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR:
yyMark (yyt->INDEXED_VAR.IND_VAR);
yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR:
yyMark (yyt->SUBSTRING_VAR.IND_VAR);
yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR:
yyMark (yyt->SELECTED_VAR.SELEC_VAR);
yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR:
yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR:
yyt = yyt->PERM_VAR.VAL; break;
case kADDR:
yyt = yyt->ADDR.E; break;
case kDO_VAR:
yyMark (yyt->DO_VAR.DO_ID);
yyMark (yyt->DO_VAR.RANGE);
yyt = yyt->DO_VAR.BODY; break;
case kREMOTE_VAR:
yyt = yyt->REMOTE_VAR.VAR; break;
case kBTV_LIST:
yyMark (yyt->BTV_LIST.Elem);
yyt = yyt->BTV_LIST.Next; break;
case kVAR_PARAM:
yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM:
yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM:
yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM:
yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM:
yyt = yyt->FUNC_PARAM.F; break;
case kBTP_LIST:
yyMark (yyt->BTP_LIST.Elem);
yyt = yyt->BTP_LIST.Next; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tTree yyTreeStore [yyInitTreeStoreSize];
static tTree * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;

static Tree_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tTree));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteTree ();

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static void yyWriteAdr
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 if (yyt == NoTree) (void) fputs ("NoTree", yyf);
 else yyWriteHex ((unsigned char *) & yyt, sizeof (yyt));
 yyWriteNl ();
}

static void yWriteNodeCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("COMP_ELEMENTS"); yyWriteAdr (yyt->COMP_UNIT.COMP_ELEMENTS);
 yyWriteSelector ("USED_ELEMENTS"); yyWriteAdr (yyt->COMP_UNIT.USED_ELEMENTS);
}

static void yWriteNodeUNIT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->UNIT_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->UNIT_LIST.Next);
}

static void yWriteNodeUNIT_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->UNIT_NODE.Ident) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->UNIT_NODE.Line) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->UNIT_NODE.Object) yyWriteNl ();
}

static void yWriteNodeMODULE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("MODULE_BODY"); yyWriteAdr (yyt->MODULE_DECL.MODULE_BODY);
}

static void yWriteNodePROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->PROGRAM_DECL.FORMALS);
 yyWriteSelector ("PROGRAM_BODY"); yyWriteAdr (yyt->PROGRAM_DECL.PROGRAM_BODY);
}

static void yWriteNodePROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->PROC_DECL.FORMALS);
 yyWriteSelector ("PROC_BODY"); yyWriteAdr (yyt->PROC_DECL.PROC_BODY);
 yyWriteSelector ("IsRecursive"); writebool (yyt->PROC_DECL.IsRecursive) yyWriteNl ();
 yyWriteSelector ("IsPure"); writebool (yyt->PROC_DECL.IsPure) yyWriteNl ();
 yyWriteSelector ("HPFExtrinsic"); writetIdent (yyt->PROC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteNodeFUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->FUNC_DECL.FORMALS);
 yyWriteSelector ("FUNC_BODY"); yyWriteAdr (yyt->FUNC_DECL.FUNC_BODY);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->FUNC_DECL.RESULT_TYPE);
 yyWriteSelector ("RESULT_ID"); writetIdent (yyt->FUNC_DECL.RESULT_ID) yyWriteNl ();
 yyWriteSelector ("IsRecursive"); writebool (yyt->FUNC_DECL.IsRecursive) yyWriteNl ();
 yyWriteSelector ("IsPure"); writebool (yyt->FUNC_DECL.IsPure) yyWriteNl ();
 yyWriteSelector ("HPFExtrinsic"); writetIdent (yyt->FUNC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteNodeMODULE_PROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
}

static void yWriteNodeBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("DATA_BODY"); yyWriteAdr (yyt->BLOCK_DATA_DECL.DATA_BODY);
}

static void yWriteNodeINTERFACE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeUNIT_NODE (yyt); 
 yyWriteSelector ("SPEC"); yyWriteAdr (yyt->INTERFACE.SPEC);
 yyWriteSelector ("ITEMS"); yyWriteAdr (yyt->INTERFACE.ITEMS);
}

static void yWriteNodeBODY_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DECLS"); yyWriteAdr (yyt->BODY_NODE.DECLS);
 yyWriteSelector ("STATS"); yyWriteAdr (yyt->BODY_NODE.STATS);
 yyWriteSelector ("INTERNALS"); yyWriteAdr (yyt->BODY_NODE.INTERNALS);
}

static void yWriteNodeINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->INTEGER_TYPE.SIZE);
}

static void yWriteNodeREAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->REAL_TYPE.SIZE);
}

static void yWriteNodeBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->BOOLEAN_TYPE.SIZE);
}

static void yWriteNodeCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->COMPLEX_TYPE.SIZE);
}

static void yWriteNodeSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LENGTH"); yyWriteAdr (yyt->STRING_TYPE.LENGTH);
}

static void yWriteNodeTYPE_ID
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->TYPE_ID.ID);
}

static void yWriteNodeARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY_INDEX_TYPES"); yyWriteAdr (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
 yyWriteSelector ("ARRAY_COMP_TYPE"); yyWriteAdr (yyt->ARRAY_TYPE.ARRAY_COMP_TYPE);
}

static void yWriteNodeRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->RECORD_TYPE.Name) yyWriteNl ();
 yyWriteSelector ("COMPONENTS"); yyWriteAdr (yyt->RECORD_TYPE.COMPONENTS);
}

static void yWriteNodePOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PTR_COMP"); yyWriteAdr (yyt->POINTER_TYPE.PTR_COMP);
}

static void yWriteNodeSHAPE_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Overlap"); yyWriteAdr (yyt->SHAPE_SPEC.Overlap);
}

static void yWriteNodeEXPLICIT_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->EXPLICIT_SHAPE.LOWER);
 yyWriteSelector ("UPPER"); yyWriteAdr (yyt->EXPLICIT_SHAPE.UPPER);
}

static void yWriteNodeASSUMED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->ASSUMED_SHAPE.LOWER);
}

static void yWriteNodeDEFERRED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
}

static void yWriteNodeASSUMED_SIZE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeSHAPE_SPEC (yyt); 
 yyWriteSelector ("LOWER"); yyWriteAdr (yyt->ASSUMED_SIZE.LOWER);
}

static void yWriteNodeSHAPE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SHAPE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SHAPE_LIST.Next);
}

static void yWriteNodeDECL_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->DECL_NODE.Ident) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->DECL_NODE.Line) yyWriteNl ();
}

static void yWriteNodeTYPE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->TYPE_DECL.VAL);
}

static void yWriteNodeNAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeRENAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("oldname"); writetIdent (yyt->RENAME_DECL.oldname) yyWriteNl ();
}

static void yWriteNodeENTITY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("ATTRIBUTES"); yyWriteAdr (yyt->ENTITY_DECL.ATTRIBUTES);
}

static void yWriteNodeVAR_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAR_DECL.VAL);
}

static void yWriteNodeCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("IDS"); yyWriteAdr (yyt->COMMON_DECL.IDS);
}

static void yWriteNodeNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("IDS"); yyWriteAdr (yyt->NAMELIST_DECL.IDS);
}

static void yWriteNodeTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->TEMPLATE_DECL.DIMENSIONS);
}

static void yWriteNodeRAGGED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->RAGGED_DECL.DIMENSIONS);
}

static void yWriteNodePROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->PROCESSORS_DECL.DIMENSIONS);
}

static void yWriteNodeSUB_PROCS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("TOP"); yyWriteAdr (yyt->SUB_PROCS_DECL.TOP);
 yyWriteSelector ("DIMENSIONS"); yyWriteAdr (yyt->SUB_PROCS_DECL.DIMENSIONS);
}

static void yWriteNodeINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeRANGE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("RANGES"); yyWriteAdr (yyt->RANGE_DECL.RANGES);
}

static void yWriteNodeSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("FORMALS"); yyWriteAdr (yyt->STMT_FUNC_DECL.FORMALS);
 yyWriteSelector ("RESULT_TYPE"); yyWriteAdr (yyt->STMT_FUNC_DECL.RESULT_TYPE);
 yyWriteSelector ("FFUNC_BODY"); yyWriteAdr (yyt->STMT_FUNC_DECL.FFUNC_BODY);
}

static void yWriteNodeINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("SPEC"); yyWriteAdr (yyt->INTERFACE_DECL.SPEC);
 yyWriteSelector ("ITEMS"); yyWriteAdr (yyt->INTERFACE_DECL.ITEMS);
}

static void yWriteNodeVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->VAR_PARAM_DECL.VAL);
}

static void yWriteNodeRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("first"); writetIdent (yyt->IMPLICIT_DECL.first) yyWriteNl ();
 yyWriteSelector ("last"); writetIdent (yyt->IMPLICIT_DECL.last) yyWriteNl ();
 yyWriteSelector ("TYPE"); yyWriteAdr (yyt->IMPLICIT_DECL.TYPE);
}

static void yWriteNodeUSE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("use"); writetIdent (yyt->USE_DECL.use) yyWriteNl ();
 yyWriteSelector ("RENAMINGS"); yyWriteAdr (yyt->USE_DECL.RENAMINGS);
}

static void yWriteNodeONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("use"); writetIdent (yyt->ONLY_USE_DECL.use) yyWriteNl ();
 yyWriteSelector ("NAMES"); yyWriteAdr (yyt->ONLY_USE_DECL.NAMES);
}

static void yWriteNodeEQV_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VARS"); yyWriteAdr (yyt->EQV_DECL.VARS);
}

static void yWriteNodeDATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VARS"); yyWriteAdr (yyt->DATA_DECL.VARS);
 yyWriteSelector ("VALS"); yyWriteAdr (yyt->DATA_DECL.VALS);
}

static void yWriteNodeFORMAT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("label"); writeint (yyt->FORMAT_DECL.label) yyWriteNl ();
 yyWriteSelector ("FORMAT_PARAMS"); yyWriteAdr (yyt->FORMAT_DECL.FORMAT_PARAMS);
}

static void yWriteNodeDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("INDEXES"); yyWriteAdr (yyt->DIMENSION_DECL.INDEXES);
}

static void yWriteNodeINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->INIT_DATA_DECL.VAL);
}

static void yWriteNodeTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->TYPESPEC_DECL.VAL);
}

static void yWriteNodeALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeINTENT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("intent"); writeint (yyt->INTENT_DECL.intent) yyWriteNl ();
}

static void yWriteNodeINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("generic"); writetIdent (yyt->INTRINSIC_DECL.generic) yyWriteNl ();
 yyWriteSelector ("class"); writeint (yyt->INTRINSIC_DECL.class) yyWriteNl ();
 yyWriteSelector ("kind"); writeint (yyt->INTRINSIC_DECL.kind) yyWriteNl ();
}

static void yWriteNodeOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePOINTER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSAVE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTARGET_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PARAMETER_DECL.VAL);
}

static void yWriteNodePUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodePRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("DISTRIBUTION"); yyWriteAdr (yyt->DISTRIBUTE_DECL.DISTRIBUTION);
 yyWriteSelector ("TARGET"); yyWriteAdr (yyt->DISTRIBUTE_DECL.TARGET);
}

static void yWriteNodeALIGN_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("ALIGN_SOURCE"); yyWriteAdr (yyt->ALIGN_DECL.ALIGN_SOURCE);
 yyWriteSelector ("ALIGN_TARGET"); yyWriteAdr (yyt->ALIGN_DECL.ALIGN_TARGET);
}

static void yWriteNodeMAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("MAP_TARGET"); yyWriteAdr (yyt->MAP_DECL.MAP_TARGET);
}

static void yWriteNodeOVERLAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("OVERLAPS"); yyWriteAdr (yyt->OVERLAP_DECL.OVERLAPS);
}

static void yWriteNodeSHARED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writeint (yyt->SHARED_DECL.kind) yyWriteNl ();
}

static void yWriteNodeDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTRACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeTREE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeSELECT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("SELECTIONS"); yyWriteAdr (yyt->SELECT_DECL.SELECTIONS);
}

static void yWriteNodeHPF_SEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
}

static void yWriteNodeLAYOUT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writetStringRef (yyt->LAYOUT_DECL.kind) yyWriteNl ();
}

static void yWriteNodePASS_BY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writetStringRef (yyt->PASS_BY_DECL.kind) yyWriteNl ();
}

static void yWriteNodeMAP_TO_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDECL_NODE (yyt); 
 yyWriteSelector ("kind"); writetStringRef (yyt->MAP_TO_DECL.kind) yyWriteNl ();
}

static void yWriteNodeDECL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->DECL_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->DECL_LIST.Next);
}

static void yWriteNodeRANGE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->RANGE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->RANGE_LIST.Next);
}

static void yWriteNodeSELECT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SELECT_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SELECT_LIST.Next);
}

static void yWriteNodeSELECT_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("selector"); writeint (yyt->SELECT_SPEC.selector) yyWriteNl ();
}

static void yWriteNodeDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("is_descriptive"); writeint (yyt->DISTRIBUTION_SPEC.is_descriptive) yyWriteNl ();
}

static void yWriteNodeANY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
}

static void yWriteNodeDEFAULT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
}

static void yWriteNodeREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
}

static void yWriteNodeNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeDISTRIBUTION_SPEC (yyt); 
 yyWriteSelector ("MAPPING"); yyWriteAdr (yyt->NODE_DISTRIBUTION.MAPPING);
}

static void yWriteNodeDIST_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->DIST_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->DIST_LIST.Next);
}

static void yWriteNodeBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->BLOCK_DISTRIBUTION.SIZE);
}

static void yWriteNodeCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->CYCLIC_DISTRIBUTION.SIZE);
}

static void yWriteNodeGEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->GEN_BLOCK_DISTRIBUTION.ARRAY);
}

static void yWriteNodeINDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->INDIRECT_DISTRIBUTION.ARRAY);
}

static void yWriteNodeARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SIZE"); yyWriteAdr (yyt->ARBITRARY_DISTRIBUTION.SIZE);
 yyWriteSelector ("LENGTH"); yyWriteAdr (yyt->ARBITRARY_DISTRIBUTION.LENGTH);
 yyWriteSelector ("MAP"); yyWriteAdr (yyt->ARBITRARY_DISTRIBUTION.MAP);
}

static void yWriteNodePROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("TOPNAME"); yyWriteAdr (yyt->PROCESSOR_ARRAY.TOPNAME);
}

static void yWriteNodePROCESSOR_SUBSET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SUBTOP"); yyWriteAdr (yyt->PROCESSOR_SUBSET.SUBTOP);
 yyWriteSelector ("FULLTOP"); yyWriteAdr (yyt->PROCESSOR_SUBSET.FULLTOP);
 yyWriteSelector ("SUBSCRIPTS"); yyWriteAdr (yyt->PROCESSOR_SUBSET.SUBSCRIPTS);
}

static void yWriteNodeALIGN_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("is_descriptive"); writeint (yyt->ALIGN_SPEC.is_descriptive) yyWriteNl ();
 yyWriteSelector ("TEMPNAME"); yyWriteAdr (yyt->ALIGN_SPEC.TEMPNAME);
 yyWriteSelector ("SUBSCRIPTS"); yyWriteAdr (yyt->ALIGN_SPEC.SUBSCRIPTS);
}

static void yWriteNodeID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("name"); writetIdent (yyt->ID_GENERIC_SPEC.name) yyWriteNl ();
}

static void yWriteNodeOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("OPERATOR"); yyWriteAdr (yyt->OP_GENERIC_SPEC.OPERATOR);
}

static void yWriteNodeACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->ACF_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->ACF_LIST.Next);
}

static void yWriteNodeACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Label"); writeint (yyt->ACF_NODE.Label) yyWriteNl ();
 yyWriteSelector ("Line"); writeint (yyt->ACF_NODE.Line) yyWriteNl ();
}

static void yWriteNodeACF_DUMMY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
}

static void yWriteNodeACF_BASIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("BASIC_STMT"); yyWriteAdr (yyt->ACF_BASIC.BASIC_STMT);
}

static void yWriteNodeACF_IF
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("IF_EXP"); yyWriteAdr (yyt->ACF_IF.IF_EXP);
 yyWriteSelector ("THEN_PART"); yyWriteAdr (yyt->ACF_IF.THEN_PART);
 yyWriteSelector ("ELSE_PART"); yyWriteAdr (yyt->ACF_IF.ELSE_PART);
}

static void yWriteNodeACF_WHERE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WHERE_EXP"); yyWriteAdr (yyt->ACF_WHERE.WHERE_EXP);
 yyWriteSelector ("TRUE_PART"); yyWriteAdr (yyt->ACF_WHERE.TRUE_PART);
 yyWriteSelector ("FALSE_PART"); yyWriteAdr (yyt->ACF_WHERE.FALSE_PART);
}

static void yWriteNodeACF_CASE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("CASE_EXP"); yyWriteAdr (yyt->ACF_CASE.CASE_EXP);
 yyWriteSelector ("CASE_ALTS"); yyWriteAdr (yyt->ACF_CASE.CASE_ALTS);
}

static void yWriteNodeACF_WHILE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("WHILE_EXP"); yyWriteAdr (yyt->ACF_WHILE.WHILE_EXP);
 yyWriteSelector ("WHILE_BODY"); yyWriteAdr (yyt->ACF_WHILE.WHILE_BODY);
}

static void yWriteNodeACF_REPEAT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("REPEAT_BODY"); yyWriteAdr (yyt->ACF_REPEAT.REPEAT_BODY);
 yyWriteSelector ("REPEAT_EXP"); yyWriteAdr (yyt->ACF_REPEAT.REPEAT_EXP);
}

static void yWriteNodeACF_LOOP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("LOOP_BODY"); yyWriteAdr (yyt->ACF_LOOP.LOOP_BODY);
}

static void yWriteNodeACF_DO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->ACF_DO.DO_ID);
 yyWriteSelector ("DO_RANGE"); yyWriteAdr (yyt->ACF_DO.DO_RANGE);
 yyWriteSelector ("DO_BODY"); yyWriteAdr (yyt->ACF_DO.DO_BODY);
 yyWriteSelector ("DO_DEP_INFO"); yyWriteAdr (yyt->ACF_DO.DO_DEP_INFO);
 yyWriteSelector ("DO_HOME_INFO"); yyWriteAdr (yyt->ACF_DO.DO_HOME_INFO);
}

static void yWriteNodeACF_FORALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("FORALL_ID"); yyWriteAdr (yyt->ACF_FORALL.FORALL_ID);
 yyWriteSelector ("FORALL_RANGE"); yyWriteAdr (yyt->ACF_FORALL.FORALL_RANGE);
 yyWriteSelector ("FORALL_BODY"); yyWriteAdr (yyt->ACF_FORALL.FORALL_BODY);
 yyWriteSelector ("FORALL_DEP_INFO"); yyWriteAdr (yyt->ACF_FORALL.FORALL_DEP_INFO);
 yyWriteSelector ("FORALL_HOME_INFO"); yyWriteAdr (yyt->ACF_FORALL.FORALL_HOME_INFO);
}

static void yWriteNodeACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("FLOW_NODES"); yyWriteAdr (yyt->ACF_FLOW_GRAPH.FLOW_NODES);
}

static void yWriteNodeACF_ENTRY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ENTRY_DECL"); yyWriteAdr (yyt->ACF_ENTRY.ENTRY_DECL);
}

static void yWriteNodeACF_HOME
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("HOME_VAR"); yyWriteAdr (yyt->ACF_HOME.HOME_VAR);
 yyWriteSelector ("user_home"); writebool (yyt->ACF_HOME.user_home) yyWriteNl ();
 yyWriteSelector ("HOME_BODY"); yyWriteAdr (yyt->ACF_HOME.HOME_BODY);
}

static void yWriteNodeACF_RESIDENT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("RESIDENT_VAR"); yyWriteAdr (yyt->ACF_RESIDENT.RESIDENT_VAR);
 yyWriteSelector ("RESIDENT_BODY"); yyWriteAdr (yyt->ACF_RESIDENT.RESIDENT_BODY);
}

static void yWriteNodeACF_NEW
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("NEW_VAR"); yyWriteAdr (yyt->ACF_NEW.NEW_VAR);
 yyWriteSelector ("NEW_BODY"); yyWriteAdr (yyt->ACF_NEW.NEW_BODY);
}

static void yWriteNodeACF_REDUCTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("is_zero"); writebool (yyt->ACF_REDUCTION.is_zero) yyWriteNl ();
 yyWriteSelector ("REDUCTION_VAR"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_VAR);
 yyWriteSelector ("REDUCTION_LVAR"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_LVAR);
 yyWriteSelector ("REDUCTION_FUNC"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_FUNC);
 yyWriteSelector ("REDUCTION_BODY"); yyWriteAdr (yyt->ACF_REDUCTION.REDUCTION_BODY);
}

static void yWriteNodeACF_TASK_REGION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("task_flag"); writeint (yyt->ACF_TASK_REGION.task_flag) yyWriteNl ();
 yyWriteSelector ("TASK_BODY"); yyWriteAdr (yyt->ACF_TASK_REGION.TASK_BODY);
}

static void yWriteNodeACF_PARALLEL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("REDUCTION_VARS"); yyWriteAdr (yyt->ACF_PARALLEL.REDUCTION_VARS);
 yyWriteSelector ("SHARED_VARS"); yyWriteAdr (yyt->ACF_PARALLEL.SHARED_VARS);
 yyWriteSelector ("LOCAL_VARS"); yyWriteAdr (yyt->ACF_PARALLEL.LOCAL_VARS);
 yyWriteSelector ("PARALLEL_BODY"); yyWriteAdr (yyt->ACF_PARALLEL.PARALLEL_BODY);
}

static void yWriteNodeACF_CRITICAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("CRITICAL_BODY"); yyWriteAdr (yyt->ACF_CRITICAL.CRITICAL_BODY);
}

static void yWriteNodeACF_ON
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("ON_HOME"); yyWriteAdr (yyt->ACF_ON.ON_HOME);
 yyWriteSelector ("ON_SPECS"); yyWriteAdr (yyt->ACF_ON.ON_SPECS);
 yyWriteSelector ("ON_BODY"); yyWriteAdr (yyt->ACF_ON.ON_BODY);
}

static void yWriteNodeACF_RM_READ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("LOCAL_VAR"); yyWriteAdr (yyt->ACF_RM_READ.LOCAL_VAR);
 yyWriteSelector ("REMOTE_VAR"); yyWriteAdr (yyt->ACF_RM_READ.REMOTE_VAR);
}

static void yWriteNodeACF_RM_WRITE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("op"); writeint (yyt->ACF_RM_WRITE.op) yyWriteNl ();
 yyWriteSelector ("REMOTE_VAR"); yyWriteAdr (yyt->ACF_RM_WRITE.REMOTE_VAR);
 yyWriteSelector ("LOCAL_DATA"); yyWriteAdr (yyt->ACF_RM_WRITE.LOCAL_DATA);
}

static void yWriteNodeACF_MOVE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("MOVE_STMT"); yyWriteAdr (yyt->ACF_MOVE.MOVE_STMT);
}

static void yWriteNodeACF_BARRIER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("BARRIER_VARS"); yyWriteAdr (yyt->ACF_BARRIER.BARRIER_VARS);
}

static void yWriteNodeACF_UPDATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yWriteNodeACF_NODE (yyt); 
 yyWriteSelector ("OVERLAP_VAR"); yyWriteAdr (yyt->ACF_UPDATE.OVERLAP_VAR);
}

static void yWriteNodeON_VAR_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ON_VAR"); yyWriteAdr (yyt->ON_VAR_CLAUSE.ON_VAR);
}

static void yWriteNodeON_PROC_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ON_PROC"); yyWriteAdr (yyt->ON_PROC_CLAUSE.ON_PROC);
}

static void yWriteNodeON_PROCS
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("topid"); writetObject (yyt->ON_PROCS.topid) yyWriteNl ();
}

static void yWriteNodeON_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("topid"); writetObject (yyt->ON_VAR.topid) yyWriteNl ();
 yyWriteSelector ("tempid"); writetObject (yyt->ON_VAR.tempid) yyWriteNl ();
 yyWriteSelector ("arrayid"); writetObject (yyt->ON_VAR.arrayid) yyWriteNl ();
}

static void yWriteNodeON_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->ON_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->ON_LIST.Next);
}

static void yWriteNodeON_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("top_dim"); writeint (yyt->ON_SPEC.top_dim) yyWriteNl ();
 yyWriteSelector ("temp_dim"); writeint (yyt->ON_SPEC.temp_dim) yyWriteNl ();
 yyWriteSelector ("array_dim"); writeint (yyt->ON_SPEC.array_dim) yyWriteNl ();
 yyWriteSelector ("ON_VAL"); yyWriteAdr (yyt->ON_SPEC.ON_VAL);
}

static void yWriteNodeSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->SELECTED_ACF_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->SELECTED_ACF_LIST.Next);
}

static void yWriteNodeSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELECT_LIST"); yyWriteAdr (yyt->SELECTED_ACF_NODE.SELECT_LIST);
 yyWriteSelector ("SELECT_ACFS"); yyWriteAdr (yyt->SELECTED_ACF_NODE.SELECT_ACFS);
}

static void yWriteNodeASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_VAR"); yyWriteAdr (yyt->ASSIGN_STMT.ASSIGN_VAR);
 yyWriteSelector ("ASSIGN_EXP"); yyWriteAdr (yyt->ASSIGN_STMT.ASSIGN_EXP);
}

static void yWriteNodePTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ASSIGN_VAR"); yyWriteAdr (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
 yyWriteSelector ("ASSIGN_EXP"); yyWriteAdr (yyt->PTR_ASSIGN_STMT.ASSIGN_EXP);
}

static void yWriteNodeLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("assign_label"); writeint (yyt->LABEL_ASSIGN_STMT.assign_label) yyWriteNl ();
 yyWriteSelector ("LABEL_VAR"); yyWriteAdr (yyt->LABEL_ASSIGN_STMT.LABEL_VAR);
}

static void yWriteNodeCALL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("CALL_ID"); yyWriteAdr (yyt->CALL_STMT.CALL_ID);
 yyWriteSelector ("CALL_PARAMS"); yyWriteAdr (yyt->CALL_STMT.CALL_PARAMS);
}

static void yWriteNodeIO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->IO_STMT.ID);
 yyWriteSelector ("IO_SPECS"); yyWriteAdr (yyt->IO_STMT.IO_SPECS);
 yyWriteSelector ("IO_ITEMS"); yyWriteAdr (yyt->IO_STMT.IO_ITEMS);
}

static void yWriteNodeGOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_LABEL"); writeint (yyt->GOTO_STMT.GOTO_LABEL) yyWriteNl ();
}

static void yWriteNodeASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_VAR"); yyWriteAdr (yyt->ASS_GOTO_STMT.GOTO_VAR);
 yyWriteSelector ("LABELS"); yyWriteAdr (yyt->ASS_GOTO_STMT.LABELS);
}

static void yWriteNodeCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("GOTO_LABELS"); yyWriteAdr (yyt->COMP_GOTO_STMT.GOTO_LABELS);
 yyWriteSelector ("GOTO_EXP"); yyWriteAdr (yyt->COMP_GOTO_STMT.GOTO_EXP);
}

static void yWriteNodeCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IF_EXP"); yyWriteAdr (yyt->COMP_IF_STMT.IF_EXP);
 yyWriteSelector ("IF_LT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_LT_LABEL) yyWriteNl ();
 yyWriteSelector ("IF_EQ_LABEL"); writeint (yyt->COMP_IF_STMT.IF_EQ_LABEL) yyWriteNl ();
 yyWriteSelector ("IF_GT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_GT_LABEL) yyWriteNl ();
}

static void yWriteNodeRETURN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("RETURN_EXP"); yyWriteAdr (yyt->RETURN_STMT.RETURN_EXP);
}

static void yWriteNodePAUSE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PAUSE_CONST"); yyWriteAdr (yyt->PAUSE_STMT.PAUSE_CONST);
}

static void yWriteNodeEXIT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("loopid"); writetIdent (yyt->EXIT_STMT.loopid) yyWriteNl ();
}

static void yWriteNodeCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("loopid"); writetIdent (yyt->CYCLE_STMT.loopid) yyWriteNl ();
}

static void yWriteNodeSTOP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("STOP_CONST"); yyWriteAdr (yyt->STOP_STMT.STOP_CONST);
}

static void yWriteNodeFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FORMAT_PARAMS"); yyWriteAdr (yyt->FORMAT_STMT.FORMAT_PARAMS);
}

static void yWriteNodeINHERIT_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->INHERIT_DSP_STMT.VAR);
 yyWriteSelector ("SHAPE"); yyWriteAdr (yyt->INHERIT_DSP_STMT.SHAPE);
 yyWriteSelector ("flag"); writeint (yyt->INHERIT_DSP_STMT.flag) yyWriteNl ();
 yyWriteSelector ("safety"); writeint (yyt->INHERIT_DSP_STMT.safety) yyWriteNl ();
}

static void yWriteNodeCREATE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->CREATE_DSP_STMT.VAR);
 yyWriteSelector ("SHAPE"); yyWriteAdr (yyt->CREATE_DSP_STMT.SHAPE);
 yyWriteSelector ("flag"); writeint (yyt->CREATE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteNodeFREE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->FREE_DSP_STMT.VAR);
 yyWriteSelector ("flag"); writeint (yyt->FREE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteNodeALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->ALLOCATE_STMT.PARAMS);
 yyWriteSelector ("STATUS"); yyWriteAdr (yyt->ALLOCATE_STMT.STATUS);
}

static void yWriteNodeDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->DEALLOCATE_STMT.PARAMS);
 yyWriteSelector ("STATUS"); yyWriteAdr (yyt->DEALLOCATE_STMT.STATUS);
}

static void yWriteNodeNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("PARAMS"); yyWriteAdr (yyt->NULLIFY_STMT.PARAMS);
}

static void yWriteNodeREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("RED_FUNC"); yyWriteAdr (yyt->REDUCE_STMT.RED_FUNC);
 yyWriteSelector ("RED_PARAMS"); yyWriteAdr (yyt->REDUCE_STMT.RED_PARAMS);
}

static void yWriteNodeMOVE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("TARGET"); yyWriteAdr (yyt->MOVE_STMT.TARGET);
 yyWriteSelector ("SOURCE"); yyWriteAdr (yyt->MOVE_STMT.SOURCE);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->MOVE_STMT.MASK);
}

static void yWriteNodeSCATTER_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("func"); writetIdent (yyt->SCATTER_STMT.func) yyWriteNl ();
 yyWriteSelector ("ARRAY"); yyWriteAdr (yyt->SCATTER_STMT.ARRAY);
 yyWriteSelector ("BASE"); yyWriteAdr (yyt->SCATTER_STMT.BASE);
 yyWriteSelector ("INDEXES"); yyWriteAdr (yyt->SCATTER_STMT.INDEXES);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->SCATTER_STMT.MASK);
}

static void yWriteNodeREALIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ALIGNEE"); yyWriteAdr (yyt->REALIGN_STMT.ALIGNEE);
 yyWriteSelector ("ALIGN_SOURCE"); yyWriteAdr (yyt->REALIGN_STMT.ALIGN_SOURCE);
 yyWriteSelector ("ALIGN_TARGET"); yyWriteAdr (yyt->REALIGN_STMT.ALIGN_TARGET);
 yyWriteSelector ("distribution"); writetDefinitions (yyt->REALIGN_STMT.distribution) yyWriteNl ();
}

static void yWriteNodeREDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DISTRIBUTEE"); yyWriteAdr (yyt->REDISTRIBUTE_STMT.DISTRIBUTEE);
 yyWriteSelector ("DISTRIBUTION"); yyWriteAdr (yyt->REDISTRIBUTE_STMT.DISTRIBUTION);
 yyWriteSelector ("TARGET"); yyWriteAdr (yyt->REDISTRIBUTE_STMT.TARGET);
 yyWriteSelector ("distribution"); writetDefinitions (yyt->REDISTRIBUTE_STMT.distribution) yyWriteNl ();
}

static void yWriteNodeREG_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->REG_SHADOW_GET.SHADOW_VAR);
 yyWriteSelector ("SHADOW_SIZE"); yyWriteAdr (yyt->REG_SHADOW_GET.SHADOW_SIZE);
}

static void yWriteNodeREG_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("op"); writeint (yyt->REG_SHADOW_PUT.op) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->REG_SHADOW_PUT.SHADOW_VAR);
 yyWriteSelector ("SHADOW_SIZE"); yyWriteAdr (yyt->REG_SHADOW_PUT.SHADOW_SIZE);
}

static void yWriteNodeREG_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->REG_SHADOW_SET.SHADOW_VAR);
 yyWriteSelector ("SHADOW_SIZE"); yyWriteAdr (yyt->REG_SHADOW_SET.SHADOW_SIZE);
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->REG_SHADOW_SET.VAL);
}

static void yWriteNodeIND_SHADOW_CREATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_CREATE.id) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_CREATE.SHADOW_VAR);
 yyWriteSelector ("INDEX_VAR"); yyWriteAdr (yyt->IND_SHADOW_CREATE.INDEX_VAR);
 yyWriteSelector ("TMP_INDEX_VAR"); yyWriteAdr (yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR);
 yyWriteSelector ("MASK"); yyWriteAdr (yyt->IND_SHADOW_CREATE.MASK);
}

static void yWriteNodeIND_SHADOW_FREE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_FREE.id) yyWriteNl ();
 yyWriteSelector ("INDEX_VAR"); yyWriteAdr (yyt->IND_SHADOW_FREE.INDEX_VAR);
}

static void yWriteNodeIND_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_GET.id) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_GET.SHADOW_VAR);
}

static void yWriteNodeIND_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_PUT.id) yyWriteNl ();
 yyWriteSelector ("op"); writeint (yyt->IND_SHADOW_PUT.op) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_PUT.SHADOW_VAR);
}

static void yWriteNodeIND_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("id"); writeint (yyt->IND_SHADOW_SET.id) yyWriteNl ();
 yyWriteSelector ("SHADOW_VAR"); yyWriteAdr (yyt->IND_SHADOW_SET.SHADOW_VAR);
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->IND_SHADOW_SET.VAL);
}

static void yWriteNodeBROADCAST_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMS"); yyWriteAdr (yyt->BROADCAST_STMT.ELEMS);
 yyWriteSelector ("OWNER_TOP"); yyWriteAdr (yyt->BROADCAST_STMT.OWNER_TOP);
 yyWriteSelector ("OWNER_SPEC"); yyWriteAdr (yyt->BROADCAST_STMT.OWNER_SPEC);
}

static void yWriteNodeREDUCTION_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("REDFUNC"); yyWriteAdr (yyt->REDUCTION_STMT.REDFUNC);
 yyWriteSelector ("ELEMS"); yyWriteAdr (yyt->REDUCTION_STMT.ELEMS);
 yyWriteSelector ("RED_TOP"); yyWriteAdr (yyt->REDUCTION_STMT.RED_TOP);
 yyWriteSelector ("RED_SPEC"); yyWriteAdr (yyt->REDUCTION_STMT.RED_SPEC);
}

static void yWriteNodeDIRTY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMS"); yyWriteAdr (yyt->DIRTY_STMT.ELEMS);
}

static void yWriteNodeLABEL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); writeint (yyt->LABEL_LIST.Elem) yyWriteNl ();
 yyWriteSelector ("Next"); yyWriteAdr (yyt->LABEL_LIST.Next);
}

static void yWriteNodeOP_DEFINED
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("opname"); writetIdent (yyt->OP_DEFINED.opname) yyWriteNl ();
}

static void yWriteNodeCONST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("C"); yyWriteAdr (yyt->CONST_EXP.C);
}

static void yWriteNodeOP_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("EXP_OP"); yyWriteAdr (yyt->OP_EXP.EXP_OP);
 yyWriteSelector ("OPND1"); yyWriteAdr (yyt->OP_EXP.OPND1);
 yyWriteSelector ("OPND2"); yyWriteAdr (yyt->OP_EXP.OPND2);
}

static void yWriteNodeOP1_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("EXP_OP1"); yyWriteAdr (yyt->OP1_EXP.EXP_OP1);
 yyWriteSelector ("OPND"); yyWriteAdr (yyt->OP1_EXP.OPND);
}

static void yWriteNodeSLICE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("START"); yyWriteAdr (yyt->SLICE_EXP.START);
 yyWriteSelector ("STOP"); yyWriteAdr (yyt->SLICE_EXP.STOP);
 yyWriteSelector ("INC"); yyWriteAdr (yyt->SLICE_EXP.INC);
}

static void yWriteNodeVAR_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("V"); yyWriteAdr (yyt->VAR_EXP.V);
}

static void yWriteNodeFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("FUNC_ID"); yyWriteAdr (yyt->FUNC_CALL_EXP.FUNC_ID);
 yyWriteSelector ("FUNC_PARAMS"); yyWriteAdr (yyt->FUNC_CALL_EXP.FUNC_PARAMS);
}

static void yWriteNodeNAMED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->NAMED_EXP.Name) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->NAMED_EXP.VAL);
}

static void yWriteNodeDO_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->DO_EXP.DO_ID);
 yyWriteSelector ("RANGE"); yyWriteAdr (yyt->DO_EXP.RANGE);
 yyWriteSelector ("BODY"); yyWriteAdr (yyt->DO_EXP.BODY);
}

static void yWriteNodeTYPE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ID"); yyWriteAdr (yyt->TYPE_EXP.ID);
 yyWriteSelector ("ELEMENTS"); yyWriteAdr (yyt->TYPE_EXP.ELEMENTS);
}

static void yWriteNodeARRAY_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("ELEMENTS"); yyWriteAdr (yyt->ARRAY_EXP.ELEMENTS);
}

static void yWriteNodePERM_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PERM_EXP.VAL);
 yyWriteSelector ("perm"); writePermutation (yyt->PERM_EXP.perm) yyWriteNl ();
}

static void yWriteNodeBOUND_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->BOUND_EXP.VAR);
 yyWriteSelector ("dim"); writeint (yyt->BOUND_EXP.dim) yyWriteNl ();
 yyWriteSelector ("kind"); writeint (yyt->BOUND_EXP.kind) yyWriteNl ();
 yyWriteSelector ("local"); writeint (yyt->BOUND_EXP.local) yyWriteNl ();
}

static void yWriteNodeRANK_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("kind"); writeint (yyt->RANK_EXP.kind) yyWriteNl ();
}

static void yWriteNodeBTE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTE_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTE_LIST.Next);
}

static void yWriteNodeUSED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VARNAME"); yyWriteAdr (yyt->USED_VAR.VARNAME);
}

static void yWriteNodeINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_VAR"); yyWriteAdr (yyt->INDEXED_VAR.IND_VAR);
 yyWriteSelector ("IND_EXPS"); yyWriteAdr (yyt->INDEXED_VAR.IND_EXPS);
}

static void yWriteNodeSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("IND_VAR"); yyWriteAdr (yyt->SUBSTRING_VAR.IND_VAR);
 yyWriteSelector ("IND_EXP"); yyWriteAdr (yyt->SUBSTRING_VAR.IND_EXP);
}

static void yWriteNodeSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("SELEC_VAR"); yyWriteAdr (yyt->SELECTED_VAR.SELEC_VAR);
 yyWriteSelector ("SELECTOR"); yyWriteAdr (yyt->SELECTED_VAR.SELECTOR);
}

static void yWriteNodeLOOP_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("LOOP_VARNAME"); yyWriteAdr (yyt->LOOP_VAR.LOOP_VARNAME);
}

static void yWriteNodePERM_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->PERM_VAR.VAL);
 yyWriteSelector ("perm"); writePermutation (yyt->PERM_VAR.perm) yyWriteNl ();
}

static void yWriteNodeADDR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("E"); yyWriteAdr (yyt->ADDR.E);
}

static void yWriteNodeDO_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("DO_ID"); yyWriteAdr (yyt->DO_VAR.DO_ID);
 yyWriteSelector ("RANGE"); yyWriteAdr (yyt->DO_VAR.RANGE);
 yyWriteSelector ("BODY"); yyWriteAdr (yyt->DO_VAR.BODY);
}

static void yWriteNodeREMOTE_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("VAR"); yyWriteAdr (yyt->REMOTE_VAR.VAR);
}

static void yWriteNodeBTV_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTV_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTV_LIST.Next);
}

static void yWriteNodeVAR_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("V"); yyWriteAdr (yyt->VAR_PARAM.V);
 yyWriteSelector ("formal"); writetDefinitions (yyt->VAR_PARAM.formal) yyWriteNl ();
 yyWriteSelector ("intent"); writeint (yyt->VAR_PARAM.intent) yyWriteNl ();
 yyWriteSelector ("layout"); writeint (yyt->VAR_PARAM.layout) yyWriteNl ();
 yyWriteSelector ("pass_by"); writeint (yyt->VAR_PARAM.pass_by) yyWriteNl ();
 yyWriteSelector ("trace"); writeint (yyt->VAR_PARAM.trace) yyWriteNl ();
}

static void yWriteNodeVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("E"); yyWriteAdr (yyt->VALUE_PARAM.E);
}

static void yWriteNodeNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Name"); writetIdent (yyt->NAMED_PARAM.Name) yyWriteNl ();
 yyWriteSelector ("VAL"); yyWriteAdr (yyt->NAMED_PARAM.VAL);
}

static void yWriteNodePROC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("P"); yyWriteAdr (yyt->PROC_PARAM.P);
}

static void yWriteNodeFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("F"); yyWriteAdr (yyt->FUNC_PARAM.F);
}

static void yWriteNodeFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("S"); writetStringRef (yyt->FORMAT_PARAM.S) yyWriteNl ();
}

static void yWriteNodeRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("label"); writeint (yyt->RETURN_PARAM.label) yyWriteNl ();
}

static void yWriteNodeNO_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("type"); writeint (yyt->NO_PARAM.type) yyWriteNl ();
}

static void yWriteNodeBTP_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Elem"); yyWriteAdr (yyt->BTP_LIST.Elem);
 yyWriteSelector ("Next"); yyWriteAdr (yyt->BTP_LIST.Next);
}

static void yWriteNodeBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writeint (yyt->BOOL_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writeint (yyt->INT_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->REAL_CONSTANT.value) yyWriteNl ();
 yyWriteSelector ("kind"); writeint (yyt->REAL_CONSTANT.kind) yyWriteNl ();
}

static void yWriteNodeSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("value"); writetStringRef (yyt->STRING_CONSTANT.value) yyWriteNl ();
}

static void yWriteNodeCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("rvalue"); writetStringRef (yyt->COMPLEX_CONSTANT.rvalue) yyWriteNl ();
 yyWriteSelector ("ivalue"); writetStringRef (yyt->COMPLEX_CONSTANT.ivalue) yyWriteNl ();
}

static void yWriteNodePROC_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->PROC_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->PROC_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeVAR_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Pos"); writeint (yyt->VAR_OBJ.Pos) yyWriteNl ();
 yyWriteSelector ("Ident"); writetIdent (yyt->VAR_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->VAR_OBJ.Object) yyWriteNl ();
 yyWriteSelector ("Reaching"); writetReaching (yyt->VAR_OBJ.Reaching) yyWriteNl ();
}

static void yWriteNodeTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TYPE_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TYPE_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeREC_COMP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->REC_COMP.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->REC_COMP.Object) yyWriteNl ();
}

static void yWriteNodeTOP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TOP_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TOP_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeTEMP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("Ident"); writetIdent (yyt->TEMP_OBJ.Ident) yyWriteNl ();
 yyWriteSelector ("Object"); writetDefinitions (yyt->TEMP_OBJ.Object) yyWriteNl ();
}

static void yWriteNodeOVERLAP_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("left_size"); writeint (yyt->OVERLAP_SPEC.left_size) yyWriteNl ();
 yyWriteSelector ("right_size"); writeint (yyt->OVERLAP_SPEC.right_size) yyWriteNl ();
 yyWriteSelector ("left_update"); writeint (yyt->OVERLAP_SPEC.left_update) yyWriteNl ();
 yyWriteSelector ("right_update"); writeint (yyt->OVERLAP_SPEC.right_update) yyWriteNl ();
}

static void yWriteNodeINDEP_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("user_independent"); writebool (yyt->INDEP_INFO.user_independent) yyWriteNl ();
 yyWriteSelector ("selection"); writeint (yyt->INDEP_INFO.selection) yyWriteNl ();
 yyWriteSelector ("red_vars"); writeInfoTree (yyt->INDEP_INFO.red_vars) yyWriteNl ();
 yyWriteSelector ("new_vars"); writeInfoTree (yyt->INDEP_INFO.new_vars) yyWriteNl ();
}

static void yWriteNodeVECTOR_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("is_independent"); writebool (yyt->VECTOR_INFO.is_independent) yyWriteNl ();
 yyWriteSelector ("selection"); writeint (yyt->VECTOR_INFO.selection) yyWriteNl ();
 yyWriteSelector ("loop_cnt"); writeint (yyt->VECTOR_INFO.loop_cnt) yyWriteNl ();
 yyWriteSelector ("independent_vars"); writeInfoTree (yyt->VECTOR_INFO.independent_vars) yyWriteNl ();
}

static void yWriteNodeCOMM_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("home_var"); writeInfoTree (yyt->COMM_INFO.home_var) yyWriteNl ();
 yyWriteSelector ("is_local"); writebool (yyt->COMM_INFO.is_local) yyWriteNl ();
}

static void yWriteNodeON_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("on_id"); writetObject (yyt->ON_INFO.on_id) yyWriteNl ();
 yyWriteSelector ("on_dim"); writeint (yyt->ON_INFO.on_dim) yyWriteNl ();
 yyWriteSelector ("base"); writeint (yyt->ON_INFO.base) yyWriteNl ();
 yyWriteSelector ("stride"); writeint (yyt->ON_INFO.stride) yyWriteNl ();
}

static void yWriteNodePARALLEL_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("reduction_vars"); writeInfoTree (yyt->PARALLEL_INFO.reduction_vars) yyWriteNl ();
 yyWriteSelector ("home_var"); writeInfoTree (yyt->PARALLEL_INFO.home_var) yyWriteNl ();
 yyWriteSelector ("new_vars"); writeInfoTree (yyt->PARALLEL_INFO.new_vars) yyWriteNl ();
 yyWriteSelector ("resident_vars"); writeInfoTree (yyt->PARALLEL_INFO.resident_vars) yyWriteNl ();
}

static void yWriteNodeREACHING_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyWriteSelector ("var_allocate"); writeInfoTree (yyt->REACHING_INFO.var_allocate) yyWriteNl ();
 yyWriteSelector ("temp_allocate"); writeInfoTree (yyt->REACHING_INFO.temp_allocate) yyWriteNl ();
 yyWriteSelector ("var_distribution"); writetDefinitions (yyt->REACHING_INFO.var_distribution) yyWriteNl ();
 yyWriteSelector ("temp_distribution"); writetDefinitions (yyt->REACHING_INFO.temp_distribution) yyWriteNl ();
}

void WriteTreeNode
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyt == NoTree) { (void) fputs ("NoTree\n", yyf); return; }

 switch (yyt->Kind) {
case kCOMP_UNIT: (void) fputs (Tree_NodeName [kCOMP_UNIT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_UNIT (yyt); break;
case kUNIT_NODE_LIST: (void) fputs (Tree_NodeName [kUNIT_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kUNIT_EMPTY: (void) fputs (Tree_NodeName [kUNIT_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kUNIT_LIST: (void) fputs (Tree_NodeName [kUNIT_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUNIT_LIST (yyt); break;
case kUNIT_NODE: (void) fputs (Tree_NodeName [kUNIT_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUNIT_NODE (yyt); break;
case kMODULE_DECL: (void) fputs (Tree_NodeName [kMODULE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMODULE_DECL (yyt); break;
case kPROGRAM_DECL: (void) fputs (Tree_NodeName [kPROGRAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROGRAM_DECL (yyt); break;
case kPROC_DECL: (void) fputs (Tree_NodeName [kPROC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_DECL (yyt); break;
case kFUNC_DECL: (void) fputs (Tree_NodeName [kFUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_DECL (yyt); break;
case kMODULE_PROC_DECL: (void) fputs (Tree_NodeName [kMODULE_PROC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMODULE_PROC_DECL (yyt); break;
case kBLOCK_DATA_DECL: (void) fputs (Tree_NodeName [kBLOCK_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBLOCK_DATA_DECL (yyt); break;
case kINTERFACE: (void) fputs (Tree_NodeName [kINTERFACE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTERFACE (yyt); break;
case kBODY_NODE: (void) fputs (Tree_NodeName [kBODY_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBODY_NODE (yyt); break;
case kTYPE_NODE: (void) fputs (Tree_NodeName [kTYPE_NODE], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_TYPE: (void) fputs (Tree_NodeName [kDUMMY_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kALIGN_TYPE: (void) fputs (Tree_NodeName [kALIGN_TYPE], yyf); (void) fputc ('\n', yyf);
 break;
case kINTEGER_TYPE: (void) fputs (Tree_NodeName [kINTEGER_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTEGER_TYPE (yyt); break;
case kREAL_TYPE: (void) fputs (Tree_NodeName [kREAL_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREAL_TYPE (yyt); break;
case kBOOLEAN_TYPE: (void) fputs (Tree_NodeName [kBOOLEAN_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOOLEAN_TYPE (yyt); break;
case kCOMPLEX_TYPE: (void) fputs (Tree_NodeName [kCOMPLEX_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMPLEX_TYPE (yyt); break;
case kSTRING_TYPE: (void) fputs (Tree_NodeName [kSTRING_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTRING_TYPE (yyt); break;
case kTYPE_ID: (void) fputs (Tree_NodeName [kTYPE_ID], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_ID (yyt); break;
case kARRAY_TYPE: (void) fputs (Tree_NodeName [kARRAY_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY_TYPE (yyt); break;
case kRECORD_TYPE: (void) fputs (Tree_NodeName [kRECORD_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRECORD_TYPE (yyt); break;
case kPOINTER_TYPE: (void) fputs (Tree_NodeName [kPOINTER_TYPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOINTER_TYPE (yyt); break;
case kSHAPE_SPEC: (void) fputs (Tree_NodeName [kSHAPE_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSHAPE_SPEC (yyt); break;
case kEXPLICIT_SHAPE: (void) fputs (Tree_NodeName [kEXPLICIT_SHAPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXPLICIT_SHAPE (yyt); break;
case kASSUMED_SHAPE: (void) fputs (Tree_NodeName [kASSUMED_SHAPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSUMED_SHAPE (yyt); break;
case kDEFERRED_SHAPE: (void) fputs (Tree_NodeName [kDEFERRED_SHAPE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEFERRED_SHAPE (yyt); break;
case kASSUMED_SIZE: (void) fputs (Tree_NodeName [kASSUMED_SIZE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSUMED_SIZE (yyt); break;
case kSHAPE_SPEC_LIST: (void) fputs (Tree_NodeName [kSHAPE_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSHAPE_EMPTY: (void) fputs (Tree_NodeName [kSHAPE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSHAPE_LIST: (void) fputs (Tree_NodeName [kSHAPE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSHAPE_LIST (yyt); break;
case kDECL_NODE: (void) fputs (Tree_NodeName [kDECL_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDECL_NODE (yyt); break;
case kTYPE_DECL: (void) fputs (Tree_NodeName [kTYPE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_DECL (yyt); break;
case kNAME_DECL: (void) fputs (Tree_NodeName [kNAME_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAME_DECL (yyt); break;
case kRENAME_DECL: (void) fputs (Tree_NodeName [kRENAME_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRENAME_DECL (yyt); break;
case kENTITY_DECL: (void) fputs (Tree_NodeName [kENTITY_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeENTITY_DECL (yyt); break;
case kVAR_DECL: (void) fputs (Tree_NodeName [kVAR_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_DECL (yyt); break;
case kCOMMON_DECL: (void) fputs (Tree_NodeName [kCOMMON_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMMON_DECL (yyt); break;
case kNAMELIST_DECL: (void) fputs (Tree_NodeName [kNAMELIST_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMELIST_DECL (yyt); break;
case kTEMPLATE_DECL: (void) fputs (Tree_NodeName [kTEMPLATE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTEMPLATE_DECL (yyt); break;
case kRAGGED_DECL: (void) fputs (Tree_NodeName [kRAGGED_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRAGGED_DECL (yyt); break;
case kPROCESSORS_DECL: (void) fputs (Tree_NodeName [kPROCESSORS_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSORS_DECL (yyt); break;
case kSUB_PROCS_DECL: (void) fputs (Tree_NodeName [kSUB_PROCS_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSUB_PROCS_DECL (yyt); break;
case kINHERIT_DECL: (void) fputs (Tree_NodeName [kINHERIT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINHERIT_DECL (yyt); break;
case kRANGE_DECL: (void) fputs (Tree_NodeName [kRANGE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRANGE_DECL (yyt); break;
case kSTMT_FUNC_DECL: (void) fputs (Tree_NodeName [kSTMT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTMT_FUNC_DECL (yyt); break;
case kINTERFACE_DECL: (void) fputs (Tree_NodeName [kINTERFACE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTERFACE_DECL (yyt); break;
case kVAR_PARAM_DECL: (void) fputs (Tree_NodeName [kVAR_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_PARAM_DECL (yyt); break;
case kRET_PARAM_DECL: (void) fputs (Tree_NodeName [kRET_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRET_PARAM_DECL (yyt); break;
case kIMPLICIT_DECL: (void) fputs (Tree_NodeName [kIMPLICIT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIMPLICIT_DECL (yyt); break;
case kUSE_DECL: (void) fputs (Tree_NodeName [kUSE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSE_DECL (yyt); break;
case kONLY_USE_DECL: (void) fputs (Tree_NodeName [kONLY_USE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeONLY_USE_DECL (yyt); break;
case kEQV_DECL: (void) fputs (Tree_NodeName [kEQV_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEQV_DECL (yyt); break;
case kDATA_DECL: (void) fputs (Tree_NodeName [kDATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDATA_DECL (yyt); break;
case kFORMAT_DECL: (void) fputs (Tree_NodeName [kFORMAT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_DECL (yyt); break;
case kDIMENSION_DECL: (void) fputs (Tree_NodeName [kDIMENSION_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIMENSION_DECL (yyt); break;
case kINIT_DATA_DECL: (void) fputs (Tree_NodeName [kINIT_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINIT_DATA_DECL (yyt); break;
case kTYPESPEC_DECL: (void) fputs (Tree_NodeName [kTYPESPEC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPESPEC_DECL (yyt); break;
case kALLOCATABLE_DECL: (void) fputs (Tree_NodeName [kALLOCATABLE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALLOCATABLE_DECL (yyt); break;
case kEXTERNAL_DECL: (void) fputs (Tree_NodeName [kEXTERNAL_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXTERNAL_DECL (yyt); break;
case kINTENT_DECL: (void) fputs (Tree_NodeName [kINTENT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTENT_DECL (yyt); break;
case kINTRINSIC_DECL: (void) fputs (Tree_NodeName [kINTRINSIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINTRINSIC_DECL (yyt); break;
case kOPTIONAL_DECL: (void) fputs (Tree_NodeName [kOPTIONAL_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOPTIONAL_DECL (yyt); break;
case kPOINTER_DECL: (void) fputs (Tree_NodeName [kPOINTER_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePOINTER_DECL (yyt); break;
case kSAVE_DECL: (void) fputs (Tree_NodeName [kSAVE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSAVE_DECL (yyt); break;
case kTARGET_DECL: (void) fputs (Tree_NodeName [kTARGET_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTARGET_DECL (yyt); break;
case kPARAMETER_DECL: (void) fputs (Tree_NodeName [kPARAMETER_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePARAMETER_DECL (yyt); break;
case kPUBLIC_DECL: (void) fputs (Tree_NodeName [kPUBLIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePUBLIC_DECL (yyt); break;
case kPRIVATE_DECL: (void) fputs (Tree_NodeName [kPRIVATE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePRIVATE_DECL (yyt); break;
case kSEQUENCE_DECL: (void) fputs (Tree_NodeName [kSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSEQUENCE_DECL (yyt); break;
case kDISTRIBUTE_DECL: (void) fputs (Tree_NodeName [kDISTRIBUTE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDISTRIBUTE_DECL (yyt); break;
case kALIGN_DECL: (void) fputs (Tree_NodeName [kALIGN_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALIGN_DECL (yyt); break;
case kMAP_DECL: (void) fputs (Tree_NodeName [kMAP_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMAP_DECL (yyt); break;
case kOVERLAP_DECL: (void) fputs (Tree_NodeName [kOVERLAP_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOVERLAP_DECL (yyt); break;
case kSHARED_DECL: (void) fputs (Tree_NodeName [kSHARED_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSHARED_DECL (yyt); break;
case kDYNAMIC_DECL: (void) fputs (Tree_NodeName [kDYNAMIC_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDYNAMIC_DECL (yyt); break;
case kTRACE_DECL: (void) fputs (Tree_NodeName [kTRACE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTRACE_DECL (yyt); break;
case kTREE_DECL: (void) fputs (Tree_NodeName [kTREE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTREE_DECL (yyt); break;
case kSELECT_DECL: (void) fputs (Tree_NodeName [kSELECT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECT_DECL (yyt); break;
case kHPF_SEQUENCE_DECL: (void) fputs (Tree_NodeName [kHPF_SEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeHPF_SEQUENCE_DECL (yyt); break;
case kNOSEQUENCE_DECL: (void) fputs (Tree_NodeName [kNOSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNOSEQUENCE_DECL (yyt); break;
case kLAYOUT_DECL: (void) fputs (Tree_NodeName [kLAYOUT_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLAYOUT_DECL (yyt); break;
case kPASS_BY_DECL: (void) fputs (Tree_NodeName [kPASS_BY_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodePASS_BY_DECL (yyt); break;
case kMAP_TO_DECL: (void) fputs (Tree_NodeName [kMAP_TO_DECL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMAP_TO_DECL (yyt); break;
case kDECL_NODE_LIST: (void) fputs (Tree_NodeName [kDECL_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kDECL_EMPTY: (void) fputs (Tree_NodeName [kDECL_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kDECL_LIST: (void) fputs (Tree_NodeName [kDECL_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDECL_LIST (yyt); break;
case kRANGE_SPEC_LIST: (void) fputs (Tree_NodeName [kRANGE_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kRANGE_EMPTY: (void) fputs (Tree_NodeName [kRANGE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kRANGE_LIST: (void) fputs (Tree_NodeName [kRANGE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRANGE_LIST (yyt); break;
case kSELECT_SPEC_LIST: (void) fputs (Tree_NodeName [kSELECT_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECT_EMPTY: (void) fputs (Tree_NodeName [kSELECT_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECT_LIST: (void) fputs (Tree_NodeName [kSELECT_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECT_LIST (yyt); break;
case kSELECT_SPEC: (void) fputs (Tree_NodeName [kSELECT_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECT_SPEC (yyt); break;
case kDISTRIBUTION_SPEC: (void) fputs (Tree_NodeName [kDISTRIBUTION_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDISTRIBUTION_SPEC (yyt); break;
case kANY_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeANY_DISTRIBUTION (yyt); break;
case kDEFAULT_DISTRIBUTION: (void) fputs (Tree_NodeName [kDEFAULT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEFAULT_DISTRIBUTION (yyt); break;
case kREPL_DISTRIBUTION: (void) fputs (Tree_NodeName [kREPL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREPL_DISTRIBUTION (yyt); break;
case kNODE_DISTRIBUTION: (void) fputs (Tree_NodeName [kNODE_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNODE_DISTRIBUTION (yyt); break;
case kDIST_FORMAT_LIST: (void) fputs (Tree_NodeName [kDIST_FORMAT_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_EMPTY: (void) fputs (Tree_NodeName [kDIST_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kDIST_LIST: (void) fputs (Tree_NodeName [kDIST_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIST_LIST (yyt); break;
case kDISTRIBUTION_FORMAT: (void) fputs (Tree_NodeName [kDISTRIBUTION_FORMAT], yyf); (void) fputc ('\n', yyf);
 break;
case kBLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kBLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBLOCK_DISTRIBUTION (yyt); break;
case kCYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kCYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCYCLIC_DISTRIBUTION (yyt); break;
case kGEN_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kGEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeGEN_BLOCK_DISTRIBUTION (yyt); break;
case kINDIRECT_DISTRIBUTION: (void) fputs (Tree_NodeName [kINDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDIRECT_DISTRIBUTION (yyt); break;
case kARBITRARY_DISTRIBUTION: (void) fputs (Tree_NodeName [kARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARBITRARY_DISTRIBUTION (yyt); break;
case kSERIAL_DISTRIBUTION: (void) fputs (Tree_NodeName [kSERIAL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_CYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_CYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_GEN_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_GEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_INDIRECT_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_INDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_ARBITRARY_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_ARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_DIM_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_DIM_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 break;
case kPROCESSOR_SPEC: (void) fputs (Tree_NodeName [kPROCESSOR_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kANY_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kANY_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
 break;
case kDEFAULT_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kDEFAULT_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
 break;
case kPROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kPROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSOR_ARRAY (yyt); break;
case kPROCESSOR_SUBSET: (void) fputs (Tree_NodeName [kPROCESSOR_SUBSET], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROCESSOR_SUBSET (yyt); break;
case kALIGN_SPEC: (void) fputs (Tree_NodeName [kALIGN_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALIGN_SPEC (yyt); break;
case kGENERIC_SPEC: (void) fputs (Tree_NodeName [kGENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kNO_GENERIC_SPEC: (void) fputs (Tree_NodeName [kNO_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kID_GENERIC_SPEC: (void) fputs (Tree_NodeName [kID_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeID_GENERIC_SPEC (yyt); break;
case kOP_GENERIC_SPEC: (void) fputs (Tree_NodeName [kOP_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_GENERIC_SPEC (yyt); break;
case kASSIGN_GENERIC_SPEC: (void) fputs (Tree_NodeName [kASSIGN_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_NODE_LIST: (void) fputs (Tree_NodeName [kACF_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_EMPTY: (void) fputs (Tree_NodeName [kACF_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_LIST: (void) fputs (Tree_NodeName [kACF_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_LIST (yyt); break;
case kACF_NODE: (void) fputs (Tree_NodeName [kACF_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_NODE (yyt); break;
case kACF_DUMMY: (void) fputs (Tree_NodeName [kACF_DUMMY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DUMMY (yyt); break;
case kACF_BASIC: (void) fputs (Tree_NodeName [kACF_BASIC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_BASIC (yyt); break;
case kACF_IF: (void) fputs (Tree_NodeName [kACF_IF], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_IF (yyt); break;
case kACF_WHERE: (void) fputs (Tree_NodeName [kACF_WHERE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WHERE (yyt); break;
case kACF_CASE: (void) fputs (Tree_NodeName [kACF_CASE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_CASE (yyt); break;
case kACF_WHILE: (void) fputs (Tree_NodeName [kACF_WHILE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_WHILE (yyt); break;
case kACF_REPEAT: (void) fputs (Tree_NodeName [kACF_REPEAT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_REPEAT (yyt); break;
case kACF_LOOP: (void) fputs (Tree_NodeName [kACF_LOOP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_LOOP (yyt); break;
case kACF_DO: (void) fputs (Tree_NodeName [kACF_DO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_DO (yyt); break;
case kACF_FORALL: (void) fputs (Tree_NodeName [kACF_FORALL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_FORALL (yyt); break;
case kACF_FLOW_GRAPH: (void) fputs (Tree_NodeName [kACF_FLOW_GRAPH], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_FLOW_GRAPH (yyt); break;
case kACF_ENTRY: (void) fputs (Tree_NodeName [kACF_ENTRY], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ENTRY (yyt); break;
case kACF_HOME: (void) fputs (Tree_NodeName [kACF_HOME], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_HOME (yyt); break;
case kACF_RESIDENT: (void) fputs (Tree_NodeName [kACF_RESIDENT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_RESIDENT (yyt); break;
case kACF_NEW: (void) fputs (Tree_NodeName [kACF_NEW], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_NEW (yyt); break;
case kACF_REDUCTION: (void) fputs (Tree_NodeName [kACF_REDUCTION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_REDUCTION (yyt); break;
case kACF_TASK_REGION: (void) fputs (Tree_NodeName [kACF_TASK_REGION], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_TASK_REGION (yyt); break;
case kACF_PARALLEL: (void) fputs (Tree_NodeName [kACF_PARALLEL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_PARALLEL (yyt); break;
case kACF_CRITICAL: (void) fputs (Tree_NodeName [kACF_CRITICAL], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_CRITICAL (yyt); break;
case kACF_ON: (void) fputs (Tree_NodeName [kACF_ON], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_ON (yyt); break;
case kACF_RM_READ: (void) fputs (Tree_NodeName [kACF_RM_READ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_RM_READ (yyt); break;
case kACF_RM_WRITE: (void) fputs (Tree_NodeName [kACF_RM_WRITE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_RM_WRITE (yyt); break;
case kACF_MOVE: (void) fputs (Tree_NodeName [kACF_MOVE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_MOVE (yyt); break;
case kACF_BARRIER: (void) fputs (Tree_NodeName [kACF_BARRIER], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_BARRIER (yyt); break;
case kACF_UPDATE: (void) fputs (Tree_NodeName [kACF_UPDATE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeACF_UPDATE (yyt); break;
case kACF_FLOW_KIND: (void) fputs (Tree_NodeName [kACF_FLOW_KIND], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_COMPLEX_FLOW: (void) fputs (Tree_NodeName [kACF_COMPLEX_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_INTERVAL_FLOW: (void) fputs (Tree_NodeName [kACF_INTERVAL_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kACF_SIMPLE_FLOW: (void) fputs (Tree_NodeName [kACF_SIMPLE_FLOW], yyf); (void) fputc ('\n', yyf);
 break;
case kON_CLAUSE: (void) fputs (Tree_NodeName [kON_CLAUSE], yyf); (void) fputc ('\n', yyf);
 break;
case kON_HOST_CLAUSE: (void) fputs (Tree_NodeName [kON_HOST_CLAUSE], yyf); (void) fputc ('\n', yyf);
 break;
case kON_ALL_CLAUSE: (void) fputs (Tree_NodeName [kON_ALL_CLAUSE], yyf); (void) fputc ('\n', yyf);
 break;
case kON_VAR_CLAUSE: (void) fputs (Tree_NodeName [kON_VAR_CLAUSE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_VAR_CLAUSE (yyt); break;
case kON_PROC_CLAUSE: (void) fputs (Tree_NodeName [kON_PROC_CLAUSE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_PROC_CLAUSE (yyt); break;
case kON_TOPOLOGY: (void) fputs (Tree_NodeName [kON_TOPOLOGY], yyf); (void) fputc ('\n', yyf);
 break;
case kON_ALL: (void) fputs (Tree_NodeName [kON_ALL], yyf); (void) fputc ('\n', yyf);
 break;
case kON_HOST: (void) fputs (Tree_NodeName [kON_HOST], yyf); (void) fputc ('\n', yyf);
 break;
case kON_PROCS: (void) fputs (Tree_NodeName [kON_PROCS], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_PROCS (yyt); break;
case kON_VAR: (void) fputs (Tree_NodeName [kON_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_VAR (yyt); break;
case kON_SPEC_LIST: (void) fputs (Tree_NodeName [kON_SPEC_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kON_EMPTY: (void) fputs (Tree_NodeName [kON_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kON_LIST: (void) fputs (Tree_NodeName [kON_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_LIST (yyt); break;
case kON_SPEC: (void) fputs (Tree_NodeName [kON_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_SPEC (yyt); break;
case kSELECTED_ACF_NODE_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_EMPTY: (void) fputs (Tree_NodeName [kSELECTED_ACF_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kSELECTED_ACF_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_ACF_LIST (yyt); break;
case kSELECTED_ACF_NODE: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_ACF_NODE (yyt); break;
case kBT_STMT: (void) fputs (Tree_NodeName [kBT_STMT], yyf); (void) fputc ('\n', yyf);
 break;
case kASSIGN_STMT: (void) fputs (Tree_NodeName [kASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASSIGN_STMT (yyt); break;
case kPTR_ASSIGN_STMT: (void) fputs (Tree_NodeName [kPTR_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodePTR_ASSIGN_STMT (yyt); break;
case kLABEL_ASSIGN_STMT: (void) fputs (Tree_NodeName [kLABEL_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLABEL_ASSIGN_STMT (yyt); break;
case kCALL_STMT: (void) fputs (Tree_NodeName [kCALL_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCALL_STMT (yyt); break;
case kIO_STMT: (void) fputs (Tree_NodeName [kIO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIO_STMT (yyt); break;
case kGOTO_STMT: (void) fputs (Tree_NodeName [kGOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeGOTO_STMT (yyt); break;
case kASS_GOTO_STMT: (void) fputs (Tree_NodeName [kASS_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeASS_GOTO_STMT (yyt); break;
case kCOMP_GOTO_STMT: (void) fputs (Tree_NodeName [kCOMP_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_GOTO_STMT (yyt); break;
case kCOMP_IF_STMT: (void) fputs (Tree_NodeName [kCOMP_IF_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMP_IF_STMT (yyt); break;
case kRETURN_STMT: (void) fputs (Tree_NodeName [kRETURN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRETURN_STMT (yyt); break;
case kPAUSE_STMT: (void) fputs (Tree_NodeName [kPAUSE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodePAUSE_STMT (yyt); break;
case kEXIT_STMT: (void) fputs (Tree_NodeName [kEXIT_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeEXIT_STMT (yyt); break;
case kCYCLE_STMT: (void) fputs (Tree_NodeName [kCYCLE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCYCLE_STMT (yyt); break;
case kSTOP_STMT: (void) fputs (Tree_NodeName [kSTOP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTOP_STMT (yyt); break;
case kFORMAT_STMT: (void) fputs (Tree_NodeName [kFORMAT_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_STMT (yyt); break;
case kINHERIT_DSP_STMT: (void) fputs (Tree_NodeName [kINHERIT_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINHERIT_DSP_STMT (yyt); break;
case kCREATE_DSP_STMT: (void) fputs (Tree_NodeName [kCREATE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCREATE_DSP_STMT (yyt); break;
case kFREE_DSP_STMT: (void) fputs (Tree_NodeName [kFREE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFREE_DSP_STMT (yyt); break;
case kALLOCATE_STMT: (void) fputs (Tree_NodeName [kALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeALLOCATE_STMT (yyt); break;
case kDEALLOCATE_STMT: (void) fputs (Tree_NodeName [kDEALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDEALLOCATE_STMT (yyt); break;
case kNULLIFY_STMT: (void) fputs (Tree_NodeName [kNULLIFY_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNULLIFY_STMT (yyt); break;
case kREDUCE_STMT: (void) fputs (Tree_NodeName [kREDUCE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDUCE_STMT (yyt); break;
case kMOVE_STMT: (void) fputs (Tree_NodeName [kMOVE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeMOVE_STMT (yyt); break;
case kSCATTER_STMT: (void) fputs (Tree_NodeName [kSCATTER_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSCATTER_STMT (yyt); break;
case kREALIGN_STMT: (void) fputs (Tree_NodeName [kREALIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREALIGN_STMT (yyt); break;
case kREDISTRIBUTE_STMT: (void) fputs (Tree_NodeName [kREDISTRIBUTE_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDISTRIBUTE_STMT (yyt); break;
case kREG_SHADOW_GET: (void) fputs (Tree_NodeName [kREG_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREG_SHADOW_GET (yyt); break;
case kREG_SHADOW_PUT: (void) fputs (Tree_NodeName [kREG_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREG_SHADOW_PUT (yyt); break;
case kREG_SHADOW_SET: (void) fputs (Tree_NodeName [kREG_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREG_SHADOW_SET (yyt); break;
case kIND_SHADOW_CREATE: (void) fputs (Tree_NodeName [kIND_SHADOW_CREATE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_CREATE (yyt); break;
case kIND_SHADOW_FREE: (void) fputs (Tree_NodeName [kIND_SHADOW_FREE], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_FREE (yyt); break;
case kIND_SHADOW_GET: (void) fputs (Tree_NodeName [kIND_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_GET (yyt); break;
case kIND_SHADOW_PUT: (void) fputs (Tree_NodeName [kIND_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_PUT (yyt); break;
case kIND_SHADOW_SET: (void) fputs (Tree_NodeName [kIND_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yWriteNodeIND_SHADOW_SET (yyt); break;
case kBROADCAST_STMT: (void) fputs (Tree_NodeName [kBROADCAST_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBROADCAST_STMT (yyt); break;
case kREDUCTION_STMT: (void) fputs (Tree_NodeName [kREDUCTION_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREDUCTION_STMT (yyt); break;
case kDIRTY_STMT: (void) fputs (Tree_NodeName [kDIRTY_STMT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDIRTY_STMT (yyt); break;
case kLABEL_USE_LIST: (void) fputs (Tree_NodeName [kLABEL_USE_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kLABEL_EMPTY: (void) fputs (Tree_NodeName [kLABEL_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kLABEL_LIST: (void) fputs (Tree_NodeName [kLABEL_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLABEL_LIST (yyt); break;
case kOP: (void) fputs (Tree_NodeName [kOP], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EQ: (void) fputs (Tree_NodeName [kOP_EQ], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_NE: (void) fputs (Tree_NodeName [kOP_NE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LT: (void) fputs (Tree_NodeName [kOP_LT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_GT: (void) fputs (Tree_NodeName [kOP_GT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_GE: (void) fputs (Tree_NodeName [kOP_GE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_LE: (void) fputs (Tree_NodeName [kOP_LE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_PLUS: (void) fputs (Tree_NodeName [kOP_PLUS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_MINUS: (void) fputs (Tree_NodeName [kOP_MINUS], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_XOR: (void) fputs (Tree_NodeName [kOP_XOR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_OR: (void) fputs (Tree_NodeName [kOP_OR], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_CONCAT: (void) fputs (Tree_NodeName [kOP_CONCAT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_TIMES: (void) fputs (Tree_NodeName [kOP_TIMES], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DIVIDE: (void) fputs (Tree_NodeName [kOP_DIVIDE], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_AND: (void) fputs (Tree_NodeName [kOP_AND], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EQV: (void) fputs (Tree_NodeName [kOP_EQV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_NEQV: (void) fputs (Tree_NodeName [kOP_NEQV], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_EXPO: (void) fputs (Tree_NodeName [kOP_EXPO], yyf); (void) fputc ('\n', yyf);
 break;
case kOP_DEFINED: (void) fputs (Tree_NodeName [kOP_DEFINED], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_DEFINED (yyt); break;
case kOP_ASSIGN: (void) fputs (Tree_NodeName [kOP_ASSIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_NOT: (void) fputs (Tree_NodeName [kOP1_NOT], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_SIGN: (void) fputs (Tree_NodeName [kOP1_SIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kOP1_PSIGN: (void) fputs (Tree_NodeName [kOP1_PSIGN], yyf); (void) fputc ('\n', yyf);
 break;
case kBT_EXP: (void) fputs (Tree_NodeName [kBT_EXP], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_EXP: (void) fputs (Tree_NodeName [kDUMMY_EXP], yyf); (void) fputc ('\n', yyf);
 break;
case kCONST_EXP: (void) fputs (Tree_NodeName [kCONST_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCONST_EXP (yyt); break;
case kOP_EXP: (void) fputs (Tree_NodeName [kOP_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP_EXP (yyt); break;
case kOP1_EXP: (void) fputs (Tree_NodeName [kOP1_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOP1_EXP (yyt); break;
case kSLICE_EXP: (void) fputs (Tree_NodeName [kSLICE_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSLICE_EXP (yyt); break;
case kVAR_EXP: (void) fputs (Tree_NodeName [kVAR_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_EXP (yyt); break;
case kFUNC_CALL_EXP: (void) fputs (Tree_NodeName [kFUNC_CALL_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_CALL_EXP (yyt); break;
case kNAMED_EXP: (void) fputs (Tree_NodeName [kNAMED_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMED_EXP (yyt); break;
case kDO_EXP: (void) fputs (Tree_NodeName [kDO_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDO_EXP (yyt); break;
case kTYPE_EXP: (void) fputs (Tree_NodeName [kTYPE_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_EXP (yyt); break;
case kARRAY_EXP: (void) fputs (Tree_NodeName [kARRAY_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeARRAY_EXP (yyt); break;
case kPERM_EXP: (void) fputs (Tree_NodeName [kPERM_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodePERM_EXP (yyt); break;
case kBOUND_EXP: (void) fputs (Tree_NodeName [kBOUND_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOUND_EXP (yyt); break;
case kRANK_EXP: (void) fputs (Tree_NodeName [kRANK_EXP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRANK_EXP (yyt); break;
case kBT_EXP_LIST: (void) fputs (Tree_NodeName [kBT_EXP_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTE_EMPTY: (void) fputs (Tree_NodeName [kBTE_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTE_LIST: (void) fputs (Tree_NodeName [kBTE_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTE_LIST (yyt); break;
case kBT_VAR: (void) fputs (Tree_NodeName [kBT_VAR], yyf); (void) fputc ('\n', yyf);
 break;
case kDUMMY_VAR: (void) fputs (Tree_NodeName [kDUMMY_VAR], yyf); (void) fputc ('\n', yyf);
 break;
case kUSED_VAR: (void) fputs (Tree_NodeName [kUSED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeUSED_VAR (yyt); break;
case kINDEXED_VAR: (void) fputs (Tree_NodeName [kINDEXED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEXED_VAR (yyt); break;
case kSUBSTRING_VAR: (void) fputs (Tree_NodeName [kSUBSTRING_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSUBSTRING_VAR (yyt); break;
case kSELECTED_VAR: (void) fputs (Tree_NodeName [kSELECTED_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSELECTED_VAR (yyt); break;
case kLOOP_VAR: (void) fputs (Tree_NodeName [kLOOP_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeLOOP_VAR (yyt); break;
case kPERM_VAR: (void) fputs (Tree_NodeName [kPERM_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodePERM_VAR (yyt); break;
case kADDR: (void) fputs (Tree_NodeName [kADDR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeADDR (yyt); break;
case kDO_VAR: (void) fputs (Tree_NodeName [kDO_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeDO_VAR (yyt); break;
case kREMOTE_VAR: (void) fputs (Tree_NodeName [kREMOTE_VAR], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREMOTE_VAR (yyt); break;
case kBT_VAR_LIST: (void) fputs (Tree_NodeName [kBT_VAR_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTV_EMPTY: (void) fputs (Tree_NodeName [kBTV_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTV_LIST: (void) fputs (Tree_NodeName [kBTV_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTV_LIST (yyt); break;
case kBT_PARAM: (void) fputs (Tree_NodeName [kBT_PARAM], yyf); (void) fputc ('\n', yyf);
 break;
case kVAR_PARAM: (void) fputs (Tree_NodeName [kVAR_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_PARAM (yyt); break;
case kVALUE_PARAM: (void) fputs (Tree_NodeName [kVALUE_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVALUE_PARAM (yyt); break;
case kNAMED_PARAM: (void) fputs (Tree_NodeName [kNAMED_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNAMED_PARAM (yyt); break;
case kPROC_PARAM: (void) fputs (Tree_NodeName [kPROC_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_PARAM (yyt); break;
case kFUNC_PARAM: (void) fputs (Tree_NodeName [kFUNC_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFUNC_PARAM (yyt); break;
case kFORMAT_PARAM: (void) fputs (Tree_NodeName [kFORMAT_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeFORMAT_PARAM (yyt); break;
case kRETURN_PARAM: (void) fputs (Tree_NodeName [kRETURN_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeRETURN_PARAM (yyt); break;
case kNO_PARAM: (void) fputs (Tree_NodeName [kNO_PARAM], yyf); (void) fputc ('\n', yyf);
 yWriteNodeNO_PARAM (yyt); break;
case kBT_PARAM_LIST: (void) fputs (Tree_NodeName [kBT_PARAM_LIST], yyf); (void) fputc ('\n', yyf);
 break;
case kBTP_EMPTY: (void) fputs (Tree_NodeName [kBTP_EMPTY], yyf); (void) fputc ('\n', yyf);
 break;
case kBTP_LIST: (void) fputs (Tree_NodeName [kBTP_LIST], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBTP_LIST (yyt); break;
case kCONSTANT: (void) fputs (Tree_NodeName [kCONSTANT], yyf); (void) fputc ('\n', yyf);
 break;
case kBOOL_CONSTANT: (void) fputs (Tree_NodeName [kBOOL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeBOOL_CONSTANT (yyt); break;
case kINT_CONSTANT: (void) fputs (Tree_NodeName [kINT_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINT_CONSTANT (yyt); break;
case kREAL_CONSTANT: (void) fputs (Tree_NodeName [kREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREAL_CONSTANT (yyt); break;
case kSTRING_CONSTANT: (void) fputs (Tree_NodeName [kSTRING_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeSTRING_CONSTANT (yyt); break;
case kCOMPLEX_CONSTANT: (void) fputs (Tree_NodeName [kCOMPLEX_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMPLEX_CONSTANT (yyt); break;
case kPROC_OBJ: (void) fputs (Tree_NodeName [kPROC_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodePROC_OBJ (yyt); break;
case kVAR_OBJ: (void) fputs (Tree_NodeName [kVAR_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVAR_OBJ (yyt); break;
case kTYPE_OBJ: (void) fputs (Tree_NodeName [kTYPE_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTYPE_OBJ (yyt); break;
case kREC_COMP: (void) fputs (Tree_NodeName [kREC_COMP], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREC_COMP (yyt); break;
case kTOP_OBJ: (void) fputs (Tree_NodeName [kTOP_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTOP_OBJ (yyt); break;
case kTEMP_OBJ: (void) fputs (Tree_NodeName [kTEMP_OBJ], yyf); (void) fputc ('\n', yyf);
 yWriteNodeTEMP_OBJ (yyt); break;
case kOVERLAP_SPEC: (void) fputs (Tree_NodeName [kOVERLAP_SPEC], yyf); (void) fputc ('\n', yyf);
 yWriteNodeOVERLAP_SPEC (yyt); break;
case kDEPENDENCE_INFO: (void) fputs (Tree_NodeName [kDEPENDENCE_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kSERIAL_INFO: (void) fputs (Tree_NodeName [kSERIAL_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kINDEP_INFO: (void) fputs (Tree_NodeName [kINDEP_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeINDEP_INFO (yyt); break;
case kVECTOR_INFO: (void) fputs (Tree_NodeName [kVECTOR_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeVECTOR_INFO (yyt); break;
case kPARDO_INFO: (void) fputs (Tree_NodeName [kPARDO_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kHOME_INFO: (void) fputs (Tree_NodeName [kHOME_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kNO_HOME_INFO: (void) fputs (Tree_NodeName [kNO_HOME_INFO], yyf); (void) fputc ('\n', yyf);
 break;
case kCOMM_INFO: (void) fputs (Tree_NodeName [kCOMM_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeCOMM_INFO (yyt); break;
case kON_INFO: (void) fputs (Tree_NodeName [kON_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeON_INFO (yyt); break;
case kPARALLEL_INFO: (void) fputs (Tree_NodeName [kPARALLEL_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodePARALLEL_INFO (yyt); break;
case kREACHING_INFO: (void) fputs (Tree_NodeName [kREACHING_INFO], yyf); (void) fputc ('\n', yyf);
 yWriteNodeREACHING_INFO (yyt); break;
 default: ;
 }
}

static short yyIndentLevel;

void WriteTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteTree (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tTree yyt)
# else
 (yys, yyt) char * yys; tTree yyt;
# endif
{ yyIndentSelector (yys); writetTree (yyt) }

static void yWriteCOMP_UNIT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_UNIT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("COMP_ELEMENTS", yyt->COMP_UNIT.COMP_ELEMENTS);
}

static void yWriteUNIT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUNIT_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->UNIT_LIST.Elem);
}

static void yWriteUNIT_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUNIT_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->UNIT_NODE.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->UNIT_NODE.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->UNIT_NODE.Object) yyWriteNl ();
}

static void yWriteMODULE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMODULE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MODULE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MODULE_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->MODULE_DECL.Object) yyWriteNl ();
}

static void yWritePROGRAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROGRAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROGRAM_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PROGRAM_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROGRAM_DECL.Object) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->PROGRAM_DECL.FORMALS);
}

static void yWritePROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PROC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROC_DECL.Object) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->PROC_DECL.FORMALS);
 yyIndentSelector ("IsRecursive"); writebool (yyt->PROC_DECL.IsRecursive) yyWriteNl ();
 yyIndentSelector ("IsPure"); writebool (yyt->PROC_DECL.IsPure) yyWriteNl ();
 yyIndentSelector ("HPFExtrinsic"); writetIdent (yyt->PROC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteFUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->FUNC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->FUNC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->FUNC_DECL.Object) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->FUNC_DECL.FORMALS);
 yyIndentSelectorTree ("FUNC_BODY", yyt->FUNC_DECL.FUNC_BODY);
 yyIndentSelector ("RESULT_ID"); writetIdent (yyt->FUNC_DECL.RESULT_ID) yyWriteNl ();
 yyIndentSelector ("IsRecursive"); writebool (yyt->FUNC_DECL.IsRecursive) yyWriteNl ();
 yyIndentSelector ("IsPure"); writebool (yyt->FUNC_DECL.IsPure) yyWriteNl ();
 yyIndentSelector ("HPFExtrinsic"); writetIdent (yyt->FUNC_DECL.HPFExtrinsic) yyWriteNl ();
}

static void yWriteMODULE_PROC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMODULE_PROC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MODULE_PROC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MODULE_PROC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->MODULE_PROC_DECL.Object) yyWriteNl ();
}

static void yWriteBLOCK_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBLOCK_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->BLOCK_DATA_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->BLOCK_DATA_DECL.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->BLOCK_DATA_DECL.Object) yyWriteNl ();
}

static void yWriteINTERFACE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTERFACE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTERFACE.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTERFACE.Line) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->INTERFACE.Object) yyWriteNl ();
 yyIndentSelectorTree ("SPEC", yyt->INTERFACE.SPEC);
}

static void yWriteBODY_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBODY_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DECLS", yyt->BODY_NODE.DECLS);
 yyIndentSelectorTree ("STATS", yyt->BODY_NODE.STATS);
}

static void yWriteINTEGER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTEGER_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteREAL_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREAL_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBOOLEAN_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOOLEAN_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCOMPLEX_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMPLEX_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteSTRING_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTRING_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteTYPE_ID
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_ID], yyf); (void) fputc ('\n', yyf);
}

static void yWriteARRAY_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ARRAY_INDEX_TYPES", yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES);
}

static void yWriteRECORD_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRECORD_TYPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->RECORD_TYPE.Name) yyWriteNl ();
}

static void yWritePOINTER_TYPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOINTER_TYPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteSHAPE_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSHAPE_SPEC], yyf); (void) fputc ('\n', yyf);
}

static void yWriteEXPLICIT_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXPLICIT_SHAPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Overlap", yyt->EXPLICIT_SHAPE.Overlap);
 yyIndentSelectorTree ("LOWER", yyt->EXPLICIT_SHAPE.LOWER);
}

static void yWriteASSUMED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSUMED_SHAPE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Overlap", yyt->ASSUMED_SHAPE.Overlap);
}

static void yWriteDEFERRED_SHAPE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEFERRED_SHAPE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteASSUMED_SIZE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSUMED_SIZE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Overlap", yyt->ASSUMED_SIZE.Overlap);
}

static void yWriteSHAPE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSHAPE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SHAPE_LIST.Elem);
}

static void yWriteDECL_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDECL_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DECL_NODE.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DECL_NODE.Line) yyWriteNl ();
}

static void yWriteTYPE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TYPE_DECL.Line) yyWriteNl ();
}

static void yWriteNAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAME_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->NAME_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->NAME_DECL.Line) yyWriteNl ();
}

static void yWriteRENAME_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRENAME_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RENAME_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RENAME_DECL.Line) yyWriteNl ();
 yyIndentSelector ("oldname"); writetIdent (yyt->RENAME_DECL.oldname) yyWriteNl ();
}

static void yWriteENTITY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kENTITY_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ENTITY_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ENTITY_DECL.Line) yyWriteNl ();
}

static void yWriteVAR_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->VAR_DECL.Line) yyWriteNl ();
}

static void yWriteCOMMON_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMMON_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->COMMON_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->COMMON_DECL.Line) yyWriteNl ();
}

static void yWriteNAMELIST_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMELIST_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->NAMELIST_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->NAMELIST_DECL.Line) yyWriteNl ();
}

static void yWriteTEMPLATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTEMPLATE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TEMPLATE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TEMPLATE_DECL.Line) yyWriteNl ();
}

static void yWriteRAGGED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRAGGED_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RAGGED_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RAGGED_DECL.Line) yyWriteNl ();
}

static void yWritePROCESSORS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSORS_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROCESSORS_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PROCESSORS_DECL.Line) yyWriteNl ();
}

static void yWriteSUB_PROCS_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSUB_PROCS_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SUB_PROCS_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SUB_PROCS_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("TOP", yyt->SUB_PROCS_DECL.TOP);
}

static void yWriteINHERIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINHERIT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INHERIT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INHERIT_DECL.Line) yyWriteNl ();
}

static void yWriteRANGE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRANGE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RANGE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RANGE_DECL.Line) yyWriteNl ();
}

static void yWriteSTMT_FUNC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTMT_FUNC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->STMT_FUNC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->STMT_FUNC_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("FORMALS", yyt->STMT_FUNC_DECL.FORMALS);
 yyIndentSelectorTree ("RESULT_TYPE", yyt->STMT_FUNC_DECL.RESULT_TYPE);
}

static void yWriteINTERFACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTERFACE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTERFACE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTERFACE_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("SPEC", yyt->INTERFACE_DECL.SPEC);
}

static void yWriteVAR_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_PARAM_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->VAR_PARAM_DECL.Line) yyWriteNl ();
}

static void yWriteRET_PARAM_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRET_PARAM_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->RET_PARAM_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->RET_PARAM_DECL.Line) yyWriteNl ();
}

static void yWriteIMPLICIT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIMPLICIT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->IMPLICIT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->IMPLICIT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("first"); writetIdent (yyt->IMPLICIT_DECL.first) yyWriteNl ();
 yyIndentSelector ("last"); writetIdent (yyt->IMPLICIT_DECL.last) yyWriteNl ();
}

static void yWriteUSE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->USE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->USE_DECL.Line) yyWriteNl ();
 yyIndentSelector ("use"); writetIdent (yyt->USE_DECL.use) yyWriteNl ();
}

static void yWriteONLY_USE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kONLY_USE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ONLY_USE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ONLY_USE_DECL.Line) yyWriteNl ();
 yyIndentSelector ("use"); writetIdent (yyt->ONLY_USE_DECL.use) yyWriteNl ();
}

static void yWriteEQV_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEQV_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->EQV_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->EQV_DECL.Line) yyWriteNl ();
}

static void yWriteDATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DATA_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DATA_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("VARS", yyt->DATA_DECL.VARS);
}

static void yWriteFORMAT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->FORMAT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->FORMAT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("label"); writeint (yyt->FORMAT_DECL.label) yyWriteNl ();
}

static void yWriteDIMENSION_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIMENSION_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DIMENSION_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DIMENSION_DECL.Line) yyWriteNl ();
}

static void yWriteINIT_DATA_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINIT_DATA_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INIT_DATA_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INIT_DATA_DECL.Line) yyWriteNl ();
}

static void yWriteTYPESPEC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPESPEC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPESPEC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TYPESPEC_DECL.Line) yyWriteNl ();
}

static void yWriteALLOCATABLE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALLOCATABLE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ALLOCATABLE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ALLOCATABLE_DECL.Line) yyWriteNl ();
}

static void yWriteEXTERNAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXTERNAL_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->EXTERNAL_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->EXTERNAL_DECL.Line) yyWriteNl ();
}

static void yWriteINTENT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTENT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTENT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTENT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("intent"); writeint (yyt->INTENT_DECL.intent) yyWriteNl ();
}

static void yWriteINTRINSIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINTRINSIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->INTRINSIC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->INTRINSIC_DECL.Line) yyWriteNl ();
 yyIndentSelector ("generic"); writetIdent (yyt->INTRINSIC_DECL.generic) yyWriteNl ();
 yyIndentSelector ("class"); writeint (yyt->INTRINSIC_DECL.class) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->INTRINSIC_DECL.kind) yyWriteNl ();
}

static void yWriteOPTIONAL_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOPTIONAL_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->OPTIONAL_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->OPTIONAL_DECL.Line) yyWriteNl ();
}

static void yWritePOINTER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPOINTER_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->POINTER_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->POINTER_DECL.Line) yyWriteNl ();
}

static void yWriteSAVE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSAVE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SAVE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SAVE_DECL.Line) yyWriteNl ();
}

static void yWriteTARGET_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTARGET_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TARGET_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TARGET_DECL.Line) yyWriteNl ();
}

static void yWritePARAMETER_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPARAMETER_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PARAMETER_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PARAMETER_DECL.Line) yyWriteNl ();
}

static void yWritePUBLIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPUBLIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PUBLIC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PUBLIC_DECL.Line) yyWriteNl ();
}

static void yWritePRIVATE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPRIVATE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PRIVATE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PRIVATE_DECL.Line) yyWriteNl ();
}

static void yWriteSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SEQUENCE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SEQUENCE_DECL.Line) yyWriteNl ();
}

static void yWriteDISTRIBUTE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDISTRIBUTE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DISTRIBUTE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DISTRIBUTE_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("DISTRIBUTION", yyt->DISTRIBUTE_DECL.DISTRIBUTION);
}

static void yWriteALIGN_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALIGN_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->ALIGN_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ALIGN_DECL.Line) yyWriteNl ();
 yyIndentSelectorTree ("ALIGN_SOURCE", yyt->ALIGN_DECL.ALIGN_SOURCE);
}

static void yWriteMAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMAP_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MAP_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MAP_DECL.Line) yyWriteNl ();
}

static void yWriteOVERLAP_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOVERLAP_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->OVERLAP_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->OVERLAP_DECL.Line) yyWriteNl ();
}

static void yWriteSHARED_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSHARED_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SHARED_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SHARED_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->SHARED_DECL.kind) yyWriteNl ();
}

static void yWriteDYNAMIC_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDYNAMIC_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->DYNAMIC_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->DYNAMIC_DECL.Line) yyWriteNl ();
}

static void yWriteTRACE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTRACE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TRACE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TRACE_DECL.Line) yyWriteNl ();
}

static void yWriteTREE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTREE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TREE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->TREE_DECL.Line) yyWriteNl ();
}

static void yWriteSELECT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->SELECT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->SELECT_DECL.Line) yyWriteNl ();
}

static void yWriteHPF_SEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kHPF_SEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->HPF_SEQUENCE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->HPF_SEQUENCE_DECL.Line) yyWriteNl ();
}

static void yWriteNOSEQUENCE_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNOSEQUENCE_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->NOSEQUENCE_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->NOSEQUENCE_DECL.Line) yyWriteNl ();
}

static void yWriteLAYOUT_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLAYOUT_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->LAYOUT_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->LAYOUT_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writetStringRef (yyt->LAYOUT_DECL.kind) yyWriteNl ();
}

static void yWritePASS_BY_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPASS_BY_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PASS_BY_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->PASS_BY_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writetStringRef (yyt->PASS_BY_DECL.kind) yyWriteNl ();
}

static void yWriteMAP_TO_DECL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMAP_TO_DECL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->MAP_TO_DECL.Ident) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->MAP_TO_DECL.Line) yyWriteNl ();
 yyIndentSelector ("kind"); writetStringRef (yyt->MAP_TO_DECL.kind) yyWriteNl ();
}

static void yWriteDECL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDECL_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->DECL_LIST.Elem);
}

static void yWriteRANGE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRANGE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->RANGE_LIST.Elem);
}

static void yWriteSELECT_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECT_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SELECT_LIST.Elem);
}

static void yWriteSELECT_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECT_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("selector"); writeint (yyt->SELECT_SPEC.selector) yyWriteNl ();
}

static void yWriteDISTRIBUTION_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDISTRIBUTION_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->DISTRIBUTION_SPEC.is_descriptive) yyWriteNl ();
}

static void yWriteANY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kANY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->ANY_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteDEFAULT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEFAULT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->DEFAULT_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteREPL_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREPL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->REPL_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteNODE_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNODE_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->NODE_DISTRIBUTION.is_descriptive) yyWriteNl ();
}

static void yWriteDIST_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIST_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->DIST_LIST.Elem);
}

static void yWriteBLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteCYCLIC_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteGEN_BLOCK_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kGEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINDIRECT_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
}

static void yWriteARBITRARY_DISTRIBUTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SIZE", yyt->ARBITRARY_DISTRIBUTION.SIZE);
 yyIndentSelectorTree ("LENGTH", yyt->ARBITRARY_DISTRIBUTION.LENGTH);
}

static void yWritePROCESSOR_ARRAY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf);
}

static void yWritePROCESSOR_SUBSET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROCESSOR_SUBSET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SUBTOP", yyt->PROCESSOR_SUBSET.SUBTOP);
 yyIndentSelectorTree ("FULLTOP", yyt->PROCESSOR_SUBSET.FULLTOP);
}

static void yWriteALIGN_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALIGN_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_descriptive"); writeint (yyt->ALIGN_SPEC.is_descriptive) yyWriteNl ();
 yyIndentSelectorTree ("TEMPNAME", yyt->ALIGN_SPEC.TEMPNAME);
}

static void yWriteID_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kID_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("name"); writetIdent (yyt->ID_GENERIC_SPEC.name) yyWriteNl ();
}

static void yWriteOP_GENERIC_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf);
}

static void yWriteACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->ACF_LIST.Elem);
}

static void yWriteACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_NODE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_NODE.Line) yyWriteNl ();
}

static void yWriteACF_DUMMY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DUMMY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DUMMY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DUMMY.Line) yyWriteNl ();
}

static void yWriteACF_BASIC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_BASIC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_BASIC.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_BASIC.Line) yyWriteNl ();
}

static void yWriteACF_IF
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_IF], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_IF.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_IF.Line) yyWriteNl ();
 yyIndentSelectorTree ("IF_EXP", yyt->ACF_IF.IF_EXP);
 yyIndentSelectorTree ("THEN_PART", yyt->ACF_IF.THEN_PART);
}

static void yWriteACF_WHERE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WHERE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WHERE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WHERE.Line) yyWriteNl ();
 yyIndentSelectorTree ("WHERE_EXP", yyt->ACF_WHERE.WHERE_EXP);
 yyIndentSelectorTree ("TRUE_PART", yyt->ACF_WHERE.TRUE_PART);
}

static void yWriteACF_CASE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_CASE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_CASE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_CASE.Line) yyWriteNl ();
 yyIndentSelectorTree ("CASE_EXP", yyt->ACF_CASE.CASE_EXP);
}

static void yWriteACF_WHILE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_WHILE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_WHILE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_WHILE.Line) yyWriteNl ();
 yyIndentSelectorTree ("WHILE_EXP", yyt->ACF_WHILE.WHILE_EXP);
}

static void yWriteACF_REPEAT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_REPEAT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_REPEAT.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_REPEAT.Line) yyWriteNl ();
 yyIndentSelectorTree ("REPEAT_BODY", yyt->ACF_REPEAT.REPEAT_BODY);
}

static void yWriteACF_LOOP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_LOOP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_LOOP.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_LOOP.Line) yyWriteNl ();
}

static void yWriteACF_DO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_DO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_DO.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_DO.Line) yyWriteNl ();
 yyIndentSelectorTree ("DO_ID", yyt->ACF_DO.DO_ID);
 yyIndentSelectorTree ("DO_RANGE", yyt->ACF_DO.DO_RANGE);
 yyIndentSelectorTree ("DO_BODY", yyt->ACF_DO.DO_BODY);
 yyIndentSelectorTree ("DO_DEP_INFO", yyt->ACF_DO.DO_DEP_INFO);
}

static void yWriteACF_FORALL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_FORALL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_FORALL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_FORALL.Line) yyWriteNl ();
 yyIndentSelectorTree ("FORALL_ID", yyt->ACF_FORALL.FORALL_ID);
 yyIndentSelectorTree ("FORALL_RANGE", yyt->ACF_FORALL.FORALL_RANGE);
 yyIndentSelectorTree ("FORALL_BODY", yyt->ACF_FORALL.FORALL_BODY);
 yyIndentSelectorTree ("FORALL_DEP_INFO", yyt->ACF_FORALL.FORALL_DEP_INFO);
}

static void yWriteACF_FLOW_GRAPH
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_FLOW_GRAPH], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_FLOW_GRAPH.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_FLOW_GRAPH.Line) yyWriteNl ();
}

static void yWriteACF_ENTRY
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ENTRY], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ENTRY.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ENTRY.Line) yyWriteNl ();
}

static void yWriteACF_HOME
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_HOME], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_HOME.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_HOME.Line) yyWriteNl ();
 yyIndentSelectorTree ("HOME_VAR", yyt->ACF_HOME.HOME_VAR);
 yyIndentSelector ("user_home"); writebool (yyt->ACF_HOME.user_home) yyWriteNl ();
}

static void yWriteACF_RESIDENT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_RESIDENT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_RESIDENT.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_RESIDENT.Line) yyWriteNl ();
 yyIndentSelectorTree ("RESIDENT_VAR", yyt->ACF_RESIDENT.RESIDENT_VAR);
}

static void yWriteACF_NEW
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_NEW], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_NEW.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_NEW.Line) yyWriteNl ();
 yyIndentSelectorTree ("NEW_VAR", yyt->ACF_NEW.NEW_VAR);
}

static void yWriteACF_REDUCTION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_REDUCTION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_REDUCTION.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_REDUCTION.Line) yyWriteNl ();
 yyIndentSelector ("is_zero"); writebool (yyt->ACF_REDUCTION.is_zero) yyWriteNl ();
 yyIndentSelectorTree ("REDUCTION_VAR", yyt->ACF_REDUCTION.REDUCTION_VAR);
 yyIndentSelectorTree ("REDUCTION_LVAR", yyt->ACF_REDUCTION.REDUCTION_LVAR);
 yyIndentSelectorTree ("REDUCTION_FUNC", yyt->ACF_REDUCTION.REDUCTION_FUNC);
}

static void yWriteACF_TASK_REGION
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_TASK_REGION], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_TASK_REGION.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_TASK_REGION.Line) yyWriteNl ();
 yyIndentSelector ("task_flag"); writeint (yyt->ACF_TASK_REGION.task_flag) yyWriteNl ();
}

static void yWriteACF_PARALLEL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_PARALLEL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_PARALLEL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_PARALLEL.Line) yyWriteNl ();
 yyIndentSelectorTree ("REDUCTION_VARS", yyt->ACF_PARALLEL.REDUCTION_VARS);
 yyIndentSelectorTree ("SHARED_VARS", yyt->ACF_PARALLEL.SHARED_VARS);
 yyIndentSelectorTree ("LOCAL_VARS", yyt->ACF_PARALLEL.LOCAL_VARS);
}

static void yWriteACF_CRITICAL
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_CRITICAL], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_CRITICAL.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_CRITICAL.Line) yyWriteNl ();
}

static void yWriteACF_ON
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_ON], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_ON.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_ON.Line) yyWriteNl ();
 yyIndentSelectorTree ("ON_HOME", yyt->ACF_ON.ON_HOME);
 yyIndentSelectorTree ("ON_SPECS", yyt->ACF_ON.ON_SPECS);
}

static void yWriteACF_RM_READ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_RM_READ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_RM_READ.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_RM_READ.Line) yyWriteNl ();
 yyIndentSelectorTree ("LOCAL_VAR", yyt->ACF_RM_READ.LOCAL_VAR);
}

static void yWriteACF_RM_WRITE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_RM_WRITE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_RM_WRITE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_RM_WRITE.Line) yyWriteNl ();
 yyIndentSelector ("op"); writeint (yyt->ACF_RM_WRITE.op) yyWriteNl ();
 yyIndentSelectorTree ("REMOTE_VAR", yyt->ACF_RM_WRITE.REMOTE_VAR);
}

static void yWriteACF_MOVE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_MOVE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_MOVE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_MOVE.Line) yyWriteNl ();
}

static void yWriteACF_BARRIER
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_BARRIER], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_BARRIER.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_BARRIER.Line) yyWriteNl ();
}

static void yWriteACF_UPDATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kACF_UPDATE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Label"); writeint (yyt->ACF_UPDATE.Label) yyWriteNl ();
 yyIndentSelector ("Line"); writeint (yyt->ACF_UPDATE.Line) yyWriteNl ();
}

static void yWriteON_VAR_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_VAR_CLAUSE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteON_PROC_CLAUSE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_PROC_CLAUSE], yyf); (void) fputc ('\n', yyf);
}

static void yWriteON_PROCS
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_PROCS], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("topid"); writetObject (yyt->ON_PROCS.topid) yyWriteNl ();
}

static void yWriteON_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("topid"); writetObject (yyt->ON_VAR.topid) yyWriteNl ();
 yyIndentSelector ("tempid"); writetObject (yyt->ON_VAR.tempid) yyWriteNl ();
 yyIndentSelector ("arrayid"); writetObject (yyt->ON_VAR.arrayid) yyWriteNl ();
}

static void yWriteON_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->ON_LIST.Elem);
}

static void yWriteON_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("top_dim"); writeint (yyt->ON_SPEC.top_dim) yyWriteNl ();
 yyIndentSelector ("temp_dim"); writeint (yyt->ON_SPEC.temp_dim) yyWriteNl ();
 yyIndentSelector ("array_dim"); writeint (yyt->ON_SPEC.array_dim) yyWriteNl ();
}

static void yWriteSELECTED_ACF_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_ACF_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->SELECTED_ACF_LIST.Elem);
}

static void yWriteSELECTED_ACF_NODE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELECT_LIST", yyt->SELECTED_ACF_NODE.SELECT_LIST);
}

static void yWriteASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_VAR", yyt->ASSIGN_STMT.ASSIGN_VAR);
}

static void yWritePTR_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPTR_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ASSIGN_VAR", yyt->PTR_ASSIGN_STMT.ASSIGN_VAR);
}

static void yWriteLABEL_ASSIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLABEL_ASSIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("assign_label"); writeint (yyt->LABEL_ASSIGN_STMT.assign_label) yyWriteNl ();
}

static void yWriteCALL_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCALL_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("CALL_ID", yyt->CALL_STMT.CALL_ID);
}

static void yWriteIO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->IO_STMT.ID);
 yyIndentSelectorTree ("IO_SPECS", yyt->IO_STMT.IO_SPECS);
}

static void yWriteGOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kGOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("GOTO_LABEL"); writeint (yyt->GOTO_STMT.GOTO_LABEL) yyWriteNl ();
}

static void yWriteASS_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kASS_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("GOTO_VAR", yyt->ASS_GOTO_STMT.GOTO_VAR);
}

static void yWriteCOMP_GOTO_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_GOTO_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("GOTO_LABELS", yyt->COMP_GOTO_STMT.GOTO_LABELS);
}

static void yWriteCOMP_IF_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMP_IF_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("IF_LT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_LT_LABEL) yyWriteNl ();
 yyIndentSelector ("IF_EQ_LABEL"); writeint (yyt->COMP_IF_STMT.IF_EQ_LABEL) yyWriteNl ();
 yyIndentSelector ("IF_GT_LABEL"); writeint (yyt->COMP_IF_STMT.IF_GT_LABEL) yyWriteNl ();
}

static void yWriteRETURN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRETURN_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWritePAUSE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPAUSE_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteEXIT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kEXIT_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("loopid"); writetIdent (yyt->EXIT_STMT.loopid) yyWriteNl ();
}

static void yWriteCYCLE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCYCLE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("loopid"); writetIdent (yyt->CYCLE_STMT.loopid) yyWriteNl ();
}

static void yWriteSTOP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTOP_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFORMAT_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINHERIT_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINHERIT_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("VAR", yyt->INHERIT_DSP_STMT.VAR);
 yyIndentSelector ("flag"); writeint (yyt->INHERIT_DSP_STMT.flag) yyWriteNl ();
 yyIndentSelector ("safety"); writeint (yyt->INHERIT_DSP_STMT.safety) yyWriteNl ();
}

static void yWriteCREATE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCREATE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("VAR", yyt->CREATE_DSP_STMT.VAR);
 yyIndentSelector ("flag"); writeint (yyt->CREATE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteFREE_DSP_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFREE_DSP_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("flag"); writeint (yyt->FREE_DSP_STMT.flag) yyWriteNl ();
}

static void yWriteALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("PARAMS", yyt->ALLOCATE_STMT.PARAMS);
}

static void yWriteDEALLOCATE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDEALLOCATE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("PARAMS", yyt->DEALLOCATE_STMT.PARAMS);
}

static void yWriteNULLIFY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNULLIFY_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteREDUCE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDUCE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("RED_FUNC", yyt->REDUCE_STMT.RED_FUNC);
}

static void yWriteMOVE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kMOVE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("TARGET", yyt->MOVE_STMT.TARGET);
 yyIndentSelectorTree ("SOURCE", yyt->MOVE_STMT.SOURCE);
}

static void yWriteSCATTER_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSCATTER_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("func"); writetIdent (yyt->SCATTER_STMT.func) yyWriteNl ();
 yyIndentSelectorTree ("ARRAY", yyt->SCATTER_STMT.ARRAY);
 yyIndentSelectorTree ("BASE", yyt->SCATTER_STMT.BASE);
 yyIndentSelectorTree ("INDEXES", yyt->SCATTER_STMT.INDEXES);
}

static void yWriteREALIGN_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREALIGN_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ALIGNEE", yyt->REALIGN_STMT.ALIGNEE);
 yyIndentSelectorTree ("ALIGN_SOURCE", yyt->REALIGN_STMT.ALIGN_SOURCE);
 yyIndentSelector ("distribution"); writetDefinitions (yyt->REALIGN_STMT.distribution) yyWriteNl ();
}

static void yWriteREDISTRIBUTE_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDISTRIBUTE_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DISTRIBUTEE", yyt->REDISTRIBUTE_STMT.DISTRIBUTEE);
 yyIndentSelectorTree ("DISTRIBUTION", yyt->REDISTRIBUTE_STMT.DISTRIBUTION);
 yyIndentSelector ("distribution"); writetDefinitions (yyt->REDISTRIBUTE_STMT.distribution) yyWriteNl ();
}

static void yWriteREG_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREG_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SHADOW_VAR", yyt->REG_SHADOW_GET.SHADOW_VAR);
}

static void yWriteREG_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREG_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("op"); writeint (yyt->REG_SHADOW_PUT.op) yyWriteNl ();
 yyIndentSelectorTree ("SHADOW_VAR", yyt->REG_SHADOW_PUT.SHADOW_VAR);
}

static void yWriteREG_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREG_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SHADOW_VAR", yyt->REG_SHADOW_SET.SHADOW_VAR);
 yyIndentSelectorTree ("SHADOW_SIZE", yyt->REG_SHADOW_SET.SHADOW_SIZE);
}

static void yWriteIND_SHADOW_CREATE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_CREATE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_CREATE.id) yyWriteNl ();
 yyIndentSelectorTree ("SHADOW_VAR", yyt->IND_SHADOW_CREATE.SHADOW_VAR);
 yyIndentSelectorTree ("INDEX_VAR", yyt->IND_SHADOW_CREATE.INDEX_VAR);
 yyIndentSelectorTree ("TMP_INDEX_VAR", yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR);
}

static void yWriteIND_SHADOW_FREE
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_FREE], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_FREE.id) yyWriteNl ();
}

static void yWriteIND_SHADOW_GET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_GET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_GET.id) yyWriteNl ();
}

static void yWriteIND_SHADOW_PUT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_PUT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_PUT.id) yyWriteNl ();
 yyIndentSelector ("op"); writeint (yyt->IND_SHADOW_PUT.op) yyWriteNl ();
}

static void yWriteIND_SHADOW_SET
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kIND_SHADOW_SET], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("id"); writeint (yyt->IND_SHADOW_SET.id) yyWriteNl ();
 yyIndentSelectorTree ("SHADOW_VAR", yyt->IND_SHADOW_SET.SHADOW_VAR);
}

static void yWriteBROADCAST_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBROADCAST_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ELEMS", yyt->BROADCAST_STMT.ELEMS);
 yyIndentSelectorTree ("OWNER_TOP", yyt->BROADCAST_STMT.OWNER_TOP);
}

static void yWriteREDUCTION_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREDUCTION_STMT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("REDFUNC", yyt->REDUCTION_STMT.REDFUNC);
 yyIndentSelectorTree ("ELEMS", yyt->REDUCTION_STMT.ELEMS);
 yyIndentSelectorTree ("RED_TOP", yyt->REDUCTION_STMT.RED_TOP);
}

static void yWriteDIRTY_STMT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDIRTY_STMT], yyf); (void) fputc ('\n', yyf);
}

static void yWriteLABEL_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLABEL_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Elem"); writeint (yyt->LABEL_LIST.Elem) yyWriteNl ();
}

static void yWriteOP_DEFINED
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_DEFINED], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("opname"); writetIdent (yyt->OP_DEFINED.opname) yyWriteNl ();
}

static void yWriteCONST_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCONST_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteOP_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("EXP_OP", yyt->OP_EXP.EXP_OP);
 yyIndentSelectorTree ("OPND1", yyt->OP_EXP.OPND1);
}

static void yWriteOP1_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOP1_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("EXP_OP1", yyt->OP1_EXP.EXP_OP1);
}

static void yWriteSLICE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSLICE_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("START", yyt->SLICE_EXP.START);
 yyIndentSelectorTree ("STOP", yyt->SLICE_EXP.STOP);
}

static void yWriteVAR_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFUNC_CALL_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_CALL_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("FUNC_ID", yyt->FUNC_CALL_EXP.FUNC_ID);
}

static void yWriteNAMED_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMED_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMED_EXP.Name) yyWriteNl ();
}

static void yWriteDO_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDO_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DO_ID", yyt->DO_EXP.DO_ID);
 yyIndentSelectorTree ("RANGE", yyt->DO_EXP.RANGE);
}

static void yWriteTYPE_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("ID", yyt->TYPE_EXP.ID);
}

static void yWriteARRAY_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kARRAY_EXP], yyf); (void) fputc ('\n', yyf);
}

static void yWritePERM_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPERM_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("perm"); writePermutation (yyt->PERM_EXP.perm) yyWriteNl ();
}

static void yWriteBOUND_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOUND_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("dim"); writeint (yyt->BOUND_EXP.dim) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->BOUND_EXP.kind) yyWriteNl ();
 yyIndentSelector ("local"); writeint (yyt->BOUND_EXP.local) yyWriteNl ();
}

static void yWriteRANK_EXP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRANK_EXP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("kind"); writeint (yyt->RANK_EXP.kind) yyWriteNl ();
}

static void yWriteBTE_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTE_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTE_LIST.Elem);
}

static void yWriteUSED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kUSED_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteINDEXED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEXED_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_VAR", yyt->INDEXED_VAR.IND_VAR);
}

static void yWriteSUBSTRING_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSUBSTRING_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("IND_VAR", yyt->SUBSTRING_VAR.IND_VAR);
}

static void yWriteSELECTED_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSELECTED_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("SELEC_VAR", yyt->SELECTED_VAR.SELEC_VAR);
}

static void yWriteLOOP_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kLOOP_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWritePERM_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPERM_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("perm"); writePermutation (yyt->PERM_VAR.perm) yyWriteNl ();
}

static void yWriteADDR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kADDR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteDO_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kDO_VAR], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("DO_ID", yyt->DO_VAR.DO_ID);
 yyIndentSelectorTree ("RANGE", yyt->DO_VAR.RANGE);
}

static void yWriteREMOTE_VAR
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREMOTE_VAR], yyf); (void) fputc ('\n', yyf);
}

static void yWriteBTV_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTV_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTV_LIST.Elem);
}

static void yWriteVAR_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("formal"); writetDefinitions (yyt->VAR_PARAM.formal) yyWriteNl ();
 yyIndentSelector ("intent"); writeint (yyt->VAR_PARAM.intent) yyWriteNl ();
 yyIndentSelector ("layout"); writeint (yyt->VAR_PARAM.layout) yyWriteNl ();
 yyIndentSelector ("pass_by"); writeint (yyt->VAR_PARAM.pass_by) yyWriteNl ();
 yyIndentSelector ("trace"); writeint (yyt->VAR_PARAM.trace) yyWriteNl ();
}

static void yWriteVALUE_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVALUE_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteNAMED_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNAMED_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Name"); writetIdent (yyt->NAMED_PARAM.Name) yyWriteNl ();
}

static void yWritePROC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFUNC_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFUNC_PARAM], yyf); (void) fputc ('\n', yyf);
}

static void yWriteFORMAT_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kFORMAT_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("S"); writetStringRef (yyt->FORMAT_PARAM.S) yyWriteNl ();
}

static void yWriteRETURN_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kRETURN_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("label"); writeint (yyt->RETURN_PARAM.label) yyWriteNl ();
}

static void yWriteNO_PARAM
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kNO_PARAM], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("type"); writeint (yyt->NO_PARAM.type) yyWriteNl ();
}

static void yWriteBTP_LIST
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBTP_LIST], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Elem", yyt->BTP_LIST.Elem);
}

static void yWriteBOOL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kBOOL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writeint (yyt->BOOL_CONSTANT.value) yyWriteNl ();
}

static void yWriteINT_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINT_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writeint (yyt->INT_CONSTANT.value) yyWriteNl ();
}

static void yWriteREAL_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREAL_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->REAL_CONSTANT.value) yyWriteNl ();
 yyIndentSelector ("kind"); writeint (yyt->REAL_CONSTANT.kind) yyWriteNl ();
}

static void yWriteSTRING_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kSTRING_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("value"); writetStringRef (yyt->STRING_CONSTANT.value) yyWriteNl ();
}

static void yWriteCOMPLEX_CONSTANT
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMPLEX_CONSTANT], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("rvalue"); writetStringRef (yyt->COMPLEX_CONSTANT.rvalue) yyWriteNl ();
 yyIndentSelector ("ivalue"); writetStringRef (yyt->COMPLEX_CONSTANT.ivalue) yyWriteNl ();
}

static void yWritePROC_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPROC_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->PROC_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->PROC_OBJ.Object) yyWriteNl ();
}

static void yWriteVAR_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVAR_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Pos"); writeint (yyt->VAR_OBJ.Pos) yyWriteNl ();
 yyIndentSelector ("Ident"); writetIdent (yyt->VAR_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->VAR_OBJ.Object) yyWriteNl ();
 yyIndentSelector ("Reaching"); writetReaching (yyt->VAR_OBJ.Reaching) yyWriteNl ();
}

static void yWriteTYPE_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTYPE_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TYPE_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TYPE_OBJ.Object) yyWriteNl ();
}

static void yWriteREC_COMP
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREC_COMP], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->REC_COMP.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->REC_COMP.Object) yyWriteNl ();
}

static void yWriteTOP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTOP_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TOP_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TOP_OBJ.Object) yyWriteNl ();
}

static void yWriteTEMP_OBJ
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kTEMP_OBJ], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Ident"); writetIdent (yyt->TEMP_OBJ.Ident) yyWriteNl ();
 yyIndentSelector ("Object"); writetDefinitions (yyt->TEMP_OBJ.Object) yyWriteNl ();
}

static void yWriteOVERLAP_SPEC
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kOVERLAP_SPEC], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("left_size"); writeint (yyt->OVERLAP_SPEC.left_size) yyWriteNl ();
 yyIndentSelector ("right_size"); writeint (yyt->OVERLAP_SPEC.right_size) yyWriteNl ();
 yyIndentSelector ("left_update"); writeint (yyt->OVERLAP_SPEC.left_update) yyWriteNl ();
 yyIndentSelector ("right_update"); writeint (yyt->OVERLAP_SPEC.right_update) yyWriteNl ();
}

static void yWriteINDEP_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kINDEP_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("user_independent"); writebool (yyt->INDEP_INFO.user_independent) yyWriteNl ();
 yyIndentSelector ("selection"); writeint (yyt->INDEP_INFO.selection) yyWriteNl ();
 yyIndentSelector ("red_vars"); writeInfoTree (yyt->INDEP_INFO.red_vars) yyWriteNl ();
 yyIndentSelector ("new_vars"); writeInfoTree (yyt->INDEP_INFO.new_vars) yyWriteNl ();
}

static void yWriteVECTOR_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kVECTOR_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("is_independent"); writebool (yyt->VECTOR_INFO.is_independent) yyWriteNl ();
 yyIndentSelector ("selection"); writeint (yyt->VECTOR_INFO.selection) yyWriteNl ();
 yyIndentSelector ("loop_cnt"); writeint (yyt->VECTOR_INFO.loop_cnt) yyWriteNl ();
 yyIndentSelector ("independent_vars"); writeInfoTree (yyt->VECTOR_INFO.independent_vars) yyWriteNl ();
}

static void yWriteCOMM_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kCOMM_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("home_var"); writeInfoTree (yyt->COMM_INFO.home_var) yyWriteNl ();
 yyIndentSelector ("is_local"); writebool (yyt->COMM_INFO.is_local) yyWriteNl ();
}

static void yWriteON_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kON_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("on_id"); writetObject (yyt->ON_INFO.on_id) yyWriteNl ();
 yyIndentSelector ("on_dim"); writeint (yyt->ON_INFO.on_dim) yyWriteNl ();
 yyIndentSelector ("base"); writeint (yyt->ON_INFO.base) yyWriteNl ();
 yyIndentSelector ("stride"); writeint (yyt->ON_INFO.stride) yyWriteNl ();
}

static void yWritePARALLEL_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kPARALLEL_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("reduction_vars"); writeInfoTree (yyt->PARALLEL_INFO.reduction_vars) yyWriteNl ();
 yyIndentSelector ("home_var"); writeInfoTree (yyt->PARALLEL_INFO.home_var) yyWriteNl ();
 yyIndentSelector ("new_vars"); writeInfoTree (yyt->PARALLEL_INFO.new_vars) yyWriteNl ();
 yyIndentSelector ("resident_vars"); writeInfoTree (yyt->PARALLEL_INFO.resident_vars) yyWriteNl ();
}

static void yWriteREACHING_INFO
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 (void) fputs (Tree_NodeName [kREACHING_INFO], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("var_allocate"); writeInfoTree (yyt->REACHING_INFO.var_allocate) yyWriteNl ();
 yyIndentSelector ("temp_allocate"); writeInfoTree (yyt->REACHING_INFO.temp_allocate) yyWriteNl ();
 yyIndentSelector ("var_distribution"); writetDefinitions (yyt->REACHING_INFO.var_distribution) yyWriteNl ();
 yyIndentSelector ("temp_distribution"); writetDefinitions (yyt->REACHING_INFO.temp_distribution) yyWriteNl ();
}

static void yyWriteTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoTree) { (void) fputs (" NoTree\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kCOMP_UNIT: yWriteCOMP_UNIT (yyt); yyIndentSelector ("USED_ELEMENTS"); yyt = yyt->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_NODE_LIST: (void) fputs (Tree_NodeName [kUNIT_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUNIT_EMPTY: (void) fputs (Tree_NodeName [kUNIT_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUNIT_LIST: yWriteUNIT_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->UNIT_LIST.Next; break;
case kUNIT_NODE: yWriteUNIT_NODE (yyt); goto yyExit;
case kMODULE_DECL: yWriteMODULE_DECL (yyt); yyIndentSelector ("MODULE_BODY"); yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL: yWritePROGRAM_DECL (yyt); yyIndentSelector ("PROGRAM_BODY"); yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL: yWritePROC_DECL (yyt); yyIndentSelector ("PROC_BODY"); yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL: yWriteFUNC_DECL (yyt); yyIndentSelector ("RESULT_TYPE"); yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kMODULE_PROC_DECL: yWriteMODULE_PROC_DECL (yyt); goto yyExit;
case kBLOCK_DATA_DECL: yWriteBLOCK_DATA_DECL (yyt); yyIndentSelector ("DATA_BODY"); yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE: yWriteINTERFACE (yyt); yyIndentSelector ("ITEMS"); yyt = yyt->INTERFACE.ITEMS; break;
case kBODY_NODE: yWriteBODY_NODE (yyt); yyIndentSelector ("INTERNALS"); yyt = yyt->BODY_NODE.INTERNALS; break;
case kTYPE_NODE: (void) fputs (Tree_NodeName [kTYPE_NODE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_TYPE: (void) fputs (Tree_NodeName [kDUMMY_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kALIGN_TYPE: (void) fputs (Tree_NodeName [kALIGN_TYPE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kINTEGER_TYPE: yWriteINTEGER_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE: yWriteREAL_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE: yWriteBOOLEAN_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE: yWriteCOMPLEX_TYPE (yyt); yyIndentSelector ("SIZE"); yyt = yyt->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE: yWriteSTRING_TYPE (yyt); yyIndentSelector ("LENGTH"); yyt = yyt->STRING_TYPE.LENGTH; break;
case kTYPE_ID: yWriteTYPE_ID (yyt); yyIndentSelector ("ID"); yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE: yWriteARRAY_TYPE (yyt); yyIndentSelector ("ARRAY_COMP_TYPE"); yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE: yWriteRECORD_TYPE (yyt); yyIndentSelector ("COMPONENTS"); yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE: yWritePOINTER_TYPE (yyt); yyIndentSelector ("PTR_COMP"); yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC: yWriteSHAPE_SPEC (yyt); yyIndentSelector ("Overlap"); yyt = yyt->SHAPE_SPEC.Overlap; break;
case kEXPLICIT_SHAPE: yWriteEXPLICIT_SHAPE (yyt); yyIndentSelector ("UPPER"); yyt = yyt->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE: yWriteASSUMED_SHAPE (yyt); yyIndentSelector ("LOWER"); yyt = yyt->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE: yWriteDEFERRED_SHAPE (yyt); yyIndentSelector ("Overlap"); yyt = yyt->DEFERRED_SHAPE.Overlap; break;
case kASSUMED_SIZE: yWriteASSUMED_SIZE (yyt); yyIndentSelector ("LOWER"); yyt = yyt->ASSUMED_SIZE.LOWER; break;
case kSHAPE_SPEC_LIST: (void) fputs (Tree_NodeName [kSHAPE_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSHAPE_EMPTY: (void) fputs (Tree_NodeName [kSHAPE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSHAPE_LIST: yWriteSHAPE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SHAPE_LIST.Next; break;
case kDECL_NODE: yWriteDECL_NODE (yyt); goto yyExit;
case kTYPE_DECL: yWriteTYPE_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->TYPE_DECL.VAL; break;
case kNAME_DECL: yWriteNAME_DECL (yyt); goto yyExit;
case kRENAME_DECL: yWriteRENAME_DECL (yyt); goto yyExit;
case kENTITY_DECL: yWriteENTITY_DECL (yyt); yyIndentSelector ("ATTRIBUTES"); yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL: yWriteVAR_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL: yWriteCOMMON_DECL (yyt); yyIndentSelector ("IDS"); yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL: yWriteNAMELIST_DECL (yyt); yyIndentSelector ("IDS"); yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL: yWriteTEMPLATE_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL: yWriteRAGGED_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL: yWritePROCESSORS_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL: yWriteSUB_PROCS_DECL (yyt); yyIndentSelector ("DIMENSIONS"); yyt = yyt->SUB_PROCS_DECL.DIMENSIONS; break;
case kINHERIT_DECL: yWriteINHERIT_DECL (yyt); goto yyExit;
case kRANGE_DECL: yWriteRANGE_DECL (yyt); yyIndentSelector ("RANGES"); yyt = yyt->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL: yWriteSTMT_FUNC_DECL (yyt); yyIndentSelector ("FFUNC_BODY"); yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL: yWriteINTERFACE_DECL (yyt); yyIndentSelector ("ITEMS"); yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL: yWriteVAR_PARAM_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kRET_PARAM_DECL: yWriteRET_PARAM_DECL (yyt); goto yyExit;
case kIMPLICIT_DECL: yWriteIMPLICIT_DECL (yyt); yyIndentSelector ("TYPE"); yyt = yyt->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL: yWriteUSE_DECL (yyt); yyIndentSelector ("RENAMINGS"); yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL: yWriteONLY_USE_DECL (yyt); yyIndentSelector ("NAMES"); yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL: yWriteEQV_DECL (yyt); yyIndentSelector ("VARS"); yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL: yWriteDATA_DECL (yyt); yyIndentSelector ("VALS"); yyt = yyt->DATA_DECL.VALS; break;
case kFORMAT_DECL: yWriteFORMAT_DECL (yyt); yyIndentSelector ("FORMAT_PARAMS"); yyt = yyt->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL: yWriteDIMENSION_DECL (yyt); yyIndentSelector ("INDEXES"); yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL: yWriteINIT_DATA_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL: yWriteTYPESPEC_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->TYPESPEC_DECL.VAL; break;
case kALLOCATABLE_DECL: yWriteALLOCATABLE_DECL (yyt); goto yyExit;
case kEXTERNAL_DECL: yWriteEXTERNAL_DECL (yyt); goto yyExit;
case kINTENT_DECL: yWriteINTENT_DECL (yyt); goto yyExit;
case kINTRINSIC_DECL: yWriteINTRINSIC_DECL (yyt); goto yyExit;
case kOPTIONAL_DECL: yWriteOPTIONAL_DECL (yyt); goto yyExit;
case kPOINTER_DECL: yWritePOINTER_DECL (yyt); goto yyExit;
case kSAVE_DECL: yWriteSAVE_DECL (yyt); goto yyExit;
case kTARGET_DECL: yWriteTARGET_DECL (yyt); goto yyExit;
case kPARAMETER_DECL: yWritePARAMETER_DECL (yyt); yyIndentSelector ("VAL"); yyt = yyt->PARAMETER_DECL.VAL; break;
case kPUBLIC_DECL: yWritePUBLIC_DECL (yyt); goto yyExit;
case kPRIVATE_DECL: yWritePRIVATE_DECL (yyt); goto yyExit;
case kSEQUENCE_DECL: yWriteSEQUENCE_DECL (yyt); goto yyExit;
case kDISTRIBUTE_DECL: yWriteDISTRIBUTE_DECL (yyt); yyIndentSelector ("TARGET"); yyt = yyt->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL: yWriteALIGN_DECL (yyt); yyIndentSelector ("ALIGN_TARGET"); yyt = yyt->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL: yWriteMAP_DECL (yyt); yyIndentSelector ("MAP_TARGET"); yyt = yyt->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL: yWriteOVERLAP_DECL (yyt); yyIndentSelector ("OVERLAPS"); yyt = yyt->OVERLAP_DECL.OVERLAPS; break;
case kSHARED_DECL: yWriteSHARED_DECL (yyt); goto yyExit;
case kDYNAMIC_DECL: yWriteDYNAMIC_DECL (yyt); goto yyExit;
case kTRACE_DECL: yWriteTRACE_DECL (yyt); goto yyExit;
case kTREE_DECL: yWriteTREE_DECL (yyt); goto yyExit;
case kSELECT_DECL: yWriteSELECT_DECL (yyt); yyIndentSelector ("SELECTIONS"); yyt = yyt->SELECT_DECL.SELECTIONS; break;
case kHPF_SEQUENCE_DECL: yWriteHPF_SEQUENCE_DECL (yyt); goto yyExit;
case kNOSEQUENCE_DECL: yWriteNOSEQUENCE_DECL (yyt); goto yyExit;
case kLAYOUT_DECL: yWriteLAYOUT_DECL (yyt); goto yyExit;
case kPASS_BY_DECL: yWritePASS_BY_DECL (yyt); goto yyExit;
case kMAP_TO_DECL: yWriteMAP_TO_DECL (yyt); goto yyExit;
case kDECL_NODE_LIST: (void) fputs (Tree_NodeName [kDECL_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDECL_EMPTY: (void) fputs (Tree_NodeName [kDECL_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDECL_LIST: yWriteDECL_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->DECL_LIST.Next; break;
case kRANGE_SPEC_LIST: (void) fputs (Tree_NodeName [kRANGE_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRANGE_EMPTY: (void) fputs (Tree_NodeName [kRANGE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kRANGE_LIST: yWriteRANGE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->RANGE_LIST.Next; break;
case kSELECT_SPEC_LIST: (void) fputs (Tree_NodeName [kSELECT_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECT_EMPTY: (void) fputs (Tree_NodeName [kSELECT_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECT_LIST: yWriteSELECT_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SELECT_LIST.Next; break;
case kSELECT_SPEC: yWriteSELECT_SPEC (yyt); goto yyExit;
case kDISTRIBUTION_SPEC: yWriteDISTRIBUTION_SPEC (yyt); goto yyExit;
case kANY_DISTRIBUTION: yWriteANY_DISTRIBUTION (yyt); goto yyExit;
case kDEFAULT_DISTRIBUTION: yWriteDEFAULT_DISTRIBUTION (yyt); goto yyExit;
case kREPL_DISTRIBUTION: yWriteREPL_DISTRIBUTION (yyt); goto yyExit;
case kNODE_DISTRIBUTION: yWriteNODE_DISTRIBUTION (yyt); yyIndentSelector ("MAPPING"); yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_FORMAT_LIST: (void) fputs (Tree_NodeName [kDIST_FORMAT_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_EMPTY: (void) fputs (Tree_NodeName [kDIST_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDIST_LIST: yWriteDIST_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->DIST_LIST.Next; break;
case kDISTRIBUTION_FORMAT: (void) fputs (Tree_NodeName [kDISTRIBUTION_FORMAT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBLOCK_DISTRIBUTION: yWriteBLOCK_DISTRIBUTION (yyt); yyIndentSelector ("SIZE"); yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION: yWriteCYCLIC_DISTRIBUTION (yyt); yyIndentSelector ("SIZE"); yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION: yWriteGEN_BLOCK_DISTRIBUTION (yyt); yyIndentSelector ("ARRAY"); yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION: yWriteINDIRECT_DISTRIBUTION (yyt); yyIndentSelector ("ARRAY"); yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION: yWriteARBITRARY_DISTRIBUTION (yyt); yyIndentSelector ("MAP"); yyt = yyt->ARBITRARY_DISTRIBUTION.MAP; break;
case kSERIAL_DISTRIBUTION: (void) fputs (Tree_NodeName [kSERIAL_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_CYCLIC_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_CYCLIC_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_GEN_BLOCK_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_GEN_BLOCK_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_INDIRECT_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_INDIRECT_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_ARBITRARY_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_ARBITRARY_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_DIM_DISTRIBUTION: (void) fputs (Tree_NodeName [kANY_DIM_DISTRIBUTION], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kPROCESSOR_SPEC: (void) fputs (Tree_NodeName [kPROCESSOR_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kANY_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kANY_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDEFAULT_PROCESSOR_ARRAY: (void) fputs (Tree_NodeName [kDEFAULT_PROCESSOR_ARRAY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kPROCESSOR_ARRAY: yWritePROCESSOR_ARRAY (yyt); yyIndentSelector ("TOPNAME"); yyt = yyt->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET: yWritePROCESSOR_SUBSET (yyt); yyIndentSelector ("SUBSCRIPTS"); yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC: yWriteALIGN_SPEC (yyt); yyIndentSelector ("SUBSCRIPTS"); yyt = yyt->ALIGN_SPEC.SUBSCRIPTS; break;
case kGENERIC_SPEC: (void) fputs (Tree_NodeName [kGENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNO_GENERIC_SPEC: (void) fputs (Tree_NodeName [kNO_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kID_GENERIC_SPEC: yWriteID_GENERIC_SPEC (yyt); goto yyExit;
case kOP_GENERIC_SPEC: yWriteOP_GENERIC_SPEC (yyt); yyIndentSelector ("OPERATOR"); yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kASSIGN_GENERIC_SPEC: (void) fputs (Tree_NodeName [kASSIGN_GENERIC_SPEC], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_NODE_LIST: (void) fputs (Tree_NodeName [kACF_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_EMPTY: (void) fputs (Tree_NodeName [kACF_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_LIST: yWriteACF_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->ACF_LIST.Next; break;
case kACF_NODE: yWriteACF_NODE (yyt); goto yyExit;
case kACF_DUMMY: yWriteACF_DUMMY (yyt); goto yyExit;
case kACF_BASIC: yWriteACF_BASIC (yyt); yyIndentSelector ("BASIC_STMT"); yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF: yWriteACF_IF (yyt); yyIndentSelector ("ELSE_PART"); yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE: yWriteACF_WHERE (yyt); yyIndentSelector ("FALSE_PART"); yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_CASE: yWriteACF_CASE (yyt); yyIndentSelector ("CASE_ALTS"); yyt = yyt->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE: yWriteACF_WHILE (yyt); yyIndentSelector ("WHILE_BODY"); yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT: yWriteACF_REPEAT (yyt); yyIndentSelector ("REPEAT_EXP"); yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP: yWriteACF_LOOP (yyt); yyIndentSelector ("LOOP_BODY"); yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO: yWriteACF_DO (yyt); yyIndentSelector ("DO_HOME_INFO"); yyt = yyt->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL: yWriteACF_FORALL (yyt); yyIndentSelector ("FORALL_HOME_INFO"); yyt = yyt->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH: yWriteACF_FLOW_GRAPH (yyt); yyIndentSelector ("FLOW_NODES"); yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY: yWriteACF_ENTRY (yyt); yyIndentSelector ("ENTRY_DECL"); yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME: yWriteACF_HOME (yyt); yyIndentSelector ("HOME_BODY"); yyt = yyt->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT: yWriteACF_RESIDENT (yyt); yyIndentSelector ("RESIDENT_BODY"); yyt = yyt->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW: yWriteACF_NEW (yyt); yyIndentSelector ("NEW_BODY"); yyt = yyt->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION: yWriteACF_REDUCTION (yyt); yyIndentSelector ("REDUCTION_BODY"); yyt = yyt->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION: yWriteACF_TASK_REGION (yyt); yyIndentSelector ("TASK_BODY"); yyt = yyt->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL: yWriteACF_PARALLEL (yyt); yyIndentSelector ("PARALLEL_BODY"); yyt = yyt->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL: yWriteACF_CRITICAL (yyt); yyIndentSelector ("CRITICAL_BODY"); yyt = yyt->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON: yWriteACF_ON (yyt); yyIndentSelector ("ON_BODY"); yyt = yyt->ACF_ON.ON_BODY; break;
case kACF_RM_READ: yWriteACF_RM_READ (yyt); yyIndentSelector ("REMOTE_VAR"); yyt = yyt->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE: yWriteACF_RM_WRITE (yyt); yyIndentSelector ("LOCAL_DATA"); yyt = yyt->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE: yWriteACF_MOVE (yyt); yyIndentSelector ("MOVE_STMT"); yyt = yyt->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER: yWriteACF_BARRIER (yyt); yyIndentSelector ("BARRIER_VARS"); yyt = yyt->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE: yWriteACF_UPDATE (yyt); yyIndentSelector ("OVERLAP_VAR"); yyt = yyt->ACF_UPDATE.OVERLAP_VAR; break;
case kACF_FLOW_KIND: (void) fputs (Tree_NodeName [kACF_FLOW_KIND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_COMPLEX_FLOW: (void) fputs (Tree_NodeName [kACF_COMPLEX_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_INTERVAL_FLOW: (void) fputs (Tree_NodeName [kACF_INTERVAL_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kACF_SIMPLE_FLOW: (void) fputs (Tree_NodeName [kACF_SIMPLE_FLOW], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_CLAUSE: (void) fputs (Tree_NodeName [kON_CLAUSE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_HOST_CLAUSE: (void) fputs (Tree_NodeName [kON_HOST_CLAUSE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_ALL_CLAUSE: (void) fputs (Tree_NodeName [kON_ALL_CLAUSE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_VAR_CLAUSE: yWriteON_VAR_CLAUSE (yyt); yyIndentSelector ("ON_VAR"); yyt = yyt->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE: yWriteON_PROC_CLAUSE (yyt); yyIndentSelector ("ON_PROC"); yyt = yyt->ON_PROC_CLAUSE.ON_PROC; break;
case kON_TOPOLOGY: (void) fputs (Tree_NodeName [kON_TOPOLOGY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_ALL: (void) fputs (Tree_NodeName [kON_ALL], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_HOST: (void) fputs (Tree_NodeName [kON_HOST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_PROCS: yWriteON_PROCS (yyt); goto yyExit;
case kON_VAR: yWriteON_VAR (yyt); goto yyExit;
case kON_SPEC_LIST: (void) fputs (Tree_NodeName [kON_SPEC_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_EMPTY: (void) fputs (Tree_NodeName [kON_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kON_LIST: yWriteON_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->ON_LIST.Next; break;
case kON_SPEC: yWriteON_SPEC (yyt); yyIndentSelector ("ON_VAL"); yyt = yyt->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_NODE_LIST: (void) fputs (Tree_NodeName [kSELECTED_ACF_NODE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_EMPTY: (void) fputs (Tree_NodeName [kSELECTED_ACF_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSELECTED_ACF_LIST: yWriteSELECTED_ACF_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE: yWriteSELECTED_ACF_NODE (yyt); yyIndentSelector ("SELECT_ACFS"); yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kBT_STMT: (void) fputs (Tree_NodeName [kBT_STMT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kASSIGN_STMT: yWriteASSIGN_STMT (yyt); yyIndentSelector ("ASSIGN_EXP"); yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT: yWritePTR_ASSIGN_STMT (yyt); yyIndentSelector ("ASSIGN_EXP"); yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT: yWriteLABEL_ASSIGN_STMT (yyt); yyIndentSelector ("LABEL_VAR"); yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT: yWriteCALL_STMT (yyt); yyIndentSelector ("CALL_PARAMS"); yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT: yWriteIO_STMT (yyt); yyIndentSelector ("IO_ITEMS"); yyt = yyt->IO_STMT.IO_ITEMS; break;
case kGOTO_STMT: yWriteGOTO_STMT (yyt); goto yyExit;
case kASS_GOTO_STMT: yWriteASS_GOTO_STMT (yyt); yyIndentSelector ("LABELS"); yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT: yWriteCOMP_GOTO_STMT (yyt); yyIndentSelector ("GOTO_EXP"); yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT: yWriteCOMP_IF_STMT (yyt); yyIndentSelector ("IF_EXP"); yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT: yWriteRETURN_STMT (yyt); yyIndentSelector ("RETURN_EXP"); yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT: yWritePAUSE_STMT (yyt); yyIndentSelector ("PAUSE_CONST"); yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kEXIT_STMT: yWriteEXIT_STMT (yyt); goto yyExit;
case kCYCLE_STMT: yWriteCYCLE_STMT (yyt); goto yyExit;
case kSTOP_STMT: yWriteSTOP_STMT (yyt); yyIndentSelector ("STOP_CONST"); yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT: yWriteFORMAT_STMT (yyt); yyIndentSelector ("FORMAT_PARAMS"); yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT: yWriteINHERIT_DSP_STMT (yyt); yyIndentSelector ("SHAPE"); yyt = yyt->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT: yWriteCREATE_DSP_STMT (yyt); yyIndentSelector ("SHAPE"); yyt = yyt->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT: yWriteFREE_DSP_STMT (yyt); yyIndentSelector ("VAR"); yyt = yyt->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT: yWriteALLOCATE_STMT (yyt); yyIndentSelector ("STATUS"); yyt = yyt->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT: yWriteDEALLOCATE_STMT (yyt); yyIndentSelector ("STATUS"); yyt = yyt->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT: yWriteNULLIFY_STMT (yyt); yyIndentSelector ("PARAMS"); yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT: yWriteREDUCE_STMT (yyt); yyIndentSelector ("RED_PARAMS"); yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT: yWriteMOVE_STMT (yyt); yyIndentSelector ("MASK"); yyt = yyt->MOVE_STMT.MASK; break;
case kSCATTER_STMT: yWriteSCATTER_STMT (yyt); yyIndentSelector ("MASK"); yyt = yyt->SCATTER_STMT.MASK; break;
case kREALIGN_STMT: yWriteREALIGN_STMT (yyt); yyIndentSelector ("ALIGN_TARGET"); yyt = yyt->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT: yWriteREDISTRIBUTE_STMT (yyt); yyIndentSelector ("TARGET"); yyt = yyt->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET: yWriteREG_SHADOW_GET (yyt); yyIndentSelector ("SHADOW_SIZE"); yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT: yWriteREG_SHADOW_PUT (yyt); yyIndentSelector ("SHADOW_SIZE"); yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET: yWriteREG_SHADOW_SET (yyt); yyIndentSelector ("VAL"); yyt = yyt->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE: yWriteIND_SHADOW_CREATE (yyt); yyIndentSelector ("MASK"); yyt = yyt->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE: yWriteIND_SHADOW_FREE (yyt); yyIndentSelector ("INDEX_VAR"); yyt = yyt->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET: yWriteIND_SHADOW_GET (yyt); yyIndentSelector ("SHADOW_VAR"); yyt = yyt->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT: yWriteIND_SHADOW_PUT (yyt); yyIndentSelector ("SHADOW_VAR"); yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET: yWriteIND_SHADOW_SET (yyt); yyIndentSelector ("VAL"); yyt = yyt->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT: yWriteBROADCAST_STMT (yyt); yyIndentSelector ("OWNER_SPEC"); yyt = yyt->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT: yWriteREDUCTION_STMT (yyt); yyIndentSelector ("RED_SPEC"); yyt = yyt->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT: yWriteDIRTY_STMT (yyt); yyIndentSelector ("ELEMS"); yyt = yyt->DIRTY_STMT.ELEMS; break;
case kLABEL_USE_LIST: (void) fputs (Tree_NodeName [kLABEL_USE_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLABEL_EMPTY: (void) fputs (Tree_NodeName [kLABEL_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kLABEL_LIST: yWriteLABEL_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->LABEL_LIST.Next; break;
case kOP: (void) fputs (Tree_NodeName [kOP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EQ: (void) fputs (Tree_NodeName [kOP_EQ], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_NE: (void) fputs (Tree_NodeName [kOP_NE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LT: (void) fputs (Tree_NodeName [kOP_LT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_GT: (void) fputs (Tree_NodeName [kOP_GT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_GE: (void) fputs (Tree_NodeName [kOP_GE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_LE: (void) fputs (Tree_NodeName [kOP_LE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_PLUS: (void) fputs (Tree_NodeName [kOP_PLUS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_MINUS: (void) fputs (Tree_NodeName [kOP_MINUS], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_XOR: (void) fputs (Tree_NodeName [kOP_XOR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_OR: (void) fputs (Tree_NodeName [kOP_OR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_CONCAT: (void) fputs (Tree_NodeName [kOP_CONCAT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_TIMES: (void) fputs (Tree_NodeName [kOP_TIMES], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DIVIDE: (void) fputs (Tree_NodeName [kOP_DIVIDE], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_AND: (void) fputs (Tree_NodeName [kOP_AND], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EQV: (void) fputs (Tree_NodeName [kOP_EQV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_NEQV: (void) fputs (Tree_NodeName [kOP_NEQV], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_EXPO: (void) fputs (Tree_NodeName [kOP_EXPO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP_DEFINED: yWriteOP_DEFINED (yyt); goto yyExit;
case kOP_ASSIGN: (void) fputs (Tree_NodeName [kOP_ASSIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_NOT: (void) fputs (Tree_NodeName [kOP1_NOT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_SIGN: (void) fputs (Tree_NodeName [kOP1_SIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kOP1_PSIGN: (void) fputs (Tree_NodeName [kOP1_PSIGN], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBT_EXP: (void) fputs (Tree_NodeName [kBT_EXP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_EXP: (void) fputs (Tree_NodeName [kDUMMY_EXP], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCONST_EXP: yWriteCONST_EXP (yyt); yyIndentSelector ("C"); yyt = yyt->CONST_EXP.C; break;
case kOP_EXP: yWriteOP_EXP (yyt); yyIndentSelector ("OPND2"); yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP: yWriteOP1_EXP (yyt); yyIndentSelector ("OPND"); yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP: yWriteSLICE_EXP (yyt); yyIndentSelector ("INC"); yyt = yyt->SLICE_EXP.INC; break;
case kVAR_EXP: yWriteVAR_EXP (yyt); yyIndentSelector ("V"); yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP: yWriteFUNC_CALL_EXP (yyt); yyIndentSelector ("FUNC_PARAMS"); yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP: yWriteNAMED_EXP (yyt); yyIndentSelector ("VAL"); yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP: yWriteDO_EXP (yyt); yyIndentSelector ("BODY"); yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP: yWriteTYPE_EXP (yyt); yyIndentSelector ("ELEMENTS"); yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP: yWriteARRAY_EXP (yyt); yyIndentSelector ("ELEMENTS"); yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP: yWritePERM_EXP (yyt); yyIndentSelector ("VAL"); yyt = yyt->PERM_EXP.VAL; break;
case kBOUND_EXP: yWriteBOUND_EXP (yyt); yyIndentSelector ("VAR"); yyt = yyt->BOUND_EXP.VAR; break;
case kRANK_EXP: yWriteRANK_EXP (yyt); goto yyExit;
case kBT_EXP_LIST: (void) fputs (Tree_NodeName [kBT_EXP_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTE_EMPTY: (void) fputs (Tree_NodeName [kBTE_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTE_LIST: yWriteBTE_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTE_LIST.Next; break;
case kBT_VAR: (void) fputs (Tree_NodeName [kBT_VAR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kDUMMY_VAR: (void) fputs (Tree_NodeName [kDUMMY_VAR], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kUSED_VAR: yWriteUSED_VAR (yyt); yyIndentSelector ("VARNAME"); yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR: yWriteINDEXED_VAR (yyt); yyIndentSelector ("IND_EXPS"); yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR: yWriteSUBSTRING_VAR (yyt); yyIndentSelector ("IND_EXP"); yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR: yWriteSELECTED_VAR (yyt); yyIndentSelector ("SELECTOR"); yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR: yWriteLOOP_VAR (yyt); yyIndentSelector ("LOOP_VARNAME"); yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR: yWritePERM_VAR (yyt); yyIndentSelector ("VAL"); yyt = yyt->PERM_VAR.VAL; break;
case kADDR: yWriteADDR (yyt); yyIndentSelector ("E"); yyt = yyt->ADDR.E; break;
case kDO_VAR: yWriteDO_VAR (yyt); yyIndentSelector ("BODY"); yyt = yyt->DO_VAR.BODY; break;
case kREMOTE_VAR: yWriteREMOTE_VAR (yyt); yyIndentSelector ("VAR"); yyt = yyt->REMOTE_VAR.VAR; break;
case kBT_VAR_LIST: (void) fputs (Tree_NodeName [kBT_VAR_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTV_EMPTY: (void) fputs (Tree_NodeName [kBTV_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTV_LIST: yWriteBTV_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTV_LIST.Next; break;
case kBT_PARAM: (void) fputs (Tree_NodeName [kBT_PARAM], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kVAR_PARAM: yWriteVAR_PARAM (yyt); yyIndentSelector ("V"); yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM: yWriteVALUE_PARAM (yyt); yyIndentSelector ("E"); yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM: yWriteNAMED_PARAM (yyt); yyIndentSelector ("VAL"); yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM: yWritePROC_PARAM (yyt); yyIndentSelector ("P"); yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM: yWriteFUNC_PARAM (yyt); yyIndentSelector ("F"); yyt = yyt->FUNC_PARAM.F; break;
case kFORMAT_PARAM: yWriteFORMAT_PARAM (yyt); goto yyExit;
case kRETURN_PARAM: yWriteRETURN_PARAM (yyt); goto yyExit;
case kNO_PARAM: yWriteNO_PARAM (yyt); goto yyExit;
case kBT_PARAM_LIST: (void) fputs (Tree_NodeName [kBT_PARAM_LIST], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTP_EMPTY: (void) fputs (Tree_NodeName [kBTP_EMPTY], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBTP_LIST: yWriteBTP_LIST (yyt); yyIndentSelector ("Next"); yyt = yyt->BTP_LIST.Next; break;
case kCONSTANT: (void) fputs (Tree_NodeName [kCONSTANT], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kBOOL_CONSTANT: yWriteBOOL_CONSTANT (yyt); goto yyExit;
case kINT_CONSTANT: yWriteINT_CONSTANT (yyt); goto yyExit;
case kREAL_CONSTANT: yWriteREAL_CONSTANT (yyt); goto yyExit;
case kSTRING_CONSTANT: yWriteSTRING_CONSTANT (yyt); goto yyExit;
case kCOMPLEX_CONSTANT: yWriteCOMPLEX_CONSTANT (yyt); goto yyExit;
case kPROC_OBJ: yWritePROC_OBJ (yyt); goto yyExit;
case kVAR_OBJ: yWriteVAR_OBJ (yyt); goto yyExit;
case kTYPE_OBJ: yWriteTYPE_OBJ (yyt); goto yyExit;
case kREC_COMP: yWriteREC_COMP (yyt); goto yyExit;
case kTOP_OBJ: yWriteTOP_OBJ (yyt); goto yyExit;
case kTEMP_OBJ: yWriteTEMP_OBJ (yyt); goto yyExit;
case kOVERLAP_SPEC: yWriteOVERLAP_SPEC (yyt); goto yyExit;
case kDEPENDENCE_INFO: (void) fputs (Tree_NodeName [kDEPENDENCE_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kSERIAL_INFO: (void) fputs (Tree_NodeName [kSERIAL_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kINDEP_INFO: yWriteINDEP_INFO (yyt); goto yyExit;
case kVECTOR_INFO: yWriteVECTOR_INFO (yyt); goto yyExit;
case kPARDO_INFO: (void) fputs (Tree_NodeName [kPARDO_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kHOME_INFO: (void) fputs (Tree_NodeName [kHOME_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kNO_HOME_INFO: (void) fputs (Tree_NodeName [kNO_HOME_INFO], yyf); (void) fputc ('\n', yyf); goto yyExit;
case kCOMM_INFO: yWriteCOMM_INFO (yyt); goto yyExit;
case kON_INFO: yWriteON_INFO (yyt); goto yyExit;
case kPARALLEL_INFO: yWritePARALLEL_INFO (yyt); goto yyExit;
case kREACHING_INFO: yWriteREACHING_INFO (yyt); goto yyExit;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

static void yyPut
# if defined __STDC__ | defined __cplusplus
 (char * yyx, int yysize)
# else
 (yyx, yysize) char * yyx; int yysize;
# endif
{ (void) fwrite (yyx, 1, yysize, yyf); }

static void yyPutIdent
# if defined __STDC__ | defined __cplusplus
 (tIdent yyi)
# else
 (yyi) tIdent yyi;
# endif
{
 char yys [256];
 GetString (yyi, (tString) yys);
 (void) fprintf (yyf, "%s\n", yys);
}

static void yyPutTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 for (;;) {
  if (yyt == NoTree) {
   (void) putc (yyNil, yyf); return;
  } else if (yyt->yyHead.yyMark == 0) {
   (void) putc (yyLabelUse, yyf); yyLabel = yyMapToLabel (yyt); yyPut ((char *) & yyLabel, sizeof (yyLabel)); return;
  } else if (yyt->yyHead.yyMark > 1) {
   (void) putc (yyLabelDef, yyf); yyLabel = yyMapToLabel (yyt); yyPut ((char *) & yyLabel, sizeof (yyLabel));
   yyPut ((char *) & yyt->Kind, sizeof (Tree_tKind));
  } else if (yyt->Kind > 251) {
   (void) putc (yyNoLabel, yyf); yyPut ((char *) & yyt->Kind, sizeof (Tree_tKind));
  } else {
   (void) putc ((char) yyt->Kind, yyf);
  }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kCOMP_UNIT:
puttTree (yyt->COMP_UNIT.COMP_ELEMENTS)
yyt = yyt->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_LIST:
puttTree (yyt->UNIT_LIST.Elem)
yyt = yyt->UNIT_LIST.Next; break;
case kUNIT_NODE:
puttIdent (yyt->UNIT_NODE.Ident)
putint (yyt->UNIT_NODE.Line)
puttDefinitions (yyt->UNIT_NODE.Object)
return;
case kMODULE_DECL:
puttIdent (yyt->MODULE_DECL.Ident)
putint (yyt->MODULE_DECL.Line)
puttDefinitions (yyt->MODULE_DECL.Object)
yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL:
puttIdent (yyt->PROGRAM_DECL.Ident)
putint (yyt->PROGRAM_DECL.Line)
puttDefinitions (yyt->PROGRAM_DECL.Object)
puttTree (yyt->PROGRAM_DECL.FORMALS)
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL:
puttIdent (yyt->PROC_DECL.Ident)
putint (yyt->PROC_DECL.Line)
puttDefinitions (yyt->PROC_DECL.Object)
puttTree (yyt->PROC_DECL.FORMALS)
putbool (yyt->PROC_DECL.IsRecursive)
putbool (yyt->PROC_DECL.IsPure)
puttIdent (yyt->PROC_DECL.HPFExtrinsic)
yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL:
puttIdent (yyt->FUNC_DECL.Ident)
putint (yyt->FUNC_DECL.Line)
puttDefinitions (yyt->FUNC_DECL.Object)
puttTree (yyt->FUNC_DECL.FORMALS)
puttTree (yyt->FUNC_DECL.FUNC_BODY)
puttIdent (yyt->FUNC_DECL.RESULT_ID)
putbool (yyt->FUNC_DECL.IsRecursive)
putbool (yyt->FUNC_DECL.IsPure)
puttIdent (yyt->FUNC_DECL.HPFExtrinsic)
yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kMODULE_PROC_DECL:
puttIdent (yyt->MODULE_PROC_DECL.Ident)
putint (yyt->MODULE_PROC_DECL.Line)
puttDefinitions (yyt->MODULE_PROC_DECL.Object)
return;
case kBLOCK_DATA_DECL:
puttIdent (yyt->BLOCK_DATA_DECL.Ident)
putint (yyt->BLOCK_DATA_DECL.Line)
puttDefinitions (yyt->BLOCK_DATA_DECL.Object)
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE:
puttIdent (yyt->INTERFACE.Ident)
putint (yyt->INTERFACE.Line)
puttDefinitions (yyt->INTERFACE.Object)
puttTree (yyt->INTERFACE.SPEC)
yyt = yyt->INTERFACE.ITEMS; break;
case kBODY_NODE:
puttTree (yyt->BODY_NODE.DECLS)
puttTree (yyt->BODY_NODE.STATS)
yyt = yyt->BODY_NODE.INTERNALS; break;
case kINTEGER_TYPE:
yyt = yyt->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE:
yyt = yyt->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE:
yyt = yyt->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE:
yyt = yyt->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE:
yyt = yyt->STRING_TYPE.LENGTH; break;
case kTYPE_ID:
yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE:
puttTree (yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES)
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE:
puttIdent (yyt->RECORD_TYPE.Name)
yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE:
yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC:
yyt = yyt->SHAPE_SPEC.Overlap; break;
case kEXPLICIT_SHAPE:
puttTree (yyt->EXPLICIT_SHAPE.Overlap)
puttTree (yyt->EXPLICIT_SHAPE.LOWER)
yyt = yyt->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE:
puttTree (yyt->ASSUMED_SHAPE.Overlap)
yyt = yyt->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE:
yyt = yyt->DEFERRED_SHAPE.Overlap; break;
case kASSUMED_SIZE:
puttTree (yyt->ASSUMED_SIZE.Overlap)
yyt = yyt->ASSUMED_SIZE.LOWER; break;
case kSHAPE_LIST:
puttTree (yyt->SHAPE_LIST.Elem)
yyt = yyt->SHAPE_LIST.Next; break;
case kDECL_NODE:
puttIdent (yyt->DECL_NODE.Ident)
putint (yyt->DECL_NODE.Line)
return;
case kTYPE_DECL:
puttIdent (yyt->TYPE_DECL.Ident)
putint (yyt->TYPE_DECL.Line)
yyt = yyt->TYPE_DECL.VAL; break;
case kNAME_DECL:
puttIdent (yyt->NAME_DECL.Ident)
putint (yyt->NAME_DECL.Line)
return;
case kRENAME_DECL:
puttIdent (yyt->RENAME_DECL.Ident)
putint (yyt->RENAME_DECL.Line)
puttIdent (yyt->RENAME_DECL.oldname)
return;
case kENTITY_DECL:
puttIdent (yyt->ENTITY_DECL.Ident)
putint (yyt->ENTITY_DECL.Line)
yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL:
puttIdent (yyt->VAR_DECL.Ident)
putint (yyt->VAR_DECL.Line)
yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL:
puttIdent (yyt->COMMON_DECL.Ident)
putint (yyt->COMMON_DECL.Line)
yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL:
puttIdent (yyt->NAMELIST_DECL.Ident)
putint (yyt->NAMELIST_DECL.Line)
yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL:
puttIdent (yyt->TEMPLATE_DECL.Ident)
putint (yyt->TEMPLATE_DECL.Line)
yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL:
puttIdent (yyt->RAGGED_DECL.Ident)
putint (yyt->RAGGED_DECL.Line)
yyt = yyt->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL:
puttIdent (yyt->PROCESSORS_DECL.Ident)
putint (yyt->PROCESSORS_DECL.Line)
yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL:
puttIdent (yyt->SUB_PROCS_DECL.Ident)
putint (yyt->SUB_PROCS_DECL.Line)
puttTree (yyt->SUB_PROCS_DECL.TOP)
yyt = yyt->SUB_PROCS_DECL.DIMENSIONS; break;
case kINHERIT_DECL:
puttIdent (yyt->INHERIT_DECL.Ident)
putint (yyt->INHERIT_DECL.Line)
return;
case kRANGE_DECL:
puttIdent (yyt->RANGE_DECL.Ident)
putint (yyt->RANGE_DECL.Line)
yyt = yyt->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL:
puttIdent (yyt->STMT_FUNC_DECL.Ident)
putint (yyt->STMT_FUNC_DECL.Line)
puttTree (yyt->STMT_FUNC_DECL.FORMALS)
puttTree (yyt->STMT_FUNC_DECL.RESULT_TYPE)
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL:
puttIdent (yyt->INTERFACE_DECL.Ident)
putint (yyt->INTERFACE_DECL.Line)
puttTree (yyt->INTERFACE_DECL.SPEC)
yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL:
puttIdent (yyt->VAR_PARAM_DECL.Ident)
putint (yyt->VAR_PARAM_DECL.Line)
yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kRET_PARAM_DECL:
puttIdent (yyt->RET_PARAM_DECL.Ident)
putint (yyt->RET_PARAM_DECL.Line)
return;
case kIMPLICIT_DECL:
puttIdent (yyt->IMPLICIT_DECL.Ident)
putint (yyt->IMPLICIT_DECL.Line)
puttIdent (yyt->IMPLICIT_DECL.first)
puttIdent (yyt->IMPLICIT_DECL.last)
yyt = yyt->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL:
puttIdent (yyt->USE_DECL.Ident)
putint (yyt->USE_DECL.Line)
puttIdent (yyt->USE_DECL.use)
yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL:
puttIdent (yyt->ONLY_USE_DECL.Ident)
putint (yyt->ONLY_USE_DECL.Line)
puttIdent (yyt->ONLY_USE_DECL.use)
yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL:
puttIdent (yyt->EQV_DECL.Ident)
putint (yyt->EQV_DECL.Line)
yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL:
puttIdent (yyt->DATA_DECL.Ident)
putint (yyt->DATA_DECL.Line)
puttTree (yyt->DATA_DECL.VARS)
yyt = yyt->DATA_DECL.VALS; break;
case kFORMAT_DECL:
puttIdent (yyt->FORMAT_DECL.Ident)
putint (yyt->FORMAT_DECL.Line)
putint (yyt->FORMAT_DECL.label)
yyt = yyt->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL:
puttIdent (yyt->DIMENSION_DECL.Ident)
putint (yyt->DIMENSION_DECL.Line)
yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL:
puttIdent (yyt->INIT_DATA_DECL.Ident)
putint (yyt->INIT_DATA_DECL.Line)
yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL:
puttIdent (yyt->TYPESPEC_DECL.Ident)
putint (yyt->TYPESPEC_DECL.Line)
yyt = yyt->TYPESPEC_DECL.VAL; break;
case kALLOCATABLE_DECL:
puttIdent (yyt->ALLOCATABLE_DECL.Ident)
putint (yyt->ALLOCATABLE_DECL.Line)
return;
case kEXTERNAL_DECL:
puttIdent (yyt->EXTERNAL_DECL.Ident)
putint (yyt->EXTERNAL_DECL.Line)
return;
case kINTENT_DECL:
puttIdent (yyt->INTENT_DECL.Ident)
putint (yyt->INTENT_DECL.Line)
putint (yyt->INTENT_DECL.intent)
return;
case kINTRINSIC_DECL:
puttIdent (yyt->INTRINSIC_DECL.Ident)
putint (yyt->INTRINSIC_DECL.Line)
puttIdent (yyt->INTRINSIC_DECL.generic)
putint (yyt->INTRINSIC_DECL.class)
putint (yyt->INTRINSIC_DECL.kind)
return;
case kOPTIONAL_DECL:
puttIdent (yyt->OPTIONAL_DECL.Ident)
putint (yyt->OPTIONAL_DECL.Line)
return;
case kPOINTER_DECL:
puttIdent (yyt->POINTER_DECL.Ident)
putint (yyt->POINTER_DECL.Line)
return;
case kSAVE_DECL:
puttIdent (yyt->SAVE_DECL.Ident)
putint (yyt->SAVE_DECL.Line)
return;
case kTARGET_DECL:
puttIdent (yyt->TARGET_DECL.Ident)
putint (yyt->TARGET_DECL.Line)
return;
case kPARAMETER_DECL:
puttIdent (yyt->PARAMETER_DECL.Ident)
putint (yyt->PARAMETER_DECL.Line)
yyt = yyt->PARAMETER_DECL.VAL; break;
case kPUBLIC_DECL:
puttIdent (yyt->PUBLIC_DECL.Ident)
putint (yyt->PUBLIC_DECL.Line)
return;
case kPRIVATE_DECL:
puttIdent (yyt->PRIVATE_DECL.Ident)
putint (yyt->PRIVATE_DECL.Line)
return;
case kSEQUENCE_DECL:
puttIdent (yyt->SEQUENCE_DECL.Ident)
putint (yyt->SEQUENCE_DECL.Line)
return;
case kDISTRIBUTE_DECL:
puttIdent (yyt->DISTRIBUTE_DECL.Ident)
putint (yyt->DISTRIBUTE_DECL.Line)
puttTree (yyt->DISTRIBUTE_DECL.DISTRIBUTION)
yyt = yyt->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL:
puttIdent (yyt->ALIGN_DECL.Ident)
putint (yyt->ALIGN_DECL.Line)
puttTree (yyt->ALIGN_DECL.ALIGN_SOURCE)
yyt = yyt->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL:
puttIdent (yyt->MAP_DECL.Ident)
putint (yyt->MAP_DECL.Line)
yyt = yyt->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL:
puttIdent (yyt->OVERLAP_DECL.Ident)
putint (yyt->OVERLAP_DECL.Line)
yyt = yyt->OVERLAP_DECL.OVERLAPS; break;
case kSHARED_DECL:
puttIdent (yyt->SHARED_DECL.Ident)
putint (yyt->SHARED_DECL.Line)
putint (yyt->SHARED_DECL.kind)
return;
case kDYNAMIC_DECL:
puttIdent (yyt->DYNAMIC_DECL.Ident)
putint (yyt->DYNAMIC_DECL.Line)
return;
case kTRACE_DECL:
puttIdent (yyt->TRACE_DECL.Ident)
putint (yyt->TRACE_DECL.Line)
return;
case kTREE_DECL:
puttIdent (yyt->TREE_DECL.Ident)
putint (yyt->TREE_DECL.Line)
return;
case kSELECT_DECL:
puttIdent (yyt->SELECT_DECL.Ident)
putint (yyt->SELECT_DECL.Line)
yyt = yyt->SELECT_DECL.SELECTIONS; break;
case kHPF_SEQUENCE_DECL:
puttIdent (yyt->HPF_SEQUENCE_DECL.Ident)
putint (yyt->HPF_SEQUENCE_DECL.Line)
return;
case kNOSEQUENCE_DECL:
puttIdent (yyt->NOSEQUENCE_DECL.Ident)
putint (yyt->NOSEQUENCE_DECL.Line)
return;
case kLAYOUT_DECL:
puttIdent (yyt->LAYOUT_DECL.Ident)
putint (yyt->LAYOUT_DECL.Line)
puttStringRef (yyt->LAYOUT_DECL.kind)
return;
case kPASS_BY_DECL:
puttIdent (yyt->PASS_BY_DECL.Ident)
putint (yyt->PASS_BY_DECL.Line)
puttStringRef (yyt->PASS_BY_DECL.kind)
return;
case kMAP_TO_DECL:
puttIdent (yyt->MAP_TO_DECL.Ident)
putint (yyt->MAP_TO_DECL.Line)
puttStringRef (yyt->MAP_TO_DECL.kind)
return;
case kDECL_LIST:
puttTree (yyt->DECL_LIST.Elem)
yyt = yyt->DECL_LIST.Next; break;
case kRANGE_LIST:
puttTree (yyt->RANGE_LIST.Elem)
yyt = yyt->RANGE_LIST.Next; break;
case kSELECT_LIST:
puttTree (yyt->SELECT_LIST.Elem)
yyt = yyt->SELECT_LIST.Next; break;
case kSELECT_SPEC:
putint (yyt->SELECT_SPEC.selector)
return;
case kDISTRIBUTION_SPEC:
putint (yyt->DISTRIBUTION_SPEC.is_descriptive)
return;
case kANY_DISTRIBUTION:
putint (yyt->ANY_DISTRIBUTION.is_descriptive)
return;
case kDEFAULT_DISTRIBUTION:
putint (yyt->DEFAULT_DISTRIBUTION.is_descriptive)
return;
case kREPL_DISTRIBUTION:
putint (yyt->REPL_DISTRIBUTION.is_descriptive)
return;
case kNODE_DISTRIBUTION:
putint (yyt->NODE_DISTRIBUTION.is_descriptive)
yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_LIST:
puttTree (yyt->DIST_LIST.Elem)
yyt = yyt->DIST_LIST.Next; break;
case kBLOCK_DISTRIBUTION:
yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION:
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION:
yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION:
yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION:
puttTree (yyt->ARBITRARY_DISTRIBUTION.SIZE)
puttTree (yyt->ARBITRARY_DISTRIBUTION.LENGTH)
yyt = yyt->ARBITRARY_DISTRIBUTION.MAP; break;
case kPROCESSOR_ARRAY:
yyt = yyt->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET:
puttTree (yyt->PROCESSOR_SUBSET.SUBTOP)
puttTree (yyt->PROCESSOR_SUBSET.FULLTOP)
yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC:
putint (yyt->ALIGN_SPEC.is_descriptive)
puttTree (yyt->ALIGN_SPEC.TEMPNAME)
yyt = yyt->ALIGN_SPEC.SUBSCRIPTS; break;
case kID_GENERIC_SPEC:
puttIdent (yyt->ID_GENERIC_SPEC.name)
return;
case kOP_GENERIC_SPEC:
yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kACF_LIST:
puttTree (yyt->ACF_LIST.Elem)
yyt = yyt->ACF_LIST.Next; break;
case kACF_NODE:
putint (yyt->ACF_NODE.Label)
putint (yyt->ACF_NODE.Line)
return;
case kACF_DUMMY:
putint (yyt->ACF_DUMMY.Label)
putint (yyt->ACF_DUMMY.Line)
return;
case kACF_BASIC:
putint (yyt->ACF_BASIC.Label)
putint (yyt->ACF_BASIC.Line)
yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF:
putint (yyt->ACF_IF.Label)
putint (yyt->ACF_IF.Line)
puttTree (yyt->ACF_IF.IF_EXP)
puttTree (yyt->ACF_IF.THEN_PART)
yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE:
putint (yyt->ACF_WHERE.Label)
putint (yyt->ACF_WHERE.Line)
puttTree (yyt->ACF_WHERE.WHERE_EXP)
puttTree (yyt->ACF_WHERE.TRUE_PART)
yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_CASE:
putint (yyt->ACF_CASE.Label)
putint (yyt->ACF_CASE.Line)
puttTree (yyt->ACF_CASE.CASE_EXP)
yyt = yyt->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE:
putint (yyt->ACF_WHILE.Label)
putint (yyt->ACF_WHILE.Line)
puttTree (yyt->ACF_WHILE.WHILE_EXP)
yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT:
putint (yyt->ACF_REPEAT.Label)
putint (yyt->ACF_REPEAT.Line)
puttTree (yyt->ACF_REPEAT.REPEAT_BODY)
yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP:
putint (yyt->ACF_LOOP.Label)
putint (yyt->ACF_LOOP.Line)
yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO:
putint (yyt->ACF_DO.Label)
putint (yyt->ACF_DO.Line)
puttTree (yyt->ACF_DO.DO_ID)
puttTree (yyt->ACF_DO.DO_RANGE)
puttTree (yyt->ACF_DO.DO_BODY)
puttTree (yyt->ACF_DO.DO_DEP_INFO)
yyt = yyt->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL:
putint (yyt->ACF_FORALL.Label)
putint (yyt->ACF_FORALL.Line)
puttTree (yyt->ACF_FORALL.FORALL_ID)
puttTree (yyt->ACF_FORALL.FORALL_RANGE)
puttTree (yyt->ACF_FORALL.FORALL_BODY)
puttTree (yyt->ACF_FORALL.FORALL_DEP_INFO)
yyt = yyt->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH:
putint (yyt->ACF_FLOW_GRAPH.Label)
putint (yyt->ACF_FLOW_GRAPH.Line)
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY:
putint (yyt->ACF_ENTRY.Label)
putint (yyt->ACF_ENTRY.Line)
yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME:
putint (yyt->ACF_HOME.Label)
putint (yyt->ACF_HOME.Line)
puttTree (yyt->ACF_HOME.HOME_VAR)
putbool (yyt->ACF_HOME.user_home)
yyt = yyt->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT:
putint (yyt->ACF_RESIDENT.Label)
putint (yyt->ACF_RESIDENT.Line)
puttTree (yyt->ACF_RESIDENT.RESIDENT_VAR)
yyt = yyt->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW:
putint (yyt->ACF_NEW.Label)
putint (yyt->ACF_NEW.Line)
puttTree (yyt->ACF_NEW.NEW_VAR)
yyt = yyt->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION:
putint (yyt->ACF_REDUCTION.Label)
putint (yyt->ACF_REDUCTION.Line)
putbool (yyt->ACF_REDUCTION.is_zero)
puttTree (yyt->ACF_REDUCTION.REDUCTION_VAR)
puttTree (yyt->ACF_REDUCTION.REDUCTION_LVAR)
puttTree (yyt->ACF_REDUCTION.REDUCTION_FUNC)
yyt = yyt->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION:
putint (yyt->ACF_TASK_REGION.Label)
putint (yyt->ACF_TASK_REGION.Line)
putint (yyt->ACF_TASK_REGION.task_flag)
yyt = yyt->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL:
putint (yyt->ACF_PARALLEL.Label)
putint (yyt->ACF_PARALLEL.Line)
puttTree (yyt->ACF_PARALLEL.REDUCTION_VARS)
puttTree (yyt->ACF_PARALLEL.SHARED_VARS)
puttTree (yyt->ACF_PARALLEL.LOCAL_VARS)
yyt = yyt->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL:
putint (yyt->ACF_CRITICAL.Label)
putint (yyt->ACF_CRITICAL.Line)
yyt = yyt->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON:
putint (yyt->ACF_ON.Label)
putint (yyt->ACF_ON.Line)
puttTree (yyt->ACF_ON.ON_HOME)
puttTree (yyt->ACF_ON.ON_SPECS)
yyt = yyt->ACF_ON.ON_BODY; break;
case kACF_RM_READ:
putint (yyt->ACF_RM_READ.Label)
putint (yyt->ACF_RM_READ.Line)
puttTree (yyt->ACF_RM_READ.LOCAL_VAR)
yyt = yyt->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE:
putint (yyt->ACF_RM_WRITE.Label)
putint (yyt->ACF_RM_WRITE.Line)
putint (yyt->ACF_RM_WRITE.op)
puttTree (yyt->ACF_RM_WRITE.REMOTE_VAR)
yyt = yyt->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE:
putint (yyt->ACF_MOVE.Label)
putint (yyt->ACF_MOVE.Line)
yyt = yyt->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER:
putint (yyt->ACF_BARRIER.Label)
putint (yyt->ACF_BARRIER.Line)
yyt = yyt->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE:
putint (yyt->ACF_UPDATE.Label)
putint (yyt->ACF_UPDATE.Line)
yyt = yyt->ACF_UPDATE.OVERLAP_VAR; break;
case kON_VAR_CLAUSE:
yyt = yyt->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE:
yyt = yyt->ON_PROC_CLAUSE.ON_PROC; break;
case kON_PROCS:
puttObject (yyt->ON_PROCS.topid)
return;
case kON_VAR:
puttObject (yyt->ON_VAR.topid)
puttObject (yyt->ON_VAR.tempid)
puttObject (yyt->ON_VAR.arrayid)
return;
case kON_LIST:
puttTree (yyt->ON_LIST.Elem)
yyt = yyt->ON_LIST.Next; break;
case kON_SPEC:
putint (yyt->ON_SPEC.top_dim)
putint (yyt->ON_SPEC.temp_dim)
putint (yyt->ON_SPEC.array_dim)
yyt = yyt->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_LIST:
puttTree (yyt->SELECTED_ACF_LIST.Elem)
yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE:
puttTree (yyt->SELECTED_ACF_NODE.SELECT_LIST)
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kASSIGN_STMT:
puttTree (yyt->ASSIGN_STMT.ASSIGN_VAR)
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT:
puttTree (yyt->PTR_ASSIGN_STMT.ASSIGN_VAR)
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT:
putint (yyt->LABEL_ASSIGN_STMT.assign_label)
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT:
puttTree (yyt->CALL_STMT.CALL_ID)
yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT:
puttTree (yyt->IO_STMT.ID)
puttTree (yyt->IO_STMT.IO_SPECS)
yyt = yyt->IO_STMT.IO_ITEMS; break;
case kGOTO_STMT:
putint (yyt->GOTO_STMT.GOTO_LABEL)
return;
case kASS_GOTO_STMT:
puttTree (yyt->ASS_GOTO_STMT.GOTO_VAR)
yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT:
puttTree (yyt->COMP_GOTO_STMT.GOTO_LABELS)
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT:
putint (yyt->COMP_IF_STMT.IF_LT_LABEL)
putint (yyt->COMP_IF_STMT.IF_EQ_LABEL)
putint (yyt->COMP_IF_STMT.IF_GT_LABEL)
yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT:
yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT:
yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kEXIT_STMT:
puttIdent (yyt->EXIT_STMT.loopid)
return;
case kCYCLE_STMT:
puttIdent (yyt->CYCLE_STMT.loopid)
return;
case kSTOP_STMT:
yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT:
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT:
puttTree (yyt->INHERIT_DSP_STMT.VAR)
putint (yyt->INHERIT_DSP_STMT.flag)
putint (yyt->INHERIT_DSP_STMT.safety)
yyt = yyt->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT:
puttTree (yyt->CREATE_DSP_STMT.VAR)
putint (yyt->CREATE_DSP_STMT.flag)
yyt = yyt->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT:
putint (yyt->FREE_DSP_STMT.flag)
yyt = yyt->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT:
puttTree (yyt->ALLOCATE_STMT.PARAMS)
yyt = yyt->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT:
puttTree (yyt->DEALLOCATE_STMT.PARAMS)
yyt = yyt->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT:
yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT:
puttTree (yyt->REDUCE_STMT.RED_FUNC)
yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT:
puttTree (yyt->MOVE_STMT.TARGET)
puttTree (yyt->MOVE_STMT.SOURCE)
yyt = yyt->MOVE_STMT.MASK; break;
case kSCATTER_STMT:
puttIdent (yyt->SCATTER_STMT.func)
puttTree (yyt->SCATTER_STMT.ARRAY)
puttTree (yyt->SCATTER_STMT.BASE)
puttTree (yyt->SCATTER_STMT.INDEXES)
yyt = yyt->SCATTER_STMT.MASK; break;
case kREALIGN_STMT:
puttTree (yyt->REALIGN_STMT.ALIGNEE)
puttTree (yyt->REALIGN_STMT.ALIGN_SOURCE)
puttDefinitions (yyt->REALIGN_STMT.distribution)
yyt = yyt->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT:
puttTree (yyt->REDISTRIBUTE_STMT.DISTRIBUTEE)
puttTree (yyt->REDISTRIBUTE_STMT.DISTRIBUTION)
puttDefinitions (yyt->REDISTRIBUTE_STMT.distribution)
yyt = yyt->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET:
puttTree (yyt->REG_SHADOW_GET.SHADOW_VAR)
yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT:
putint (yyt->REG_SHADOW_PUT.op)
puttTree (yyt->REG_SHADOW_PUT.SHADOW_VAR)
yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET:
puttTree (yyt->REG_SHADOW_SET.SHADOW_VAR)
puttTree (yyt->REG_SHADOW_SET.SHADOW_SIZE)
yyt = yyt->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE:
putint (yyt->IND_SHADOW_CREATE.id)
puttTree (yyt->IND_SHADOW_CREATE.SHADOW_VAR)
puttTree (yyt->IND_SHADOW_CREATE.INDEX_VAR)
puttTree (yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR)
yyt = yyt->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE:
putint (yyt->IND_SHADOW_FREE.id)
yyt = yyt->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET:
putint (yyt->IND_SHADOW_GET.id)
yyt = yyt->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT:
putint (yyt->IND_SHADOW_PUT.id)
putint (yyt->IND_SHADOW_PUT.op)
yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET:
putint (yyt->IND_SHADOW_SET.id)
puttTree (yyt->IND_SHADOW_SET.SHADOW_VAR)
yyt = yyt->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT:
puttTree (yyt->BROADCAST_STMT.ELEMS)
puttTree (yyt->BROADCAST_STMT.OWNER_TOP)
yyt = yyt->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT:
puttTree (yyt->REDUCTION_STMT.REDFUNC)
puttTree (yyt->REDUCTION_STMT.ELEMS)
puttTree (yyt->REDUCTION_STMT.RED_TOP)
yyt = yyt->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT:
yyt = yyt->DIRTY_STMT.ELEMS; break;
case kLABEL_LIST:
putint (yyt->LABEL_LIST.Elem)
yyt = yyt->LABEL_LIST.Next; break;
case kOP_DEFINED:
puttIdent (yyt->OP_DEFINED.opname)
return;
case kCONST_EXP:
yyt = yyt->CONST_EXP.C; break;
case kOP_EXP:
puttTree (yyt->OP_EXP.EXP_OP)
puttTree (yyt->OP_EXP.OPND1)
yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP:
puttTree (yyt->OP1_EXP.EXP_OP1)
yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP:
puttTree (yyt->SLICE_EXP.START)
puttTree (yyt->SLICE_EXP.STOP)
yyt = yyt->SLICE_EXP.INC; break;
case kVAR_EXP:
yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP:
puttTree (yyt->FUNC_CALL_EXP.FUNC_ID)
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP:
puttIdent (yyt->NAMED_EXP.Name)
yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP:
puttTree (yyt->DO_EXP.DO_ID)
puttTree (yyt->DO_EXP.RANGE)
yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP:
puttTree (yyt->TYPE_EXP.ID)
yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP:
yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP:
putPermutation (yyt->PERM_EXP.perm)
yyt = yyt->PERM_EXP.VAL; break;
case kBOUND_EXP:
putint (yyt->BOUND_EXP.dim)
putint (yyt->BOUND_EXP.kind)
putint (yyt->BOUND_EXP.local)
yyt = yyt->BOUND_EXP.VAR; break;
case kRANK_EXP:
putint (yyt->RANK_EXP.kind)
return;
case kBTE_LIST:
puttTree (yyt->BTE_LIST.Elem)
yyt = yyt->BTE_LIST.Next; break;
case kUSED_VAR:
yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR:
puttTree (yyt->INDEXED_VAR.IND_VAR)
yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR:
puttTree (yyt->SUBSTRING_VAR.IND_VAR)
yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR:
puttTree (yyt->SELECTED_VAR.SELEC_VAR)
yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR:
yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR:
putPermutation (yyt->PERM_VAR.perm)
yyt = yyt->PERM_VAR.VAL; break;
case kADDR:
yyt = yyt->ADDR.E; break;
case kDO_VAR:
puttTree (yyt->DO_VAR.DO_ID)
puttTree (yyt->DO_VAR.RANGE)
yyt = yyt->DO_VAR.BODY; break;
case kREMOTE_VAR:
yyt = yyt->REMOTE_VAR.VAR; break;
case kBTV_LIST:
puttTree (yyt->BTV_LIST.Elem)
yyt = yyt->BTV_LIST.Next; break;
case kVAR_PARAM:
puttDefinitions (yyt->VAR_PARAM.formal)
putint (yyt->VAR_PARAM.intent)
putint (yyt->VAR_PARAM.layout)
putint (yyt->VAR_PARAM.pass_by)
putint (yyt->VAR_PARAM.trace)
yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM:
yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM:
puttIdent (yyt->NAMED_PARAM.Name)
yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM:
yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM:
yyt = yyt->FUNC_PARAM.F; break;
case kFORMAT_PARAM:
puttStringRef (yyt->FORMAT_PARAM.S)
return;
case kRETURN_PARAM:
putint (yyt->RETURN_PARAM.label)
return;
case kNO_PARAM:
putint (yyt->NO_PARAM.type)
return;
case kBTP_LIST:
puttTree (yyt->BTP_LIST.Elem)
yyt = yyt->BTP_LIST.Next; break;
case kBOOL_CONSTANT:
putint (yyt->BOOL_CONSTANT.value)
return;
case kINT_CONSTANT:
putint (yyt->INT_CONSTANT.value)
return;
case kREAL_CONSTANT:
puttStringRef (yyt->REAL_CONSTANT.value)
putint (yyt->REAL_CONSTANT.kind)
return;
case kSTRING_CONSTANT:
puttStringRef (yyt->STRING_CONSTANT.value)
return;
case kCOMPLEX_CONSTANT:
puttStringRef (yyt->COMPLEX_CONSTANT.rvalue)
puttStringRef (yyt->COMPLEX_CONSTANT.ivalue)
return;
case kPROC_OBJ:
puttIdent (yyt->PROC_OBJ.Ident)
puttDefinitions (yyt->PROC_OBJ.Object)
return;
case kVAR_OBJ:
putint (yyt->VAR_OBJ.Pos)
puttIdent (yyt->VAR_OBJ.Ident)
puttDefinitions (yyt->VAR_OBJ.Object)
puttReaching (yyt->VAR_OBJ.Reaching)
return;
case kTYPE_OBJ:
puttIdent (yyt->TYPE_OBJ.Ident)
puttDefinitions (yyt->TYPE_OBJ.Object)
return;
case kREC_COMP:
puttIdent (yyt->REC_COMP.Ident)
puttDefinitions (yyt->REC_COMP.Object)
return;
case kTOP_OBJ:
puttIdent (yyt->TOP_OBJ.Ident)
puttDefinitions (yyt->TOP_OBJ.Object)
return;
case kTEMP_OBJ:
puttIdent (yyt->TEMP_OBJ.Ident)
puttDefinitions (yyt->TEMP_OBJ.Object)
return;
case kOVERLAP_SPEC:
putint (yyt->OVERLAP_SPEC.left_size)
putint (yyt->OVERLAP_SPEC.right_size)
putint (yyt->OVERLAP_SPEC.left_update)
putint (yyt->OVERLAP_SPEC.right_update)
return;
case kINDEP_INFO:
putbool (yyt->INDEP_INFO.user_independent)
putint (yyt->INDEP_INFO.selection)
putInfoTree (yyt->INDEP_INFO.red_vars)
putInfoTree (yyt->INDEP_INFO.new_vars)
return;
case kVECTOR_INFO:
putbool (yyt->VECTOR_INFO.is_independent)
putint (yyt->VECTOR_INFO.selection)
putint (yyt->VECTOR_INFO.loop_cnt)
putInfoTree (yyt->VECTOR_INFO.independent_vars)
return;
case kCOMM_INFO:
putInfoTree (yyt->COMM_INFO.home_var)
putbool (yyt->COMM_INFO.is_local)
return;
case kON_INFO:
puttObject (yyt->ON_INFO.on_id)
putint (yyt->ON_INFO.on_dim)
putint (yyt->ON_INFO.base)
putint (yyt->ON_INFO.stride)
return;
case kPARALLEL_INFO:
putInfoTree (yyt->PARALLEL_INFO.reduction_vars)
putInfoTree (yyt->PARALLEL_INFO.home_var)
putInfoTree (yyt->PARALLEL_INFO.new_vars)
putInfoTree (yyt->PARALLEL_INFO.resident_vars)
return;
case kREACHING_INFO:
putInfoTree (yyt->REACHING_INFO.var_allocate)
putInfoTree (yyt->REACHING_INFO.temp_allocate)
puttDefinitions (yyt->REACHING_INFO.var_distribution)
puttDefinitions (yyt->REACHING_INFO.temp_distribution)
return;
  default: return;
  }
 }
}

void PutTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tTree yyt;
# endif
{
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyPutTree (yyt);
 yyRecursionLevel --;
}

static void yyGet
# if defined __STDC__ | defined __cplusplus
 (char * yyx, int yysize)
# else
 (yyx, yysize) char * yyx; int yysize;
# endif
{ (void) fread (yyx, 1, yysize, yyf); }

static void yyGetIdent
# if defined __STDC__ | defined __cplusplus
 (tIdent * yyi)
# else
 (yyi) tIdent * yyi;
# endif
{
 char yys [256];
 (void) fscanf (yyf, "%s%*c", yys);
 * yyi = MakeIdent ((tString) yys, strlen (yys));
}

static void yyGetTree
# if defined __STDC__ | defined __cplusplus
 (yyPtrtTree yyt)
# else
 (yyt) yyPtrtTree yyt;
# endif
{
 static Tree_tLabel yyLabel;
 static Tree_tKind yyKind;
 for (;;) {
  switch (yyKind = getc (yyf)) {
  case yyNil		: * yyt = NoTree; return;
  case yyLabelUse	: yyGet ((char *) & yyLabel, sizeof (yyLabel));
   * yyt = yyMapToTree (yyLabel); return;
  case yyLabelDef	: yyGet ((char *) & yyLabel, sizeof (yyLabel));
   yyGet ((char *) & yyKind, sizeof (yyKind));
   * yyt = MakeTree (yyKind);
   if (yyLabel != yyMapToLabel (* yyt)) { (void) fputs ("Tree: error in GetTree\n", stderr); Tree_Exit (); } break;
  case yyNoLabel	: yyGet ((char *) & yyKind, sizeof (yyKind));
   * yyt = MakeTree (yyKind); break;
  default	: * yyt = MakeTree (yyKind);
  }

  switch (yyKind) {
case kCOMP_UNIT:
gettTree (& ((* yyt)->COMP_UNIT.COMP_ELEMENTS))
yyt = & ((* yyt)->COMP_UNIT.USED_ELEMENTS); break;
case kUNIT_LIST:
gettTree (& ((* yyt)->UNIT_LIST.Elem))
yyt = & ((* yyt)->UNIT_LIST.Next); break;
case kUNIT_NODE:
gettIdent ((* yyt)->UNIT_NODE.Ident)
getint ((* yyt)->UNIT_NODE.Line)
gettDefinitions ((* yyt)->UNIT_NODE.Object)
return;
case kMODULE_DECL:
gettIdent ((* yyt)->MODULE_DECL.Ident)
getint ((* yyt)->MODULE_DECL.Line)
gettDefinitions ((* yyt)->MODULE_DECL.Object)
yyt = & ((* yyt)->MODULE_DECL.MODULE_BODY); break;
case kPROGRAM_DECL:
gettIdent ((* yyt)->PROGRAM_DECL.Ident)
getint ((* yyt)->PROGRAM_DECL.Line)
gettDefinitions ((* yyt)->PROGRAM_DECL.Object)
gettTree (& ((* yyt)->PROGRAM_DECL.FORMALS))
yyt = & ((* yyt)->PROGRAM_DECL.PROGRAM_BODY); break;
case kPROC_DECL:
gettIdent ((* yyt)->PROC_DECL.Ident)
getint ((* yyt)->PROC_DECL.Line)
gettDefinitions ((* yyt)->PROC_DECL.Object)
gettTree (& ((* yyt)->PROC_DECL.FORMALS))
getbool ((* yyt)->PROC_DECL.IsRecursive)
getbool ((* yyt)->PROC_DECL.IsPure)
gettIdent ((* yyt)->PROC_DECL.HPFExtrinsic)
yyt = & ((* yyt)->PROC_DECL.PROC_BODY); break;
case kFUNC_DECL:
gettIdent ((* yyt)->FUNC_DECL.Ident)
getint ((* yyt)->FUNC_DECL.Line)
gettDefinitions ((* yyt)->FUNC_DECL.Object)
gettTree (& ((* yyt)->FUNC_DECL.FORMALS))
gettTree (& ((* yyt)->FUNC_DECL.FUNC_BODY))
gettIdent ((* yyt)->FUNC_DECL.RESULT_ID)
getbool ((* yyt)->FUNC_DECL.IsRecursive)
getbool ((* yyt)->FUNC_DECL.IsPure)
gettIdent ((* yyt)->FUNC_DECL.HPFExtrinsic)
yyt = & ((* yyt)->FUNC_DECL.RESULT_TYPE); break;
case kMODULE_PROC_DECL:
gettIdent ((* yyt)->MODULE_PROC_DECL.Ident)
getint ((* yyt)->MODULE_PROC_DECL.Line)
gettDefinitions ((* yyt)->MODULE_PROC_DECL.Object)
return;
case kBLOCK_DATA_DECL:
gettIdent ((* yyt)->BLOCK_DATA_DECL.Ident)
getint ((* yyt)->BLOCK_DATA_DECL.Line)
gettDefinitions ((* yyt)->BLOCK_DATA_DECL.Object)
yyt = & ((* yyt)->BLOCK_DATA_DECL.DATA_BODY); break;
case kINTERFACE:
gettIdent ((* yyt)->INTERFACE.Ident)
getint ((* yyt)->INTERFACE.Line)
gettDefinitions ((* yyt)->INTERFACE.Object)
gettTree (& ((* yyt)->INTERFACE.SPEC))
yyt = & ((* yyt)->INTERFACE.ITEMS); break;
case kBODY_NODE:
gettTree (& ((* yyt)->BODY_NODE.DECLS))
gettTree (& ((* yyt)->BODY_NODE.STATS))
yyt = & ((* yyt)->BODY_NODE.INTERNALS); break;
case kINTEGER_TYPE:
yyt = & ((* yyt)->INTEGER_TYPE.SIZE); break;
case kREAL_TYPE:
yyt = & ((* yyt)->REAL_TYPE.SIZE); break;
case kBOOLEAN_TYPE:
yyt = & ((* yyt)->BOOLEAN_TYPE.SIZE); break;
case kCOMPLEX_TYPE:
yyt = & ((* yyt)->COMPLEX_TYPE.SIZE); break;
case kSTRING_TYPE:
yyt = & ((* yyt)->STRING_TYPE.LENGTH); break;
case kTYPE_ID:
yyt = & ((* yyt)->TYPE_ID.ID); break;
case kARRAY_TYPE:
gettTree (& ((* yyt)->ARRAY_TYPE.ARRAY_INDEX_TYPES))
yyt = & ((* yyt)->ARRAY_TYPE.ARRAY_COMP_TYPE); break;
case kRECORD_TYPE:
gettIdent ((* yyt)->RECORD_TYPE.Name)
yyt = & ((* yyt)->RECORD_TYPE.COMPONENTS); break;
case kPOINTER_TYPE:
yyt = & ((* yyt)->POINTER_TYPE.PTR_COMP); break;
case kSHAPE_SPEC:
yyt = & ((* yyt)->SHAPE_SPEC.Overlap); break;
case kEXPLICIT_SHAPE:
gettTree (& ((* yyt)->EXPLICIT_SHAPE.Overlap))
gettTree (& ((* yyt)->EXPLICIT_SHAPE.LOWER))
yyt = & ((* yyt)->EXPLICIT_SHAPE.UPPER); break;
case kASSUMED_SHAPE:
gettTree (& ((* yyt)->ASSUMED_SHAPE.Overlap))
yyt = & ((* yyt)->ASSUMED_SHAPE.LOWER); break;
case kDEFERRED_SHAPE:
yyt = & ((* yyt)->DEFERRED_SHAPE.Overlap); break;
case kASSUMED_SIZE:
gettTree (& ((* yyt)->ASSUMED_SIZE.Overlap))
yyt = & ((* yyt)->ASSUMED_SIZE.LOWER); break;
case kSHAPE_LIST:
gettTree (& ((* yyt)->SHAPE_LIST.Elem))
yyt = & ((* yyt)->SHAPE_LIST.Next); break;
case kDECL_NODE:
gettIdent ((* yyt)->DECL_NODE.Ident)
getint ((* yyt)->DECL_NODE.Line)
return;
case kTYPE_DECL:
gettIdent ((* yyt)->TYPE_DECL.Ident)
getint ((* yyt)->TYPE_DECL.Line)
yyt = & ((* yyt)->TYPE_DECL.VAL); break;
case kNAME_DECL:
gettIdent ((* yyt)->NAME_DECL.Ident)
getint ((* yyt)->NAME_DECL.Line)
return;
case kRENAME_DECL:
gettIdent ((* yyt)->RENAME_DECL.Ident)
getint ((* yyt)->RENAME_DECL.Line)
gettIdent ((* yyt)->RENAME_DECL.oldname)
return;
case kENTITY_DECL:
gettIdent ((* yyt)->ENTITY_DECL.Ident)
getint ((* yyt)->ENTITY_DECL.Line)
yyt = & ((* yyt)->ENTITY_DECL.ATTRIBUTES); break;
case kVAR_DECL:
gettIdent ((* yyt)->VAR_DECL.Ident)
getint ((* yyt)->VAR_DECL.Line)
yyt = & ((* yyt)->VAR_DECL.VAL); break;
case kCOMMON_DECL:
gettIdent ((* yyt)->COMMON_DECL.Ident)
getint ((* yyt)->COMMON_DECL.Line)
yyt = & ((* yyt)->COMMON_DECL.IDS); break;
case kNAMELIST_DECL:
gettIdent ((* yyt)->NAMELIST_DECL.Ident)
getint ((* yyt)->NAMELIST_DECL.Line)
yyt = & ((* yyt)->NAMELIST_DECL.IDS); break;
case kTEMPLATE_DECL:
gettIdent ((* yyt)->TEMPLATE_DECL.Ident)
getint ((* yyt)->TEMPLATE_DECL.Line)
yyt = & ((* yyt)->TEMPLATE_DECL.DIMENSIONS); break;
case kRAGGED_DECL:
gettIdent ((* yyt)->RAGGED_DECL.Ident)
getint ((* yyt)->RAGGED_DECL.Line)
yyt = & ((* yyt)->RAGGED_DECL.DIMENSIONS); break;
case kPROCESSORS_DECL:
gettIdent ((* yyt)->PROCESSORS_DECL.Ident)
getint ((* yyt)->PROCESSORS_DECL.Line)
yyt = & ((* yyt)->PROCESSORS_DECL.DIMENSIONS); break;
case kSUB_PROCS_DECL:
gettIdent ((* yyt)->SUB_PROCS_DECL.Ident)
getint ((* yyt)->SUB_PROCS_DECL.Line)
gettTree (& ((* yyt)->SUB_PROCS_DECL.TOP))
yyt = & ((* yyt)->SUB_PROCS_DECL.DIMENSIONS); break;
case kINHERIT_DECL:
gettIdent ((* yyt)->INHERIT_DECL.Ident)
getint ((* yyt)->INHERIT_DECL.Line)
return;
case kRANGE_DECL:
gettIdent ((* yyt)->RANGE_DECL.Ident)
getint ((* yyt)->RANGE_DECL.Line)
yyt = & ((* yyt)->RANGE_DECL.RANGES); break;
case kSTMT_FUNC_DECL:
gettIdent ((* yyt)->STMT_FUNC_DECL.Ident)
getint ((* yyt)->STMT_FUNC_DECL.Line)
gettTree (& ((* yyt)->STMT_FUNC_DECL.FORMALS))
gettTree (& ((* yyt)->STMT_FUNC_DECL.RESULT_TYPE))
yyt = & ((* yyt)->STMT_FUNC_DECL.FFUNC_BODY); break;
case kINTERFACE_DECL:
gettIdent ((* yyt)->INTERFACE_DECL.Ident)
getint ((* yyt)->INTERFACE_DECL.Line)
gettTree (& ((* yyt)->INTERFACE_DECL.SPEC))
yyt = & ((* yyt)->INTERFACE_DECL.ITEMS); break;
case kVAR_PARAM_DECL:
gettIdent ((* yyt)->VAR_PARAM_DECL.Ident)
getint ((* yyt)->VAR_PARAM_DECL.Line)
yyt = & ((* yyt)->VAR_PARAM_DECL.VAL); break;
case kRET_PARAM_DECL:
gettIdent ((* yyt)->RET_PARAM_DECL.Ident)
getint ((* yyt)->RET_PARAM_DECL.Line)
return;
case kIMPLICIT_DECL:
gettIdent ((* yyt)->IMPLICIT_DECL.Ident)
getint ((* yyt)->IMPLICIT_DECL.Line)
gettIdent ((* yyt)->IMPLICIT_DECL.first)
gettIdent ((* yyt)->IMPLICIT_DECL.last)
yyt = & ((* yyt)->IMPLICIT_DECL.TYPE); break;
case kUSE_DECL:
gettIdent ((* yyt)->USE_DECL.Ident)
getint ((* yyt)->USE_DECL.Line)
gettIdent ((* yyt)->USE_DECL.use)
yyt = & ((* yyt)->USE_DECL.RENAMINGS); break;
case kONLY_USE_DECL:
gettIdent ((* yyt)->ONLY_USE_DECL.Ident)
getint ((* yyt)->ONLY_USE_DECL.Line)
gettIdent ((* yyt)->ONLY_USE_DECL.use)
yyt = & ((* yyt)->ONLY_USE_DECL.NAMES); break;
case kEQV_DECL:
gettIdent ((* yyt)->EQV_DECL.Ident)
getint ((* yyt)->EQV_DECL.Line)
yyt = & ((* yyt)->EQV_DECL.VARS); break;
case kDATA_DECL:
gettIdent ((* yyt)->DATA_DECL.Ident)
getint ((* yyt)->DATA_DECL.Line)
gettTree (& ((* yyt)->DATA_DECL.VARS))
yyt = & ((* yyt)->DATA_DECL.VALS); break;
case kFORMAT_DECL:
gettIdent ((* yyt)->FORMAT_DECL.Ident)
getint ((* yyt)->FORMAT_DECL.Line)
getint ((* yyt)->FORMAT_DECL.label)
yyt = & ((* yyt)->FORMAT_DECL.FORMAT_PARAMS); break;
case kDIMENSION_DECL:
gettIdent ((* yyt)->DIMENSION_DECL.Ident)
getint ((* yyt)->DIMENSION_DECL.Line)
yyt = & ((* yyt)->DIMENSION_DECL.INDEXES); break;
case kINIT_DATA_DECL:
gettIdent ((* yyt)->INIT_DATA_DECL.Ident)
getint ((* yyt)->INIT_DATA_DECL.Line)
yyt = & ((* yyt)->INIT_DATA_DECL.VAL); break;
case kTYPESPEC_DECL:
gettIdent ((* yyt)->TYPESPEC_DECL.Ident)
getint ((* yyt)->TYPESPEC_DECL.Line)
yyt = & ((* yyt)->TYPESPEC_DECL.VAL); break;
case kALLOCATABLE_DECL:
gettIdent ((* yyt)->ALLOCATABLE_DECL.Ident)
getint ((* yyt)->ALLOCATABLE_DECL.Line)
return;
case kEXTERNAL_DECL:
gettIdent ((* yyt)->EXTERNAL_DECL.Ident)
getint ((* yyt)->EXTERNAL_DECL.Line)
return;
case kINTENT_DECL:
gettIdent ((* yyt)->INTENT_DECL.Ident)
getint ((* yyt)->INTENT_DECL.Line)
getint ((* yyt)->INTENT_DECL.intent)
return;
case kINTRINSIC_DECL:
gettIdent ((* yyt)->INTRINSIC_DECL.Ident)
getint ((* yyt)->INTRINSIC_DECL.Line)
gettIdent ((* yyt)->INTRINSIC_DECL.generic)
getint ((* yyt)->INTRINSIC_DECL.class)
getint ((* yyt)->INTRINSIC_DECL.kind)
return;
case kOPTIONAL_DECL:
gettIdent ((* yyt)->OPTIONAL_DECL.Ident)
getint ((* yyt)->OPTIONAL_DECL.Line)
return;
case kPOINTER_DECL:
gettIdent ((* yyt)->POINTER_DECL.Ident)
getint ((* yyt)->POINTER_DECL.Line)
return;
case kSAVE_DECL:
gettIdent ((* yyt)->SAVE_DECL.Ident)
getint ((* yyt)->SAVE_DECL.Line)
return;
case kTARGET_DECL:
gettIdent ((* yyt)->TARGET_DECL.Ident)
getint ((* yyt)->TARGET_DECL.Line)
return;
case kPARAMETER_DECL:
gettIdent ((* yyt)->PARAMETER_DECL.Ident)
getint ((* yyt)->PARAMETER_DECL.Line)
yyt = & ((* yyt)->PARAMETER_DECL.VAL); break;
case kPUBLIC_DECL:
gettIdent ((* yyt)->PUBLIC_DECL.Ident)
getint ((* yyt)->PUBLIC_DECL.Line)
return;
case kPRIVATE_DECL:
gettIdent ((* yyt)->PRIVATE_DECL.Ident)
getint ((* yyt)->PRIVATE_DECL.Line)
return;
case kSEQUENCE_DECL:
gettIdent ((* yyt)->SEQUENCE_DECL.Ident)
getint ((* yyt)->SEQUENCE_DECL.Line)
return;
case kDISTRIBUTE_DECL:
gettIdent ((* yyt)->DISTRIBUTE_DECL.Ident)
getint ((* yyt)->DISTRIBUTE_DECL.Line)
gettTree (& ((* yyt)->DISTRIBUTE_DECL.DISTRIBUTION))
yyt = & ((* yyt)->DISTRIBUTE_DECL.TARGET); break;
case kALIGN_DECL:
gettIdent ((* yyt)->ALIGN_DECL.Ident)
getint ((* yyt)->ALIGN_DECL.Line)
gettTree (& ((* yyt)->ALIGN_DECL.ALIGN_SOURCE))
yyt = & ((* yyt)->ALIGN_DECL.ALIGN_TARGET); break;
case kMAP_DECL:
gettIdent ((* yyt)->MAP_DECL.Ident)
getint ((* yyt)->MAP_DECL.Line)
yyt = & ((* yyt)->MAP_DECL.MAP_TARGET); break;
case kOVERLAP_DECL:
gettIdent ((* yyt)->OVERLAP_DECL.Ident)
getint ((* yyt)->OVERLAP_DECL.Line)
yyt = & ((* yyt)->OVERLAP_DECL.OVERLAPS); break;
case kSHARED_DECL:
gettIdent ((* yyt)->SHARED_DECL.Ident)
getint ((* yyt)->SHARED_DECL.Line)
getint ((* yyt)->SHARED_DECL.kind)
return;
case kDYNAMIC_DECL:
gettIdent ((* yyt)->DYNAMIC_DECL.Ident)
getint ((* yyt)->DYNAMIC_DECL.Line)
return;
case kTRACE_DECL:
gettIdent ((* yyt)->TRACE_DECL.Ident)
getint ((* yyt)->TRACE_DECL.Line)
return;
case kTREE_DECL:
gettIdent ((* yyt)->TREE_DECL.Ident)
getint ((* yyt)->TREE_DECL.Line)
return;
case kSELECT_DECL:
gettIdent ((* yyt)->SELECT_DECL.Ident)
getint ((* yyt)->SELECT_DECL.Line)
yyt = & ((* yyt)->SELECT_DECL.SELECTIONS); break;
case kHPF_SEQUENCE_DECL:
gettIdent ((* yyt)->HPF_SEQUENCE_DECL.Ident)
getint ((* yyt)->HPF_SEQUENCE_DECL.Line)
return;
case kNOSEQUENCE_DECL:
gettIdent ((* yyt)->NOSEQUENCE_DECL.Ident)
getint ((* yyt)->NOSEQUENCE_DECL.Line)
return;
case kLAYOUT_DECL:
gettIdent ((* yyt)->LAYOUT_DECL.Ident)
getint ((* yyt)->LAYOUT_DECL.Line)
gettStringRef ((* yyt)->LAYOUT_DECL.kind)
return;
case kPASS_BY_DECL:
gettIdent ((* yyt)->PASS_BY_DECL.Ident)
getint ((* yyt)->PASS_BY_DECL.Line)
gettStringRef ((* yyt)->PASS_BY_DECL.kind)
return;
case kMAP_TO_DECL:
gettIdent ((* yyt)->MAP_TO_DECL.Ident)
getint ((* yyt)->MAP_TO_DECL.Line)
gettStringRef ((* yyt)->MAP_TO_DECL.kind)
return;
case kDECL_LIST:
gettTree (& ((* yyt)->DECL_LIST.Elem))
yyt = & ((* yyt)->DECL_LIST.Next); break;
case kRANGE_LIST:
gettTree (& ((* yyt)->RANGE_LIST.Elem))
yyt = & ((* yyt)->RANGE_LIST.Next); break;
case kSELECT_LIST:
gettTree (& ((* yyt)->SELECT_LIST.Elem))
yyt = & ((* yyt)->SELECT_LIST.Next); break;
case kSELECT_SPEC:
getint ((* yyt)->SELECT_SPEC.selector)
return;
case kDISTRIBUTION_SPEC:
getint ((* yyt)->DISTRIBUTION_SPEC.is_descriptive)
return;
case kANY_DISTRIBUTION:
getint ((* yyt)->ANY_DISTRIBUTION.is_descriptive)
return;
case kDEFAULT_DISTRIBUTION:
getint ((* yyt)->DEFAULT_DISTRIBUTION.is_descriptive)
return;
case kREPL_DISTRIBUTION:
getint ((* yyt)->REPL_DISTRIBUTION.is_descriptive)
return;
case kNODE_DISTRIBUTION:
getint ((* yyt)->NODE_DISTRIBUTION.is_descriptive)
yyt = & ((* yyt)->NODE_DISTRIBUTION.MAPPING); break;
case kDIST_LIST:
gettTree (& ((* yyt)->DIST_LIST.Elem))
yyt = & ((* yyt)->DIST_LIST.Next); break;
case kBLOCK_DISTRIBUTION:
yyt = & ((* yyt)->BLOCK_DISTRIBUTION.SIZE); break;
case kCYCLIC_DISTRIBUTION:
yyt = & ((* yyt)->CYCLIC_DISTRIBUTION.SIZE); break;
case kGEN_BLOCK_DISTRIBUTION:
yyt = & ((* yyt)->GEN_BLOCK_DISTRIBUTION.ARRAY); break;
case kINDIRECT_DISTRIBUTION:
yyt = & ((* yyt)->INDIRECT_DISTRIBUTION.ARRAY); break;
case kARBITRARY_DISTRIBUTION:
gettTree (& ((* yyt)->ARBITRARY_DISTRIBUTION.SIZE))
gettTree (& ((* yyt)->ARBITRARY_DISTRIBUTION.LENGTH))
yyt = & ((* yyt)->ARBITRARY_DISTRIBUTION.MAP); break;
case kPROCESSOR_ARRAY:
yyt = & ((* yyt)->PROCESSOR_ARRAY.TOPNAME); break;
case kPROCESSOR_SUBSET:
gettTree (& ((* yyt)->PROCESSOR_SUBSET.SUBTOP))
gettTree (& ((* yyt)->PROCESSOR_SUBSET.FULLTOP))
yyt = & ((* yyt)->PROCESSOR_SUBSET.SUBSCRIPTS); break;
case kALIGN_SPEC:
getint ((* yyt)->ALIGN_SPEC.is_descriptive)
gettTree (& ((* yyt)->ALIGN_SPEC.TEMPNAME))
yyt = & ((* yyt)->ALIGN_SPEC.SUBSCRIPTS); break;
case kID_GENERIC_SPEC:
gettIdent ((* yyt)->ID_GENERIC_SPEC.name)
return;
case kOP_GENERIC_SPEC:
yyt = & ((* yyt)->OP_GENERIC_SPEC.OPERATOR); break;
case kACF_LIST:
gettTree (& ((* yyt)->ACF_LIST.Elem))
yyt = & ((* yyt)->ACF_LIST.Next); break;
case kACF_NODE:
getint ((* yyt)->ACF_NODE.Label)
getint ((* yyt)->ACF_NODE.Line)
return;
case kACF_DUMMY:
getint ((* yyt)->ACF_DUMMY.Label)
getint ((* yyt)->ACF_DUMMY.Line)
return;
case kACF_BASIC:
getint ((* yyt)->ACF_BASIC.Label)
getint ((* yyt)->ACF_BASIC.Line)
yyt = & ((* yyt)->ACF_BASIC.BASIC_STMT); break;
case kACF_IF:
getint ((* yyt)->ACF_IF.Label)
getint ((* yyt)->ACF_IF.Line)
gettTree (& ((* yyt)->ACF_IF.IF_EXP))
gettTree (& ((* yyt)->ACF_IF.THEN_PART))
yyt = & ((* yyt)->ACF_IF.ELSE_PART); break;
case kACF_WHERE:
getint ((* yyt)->ACF_WHERE.Label)
getint ((* yyt)->ACF_WHERE.Line)
gettTree (& ((* yyt)->ACF_WHERE.WHERE_EXP))
gettTree (& ((* yyt)->ACF_WHERE.TRUE_PART))
yyt = & ((* yyt)->ACF_WHERE.FALSE_PART); break;
case kACF_CASE:
getint ((* yyt)->ACF_CASE.Label)
getint ((* yyt)->ACF_CASE.Line)
gettTree (& ((* yyt)->ACF_CASE.CASE_EXP))
yyt = & ((* yyt)->ACF_CASE.CASE_ALTS); break;
case kACF_WHILE:
getint ((* yyt)->ACF_WHILE.Label)
getint ((* yyt)->ACF_WHILE.Line)
gettTree (& ((* yyt)->ACF_WHILE.WHILE_EXP))
yyt = & ((* yyt)->ACF_WHILE.WHILE_BODY); break;
case kACF_REPEAT:
getint ((* yyt)->ACF_REPEAT.Label)
getint ((* yyt)->ACF_REPEAT.Line)
gettTree (& ((* yyt)->ACF_REPEAT.REPEAT_BODY))
yyt = & ((* yyt)->ACF_REPEAT.REPEAT_EXP); break;
case kACF_LOOP:
getint ((* yyt)->ACF_LOOP.Label)
getint ((* yyt)->ACF_LOOP.Line)
yyt = & ((* yyt)->ACF_LOOP.LOOP_BODY); break;
case kACF_DO:
getint ((* yyt)->ACF_DO.Label)
getint ((* yyt)->ACF_DO.Line)
gettTree (& ((* yyt)->ACF_DO.DO_ID))
gettTree (& ((* yyt)->ACF_DO.DO_RANGE))
gettTree (& ((* yyt)->ACF_DO.DO_BODY))
gettTree (& ((* yyt)->ACF_DO.DO_DEP_INFO))
yyt = & ((* yyt)->ACF_DO.DO_HOME_INFO); break;
case kACF_FORALL:
getint ((* yyt)->ACF_FORALL.Label)
getint ((* yyt)->ACF_FORALL.Line)
gettTree (& ((* yyt)->ACF_FORALL.FORALL_ID))
gettTree (& ((* yyt)->ACF_FORALL.FORALL_RANGE))
gettTree (& ((* yyt)->ACF_FORALL.FORALL_BODY))
gettTree (& ((* yyt)->ACF_FORALL.FORALL_DEP_INFO))
yyt = & ((* yyt)->ACF_FORALL.FORALL_HOME_INFO); break;
case kACF_FLOW_GRAPH:
getint ((* yyt)->ACF_FLOW_GRAPH.Label)
getint ((* yyt)->ACF_FLOW_GRAPH.Line)
yyt = & ((* yyt)->ACF_FLOW_GRAPH.FLOW_NODES); break;
case kACF_ENTRY:
getint ((* yyt)->ACF_ENTRY.Label)
getint ((* yyt)->ACF_ENTRY.Line)
yyt = & ((* yyt)->ACF_ENTRY.ENTRY_DECL); break;
case kACF_HOME:
getint ((* yyt)->ACF_HOME.Label)
getint ((* yyt)->ACF_HOME.Line)
gettTree (& ((* yyt)->ACF_HOME.HOME_VAR))
getbool ((* yyt)->ACF_HOME.user_home)
yyt = & ((* yyt)->ACF_HOME.HOME_BODY); break;
case kACF_RESIDENT:
getint ((* yyt)->ACF_RESIDENT.Label)
getint ((* yyt)->ACF_RESIDENT.Line)
gettTree (& ((* yyt)->ACF_RESIDENT.RESIDENT_VAR))
yyt = & ((* yyt)->ACF_RESIDENT.RESIDENT_BODY); break;
case kACF_NEW:
getint ((* yyt)->ACF_NEW.Label)
getint ((* yyt)->ACF_NEW.Line)
gettTree (& ((* yyt)->ACF_NEW.NEW_VAR))
yyt = & ((* yyt)->ACF_NEW.NEW_BODY); break;
case kACF_REDUCTION:
getint ((* yyt)->ACF_REDUCTION.Label)
getint ((* yyt)->ACF_REDUCTION.Line)
getbool ((* yyt)->ACF_REDUCTION.is_zero)
gettTree (& ((* yyt)->ACF_REDUCTION.REDUCTION_VAR))
gettTree (& ((* yyt)->ACF_REDUCTION.REDUCTION_LVAR))
gettTree (& ((* yyt)->ACF_REDUCTION.REDUCTION_FUNC))
yyt = & ((* yyt)->ACF_REDUCTION.REDUCTION_BODY); break;
case kACF_TASK_REGION:
getint ((* yyt)->ACF_TASK_REGION.Label)
getint ((* yyt)->ACF_TASK_REGION.Line)
getint ((* yyt)->ACF_TASK_REGION.task_flag)
yyt = & ((* yyt)->ACF_TASK_REGION.TASK_BODY); break;
case kACF_PARALLEL:
getint ((* yyt)->ACF_PARALLEL.Label)
getint ((* yyt)->ACF_PARALLEL.Line)
gettTree (& ((* yyt)->ACF_PARALLEL.REDUCTION_VARS))
gettTree (& ((* yyt)->ACF_PARALLEL.SHARED_VARS))
gettTree (& ((* yyt)->ACF_PARALLEL.LOCAL_VARS))
yyt = & ((* yyt)->ACF_PARALLEL.PARALLEL_BODY); break;
case kACF_CRITICAL:
getint ((* yyt)->ACF_CRITICAL.Label)
getint ((* yyt)->ACF_CRITICAL.Line)
yyt = & ((* yyt)->ACF_CRITICAL.CRITICAL_BODY); break;
case kACF_ON:
getint ((* yyt)->ACF_ON.Label)
getint ((* yyt)->ACF_ON.Line)
gettTree (& ((* yyt)->ACF_ON.ON_HOME))
gettTree (& ((* yyt)->ACF_ON.ON_SPECS))
yyt = & ((* yyt)->ACF_ON.ON_BODY); break;
case kACF_RM_READ:
getint ((* yyt)->ACF_RM_READ.Label)
getint ((* yyt)->ACF_RM_READ.Line)
gettTree (& ((* yyt)->ACF_RM_READ.LOCAL_VAR))
yyt = & ((* yyt)->ACF_RM_READ.REMOTE_VAR); break;
case kACF_RM_WRITE:
getint ((* yyt)->ACF_RM_WRITE.Label)
getint ((* yyt)->ACF_RM_WRITE.Line)
getint ((* yyt)->ACF_RM_WRITE.op)
gettTree (& ((* yyt)->ACF_RM_WRITE.REMOTE_VAR))
yyt = & ((* yyt)->ACF_RM_WRITE.LOCAL_DATA); break;
case kACF_MOVE:
getint ((* yyt)->ACF_MOVE.Label)
getint ((* yyt)->ACF_MOVE.Line)
yyt = & ((* yyt)->ACF_MOVE.MOVE_STMT); break;
case kACF_BARRIER:
getint ((* yyt)->ACF_BARRIER.Label)
getint ((* yyt)->ACF_BARRIER.Line)
yyt = & ((* yyt)->ACF_BARRIER.BARRIER_VARS); break;
case kACF_UPDATE:
getint ((* yyt)->ACF_UPDATE.Label)
getint ((* yyt)->ACF_UPDATE.Line)
yyt = & ((* yyt)->ACF_UPDATE.OVERLAP_VAR); break;
case kON_VAR_CLAUSE:
yyt = & ((* yyt)->ON_VAR_CLAUSE.ON_VAR); break;
case kON_PROC_CLAUSE:
yyt = & ((* yyt)->ON_PROC_CLAUSE.ON_PROC); break;
case kON_PROCS:
gettObject ((* yyt)->ON_PROCS.topid)
return;
case kON_VAR:
gettObject ((* yyt)->ON_VAR.topid)
gettObject ((* yyt)->ON_VAR.tempid)
gettObject ((* yyt)->ON_VAR.arrayid)
return;
case kON_LIST:
gettTree (& ((* yyt)->ON_LIST.Elem))
yyt = & ((* yyt)->ON_LIST.Next); break;
case kON_SPEC:
getint ((* yyt)->ON_SPEC.top_dim)
getint ((* yyt)->ON_SPEC.temp_dim)
getint ((* yyt)->ON_SPEC.array_dim)
yyt = & ((* yyt)->ON_SPEC.ON_VAL); break;
case kSELECTED_ACF_LIST:
gettTree (& ((* yyt)->SELECTED_ACF_LIST.Elem))
yyt = & ((* yyt)->SELECTED_ACF_LIST.Next); break;
case kSELECTED_ACF_NODE:
gettTree (& ((* yyt)->SELECTED_ACF_NODE.SELECT_LIST))
yyt = & ((* yyt)->SELECTED_ACF_NODE.SELECT_ACFS); break;
case kASSIGN_STMT:
gettTree (& ((* yyt)->ASSIGN_STMT.ASSIGN_VAR))
yyt = & ((* yyt)->ASSIGN_STMT.ASSIGN_EXP); break;
case kPTR_ASSIGN_STMT:
gettTree (& ((* yyt)->PTR_ASSIGN_STMT.ASSIGN_VAR))
yyt = & ((* yyt)->PTR_ASSIGN_STMT.ASSIGN_EXP); break;
case kLABEL_ASSIGN_STMT:
getint ((* yyt)->LABEL_ASSIGN_STMT.assign_label)
yyt = & ((* yyt)->LABEL_ASSIGN_STMT.LABEL_VAR); break;
case kCALL_STMT:
gettTree (& ((* yyt)->CALL_STMT.CALL_ID))
yyt = & ((* yyt)->CALL_STMT.CALL_PARAMS); break;
case kIO_STMT:
gettTree (& ((* yyt)->IO_STMT.ID))
gettTree (& ((* yyt)->IO_STMT.IO_SPECS))
yyt = & ((* yyt)->IO_STMT.IO_ITEMS); break;
case kGOTO_STMT:
getint ((* yyt)->GOTO_STMT.GOTO_LABEL)
return;
case kASS_GOTO_STMT:
gettTree (& ((* yyt)->ASS_GOTO_STMT.GOTO_VAR))
yyt = & ((* yyt)->ASS_GOTO_STMT.LABELS); break;
case kCOMP_GOTO_STMT:
gettTree (& ((* yyt)->COMP_GOTO_STMT.GOTO_LABELS))
yyt = & ((* yyt)->COMP_GOTO_STMT.GOTO_EXP); break;
case kCOMP_IF_STMT:
getint ((* yyt)->COMP_IF_STMT.IF_LT_LABEL)
getint ((* yyt)->COMP_IF_STMT.IF_EQ_LABEL)
getint ((* yyt)->COMP_IF_STMT.IF_GT_LABEL)
yyt = & ((* yyt)->COMP_IF_STMT.IF_EXP); break;
case kRETURN_STMT:
yyt = & ((* yyt)->RETURN_STMT.RETURN_EXP); break;
case kPAUSE_STMT:
yyt = & ((* yyt)->PAUSE_STMT.PAUSE_CONST); break;
case kEXIT_STMT:
gettIdent ((* yyt)->EXIT_STMT.loopid)
return;
case kCYCLE_STMT:
gettIdent ((* yyt)->CYCLE_STMT.loopid)
return;
case kSTOP_STMT:
yyt = & ((* yyt)->STOP_STMT.STOP_CONST); break;
case kFORMAT_STMT:
yyt = & ((* yyt)->FORMAT_STMT.FORMAT_PARAMS); break;
case kINHERIT_DSP_STMT:
gettTree (& ((* yyt)->INHERIT_DSP_STMT.VAR))
getint ((* yyt)->INHERIT_DSP_STMT.flag)
getint ((* yyt)->INHERIT_DSP_STMT.safety)
yyt = & ((* yyt)->INHERIT_DSP_STMT.SHAPE); break;
case kCREATE_DSP_STMT:
gettTree (& ((* yyt)->CREATE_DSP_STMT.VAR))
getint ((* yyt)->CREATE_DSP_STMT.flag)
yyt = & ((* yyt)->CREATE_DSP_STMT.SHAPE); break;
case kFREE_DSP_STMT:
getint ((* yyt)->FREE_DSP_STMT.flag)
yyt = & ((* yyt)->FREE_DSP_STMT.VAR); break;
case kALLOCATE_STMT:
gettTree (& ((* yyt)->ALLOCATE_STMT.PARAMS))
yyt = & ((* yyt)->ALLOCATE_STMT.STATUS); break;
case kDEALLOCATE_STMT:
gettTree (& ((* yyt)->DEALLOCATE_STMT.PARAMS))
yyt = & ((* yyt)->DEALLOCATE_STMT.STATUS); break;
case kNULLIFY_STMT:
yyt = & ((* yyt)->NULLIFY_STMT.PARAMS); break;
case kREDUCE_STMT:
gettTree (& ((* yyt)->REDUCE_STMT.RED_FUNC))
yyt = & ((* yyt)->REDUCE_STMT.RED_PARAMS); break;
case kMOVE_STMT:
gettTree (& ((* yyt)->MOVE_STMT.TARGET))
gettTree (& ((* yyt)->MOVE_STMT.SOURCE))
yyt = & ((* yyt)->MOVE_STMT.MASK); break;
case kSCATTER_STMT:
gettIdent ((* yyt)->SCATTER_STMT.func)
gettTree (& ((* yyt)->SCATTER_STMT.ARRAY))
gettTree (& ((* yyt)->SCATTER_STMT.BASE))
gettTree (& ((* yyt)->SCATTER_STMT.INDEXES))
yyt = & ((* yyt)->SCATTER_STMT.MASK); break;
case kREALIGN_STMT:
gettTree (& ((* yyt)->REALIGN_STMT.ALIGNEE))
gettTree (& ((* yyt)->REALIGN_STMT.ALIGN_SOURCE))
gettDefinitions ((* yyt)->REALIGN_STMT.distribution)
yyt = & ((* yyt)->REALIGN_STMT.ALIGN_TARGET); break;
case kREDISTRIBUTE_STMT:
gettTree (& ((* yyt)->REDISTRIBUTE_STMT.DISTRIBUTEE))
gettTree (& ((* yyt)->REDISTRIBUTE_STMT.DISTRIBUTION))
gettDefinitions ((* yyt)->REDISTRIBUTE_STMT.distribution)
yyt = & ((* yyt)->REDISTRIBUTE_STMT.TARGET); break;
case kREG_SHADOW_GET:
gettTree (& ((* yyt)->REG_SHADOW_GET.SHADOW_VAR))
yyt = & ((* yyt)->REG_SHADOW_GET.SHADOW_SIZE); break;
case kREG_SHADOW_PUT:
getint ((* yyt)->REG_SHADOW_PUT.op)
gettTree (& ((* yyt)->REG_SHADOW_PUT.SHADOW_VAR))
yyt = & ((* yyt)->REG_SHADOW_PUT.SHADOW_SIZE); break;
case kREG_SHADOW_SET:
gettTree (& ((* yyt)->REG_SHADOW_SET.SHADOW_VAR))
gettTree (& ((* yyt)->REG_SHADOW_SET.SHADOW_SIZE))
yyt = & ((* yyt)->REG_SHADOW_SET.VAL); break;
case kIND_SHADOW_CREATE:
getint ((* yyt)->IND_SHADOW_CREATE.id)
gettTree (& ((* yyt)->IND_SHADOW_CREATE.SHADOW_VAR))
gettTree (& ((* yyt)->IND_SHADOW_CREATE.INDEX_VAR))
gettTree (& ((* yyt)->IND_SHADOW_CREATE.TMP_INDEX_VAR))
yyt = & ((* yyt)->IND_SHADOW_CREATE.MASK); break;
case kIND_SHADOW_FREE:
getint ((* yyt)->IND_SHADOW_FREE.id)
yyt = & ((* yyt)->IND_SHADOW_FREE.INDEX_VAR); break;
case kIND_SHADOW_GET:
getint ((* yyt)->IND_SHADOW_GET.id)
yyt = & ((* yyt)->IND_SHADOW_GET.SHADOW_VAR); break;
case kIND_SHADOW_PUT:
getint ((* yyt)->IND_SHADOW_PUT.id)
getint ((* yyt)->IND_SHADOW_PUT.op)
yyt = & ((* yyt)->IND_SHADOW_PUT.SHADOW_VAR); break;
case kIND_SHADOW_SET:
getint ((* yyt)->IND_SHADOW_SET.id)
gettTree (& ((* yyt)->IND_SHADOW_SET.SHADOW_VAR))
yyt = & ((* yyt)->IND_SHADOW_SET.VAL); break;
case kBROADCAST_STMT:
gettTree (& ((* yyt)->BROADCAST_STMT.ELEMS))
gettTree (& ((* yyt)->BROADCAST_STMT.OWNER_TOP))
yyt = & ((* yyt)->BROADCAST_STMT.OWNER_SPEC); break;
case kREDUCTION_STMT:
gettTree (& ((* yyt)->REDUCTION_STMT.REDFUNC))
gettTree (& ((* yyt)->REDUCTION_STMT.ELEMS))
gettTree (& ((* yyt)->REDUCTION_STMT.RED_TOP))
yyt = & ((* yyt)->REDUCTION_STMT.RED_SPEC); break;
case kDIRTY_STMT:
yyt = & ((* yyt)->DIRTY_STMT.ELEMS); break;
case kLABEL_LIST:
getint ((* yyt)->LABEL_LIST.Elem)
yyt = & ((* yyt)->LABEL_LIST.Next); break;
case kOP_DEFINED:
gettIdent ((* yyt)->OP_DEFINED.opname)
return;
case kCONST_EXP:
yyt = & ((* yyt)->CONST_EXP.C); break;
case kOP_EXP:
gettTree (& ((* yyt)->OP_EXP.EXP_OP))
gettTree (& ((* yyt)->OP_EXP.OPND1))
yyt = & ((* yyt)->OP_EXP.OPND2); break;
case kOP1_EXP:
gettTree (& ((* yyt)->OP1_EXP.EXP_OP1))
yyt = & ((* yyt)->OP1_EXP.OPND); break;
case kSLICE_EXP:
gettTree (& ((* yyt)->SLICE_EXP.START))
gettTree (& ((* yyt)->SLICE_EXP.STOP))
yyt = & ((* yyt)->SLICE_EXP.INC); break;
case kVAR_EXP:
yyt = & ((* yyt)->VAR_EXP.V); break;
case kFUNC_CALL_EXP:
gettTree (& ((* yyt)->FUNC_CALL_EXP.FUNC_ID))
yyt = & ((* yyt)->FUNC_CALL_EXP.FUNC_PARAMS); break;
case kNAMED_EXP:
gettIdent ((* yyt)->NAMED_EXP.Name)
yyt = & ((* yyt)->NAMED_EXP.VAL); break;
case kDO_EXP:
gettTree (& ((* yyt)->DO_EXP.DO_ID))
gettTree (& ((* yyt)->DO_EXP.RANGE))
yyt = & ((* yyt)->DO_EXP.BODY); break;
case kTYPE_EXP:
gettTree (& ((* yyt)->TYPE_EXP.ID))
yyt = & ((* yyt)->TYPE_EXP.ELEMENTS); break;
case kARRAY_EXP:
yyt = & ((* yyt)->ARRAY_EXP.ELEMENTS); break;
case kPERM_EXP:
getPermutation ((* yyt)->PERM_EXP.perm)
yyt = & ((* yyt)->PERM_EXP.VAL); break;
case kBOUND_EXP:
getint ((* yyt)->BOUND_EXP.dim)
getint ((* yyt)->BOUND_EXP.kind)
getint ((* yyt)->BOUND_EXP.local)
yyt = & ((* yyt)->BOUND_EXP.VAR); break;
case kRANK_EXP:
getint ((* yyt)->RANK_EXP.kind)
return;
case kBTE_LIST:
gettTree (& ((* yyt)->BTE_LIST.Elem))
yyt = & ((* yyt)->BTE_LIST.Next); break;
case kUSED_VAR:
yyt = & ((* yyt)->USED_VAR.VARNAME); break;
case kINDEXED_VAR:
gettTree (& ((* yyt)->INDEXED_VAR.IND_VAR))
yyt = & ((* yyt)->INDEXED_VAR.IND_EXPS); break;
case kSUBSTRING_VAR:
gettTree (& ((* yyt)->SUBSTRING_VAR.IND_VAR))
yyt = & ((* yyt)->SUBSTRING_VAR.IND_EXP); break;
case kSELECTED_VAR:
gettTree (& ((* yyt)->SELECTED_VAR.SELEC_VAR))
yyt = & ((* yyt)->SELECTED_VAR.SELECTOR); break;
case kLOOP_VAR:
yyt = & ((* yyt)->LOOP_VAR.LOOP_VARNAME); break;
case kPERM_VAR:
getPermutation ((* yyt)->PERM_VAR.perm)
yyt = & ((* yyt)->PERM_VAR.VAL); break;
case kADDR:
yyt = & ((* yyt)->ADDR.E); break;
case kDO_VAR:
gettTree (& ((* yyt)->DO_VAR.DO_ID))
gettTree (& ((* yyt)->DO_VAR.RANGE))
yyt = & ((* yyt)->DO_VAR.BODY); break;
case kREMOTE_VAR:
yyt = & ((* yyt)->REMOTE_VAR.VAR); break;
case kBTV_LIST:
gettTree (& ((* yyt)->BTV_LIST.Elem))
yyt = & ((* yyt)->BTV_LIST.Next); break;
case kVAR_PARAM:
gettDefinitions ((* yyt)->VAR_PARAM.formal)
getint ((* yyt)->VAR_PARAM.intent)
getint ((* yyt)->VAR_PARAM.layout)
getint ((* yyt)->VAR_PARAM.pass_by)
getint ((* yyt)->VAR_PARAM.trace)
yyt = & ((* yyt)->VAR_PARAM.V); break;
case kVALUE_PARAM:
yyt = & ((* yyt)->VALUE_PARAM.E); break;
case kNAMED_PARAM:
gettIdent ((* yyt)->NAMED_PARAM.Name)
yyt = & ((* yyt)->NAMED_PARAM.VAL); break;
case kPROC_PARAM:
yyt = & ((* yyt)->PROC_PARAM.P); break;
case kFUNC_PARAM:
yyt = & ((* yyt)->FUNC_PARAM.F); break;
case kFORMAT_PARAM:
gettStringRef ((* yyt)->FORMAT_PARAM.S)
return;
case kRETURN_PARAM:
getint ((* yyt)->RETURN_PARAM.label)
return;
case kNO_PARAM:
getint ((* yyt)->NO_PARAM.type)
return;
case kBTP_LIST:
gettTree (& ((* yyt)->BTP_LIST.Elem))
yyt = & ((* yyt)->BTP_LIST.Next); break;
case kBOOL_CONSTANT:
getint ((* yyt)->BOOL_CONSTANT.value)
return;
case kINT_CONSTANT:
getint ((* yyt)->INT_CONSTANT.value)
return;
case kREAL_CONSTANT:
gettStringRef ((* yyt)->REAL_CONSTANT.value)
getint ((* yyt)->REAL_CONSTANT.kind)
return;
case kSTRING_CONSTANT:
gettStringRef ((* yyt)->STRING_CONSTANT.value)
return;
case kCOMPLEX_CONSTANT:
gettStringRef ((* yyt)->COMPLEX_CONSTANT.rvalue)
gettStringRef ((* yyt)->COMPLEX_CONSTANT.ivalue)
return;
case kPROC_OBJ:
gettIdent ((* yyt)->PROC_OBJ.Ident)
gettDefinitions ((* yyt)->PROC_OBJ.Object)
return;
case kVAR_OBJ:
getint ((* yyt)->VAR_OBJ.Pos)
gettIdent ((* yyt)->VAR_OBJ.Ident)
gettDefinitions ((* yyt)->VAR_OBJ.Object)
gettReaching ((* yyt)->VAR_OBJ.Reaching)
return;
case kTYPE_OBJ:
gettIdent ((* yyt)->TYPE_OBJ.Ident)
gettDefinitions ((* yyt)->TYPE_OBJ.Object)
return;
case kREC_COMP:
gettIdent ((* yyt)->REC_COMP.Ident)
gettDefinitions ((* yyt)->REC_COMP.Object)
return;
case kTOP_OBJ:
gettIdent ((* yyt)->TOP_OBJ.Ident)
gettDefinitions ((* yyt)->TOP_OBJ.Object)
return;
case kTEMP_OBJ:
gettIdent ((* yyt)->TEMP_OBJ.Ident)
gettDefinitions ((* yyt)->TEMP_OBJ.Object)
return;
case kOVERLAP_SPEC:
getint ((* yyt)->OVERLAP_SPEC.left_size)
getint ((* yyt)->OVERLAP_SPEC.right_size)
getint ((* yyt)->OVERLAP_SPEC.left_update)
getint ((* yyt)->OVERLAP_SPEC.right_update)
return;
case kINDEP_INFO:
getbool ((* yyt)->INDEP_INFO.user_independent)
getint ((* yyt)->INDEP_INFO.selection)
getInfoTree ((* yyt)->INDEP_INFO.red_vars)
getInfoTree ((* yyt)->INDEP_INFO.new_vars)
return;
case kVECTOR_INFO:
getbool ((* yyt)->VECTOR_INFO.is_independent)
getint ((* yyt)->VECTOR_INFO.selection)
getint ((* yyt)->VECTOR_INFO.loop_cnt)
getInfoTree ((* yyt)->VECTOR_INFO.independent_vars)
return;
case kCOMM_INFO:
getInfoTree ((* yyt)->COMM_INFO.home_var)
getbool ((* yyt)->COMM_INFO.is_local)
return;
case kON_INFO:
gettObject ((* yyt)->ON_INFO.on_id)
getint ((* yyt)->ON_INFO.on_dim)
getint ((* yyt)->ON_INFO.base)
getint ((* yyt)->ON_INFO.stride)
return;
case kPARALLEL_INFO:
getInfoTree ((* yyt)->PARALLEL_INFO.reduction_vars)
getInfoTree ((* yyt)->PARALLEL_INFO.home_var)
getInfoTree ((* yyt)->PARALLEL_INFO.new_vars)
getInfoTree ((* yyt)->PARALLEL_INFO.resident_vars)
return;
case kREACHING_INFO:
getInfoTree ((* yyt)->REACHING_INFO.var_allocate)
getInfoTree ((* yyt)->REACHING_INFO.temp_allocate)
gettDefinitions ((* yyt)->REACHING_INFO.var_distribution)
gettDefinitions ((* yyt)->REACHING_INFO.temp_distribution)
return;
  default: return;
  }
 }
}

tTree GetTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf)
# else
 (yyyf) FILE * yyyf;
# endif
{
 tTree yyt;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyGetTree (& yyt);
 yyRecursionLevel --;
 return yyt;
}

tTree ReverseTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register tTree yyNew, yyNext, yyTail;
 yyNew = yyOld;
 yyTail = yyOld;
 for (;;) {
  switch (yyOld->Kind) {
  default: goto yyExit;
  }
  yyNew = yyOld;
  yyOld = yyNext;
 }
yyExit:
 switch (yyTail->Kind) {
 default: ;
 }
 return yyNew;
}

# define yyInitOldToNewStoreSize 32

typedef struct { tTree yyOld, yyNew; } yytOldToNew;
static unsigned long yyOldToNewStoreSize = yyInitOldToNewStoreSize;
static yytOldToNew yyOldToNewStore [yyInitOldToNewStoreSize];
static yytOldToNew * yyOldToNewStorePtr = yyOldToNewStore;
static int yyOldToNewCount;

static void yyStoreOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld, tTree yyNew)
# else
 (yyOld, yyNew) tTree yyOld, yyNew;
# endif
{
 if (++ yyOldToNewCount == yyOldToNewStoreSize)
  ExtendArray ((char * *) & yyOldToNewStorePtr, & yyOldToNewStoreSize, sizeof (yytOldToNew));
 yyOldToNewStorePtr [yyOldToNewCount].yyOld = yyOld;
 yyOldToNewStorePtr [yyOldToNewCount].yyNew = yyNew;
}

static tTree yyMapOldToNew
# if defined __STDC__ | defined __cplusplus
 (tTree yyOld)
# else
 (yyOld) tTree yyOld;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyOldToNewCount; yyi ++)
  if (yyOldToNewStorePtr [yyi].yyOld == yyOld) return yyOldToNewStorePtr [yyi].yyNew;
}

static tTree yyCopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt, yyPtrtTree yyNew)
# else
 (yyt, yyNew) tTree yyt; yyPtrtTree yyNew;
# endif
{
 for (;;) {
  if (yyt == NoTree) { * yyNew = NoTree; return; }
  if (yyt->yyHead.yyMark == 0) { * yyNew = yyMapOldToNew (yyt); return; }
  yyALLOC (* yyNew, Tree_NodeSize [yyt->Kind])
  if (yyt->yyHead.yyMark > 1) { yyStoreOldToNew (yyt, * yyNew); }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kCOMP_UNIT: (* yyNew)->COMP_UNIT = yyt->COMP_UNIT;
copytTree ((* yyNew)->COMP_UNIT.COMP_ELEMENTS, yyt->COMP_UNIT.COMP_ELEMENTS)
yyt = yyt->COMP_UNIT.USED_ELEMENTS;
yyNew = & (* yyNew)->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_NODE_LIST: (* yyNew)->UNIT_NODE_LIST = yyt->UNIT_NODE_LIST;
return;
case kUNIT_EMPTY: (* yyNew)->UNIT_EMPTY = yyt->UNIT_EMPTY;
return;
case kUNIT_LIST: (* yyNew)->UNIT_LIST = yyt->UNIT_LIST;
copytTree ((* yyNew)->UNIT_LIST.Elem, yyt->UNIT_LIST.Elem)
yyt = yyt->UNIT_LIST.Next;
yyNew = & (* yyNew)->UNIT_LIST.Next; break;
case kUNIT_NODE: (* yyNew)->UNIT_NODE = yyt->UNIT_NODE;
copytIdent ((* yyNew)->UNIT_NODE.Ident, yyt->UNIT_NODE.Ident)
copyint ((* yyNew)->UNIT_NODE.Line, yyt->UNIT_NODE.Line)
copytDefinitions ((* yyNew)->UNIT_NODE.Object, yyt->UNIT_NODE.Object)
return;
case kMODULE_DECL: (* yyNew)->MODULE_DECL = yyt->MODULE_DECL;
copytIdent ((* yyNew)->MODULE_DECL.Ident, yyt->MODULE_DECL.Ident)
copyint ((* yyNew)->MODULE_DECL.Line, yyt->MODULE_DECL.Line)
copytDefinitions ((* yyNew)->MODULE_DECL.Object, yyt->MODULE_DECL.Object)
yyt = yyt->MODULE_DECL.MODULE_BODY;
yyNew = & (* yyNew)->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL: (* yyNew)->PROGRAM_DECL = yyt->PROGRAM_DECL;
copytIdent ((* yyNew)->PROGRAM_DECL.Ident, yyt->PROGRAM_DECL.Ident)
copyint ((* yyNew)->PROGRAM_DECL.Line, yyt->PROGRAM_DECL.Line)
copytDefinitions ((* yyNew)->PROGRAM_DECL.Object, yyt->PROGRAM_DECL.Object)
copytTree ((* yyNew)->PROGRAM_DECL.FORMALS, yyt->PROGRAM_DECL.FORMALS)
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY;
yyNew = & (* yyNew)->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL: (* yyNew)->PROC_DECL = yyt->PROC_DECL;
copytIdent ((* yyNew)->PROC_DECL.Ident, yyt->PROC_DECL.Ident)
copyint ((* yyNew)->PROC_DECL.Line, yyt->PROC_DECL.Line)
copytDefinitions ((* yyNew)->PROC_DECL.Object, yyt->PROC_DECL.Object)
copytTree ((* yyNew)->PROC_DECL.FORMALS, yyt->PROC_DECL.FORMALS)
copybool ((* yyNew)->PROC_DECL.IsRecursive, yyt->PROC_DECL.IsRecursive)
copybool ((* yyNew)->PROC_DECL.IsPure, yyt->PROC_DECL.IsPure)
copytIdent ((* yyNew)->PROC_DECL.HPFExtrinsic, yyt->PROC_DECL.HPFExtrinsic)
yyt = yyt->PROC_DECL.PROC_BODY;
yyNew = & (* yyNew)->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL: (* yyNew)->FUNC_DECL = yyt->FUNC_DECL;
copytIdent ((* yyNew)->FUNC_DECL.Ident, yyt->FUNC_DECL.Ident)
copyint ((* yyNew)->FUNC_DECL.Line, yyt->FUNC_DECL.Line)
copytDefinitions ((* yyNew)->FUNC_DECL.Object, yyt->FUNC_DECL.Object)
copytTree ((* yyNew)->FUNC_DECL.FORMALS, yyt->FUNC_DECL.FORMALS)
copytTree ((* yyNew)->FUNC_DECL.FUNC_BODY, yyt->FUNC_DECL.FUNC_BODY)
copytIdent ((* yyNew)->FUNC_DECL.RESULT_ID, yyt->FUNC_DECL.RESULT_ID)
copybool ((* yyNew)->FUNC_DECL.IsRecursive, yyt->FUNC_DECL.IsRecursive)
copybool ((* yyNew)->FUNC_DECL.IsPure, yyt->FUNC_DECL.IsPure)
copytIdent ((* yyNew)->FUNC_DECL.HPFExtrinsic, yyt->FUNC_DECL.HPFExtrinsic)
yyt = yyt->FUNC_DECL.RESULT_TYPE;
yyNew = & (* yyNew)->FUNC_DECL.RESULT_TYPE; break;
case kMODULE_PROC_DECL: (* yyNew)->MODULE_PROC_DECL = yyt->MODULE_PROC_DECL;
copytIdent ((* yyNew)->MODULE_PROC_DECL.Ident, yyt->MODULE_PROC_DECL.Ident)
copyint ((* yyNew)->MODULE_PROC_DECL.Line, yyt->MODULE_PROC_DECL.Line)
copytDefinitions ((* yyNew)->MODULE_PROC_DECL.Object, yyt->MODULE_PROC_DECL.Object)
return;
case kBLOCK_DATA_DECL: (* yyNew)->BLOCK_DATA_DECL = yyt->BLOCK_DATA_DECL;
copytIdent ((* yyNew)->BLOCK_DATA_DECL.Ident, yyt->BLOCK_DATA_DECL.Ident)
copyint ((* yyNew)->BLOCK_DATA_DECL.Line, yyt->BLOCK_DATA_DECL.Line)
copytDefinitions ((* yyNew)->BLOCK_DATA_DECL.Object, yyt->BLOCK_DATA_DECL.Object)
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY;
yyNew = & (* yyNew)->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE: (* yyNew)->INTERFACE = yyt->INTERFACE;
copytIdent ((* yyNew)->INTERFACE.Ident, yyt->INTERFACE.Ident)
copyint ((* yyNew)->INTERFACE.Line, yyt->INTERFACE.Line)
copytDefinitions ((* yyNew)->INTERFACE.Object, yyt->INTERFACE.Object)
copytTree ((* yyNew)->INTERFACE.SPEC, yyt->INTERFACE.SPEC)
yyt = yyt->INTERFACE.ITEMS;
yyNew = & (* yyNew)->INTERFACE.ITEMS; break;
case kBODY_NODE: (* yyNew)->BODY_NODE = yyt->BODY_NODE;
copytTree ((* yyNew)->BODY_NODE.DECLS, yyt->BODY_NODE.DECLS)
copytTree ((* yyNew)->BODY_NODE.STATS, yyt->BODY_NODE.STATS)
yyt = yyt->BODY_NODE.INTERNALS;
yyNew = & (* yyNew)->BODY_NODE.INTERNALS; break;
case kTYPE_NODE: (* yyNew)->TYPE_NODE = yyt->TYPE_NODE;
return;
case kDUMMY_TYPE: (* yyNew)->DUMMY_TYPE = yyt->DUMMY_TYPE;
return;
case kALIGN_TYPE: (* yyNew)->ALIGN_TYPE = yyt->ALIGN_TYPE;
return;
case kINTEGER_TYPE: (* yyNew)->INTEGER_TYPE = yyt->INTEGER_TYPE;
yyt = yyt->INTEGER_TYPE.SIZE;
yyNew = & (* yyNew)->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE: (* yyNew)->REAL_TYPE = yyt->REAL_TYPE;
yyt = yyt->REAL_TYPE.SIZE;
yyNew = & (* yyNew)->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE: (* yyNew)->BOOLEAN_TYPE = yyt->BOOLEAN_TYPE;
yyt = yyt->BOOLEAN_TYPE.SIZE;
yyNew = & (* yyNew)->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE: (* yyNew)->COMPLEX_TYPE = yyt->COMPLEX_TYPE;
yyt = yyt->COMPLEX_TYPE.SIZE;
yyNew = & (* yyNew)->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE: (* yyNew)->STRING_TYPE = yyt->STRING_TYPE;
yyt = yyt->STRING_TYPE.LENGTH;
yyNew = & (* yyNew)->STRING_TYPE.LENGTH; break;
case kTYPE_ID: (* yyNew)->TYPE_ID = yyt->TYPE_ID;
yyt = yyt->TYPE_ID.ID;
yyNew = & (* yyNew)->TYPE_ID.ID; break;
case kARRAY_TYPE: (* yyNew)->ARRAY_TYPE = yyt->ARRAY_TYPE;
copytTree ((* yyNew)->ARRAY_TYPE.ARRAY_INDEX_TYPES, yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES)
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE;
yyNew = & (* yyNew)->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE: (* yyNew)->RECORD_TYPE = yyt->RECORD_TYPE;
copytIdent ((* yyNew)->RECORD_TYPE.Name, yyt->RECORD_TYPE.Name)
yyt = yyt->RECORD_TYPE.COMPONENTS;
yyNew = & (* yyNew)->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE: (* yyNew)->POINTER_TYPE = yyt->POINTER_TYPE;
yyt = yyt->POINTER_TYPE.PTR_COMP;
yyNew = & (* yyNew)->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC: (* yyNew)->SHAPE_SPEC = yyt->SHAPE_SPEC;
yyt = yyt->SHAPE_SPEC.Overlap;
yyNew = & (* yyNew)->SHAPE_SPEC.Overlap; break;
case kEXPLICIT_SHAPE: (* yyNew)->EXPLICIT_SHAPE = yyt->EXPLICIT_SHAPE;
copytTree ((* yyNew)->EXPLICIT_SHAPE.Overlap, yyt->EXPLICIT_SHAPE.Overlap)
copytTree ((* yyNew)->EXPLICIT_SHAPE.LOWER, yyt->EXPLICIT_SHAPE.LOWER)
yyt = yyt->EXPLICIT_SHAPE.UPPER;
yyNew = & (* yyNew)->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE: (* yyNew)->ASSUMED_SHAPE = yyt->ASSUMED_SHAPE;
copytTree ((* yyNew)->ASSUMED_SHAPE.Overlap, yyt->ASSUMED_SHAPE.Overlap)
yyt = yyt->ASSUMED_SHAPE.LOWER;
yyNew = & (* yyNew)->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE: (* yyNew)->DEFERRED_SHAPE = yyt->DEFERRED_SHAPE;
yyt = yyt->DEFERRED_SHAPE.Overlap;
yyNew = & (* yyNew)->DEFERRED_SHAPE.Overlap; break;
case kASSUMED_SIZE: (* yyNew)->ASSUMED_SIZE = yyt->ASSUMED_SIZE;
copytTree ((* yyNew)->ASSUMED_SIZE.Overlap, yyt->ASSUMED_SIZE.Overlap)
yyt = yyt->ASSUMED_SIZE.LOWER;
yyNew = & (* yyNew)->ASSUMED_SIZE.LOWER; break;
case kSHAPE_SPEC_LIST: (* yyNew)->SHAPE_SPEC_LIST = yyt->SHAPE_SPEC_LIST;
return;
case kSHAPE_EMPTY: (* yyNew)->SHAPE_EMPTY = yyt->SHAPE_EMPTY;
return;
case kSHAPE_LIST: (* yyNew)->SHAPE_LIST = yyt->SHAPE_LIST;
copytTree ((* yyNew)->SHAPE_LIST.Elem, yyt->SHAPE_LIST.Elem)
yyt = yyt->SHAPE_LIST.Next;
yyNew = & (* yyNew)->SHAPE_LIST.Next; break;
case kDECL_NODE: (* yyNew)->DECL_NODE = yyt->DECL_NODE;
copytIdent ((* yyNew)->DECL_NODE.Ident, yyt->DECL_NODE.Ident)
copyint ((* yyNew)->DECL_NODE.Line, yyt->DECL_NODE.Line)
return;
case kTYPE_DECL: (* yyNew)->TYPE_DECL = yyt->TYPE_DECL;
copytIdent ((* yyNew)->TYPE_DECL.Ident, yyt->TYPE_DECL.Ident)
copyint ((* yyNew)->TYPE_DECL.Line, yyt->TYPE_DECL.Line)
yyt = yyt->TYPE_DECL.VAL;
yyNew = & (* yyNew)->TYPE_DECL.VAL; break;
case kNAME_DECL: (* yyNew)->NAME_DECL = yyt->NAME_DECL;
copytIdent ((* yyNew)->NAME_DECL.Ident, yyt->NAME_DECL.Ident)
copyint ((* yyNew)->NAME_DECL.Line, yyt->NAME_DECL.Line)
return;
case kRENAME_DECL: (* yyNew)->RENAME_DECL = yyt->RENAME_DECL;
copytIdent ((* yyNew)->RENAME_DECL.Ident, yyt->RENAME_DECL.Ident)
copyint ((* yyNew)->RENAME_DECL.Line, yyt->RENAME_DECL.Line)
copytIdent ((* yyNew)->RENAME_DECL.oldname, yyt->RENAME_DECL.oldname)
return;
case kENTITY_DECL: (* yyNew)->ENTITY_DECL = yyt->ENTITY_DECL;
copytIdent ((* yyNew)->ENTITY_DECL.Ident, yyt->ENTITY_DECL.Ident)
copyint ((* yyNew)->ENTITY_DECL.Line, yyt->ENTITY_DECL.Line)
yyt = yyt->ENTITY_DECL.ATTRIBUTES;
yyNew = & (* yyNew)->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL: (* yyNew)->VAR_DECL = yyt->VAR_DECL;
copytIdent ((* yyNew)->VAR_DECL.Ident, yyt->VAR_DECL.Ident)
copyint ((* yyNew)->VAR_DECL.Line, yyt->VAR_DECL.Line)
yyt = yyt->VAR_DECL.VAL;
yyNew = & (* yyNew)->VAR_DECL.VAL; break;
case kCOMMON_DECL: (* yyNew)->COMMON_DECL = yyt->COMMON_DECL;
copytIdent ((* yyNew)->COMMON_DECL.Ident, yyt->COMMON_DECL.Ident)
copyint ((* yyNew)->COMMON_DECL.Line, yyt->COMMON_DECL.Line)
yyt = yyt->COMMON_DECL.IDS;
yyNew = & (* yyNew)->COMMON_DECL.IDS; break;
case kNAMELIST_DECL: (* yyNew)->NAMELIST_DECL = yyt->NAMELIST_DECL;
copytIdent ((* yyNew)->NAMELIST_DECL.Ident, yyt->NAMELIST_DECL.Ident)
copyint ((* yyNew)->NAMELIST_DECL.Line, yyt->NAMELIST_DECL.Line)
yyt = yyt->NAMELIST_DECL.IDS;
yyNew = & (* yyNew)->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL: (* yyNew)->TEMPLATE_DECL = yyt->TEMPLATE_DECL;
copytIdent ((* yyNew)->TEMPLATE_DECL.Ident, yyt->TEMPLATE_DECL.Ident)
copyint ((* yyNew)->TEMPLATE_DECL.Line, yyt->TEMPLATE_DECL.Line)
yyt = yyt->TEMPLATE_DECL.DIMENSIONS;
yyNew = & (* yyNew)->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL: (* yyNew)->RAGGED_DECL = yyt->RAGGED_DECL;
copytIdent ((* yyNew)->RAGGED_DECL.Ident, yyt->RAGGED_DECL.Ident)
copyint ((* yyNew)->RAGGED_DECL.Line, yyt->RAGGED_DECL.Line)
yyt = yyt->RAGGED_DECL.DIMENSIONS;
yyNew = & (* yyNew)->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL: (* yyNew)->PROCESSORS_DECL = yyt->PROCESSORS_DECL;
copytIdent ((* yyNew)->PROCESSORS_DECL.Ident, yyt->PROCESSORS_DECL.Ident)
copyint ((* yyNew)->PROCESSORS_DECL.Line, yyt->PROCESSORS_DECL.Line)
yyt = yyt->PROCESSORS_DECL.DIMENSIONS;
yyNew = & (* yyNew)->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL: (* yyNew)->SUB_PROCS_DECL = yyt->SUB_PROCS_DECL;
copytIdent ((* yyNew)->SUB_PROCS_DECL.Ident, yyt->SUB_PROCS_DECL.Ident)
copyint ((* yyNew)->SUB_PROCS_DECL.Line, yyt->SUB_PROCS_DECL.Line)
copytTree ((* yyNew)->SUB_PROCS_DECL.TOP, yyt->SUB_PROCS_DECL.TOP)
yyt = yyt->SUB_PROCS_DECL.DIMENSIONS;
yyNew = & (* yyNew)->SUB_PROCS_DECL.DIMENSIONS; break;
case kINHERIT_DECL: (* yyNew)->INHERIT_DECL = yyt->INHERIT_DECL;
copytIdent ((* yyNew)->INHERIT_DECL.Ident, yyt->INHERIT_DECL.Ident)
copyint ((* yyNew)->INHERIT_DECL.Line, yyt->INHERIT_DECL.Line)
return;
case kRANGE_DECL: (* yyNew)->RANGE_DECL = yyt->RANGE_DECL;
copytIdent ((* yyNew)->RANGE_DECL.Ident, yyt->RANGE_DECL.Ident)
copyint ((* yyNew)->RANGE_DECL.Line, yyt->RANGE_DECL.Line)
yyt = yyt->RANGE_DECL.RANGES;
yyNew = & (* yyNew)->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL: (* yyNew)->STMT_FUNC_DECL = yyt->STMT_FUNC_DECL;
copytIdent ((* yyNew)->STMT_FUNC_DECL.Ident, yyt->STMT_FUNC_DECL.Ident)
copyint ((* yyNew)->STMT_FUNC_DECL.Line, yyt->STMT_FUNC_DECL.Line)
copytTree ((* yyNew)->STMT_FUNC_DECL.FORMALS, yyt->STMT_FUNC_DECL.FORMALS)
copytTree ((* yyNew)->STMT_FUNC_DECL.RESULT_TYPE, yyt->STMT_FUNC_DECL.RESULT_TYPE)
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY;
yyNew = & (* yyNew)->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL: (* yyNew)->INTERFACE_DECL = yyt->INTERFACE_DECL;
copytIdent ((* yyNew)->INTERFACE_DECL.Ident, yyt->INTERFACE_DECL.Ident)
copyint ((* yyNew)->INTERFACE_DECL.Line, yyt->INTERFACE_DECL.Line)
copytTree ((* yyNew)->INTERFACE_DECL.SPEC, yyt->INTERFACE_DECL.SPEC)
yyt = yyt->INTERFACE_DECL.ITEMS;
yyNew = & (* yyNew)->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL: (* yyNew)->VAR_PARAM_DECL = yyt->VAR_PARAM_DECL;
copytIdent ((* yyNew)->VAR_PARAM_DECL.Ident, yyt->VAR_PARAM_DECL.Ident)
copyint ((* yyNew)->VAR_PARAM_DECL.Line, yyt->VAR_PARAM_DECL.Line)
yyt = yyt->VAR_PARAM_DECL.VAL;
yyNew = & (* yyNew)->VAR_PARAM_DECL.VAL; break;
case kRET_PARAM_DECL: (* yyNew)->RET_PARAM_DECL = yyt->RET_PARAM_DECL;
copytIdent ((* yyNew)->RET_PARAM_DECL.Ident, yyt->RET_PARAM_DECL.Ident)
copyint ((* yyNew)->RET_PARAM_DECL.Line, yyt->RET_PARAM_DECL.Line)
return;
case kIMPLICIT_DECL: (* yyNew)->IMPLICIT_DECL = yyt->IMPLICIT_DECL;
copytIdent ((* yyNew)->IMPLICIT_DECL.Ident, yyt->IMPLICIT_DECL.Ident)
copyint ((* yyNew)->IMPLICIT_DECL.Line, yyt->IMPLICIT_DECL.Line)
copytIdent ((* yyNew)->IMPLICIT_DECL.first, yyt->IMPLICIT_DECL.first)
copytIdent ((* yyNew)->IMPLICIT_DECL.last, yyt->IMPLICIT_DECL.last)
yyt = yyt->IMPLICIT_DECL.TYPE;
yyNew = & (* yyNew)->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL: (* yyNew)->USE_DECL = yyt->USE_DECL;
copytIdent ((* yyNew)->USE_DECL.Ident, yyt->USE_DECL.Ident)
copyint ((* yyNew)->USE_DECL.Line, yyt->USE_DECL.Line)
copytIdent ((* yyNew)->USE_DECL.use, yyt->USE_DECL.use)
yyt = yyt->USE_DECL.RENAMINGS;
yyNew = & (* yyNew)->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL: (* yyNew)->ONLY_USE_DECL = yyt->ONLY_USE_DECL;
copytIdent ((* yyNew)->ONLY_USE_DECL.Ident, yyt->ONLY_USE_DECL.Ident)
copyint ((* yyNew)->ONLY_USE_DECL.Line, yyt->ONLY_USE_DECL.Line)
copytIdent ((* yyNew)->ONLY_USE_DECL.use, yyt->ONLY_USE_DECL.use)
yyt = yyt->ONLY_USE_DECL.NAMES;
yyNew = & (* yyNew)->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL: (* yyNew)->EQV_DECL = yyt->EQV_DECL;
copytIdent ((* yyNew)->EQV_DECL.Ident, yyt->EQV_DECL.Ident)
copyint ((* yyNew)->EQV_DECL.Line, yyt->EQV_DECL.Line)
yyt = yyt->EQV_DECL.VARS;
yyNew = & (* yyNew)->EQV_DECL.VARS; break;
case kDATA_DECL: (* yyNew)->DATA_DECL = yyt->DATA_DECL;
copytIdent ((* yyNew)->DATA_DECL.Ident, yyt->DATA_DECL.Ident)
copyint ((* yyNew)->DATA_DECL.Line, yyt->DATA_DECL.Line)
copytTree ((* yyNew)->DATA_DECL.VARS, yyt->DATA_DECL.VARS)
yyt = yyt->DATA_DECL.VALS;
yyNew = & (* yyNew)->DATA_DECL.VALS; break;
case kFORMAT_DECL: (* yyNew)->FORMAT_DECL = yyt->FORMAT_DECL;
copytIdent ((* yyNew)->FORMAT_DECL.Ident, yyt->FORMAT_DECL.Ident)
copyint ((* yyNew)->FORMAT_DECL.Line, yyt->FORMAT_DECL.Line)
copyint ((* yyNew)->FORMAT_DECL.label, yyt->FORMAT_DECL.label)
yyt = yyt->FORMAT_DECL.FORMAT_PARAMS;
yyNew = & (* yyNew)->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL: (* yyNew)->DIMENSION_DECL = yyt->DIMENSION_DECL;
copytIdent ((* yyNew)->DIMENSION_DECL.Ident, yyt->DIMENSION_DECL.Ident)
copyint ((* yyNew)->DIMENSION_DECL.Line, yyt->DIMENSION_DECL.Line)
yyt = yyt->DIMENSION_DECL.INDEXES;
yyNew = & (* yyNew)->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL: (* yyNew)->INIT_DATA_DECL = yyt->INIT_DATA_DECL;
copytIdent ((* yyNew)->INIT_DATA_DECL.Ident, yyt->INIT_DATA_DECL.Ident)
copyint ((* yyNew)->INIT_DATA_DECL.Line, yyt->INIT_DATA_DECL.Line)
yyt = yyt->INIT_DATA_DECL.VAL;
yyNew = & (* yyNew)->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL: (* yyNew)->TYPESPEC_DECL = yyt->TYPESPEC_DECL;
copytIdent ((* yyNew)->TYPESPEC_DECL.Ident, yyt->TYPESPEC_DECL.Ident)
copyint ((* yyNew)->TYPESPEC_DECL.Line, yyt->TYPESPEC_DECL.Line)
yyt = yyt->TYPESPEC_DECL.VAL;
yyNew = & (* yyNew)->TYPESPEC_DECL.VAL; break;
case kALLOCATABLE_DECL: (* yyNew)->ALLOCATABLE_DECL = yyt->ALLOCATABLE_DECL;
copytIdent ((* yyNew)->ALLOCATABLE_DECL.Ident, yyt->ALLOCATABLE_DECL.Ident)
copyint ((* yyNew)->ALLOCATABLE_DECL.Line, yyt->ALLOCATABLE_DECL.Line)
return;
case kEXTERNAL_DECL: (* yyNew)->EXTERNAL_DECL = yyt->EXTERNAL_DECL;
copytIdent ((* yyNew)->EXTERNAL_DECL.Ident, yyt->EXTERNAL_DECL.Ident)
copyint ((* yyNew)->EXTERNAL_DECL.Line, yyt->EXTERNAL_DECL.Line)
return;
case kINTENT_DECL: (* yyNew)->INTENT_DECL = yyt->INTENT_DECL;
copytIdent ((* yyNew)->INTENT_DECL.Ident, yyt->INTENT_DECL.Ident)
copyint ((* yyNew)->INTENT_DECL.Line, yyt->INTENT_DECL.Line)
copyint ((* yyNew)->INTENT_DECL.intent, yyt->INTENT_DECL.intent)
return;
case kINTRINSIC_DECL: (* yyNew)->INTRINSIC_DECL = yyt->INTRINSIC_DECL;
copytIdent ((* yyNew)->INTRINSIC_DECL.Ident, yyt->INTRINSIC_DECL.Ident)
copyint ((* yyNew)->INTRINSIC_DECL.Line, yyt->INTRINSIC_DECL.Line)
copytIdent ((* yyNew)->INTRINSIC_DECL.generic, yyt->INTRINSIC_DECL.generic)
copyint ((* yyNew)->INTRINSIC_DECL.class, yyt->INTRINSIC_DECL.class)
copyint ((* yyNew)->INTRINSIC_DECL.kind, yyt->INTRINSIC_DECL.kind)
return;
case kOPTIONAL_DECL: (* yyNew)->OPTIONAL_DECL = yyt->OPTIONAL_DECL;
copytIdent ((* yyNew)->OPTIONAL_DECL.Ident, yyt->OPTIONAL_DECL.Ident)
copyint ((* yyNew)->OPTIONAL_DECL.Line, yyt->OPTIONAL_DECL.Line)
return;
case kPOINTER_DECL: (* yyNew)->POINTER_DECL = yyt->POINTER_DECL;
copytIdent ((* yyNew)->POINTER_DECL.Ident, yyt->POINTER_DECL.Ident)
copyint ((* yyNew)->POINTER_DECL.Line, yyt->POINTER_DECL.Line)
return;
case kSAVE_DECL: (* yyNew)->SAVE_DECL = yyt->SAVE_DECL;
copytIdent ((* yyNew)->SAVE_DECL.Ident, yyt->SAVE_DECL.Ident)
copyint ((* yyNew)->SAVE_DECL.Line, yyt->SAVE_DECL.Line)
return;
case kTARGET_DECL: (* yyNew)->TARGET_DECL = yyt->TARGET_DECL;
copytIdent ((* yyNew)->TARGET_DECL.Ident, yyt->TARGET_DECL.Ident)
copyint ((* yyNew)->TARGET_DECL.Line, yyt->TARGET_DECL.Line)
return;
case kPARAMETER_DECL: (* yyNew)->PARAMETER_DECL = yyt->PARAMETER_DECL;
copytIdent ((* yyNew)->PARAMETER_DECL.Ident, yyt->PARAMETER_DECL.Ident)
copyint ((* yyNew)->PARAMETER_DECL.Line, yyt->PARAMETER_DECL.Line)
yyt = yyt->PARAMETER_DECL.VAL;
yyNew = & (* yyNew)->PARAMETER_DECL.VAL; break;
case kPUBLIC_DECL: (* yyNew)->PUBLIC_DECL = yyt->PUBLIC_DECL;
copytIdent ((* yyNew)->PUBLIC_DECL.Ident, yyt->PUBLIC_DECL.Ident)
copyint ((* yyNew)->PUBLIC_DECL.Line, yyt->PUBLIC_DECL.Line)
return;
case kPRIVATE_DECL: (* yyNew)->PRIVATE_DECL = yyt->PRIVATE_DECL;
copytIdent ((* yyNew)->PRIVATE_DECL.Ident, yyt->PRIVATE_DECL.Ident)
copyint ((* yyNew)->PRIVATE_DECL.Line, yyt->PRIVATE_DECL.Line)
return;
case kSEQUENCE_DECL: (* yyNew)->SEQUENCE_DECL = yyt->SEQUENCE_DECL;
copytIdent ((* yyNew)->SEQUENCE_DECL.Ident, yyt->SEQUENCE_DECL.Ident)
copyint ((* yyNew)->SEQUENCE_DECL.Line, yyt->SEQUENCE_DECL.Line)
return;
case kDISTRIBUTE_DECL: (* yyNew)->DISTRIBUTE_DECL = yyt->DISTRIBUTE_DECL;
copytIdent ((* yyNew)->DISTRIBUTE_DECL.Ident, yyt->DISTRIBUTE_DECL.Ident)
copyint ((* yyNew)->DISTRIBUTE_DECL.Line, yyt->DISTRIBUTE_DECL.Line)
copytTree ((* yyNew)->DISTRIBUTE_DECL.DISTRIBUTION, yyt->DISTRIBUTE_DECL.DISTRIBUTION)
yyt = yyt->DISTRIBUTE_DECL.TARGET;
yyNew = & (* yyNew)->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL: (* yyNew)->ALIGN_DECL = yyt->ALIGN_DECL;
copytIdent ((* yyNew)->ALIGN_DECL.Ident, yyt->ALIGN_DECL.Ident)
copyint ((* yyNew)->ALIGN_DECL.Line, yyt->ALIGN_DECL.Line)
copytTree ((* yyNew)->ALIGN_DECL.ALIGN_SOURCE, yyt->ALIGN_DECL.ALIGN_SOURCE)
yyt = yyt->ALIGN_DECL.ALIGN_TARGET;
yyNew = & (* yyNew)->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL: (* yyNew)->MAP_DECL = yyt->MAP_DECL;
copytIdent ((* yyNew)->MAP_DECL.Ident, yyt->MAP_DECL.Ident)
copyint ((* yyNew)->MAP_DECL.Line, yyt->MAP_DECL.Line)
yyt = yyt->MAP_DECL.MAP_TARGET;
yyNew = & (* yyNew)->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL: (* yyNew)->OVERLAP_DECL = yyt->OVERLAP_DECL;
copytIdent ((* yyNew)->OVERLAP_DECL.Ident, yyt->OVERLAP_DECL.Ident)
copyint ((* yyNew)->OVERLAP_DECL.Line, yyt->OVERLAP_DECL.Line)
yyt = yyt->OVERLAP_DECL.OVERLAPS;
yyNew = & (* yyNew)->OVERLAP_DECL.OVERLAPS; break;
case kSHARED_DECL: (* yyNew)->SHARED_DECL = yyt->SHARED_DECL;
copytIdent ((* yyNew)->SHARED_DECL.Ident, yyt->SHARED_DECL.Ident)
copyint ((* yyNew)->SHARED_DECL.Line, yyt->SHARED_DECL.Line)
copyint ((* yyNew)->SHARED_DECL.kind, yyt->SHARED_DECL.kind)
return;
case kDYNAMIC_DECL: (* yyNew)->DYNAMIC_DECL = yyt->DYNAMIC_DECL;
copytIdent ((* yyNew)->DYNAMIC_DECL.Ident, yyt->DYNAMIC_DECL.Ident)
copyint ((* yyNew)->DYNAMIC_DECL.Line, yyt->DYNAMIC_DECL.Line)
return;
case kTRACE_DECL: (* yyNew)->TRACE_DECL = yyt->TRACE_DECL;
copytIdent ((* yyNew)->TRACE_DECL.Ident, yyt->TRACE_DECL.Ident)
copyint ((* yyNew)->TRACE_DECL.Line, yyt->TRACE_DECL.Line)
return;
case kTREE_DECL: (* yyNew)->TREE_DECL = yyt->TREE_DECL;
copytIdent ((* yyNew)->TREE_DECL.Ident, yyt->TREE_DECL.Ident)
copyint ((* yyNew)->TREE_DECL.Line, yyt->TREE_DECL.Line)
return;
case kSELECT_DECL: (* yyNew)->SELECT_DECL = yyt->SELECT_DECL;
copytIdent ((* yyNew)->SELECT_DECL.Ident, yyt->SELECT_DECL.Ident)
copyint ((* yyNew)->SELECT_DECL.Line, yyt->SELECT_DECL.Line)
yyt = yyt->SELECT_DECL.SELECTIONS;
yyNew = & (* yyNew)->SELECT_DECL.SELECTIONS; break;
case kHPF_SEQUENCE_DECL: (* yyNew)->HPF_SEQUENCE_DECL = yyt->HPF_SEQUENCE_DECL;
copytIdent ((* yyNew)->HPF_SEQUENCE_DECL.Ident, yyt->HPF_SEQUENCE_DECL.Ident)
copyint ((* yyNew)->HPF_SEQUENCE_DECL.Line, yyt->HPF_SEQUENCE_DECL.Line)
return;
case kNOSEQUENCE_DECL: (* yyNew)->NOSEQUENCE_DECL = yyt->NOSEQUENCE_DECL;
copytIdent ((* yyNew)->NOSEQUENCE_DECL.Ident, yyt->NOSEQUENCE_DECL.Ident)
copyint ((* yyNew)->NOSEQUENCE_DECL.Line, yyt->NOSEQUENCE_DECL.Line)
return;
case kLAYOUT_DECL: (* yyNew)->LAYOUT_DECL = yyt->LAYOUT_DECL;
copytIdent ((* yyNew)->LAYOUT_DECL.Ident, yyt->LAYOUT_DECL.Ident)
copyint ((* yyNew)->LAYOUT_DECL.Line, yyt->LAYOUT_DECL.Line)
copytStringRef ((* yyNew)->LAYOUT_DECL.kind, yyt->LAYOUT_DECL.kind)
return;
case kPASS_BY_DECL: (* yyNew)->PASS_BY_DECL = yyt->PASS_BY_DECL;
copytIdent ((* yyNew)->PASS_BY_DECL.Ident, yyt->PASS_BY_DECL.Ident)
copyint ((* yyNew)->PASS_BY_DECL.Line, yyt->PASS_BY_DECL.Line)
copytStringRef ((* yyNew)->PASS_BY_DECL.kind, yyt->PASS_BY_DECL.kind)
return;
case kMAP_TO_DECL: (* yyNew)->MAP_TO_DECL = yyt->MAP_TO_DECL;
copytIdent ((* yyNew)->MAP_TO_DECL.Ident, yyt->MAP_TO_DECL.Ident)
copyint ((* yyNew)->MAP_TO_DECL.Line, yyt->MAP_TO_DECL.Line)
copytStringRef ((* yyNew)->MAP_TO_DECL.kind, yyt->MAP_TO_DECL.kind)
return;
case kDECL_NODE_LIST: (* yyNew)->DECL_NODE_LIST = yyt->DECL_NODE_LIST;
return;
case kDECL_EMPTY: (* yyNew)->DECL_EMPTY = yyt->DECL_EMPTY;
return;
case kDECL_LIST: (* yyNew)->DECL_LIST = yyt->DECL_LIST;
copytTree ((* yyNew)->DECL_LIST.Elem, yyt->DECL_LIST.Elem)
yyt = yyt->DECL_LIST.Next;
yyNew = & (* yyNew)->DECL_LIST.Next; break;
case kRANGE_SPEC_LIST: (* yyNew)->RANGE_SPEC_LIST = yyt->RANGE_SPEC_LIST;
return;
case kRANGE_EMPTY: (* yyNew)->RANGE_EMPTY = yyt->RANGE_EMPTY;
return;
case kRANGE_LIST: (* yyNew)->RANGE_LIST = yyt->RANGE_LIST;
copytTree ((* yyNew)->RANGE_LIST.Elem, yyt->RANGE_LIST.Elem)
yyt = yyt->RANGE_LIST.Next;
yyNew = & (* yyNew)->RANGE_LIST.Next; break;
case kSELECT_SPEC_LIST: (* yyNew)->SELECT_SPEC_LIST = yyt->SELECT_SPEC_LIST;
return;
case kSELECT_EMPTY: (* yyNew)->SELECT_EMPTY = yyt->SELECT_EMPTY;
return;
case kSELECT_LIST: (* yyNew)->SELECT_LIST = yyt->SELECT_LIST;
copytTree ((* yyNew)->SELECT_LIST.Elem, yyt->SELECT_LIST.Elem)
yyt = yyt->SELECT_LIST.Next;
yyNew = & (* yyNew)->SELECT_LIST.Next; break;
case kSELECT_SPEC: (* yyNew)->SELECT_SPEC = yyt->SELECT_SPEC;
copyint ((* yyNew)->SELECT_SPEC.selector, yyt->SELECT_SPEC.selector)
return;
case kDISTRIBUTION_SPEC: (* yyNew)->DISTRIBUTION_SPEC = yyt->DISTRIBUTION_SPEC;
copyint ((* yyNew)->DISTRIBUTION_SPEC.is_descriptive, yyt->DISTRIBUTION_SPEC.is_descriptive)
return;
case kANY_DISTRIBUTION: (* yyNew)->ANY_DISTRIBUTION = yyt->ANY_DISTRIBUTION;
copyint ((* yyNew)->ANY_DISTRIBUTION.is_descriptive, yyt->ANY_DISTRIBUTION.is_descriptive)
return;
case kDEFAULT_DISTRIBUTION: (* yyNew)->DEFAULT_DISTRIBUTION = yyt->DEFAULT_DISTRIBUTION;
copyint ((* yyNew)->DEFAULT_DISTRIBUTION.is_descriptive, yyt->DEFAULT_DISTRIBUTION.is_descriptive)
return;
case kREPL_DISTRIBUTION: (* yyNew)->REPL_DISTRIBUTION = yyt->REPL_DISTRIBUTION;
copyint ((* yyNew)->REPL_DISTRIBUTION.is_descriptive, yyt->REPL_DISTRIBUTION.is_descriptive)
return;
case kNODE_DISTRIBUTION: (* yyNew)->NODE_DISTRIBUTION = yyt->NODE_DISTRIBUTION;
copyint ((* yyNew)->NODE_DISTRIBUTION.is_descriptive, yyt->NODE_DISTRIBUTION.is_descriptive)
yyt = yyt->NODE_DISTRIBUTION.MAPPING;
yyNew = & (* yyNew)->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_FORMAT_LIST: (* yyNew)->DIST_FORMAT_LIST = yyt->DIST_FORMAT_LIST;
return;
case kDIST_EMPTY: (* yyNew)->DIST_EMPTY = yyt->DIST_EMPTY;
return;
case kDIST_LIST: (* yyNew)->DIST_LIST = yyt->DIST_LIST;
copytTree ((* yyNew)->DIST_LIST.Elem, yyt->DIST_LIST.Elem)
yyt = yyt->DIST_LIST.Next;
yyNew = & (* yyNew)->DIST_LIST.Next; break;
case kDISTRIBUTION_FORMAT: (* yyNew)->DISTRIBUTION_FORMAT = yyt->DISTRIBUTION_FORMAT;
return;
case kBLOCK_DISTRIBUTION: (* yyNew)->BLOCK_DISTRIBUTION = yyt->BLOCK_DISTRIBUTION;
yyt = yyt->BLOCK_DISTRIBUTION.SIZE;
yyNew = & (* yyNew)->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION: (* yyNew)->CYCLIC_DISTRIBUTION = yyt->CYCLIC_DISTRIBUTION;
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE;
yyNew = & (* yyNew)->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION: (* yyNew)->GEN_BLOCK_DISTRIBUTION = yyt->GEN_BLOCK_DISTRIBUTION;
yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY;
yyNew = & (* yyNew)->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION: (* yyNew)->INDIRECT_DISTRIBUTION = yyt->INDIRECT_DISTRIBUTION;
yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY;
yyNew = & (* yyNew)->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION: (* yyNew)->ARBITRARY_DISTRIBUTION = yyt->ARBITRARY_DISTRIBUTION;
copytTree ((* yyNew)->ARBITRARY_DISTRIBUTION.SIZE, yyt->ARBITRARY_DISTRIBUTION.SIZE)
copytTree ((* yyNew)->ARBITRARY_DISTRIBUTION.LENGTH, yyt->ARBITRARY_DISTRIBUTION.LENGTH)
yyt = yyt->ARBITRARY_DISTRIBUTION.MAP;
yyNew = & (* yyNew)->ARBITRARY_DISTRIBUTION.MAP; break;
case kSERIAL_DISTRIBUTION: (* yyNew)->SERIAL_DISTRIBUTION = yyt->SERIAL_DISTRIBUTION;
return;
case kANY_BLOCK_DISTRIBUTION: (* yyNew)->ANY_BLOCK_DISTRIBUTION = yyt->ANY_BLOCK_DISTRIBUTION;
return;
case kANY_CYCLIC_DISTRIBUTION: (* yyNew)->ANY_CYCLIC_DISTRIBUTION = yyt->ANY_CYCLIC_DISTRIBUTION;
return;
case kANY_GEN_BLOCK_DISTRIBUTION: (* yyNew)->ANY_GEN_BLOCK_DISTRIBUTION = yyt->ANY_GEN_BLOCK_DISTRIBUTION;
return;
case kANY_INDIRECT_DISTRIBUTION: (* yyNew)->ANY_INDIRECT_DISTRIBUTION = yyt->ANY_INDIRECT_DISTRIBUTION;
return;
case kANY_ARBITRARY_DISTRIBUTION: (* yyNew)->ANY_ARBITRARY_DISTRIBUTION = yyt->ANY_ARBITRARY_DISTRIBUTION;
return;
case kANY_DIM_DISTRIBUTION: (* yyNew)->ANY_DIM_DISTRIBUTION = yyt->ANY_DIM_DISTRIBUTION;
return;
case kPROCESSOR_SPEC: (* yyNew)->PROCESSOR_SPEC = yyt->PROCESSOR_SPEC;
return;
case kANY_PROCESSOR_ARRAY: (* yyNew)->ANY_PROCESSOR_ARRAY = yyt->ANY_PROCESSOR_ARRAY;
return;
case kDEFAULT_PROCESSOR_ARRAY: (* yyNew)->DEFAULT_PROCESSOR_ARRAY = yyt->DEFAULT_PROCESSOR_ARRAY;
return;
case kPROCESSOR_ARRAY: (* yyNew)->PROCESSOR_ARRAY = yyt->PROCESSOR_ARRAY;
yyt = yyt->PROCESSOR_ARRAY.TOPNAME;
yyNew = & (* yyNew)->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET: (* yyNew)->PROCESSOR_SUBSET = yyt->PROCESSOR_SUBSET;
copytTree ((* yyNew)->PROCESSOR_SUBSET.SUBTOP, yyt->PROCESSOR_SUBSET.SUBTOP)
copytTree ((* yyNew)->PROCESSOR_SUBSET.FULLTOP, yyt->PROCESSOR_SUBSET.FULLTOP)
yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS;
yyNew = & (* yyNew)->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC: (* yyNew)->ALIGN_SPEC = yyt->ALIGN_SPEC;
copyint ((* yyNew)->ALIGN_SPEC.is_descriptive, yyt->ALIGN_SPEC.is_descriptive)
copytTree ((* yyNew)->ALIGN_SPEC.TEMPNAME, yyt->ALIGN_SPEC.TEMPNAME)
yyt = yyt->ALIGN_SPEC.SUBSCRIPTS;
yyNew = & (* yyNew)->ALIGN_SPEC.SUBSCRIPTS; break;
case kGENERIC_SPEC: (* yyNew)->GENERIC_SPEC = yyt->GENERIC_SPEC;
return;
case kNO_GENERIC_SPEC: (* yyNew)->NO_GENERIC_SPEC = yyt->NO_GENERIC_SPEC;
return;
case kID_GENERIC_SPEC: (* yyNew)->ID_GENERIC_SPEC = yyt->ID_GENERIC_SPEC;
copytIdent ((* yyNew)->ID_GENERIC_SPEC.name, yyt->ID_GENERIC_SPEC.name)
return;
case kOP_GENERIC_SPEC: (* yyNew)->OP_GENERIC_SPEC = yyt->OP_GENERIC_SPEC;
yyt = yyt->OP_GENERIC_SPEC.OPERATOR;
yyNew = & (* yyNew)->OP_GENERIC_SPEC.OPERATOR; break;
case kASSIGN_GENERIC_SPEC: (* yyNew)->ASSIGN_GENERIC_SPEC = yyt->ASSIGN_GENERIC_SPEC;
return;
case kACF_NODE_LIST: (* yyNew)->ACF_NODE_LIST = yyt->ACF_NODE_LIST;
return;
case kACF_EMPTY: (* yyNew)->ACF_EMPTY = yyt->ACF_EMPTY;
return;
case kACF_LIST: (* yyNew)->ACF_LIST = yyt->ACF_LIST;
copytTree ((* yyNew)->ACF_LIST.Elem, yyt->ACF_LIST.Elem)
yyt = yyt->ACF_LIST.Next;
yyNew = & (* yyNew)->ACF_LIST.Next; break;
case kACF_NODE: (* yyNew)->ACF_NODE = yyt->ACF_NODE;
copyint ((* yyNew)->ACF_NODE.Label, yyt->ACF_NODE.Label)
copyint ((* yyNew)->ACF_NODE.Line, yyt->ACF_NODE.Line)
return;
case kACF_DUMMY: (* yyNew)->ACF_DUMMY = yyt->ACF_DUMMY;
copyint ((* yyNew)->ACF_DUMMY.Label, yyt->ACF_DUMMY.Label)
copyint ((* yyNew)->ACF_DUMMY.Line, yyt->ACF_DUMMY.Line)
return;
case kACF_BASIC: (* yyNew)->ACF_BASIC = yyt->ACF_BASIC;
copyint ((* yyNew)->ACF_BASIC.Label, yyt->ACF_BASIC.Label)
copyint ((* yyNew)->ACF_BASIC.Line, yyt->ACF_BASIC.Line)
yyt = yyt->ACF_BASIC.BASIC_STMT;
yyNew = & (* yyNew)->ACF_BASIC.BASIC_STMT; break;
case kACF_IF: (* yyNew)->ACF_IF = yyt->ACF_IF;
copyint ((* yyNew)->ACF_IF.Label, yyt->ACF_IF.Label)
copyint ((* yyNew)->ACF_IF.Line, yyt->ACF_IF.Line)
copytTree ((* yyNew)->ACF_IF.IF_EXP, yyt->ACF_IF.IF_EXP)
copytTree ((* yyNew)->ACF_IF.THEN_PART, yyt->ACF_IF.THEN_PART)
yyt = yyt->ACF_IF.ELSE_PART;
yyNew = & (* yyNew)->ACF_IF.ELSE_PART; break;
case kACF_WHERE: (* yyNew)->ACF_WHERE = yyt->ACF_WHERE;
copyint ((* yyNew)->ACF_WHERE.Label, yyt->ACF_WHERE.Label)
copyint ((* yyNew)->ACF_WHERE.Line, yyt->ACF_WHERE.Line)
copytTree ((* yyNew)->ACF_WHERE.WHERE_EXP, yyt->ACF_WHERE.WHERE_EXP)
copytTree ((* yyNew)->ACF_WHERE.TRUE_PART, yyt->ACF_WHERE.TRUE_PART)
yyt = yyt->ACF_WHERE.FALSE_PART;
yyNew = & (* yyNew)->ACF_WHERE.FALSE_PART; break;
case kACF_CASE: (* yyNew)->ACF_CASE = yyt->ACF_CASE;
copyint ((* yyNew)->ACF_CASE.Label, yyt->ACF_CASE.Label)
copyint ((* yyNew)->ACF_CASE.Line, yyt->ACF_CASE.Line)
copytTree ((* yyNew)->ACF_CASE.CASE_EXP, yyt->ACF_CASE.CASE_EXP)
yyt = yyt->ACF_CASE.CASE_ALTS;
yyNew = & (* yyNew)->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE: (* yyNew)->ACF_WHILE = yyt->ACF_WHILE;
copyint ((* yyNew)->ACF_WHILE.Label, yyt->ACF_WHILE.Label)
copyint ((* yyNew)->ACF_WHILE.Line, yyt->ACF_WHILE.Line)
copytTree ((* yyNew)->ACF_WHILE.WHILE_EXP, yyt->ACF_WHILE.WHILE_EXP)
yyt = yyt->ACF_WHILE.WHILE_BODY;
yyNew = & (* yyNew)->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT: (* yyNew)->ACF_REPEAT = yyt->ACF_REPEAT;
copyint ((* yyNew)->ACF_REPEAT.Label, yyt->ACF_REPEAT.Label)
copyint ((* yyNew)->ACF_REPEAT.Line, yyt->ACF_REPEAT.Line)
copytTree ((* yyNew)->ACF_REPEAT.REPEAT_BODY, yyt->ACF_REPEAT.REPEAT_BODY)
yyt = yyt->ACF_REPEAT.REPEAT_EXP;
yyNew = & (* yyNew)->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP: (* yyNew)->ACF_LOOP = yyt->ACF_LOOP;
copyint ((* yyNew)->ACF_LOOP.Label, yyt->ACF_LOOP.Label)
copyint ((* yyNew)->ACF_LOOP.Line, yyt->ACF_LOOP.Line)
yyt = yyt->ACF_LOOP.LOOP_BODY;
yyNew = & (* yyNew)->ACF_LOOP.LOOP_BODY; break;
case kACF_DO: (* yyNew)->ACF_DO = yyt->ACF_DO;
copyint ((* yyNew)->ACF_DO.Label, yyt->ACF_DO.Label)
copyint ((* yyNew)->ACF_DO.Line, yyt->ACF_DO.Line)
copytTree ((* yyNew)->ACF_DO.DO_ID, yyt->ACF_DO.DO_ID)
copytTree ((* yyNew)->ACF_DO.DO_RANGE, yyt->ACF_DO.DO_RANGE)
copytTree ((* yyNew)->ACF_DO.DO_BODY, yyt->ACF_DO.DO_BODY)
copytTree ((* yyNew)->ACF_DO.DO_DEP_INFO, yyt->ACF_DO.DO_DEP_INFO)
yyt = yyt->ACF_DO.DO_HOME_INFO;
yyNew = & (* yyNew)->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL: (* yyNew)->ACF_FORALL = yyt->ACF_FORALL;
copyint ((* yyNew)->ACF_FORALL.Label, yyt->ACF_FORALL.Label)
copyint ((* yyNew)->ACF_FORALL.Line, yyt->ACF_FORALL.Line)
copytTree ((* yyNew)->ACF_FORALL.FORALL_ID, yyt->ACF_FORALL.FORALL_ID)
copytTree ((* yyNew)->ACF_FORALL.FORALL_RANGE, yyt->ACF_FORALL.FORALL_RANGE)
copytTree ((* yyNew)->ACF_FORALL.FORALL_BODY, yyt->ACF_FORALL.FORALL_BODY)
copytTree ((* yyNew)->ACF_FORALL.FORALL_DEP_INFO, yyt->ACF_FORALL.FORALL_DEP_INFO)
yyt = yyt->ACF_FORALL.FORALL_HOME_INFO;
yyNew = & (* yyNew)->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH: (* yyNew)->ACF_FLOW_GRAPH = yyt->ACF_FLOW_GRAPH;
copyint ((* yyNew)->ACF_FLOW_GRAPH.Label, yyt->ACF_FLOW_GRAPH.Label)
copyint ((* yyNew)->ACF_FLOW_GRAPH.Line, yyt->ACF_FLOW_GRAPH.Line)
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES;
yyNew = & (* yyNew)->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY: (* yyNew)->ACF_ENTRY = yyt->ACF_ENTRY;
copyint ((* yyNew)->ACF_ENTRY.Label, yyt->ACF_ENTRY.Label)
copyint ((* yyNew)->ACF_ENTRY.Line, yyt->ACF_ENTRY.Line)
yyt = yyt->ACF_ENTRY.ENTRY_DECL;
yyNew = & (* yyNew)->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME: (* yyNew)->ACF_HOME = yyt->ACF_HOME;
copyint ((* yyNew)->ACF_HOME.Label, yyt->ACF_HOME.Label)
copyint ((* yyNew)->ACF_HOME.Line, yyt->ACF_HOME.Line)
copytTree ((* yyNew)->ACF_HOME.HOME_VAR, yyt->ACF_HOME.HOME_VAR)
copybool ((* yyNew)->ACF_HOME.user_home, yyt->ACF_HOME.user_home)
yyt = yyt->ACF_HOME.HOME_BODY;
yyNew = & (* yyNew)->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT: (* yyNew)->ACF_RESIDENT = yyt->ACF_RESIDENT;
copyint ((* yyNew)->ACF_RESIDENT.Label, yyt->ACF_RESIDENT.Label)
copyint ((* yyNew)->ACF_RESIDENT.Line, yyt->ACF_RESIDENT.Line)
copytTree ((* yyNew)->ACF_RESIDENT.RESIDENT_VAR, yyt->ACF_RESIDENT.RESIDENT_VAR)
yyt = yyt->ACF_RESIDENT.RESIDENT_BODY;
yyNew = & (* yyNew)->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW: (* yyNew)->ACF_NEW = yyt->ACF_NEW;
copyint ((* yyNew)->ACF_NEW.Label, yyt->ACF_NEW.Label)
copyint ((* yyNew)->ACF_NEW.Line, yyt->ACF_NEW.Line)
copytTree ((* yyNew)->ACF_NEW.NEW_VAR, yyt->ACF_NEW.NEW_VAR)
yyt = yyt->ACF_NEW.NEW_BODY;
yyNew = & (* yyNew)->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION: (* yyNew)->ACF_REDUCTION = yyt->ACF_REDUCTION;
copyint ((* yyNew)->ACF_REDUCTION.Label, yyt->ACF_REDUCTION.Label)
copyint ((* yyNew)->ACF_REDUCTION.Line, yyt->ACF_REDUCTION.Line)
copybool ((* yyNew)->ACF_REDUCTION.is_zero, yyt->ACF_REDUCTION.is_zero)
copytTree ((* yyNew)->ACF_REDUCTION.REDUCTION_VAR, yyt->ACF_REDUCTION.REDUCTION_VAR)
copytTree ((* yyNew)->ACF_REDUCTION.REDUCTION_LVAR, yyt->ACF_REDUCTION.REDUCTION_LVAR)
copytTree ((* yyNew)->ACF_REDUCTION.REDUCTION_FUNC, yyt->ACF_REDUCTION.REDUCTION_FUNC)
yyt = yyt->ACF_REDUCTION.REDUCTION_BODY;
yyNew = & (* yyNew)->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION: (* yyNew)->ACF_TASK_REGION = yyt->ACF_TASK_REGION;
copyint ((* yyNew)->ACF_TASK_REGION.Label, yyt->ACF_TASK_REGION.Label)
copyint ((* yyNew)->ACF_TASK_REGION.Line, yyt->ACF_TASK_REGION.Line)
copyint ((* yyNew)->ACF_TASK_REGION.task_flag, yyt->ACF_TASK_REGION.task_flag)
yyt = yyt->ACF_TASK_REGION.TASK_BODY;
yyNew = & (* yyNew)->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL: (* yyNew)->ACF_PARALLEL = yyt->ACF_PARALLEL;
copyint ((* yyNew)->ACF_PARALLEL.Label, yyt->ACF_PARALLEL.Label)
copyint ((* yyNew)->ACF_PARALLEL.Line, yyt->ACF_PARALLEL.Line)
copytTree ((* yyNew)->ACF_PARALLEL.REDUCTION_VARS, yyt->ACF_PARALLEL.REDUCTION_VARS)
copytTree ((* yyNew)->ACF_PARALLEL.SHARED_VARS, yyt->ACF_PARALLEL.SHARED_VARS)
copytTree ((* yyNew)->ACF_PARALLEL.LOCAL_VARS, yyt->ACF_PARALLEL.LOCAL_VARS)
yyt = yyt->ACF_PARALLEL.PARALLEL_BODY;
yyNew = & (* yyNew)->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL: (* yyNew)->ACF_CRITICAL = yyt->ACF_CRITICAL;
copyint ((* yyNew)->ACF_CRITICAL.Label, yyt->ACF_CRITICAL.Label)
copyint ((* yyNew)->ACF_CRITICAL.Line, yyt->ACF_CRITICAL.Line)
yyt = yyt->ACF_CRITICAL.CRITICAL_BODY;
yyNew = & (* yyNew)->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON: (* yyNew)->ACF_ON = yyt->ACF_ON;
copyint ((* yyNew)->ACF_ON.Label, yyt->ACF_ON.Label)
copyint ((* yyNew)->ACF_ON.Line, yyt->ACF_ON.Line)
copytTree ((* yyNew)->ACF_ON.ON_HOME, yyt->ACF_ON.ON_HOME)
copytTree ((* yyNew)->ACF_ON.ON_SPECS, yyt->ACF_ON.ON_SPECS)
yyt = yyt->ACF_ON.ON_BODY;
yyNew = & (* yyNew)->ACF_ON.ON_BODY; break;
case kACF_RM_READ: (* yyNew)->ACF_RM_READ = yyt->ACF_RM_READ;
copyint ((* yyNew)->ACF_RM_READ.Label, yyt->ACF_RM_READ.Label)
copyint ((* yyNew)->ACF_RM_READ.Line, yyt->ACF_RM_READ.Line)
copytTree ((* yyNew)->ACF_RM_READ.LOCAL_VAR, yyt->ACF_RM_READ.LOCAL_VAR)
yyt = yyt->ACF_RM_READ.REMOTE_VAR;
yyNew = & (* yyNew)->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE: (* yyNew)->ACF_RM_WRITE = yyt->ACF_RM_WRITE;
copyint ((* yyNew)->ACF_RM_WRITE.Label, yyt->ACF_RM_WRITE.Label)
copyint ((* yyNew)->ACF_RM_WRITE.Line, yyt->ACF_RM_WRITE.Line)
copyint ((* yyNew)->ACF_RM_WRITE.op, yyt->ACF_RM_WRITE.op)
copytTree ((* yyNew)->ACF_RM_WRITE.REMOTE_VAR, yyt->ACF_RM_WRITE.REMOTE_VAR)
yyt = yyt->ACF_RM_WRITE.LOCAL_DATA;
yyNew = & (* yyNew)->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE: (* yyNew)->ACF_MOVE = yyt->ACF_MOVE;
copyint ((* yyNew)->ACF_MOVE.Label, yyt->ACF_MOVE.Label)
copyint ((* yyNew)->ACF_MOVE.Line, yyt->ACF_MOVE.Line)
yyt = yyt->ACF_MOVE.MOVE_STMT;
yyNew = & (* yyNew)->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER: (* yyNew)->ACF_BARRIER = yyt->ACF_BARRIER;
copyint ((* yyNew)->ACF_BARRIER.Label, yyt->ACF_BARRIER.Label)
copyint ((* yyNew)->ACF_BARRIER.Line, yyt->ACF_BARRIER.Line)
yyt = yyt->ACF_BARRIER.BARRIER_VARS;
yyNew = & (* yyNew)->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE: (* yyNew)->ACF_UPDATE = yyt->ACF_UPDATE;
copyint ((* yyNew)->ACF_UPDATE.Label, yyt->ACF_UPDATE.Label)
copyint ((* yyNew)->ACF_UPDATE.Line, yyt->ACF_UPDATE.Line)
yyt = yyt->ACF_UPDATE.OVERLAP_VAR;
yyNew = & (* yyNew)->ACF_UPDATE.OVERLAP_VAR; break;
case kACF_FLOW_KIND: (* yyNew)->ACF_FLOW_KIND = yyt->ACF_FLOW_KIND;
return;
case kACF_COMPLEX_FLOW: (* yyNew)->ACF_COMPLEX_FLOW = yyt->ACF_COMPLEX_FLOW;
return;
case kACF_INTERVAL_FLOW: (* yyNew)->ACF_INTERVAL_FLOW = yyt->ACF_INTERVAL_FLOW;
return;
case kACF_SIMPLE_FLOW: (* yyNew)->ACF_SIMPLE_FLOW = yyt->ACF_SIMPLE_FLOW;
return;
case kON_CLAUSE: (* yyNew)->ON_CLAUSE = yyt->ON_CLAUSE;
return;
case kON_HOST_CLAUSE: (* yyNew)->ON_HOST_CLAUSE = yyt->ON_HOST_CLAUSE;
return;
case kON_ALL_CLAUSE: (* yyNew)->ON_ALL_CLAUSE = yyt->ON_ALL_CLAUSE;
return;
case kON_VAR_CLAUSE: (* yyNew)->ON_VAR_CLAUSE = yyt->ON_VAR_CLAUSE;
yyt = yyt->ON_VAR_CLAUSE.ON_VAR;
yyNew = & (* yyNew)->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE: (* yyNew)->ON_PROC_CLAUSE = yyt->ON_PROC_CLAUSE;
yyt = yyt->ON_PROC_CLAUSE.ON_PROC;
yyNew = & (* yyNew)->ON_PROC_CLAUSE.ON_PROC; break;
case kON_TOPOLOGY: (* yyNew)->ON_TOPOLOGY = yyt->ON_TOPOLOGY;
return;
case kON_ALL: (* yyNew)->ON_ALL = yyt->ON_ALL;
return;
case kON_HOST: (* yyNew)->ON_HOST = yyt->ON_HOST;
return;
case kON_PROCS: (* yyNew)->ON_PROCS = yyt->ON_PROCS;
copytObject ((* yyNew)->ON_PROCS.topid, yyt->ON_PROCS.topid)
return;
case kON_VAR: (* yyNew)->ON_VAR = yyt->ON_VAR;
copytObject ((* yyNew)->ON_VAR.topid, yyt->ON_VAR.topid)
copytObject ((* yyNew)->ON_VAR.tempid, yyt->ON_VAR.tempid)
copytObject ((* yyNew)->ON_VAR.arrayid, yyt->ON_VAR.arrayid)
return;
case kON_SPEC_LIST: (* yyNew)->ON_SPEC_LIST = yyt->ON_SPEC_LIST;
return;
case kON_EMPTY: (* yyNew)->ON_EMPTY = yyt->ON_EMPTY;
return;
case kON_LIST: (* yyNew)->ON_LIST = yyt->ON_LIST;
copytTree ((* yyNew)->ON_LIST.Elem, yyt->ON_LIST.Elem)
yyt = yyt->ON_LIST.Next;
yyNew = & (* yyNew)->ON_LIST.Next; break;
case kON_SPEC: (* yyNew)->ON_SPEC = yyt->ON_SPEC;
copyint ((* yyNew)->ON_SPEC.top_dim, yyt->ON_SPEC.top_dim)
copyint ((* yyNew)->ON_SPEC.temp_dim, yyt->ON_SPEC.temp_dim)
copyint ((* yyNew)->ON_SPEC.array_dim, yyt->ON_SPEC.array_dim)
yyt = yyt->ON_SPEC.ON_VAL;
yyNew = & (* yyNew)->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_NODE_LIST: (* yyNew)->SELECTED_ACF_NODE_LIST = yyt->SELECTED_ACF_NODE_LIST;
return;
case kSELECTED_ACF_EMPTY: (* yyNew)->SELECTED_ACF_EMPTY = yyt->SELECTED_ACF_EMPTY;
return;
case kSELECTED_ACF_LIST: (* yyNew)->SELECTED_ACF_LIST = yyt->SELECTED_ACF_LIST;
copytTree ((* yyNew)->SELECTED_ACF_LIST.Elem, yyt->SELECTED_ACF_LIST.Elem)
yyt = yyt->SELECTED_ACF_LIST.Next;
yyNew = & (* yyNew)->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE: (* yyNew)->SELECTED_ACF_NODE = yyt->SELECTED_ACF_NODE;
copytTree ((* yyNew)->SELECTED_ACF_NODE.SELECT_LIST, yyt->SELECTED_ACF_NODE.SELECT_LIST)
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS;
yyNew = & (* yyNew)->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kBT_STMT: (* yyNew)->BT_STMT = yyt->BT_STMT;
return;
case kASSIGN_STMT: (* yyNew)->ASSIGN_STMT = yyt->ASSIGN_STMT;
copytTree ((* yyNew)->ASSIGN_STMT.ASSIGN_VAR, yyt->ASSIGN_STMT.ASSIGN_VAR)
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP;
yyNew = & (* yyNew)->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT: (* yyNew)->PTR_ASSIGN_STMT = yyt->PTR_ASSIGN_STMT;
copytTree ((* yyNew)->PTR_ASSIGN_STMT.ASSIGN_VAR, yyt->PTR_ASSIGN_STMT.ASSIGN_VAR)
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP;
yyNew = & (* yyNew)->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT: (* yyNew)->LABEL_ASSIGN_STMT = yyt->LABEL_ASSIGN_STMT;
copyint ((* yyNew)->LABEL_ASSIGN_STMT.assign_label, yyt->LABEL_ASSIGN_STMT.assign_label)
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR;
yyNew = & (* yyNew)->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT: (* yyNew)->CALL_STMT = yyt->CALL_STMT;
copytTree ((* yyNew)->CALL_STMT.CALL_ID, yyt->CALL_STMT.CALL_ID)
yyt = yyt->CALL_STMT.CALL_PARAMS;
yyNew = & (* yyNew)->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT: (* yyNew)->IO_STMT = yyt->IO_STMT;
copytTree ((* yyNew)->IO_STMT.ID, yyt->IO_STMT.ID)
copytTree ((* yyNew)->IO_STMT.IO_SPECS, yyt->IO_STMT.IO_SPECS)
yyt = yyt->IO_STMT.IO_ITEMS;
yyNew = & (* yyNew)->IO_STMT.IO_ITEMS; break;
case kGOTO_STMT: (* yyNew)->GOTO_STMT = yyt->GOTO_STMT;
copyint ((* yyNew)->GOTO_STMT.GOTO_LABEL, yyt->GOTO_STMT.GOTO_LABEL)
return;
case kASS_GOTO_STMT: (* yyNew)->ASS_GOTO_STMT = yyt->ASS_GOTO_STMT;
copytTree ((* yyNew)->ASS_GOTO_STMT.GOTO_VAR, yyt->ASS_GOTO_STMT.GOTO_VAR)
yyt = yyt->ASS_GOTO_STMT.LABELS;
yyNew = & (* yyNew)->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT: (* yyNew)->COMP_GOTO_STMT = yyt->COMP_GOTO_STMT;
copytTree ((* yyNew)->COMP_GOTO_STMT.GOTO_LABELS, yyt->COMP_GOTO_STMT.GOTO_LABELS)
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP;
yyNew = & (* yyNew)->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT: (* yyNew)->COMP_IF_STMT = yyt->COMP_IF_STMT;
copyint ((* yyNew)->COMP_IF_STMT.IF_LT_LABEL, yyt->COMP_IF_STMT.IF_LT_LABEL)
copyint ((* yyNew)->COMP_IF_STMT.IF_EQ_LABEL, yyt->COMP_IF_STMT.IF_EQ_LABEL)
copyint ((* yyNew)->COMP_IF_STMT.IF_GT_LABEL, yyt->COMP_IF_STMT.IF_GT_LABEL)
yyt = yyt->COMP_IF_STMT.IF_EXP;
yyNew = & (* yyNew)->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT: (* yyNew)->RETURN_STMT = yyt->RETURN_STMT;
yyt = yyt->RETURN_STMT.RETURN_EXP;
yyNew = & (* yyNew)->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT: (* yyNew)->PAUSE_STMT = yyt->PAUSE_STMT;
yyt = yyt->PAUSE_STMT.PAUSE_CONST;
yyNew = & (* yyNew)->PAUSE_STMT.PAUSE_CONST; break;
case kEXIT_STMT: (* yyNew)->EXIT_STMT = yyt->EXIT_STMT;
copytIdent ((* yyNew)->EXIT_STMT.loopid, yyt->EXIT_STMT.loopid)
return;
case kCYCLE_STMT: (* yyNew)->CYCLE_STMT = yyt->CYCLE_STMT;
copytIdent ((* yyNew)->CYCLE_STMT.loopid, yyt->CYCLE_STMT.loopid)
return;
case kSTOP_STMT: (* yyNew)->STOP_STMT = yyt->STOP_STMT;
yyt = yyt->STOP_STMT.STOP_CONST;
yyNew = & (* yyNew)->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT: (* yyNew)->FORMAT_STMT = yyt->FORMAT_STMT;
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS;
yyNew = & (* yyNew)->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT: (* yyNew)->INHERIT_DSP_STMT = yyt->INHERIT_DSP_STMT;
copytTree ((* yyNew)->INHERIT_DSP_STMT.VAR, yyt->INHERIT_DSP_STMT.VAR)
copyint ((* yyNew)->INHERIT_DSP_STMT.flag, yyt->INHERIT_DSP_STMT.flag)
copyint ((* yyNew)->INHERIT_DSP_STMT.safety, yyt->INHERIT_DSP_STMT.safety)
yyt = yyt->INHERIT_DSP_STMT.SHAPE;
yyNew = & (* yyNew)->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT: (* yyNew)->CREATE_DSP_STMT = yyt->CREATE_DSP_STMT;
copytTree ((* yyNew)->CREATE_DSP_STMT.VAR, yyt->CREATE_DSP_STMT.VAR)
copyint ((* yyNew)->CREATE_DSP_STMT.flag, yyt->CREATE_DSP_STMT.flag)
yyt = yyt->CREATE_DSP_STMT.SHAPE;
yyNew = & (* yyNew)->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT: (* yyNew)->FREE_DSP_STMT = yyt->FREE_DSP_STMT;
copyint ((* yyNew)->FREE_DSP_STMT.flag, yyt->FREE_DSP_STMT.flag)
yyt = yyt->FREE_DSP_STMT.VAR;
yyNew = & (* yyNew)->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT: (* yyNew)->ALLOCATE_STMT = yyt->ALLOCATE_STMT;
copytTree ((* yyNew)->ALLOCATE_STMT.PARAMS, yyt->ALLOCATE_STMT.PARAMS)
yyt = yyt->ALLOCATE_STMT.STATUS;
yyNew = & (* yyNew)->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT: (* yyNew)->DEALLOCATE_STMT = yyt->DEALLOCATE_STMT;
copytTree ((* yyNew)->DEALLOCATE_STMT.PARAMS, yyt->DEALLOCATE_STMT.PARAMS)
yyt = yyt->DEALLOCATE_STMT.STATUS;
yyNew = & (* yyNew)->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT: (* yyNew)->NULLIFY_STMT = yyt->NULLIFY_STMT;
yyt = yyt->NULLIFY_STMT.PARAMS;
yyNew = & (* yyNew)->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT: (* yyNew)->REDUCE_STMT = yyt->REDUCE_STMT;
copytTree ((* yyNew)->REDUCE_STMT.RED_FUNC, yyt->REDUCE_STMT.RED_FUNC)
yyt = yyt->REDUCE_STMT.RED_PARAMS;
yyNew = & (* yyNew)->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT: (* yyNew)->MOVE_STMT = yyt->MOVE_STMT;
copytTree ((* yyNew)->MOVE_STMT.TARGET, yyt->MOVE_STMT.TARGET)
copytTree ((* yyNew)->MOVE_STMT.SOURCE, yyt->MOVE_STMT.SOURCE)
yyt = yyt->MOVE_STMT.MASK;
yyNew = & (* yyNew)->MOVE_STMT.MASK; break;
case kSCATTER_STMT: (* yyNew)->SCATTER_STMT = yyt->SCATTER_STMT;
copytIdent ((* yyNew)->SCATTER_STMT.func, yyt->SCATTER_STMT.func)
copytTree ((* yyNew)->SCATTER_STMT.ARRAY, yyt->SCATTER_STMT.ARRAY)
copytTree ((* yyNew)->SCATTER_STMT.BASE, yyt->SCATTER_STMT.BASE)
copytTree ((* yyNew)->SCATTER_STMT.INDEXES, yyt->SCATTER_STMT.INDEXES)
yyt = yyt->SCATTER_STMT.MASK;
yyNew = & (* yyNew)->SCATTER_STMT.MASK; break;
case kREALIGN_STMT: (* yyNew)->REALIGN_STMT = yyt->REALIGN_STMT;
copytTree ((* yyNew)->REALIGN_STMT.ALIGNEE, yyt->REALIGN_STMT.ALIGNEE)
copytTree ((* yyNew)->REALIGN_STMT.ALIGN_SOURCE, yyt->REALIGN_STMT.ALIGN_SOURCE)
copytDefinitions ((* yyNew)->REALIGN_STMT.distribution, yyt->REALIGN_STMT.distribution)
yyt = yyt->REALIGN_STMT.ALIGN_TARGET;
yyNew = & (* yyNew)->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT: (* yyNew)->REDISTRIBUTE_STMT = yyt->REDISTRIBUTE_STMT;
copytTree ((* yyNew)->REDISTRIBUTE_STMT.DISTRIBUTEE, yyt->REDISTRIBUTE_STMT.DISTRIBUTEE)
copytTree ((* yyNew)->REDISTRIBUTE_STMT.DISTRIBUTION, yyt->REDISTRIBUTE_STMT.DISTRIBUTION)
copytDefinitions ((* yyNew)->REDISTRIBUTE_STMT.distribution, yyt->REDISTRIBUTE_STMT.distribution)
yyt = yyt->REDISTRIBUTE_STMT.TARGET;
yyNew = & (* yyNew)->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET: (* yyNew)->REG_SHADOW_GET = yyt->REG_SHADOW_GET;
copytTree ((* yyNew)->REG_SHADOW_GET.SHADOW_VAR, yyt->REG_SHADOW_GET.SHADOW_VAR)
yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE;
yyNew = & (* yyNew)->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT: (* yyNew)->REG_SHADOW_PUT = yyt->REG_SHADOW_PUT;
copyint ((* yyNew)->REG_SHADOW_PUT.op, yyt->REG_SHADOW_PUT.op)
copytTree ((* yyNew)->REG_SHADOW_PUT.SHADOW_VAR, yyt->REG_SHADOW_PUT.SHADOW_VAR)
yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE;
yyNew = & (* yyNew)->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET: (* yyNew)->REG_SHADOW_SET = yyt->REG_SHADOW_SET;
copytTree ((* yyNew)->REG_SHADOW_SET.SHADOW_VAR, yyt->REG_SHADOW_SET.SHADOW_VAR)
copytTree ((* yyNew)->REG_SHADOW_SET.SHADOW_SIZE, yyt->REG_SHADOW_SET.SHADOW_SIZE)
yyt = yyt->REG_SHADOW_SET.VAL;
yyNew = & (* yyNew)->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE: (* yyNew)->IND_SHADOW_CREATE = yyt->IND_SHADOW_CREATE;
copyint ((* yyNew)->IND_SHADOW_CREATE.id, yyt->IND_SHADOW_CREATE.id)
copytTree ((* yyNew)->IND_SHADOW_CREATE.SHADOW_VAR, yyt->IND_SHADOW_CREATE.SHADOW_VAR)
copytTree ((* yyNew)->IND_SHADOW_CREATE.INDEX_VAR, yyt->IND_SHADOW_CREATE.INDEX_VAR)
copytTree ((* yyNew)->IND_SHADOW_CREATE.TMP_INDEX_VAR, yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR)
yyt = yyt->IND_SHADOW_CREATE.MASK;
yyNew = & (* yyNew)->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE: (* yyNew)->IND_SHADOW_FREE = yyt->IND_SHADOW_FREE;
copyint ((* yyNew)->IND_SHADOW_FREE.id, yyt->IND_SHADOW_FREE.id)
yyt = yyt->IND_SHADOW_FREE.INDEX_VAR;
yyNew = & (* yyNew)->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET: (* yyNew)->IND_SHADOW_GET = yyt->IND_SHADOW_GET;
copyint ((* yyNew)->IND_SHADOW_GET.id, yyt->IND_SHADOW_GET.id)
yyt = yyt->IND_SHADOW_GET.SHADOW_VAR;
yyNew = & (* yyNew)->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT: (* yyNew)->IND_SHADOW_PUT = yyt->IND_SHADOW_PUT;
copyint ((* yyNew)->IND_SHADOW_PUT.id, yyt->IND_SHADOW_PUT.id)
copyint ((* yyNew)->IND_SHADOW_PUT.op, yyt->IND_SHADOW_PUT.op)
yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR;
yyNew = & (* yyNew)->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET: (* yyNew)->IND_SHADOW_SET = yyt->IND_SHADOW_SET;
copyint ((* yyNew)->IND_SHADOW_SET.id, yyt->IND_SHADOW_SET.id)
copytTree ((* yyNew)->IND_SHADOW_SET.SHADOW_VAR, yyt->IND_SHADOW_SET.SHADOW_VAR)
yyt = yyt->IND_SHADOW_SET.VAL;
yyNew = & (* yyNew)->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT: (* yyNew)->BROADCAST_STMT = yyt->BROADCAST_STMT;
copytTree ((* yyNew)->BROADCAST_STMT.ELEMS, yyt->BROADCAST_STMT.ELEMS)
copytTree ((* yyNew)->BROADCAST_STMT.OWNER_TOP, yyt->BROADCAST_STMT.OWNER_TOP)
yyt = yyt->BROADCAST_STMT.OWNER_SPEC;
yyNew = & (* yyNew)->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT: (* yyNew)->REDUCTION_STMT = yyt->REDUCTION_STMT;
copytTree ((* yyNew)->REDUCTION_STMT.REDFUNC, yyt->REDUCTION_STMT.REDFUNC)
copytTree ((* yyNew)->REDUCTION_STMT.ELEMS, yyt->REDUCTION_STMT.ELEMS)
copytTree ((* yyNew)->REDUCTION_STMT.RED_TOP, yyt->REDUCTION_STMT.RED_TOP)
yyt = yyt->REDUCTION_STMT.RED_SPEC;
yyNew = & (* yyNew)->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT: (* yyNew)->DIRTY_STMT = yyt->DIRTY_STMT;
yyt = yyt->DIRTY_STMT.ELEMS;
yyNew = & (* yyNew)->DIRTY_STMT.ELEMS; break;
case kLABEL_USE_LIST: (* yyNew)->LABEL_USE_LIST = yyt->LABEL_USE_LIST;
return;
case kLABEL_EMPTY: (* yyNew)->LABEL_EMPTY = yyt->LABEL_EMPTY;
return;
case kLABEL_LIST: (* yyNew)->LABEL_LIST = yyt->LABEL_LIST;
copyint ((* yyNew)->LABEL_LIST.Elem, yyt->LABEL_LIST.Elem)
yyt = yyt->LABEL_LIST.Next;
yyNew = & (* yyNew)->LABEL_LIST.Next; break;
case kOP: (* yyNew)->OP = yyt->OP;
return;
case kOP_EQ: (* yyNew)->OP_EQ = yyt->OP_EQ;
return;
case kOP_NE: (* yyNew)->OP_NE = yyt->OP_NE;
return;
case kOP_LT: (* yyNew)->OP_LT = yyt->OP_LT;
return;
case kOP_GT: (* yyNew)->OP_GT = yyt->OP_GT;
return;
case kOP_GE: (* yyNew)->OP_GE = yyt->OP_GE;
return;
case kOP_LE: (* yyNew)->OP_LE = yyt->OP_LE;
return;
case kOP_PLUS: (* yyNew)->OP_PLUS = yyt->OP_PLUS;
return;
case kOP_MINUS: (* yyNew)->OP_MINUS = yyt->OP_MINUS;
return;
case kOP_XOR: (* yyNew)->OP_XOR = yyt->OP_XOR;
return;
case kOP_OR: (* yyNew)->OP_OR = yyt->OP_OR;
return;
case kOP_CONCAT: (* yyNew)->OP_CONCAT = yyt->OP_CONCAT;
return;
case kOP_TIMES: (* yyNew)->OP_TIMES = yyt->OP_TIMES;
return;
case kOP_DIVIDE: (* yyNew)->OP_DIVIDE = yyt->OP_DIVIDE;
return;
case kOP_AND: (* yyNew)->OP_AND = yyt->OP_AND;
return;
case kOP_EQV: (* yyNew)->OP_EQV = yyt->OP_EQV;
return;
case kOP_NEQV: (* yyNew)->OP_NEQV = yyt->OP_NEQV;
return;
case kOP_EXPO: (* yyNew)->OP_EXPO = yyt->OP_EXPO;
return;
case kOP_DEFINED: (* yyNew)->OP_DEFINED = yyt->OP_DEFINED;
copytIdent ((* yyNew)->OP_DEFINED.opname, yyt->OP_DEFINED.opname)
return;
case kOP_ASSIGN: (* yyNew)->OP_ASSIGN = yyt->OP_ASSIGN;
return;
case kOP1_NOT: (* yyNew)->OP1_NOT = yyt->OP1_NOT;
return;
case kOP1_SIGN: (* yyNew)->OP1_SIGN = yyt->OP1_SIGN;
return;
case kOP1_PSIGN: (* yyNew)->OP1_PSIGN = yyt->OP1_PSIGN;
return;
case kBT_EXP: (* yyNew)->BT_EXP = yyt->BT_EXP;
return;
case kDUMMY_EXP: (* yyNew)->DUMMY_EXP = yyt->DUMMY_EXP;
return;
case kCONST_EXP: (* yyNew)->CONST_EXP = yyt->CONST_EXP;
yyt = yyt->CONST_EXP.C;
yyNew = & (* yyNew)->CONST_EXP.C; break;
case kOP_EXP: (* yyNew)->OP_EXP = yyt->OP_EXP;
copytTree ((* yyNew)->OP_EXP.EXP_OP, yyt->OP_EXP.EXP_OP)
copytTree ((* yyNew)->OP_EXP.OPND1, yyt->OP_EXP.OPND1)
yyt = yyt->OP_EXP.OPND2;
yyNew = & (* yyNew)->OP_EXP.OPND2; break;
case kOP1_EXP: (* yyNew)->OP1_EXP = yyt->OP1_EXP;
copytTree ((* yyNew)->OP1_EXP.EXP_OP1, yyt->OP1_EXP.EXP_OP1)
yyt = yyt->OP1_EXP.OPND;
yyNew = & (* yyNew)->OP1_EXP.OPND; break;
case kSLICE_EXP: (* yyNew)->SLICE_EXP = yyt->SLICE_EXP;
copytTree ((* yyNew)->SLICE_EXP.START, yyt->SLICE_EXP.START)
copytTree ((* yyNew)->SLICE_EXP.STOP, yyt->SLICE_EXP.STOP)
yyt = yyt->SLICE_EXP.INC;
yyNew = & (* yyNew)->SLICE_EXP.INC; break;
case kVAR_EXP: (* yyNew)->VAR_EXP = yyt->VAR_EXP;
yyt = yyt->VAR_EXP.V;
yyNew = & (* yyNew)->VAR_EXP.V; break;
case kFUNC_CALL_EXP: (* yyNew)->FUNC_CALL_EXP = yyt->FUNC_CALL_EXP;
copytTree ((* yyNew)->FUNC_CALL_EXP.FUNC_ID, yyt->FUNC_CALL_EXP.FUNC_ID)
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS;
yyNew = & (* yyNew)->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP: (* yyNew)->NAMED_EXP = yyt->NAMED_EXP;
copytIdent ((* yyNew)->NAMED_EXP.Name, yyt->NAMED_EXP.Name)
yyt = yyt->NAMED_EXP.VAL;
yyNew = & (* yyNew)->NAMED_EXP.VAL; break;
case kDO_EXP: (* yyNew)->DO_EXP = yyt->DO_EXP;
copytTree ((* yyNew)->DO_EXP.DO_ID, yyt->DO_EXP.DO_ID)
copytTree ((* yyNew)->DO_EXP.RANGE, yyt->DO_EXP.RANGE)
yyt = yyt->DO_EXP.BODY;
yyNew = & (* yyNew)->DO_EXP.BODY; break;
case kTYPE_EXP: (* yyNew)->TYPE_EXP = yyt->TYPE_EXP;
copytTree ((* yyNew)->TYPE_EXP.ID, yyt->TYPE_EXP.ID)
yyt = yyt->TYPE_EXP.ELEMENTS;
yyNew = & (* yyNew)->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP: (* yyNew)->ARRAY_EXP = yyt->ARRAY_EXP;
yyt = yyt->ARRAY_EXP.ELEMENTS;
yyNew = & (* yyNew)->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP: (* yyNew)->PERM_EXP = yyt->PERM_EXP;
copyPermutation ((* yyNew)->PERM_EXP.perm, yyt->PERM_EXP.perm)
yyt = yyt->PERM_EXP.VAL;
yyNew = & (* yyNew)->PERM_EXP.VAL; break;
case kBOUND_EXP: (* yyNew)->BOUND_EXP = yyt->BOUND_EXP;
copyint ((* yyNew)->BOUND_EXP.dim, yyt->BOUND_EXP.dim)
copyint ((* yyNew)->BOUND_EXP.kind, yyt->BOUND_EXP.kind)
copyint ((* yyNew)->BOUND_EXP.local, yyt->BOUND_EXP.local)
yyt = yyt->BOUND_EXP.VAR;
yyNew = & (* yyNew)->BOUND_EXP.VAR; break;
case kRANK_EXP: (* yyNew)->RANK_EXP = yyt->RANK_EXP;
copyint ((* yyNew)->RANK_EXP.kind, yyt->RANK_EXP.kind)
return;
case kBT_EXP_LIST: (* yyNew)->BT_EXP_LIST = yyt->BT_EXP_LIST;
return;
case kBTE_EMPTY: (* yyNew)->BTE_EMPTY = yyt->BTE_EMPTY;
return;
case kBTE_LIST: (* yyNew)->BTE_LIST = yyt->BTE_LIST;
copytTree ((* yyNew)->BTE_LIST.Elem, yyt->BTE_LIST.Elem)
yyt = yyt->BTE_LIST.Next;
yyNew = & (* yyNew)->BTE_LIST.Next; break;
case kBT_VAR: (* yyNew)->BT_VAR = yyt->BT_VAR;
return;
case kDUMMY_VAR: (* yyNew)->DUMMY_VAR = yyt->DUMMY_VAR;
return;
case kUSED_VAR: (* yyNew)->USED_VAR = yyt->USED_VAR;
yyt = yyt->USED_VAR.VARNAME;
yyNew = & (* yyNew)->USED_VAR.VARNAME; break;
case kINDEXED_VAR: (* yyNew)->INDEXED_VAR = yyt->INDEXED_VAR;
copytTree ((* yyNew)->INDEXED_VAR.IND_VAR, yyt->INDEXED_VAR.IND_VAR)
yyt = yyt->INDEXED_VAR.IND_EXPS;
yyNew = & (* yyNew)->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR: (* yyNew)->SUBSTRING_VAR = yyt->SUBSTRING_VAR;
copytTree ((* yyNew)->SUBSTRING_VAR.IND_VAR, yyt->SUBSTRING_VAR.IND_VAR)
yyt = yyt->SUBSTRING_VAR.IND_EXP;
yyNew = & (* yyNew)->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR: (* yyNew)->SELECTED_VAR = yyt->SELECTED_VAR;
copytTree ((* yyNew)->SELECTED_VAR.SELEC_VAR, yyt->SELECTED_VAR.SELEC_VAR)
yyt = yyt->SELECTED_VAR.SELECTOR;
yyNew = & (* yyNew)->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR: (* yyNew)->LOOP_VAR = yyt->LOOP_VAR;
yyt = yyt->LOOP_VAR.LOOP_VARNAME;
yyNew = & (* yyNew)->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR: (* yyNew)->PERM_VAR = yyt->PERM_VAR;
copyPermutation ((* yyNew)->PERM_VAR.perm, yyt->PERM_VAR.perm)
yyt = yyt->PERM_VAR.VAL;
yyNew = & (* yyNew)->PERM_VAR.VAL; break;
case kADDR: (* yyNew)->ADDR = yyt->ADDR;
yyt = yyt->ADDR.E;
yyNew = & (* yyNew)->ADDR.E; break;
case kDO_VAR: (* yyNew)->DO_VAR = yyt->DO_VAR;
copytTree ((* yyNew)->DO_VAR.DO_ID, yyt->DO_VAR.DO_ID)
copytTree ((* yyNew)->DO_VAR.RANGE, yyt->DO_VAR.RANGE)
yyt = yyt->DO_VAR.BODY;
yyNew = & (* yyNew)->DO_VAR.BODY; break;
case kREMOTE_VAR: (* yyNew)->REMOTE_VAR = yyt->REMOTE_VAR;
yyt = yyt->REMOTE_VAR.VAR;
yyNew = & (* yyNew)->REMOTE_VAR.VAR; break;
case kBT_VAR_LIST: (* yyNew)->BT_VAR_LIST = yyt->BT_VAR_LIST;
return;
case kBTV_EMPTY: (* yyNew)->BTV_EMPTY = yyt->BTV_EMPTY;
return;
case kBTV_LIST: (* yyNew)->BTV_LIST = yyt->BTV_LIST;
copytTree ((* yyNew)->BTV_LIST.Elem, yyt->BTV_LIST.Elem)
yyt = yyt->BTV_LIST.Next;
yyNew = & (* yyNew)->BTV_LIST.Next; break;
case kBT_PARAM: (* yyNew)->BT_PARAM = yyt->BT_PARAM;
return;
case kVAR_PARAM: (* yyNew)->VAR_PARAM = yyt->VAR_PARAM;
copytDefinitions ((* yyNew)->VAR_PARAM.formal, yyt->VAR_PARAM.formal)
copyint ((* yyNew)->VAR_PARAM.intent, yyt->VAR_PARAM.intent)
copyint ((* yyNew)->VAR_PARAM.layout, yyt->VAR_PARAM.layout)
copyint ((* yyNew)->VAR_PARAM.pass_by, yyt->VAR_PARAM.pass_by)
copyint ((* yyNew)->VAR_PARAM.trace, yyt->VAR_PARAM.trace)
yyt = yyt->VAR_PARAM.V;
yyNew = & (* yyNew)->VAR_PARAM.V; break;
case kVALUE_PARAM: (* yyNew)->VALUE_PARAM = yyt->VALUE_PARAM;
yyt = yyt->VALUE_PARAM.E;
yyNew = & (* yyNew)->VALUE_PARAM.E; break;
case kNAMED_PARAM: (* yyNew)->NAMED_PARAM = yyt->NAMED_PARAM;
copytIdent ((* yyNew)->NAMED_PARAM.Name, yyt->NAMED_PARAM.Name)
yyt = yyt->NAMED_PARAM.VAL;
yyNew = & (* yyNew)->NAMED_PARAM.VAL; break;
case kPROC_PARAM: (* yyNew)->PROC_PARAM = yyt->PROC_PARAM;
yyt = yyt->PROC_PARAM.P;
yyNew = & (* yyNew)->PROC_PARAM.P; break;
case kFUNC_PARAM: (* yyNew)->FUNC_PARAM = yyt->FUNC_PARAM;
yyt = yyt->FUNC_PARAM.F;
yyNew = & (* yyNew)->FUNC_PARAM.F; break;
case kFORMAT_PARAM: (* yyNew)->FORMAT_PARAM = yyt->FORMAT_PARAM;
copytStringRef ((* yyNew)->FORMAT_PARAM.S, yyt->FORMAT_PARAM.S)
return;
case kRETURN_PARAM: (* yyNew)->RETURN_PARAM = yyt->RETURN_PARAM;
copyint ((* yyNew)->RETURN_PARAM.label, yyt->RETURN_PARAM.label)
return;
case kNO_PARAM: (* yyNew)->NO_PARAM = yyt->NO_PARAM;
copyint ((* yyNew)->NO_PARAM.type, yyt->NO_PARAM.type)
return;
case kBT_PARAM_LIST: (* yyNew)->BT_PARAM_LIST = yyt->BT_PARAM_LIST;
return;
case kBTP_EMPTY: (* yyNew)->BTP_EMPTY = yyt->BTP_EMPTY;
return;
case kBTP_LIST: (* yyNew)->BTP_LIST = yyt->BTP_LIST;
copytTree ((* yyNew)->BTP_LIST.Elem, yyt->BTP_LIST.Elem)
yyt = yyt->BTP_LIST.Next;
yyNew = & (* yyNew)->BTP_LIST.Next; break;
case kCONSTANT: (* yyNew)->CONSTANT = yyt->CONSTANT;
return;
case kBOOL_CONSTANT: (* yyNew)->BOOL_CONSTANT = yyt->BOOL_CONSTANT;
copyint ((* yyNew)->BOOL_CONSTANT.value, yyt->BOOL_CONSTANT.value)
return;
case kINT_CONSTANT: (* yyNew)->INT_CONSTANT = yyt->INT_CONSTANT;
copyint ((* yyNew)->INT_CONSTANT.value, yyt->INT_CONSTANT.value)
return;
case kREAL_CONSTANT: (* yyNew)->REAL_CONSTANT = yyt->REAL_CONSTANT;
copytStringRef ((* yyNew)->REAL_CONSTANT.value, yyt->REAL_CONSTANT.value)
copyint ((* yyNew)->REAL_CONSTANT.kind, yyt->REAL_CONSTANT.kind)
return;
case kSTRING_CONSTANT: (* yyNew)->STRING_CONSTANT = yyt->STRING_CONSTANT;
copytStringRef ((* yyNew)->STRING_CONSTANT.value, yyt->STRING_CONSTANT.value)
return;
case kCOMPLEX_CONSTANT: (* yyNew)->COMPLEX_CONSTANT = yyt->COMPLEX_CONSTANT;
copytStringRef ((* yyNew)->COMPLEX_CONSTANT.rvalue, yyt->COMPLEX_CONSTANT.rvalue)
copytStringRef ((* yyNew)->COMPLEX_CONSTANT.ivalue, yyt->COMPLEX_CONSTANT.ivalue)
return;
case kPROC_OBJ: (* yyNew)->PROC_OBJ = yyt->PROC_OBJ;
copytIdent ((* yyNew)->PROC_OBJ.Ident, yyt->PROC_OBJ.Ident)
copytDefinitions ((* yyNew)->PROC_OBJ.Object, yyt->PROC_OBJ.Object)
return;
case kVAR_OBJ: (* yyNew)->VAR_OBJ = yyt->VAR_OBJ;
copyint ((* yyNew)->VAR_OBJ.Pos, yyt->VAR_OBJ.Pos)
copytIdent ((* yyNew)->VAR_OBJ.Ident, yyt->VAR_OBJ.Ident)
copytDefinitions ((* yyNew)->VAR_OBJ.Object, yyt->VAR_OBJ.Object)
copytReaching ((* yyNew)->VAR_OBJ.Reaching, yyt->VAR_OBJ.Reaching)
return;
case kTYPE_OBJ: (* yyNew)->TYPE_OBJ = yyt->TYPE_OBJ;
copytIdent ((* yyNew)->TYPE_OBJ.Ident, yyt->TYPE_OBJ.Ident)
copytDefinitions ((* yyNew)->TYPE_OBJ.Object, yyt->TYPE_OBJ.Object)
return;
case kREC_COMP: (* yyNew)->REC_COMP = yyt->REC_COMP;
copytIdent ((* yyNew)->REC_COMP.Ident, yyt->REC_COMP.Ident)
copytDefinitions ((* yyNew)->REC_COMP.Object, yyt->REC_COMP.Object)
return;
case kTOP_OBJ: (* yyNew)->TOP_OBJ = yyt->TOP_OBJ;
copytIdent ((* yyNew)->TOP_OBJ.Ident, yyt->TOP_OBJ.Ident)
copytDefinitions ((* yyNew)->TOP_OBJ.Object, yyt->TOP_OBJ.Object)
return;
case kTEMP_OBJ: (* yyNew)->TEMP_OBJ = yyt->TEMP_OBJ;
copytIdent ((* yyNew)->TEMP_OBJ.Ident, yyt->TEMP_OBJ.Ident)
copytDefinitions ((* yyNew)->TEMP_OBJ.Object, yyt->TEMP_OBJ.Object)
return;
case kOVERLAP_SPEC: (* yyNew)->OVERLAP_SPEC = yyt->OVERLAP_SPEC;
copyint ((* yyNew)->OVERLAP_SPEC.left_size, yyt->OVERLAP_SPEC.left_size)
copyint ((* yyNew)->OVERLAP_SPEC.right_size, yyt->OVERLAP_SPEC.right_size)
copyint ((* yyNew)->OVERLAP_SPEC.left_update, yyt->OVERLAP_SPEC.left_update)
copyint ((* yyNew)->OVERLAP_SPEC.right_update, yyt->OVERLAP_SPEC.right_update)
return;
case kDEPENDENCE_INFO: (* yyNew)->DEPENDENCE_INFO = yyt->DEPENDENCE_INFO;
return;
case kSERIAL_INFO: (* yyNew)->SERIAL_INFO = yyt->SERIAL_INFO;
return;
case kINDEP_INFO: (* yyNew)->INDEP_INFO = yyt->INDEP_INFO;
copybool ((* yyNew)->INDEP_INFO.user_independent, yyt->INDEP_INFO.user_independent)
copyint ((* yyNew)->INDEP_INFO.selection, yyt->INDEP_INFO.selection)
copyInfoTree ((* yyNew)->INDEP_INFO.red_vars, yyt->INDEP_INFO.red_vars)
copyInfoTree ((* yyNew)->INDEP_INFO.new_vars, yyt->INDEP_INFO.new_vars)
return;
case kVECTOR_INFO: (* yyNew)->VECTOR_INFO = yyt->VECTOR_INFO;
copybool ((* yyNew)->VECTOR_INFO.is_independent, yyt->VECTOR_INFO.is_independent)
copyint ((* yyNew)->VECTOR_INFO.selection, yyt->VECTOR_INFO.selection)
copyint ((* yyNew)->VECTOR_INFO.loop_cnt, yyt->VECTOR_INFO.loop_cnt)
copyInfoTree ((* yyNew)->VECTOR_INFO.independent_vars, yyt->VECTOR_INFO.independent_vars)
return;
case kPARDO_INFO: (* yyNew)->PARDO_INFO = yyt->PARDO_INFO;
return;
case kHOME_INFO: (* yyNew)->HOME_INFO = yyt->HOME_INFO;
return;
case kNO_HOME_INFO: (* yyNew)->NO_HOME_INFO = yyt->NO_HOME_INFO;
return;
case kCOMM_INFO: (* yyNew)->COMM_INFO = yyt->COMM_INFO;
copyInfoTree ((* yyNew)->COMM_INFO.home_var, yyt->COMM_INFO.home_var)
copybool ((* yyNew)->COMM_INFO.is_local, yyt->COMM_INFO.is_local)
return;
case kON_INFO: (* yyNew)->ON_INFO = yyt->ON_INFO;
copytObject ((* yyNew)->ON_INFO.on_id, yyt->ON_INFO.on_id)
copyint ((* yyNew)->ON_INFO.on_dim, yyt->ON_INFO.on_dim)
copyint ((* yyNew)->ON_INFO.base, yyt->ON_INFO.base)
copyint ((* yyNew)->ON_INFO.stride, yyt->ON_INFO.stride)
return;
case kPARALLEL_INFO: (* yyNew)->PARALLEL_INFO = yyt->PARALLEL_INFO;
copyInfoTree ((* yyNew)->PARALLEL_INFO.reduction_vars, yyt->PARALLEL_INFO.reduction_vars)
copyInfoTree ((* yyNew)->PARALLEL_INFO.home_var, yyt->PARALLEL_INFO.home_var)
copyInfoTree ((* yyNew)->PARALLEL_INFO.new_vars, yyt->PARALLEL_INFO.new_vars)
copyInfoTree ((* yyNew)->PARALLEL_INFO.resident_vars, yyt->PARALLEL_INFO.resident_vars)
return;
case kREACHING_INFO: (* yyNew)->REACHING_INFO = yyt->REACHING_INFO;
copyInfoTree ((* yyNew)->REACHING_INFO.var_allocate, yyt->REACHING_INFO.var_allocate)
copyInfoTree ((* yyNew)->REACHING_INFO.temp_allocate, yyt->REACHING_INFO.temp_allocate)
copytDefinitions ((* yyNew)->REACHING_INFO.var_distribution, yyt->REACHING_INFO.var_distribution)
copytDefinitions ((* yyNew)->REACHING_INFO.temp_distribution, yyt->REACHING_INFO.temp_distribution)
return;
  default: ;
  }
 }
}

tTree CopyTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 tTree yyNew;
 yyMark (yyt);
 yyOldToNewCount = 0;
 yyCopyTree (yyt, & yyNew);
 return yyNew;
}

static bool yyCheckTree ARGS((tTree yyt));

bool CheckTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 yyMark (yyt);
 return yyCheckTree (yyt);
}

static bool yyCheckChild
# if defined __STDC__ | defined __cplusplus
 (tTree yyParent, tTree yyyChild, Tree_tKind yyType, char * yySelector)
# else
 (yyParent, yyyChild, yyType, yySelector)
 tTree yyParent, yyyChild;
 Tree_tKind yyType;
 char * yySelector;
# endif
{
 bool yySuccess = Tree_IsType (yyyChild, yyType);
 if (! yySuccess) {
  (void) fputs ("CheckTree: parent = ", stderr);
  WriteTreeNode (stderr, yyParent);
  (void) fprintf (stderr, "\nselector: %s child = ", yySelector);
  WriteTreeNode (stderr, yyyChild);
  (void) fputc ('\n', stderr);
 }
 return yyCheckTree (yyyChild) && yySuccess;
}

static bool yyCheckTree
# if defined __STDC__ | defined __cplusplus
 (tTree yyt)
# else
 (yyt) tTree yyt;
# endif
{
 bool yyResult;
 if (yyt == NoTree) return false;
 else if (yyt->yyHead.yyMark == 0) return true;
 yyt->yyHead.yyMark = 0;

 yyResult = true;
 switch (yyt->Kind) {
case kCOMP_UNIT:
yyResult = yyCheckChild (yyt, yyt->COMP_UNIT.COMP_ELEMENTS, kUNIT_NODE_LIST, "COMP_ELEMENTS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->COMP_UNIT.USED_ELEMENTS, kUNIT_NODE_LIST, "USED_ELEMENTS") && yyResult;
break;
case kUNIT_LIST:
yyResult = yyCheckChild (yyt, yyt->UNIT_LIST.Elem, kUNIT_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->UNIT_LIST.Next, kUNIT_NODE_LIST, "Next") && yyResult;
break;
case kMODULE_DECL:
yyResult = yyCheckChild (yyt, yyt->MODULE_DECL.MODULE_BODY, kBODY_NODE, "MODULE_BODY") && yyResult;
break;
case kPROGRAM_DECL:
yyResult = yyCheckChild (yyt, yyt->PROGRAM_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PROGRAM_DECL.PROGRAM_BODY, kBODY_NODE, "PROGRAM_BODY") && yyResult;
break;
case kPROC_DECL:
yyResult = yyCheckChild (yyt, yyt->PROC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PROC_DECL.PROC_BODY, kBODY_NODE, "PROC_BODY") && yyResult;
break;
case kFUNC_DECL:
yyResult = yyCheckChild (yyt, yyt->FUNC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_DECL.FUNC_BODY, kBODY_NODE, "FUNC_BODY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_DECL.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
break;
case kBLOCK_DATA_DECL:
yyResult = yyCheckChild (yyt, yyt->BLOCK_DATA_DECL.DATA_BODY, kBODY_NODE, "DATA_BODY") && yyResult;
break;
case kINTERFACE:
yyResult = yyCheckChild (yyt, yyt->INTERFACE.SPEC, kGENERIC_SPEC, "SPEC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INTERFACE.ITEMS, kUNIT_NODE_LIST, "ITEMS") && yyResult;
break;
case kBODY_NODE:
yyResult = yyCheckChild (yyt, yyt->BODY_NODE.DECLS, kDECL_NODE_LIST, "DECLS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BODY_NODE.STATS, kACF_NODE_LIST, "STATS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BODY_NODE.INTERNALS, kUNIT_NODE_LIST, "INTERNALS") && yyResult;
break;
case kINTEGER_TYPE:
yyResult = yyCheckChild (yyt, yyt->INTEGER_TYPE.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kREAL_TYPE:
yyResult = yyCheckChild (yyt, yyt->REAL_TYPE.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kBOOLEAN_TYPE:
yyResult = yyCheckChild (yyt, yyt->BOOLEAN_TYPE.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kCOMPLEX_TYPE:
yyResult = yyCheckChild (yyt, yyt->COMPLEX_TYPE.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kSTRING_TYPE:
yyResult = yyCheckChild (yyt, yyt->STRING_TYPE.LENGTH, kBT_EXP, "LENGTH") && yyResult;
break;
case kTYPE_ID:
yyResult = yyCheckChild (yyt, yyt->TYPE_ID.ID, kTYPE_OBJ, "ID") && yyResult;
break;
case kARRAY_TYPE:
yyResult = yyCheckChild (yyt, yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES, kSHAPE_SPEC_LIST, "ARRAY_INDEX_TYPES") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ARRAY_TYPE.ARRAY_COMP_TYPE, kTYPE_NODE, "ARRAY_COMP_TYPE") && yyResult;
break;
case kRECORD_TYPE:
yyResult = yyCheckChild (yyt, yyt->RECORD_TYPE.COMPONENTS, kDECL_NODE_LIST, "COMPONENTS") && yyResult;
break;
case kPOINTER_TYPE:
yyResult = yyCheckChild (yyt, yyt->POINTER_TYPE.PTR_COMP, kTYPE_NODE, "PTR_COMP") && yyResult;
break;
case kSHAPE_SPEC:
yyResult = yyCheckChild (yyt, yyt->SHAPE_SPEC.Overlap, kOVERLAP_SPEC, "Overlap") && yyResult;
break;
case kEXPLICIT_SHAPE:
yyResult = yyCheckChild (yyt, yyt->EXPLICIT_SHAPE.Overlap, kOVERLAP_SPEC, "Overlap") && yyResult;
yyResult = yyCheckChild (yyt, yyt->EXPLICIT_SHAPE.LOWER, kBT_EXP, "LOWER") && yyResult;
yyResult = yyCheckChild (yyt, yyt->EXPLICIT_SHAPE.UPPER, kBT_EXP, "UPPER") && yyResult;
break;
case kASSUMED_SHAPE:
yyResult = yyCheckChild (yyt, yyt->ASSUMED_SHAPE.Overlap, kOVERLAP_SPEC, "Overlap") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASSUMED_SHAPE.LOWER, kBT_EXP, "LOWER") && yyResult;
break;
case kDEFERRED_SHAPE:
yyResult = yyCheckChild (yyt, yyt->DEFERRED_SHAPE.Overlap, kOVERLAP_SPEC, "Overlap") && yyResult;
break;
case kASSUMED_SIZE:
yyResult = yyCheckChild (yyt, yyt->ASSUMED_SIZE.Overlap, kOVERLAP_SPEC, "Overlap") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASSUMED_SIZE.LOWER, kBT_EXP, "LOWER") && yyResult;
break;
case kSHAPE_LIST:
yyResult = yyCheckChild (yyt, yyt->SHAPE_LIST.Elem, kSHAPE_SPEC, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SHAPE_LIST.Next, kSHAPE_SPEC_LIST, "Next") && yyResult;
break;
case kTYPE_DECL:
yyResult = yyCheckChild (yyt, yyt->TYPE_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kENTITY_DECL:
yyResult = yyCheckChild (yyt, yyt->ENTITY_DECL.ATTRIBUTES, kDECL_LIST, "ATTRIBUTES") && yyResult;
break;
case kVAR_DECL:
yyResult = yyCheckChild (yyt, yyt->VAR_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kCOMMON_DECL:
yyResult = yyCheckChild (yyt, yyt->COMMON_DECL.IDS, kDECL_NODE_LIST, "IDS") && yyResult;
break;
case kNAMELIST_DECL:
yyResult = yyCheckChild (yyt, yyt->NAMELIST_DECL.IDS, kDECL_NODE_LIST, "IDS") && yyResult;
break;
case kTEMPLATE_DECL:
yyResult = yyCheckChild (yyt, yyt->TEMPLATE_DECL.DIMENSIONS, kSHAPE_SPEC_LIST, "DIMENSIONS") && yyResult;
break;
case kRAGGED_DECL:
yyResult = yyCheckChild (yyt, yyt->RAGGED_DECL.DIMENSIONS, kSHAPE_SPEC_LIST, "DIMENSIONS") && yyResult;
break;
case kPROCESSORS_DECL:
yyResult = yyCheckChild (yyt, yyt->PROCESSORS_DECL.DIMENSIONS, kSHAPE_SPEC_LIST, "DIMENSIONS") && yyResult;
break;
case kSUB_PROCS_DECL:
yyResult = yyCheckChild (yyt, yyt->SUB_PROCS_DECL.TOP, kTOP_OBJ, "TOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SUB_PROCS_DECL.DIMENSIONS, kBTE_LIST, "DIMENSIONS") && yyResult;
break;
case kRANGE_DECL:
yyResult = yyCheckChild (yyt, yyt->RANGE_DECL.RANGES, kRANGE_SPEC_LIST, "RANGES") && yyResult;
break;
case kSTMT_FUNC_DECL:
yyResult = yyCheckChild (yyt, yyt->STMT_FUNC_DECL.FORMALS, kDECL_NODE_LIST, "FORMALS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->STMT_FUNC_DECL.RESULT_TYPE, kTYPE_NODE, "RESULT_TYPE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->STMT_FUNC_DECL.FFUNC_BODY, kBT_EXP, "FFUNC_BODY") && yyResult;
break;
case kINTERFACE_DECL:
yyResult = yyCheckChild (yyt, yyt->INTERFACE_DECL.SPEC, kGENERIC_SPEC, "SPEC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INTERFACE_DECL.ITEMS, kUNIT_NODE_LIST, "ITEMS") && yyResult;
break;
case kVAR_PARAM_DECL:
yyResult = yyCheckChild (yyt, yyt->VAR_PARAM_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kIMPLICIT_DECL:
yyResult = yyCheckChild (yyt, yyt->IMPLICIT_DECL.TYPE, kTYPE_NODE, "TYPE") && yyResult;
break;
case kUSE_DECL:
yyResult = yyCheckChild (yyt, yyt->USE_DECL.RENAMINGS, kDECL_NODE_LIST, "RENAMINGS") && yyResult;
break;
case kONLY_USE_DECL:
yyResult = yyCheckChild (yyt, yyt->ONLY_USE_DECL.NAMES, kDECL_NODE_LIST, "NAMES") && yyResult;
break;
case kEQV_DECL:
yyResult = yyCheckChild (yyt, yyt->EQV_DECL.VARS, kBT_VAR_LIST, "VARS") && yyResult;
break;
case kDATA_DECL:
yyResult = yyCheckChild (yyt, yyt->DATA_DECL.VARS, kBT_VAR_LIST, "VARS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DATA_DECL.VALS, kBT_EXP_LIST, "VALS") && yyResult;
break;
case kFORMAT_DECL:
yyResult = yyCheckChild (yyt, yyt->FORMAT_DECL.FORMAT_PARAMS, kBT_PARAM_LIST, "FORMAT_PARAMS") && yyResult;
break;
case kDIMENSION_DECL:
yyResult = yyCheckChild (yyt, yyt->DIMENSION_DECL.INDEXES, kSHAPE_SPEC_LIST, "INDEXES") && yyResult;
break;
case kINIT_DATA_DECL:
yyResult = yyCheckChild (yyt, yyt->INIT_DATA_DECL.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kTYPESPEC_DECL:
yyResult = yyCheckChild (yyt, yyt->TYPESPEC_DECL.VAL, kTYPE_NODE, "VAL") && yyResult;
break;
case kPARAMETER_DECL:
yyResult = yyCheckChild (yyt, yyt->PARAMETER_DECL.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kDISTRIBUTE_DECL:
yyResult = yyCheckChild (yyt, yyt->DISTRIBUTE_DECL.DISTRIBUTION, kDISTRIBUTION_SPEC, "DISTRIBUTION") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DISTRIBUTE_DECL.TARGET, kPROCESSOR_SPEC, "TARGET") && yyResult;
break;
case kALIGN_DECL:
yyResult = yyCheckChild (yyt, yyt->ALIGN_DECL.ALIGN_SOURCE, kBT_EXP_LIST, "ALIGN_SOURCE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ALIGN_DECL.ALIGN_TARGET, kALIGN_SPEC, "ALIGN_TARGET") && yyResult;
break;
case kMAP_DECL:
yyResult = yyCheckChild (yyt, yyt->MAP_DECL.MAP_TARGET, kBT_EXP, "MAP_TARGET") && yyResult;
break;
case kOVERLAP_DECL:
yyResult = yyCheckChild (yyt, yyt->OVERLAP_DECL.OVERLAPS, kSHAPE_SPEC_LIST, "OVERLAPS") && yyResult;
break;
case kSELECT_DECL:
yyResult = yyCheckChild (yyt, yyt->SELECT_DECL.SELECTIONS, kSELECT_SPEC_LIST, "SELECTIONS") && yyResult;
break;
case kDECL_LIST:
yyResult = yyCheckChild (yyt, yyt->DECL_LIST.Elem, kDECL_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DECL_LIST.Next, kDECL_NODE_LIST, "Next") && yyResult;
break;
case kRANGE_LIST:
yyResult = yyCheckChild (yyt, yyt->RANGE_LIST.Elem, kDISTRIBUTION_SPEC, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->RANGE_LIST.Next, kRANGE_SPEC_LIST, "Next") && yyResult;
break;
case kSELECT_LIST:
yyResult = yyCheckChild (yyt, yyt->SELECT_LIST.Elem, kSELECT_SPEC, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECT_LIST.Next, kSELECT_SPEC_LIST, "Next") && yyResult;
break;
case kNODE_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->NODE_DISTRIBUTION.MAPPING, kDIST_FORMAT_LIST, "MAPPING") && yyResult;
break;
case kDIST_LIST:
yyResult = yyCheckChild (yyt, yyt->DIST_LIST.Elem, kDISTRIBUTION_FORMAT, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DIST_LIST.Next, kDIST_FORMAT_LIST, "Next") && yyResult;
break;
case kBLOCK_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->BLOCK_DISTRIBUTION.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kCYCLIC_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->CYCLIC_DISTRIBUTION.SIZE, kBT_EXP, "SIZE") && yyResult;
break;
case kGEN_BLOCK_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->GEN_BLOCK_DISTRIBUTION.ARRAY, kBT_VAR, "ARRAY") && yyResult;
break;
case kINDIRECT_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->INDIRECT_DISTRIBUTION.ARRAY, kBT_VAR, "ARRAY") && yyResult;
break;
case kARBITRARY_DISTRIBUTION:
yyResult = yyCheckChild (yyt, yyt->ARBITRARY_DISTRIBUTION.SIZE, kBT_EXP, "SIZE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ARBITRARY_DISTRIBUTION.LENGTH, kBT_VAR, "LENGTH") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ARBITRARY_DISTRIBUTION.MAP, kBT_VAR, "MAP") && yyResult;
break;
case kPROCESSOR_ARRAY:
yyResult = yyCheckChild (yyt, yyt->PROCESSOR_ARRAY.TOPNAME, kTOP_OBJ, "TOPNAME") && yyResult;
break;
case kPROCESSOR_SUBSET:
yyResult = yyCheckChild (yyt, yyt->PROCESSOR_SUBSET.SUBTOP, kTOP_OBJ, "SUBTOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PROCESSOR_SUBSET.FULLTOP, kTOP_OBJ, "FULLTOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PROCESSOR_SUBSET.SUBSCRIPTS, kBT_EXP_LIST, "SUBSCRIPTS") && yyResult;
break;
case kALIGN_SPEC:
yyResult = yyCheckChild (yyt, yyt->ALIGN_SPEC.TEMPNAME, kTEMP_OBJ, "TEMPNAME") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ALIGN_SPEC.SUBSCRIPTS, kBT_EXP_LIST, "SUBSCRIPTS") && yyResult;
break;
case kOP_GENERIC_SPEC:
yyResult = yyCheckChild (yyt, yyt->OP_GENERIC_SPEC.OPERATOR, kOP, "OPERATOR") && yyResult;
break;
case kACF_LIST:
yyResult = yyCheckChild (yyt, yyt->ACF_LIST.Elem, kACF_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_LIST.Next, kACF_NODE_LIST, "Next") && yyResult;
break;
case kACF_BASIC:
yyResult = yyCheckChild (yyt, yyt->ACF_BASIC.BASIC_STMT, kBT_STMT, "BASIC_STMT") && yyResult;
break;
case kACF_IF:
yyResult = yyCheckChild (yyt, yyt->ACF_IF.IF_EXP, kBT_EXP, "IF_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_IF.THEN_PART, kACF_NODE_LIST, "THEN_PART") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_IF.ELSE_PART, kACF_NODE_LIST, "ELSE_PART") && yyResult;
break;
case kACF_WHERE:
yyResult = yyCheckChild (yyt, yyt->ACF_WHERE.WHERE_EXP, kBT_EXP, "WHERE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WHERE.TRUE_PART, kACF_NODE_LIST, "TRUE_PART") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WHERE.FALSE_PART, kACF_NODE_LIST, "FALSE_PART") && yyResult;
break;
case kACF_CASE:
yyResult = yyCheckChild (yyt, yyt->ACF_CASE.CASE_EXP, kBT_EXP, "CASE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_CASE.CASE_ALTS, kSELECTED_ACF_NODE_LIST, "CASE_ALTS") && yyResult;
break;
case kACF_WHILE:
yyResult = yyCheckChild (yyt, yyt->ACF_WHILE.WHILE_EXP, kBT_EXP, "WHILE_EXP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_WHILE.WHILE_BODY, kACF_NODE_LIST, "WHILE_BODY") && yyResult;
break;
case kACF_REPEAT:
yyResult = yyCheckChild (yyt, yyt->ACF_REPEAT.REPEAT_BODY, kACF_NODE_LIST, "REPEAT_BODY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_REPEAT.REPEAT_EXP, kBT_EXP, "REPEAT_EXP") && yyResult;
break;
case kACF_LOOP:
yyResult = yyCheckChild (yyt, yyt->ACF_LOOP.LOOP_BODY, kACF_NODE_LIST, "LOOP_BODY") && yyResult;
break;
case kACF_DO:
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_ID, kBT_VAR, "DO_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_RANGE, kSLICE_EXP, "DO_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_BODY, kACF_NODE_LIST, "DO_BODY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_DEP_INFO, kDEPENDENCE_INFO, "DO_DEP_INFO") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_DO.DO_HOME_INFO, kHOME_INFO, "DO_HOME_INFO") && yyResult;
break;
case kACF_FORALL:
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_ID, kBT_VAR, "FORALL_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_RANGE, kSLICE_EXP, "FORALL_RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_BODY, kACF_NODE_LIST, "FORALL_BODY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_DEP_INFO, kDEPENDENCE_INFO, "FORALL_DEP_INFO") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_FORALL.FORALL_HOME_INFO, kHOME_INFO, "FORALL_HOME_INFO") && yyResult;
break;
case kACF_FLOW_GRAPH:
yyResult = yyCheckChild (yyt, yyt->ACF_FLOW_GRAPH.FLOW_NODES, kACF_NODE_LIST, "FLOW_NODES") && yyResult;
break;
case kACF_ENTRY:
yyResult = yyCheckChild (yyt, yyt->ACF_ENTRY.ENTRY_DECL, kUNIT_NODE, "ENTRY_DECL") && yyResult;
break;
case kACF_HOME:
yyResult = yyCheckChild (yyt, yyt->ACF_HOME.HOME_VAR, kON_CLAUSE, "HOME_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_HOME.HOME_BODY, kACF_NODE_LIST, "HOME_BODY") && yyResult;
break;
case kACF_RESIDENT:
yyResult = yyCheckChild (yyt, yyt->ACF_RESIDENT.RESIDENT_VAR, kBT_VAR_LIST, "RESIDENT_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_RESIDENT.RESIDENT_BODY, kACF_NODE_LIST, "RESIDENT_BODY") && yyResult;
break;
case kACF_NEW:
yyResult = yyCheckChild (yyt, yyt->ACF_NEW.NEW_VAR, kBT_VAR_LIST, "NEW_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_NEW.NEW_BODY, kACF_NODE_LIST, "NEW_BODY") && yyResult;
break;
case kACF_REDUCTION:
yyResult = yyCheckChild (yyt, yyt->ACF_REDUCTION.REDUCTION_VAR, kBT_VAR_LIST, "REDUCTION_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_REDUCTION.REDUCTION_LVAR, kBT_VAR_LIST, "REDUCTION_LVAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_REDUCTION.REDUCTION_FUNC, kPROC_OBJ, "REDUCTION_FUNC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_REDUCTION.REDUCTION_BODY, kACF_NODE_LIST, "REDUCTION_BODY") && yyResult;
break;
case kACF_TASK_REGION:
yyResult = yyCheckChild (yyt, yyt->ACF_TASK_REGION.TASK_BODY, kACF_NODE_LIST, "TASK_BODY") && yyResult;
break;
case kACF_PARALLEL:
yyResult = yyCheckChild (yyt, yyt->ACF_PARALLEL.REDUCTION_VARS, kBT_VAR_LIST, "REDUCTION_VARS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_PARALLEL.SHARED_VARS, kBT_VAR_LIST, "SHARED_VARS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_PARALLEL.LOCAL_VARS, kBT_VAR_LIST, "LOCAL_VARS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_PARALLEL.PARALLEL_BODY, kACF_NODE_LIST, "PARALLEL_BODY") && yyResult;
break;
case kACF_CRITICAL:
yyResult = yyCheckChild (yyt, yyt->ACF_CRITICAL.CRITICAL_BODY, kACF_NODE_LIST, "CRITICAL_BODY") && yyResult;
break;
case kACF_ON:
yyResult = yyCheckChild (yyt, yyt->ACF_ON.ON_HOME, kON_TOPOLOGY, "ON_HOME") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_ON.ON_SPECS, kON_SPEC_LIST, "ON_SPECS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_ON.ON_BODY, kACF_NODE_LIST, "ON_BODY") && yyResult;
break;
case kACF_RM_READ:
yyResult = yyCheckChild (yyt, yyt->ACF_RM_READ.LOCAL_VAR, kBT_VAR, "LOCAL_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_RM_READ.REMOTE_VAR, kBT_VAR, "REMOTE_VAR") && yyResult;
break;
case kACF_RM_WRITE:
yyResult = yyCheckChild (yyt, yyt->ACF_RM_WRITE.REMOTE_VAR, kBT_VAR, "REMOTE_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ACF_RM_WRITE.LOCAL_DATA, kBT_EXP, "LOCAL_DATA") && yyResult;
break;
case kACF_MOVE:
yyResult = yyCheckChild (yyt, yyt->ACF_MOVE.MOVE_STMT, kBT_STMT, "MOVE_STMT") && yyResult;
break;
case kACF_BARRIER:
yyResult = yyCheckChild (yyt, yyt->ACF_BARRIER.BARRIER_VARS, kBT_VAR_LIST, "BARRIER_VARS") && yyResult;
break;
case kACF_UPDATE:
yyResult = yyCheckChild (yyt, yyt->ACF_UPDATE.OVERLAP_VAR, kBT_VAR, "OVERLAP_VAR") && yyResult;
break;
case kON_VAR_CLAUSE:
yyResult = yyCheckChild (yyt, yyt->ON_VAR_CLAUSE.ON_VAR, kBT_VAR, "ON_VAR") && yyResult;
break;
case kON_PROC_CLAUSE:
yyResult = yyCheckChild (yyt, yyt->ON_PROC_CLAUSE.ON_PROC, kPROCESSOR_SPEC, "ON_PROC") && yyResult;
break;
case kON_LIST:
yyResult = yyCheckChild (yyt, yyt->ON_LIST.Elem, kON_SPEC, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ON_LIST.Next, kON_SPEC_LIST, "Next") && yyResult;
break;
case kON_SPEC:
yyResult = yyCheckChild (yyt, yyt->ON_SPEC.ON_VAL, kBT_EXP, "ON_VAL") && yyResult;
break;
case kSELECTED_ACF_LIST:
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_LIST.Elem, kSELECTED_ACF_NODE, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_LIST.Next, kSELECTED_ACF_NODE_LIST, "Next") && yyResult;
break;
case kSELECTED_ACF_NODE:
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_NODE.SELECT_LIST, kBT_EXP_LIST, "SELECT_LIST") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_ACF_NODE.SELECT_ACFS, kACF_NODE_LIST, "SELECT_ACFS") && yyResult;
break;
case kASSIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->ASSIGN_STMT.ASSIGN_VAR, kBT_VAR, "ASSIGN_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASSIGN_STMT.ASSIGN_EXP, kBT_EXP, "ASSIGN_EXP") && yyResult;
break;
case kPTR_ASSIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->PTR_ASSIGN_STMT.ASSIGN_VAR, kBT_VAR, "ASSIGN_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->PTR_ASSIGN_STMT.ASSIGN_EXP, kBT_EXP, "ASSIGN_EXP") && yyResult;
break;
case kLABEL_ASSIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->LABEL_ASSIGN_STMT.LABEL_VAR, kBT_VAR, "LABEL_VAR") && yyResult;
break;
case kCALL_STMT:
yyResult = yyCheckChild (yyt, yyt->CALL_STMT.CALL_ID, kPROC_OBJ, "CALL_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CALL_STMT.CALL_PARAMS, kBT_PARAM_LIST, "CALL_PARAMS") && yyResult;
break;
case kIO_STMT:
yyResult = yyCheckChild (yyt, yyt->IO_STMT.ID, kPROC_OBJ, "ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IO_STMT.IO_SPECS, kBT_PARAM_LIST, "IO_SPECS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IO_STMT.IO_ITEMS, kBT_PARAM_LIST, "IO_ITEMS") && yyResult;
break;
case kASS_GOTO_STMT:
yyResult = yyCheckChild (yyt, yyt->ASS_GOTO_STMT.GOTO_VAR, kBT_VAR, "GOTO_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ASS_GOTO_STMT.LABELS, kLABEL_USE_LIST, "LABELS") && yyResult;
break;
case kCOMP_GOTO_STMT:
yyResult = yyCheckChild (yyt, yyt->COMP_GOTO_STMT.GOTO_LABELS, kLABEL_USE_LIST, "GOTO_LABELS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->COMP_GOTO_STMT.GOTO_EXP, kBT_EXP, "GOTO_EXP") && yyResult;
break;
case kCOMP_IF_STMT:
yyResult = yyCheckChild (yyt, yyt->COMP_IF_STMT.IF_EXP, kBT_EXP, "IF_EXP") && yyResult;
break;
case kRETURN_STMT:
yyResult = yyCheckChild (yyt, yyt->RETURN_STMT.RETURN_EXP, kBT_EXP, "RETURN_EXP") && yyResult;
break;
case kPAUSE_STMT:
yyResult = yyCheckChild (yyt, yyt->PAUSE_STMT.PAUSE_CONST, kCONSTANT, "PAUSE_CONST") && yyResult;
break;
case kSTOP_STMT:
yyResult = yyCheckChild (yyt, yyt->STOP_STMT.STOP_CONST, kBT_EXP, "STOP_CONST") && yyResult;
break;
case kFORMAT_STMT:
yyResult = yyCheckChild (yyt, yyt->FORMAT_STMT.FORMAT_PARAMS, kBT_PARAM_LIST, "FORMAT_PARAMS") && yyResult;
break;
case kINHERIT_DSP_STMT:
yyResult = yyCheckChild (yyt, yyt->INHERIT_DSP_STMT.VAR, kBT_VAR, "VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INHERIT_DSP_STMT.SHAPE, kSHAPE_SPEC_LIST, "SHAPE") && yyResult;
break;
case kCREATE_DSP_STMT:
yyResult = yyCheckChild (yyt, yyt->CREATE_DSP_STMT.VAR, kBT_VAR, "VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->CREATE_DSP_STMT.SHAPE, kSHAPE_SPEC_LIST, "SHAPE") && yyResult;
break;
case kFREE_DSP_STMT:
yyResult = yyCheckChild (yyt, yyt->FREE_DSP_STMT.VAR, kBT_VAR, "VAR") && yyResult;
break;
case kALLOCATE_STMT:
yyResult = yyCheckChild (yyt, yyt->ALLOCATE_STMT.PARAMS, kBT_PARAM_LIST, "PARAMS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->ALLOCATE_STMT.STATUS, kBT_VAR, "STATUS") && yyResult;
break;
case kDEALLOCATE_STMT:
yyResult = yyCheckChild (yyt, yyt->DEALLOCATE_STMT.PARAMS, kBT_PARAM_LIST, "PARAMS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DEALLOCATE_STMT.STATUS, kBT_VAR, "STATUS") && yyResult;
break;
case kNULLIFY_STMT:
yyResult = yyCheckChild (yyt, yyt->NULLIFY_STMT.PARAMS, kBT_PARAM_LIST, "PARAMS") && yyResult;
break;
case kREDUCE_STMT:
yyResult = yyCheckChild (yyt, yyt->REDUCE_STMT.RED_FUNC, kPROC_OBJ, "RED_FUNC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDUCE_STMT.RED_PARAMS, kBT_PARAM_LIST, "RED_PARAMS") && yyResult;
break;
case kMOVE_STMT:
yyResult = yyCheckChild (yyt, yyt->MOVE_STMT.TARGET, kBT_VAR, "TARGET") && yyResult;
yyResult = yyCheckChild (yyt, yyt->MOVE_STMT.SOURCE, kBT_VAR, "SOURCE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->MOVE_STMT.MASK, kBT_PARAM, "MASK") && yyResult;
break;
case kSCATTER_STMT:
yyResult = yyCheckChild (yyt, yyt->SCATTER_STMT.ARRAY, kBT_VAR, "ARRAY") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SCATTER_STMT.BASE, kBT_VAR, "BASE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SCATTER_STMT.INDEXES, kBT_PARAM_LIST, "INDEXES") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SCATTER_STMT.MASK, kBT_PARAM, "MASK") && yyResult;
break;
case kREALIGN_STMT:
yyResult = yyCheckChild (yyt, yyt->REALIGN_STMT.ALIGNEE, kBT_VAR_LIST, "ALIGNEE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REALIGN_STMT.ALIGN_SOURCE, kBT_EXP_LIST, "ALIGN_SOURCE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REALIGN_STMT.ALIGN_TARGET, kALIGN_SPEC, "ALIGN_TARGET") && yyResult;
break;
case kREDISTRIBUTE_STMT:
yyResult = yyCheckChild (yyt, yyt->REDISTRIBUTE_STMT.DISTRIBUTEE, kBT_VAR_LIST, "DISTRIBUTEE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDISTRIBUTE_STMT.DISTRIBUTION, kDISTRIBUTION_SPEC, "DISTRIBUTION") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDISTRIBUTE_STMT.TARGET, kPROCESSOR_SPEC, "TARGET") && yyResult;
break;
case kREG_SHADOW_GET:
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_GET.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_GET.SHADOW_SIZE, kBT_EXP_LIST, "SHADOW_SIZE") && yyResult;
break;
case kREG_SHADOW_PUT:
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_PUT.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_PUT.SHADOW_SIZE, kBT_EXP_LIST, "SHADOW_SIZE") && yyResult;
break;
case kREG_SHADOW_SET:
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_SET.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_SET.SHADOW_SIZE, kBT_EXP_LIST, "SHADOW_SIZE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REG_SHADOW_SET.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kIND_SHADOW_CREATE:
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_CREATE.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_CREATE.INDEX_VAR, kBT_VAR, "INDEX_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR, kBT_VAR, "TMP_INDEX_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_CREATE.MASK, kBT_VAR, "MASK") && yyResult;
break;
case kIND_SHADOW_FREE:
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_FREE.INDEX_VAR, kBT_VAR, "INDEX_VAR") && yyResult;
break;
case kIND_SHADOW_GET:
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_GET.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
break;
case kIND_SHADOW_PUT:
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_PUT.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
break;
case kIND_SHADOW_SET:
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_SET.SHADOW_VAR, kBT_VAR, "SHADOW_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->IND_SHADOW_SET.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kBROADCAST_STMT:
yyResult = yyCheckChild (yyt, yyt->BROADCAST_STMT.ELEMS, kBT_VAR_LIST, "ELEMS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BROADCAST_STMT.OWNER_TOP, kON_TOPOLOGY, "OWNER_TOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BROADCAST_STMT.OWNER_SPEC, kON_SPEC_LIST, "OWNER_SPEC") && yyResult;
break;
case kREDUCTION_STMT:
yyResult = yyCheckChild (yyt, yyt->REDUCTION_STMT.REDFUNC, kPROC_OBJ, "REDFUNC") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDUCTION_STMT.ELEMS, kBT_VAR_LIST, "ELEMS") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDUCTION_STMT.RED_TOP, kON_TOPOLOGY, "RED_TOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->REDUCTION_STMT.RED_SPEC, kON_SPEC_LIST, "RED_SPEC") && yyResult;
break;
case kDIRTY_STMT:
yyResult = yyCheckChild (yyt, yyt->DIRTY_STMT.ELEMS, kBT_VAR_LIST, "ELEMS") && yyResult;
break;
case kLABEL_LIST:
yyResult = yyCheckChild (yyt, yyt->LABEL_LIST.Next, kLABEL_USE_LIST, "Next") && yyResult;
break;
case kCONST_EXP:
yyResult = yyCheckChild (yyt, yyt->CONST_EXP.C, kCONSTANT, "C") && yyResult;
break;
case kOP_EXP:
yyResult = yyCheckChild (yyt, yyt->OP_EXP.EXP_OP, kOP, "EXP_OP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->OP_EXP.OPND1, kBT_EXP, "OPND1") && yyResult;
yyResult = yyCheckChild (yyt, yyt->OP_EXP.OPND2, kBT_EXP, "OPND2") && yyResult;
break;
case kOP1_EXP:
yyResult = yyCheckChild (yyt, yyt->OP1_EXP.EXP_OP1, kOP, "EXP_OP1") && yyResult;
yyResult = yyCheckChild (yyt, yyt->OP1_EXP.OPND, kBT_EXP, "OPND") && yyResult;
break;
case kSLICE_EXP:
yyResult = yyCheckChild (yyt, yyt->SLICE_EXP.START, kBT_EXP, "START") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SLICE_EXP.STOP, kBT_EXP, "STOP") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SLICE_EXP.INC, kBT_EXP, "INC") && yyResult;
break;
case kVAR_EXP:
yyResult = yyCheckChild (yyt, yyt->VAR_EXP.V, kBT_VAR, "V") && yyResult;
break;
case kFUNC_CALL_EXP:
yyResult = yyCheckChild (yyt, yyt->FUNC_CALL_EXP.FUNC_ID, kPROC_OBJ, "FUNC_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->FUNC_CALL_EXP.FUNC_PARAMS, kBT_PARAM_LIST, "FUNC_PARAMS") && yyResult;
break;
case kNAMED_EXP:
yyResult = yyCheckChild (yyt, yyt->NAMED_EXP.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kDO_EXP:
yyResult = yyCheckChild (yyt, yyt->DO_EXP.DO_ID, kBT_VAR, "DO_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_EXP.RANGE, kSLICE_EXP, "RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_EXP.BODY, kBT_EXP_LIST, "BODY") && yyResult;
break;
case kTYPE_EXP:
yyResult = yyCheckChild (yyt, yyt->TYPE_EXP.ID, kTYPE_OBJ, "ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->TYPE_EXP.ELEMENTS, kBT_EXP_LIST, "ELEMENTS") && yyResult;
break;
case kARRAY_EXP:
yyResult = yyCheckChild (yyt, yyt->ARRAY_EXP.ELEMENTS, kBT_EXP_LIST, "ELEMENTS") && yyResult;
break;
case kPERM_EXP:
yyResult = yyCheckChild (yyt, yyt->PERM_EXP.VAL, kBT_EXP, "VAL") && yyResult;
break;
case kBOUND_EXP:
yyResult = yyCheckChild (yyt, yyt->BOUND_EXP.VAR, kBT_VAR, "VAR") && yyResult;
break;
case kBTE_LIST:
yyResult = yyCheckChild (yyt, yyt->BTE_LIST.Elem, kBT_EXP, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BTE_LIST.Next, kBT_EXP_LIST, "Next") && yyResult;
break;
case kUSED_VAR:
yyResult = yyCheckChild (yyt, yyt->USED_VAR.VARNAME, kVAR_OBJ, "VARNAME") && yyResult;
break;
case kINDEXED_VAR:
yyResult = yyCheckChild (yyt, yyt->INDEXED_VAR.IND_VAR, kBT_VAR, "IND_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->INDEXED_VAR.IND_EXPS, kBT_EXP_LIST, "IND_EXPS") && yyResult;
break;
case kSUBSTRING_VAR:
yyResult = yyCheckChild (yyt, yyt->SUBSTRING_VAR.IND_VAR, kBT_VAR, "IND_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SUBSTRING_VAR.IND_EXP, kBT_EXP, "IND_EXP") && yyResult;
break;
case kSELECTED_VAR:
yyResult = yyCheckChild (yyt, yyt->SELECTED_VAR.SELEC_VAR, kBT_VAR, "SELEC_VAR") && yyResult;
yyResult = yyCheckChild (yyt, yyt->SELECTED_VAR.SELECTOR, kREC_COMP, "SELECTOR") && yyResult;
break;
case kLOOP_VAR:
yyResult = yyCheckChild (yyt, yyt->LOOP_VAR.LOOP_VARNAME, kVAR_OBJ, "LOOP_VARNAME") && yyResult;
break;
case kPERM_VAR:
yyResult = yyCheckChild (yyt, yyt->PERM_VAR.VAL, kBT_VAR, "VAL") && yyResult;
break;
case kADDR:
yyResult = yyCheckChild (yyt, yyt->ADDR.E, kBT_EXP, "E") && yyResult;
break;
case kDO_VAR:
yyResult = yyCheckChild (yyt, yyt->DO_VAR.DO_ID, kBT_VAR, "DO_ID") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_VAR.RANGE, kSLICE_EXP, "RANGE") && yyResult;
yyResult = yyCheckChild (yyt, yyt->DO_VAR.BODY, kBT_VAR_LIST, "BODY") && yyResult;
break;
case kREMOTE_VAR:
yyResult = yyCheckChild (yyt, yyt->REMOTE_VAR.VAR, kBT_VAR, "VAR") && yyResult;
break;
case kBTV_LIST:
yyResult = yyCheckChild (yyt, yyt->BTV_LIST.Elem, kBT_VAR, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BTV_LIST.Next, kBT_VAR_LIST, "Next") && yyResult;
break;
case kVAR_PARAM:
yyResult = yyCheckChild (yyt, yyt->VAR_PARAM.V, kBT_VAR, "V") && yyResult;
break;
case kVALUE_PARAM:
yyResult = yyCheckChild (yyt, yyt->VALUE_PARAM.E, kBT_EXP, "E") && yyResult;
break;
case kNAMED_PARAM:
yyResult = yyCheckChild (yyt, yyt->NAMED_PARAM.VAL, kBT_PARAM, "VAL") && yyResult;
break;
case kPROC_PARAM:
yyResult = yyCheckChild (yyt, yyt->PROC_PARAM.P, kPROC_OBJ, "P") && yyResult;
break;
case kFUNC_PARAM:
yyResult = yyCheckChild (yyt, yyt->FUNC_PARAM.F, kPROC_OBJ, "F") && yyResult;
break;
case kBTP_LIST:
yyResult = yyCheckChild (yyt, yyt->BTP_LIST.Elem, kBT_PARAM, "Elem") && yyResult;
yyResult = yyCheckChild (yyt, yyt->BTP_LIST.Next, kBT_PARAM_LIST, "Next") && yyResult;
break;
 default: ;
 }
 return yyResult;
}

void InitTree
# if defined __STDC__ | defined __cplusplus
 (register tTree yyt)
# else
 (yyt) register tTree yyt;
# endif
{
 register tTree yyr;
 for (;;) {
  yyt->yyHead.yyIsComp0 = 0;
  yyt->yyHead.yyIsDone0 = 0;
  switch (yyt->Kind) {
case kCOMP_UNIT:
yyr = yyt->COMP_UNIT.COMP_ELEMENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->COMP_UNIT.USED_ELEMENTS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMP_UNIT.USED_ELEMENTS; break;
case kUNIT_LIST:
yyr = yyt->UNIT_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->UNIT_LIST.Next; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->UNIT_LIST.Next; break;
case kMODULE_DECL:
yyr = yyt->MODULE_DECL.MODULE_BODY; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->MODULE_DECL.MODULE_BODY; break;
case kPROGRAM_DECL:
yyr = yyt->PROGRAM_DECL.FORMALS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PROGRAM_DECL.PROGRAM_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROGRAM_DECL.PROGRAM_BODY; break;
case kPROC_DECL:
yyr = yyt->PROC_DECL.FORMALS; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PROC_DECL.PROC_BODY; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROC_DECL.PROC_BODY; break;
case kFUNC_DECL:
yyr = yyt->FUNC_DECL.FORMALS; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_DECL.FUNC_BODY; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_DECL.RESULT_TYPE; yyr->yyHead.yyOffset = 7; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_DECL.RESULT_TYPE; break;
case kBLOCK_DATA_DECL:
yyr = yyt->BLOCK_DATA_DECL.DATA_BODY; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BLOCK_DATA_DECL.DATA_BODY; break;
case kINTERFACE:
yyr = yyt->INTERFACE.SPEC; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INTERFACE.ITEMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->INTERFACE.ITEMS; break;
case kBODY_NODE:
yyr = yyt->BODY_NODE.DECLS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BODY_NODE.STATS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BODY_NODE.INTERNALS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->BODY_NODE.INTERNALS; break;
case kINTEGER_TYPE:
yyr = yyt->INTEGER_TYPE.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->INTEGER_TYPE.SIZE; break;
case kREAL_TYPE:
yyr = yyt->REAL_TYPE.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->REAL_TYPE.SIZE; break;
case kBOOLEAN_TYPE:
yyr = yyt->BOOLEAN_TYPE.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->BOOLEAN_TYPE.SIZE; break;
case kCOMPLEX_TYPE:
yyr = yyt->COMPLEX_TYPE.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMPLEX_TYPE.SIZE; break;
case kSTRING_TYPE:
yyr = yyt->STRING_TYPE.LENGTH; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->STRING_TYPE.LENGTH; break;
case kTYPE_ID:
yyr = yyt->TYPE_ID.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_ID.ID; break;
case kARRAY_TYPE:
yyr = yyt->ARRAY_TYPE.ARRAY_INDEX_TYPES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ARRAY_TYPE.ARRAY_COMP_TYPE; break;
case kRECORD_TYPE:
yyr = yyt->RECORD_TYPE.COMPONENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->RECORD_TYPE.COMPONENTS; break;
case kPOINTER_TYPE:
yyr = yyt->POINTER_TYPE.PTR_COMP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->POINTER_TYPE.PTR_COMP; break;
case kSHAPE_SPEC:
return;
case kEXPLICIT_SHAPE:
yyr = yyt->EXPLICIT_SHAPE.LOWER; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->EXPLICIT_SHAPE.UPPER; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->EXPLICIT_SHAPE.UPPER; break;
case kASSUMED_SHAPE:
yyr = yyt->ASSUMED_SHAPE.LOWER; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASSUMED_SHAPE.LOWER; break;
case kDEFERRED_SHAPE:
return;
case kASSUMED_SIZE:
yyr = yyt->ASSUMED_SIZE.LOWER; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASSUMED_SIZE.LOWER; break;
case kSHAPE_LIST:
yyr = yyt->SHAPE_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SHAPE_LIST.Next; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->SHAPE_LIST.Next; break;
case kTYPE_DECL:
yyr = yyt->TYPE_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_DECL.VAL; break;
case kENTITY_DECL:
yyr = yyt->ENTITY_DECL.ATTRIBUTES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ENTITY_DECL.ATTRIBUTES; break;
case kVAR_DECL:
yyr = yyt->VAR_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_DECL.VAL; break;
case kCOMMON_DECL:
yyr = yyt->COMMON_DECL.IDS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMMON_DECL.IDS; break;
case kNAMELIST_DECL:
yyr = yyt->NAMELIST_DECL.IDS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NAMELIST_DECL.IDS; break;
case kTEMPLATE_DECL:
yyr = yyt->TEMPLATE_DECL.DIMENSIONS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TEMPLATE_DECL.DIMENSIONS; break;
case kRAGGED_DECL:
yyr = yyt->RAGGED_DECL.DIMENSIONS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->RAGGED_DECL.DIMENSIONS; break;
case kPROCESSORS_DECL:
yyr = yyt->PROCESSORS_DECL.DIMENSIONS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROCESSORS_DECL.DIMENSIONS; break;
case kSUB_PROCS_DECL:
yyr = yyt->SUB_PROCS_DECL.TOP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SUB_PROCS_DECL.DIMENSIONS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->SUB_PROCS_DECL.DIMENSIONS; break;
case kRANGE_DECL:
yyr = yyt->RANGE_DECL.RANGES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->RANGE_DECL.RANGES; break;
case kSTMT_FUNC_DECL:
yyr = yyt->STMT_FUNC_DECL.FORMALS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->STMT_FUNC_DECL.RESULT_TYPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->STMT_FUNC_DECL.FFUNC_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->STMT_FUNC_DECL.FFUNC_BODY; break;
case kINTERFACE_DECL:
yyr = yyt->INTERFACE_DECL.SPEC; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INTERFACE_DECL.ITEMS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->INTERFACE_DECL.ITEMS; break;
case kVAR_PARAM_DECL:
yyr = yyt->VAR_PARAM_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_PARAM_DECL.VAL; break;
case kIMPLICIT_DECL:
yyr = yyt->IMPLICIT_DECL.TYPE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->IMPLICIT_DECL.TYPE; break;
case kUSE_DECL:
yyr = yyt->USE_DECL.RENAMINGS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->USE_DECL.RENAMINGS; break;
case kONLY_USE_DECL:
yyr = yyt->ONLY_USE_DECL.NAMES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ONLY_USE_DECL.NAMES; break;
case kEQV_DECL:
yyr = yyt->EQV_DECL.VARS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->EQV_DECL.VARS; break;
case kDATA_DECL:
yyr = yyt->DATA_DECL.VARS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DATA_DECL.VALS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DATA_DECL.VALS; break;
case kFORMAT_DECL:
yyr = yyt->FORMAT_DECL.FORMAT_PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->FORMAT_DECL.FORMAT_PARAMS; break;
case kDIMENSION_DECL:
yyr = yyt->DIMENSION_DECL.INDEXES; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->DIMENSION_DECL.INDEXES; break;
case kINIT_DATA_DECL:
yyr = yyt->INIT_DATA_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->INIT_DATA_DECL.VAL; break;
case kTYPESPEC_DECL:
yyr = yyt->TYPESPEC_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPESPEC_DECL.VAL; break;
case kPARAMETER_DECL:
yyr = yyt->PARAMETER_DECL.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PARAMETER_DECL.VAL; break;
case kDISTRIBUTE_DECL:
yyr = yyt->DISTRIBUTE_DECL.DISTRIBUTION; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DISTRIBUTE_DECL.TARGET; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DISTRIBUTE_DECL.TARGET; break;
case kALIGN_DECL:
yyr = yyt->ALIGN_DECL.ALIGN_SOURCE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ALIGN_DECL.ALIGN_TARGET; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ALIGN_DECL.ALIGN_TARGET; break;
case kMAP_DECL:
yyr = yyt->MAP_DECL.MAP_TARGET; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->MAP_DECL.MAP_TARGET; break;
case kOVERLAP_DECL:
yyr = yyt->OVERLAP_DECL.OVERLAPS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->OVERLAP_DECL.OVERLAPS; break;
case kSELECT_DECL:
yyr = yyt->SELECT_DECL.SELECTIONS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECT_DECL.SELECTIONS; break;
case kDECL_LIST:
yyr = yyt->DECL_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DECL_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DECL_LIST.Next; break;
case kRANGE_LIST:
yyr = yyt->RANGE_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->RANGE_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->RANGE_LIST.Next; break;
case kSELECT_LIST:
yyr = yyt->SELECT_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECT_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECT_LIST.Next; break;
case kNODE_DISTRIBUTION:
yyr = yyt->NODE_DISTRIBUTION.MAPPING; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NODE_DISTRIBUTION.MAPPING; break;
case kDIST_LIST:
yyr = yyt->DIST_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DIST_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DIST_LIST.Next; break;
case kBLOCK_DISTRIBUTION:
yyr = yyt->BLOCK_DISTRIBUTION.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->BLOCK_DISTRIBUTION.SIZE; break;
case kCYCLIC_DISTRIBUTION:
yyr = yyt->CYCLIC_DISTRIBUTION.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->CYCLIC_DISTRIBUTION.SIZE; break;
case kGEN_BLOCK_DISTRIBUTION:
yyr = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->GEN_BLOCK_DISTRIBUTION.ARRAY; break;
case kINDIRECT_DISTRIBUTION:
yyr = yyt->INDIRECT_DISTRIBUTION.ARRAY; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->INDIRECT_DISTRIBUTION.ARRAY; break;
case kARBITRARY_DISTRIBUTION:
yyr = yyt->ARBITRARY_DISTRIBUTION.SIZE; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ARBITRARY_DISTRIBUTION.LENGTH; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ARBITRARY_DISTRIBUTION.MAP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ARBITRARY_DISTRIBUTION.MAP; break;
case kPROCESSOR_ARRAY:
yyr = yyt->PROCESSOR_ARRAY.TOPNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROCESSOR_ARRAY.TOPNAME; break;
case kPROCESSOR_SUBSET:
yyr = yyt->PROCESSOR_SUBSET.SUBTOP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PROCESSOR_SUBSET.FULLTOP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROCESSOR_SUBSET.SUBSCRIPTS; break;
case kALIGN_SPEC:
yyr = yyt->ALIGN_SPEC.TEMPNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ALIGN_SPEC.SUBSCRIPTS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ALIGN_SPEC.SUBSCRIPTS; break;
case kOP_GENERIC_SPEC:
yyr = yyt->OP_GENERIC_SPEC.OPERATOR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->OP_GENERIC_SPEC.OPERATOR; break;
case kACF_LIST:
yyr = yyt->ACF_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_LIST.Next; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_LIST.Next; break;
case kACF_BASIC:
yyr = yyt->ACF_BASIC.BASIC_STMT; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_BASIC.BASIC_STMT; break;
case kACF_IF:
yyr = yyt->ACF_IF.IF_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_IF.THEN_PART; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_IF.ELSE_PART; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_IF.ELSE_PART; break;
case kACF_WHERE:
yyr = yyt->ACF_WHERE.WHERE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WHERE.TRUE_PART; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WHERE.FALSE_PART; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_WHERE.FALSE_PART; break;
case kACF_CASE:
yyr = yyt->ACF_CASE.CASE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_CASE.CASE_ALTS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_CASE.CASE_ALTS; break;
case kACF_WHILE:
yyr = yyt->ACF_WHILE.WHILE_EXP; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_WHILE.WHILE_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_WHILE.WHILE_BODY; break;
case kACF_REPEAT:
yyr = yyt->ACF_REPEAT.REPEAT_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_REPEAT.REPEAT_EXP; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_REPEAT.REPEAT_EXP; break;
case kACF_LOOP:
yyr = yyt->ACF_LOOP.LOOP_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_LOOP.LOOP_BODY; break;
case kACF_DO:
yyr = yyt->ACF_DO.DO_ID; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DO.DO_RANGE; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DO.DO_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DO.DO_DEP_INFO; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_DO.DO_HOME_INFO; yyr->yyHead.yyOffset = 7; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_DO.DO_HOME_INFO; break;
case kACF_FORALL:
yyr = yyt->ACF_FORALL.FORALL_ID; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_FORALL.FORALL_RANGE; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_FORALL.FORALL_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_FORALL.FORALL_DEP_INFO; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_FORALL.FORALL_HOME_INFO; yyr->yyHead.yyOffset = 7; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_FORALL.FORALL_HOME_INFO; break;
case kACF_FLOW_GRAPH:
yyr = yyt->ACF_FLOW_GRAPH.FLOW_NODES; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_FLOW_GRAPH.FLOW_NODES; break;
case kACF_ENTRY:
yyr = yyt->ACF_ENTRY.ENTRY_DECL; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_ENTRY.ENTRY_DECL; break;
case kACF_HOME:
yyr = yyt->ACF_HOME.HOME_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_HOME.HOME_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_HOME.HOME_BODY; break;
case kACF_RESIDENT:
yyr = yyt->ACF_RESIDENT.RESIDENT_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_RESIDENT.RESIDENT_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_RESIDENT.RESIDENT_BODY; break;
case kACF_NEW:
yyr = yyt->ACF_NEW.NEW_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_NEW.NEW_BODY; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_NEW.NEW_BODY; break;
case kACF_REDUCTION:
yyr = yyt->ACF_REDUCTION.REDUCTION_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_REDUCTION.REDUCTION_LVAR; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_REDUCTION.REDUCTION_FUNC; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_REDUCTION.REDUCTION_BODY; yyr->yyHead.yyOffset = 7; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_REDUCTION.REDUCTION_BODY; break;
case kACF_TASK_REGION:
yyr = yyt->ACF_TASK_REGION.TASK_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_TASK_REGION.TASK_BODY; break;
case kACF_PARALLEL:
yyr = yyt->ACF_PARALLEL.REDUCTION_VARS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_PARALLEL.SHARED_VARS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_PARALLEL.LOCAL_VARS; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_PARALLEL.PARALLEL_BODY; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_PARALLEL.PARALLEL_BODY; break;
case kACF_CRITICAL:
yyr = yyt->ACF_CRITICAL.CRITICAL_BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_CRITICAL.CRITICAL_BODY; break;
case kACF_ON:
yyr = yyt->ACF_ON.ON_HOME; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_ON.ON_SPECS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_ON.ON_BODY; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_ON.ON_BODY; break;
case kACF_RM_READ:
yyr = yyt->ACF_RM_READ.LOCAL_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_RM_READ.REMOTE_VAR; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_RM_READ.REMOTE_VAR; break;
case kACF_RM_WRITE:
yyr = yyt->ACF_RM_WRITE.REMOTE_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ACF_RM_WRITE.LOCAL_DATA; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_RM_WRITE.LOCAL_DATA; break;
case kACF_MOVE:
yyr = yyt->ACF_MOVE.MOVE_STMT; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_MOVE.MOVE_STMT; break;
case kACF_BARRIER:
yyr = yyt->ACF_BARRIER.BARRIER_VARS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_BARRIER.BARRIER_VARS; break;
case kACF_UPDATE:
yyr = yyt->ACF_UPDATE.OVERLAP_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->ACF_UPDATE.OVERLAP_VAR; break;
case kON_VAR_CLAUSE:
yyr = yyt->ON_VAR_CLAUSE.ON_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ON_VAR_CLAUSE.ON_VAR; break;
case kON_PROC_CLAUSE:
yyr = yyt->ON_PROC_CLAUSE.ON_PROC; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ON_PROC_CLAUSE.ON_PROC; break;
case kON_LIST:
yyr = yyt->ON_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ON_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ON_LIST.Next; break;
case kON_SPEC:
yyr = yyt->ON_SPEC.ON_VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ON_SPEC.ON_VAL; break;
case kSELECTED_ACF_LIST:
yyr = yyt->SELECTED_ACF_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_ACF_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_ACF_LIST.Next; break;
case kSELECTED_ACF_NODE:
yyr = yyt->SELECTED_ACF_NODE.SELECT_LIST; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_ACF_NODE.SELECT_ACFS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_ACF_NODE.SELECT_ACFS; break;
case kASSIGN_STMT:
yyr = yyt->ASSIGN_STMT.ASSIGN_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ASSIGN_STMT.ASSIGN_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASSIGN_STMT.ASSIGN_EXP; break;
case kPTR_ASSIGN_STMT:
yyr = yyt->PTR_ASSIGN_STMT.ASSIGN_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->PTR_ASSIGN_STMT.ASSIGN_EXP; break;
case kLABEL_ASSIGN_STMT:
yyr = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->LABEL_ASSIGN_STMT.LABEL_VAR; break;
case kCALL_STMT:
yyr = yyt->CALL_STMT.CALL_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->CALL_STMT.CALL_PARAMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->CALL_STMT.CALL_PARAMS; break;
case kIO_STMT:
yyr = yyt->IO_STMT.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IO_STMT.IO_SPECS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IO_STMT.IO_ITEMS; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->IO_STMT.IO_ITEMS; break;
case kASS_GOTO_STMT:
yyr = yyt->ASS_GOTO_STMT.GOTO_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ASS_GOTO_STMT.LABELS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ASS_GOTO_STMT.LABELS; break;
case kCOMP_GOTO_STMT:
yyr = yyt->COMP_GOTO_STMT.GOTO_LABELS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->COMP_GOTO_STMT.GOTO_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMP_GOTO_STMT.GOTO_EXP; break;
case kCOMP_IF_STMT:
yyr = yyt->COMP_IF_STMT.IF_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->COMP_IF_STMT.IF_EXP; break;
case kRETURN_STMT:
yyr = yyt->RETURN_STMT.RETURN_EXP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->RETURN_STMT.RETURN_EXP; break;
case kPAUSE_STMT:
yyr = yyt->PAUSE_STMT.PAUSE_CONST; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PAUSE_STMT.PAUSE_CONST; break;
case kSTOP_STMT:
yyr = yyt->STOP_STMT.STOP_CONST; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->STOP_STMT.STOP_CONST; break;
case kFORMAT_STMT:
yyr = yyt->FORMAT_STMT.FORMAT_PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->FORMAT_STMT.FORMAT_PARAMS; break;
case kINHERIT_DSP_STMT:
yyr = yyt->INHERIT_DSP_STMT.VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INHERIT_DSP_STMT.SHAPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->INHERIT_DSP_STMT.SHAPE; break;
case kCREATE_DSP_STMT:
yyr = yyt->CREATE_DSP_STMT.VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->CREATE_DSP_STMT.SHAPE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->CREATE_DSP_STMT.SHAPE; break;
case kFREE_DSP_STMT:
yyr = yyt->FREE_DSP_STMT.VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->FREE_DSP_STMT.VAR; break;
case kALLOCATE_STMT:
yyr = yyt->ALLOCATE_STMT.PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->ALLOCATE_STMT.STATUS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->ALLOCATE_STMT.STATUS; break;
case kDEALLOCATE_STMT:
yyr = yyt->DEALLOCATE_STMT.PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DEALLOCATE_STMT.STATUS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->DEALLOCATE_STMT.STATUS; break;
case kNULLIFY_STMT:
yyr = yyt->NULLIFY_STMT.PARAMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NULLIFY_STMT.PARAMS; break;
case kREDUCE_STMT:
yyr = yyt->REDUCE_STMT.RED_FUNC; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDUCE_STMT.RED_PARAMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->REDUCE_STMT.RED_PARAMS; break;
case kMOVE_STMT:
yyr = yyt->MOVE_STMT.TARGET; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->MOVE_STMT.SOURCE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->MOVE_STMT.MASK; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->MOVE_STMT.MASK; break;
case kSCATTER_STMT:
yyr = yyt->SCATTER_STMT.ARRAY; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SCATTER_STMT.BASE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SCATTER_STMT.INDEXES; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SCATTER_STMT.MASK; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->SCATTER_STMT.MASK; break;
case kREALIGN_STMT:
yyr = yyt->REALIGN_STMT.ALIGNEE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REALIGN_STMT.ALIGN_SOURCE; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REALIGN_STMT.ALIGN_TARGET; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->REALIGN_STMT.ALIGN_TARGET; break;
case kREDISTRIBUTE_STMT:
yyr = yyt->REDISTRIBUTE_STMT.DISTRIBUTEE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDISTRIBUTE_STMT.DISTRIBUTION; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDISTRIBUTE_STMT.TARGET; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->REDISTRIBUTE_STMT.TARGET; break;
case kREG_SHADOW_GET:
yyr = yyt->REG_SHADOW_GET.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REG_SHADOW_GET.SHADOW_SIZE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->REG_SHADOW_GET.SHADOW_SIZE; break;
case kREG_SHADOW_PUT:
yyr = yyt->REG_SHADOW_PUT.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REG_SHADOW_PUT.SHADOW_SIZE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->REG_SHADOW_PUT.SHADOW_SIZE; break;
case kREG_SHADOW_SET:
yyr = yyt->REG_SHADOW_SET.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REG_SHADOW_SET.SHADOW_SIZE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REG_SHADOW_SET.VAL; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->REG_SHADOW_SET.VAL; break;
case kIND_SHADOW_CREATE:
yyr = yyt->IND_SHADOW_CREATE.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IND_SHADOW_CREATE.INDEX_VAR; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IND_SHADOW_CREATE.TMP_INDEX_VAR; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IND_SHADOW_CREATE.MASK; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
yyt = yyt->IND_SHADOW_CREATE.MASK; break;
case kIND_SHADOW_FREE:
yyr = yyt->IND_SHADOW_FREE.INDEX_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->IND_SHADOW_FREE.INDEX_VAR; break;
case kIND_SHADOW_GET:
yyr = yyt->IND_SHADOW_GET.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->IND_SHADOW_GET.SHADOW_VAR; break;
case kIND_SHADOW_PUT:
yyr = yyt->IND_SHADOW_PUT.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->IND_SHADOW_PUT.SHADOW_VAR; break;
case kIND_SHADOW_SET:
yyr = yyt->IND_SHADOW_SET.SHADOW_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->IND_SHADOW_SET.VAL; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->IND_SHADOW_SET.VAL; break;
case kBROADCAST_STMT:
yyr = yyt->BROADCAST_STMT.ELEMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BROADCAST_STMT.OWNER_TOP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BROADCAST_STMT.OWNER_SPEC; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->BROADCAST_STMT.OWNER_SPEC; break;
case kREDUCTION_STMT:
yyr = yyt->REDUCTION_STMT.REDFUNC; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDUCTION_STMT.ELEMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDUCTION_STMT.RED_TOP; yyr->yyHead.yyOffset = 4; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->REDUCTION_STMT.RED_SPEC; yyr->yyHead.yyOffset = 5; yyr->yyHead.yyParent = yyt;
yyt = yyt->REDUCTION_STMT.RED_SPEC; break;
case kDIRTY_STMT:
yyr = yyt->DIRTY_STMT.ELEMS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->DIRTY_STMT.ELEMS; break;
case kLABEL_LIST:
yyr = yyt->LABEL_LIST.Next; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->LABEL_LIST.Next; break;
case kCONST_EXP:
yyr = yyt->CONST_EXP.C; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->CONST_EXP.C; break;
case kOP_EXP:
yyr = yyt->OP_EXP.EXP_OP; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->OP_EXP.OPND1; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->OP_EXP.OPND2; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->OP_EXP.OPND2; break;
case kOP1_EXP:
yyr = yyt->OP1_EXP.EXP_OP1; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->OP1_EXP.OPND; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->OP1_EXP.OPND; break;
case kSLICE_EXP:
yyr = yyt->SLICE_EXP.START; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SLICE_EXP.STOP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SLICE_EXP.INC; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->SLICE_EXP.INC; break;
case kVAR_EXP:
yyr = yyt->VAR_EXP.V; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_EXP.V; break;
case kFUNC_CALL_EXP:
yyr = yyt->FUNC_CALL_EXP.FUNC_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->FUNC_CALL_EXP.FUNC_PARAMS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_CALL_EXP.FUNC_PARAMS; break;
case kNAMED_EXP:
yyr = yyt->NAMED_EXP.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NAMED_EXP.VAL; break;
case kDO_EXP:
yyr = yyt->DO_EXP.DO_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_EXP.RANGE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_EXP.BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->DO_EXP.BODY; break;
case kTYPE_EXP:
yyr = yyt->TYPE_EXP.ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->TYPE_EXP.ELEMENTS; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->TYPE_EXP.ELEMENTS; break;
case kARRAY_EXP:
yyr = yyt->ARRAY_EXP.ELEMENTS; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ARRAY_EXP.ELEMENTS; break;
case kPERM_EXP:
yyr = yyt->PERM_EXP.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PERM_EXP.VAL; break;
case kBOUND_EXP:
yyr = yyt->BOUND_EXP.VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->BOUND_EXP.VAR; break;
case kBTE_LIST:
yyr = yyt->BTE_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BTE_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BTE_LIST.Next; break;
case kUSED_VAR:
yyr = yyt->USED_VAR.VARNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->USED_VAR.VARNAME; break;
case kINDEXED_VAR:
yyr = yyt->INDEXED_VAR.IND_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->INDEXED_VAR.IND_EXPS; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->INDEXED_VAR.IND_EXPS; break;
case kSUBSTRING_VAR:
yyr = yyt->SUBSTRING_VAR.IND_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SUBSTRING_VAR.IND_EXP; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SUBSTRING_VAR.IND_EXP; break;
case kSELECTED_VAR:
yyr = yyt->SELECTED_VAR.SELEC_VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->SELECTED_VAR.SELECTOR; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->SELECTED_VAR.SELECTOR; break;
case kLOOP_VAR:
yyr = yyt->LOOP_VAR.LOOP_VARNAME; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->LOOP_VAR.LOOP_VARNAME; break;
case kPERM_VAR:
yyr = yyt->PERM_VAR.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PERM_VAR.VAL; break;
case kADDR:
yyr = yyt->ADDR.E; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->ADDR.E; break;
case kDO_VAR:
yyr = yyt->DO_VAR.DO_ID; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_VAR.RANGE; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->DO_VAR.BODY; yyr->yyHead.yyOffset = 3; yyr->yyHead.yyParent = yyt;
yyt = yyt->DO_VAR.BODY; break;
case kREMOTE_VAR:
yyr = yyt->REMOTE_VAR.VAR; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->REMOTE_VAR.VAR; break;
case kBTV_LIST:
yyr = yyt->BTV_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BTV_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BTV_LIST.Next; break;
case kVAR_PARAM:
yyr = yyt->VAR_PARAM.V; yyr->yyHead.yyOffset = 6; yyr->yyHead.yyParent = yyt;
yyt = yyt->VAR_PARAM.V; break;
case kVALUE_PARAM:
yyr = yyt->VALUE_PARAM.E; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->VALUE_PARAM.E; break;
case kNAMED_PARAM:
yyr = yyt->NAMED_PARAM.VAL; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->NAMED_PARAM.VAL; break;
case kPROC_PARAM:
yyr = yyt->PROC_PARAM.P; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->PROC_PARAM.P; break;
case kFUNC_PARAM:
yyr = yyt->FUNC_PARAM.F; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
yyt = yyt->FUNC_PARAM.F; break;
case kBTP_LIST:
yyr = yyt->BTP_LIST.Elem; yyr->yyHead.yyOffset = 1; yyr->yyHead.yyParent = yyt;
InitTree (yyr);
yyr = yyt->BTP_LIST.Next; yyr->yyHead.yyOffset = 2; yyr->yyHead.yyParent = yyt;
yyt = yyt->BTP_LIST.Next; break;
  default: return;
  }
 }
}

void BeginTree ()
{
}

void CloseTree ()
{
}
