# include "Traverse.h"
# include "yyTraverse.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 43 "Traverse.puma"


# include <stdio.h>
# include "protocol.h"
# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"

# include "ArrayData.h"     /* SetActualOverlap */

# include "Transform.h"     /* ReplaceACF, ReplaceDECL */
# include "Nesting.h"

# define MODULE "Traverse"



static void yyExit () { Exit (1); }

void (* Traverse_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Traverse, routine %s failed\n", yyFunction);
 Traverse_Exit ();
}

static bool IsUnitDecl ARGS((tTree t));
void FullTraverseAST ARGS((tTree t, UserSubroutine visit));
static bool FalsePredicate ARGS((tTree t));
void TraverseAST ARGS((tTree t, UserPredicate pred, UserSubroutine visit));
tTree ReplaceAST ARGS((tTree t, UserPredicate pred, UserFunction visit));
static void SetStatement ARGS((tTree t));

static bool IsUnitDecl
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_DECL) {
# line 68 "Traverse.puma"
   return true;

  }
  if (t->Kind == kPROC_DECL) {
# line 69 "Traverse.puma"
   return true;

  }
  if (t->Kind == kMODULE_DECL) {
# line 70 "Traverse.puma"
   return true;

  }
  if (t->Kind == kBLOCK_DATA_DECL) {
# line 71 "Traverse.puma"
   return true;

  }
  if (t->Kind == kPROGRAM_DECL) {
# line 72 "Traverse.puma"
   return true;

  }
  return false;
}

void FullTraverseAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, UserSubroutine visit)
# else
(t, visit)
 register tTree t;
 UserSubroutine visit;
# endif
{
# line 84 "Traverse.puma"
  {
# line 86 "Traverse.puma"
   TraverseAST (t, FalsePredicate, visit);
  }
   return;

;
}

static bool FalsePredicate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  return false;
}

void TraverseAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, UserPredicate pred, UserSubroutine visit)
# else
(t, pred, visit)
 register tTree t;
 UserPredicate pred;
 UserSubroutine visit;
# endif
{
# line 102 "Traverse.puma"
  {
# line 103 "Traverse.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

# line 106 "Traverse.puma"
  {
# line 108 "Traverse.puma"
 if (IsUnitDecl (t)) NestOpenUnit (t); 
# line 110 "Traverse.puma"
   visit (t);
# line 111 "Traverse.puma"
   goto yyL2;
  }
yyL2:;

# line 114 "Traverse.puma"
  {
# line 116 "Traverse.puma"
   if (! ((pred (t)))) goto yyL3;
  {
# line 118 "Traverse.puma"
 if (IsUnitDecl (t)) NestCloseUnit (t); 
  }
  }
   return;
yyL3:;


  switch (t->Kind) {
  case kCOMP_UNIT:
# line 127 "Traverse.puma"
  {
# line 129 "Traverse.puma"
   TraverseAST (t->COMP_UNIT.COMP_ELEMENTS, pred, visit);
  }
   return;

  case kUNIT_LIST:
# line 132 "Traverse.puma"
  {
# line 134 "Traverse.puma"
   TraverseAST (t->UNIT_LIST.Elem, pred, visit);
# line 135 "Traverse.puma"
   TraverseAST (t->UNIT_LIST.Next, pred, visit);
  }
   return;

  case kUNIT_EMPTY:
# line 138 "Traverse.puma"
   return;

  case kPROGRAM_DECL:
# line 141 "Traverse.puma"
  {
# line 143 "Traverse.puma"
   TraverseAST (t->PROGRAM_DECL.PROGRAM_BODY, pred, visit);
# line 144 "Traverse.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 147 "Traverse.puma"
  {
# line 149 "Traverse.puma"
   TraverseAST (t->PROC_DECL.PROC_BODY, pred, visit);
# line 150 "Traverse.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 153 "Traverse.puma"
  {
# line 155 "Traverse.puma"
   TraverseAST (t->FUNC_DECL.FUNC_BODY, pred, visit);
# line 156 "Traverse.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 159 "Traverse.puma"
  {
# line 161 "Traverse.puma"
   TraverseAST (t->BLOCK_DATA_DECL.DATA_BODY, pred, visit);
# line 162 "Traverse.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 165 "Traverse.puma"
  {
# line 167 "Traverse.puma"
   TraverseAST (t->MODULE_DECL.MODULE_BODY, pred, visit);
# line 168 "Traverse.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_PROC_DECL:
# line 171 "Traverse.puma"
   return;

  case kBODY_NODE:
# line 180 "Traverse.puma"
  {
# line 182 "Traverse.puma"
   TraverseAST (t->BODY_NODE.DECLS, pred, visit);
# line 183 "Traverse.puma"
   TraverseAST (t->BODY_NODE.STATS, pred, visit);
# line 184 "Traverse.puma"
   TraverseAST (t->BODY_NODE.INTERNALS, pred, visit);
  }
   return;

  case kDECL_LIST:
# line 193 "Traverse.puma"
  {
# line 195 "Traverse.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 196 "Traverse.puma"
   TraverseAST (t->DECL_LIST.Elem, pred, visit);
# line 197 "Traverse.puma"
   TraverseAST (t->DECL_LIST.Next, pred, visit);
  }
   return;

  case kDECL_EMPTY:
# line 200 "Traverse.puma"
   return;

  case kVAR_DECL:
# line 203 "Traverse.puma"
  {
# line 205 "Traverse.puma"
   TraverseAST (t->VAR_DECL.VAL, pred, visit);
  }
   return;

  case kTYPE_DECL:
# line 208 "Traverse.puma"
  {
# line 210 "Traverse.puma"
   TraverseAST (t->TYPE_DECL.VAL, pred, visit);
  }
   return;

  case kINTERFACE_DECL:
# line 213 "Traverse.puma"
  {
# line 215 "Traverse.puma"
   TraverseAST (t->INTERFACE_DECL.ITEMS, pred, visit);
  }
   return;

  case kDECL_NODE:
  case kNAME_DECL:
  case kRENAME_DECL:
  case kENTITY_DECL:
  case kCOMMON_DECL:
  case kNAMELIST_DECL:
  case kTEMPLATE_DECL:
  case kRAGGED_DECL:
  case kPROCESSORS_DECL:
  case kSUB_PROCS_DECL:
  case kINHERIT_DECL:
  case kRANGE_DECL:
  case kSTMT_FUNC_DECL:
  case kVAR_PARAM_DECL:
  case kRET_PARAM_DECL:
  case kIMPLICIT_DECL:
  case kUSE_DECL:
  case kONLY_USE_DECL:
  case kEQV_DECL:
  case kDATA_DECL:
  case kFORMAT_DECL:
  case kDIMENSION_DECL:
  case kINIT_DATA_DECL:
  case kTYPESPEC_DECL:
  case kALLOCATABLE_DECL:
  case kEXTERNAL_DECL:
  case kINTENT_DECL:
  case kINTRINSIC_DECL:
  case kOPTIONAL_DECL:
  case kPOINTER_DECL:
  case kSAVE_DECL:
  case kTARGET_DECL:
  case kPARAMETER_DECL:
  case kPUBLIC_DECL:
  case kPRIVATE_DECL:
  case kSEQUENCE_DECL:
  case kDISTRIBUTE_DECL:
  case kALIGN_DECL:
  case kMAP_DECL:
  case kOVERLAP_DECL:
  case kSHARED_DECL:
  case kDYNAMIC_DECL:
  case kTRACE_DECL:
  case kTREE_DECL:
  case kSELECT_DECL:
  case kHPF_SEQUENCE_DECL:
  case kNOSEQUENCE_DECL:
  case kLAYOUT_DECL:
  case kPASS_BY_DECL:
  case kMAP_TO_DECL:
# line 218 "Traverse.puma"
   return;

  case kARRAY_TYPE:
# line 227 "Traverse.puma"
  {
# line 229 "Traverse.puma"
   TraverseAST (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, pred, visit);
# line 230 "Traverse.puma"
   TraverseAST (t->ARRAY_TYPE.ARRAY_COMP_TYPE, pred, visit);
  }
   return;

  case kSHAPE_LIST:
# line 239 "Traverse.puma"
  {
# line 241 "Traverse.puma"
   TraverseAST (t->SHAPE_LIST.Elem, pred, visit);
# line 242 "Traverse.puma"
   TraverseAST (t->SHAPE_LIST.Next, pred, visit);
  }
   return;

  case kSHAPE_EMPTY:
# line 245 "Traverse.puma"
   return;

  case kEXPLICIT_SHAPE:
# line 248 "Traverse.puma"
  {
# line 250 "Traverse.puma"
   TraverseAST (t->EXPLICIT_SHAPE.LOWER, pred, visit);
# line 251 "Traverse.puma"
   TraverseAST (t->EXPLICIT_SHAPE.UPPER, pred, visit);
  }
   return;

  case kSHAPE_SPEC:
  case kASSUMED_SHAPE:
  case kDEFERRED_SHAPE:
  case kASSUMED_SIZE:
# line 254 "Traverse.puma"
   return;

  case kRECORD_TYPE:
# line 257 "Traverse.puma"
  {
# line 259 "Traverse.puma"
   NestOpenType (t);
# line 260 "Traverse.puma"
   TraverseAST (t->RECORD_TYPE.COMPONENTS, pred, visit);
# line 261 "Traverse.puma"
   NestCloseType (t);
  }
   return;

  case kTYPE_NODE:
  case kDUMMY_TYPE:
  case kALIGN_TYPE:
  case kINTEGER_TYPE:
  case kREAL_TYPE:
  case kBOOLEAN_TYPE:
  case kCOMPLEX_TYPE:
  case kSTRING_TYPE:
  case kTYPE_ID:
  case kPOINTER_TYPE:
# line 264 "Traverse.puma"
   return;

  case kACF_LIST:
# line 273 "Traverse.puma"
  {
# line 275 "Traverse.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 276 "Traverse.puma"
   TraverseAST (t->ACF_LIST.Elem, pred, visit);
# line 277 "Traverse.puma"
   TraverseAST (t->ACF_LIST.Next, pred, visit);
  }
   return;

  case kACF_EMPTY:
# line 280 "Traverse.puma"
   return;

  case kACF_BASIC:
# line 283 "Traverse.puma"
  {
# line 285 "Traverse.puma"
   TraverseAST (t->ACF_BASIC.BASIC_STMT, pred, visit);
  }
   return;

  case kACF_DUMMY:
# line 288 "Traverse.puma"
   return;

  case kACF_WHILE:
# line 291 "Traverse.puma"
  {
# line 293 "Traverse.puma"
   TraverseAST (t->ACF_WHILE.WHILE_EXP, pred, visit);
# line 294 "Traverse.puma"
   TraverseAST (t->ACF_WHILE.WHILE_BODY, pred, visit);
  }
   return;

  case kACF_DO:
# line 297 "Traverse.puma"
  {
# line 299 "Traverse.puma"
   TraverseAST (t->ACF_DO.DO_ID, pred, visit);
# line 300 "Traverse.puma"
   TraverseAST (t->ACF_DO.DO_RANGE, pred, visit);
# line 301 "Traverse.puma"
   TraverseAST (t->ACF_DO.DO_BODY, pred, visit);
# line 302 "Traverse.puma"
   TraverseAST (t->ACF_DO.DO_DEP_INFO, pred, visit);
# line 303 "Traverse.puma"
   TraverseAST (t->ACF_DO.DO_HOME_INFO, pred, visit);
  }
   return;

  case kACF_FORALL:
# line 306 "Traverse.puma"
  {
# line 308 "Traverse.puma"
   TraverseAST (t->ACF_FORALL.FORALL_ID, pred, visit);
# line 309 "Traverse.puma"
   TraverseAST (t->ACF_FORALL.FORALL_RANGE, pred, visit);
# line 310 "Traverse.puma"
   TraverseAST (t->ACF_FORALL.FORALL_BODY, pred, visit);
# line 311 "Traverse.puma"
   TraverseAST (t->ACF_FORALL.FORALL_DEP_INFO, pred, visit);
# line 312 "Traverse.puma"
   TraverseAST (t->ACF_FORALL.FORALL_HOME_INFO, pred, visit);
  }
   return;

  case kACF_IF:
# line 315 "Traverse.puma"
  {
# line 317 "Traverse.puma"
   TraverseAST (t->ACF_IF.IF_EXP, pred, visit);
# line 318 "Traverse.puma"
   TraverseAST (t->ACF_IF.THEN_PART, pred, visit);
# line 319 "Traverse.puma"
   TraverseAST (t->ACF_IF.ELSE_PART, pred, visit);
  }
   return;

  case kACF_WHERE:
# line 322 "Traverse.puma"
  {
# line 324 "Traverse.puma"
   TraverseAST (t->ACF_WHERE.WHERE_EXP, pred, visit);
# line 325 "Traverse.puma"
   TraverseAST (t->ACF_WHERE.TRUE_PART, pred, visit);
# line 326 "Traverse.puma"
   TraverseAST (t->ACF_WHERE.FALSE_PART, pred, visit);
  }
   return;

  case kACF_HOME:
# line 329 "Traverse.puma"
  {
# line 331 "Traverse.puma"
   TraverseAST (t->ACF_HOME.HOME_VAR, pred, visit);
# line 332 "Traverse.puma"
   TraverseAST (t->ACF_HOME.HOME_BODY, pred, visit);
  }
   return;

  case kACF_RESIDENT:
# line 335 "Traverse.puma"
  {
# line 337 "Traverse.puma"
   TraverseAST (t->ACF_RESIDENT.RESIDENT_VAR, pred, visit);
# line 338 "Traverse.puma"
   TraverseAST (t->ACF_RESIDENT.RESIDENT_BODY, pred, visit);
  }
   return;

  case kACF_PARALLEL:
# line 341 "Traverse.puma"
  {
# line 343 "Traverse.puma"
   TraverseAST (t->ACF_PARALLEL.REDUCTION_VARS, pred, visit);
# line 344 "Traverse.puma"
   TraverseAST (t->ACF_PARALLEL.SHARED_VARS, pred, visit);
# line 345 "Traverse.puma"
   TraverseAST (t->ACF_PARALLEL.LOCAL_VARS, pred, visit);
# line 346 "Traverse.puma"
   TraverseAST (t->ACF_PARALLEL.PARALLEL_BODY, pred, visit);
  }
   return;

  case kACF_CRITICAL:
# line 349 "Traverse.puma"
  {
# line 351 "Traverse.puma"
   TraverseAST (t->ACF_CRITICAL.CRITICAL_BODY, pred, visit);
  }
   return;

  case kACF_NEW:
# line 354 "Traverse.puma"
  {
# line 357 "Traverse.puma"
   TraverseAST (t->ACF_NEW.NEW_BODY, pred, visit);
  }
   return;

  case kACF_REDUCTION:
# line 360 "Traverse.puma"
  {
# line 364 "Traverse.puma"
   TraverseAST (t->ACF_REDUCTION.REDUCTION_VAR, pred, visit);
# line 365 "Traverse.puma"
   TraverseAST (t->ACF_REDUCTION.REDUCTION_LVAR, pred, visit);
# line 366 "Traverse.puma"
   TraverseAST (t->ACF_REDUCTION.REDUCTION_BODY, pred, visit);
  }
   return;

  case kACF_BARRIER:
# line 369 "Traverse.puma"
   return;

  case kON_PROC_CLAUSE:
# line 372 "Traverse.puma"
  {
# line 374 "Traverse.puma"
   TraverseAST (t->ON_PROC_CLAUSE.ON_PROC, pred, visit);
  }
   return;

  case kON_VAR_CLAUSE:
# line 377 "Traverse.puma"
  {
# line 379 "Traverse.puma"
   TraverseAST (t->ON_VAR_CLAUSE.ON_VAR, pred, visit);
  }
   return;

  case kON_ALL_CLAUSE:
# line 382 "Traverse.puma"
   return;

  case kON_HOST_CLAUSE:
# line 385 "Traverse.puma"
   return;

  case kACF_ON:
# line 388 "Traverse.puma"
  {
# line 390 "Traverse.puma"
   TraverseAST (t->ACF_ON.ON_BODY, pred, visit);
  }
   return;

  case kACF_TASK_REGION:
# line 393 "Traverse.puma"
  {
# line 395 "Traverse.puma"
   TraverseAST (t->ACF_TASK_REGION.TASK_BODY, pred, visit);
  }
   return;

  case kACF_MOVE:
# line 398 "Traverse.puma"
  {
# line 400 "Traverse.puma"
   TraverseAST (t->ACF_MOVE.MOVE_STMT, pred, visit);
  }
   return;

  case kACF_CASE:
# line 403 "Traverse.puma"
  {
# line 405 "Traverse.puma"
   TraverseAST (t->ACF_CASE.CASE_EXP, pred, visit);
# line 406 "Traverse.puma"
   TraverseAST (t->ACF_CASE.CASE_ALTS, pred, visit);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 415 "Traverse.puma"
  {
# line 417 "Traverse.puma"
   TraverseAST (t->SELECTED_ACF_LIST.Elem, pred, visit);
# line 418 "Traverse.puma"
   TraverseAST (t->SELECTED_ACF_LIST.Next, pred, visit);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 421 "Traverse.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 424 "Traverse.puma"
  {
# line 426 "Traverse.puma"
   TraverseAST (t->SELECTED_ACF_NODE.SELECT_LIST, pred, visit);
# line 427 "Traverse.puma"
   TraverseAST (t->SELECTED_ACF_NODE.SELECT_ACFS, pred, visit);
  }
   return;

  case kASSIGN_STMT:
# line 436 "Traverse.puma"
  {
# line 438 "Traverse.puma"
   TraverseAST (t->ASSIGN_STMT.ASSIGN_VAR, pred, visit);
# line 439 "Traverse.puma"
   TraverseAST (t->ASSIGN_STMT.ASSIGN_EXP, pred, visit);
  }
   return;

  case kPTR_ASSIGN_STMT:
# line 442 "Traverse.puma"
  {
# line 444 "Traverse.puma"
   TraverseAST (t->PTR_ASSIGN_STMT.ASSIGN_VAR, pred, visit);
# line 445 "Traverse.puma"
   TraverseAST (t->PTR_ASSIGN_STMT.ASSIGN_EXP, pred, visit);
  }
   return;

  case kLABEL_ASSIGN_STMT:
# line 448 "Traverse.puma"
  {
# line 450 "Traverse.puma"
   TraverseAST (t->LABEL_ASSIGN_STMT.LABEL_VAR, pred, visit);
  }
   return;

  case kFORMAT_STMT:
# line 453 "Traverse.puma"
   return;

  case kCALL_STMT:
# line 456 "Traverse.puma"
  {
# line 458 "Traverse.puma"
   TraverseAST (t->CALL_STMT.CALL_PARAMS, pred, visit);
  }
   return;

  case kMOVE_STMT:
# line 461 "Traverse.puma"
  {
# line 463 "Traverse.puma"
   TraverseAST (t->MOVE_STMT.TARGET, pred, visit);
# line 464 "Traverse.puma"
   TraverseAST (t->MOVE_STMT.SOURCE, pred, visit);
# line 465 "Traverse.puma"
   TraverseAST (t->MOVE_STMT.MASK, pred, visit);
  }
   return;

  case kSCATTER_STMT:
# line 468 "Traverse.puma"
  {
# line 470 "Traverse.puma"
   TraverseAST (t->SCATTER_STMT.BASE, pred, visit);
# line 471 "Traverse.puma"
   TraverseAST (t->SCATTER_STMT.ARRAY, pred, visit);
# line 472 "Traverse.puma"
   TraverseAST (t->SCATTER_STMT.INDEXES, pred, visit);
# line 473 "Traverse.puma"
   TraverseAST (t->SCATTER_STMT.MASK, pred, visit);
  }
   return;

  case kREDUCTION_STMT:
# line 476 "Traverse.puma"
  {
# line 478 "Traverse.puma"
   TraverseAST (t->REDUCTION_STMT.ELEMS, pred, visit);
  }
   return;

  case kBROADCAST_STMT:
# line 481 "Traverse.puma"
  {
# line 483 "Traverse.puma"
   TraverseAST (t->BROADCAST_STMT.ELEMS, pred, visit);
  }
   return;

  case kGOTO_STMT:
# line 486 "Traverse.puma"
   return;

  case kASS_GOTO_STMT:
# line 489 "Traverse.puma"
  {
# line 491 "Traverse.puma"
   TraverseAST (t->ASS_GOTO_STMT.GOTO_VAR, pred, visit);
  }
   return;

  case kCOMP_GOTO_STMT:
# line 494 "Traverse.puma"
  {
# line 496 "Traverse.puma"
   TraverseAST (t->COMP_GOTO_STMT.GOTO_EXP, pred, visit);
  }
   return;

  case kIO_STMT:
# line 499 "Traverse.puma"
  {
# line 501 "Traverse.puma"
   TraverseAST (t->IO_STMT.IO_SPECS, pred, visit);
# line 502 "Traverse.puma"
   TraverseAST (t->IO_STMT.IO_ITEMS, pred, visit);
  }
   return;

  case kCOMP_IF_STMT:
# line 505 "Traverse.puma"
  {
# line 507 "Traverse.puma"
   TraverseAST (t->COMP_IF_STMT.IF_EXP, pred, visit);
  }
   return;

  case kSTOP_STMT:
# line 510 "Traverse.puma"
   return;

  case kPAUSE_STMT:
# line 513 "Traverse.puma"
   return;

  case kEXIT_STMT:
# line 516 "Traverse.puma"
   return;

  case kCYCLE_STMT:
# line 519 "Traverse.puma"
   return;

  case kRETURN_STMT:
# line 522 "Traverse.puma"
  {
# line 524 "Traverse.puma"
   TraverseAST (t->RETURN_STMT.RETURN_EXP, pred, visit);
  }
   return;

  case kREDUCE_STMT:
# line 527 "Traverse.puma"
  {
# line 529 "Traverse.puma"
   TraverseAST (t->REDUCE_STMT.RED_PARAMS, pred, visit);
  }
   return;

  case kALLOCATE_STMT:
# line 533 "Traverse.puma"
  {
# line 535 "Traverse.puma"
   TraverseAST (t->ALLOCATE_STMT.PARAMS, pred, visit);
# line 536 "Traverse.puma"
   TraverseAST (t->ALLOCATE_STMT.STATUS, pred, visit);
  }
   return;

  case kDEALLOCATE_STMT:
# line 539 "Traverse.puma"
  {
# line 541 "Traverse.puma"
   TraverseAST (t->DEALLOCATE_STMT.PARAMS, pred, visit);
# line 542 "Traverse.puma"
   TraverseAST (t->DEALLOCATE_STMT.STATUS, pred, visit);
  }
   return;

  case kCREATE_DSP_STMT:
# line 545 "Traverse.puma"
  {
# line 547 "Traverse.puma"
   TraverseAST (t->CREATE_DSP_STMT.VAR, pred, visit);
  }
   return;

  case kINHERIT_DSP_STMT:
# line 551 "Traverse.puma"
  {
# line 553 "Traverse.puma"
   TraverseAST (t->INHERIT_DSP_STMT.VAR, pred, visit);
  }
   return;

  case kFREE_DSP_STMT:
# line 556 "Traverse.puma"
  {
# line 558 "Traverse.puma"
   TraverseAST (t->FREE_DSP_STMT.VAR, pred, visit);
  }
   return;

  case kREG_SHADOW_GET:
# line 561 "Traverse.puma"
  {
# line 563 "Traverse.puma"
   SetActualOverlap (t);
# line 565 "Traverse.puma"
   TraverseAST (t->REG_SHADOW_GET.SHADOW_VAR, pred, visit);
  }
   return;

  case kIND_SHADOW_FREE:
# line 568 "Traverse.puma"
  {
# line 570 "Traverse.puma"
   TraverseAST (t->IND_SHADOW_FREE.INDEX_VAR, pred, visit);
  }
   return;

  case kDIRTY_STMT:
# line 573 "Traverse.puma"
  {
# line 575 "Traverse.puma"
   TraverseAST (t->DIRTY_STMT.ELEMS, pred, visit);
  }
   return;

  case kNULLIFY_STMT:
# line 578 "Traverse.puma"
  {
# line 580 "Traverse.puma"
   TraverseAST (t->NULLIFY_STMT.PARAMS, pred, visit);
  }
   return;

  case kREALIGN_STMT:
# line 583 "Traverse.puma"
   return;

  case kREDISTRIBUTE_STMT:
# line 586 "Traverse.puma"
   return;

  case kDUMMY_EXP:
# line 596 "Traverse.puma"
   return;

  case kCONST_EXP:
# line 599 "Traverse.puma"
   return;

  case kARRAY_EXP:
# line 602 "Traverse.puma"
  {
# line 604 "Traverse.puma"
   TraverseAST (t->ARRAY_EXP.ELEMENTS, pred, visit);
  }
   return;

  case kBOUND_EXP:
# line 607 "Traverse.puma"
   return;

  case kRANK_EXP:
# line 610 "Traverse.puma"
   return;

  case kSLICE_EXP:
# line 613 "Traverse.puma"
  {
# line 615 "Traverse.puma"
   TraverseAST (t->SLICE_EXP.START, pred, visit);
# line 616 "Traverse.puma"
   TraverseAST (t->SLICE_EXP.STOP, pred, visit);
# line 617 "Traverse.puma"
   TraverseAST (t->SLICE_EXP.INC, pred, visit);
  }
   return;

  case kOP_EXP:
# line 620 "Traverse.puma"
  {
# line 622 "Traverse.puma"
   TraverseAST (t->OP_EXP.OPND1, pred, visit);
# line 623 "Traverse.puma"
   TraverseAST (t->OP_EXP.OPND2, pred, visit);
  }
   return;

  case kOP1_EXP:
# line 626 "Traverse.puma"
  {
# line 628 "Traverse.puma"
   TraverseAST (t->OP1_EXP.OPND, pred, visit);
  }
   return;

  case kTYPE_EXP:
# line 631 "Traverse.puma"
  {
# line 633 "Traverse.puma"
   TraverseAST (t->TYPE_EXP.ELEMENTS, pred, visit);
  }
   return;

  case kPERM_EXP:
# line 636 "Traverse.puma"
  {
# line 638 "Traverse.puma"
   TraverseAST (t->PERM_EXP.VAL, pred, visit);
  }
   return;

  case kVAR_EXP:
# line 641 "Traverse.puma"
  {
# line 643 "Traverse.puma"
   TraverseAST (t->VAR_EXP.V, pred, visit);
  }
   return;

  case kDO_EXP:
# line 646 "Traverse.puma"
  {
# line 648 "Traverse.puma"
   TraverseAST (t->DO_EXP.DO_ID, pred, visit);
# line 649 "Traverse.puma"
   TraverseAST (t->DO_EXP.RANGE, pred, visit);
# line 650 "Traverse.puma"
   TraverseAST (t->DO_EXP.BODY, pred, visit);
  }
   return;

  case kFUNC_CALL_EXP:
# line 653 "Traverse.puma"
  {
# line 655 "Traverse.puma"
   TraverseAST (t->FUNC_CALL_EXP.FUNC_PARAMS, pred, visit);
  }
   return;

  case kBTE_LIST:
# line 664 "Traverse.puma"
  {
# line 666 "Traverse.puma"
   TraverseAST (t->BTE_LIST.Elem, pred, visit);
# line 667 "Traverse.puma"
   TraverseAST (t->BTE_LIST.Next, pred, visit);
  }
   return;

  case kBTE_EMPTY:
# line 670 "Traverse.puma"
   return;

  case kVAR_OBJ:
# line 679 "Traverse.puma"
   return;

  case kUSED_VAR:
# line 682 "Traverse.puma"
  {
# line 684 "Traverse.puma"
   TraverseAST (t->USED_VAR.VARNAME, pred, visit);
  }
   return;

  case kLOOP_VAR:
# line 687 "Traverse.puma"
  {
# line 689 "Traverse.puma"
   TraverseAST (t->LOOP_VAR.LOOP_VARNAME, pred, visit);
  }
   return;

  case kDUMMY_VAR:
# line 692 "Traverse.puma"
   return;

  case kREMOTE_VAR:
# line 695 "Traverse.puma"
  {
# line 697 "Traverse.puma"
   TraverseAST (t->REMOTE_VAR.VAR, pred, visit);
  }
   return;

  case kSELECTED_VAR:
# line 700 "Traverse.puma"
  {
# line 702 "Traverse.puma"
   TraverseAST (t->SELECTED_VAR.SELEC_VAR, pred, visit);
  }
   return;

  case kSUBSTRING_VAR:
# line 705 "Traverse.puma"
  {
# line 707 "Traverse.puma"
   TraverseAST (t->SUBSTRING_VAR.IND_VAR, pred, visit);
# line 708 "Traverse.puma"
   TraverseAST (t->SUBSTRING_VAR.IND_EXP, pred, visit);
  }
   return;

  case kINDEXED_VAR:
# line 711 "Traverse.puma"
  {
# line 713 "Traverse.puma"
   TraverseAST (t->INDEXED_VAR.IND_VAR, pred, visit);
# line 714 "Traverse.puma"
   TraverseAST (t->INDEXED_VAR.IND_EXPS, pred, visit);
  }
   return;

  case kDO_VAR:
# line 717 "Traverse.puma"
  {
# line 719 "Traverse.puma"
   TraverseAST (t->DO_VAR.DO_ID, pred, visit);
# line 720 "Traverse.puma"
   TraverseAST (t->DO_VAR.RANGE, pred, visit);
# line 721 "Traverse.puma"
   TraverseAST (t->DO_VAR.BODY, pred, visit);
  }
   return;

  case kPERM_VAR:
# line 724 "Traverse.puma"
  {
# line 726 "Traverse.puma"
   TraverseAST (t->PERM_VAR.VAL, pred, visit);
  }
   return;

  case kADDR:
# line 729 "Traverse.puma"
  {
# line 731 "Traverse.puma"
   TraverseAST (t->ADDR.E, pred, visit);
  }
   return;

  case kBTV_LIST:
# line 740 "Traverse.puma"
  {
# line 742 "Traverse.puma"
   TraverseAST (t->BTV_LIST.Elem, pred, visit);
# line 743 "Traverse.puma"
   TraverseAST (t->BTV_LIST.Next, pred, visit);
  }
   return;

  case kBTV_EMPTY:
# line 746 "Traverse.puma"
   return;

  case kBTP_LIST:
# line 755 "Traverse.puma"
  {
# line 757 "Traverse.puma"
   TraverseAST (t->BTP_LIST.Elem, pred, visit);
# line 758 "Traverse.puma"
   TraverseAST (t->BTP_LIST.Next, pred, visit);
  }
   return;

  case kBTP_EMPTY:
# line 761 "Traverse.puma"
   return;

  case kVAR_PARAM:
# line 764 "Traverse.puma"
  {
# line 766 "Traverse.puma"
   TraverseAST (t->VAR_PARAM.V, pred, visit);
  }
   return;

  case kNO_PARAM:
# line 769 "Traverse.puma"
   return;

  case kNAMED_PARAM:
# line 772 "Traverse.puma"
  {
# line 774 "Traverse.puma"
   TraverseAST (t->NAMED_PARAM.VAL, pred, visit);
  }
   return;

  case kFUNC_PARAM:
# line 777 "Traverse.puma"
   return;

  case kPROC_PARAM:
# line 780 "Traverse.puma"
   return;

  case kSERIAL_INFO:
# line 789 "Traverse.puma"
   return;

  case kVECTOR_INFO:
# line 792 "Traverse.puma"
   return;

  case kPARDO_INFO:
# line 795 "Traverse.puma"
   return;

  case kINDEP_INFO:
# line 798 "Traverse.puma"
   return;

  case kNO_HOME_INFO:
# line 807 "Traverse.puma"
   return;

  case kCOMM_INFO:
# line 810 "Traverse.puma"
  {
# line 812 "Traverse.puma"
 if (t->COMM_INFO.home_var != NoTree) TraverseAST (t->COMM_INFO.home_var, pred, visit); 
  }
   return;

  case kON_INFO:
# line 815 "Traverse.puma"
   return;

  case kDEFAULT_PROCESSOR_ARRAY:
# line 824 "Traverse.puma"
   return;

  case kANY_PROCESSOR_ARRAY:
# line 827 "Traverse.puma"
   return;

  case kPROCESSOR_ARRAY:
# line 830 "Traverse.puma"
   return;

  case kPROCESSOR_SUBSET:
# line 833 "Traverse.puma"
  {
# line 835 "Traverse.puma"
   TraverseAST (t->PROCESSOR_SUBSET.SUBSCRIPTS, pred, visit);
  }
   return;

  }

# line 838 "Traverse.puma"
  {
# line 840 "Traverse.puma"
   failure_protocol (MODULE, "TraverseAST", t);
  }
   return;

;
}

tTree ReplaceAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, UserPredicate pred, UserFunction visit)
# else
(t, pred, visit)
 register tTree t;
 UserPredicate pred;
 UserFunction visit;
# endif
{
# line 861 "Traverse.puma"
  {
# line 863 "Traverse.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return t;
yyL1:;

# line 869 "Traverse.puma"
  {
# line 871 "Traverse.puma"
   if (! ((pred (t)))) goto yyL2;
  {
# line 873 "Traverse.puma"
   SetStatement (t);
  }
  }
   return visit (t);
yyL2:;


  switch (t->Kind) {
  case kCOMP_UNIT:
# line 884 "Traverse.puma"
  {
# line 886 "Traverse.puma"
 t->COMP_UNIT.COMP_ELEMENTS = ReplaceAST (t->COMP_UNIT.COMP_ELEMENTS, pred, visit); 
  }
   return visit (t);

  case kUNIT_LIST:
# line 891 "Traverse.puma"
 {
  tTree new_unit;
  {
# line 893 "Traverse.puma"

# line 895 "Traverse.puma"
 new_unit = ReplaceAST (t->UNIT_LIST.Elem, pred, visit);
     t->UNIT_LIST.Next     = ReplaceAST (t->UNIT_LIST.Next, pred, visit);
     new_unit = ReplaceUNIT (t, new_unit, t->UNIT_LIST.Next);
   
  }
  {
   return new_unit;
  }
 }

  case kUNIT_EMPTY:
# line 903 "Traverse.puma"
   return t;

  case kPROGRAM_DECL:
# line 908 "Traverse.puma"
  {
# line 910 "Traverse.puma"
   NestOpenUnit (t);
# line 911 "Traverse.puma"
 t->PROGRAM_DECL.PROGRAM_BODY = ReplaceAST (t->PROGRAM_DECL.PROGRAM_BODY, pred, visit); 
# line 912 "Traverse.puma"
   NestCloseUnit (t);
  }
   return visit (t);

  case kPROC_DECL:
# line 916 "Traverse.puma"
  {
# line 918 "Traverse.puma"
   NestOpenUnit (t);
# line 919 "Traverse.puma"
 t->PROC_DECL.PROC_BODY = ReplaceAST (t->PROC_DECL.PROC_BODY, pred, visit); 
# line 920 "Traverse.puma"
   NestCloseUnit (t);
  }
   return visit (t);

  case kFUNC_DECL:
# line 924 "Traverse.puma"
  {
# line 926 "Traverse.puma"
   NestOpenUnit (t);
# line 927 "Traverse.puma"
 t->FUNC_DECL.FUNC_BODY = ReplaceAST (t->FUNC_DECL.FUNC_BODY, pred, visit); 
# line 928 "Traverse.puma"
   NestCloseUnit (t);
  }
   return visit (t);

  case kBLOCK_DATA_DECL:
# line 932 "Traverse.puma"
  {
# line 934 "Traverse.puma"
   NestOpenUnit (t);
# line 935 "Traverse.puma"
 t->BLOCK_DATA_DECL.DATA_BODY = ReplaceAST (t->BLOCK_DATA_DECL.DATA_BODY, pred, visit); 
# line 936 "Traverse.puma"
   NestCloseUnit (t);
  }
   return visit (t);

  case kMODULE_DECL:
# line 940 "Traverse.puma"
  {
# line 942 "Traverse.puma"
   NestOpenUnit (t);
# line 943 "Traverse.puma"
 t->MODULE_DECL.MODULE_BODY = ReplaceAST (t->MODULE_DECL.MODULE_BODY, pred, visit); 
# line 944 "Traverse.puma"
   NestCloseUnit (t);
  }
   return visit (t);

  case kMODULE_PROC_DECL:
# line 948 "Traverse.puma"
   return visit (t);

  case kBODY_NODE:
# line 959 "Traverse.puma"
  {
# line 961 "Traverse.puma"
 t->BODY_NODE.DECLS     = ReplaceAST (t->BODY_NODE.DECLS, pred, visit);
     t->BODY_NODE.STATS     = ReplaceAST (t->BODY_NODE.STATS, pred, visit);
     t->BODY_NODE.INTERNALS = ReplaceAST (t->BODY_NODE.INTERNALS, pred, visit);
   
  }
   return visit (t);

  case kDECL_LIST:
# line 974 "Traverse.puma"
 {
  tTree new_decl;
  {
# line 976 "Traverse.puma"

# line 978 "Traverse.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 980 "Traverse.puma"
 new_decl = ReplaceAST (t->DECL_LIST.Elem, pred, visit);
     t->DECL_LIST.Next     = ReplaceAST (t->DECL_LIST.Next, pred, visit);
     new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);
   
  }
  {
   return new_decl;
  }
 }

  case kDECL_EMPTY:
# line 988 "Traverse.puma"
   return t;

  case kVAR_DECL:
# line 993 "Traverse.puma"
  {
# line 995 "Traverse.puma"
 t->VAR_DECL.VAL = ReplaceAST (t->VAR_DECL.VAL, pred, visit); 
  }
   return visit (t);

  case kTYPE_DECL:
# line 1000 "Traverse.puma"
  {
# line 1002 "Traverse.puma"
 t->TYPE_DECL.VAL = ReplaceAST (t->TYPE_DECL.VAL, pred, visit); 
  }
   return visit (t);

  case kINTERFACE_DECL:
# line 1007 "Traverse.puma"
  {
# line 1009 "Traverse.puma"
 t->INTERFACE_DECL.ITEMS = ReplaceAST (t->INTERFACE_DECL.ITEMS, pred, visit); 
  }
   return visit (t);

  case kDECL_NODE:
  case kNAME_DECL:
  case kRENAME_DECL:
  case kENTITY_DECL:
  case kCOMMON_DECL:
  case kNAMELIST_DECL:
  case kTEMPLATE_DECL:
  case kRAGGED_DECL:
  case kPROCESSORS_DECL:
  case kSUB_PROCS_DECL:
  case kINHERIT_DECL:
  case kRANGE_DECL:
  case kSTMT_FUNC_DECL:
  case kVAR_PARAM_DECL:
  case kRET_PARAM_DECL:
  case kIMPLICIT_DECL:
  case kUSE_DECL:
  case kONLY_USE_DECL:
  case kEQV_DECL:
  case kDATA_DECL:
  case kFORMAT_DECL:
  case kDIMENSION_DECL:
  case kINIT_DATA_DECL:
  case kTYPESPEC_DECL:
  case kALLOCATABLE_DECL:
  case kEXTERNAL_DECL:
  case kINTENT_DECL:
  case kINTRINSIC_DECL:
  case kOPTIONAL_DECL:
  case kPOINTER_DECL:
  case kSAVE_DECL:
  case kTARGET_DECL:
  case kPARAMETER_DECL:
  case kPUBLIC_DECL:
  case kPRIVATE_DECL:
  case kSEQUENCE_DECL:
  case kDISTRIBUTE_DECL:
  case kALIGN_DECL:
  case kMAP_DECL:
  case kOVERLAP_DECL:
  case kSHARED_DECL:
  case kDYNAMIC_DECL:
  case kTRACE_DECL:
  case kTREE_DECL:
  case kSELECT_DECL:
  case kHPF_SEQUENCE_DECL:
  case kNOSEQUENCE_DECL:
  case kLAYOUT_DECL:
  case kPASS_BY_DECL:
  case kMAP_TO_DECL:
# line 1014 "Traverse.puma"
   return visit (t);

  case kARRAY_TYPE:
# line 1025 "Traverse.puma"
  {
# line 1027 "Traverse.puma"
 t->ARRAY_TYPE.ARRAY_INDEX_TYPES = ReplaceAST (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, pred, visit); 
     t->ARRAY_TYPE.ARRAY_COMP_TYPE   = ReplaceAST (t->ARRAY_TYPE.ARRAY_COMP_TYPE,   pred, visit); 
   
  }
   return visit (t);

  case kEXPLICIT_SHAPE:
# line 1034 "Traverse.puma"
  {
# line 1036 "Traverse.puma"
 t->EXPLICIT_SHAPE.LOWER = ReplaceAST (t->EXPLICIT_SHAPE.LOWER, pred, visit); 
     t->EXPLICIT_SHAPE.UPPER = ReplaceAST (t->EXPLICIT_SHAPE.UPPER,  pred, visit);
   
  }
   return visit (t);

  case kSHAPE_SPEC:
  case kASSUMED_SHAPE:
  case kDEFERRED_SHAPE:
  case kASSUMED_SIZE:
# line 1042 "Traverse.puma"
   return visit (t);

  case kRECORD_TYPE:
# line 1046 "Traverse.puma"
  {
# line 1048 "Traverse.puma"
   NestOpenType (t);
# line 1049 "Traverse.puma"
 t->RECORD_TYPE.COMPONENTS = ReplaceAST (t->RECORD_TYPE.COMPONENTS, pred, visit); 
# line 1050 "Traverse.puma"
   NestCloseType (t);
  }
   return visit (t);

  case kTYPE_NODE:
  case kDUMMY_TYPE:
  case kALIGN_TYPE:
  case kINTEGER_TYPE:
  case kREAL_TYPE:
  case kBOOLEAN_TYPE:
  case kCOMPLEX_TYPE:
  case kSTRING_TYPE:
  case kTYPE_ID:
  case kPOINTER_TYPE:
# line 1055 "Traverse.puma"
   return visit (t);

  case kSHAPE_LIST:
# line 1060 "Traverse.puma"
  {
# line 1062 "Traverse.puma"
 t->SHAPE_LIST.Elem = ReplaceAST (t->SHAPE_LIST.Elem, pred, visit); 
     t->SHAPE_LIST.Next = ReplaceAST (t->SHAPE_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kSHAPE_EMPTY:
# line 1068 "Traverse.puma"
   return visit (t);

  case kACF_LIST:
# line 1078 "Traverse.puma"
 {
  tTree newacf;
  {
# line 1080 "Traverse.puma"

# line 1082 "Traverse.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 1084 "Traverse.puma"
 newacf = ReplaceAST (t->ACF_LIST.Elem, pred, visit);            
     t->ACF_LIST.Next   = ReplaceAST (t->ACF_LIST.Next, pred, visit);            
   
# line 1088 "Traverse.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
  {
   return newacf;
  }
 }

  case kACF_EMPTY:
# line 1093 "Traverse.puma"
   return t;

  case kACF_BASIC:
# line 1098 "Traverse.puma"
  {
# line 1100 "Traverse.puma"
 t->ACF_BASIC.BASIC_STMT = ReplaceAST (t->ACF_BASIC.BASIC_STMT, pred, visit); 
  }
   return visit (t);

  case kACF_DUMMY:
# line 1105 "Traverse.puma"
   return visit (t);

  case kACF_WHILE:
# line 1110 "Traverse.puma"
  {
# line 1112 "Traverse.puma"
 t->ACF_WHILE.WHILE_EXP  = ReplaceAST (t->ACF_WHILE.WHILE_EXP, pred, visit);
     t->ACF_WHILE.WHILE_BODY = ReplaceAST (t->ACF_WHILE.WHILE_BODY, pred, visit);
   
  }
   return visit (t);

  case kACF_DO:
# line 1118 "Traverse.puma"
  {
# line 1120 "Traverse.puma"
 t->ACF_DO.DO_ID       = ReplaceAST (t->ACF_DO.DO_ID, pred, visit);
     t->ACF_DO.DO_RANGE    = ReplaceAST (t->ACF_DO.DO_RANGE, pred, visit);
     t->ACF_DO.DO_DEP_INFO = ReplaceAST (t->ACF_DO.DO_DEP_INFO, pred, visit);
   
# line 1125 "Traverse.puma"
   IncLoopNesting (t);
# line 1127 "Traverse.puma"
 t->ACF_DO.DO_BODY  = ReplaceAST (t->ACF_DO.DO_BODY, pred, visit); 
# line 1129 "Traverse.puma"
   DecLoopNesting (t);
  }
   return visit (t);

  case kACF_FORALL:
# line 1134 "Traverse.puma"
  {
# line 1136 "Traverse.puma"
 t->ACF_FORALL.FORALL_ID       = ReplaceAST (t->ACF_FORALL.FORALL_ID, pred, visit);
     t->ACF_FORALL.FORALL_RANGE    = ReplaceAST (t->ACF_FORALL.FORALL_RANGE, pred, visit);
     t->ACF_FORALL.FORALL_DEP_INFO = ReplaceAST (t->ACF_FORALL.FORALL_DEP_INFO, pred, visit);
   
# line 1141 "Traverse.puma"
   IncLoopNesting (t);
# line 1143 "Traverse.puma"
 t->ACF_FORALL.FORALL_BODY  = ReplaceAST (t->ACF_FORALL.FORALL_BODY, pred, visit); 
# line 1145 "Traverse.puma"
   DecLoopNesting (t);
  }
   return visit (t);

  case kACF_IF:
# line 1150 "Traverse.puma"
  {
# line 1152 "Traverse.puma"
 t->ACF_IF.IF_EXP = ReplaceAST (t->ACF_IF.IF_EXP, pred, visit);
     t->ACF_IF.THEN_PART = ReplaceAST (t->ACF_IF.THEN_PART, pred, visit);
     t->ACF_IF.ELSE_PART = ReplaceAST (t->ACF_IF.ELSE_PART, pred, visit);
   
  }
   return visit (t);

  case kACF_WHERE:
# line 1159 "Traverse.puma"
  {
# line 1161 "Traverse.puma"
 t->ACF_WHERE.WHERE_EXP = ReplaceAST (t->ACF_WHERE.WHERE_EXP, pred, visit);
     t->ACF_WHERE.TRUE_PART = ReplaceAST (t->ACF_WHERE.TRUE_PART, pred, visit);
     t->ACF_WHERE.FALSE_PART = ReplaceAST (t->ACF_WHERE.FALSE_PART, pred, visit);
   
  }
   return visit (t);

  case kACF_HOME:
# line 1168 "Traverse.puma"
  {
# line 1170 "Traverse.puma"
 t->ACF_HOME.HOME_VAR = ReplaceAST (t->ACF_HOME.HOME_VAR, pred, visit);
     t->ACF_HOME.HOME_BODY = ReplaceAST (t->ACF_HOME.HOME_BODY, pred, visit);
   
  }
   return visit (t);

  case kACF_RESIDENT:
# line 1177 "Traverse.puma"
  {
# line 1179 "Traverse.puma"
 t->ACF_RESIDENT.RESIDENT_VAR = ReplaceAST (t->ACF_RESIDENT.RESIDENT_VAR, pred, visit);
     t->ACF_RESIDENT.RESIDENT_BODY = ReplaceAST (t->ACF_RESIDENT.RESIDENT_BODY, pred, visit);
   
  }
   return visit (t);

  case kACF_PARALLEL:
# line 1186 "Traverse.puma"
  {
# line 1188 "Traverse.puma"
 t->ACF_PARALLEL.REDUCTION_VARS    = ReplaceAST (t->ACF_PARALLEL.REDUCTION_VARS, pred, visit);
     t->ACF_PARALLEL.SHARED_VARS = ReplaceAST (t->ACF_PARALLEL.SHARED_VARS, pred, visit);
     t->ACF_PARALLEL.LOCAL_VARS  = ReplaceAST (t->ACF_PARALLEL.LOCAL_VARS, pred, visit);
     t->ACF_PARALLEL.PARALLEL_BODY    = ReplaceAST (t->ACF_PARALLEL.PARALLEL_BODY, pred, visit);
   
  }
   return visit (t);

  case kACF_CRITICAL:
# line 1197 "Traverse.puma"
  {
# line 1199 "Traverse.puma"
 t->ACF_CRITICAL.CRITICAL_BODY = ReplaceAST (t->ACF_CRITICAL.CRITICAL_BODY, pred, visit); 
  }
   return visit (t);

  case kACF_NEW:
# line 1204 "Traverse.puma"
  {
# line 1206 "Traverse.puma"
 
     t->ACF_NEW.NEW_BODY = ReplaceAST (t->ACF_NEW.NEW_BODY, pred, visit);
   
  }
   return visit (t);

  case kACF_BARRIER:
# line 1213 "Traverse.puma"
   return visit (t);

  case kACF_REDUCTION:
# line 1218 "Traverse.puma"
  {
# line 1222 "Traverse.puma"
 t->ACF_REDUCTION.REDUCTION_VAR  = ReplaceAST (t->ACF_REDUCTION.REDUCTION_VAR, pred, visit);
     t->ACF_REDUCTION.REDUCTION_LVAR  = ReplaceAST (t->ACF_REDUCTION.REDUCTION_LVAR, pred, visit);
     t->ACF_REDUCTION.REDUCTION_BODY = ReplaceAST (t->ACF_REDUCTION.REDUCTION_BODY, pred, visit);
   
  }
   return visit (t);

  case kON_PROC_CLAUSE:
# line 1230 "Traverse.puma"
  {
# line 1232 "Traverse.puma"
 t->ON_PROC_CLAUSE.ON_PROC = ReplaceAST (t->ON_PROC_CLAUSE.ON_PROC, pred, visit); 
  }
   return visit (t);

  case kON_VAR_CLAUSE:
# line 1236 "Traverse.puma"
  {
# line 1238 "Traverse.puma"
 t->ON_VAR_CLAUSE.ON_VAR = ReplaceAST (t->ON_VAR_CLAUSE.ON_VAR, pred, visit); 
  }
   return visit (t);

  case kON_ALL_CLAUSE:
# line 1242 "Traverse.puma"
   return visit (t);

  case kON_HOST_CLAUSE:
# line 1247 "Traverse.puma"
   return visit (t);

  case kACF_ON:
# line 1252 "Traverse.puma"
  {
# line 1254 "Traverse.puma"
 t->ACF_ON.ON_BODY = ReplaceAST (t->ACF_ON.ON_BODY, pred, visit); 
  }
   return visit (t);

  case kACF_TASK_REGION:
# line 1259 "Traverse.puma"
  {
# line 1261 "Traverse.puma"
 t->ACF_TASK_REGION.TASK_BODY = ReplaceAST (t->ACF_TASK_REGION.TASK_BODY, pred, visit); 
  }
   return visit (t);

  case kACF_MOVE:
# line 1266 "Traverse.puma"
  {
# line 1268 "Traverse.puma"
 t->ACF_MOVE.MOVE_STMT = ReplaceAST (t->ACF_MOVE.MOVE_STMT, pred, visit); 
  }
   return visit (t);

  case kACF_CASE:
# line 1273 "Traverse.puma"
  {
# line 1275 "Traverse.puma"
 t->ACF_CASE.CASE_EXP = ReplaceAST (t->ACF_CASE.CASE_EXP, pred, visit);
     t->ACF_CASE.CASE_ALTS = ReplaceAST (t->ACF_CASE.CASE_ALTS, pred, visit);
   
  }
   return visit (t);

  case kSELECTED_ACF_LIST:
# line 1287 "Traverse.puma"
  {
# line 1289 "Traverse.puma"
 t->SELECTED_ACF_LIST.Elem = ReplaceAST (t->SELECTED_ACF_LIST.Elem, pred, visit);
     t->SELECTED_ACF_LIST.Next = ReplaceAST (t->SELECTED_ACF_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kSELECTED_ACF_EMPTY:
# line 1295 "Traverse.puma"
   return visit (t);

  case kSELECTED_ACF_NODE:
# line 1299 "Traverse.puma"
  {
# line 1301 "Traverse.puma"
 t->SELECTED_ACF_NODE.SELECT_LIST = ReplaceAST (t->SELECTED_ACF_NODE.SELECT_LIST, pred, visit);
     t->SELECTED_ACF_NODE.SELECT_ACFS   = ReplaceAST (t->SELECTED_ACF_NODE.SELECT_ACFS, pred, visit);
   
  }
   return visit (t);

  case kASSIGN_STMT:
# line 1313 "Traverse.puma"
  {
# line 1315 "Traverse.puma"
 t->ASSIGN_STMT.ASSIGN_VAR = ReplaceAST (t->ASSIGN_STMT.ASSIGN_VAR, pred, visit);
     t->ASSIGN_STMT.ASSIGN_EXP = ReplaceAST (t->ASSIGN_STMT.ASSIGN_EXP, pred, visit);
   
  }
   return visit (t);

  case kPTR_ASSIGN_STMT:
# line 1321 "Traverse.puma"
  {
# line 1323 "Traverse.puma"
 t->PTR_ASSIGN_STMT.ASSIGN_VAR = ReplaceAST (t->PTR_ASSIGN_STMT.ASSIGN_VAR, pred, visit);
     t->PTR_ASSIGN_STMT.ASSIGN_EXP = ReplaceAST (t->PTR_ASSIGN_STMT.ASSIGN_EXP, pred, visit);
   
  }
   return visit (t);

  case kLABEL_ASSIGN_STMT:
# line 1329 "Traverse.puma"
  {
# line 1331 "Traverse.puma"
 t->LABEL_ASSIGN_STMT.LABEL_VAR = ReplaceAST (t->LABEL_ASSIGN_STMT.LABEL_VAR, pred, visit); 
  }
   return visit (t);

  case kFORMAT_STMT:
# line 1335 "Traverse.puma"
   return visit (t);

  case kCALL_STMT:
# line 1339 "Traverse.puma"
  {
# line 1341 "Traverse.puma"
 t->CALL_STMT.CALL_PARAMS = ReplaceAST (t->CALL_STMT.CALL_PARAMS, pred, visit); 
  }
   return visit (t);

  case kMOVE_STMT:
# line 1345 "Traverse.puma"
  {
# line 1347 "Traverse.puma"
 t->MOVE_STMT.TARGET = ReplaceAST (t->MOVE_STMT.TARGET, pred, visit); 
     t->MOVE_STMT.SOURCE = ReplaceAST (t->MOVE_STMT.SOURCE, pred, visit); 
     t->MOVE_STMT.MASK   = ReplaceAST (t->MOVE_STMT.MASK, pred, visit); 
   
  }
   return visit (t);

  case kSCATTER_STMT:
# line 1354 "Traverse.puma"
  {
# line 1356 "Traverse.puma"
 t->SCATTER_STMT.BASE    = ReplaceAST (t->SCATTER_STMT.BASE, pred, visit); 
     t->SCATTER_STMT.ARRAY   = ReplaceAST (t->SCATTER_STMT.ARRAY, pred, visit); 
     t->SCATTER_STMT.INDEXES = ReplaceAST (t->SCATTER_STMT.INDEXES, pred, visit); 
     t->SCATTER_STMT.MASK    = ReplaceAST (t->SCATTER_STMT.MASK, pred, visit); 
   
  }
   return visit (t);

  case kBROADCAST_STMT:
# line 1364 "Traverse.puma"
  {
# line 1366 "Traverse.puma"
 t->BROADCAST_STMT.ELEMS = ReplaceAST (t->BROADCAST_STMT.ELEMS, pred, visit); 
  }
   return visit (t);

  case kGOTO_STMT:
# line 1371 "Traverse.puma"
   return visit (t);

  case kASS_GOTO_STMT:
# line 1375 "Traverse.puma"
  {
# line 1377 "Traverse.puma"
 t->ASS_GOTO_STMT.GOTO_VAR = ReplaceAST (t->ASS_GOTO_STMT.GOTO_VAR, pred, visit); 
  }
   return visit (t);

  case kREDUCTION_STMT:
# line 1381 "Traverse.puma"
  {
# line 1383 "Traverse.puma"
 t->REDUCTION_STMT.ELEMS = ReplaceAST (t->REDUCTION_STMT.ELEMS, pred, visit); 
  }
   return visit (t);

  case kCOMP_GOTO_STMT:
# line 1388 "Traverse.puma"
  {
# line 1390 "Traverse.puma"
 t->COMP_GOTO_STMT.GOTO_EXP = ReplaceAST (t->COMP_GOTO_STMT.GOTO_EXP, pred, visit); 
  }
   return visit (t);

  case kIO_STMT:
# line 1394 "Traverse.puma"
  {
# line 1396 "Traverse.puma"
 t->IO_STMT.IO_SPECS = ReplaceAST (t->IO_STMT.IO_SPECS, pred, visit);
     t->IO_STMT.IO_ITEMS = ReplaceAST (t->IO_STMT.IO_ITEMS, pred, visit);
   
  }
   return visit (t);

  case kCOMP_IF_STMT:
# line 1402 "Traverse.puma"
  {
# line 1404 "Traverse.puma"
 t->COMP_IF_STMT.IF_EXP = ReplaceAST (t->COMP_IF_STMT.IF_EXP, pred, visit); 
  }
   return visit (t);

  case kSTOP_STMT:
# line 1408 "Traverse.puma"
   return visit (t);

  case kPAUSE_STMT:
# line 1412 "Traverse.puma"
   return visit (t);

  case kEXIT_STMT:
# line 1416 "Traverse.puma"
   return visit (t);

  case kCYCLE_STMT:
# line 1420 "Traverse.puma"
   return visit (t);

  case kRETURN_STMT:
# line 1424 "Traverse.puma"
  {
# line 1426 "Traverse.puma"
 t->RETURN_STMT.RETURN_EXP = ReplaceAST (t->RETURN_STMT.RETURN_EXP, pred, visit); 
  }
   return visit (t);

  case kREDUCE_STMT:
# line 1430 "Traverse.puma"
  {
# line 1432 "Traverse.puma"
 t->REDUCE_STMT.RED_PARAMS = ReplaceAST (t->REDUCE_STMT.RED_PARAMS, pred, visit); 
  }
   return visit (t);

  case kALLOCATE_STMT:
# line 1436 "Traverse.puma"
  {
# line 1438 "Traverse.puma"
 t->ALLOCATE_STMT.PARAMS = ReplaceAST (t->ALLOCATE_STMT.PARAMS, pred, visit);
     t->ALLOCATE_STMT.STATUS = ReplaceAST (t->ALLOCATE_STMT.STATUS, pred, visit);
   
  }
   return visit (t);

  case kDEALLOCATE_STMT:
# line 1445 "Traverse.puma"
  {
# line 1447 "Traverse.puma"
 t->DEALLOCATE_STMT.PARAMS = ReplaceAST (t->DEALLOCATE_STMT.PARAMS, pred, visit);
     t->DEALLOCATE_STMT.STATUS = ReplaceAST (t->DEALLOCATE_STMT.STATUS, pred, visit);
   
  }
   return visit (t);

  case kCREATE_DSP_STMT:
# line 1454 "Traverse.puma"
  {
# line 1456 "Traverse.puma"
 t->CREATE_DSP_STMT.VAR     = ReplaceAST (t->CREATE_DSP_STMT.VAR, pred, visit);
     
   
  }
   return visit (t);

  case kINHERIT_DSP_STMT:
# line 1463 "Traverse.puma"
  {
# line 1465 "Traverse.puma"
 t->INHERIT_DSP_STMT.VAR     = ReplaceAST (t->INHERIT_DSP_STMT.VAR, pred, visit);
     
   
  }
   return visit (t);

  case kFREE_DSP_STMT:
# line 1472 "Traverse.puma"
  {
# line 1474 "Traverse.puma"
 t->FREE_DSP_STMT.VAR = ReplaceAST (t->FREE_DSP_STMT.VAR, pred, visit); 
  }
   return visit (t);

  case kREG_SHADOW_GET:
# line 1479 "Traverse.puma"
  {
# line 1481 "Traverse.puma"
   SetActualOverlap (t);
# line 1482 "Traverse.puma"
 t->REG_SHADOW_GET.SHADOW_VAR = ReplaceAST (t->REG_SHADOW_GET.SHADOW_VAR, pred, visit); 
  }
   return visit (t);

  case kIND_SHADOW_CREATE:
# line 1486 "Traverse.puma"
   return visit (t);

  case kIND_SHADOW_FREE:
# line 1491 "Traverse.puma"
   return visit (t);

  case kIND_SHADOW_GET:
# line 1496 "Traverse.puma"
   return visit (t);

  case kIND_SHADOW_SET:
# line 1501 "Traverse.puma"
   return visit (t);

  case kIND_SHADOW_PUT:
# line 1506 "Traverse.puma"
   return visit (t);

  case kDIRTY_STMT:
# line 1511 "Traverse.puma"
  {
# line 1513 "Traverse.puma"
 t->DIRTY_STMT.ELEMS = ReplaceAST (t->DIRTY_STMT.ELEMS, pred, visit); 
  }
   return visit (t);

  case kNULLIFY_STMT:
# line 1518 "Traverse.puma"
  {
# line 1520 "Traverse.puma"
 t->NULLIFY_STMT.PARAMS = ReplaceAST (t->NULLIFY_STMT.PARAMS, pred, visit); 
  }
   return visit (t);

  case kREALIGN_STMT:
# line 1524 "Traverse.puma"
   return visit (t);

  case kREDISTRIBUTE_STMT:
# line 1529 "Traverse.puma"
   return visit (t);

  case kDUMMY_EXP:
# line 1541 "Traverse.puma"
   return visit (t);

  case kCONST_EXP:
# line 1545 "Traverse.puma"
   return visit (t);

  case kARRAY_EXP:
# line 1549 "Traverse.puma"
  {
# line 1551 "Traverse.puma"
 t->ARRAY_EXP.ELEMENTS = ReplaceAST (t->ARRAY_EXP.ELEMENTS, pred, visit); 
  }
   return visit (t);

  case kBOUND_EXP:
# line 1555 "Traverse.puma"
   return visit (t);

  case kRANK_EXP:
# line 1560 "Traverse.puma"
   return visit (t);

  case kPERM_EXP:
# line 1565 "Traverse.puma"
  {
# line 1567 "Traverse.puma"
 t->PERM_EXP.VAL = ReplaceAST (t->PERM_EXP.VAL, pred, visit); 
  }
   return visit (t);

  case kSLICE_EXP:
# line 1571 "Traverse.puma"
  {
# line 1573 "Traverse.puma"
 t->SLICE_EXP.START = ReplaceAST (t->SLICE_EXP.START, pred, visit);
     t->SLICE_EXP.STOP  = ReplaceAST (t->SLICE_EXP.STOP, pred,  visit);
     t->SLICE_EXP.INC   = ReplaceAST (t->SLICE_EXP.INC, pred,  visit);
   
  }
   return visit (t);

  case kOP_EXP:
# line 1580 "Traverse.puma"
  {
# line 1582 "Traverse.puma"
 t->OP_EXP.OPND1 = ReplaceAST (t->OP_EXP.OPND1, pred, visit);
     t->OP_EXP.OPND2 = ReplaceAST (t->OP_EXP.OPND2, pred, visit);
   
  }
   return visit (t);

  case kOP1_EXP:
# line 1588 "Traverse.puma"
  {
# line 1590 "Traverse.puma"
 t->OP1_EXP.OPND = ReplaceAST (t->OP1_EXP.OPND, pred, visit); 
  }
   return visit (t);

  case kTYPE_EXP:
# line 1595 "Traverse.puma"
  {
# line 1597 "Traverse.puma"
 t->TYPE_EXP.ELEMENTS = ReplaceAST (t->TYPE_EXP.ELEMENTS, pred, visit); 
  }
   return visit (t);

  case kVAR_EXP:
# line 1601 "Traverse.puma"
  {
# line 1603 "Traverse.puma"
 t->VAR_EXP.V = ReplaceAST (t->VAR_EXP.V, pred, visit); 
  }
   return visit (t);

  case kDO_EXP:
# line 1607 "Traverse.puma"
  {
# line 1609 "Traverse.puma"
 t->DO_EXP.DO_ID = ReplaceAST (t->DO_EXP.DO_ID, pred, visit);
     t->DO_EXP.RANGE = ReplaceAST (t->DO_EXP.RANGE, pred, visit);
     t->DO_EXP.BODY  = ReplaceAST (t->DO_EXP.BODY, pred, visit);
   
  }
   return visit (t);

  case kFUNC_CALL_EXP:
# line 1616 "Traverse.puma"
  {
# line 1618 "Traverse.puma"
 t->FUNC_CALL_EXP.FUNC_PARAMS = ReplaceAST (t->FUNC_CALL_EXP.FUNC_PARAMS, pred, visit); 
  }
   return visit (t);

  case kBTE_LIST:
# line 1628 "Traverse.puma"
  {
# line 1630 "Traverse.puma"
 t->BTE_LIST.Elem = ReplaceAST (t->BTE_LIST.Elem, pred, visit);
     t->BTE_LIST.Next = ReplaceAST (t->BTE_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kBTE_EMPTY:
# line 1636 "Traverse.puma"
   return visit (t);

  case kVAR_OBJ:
# line 1646 "Traverse.puma"
   return visit (t);

  case kUSED_VAR:
# line 1650 "Traverse.puma"
  {
# line 1652 "Traverse.puma"
 t->USED_VAR.VARNAME = ReplaceAST (t->USED_VAR.VARNAME, pred, visit); 
  }
   return visit (t);

  case kLOOP_VAR:
# line 1656 "Traverse.puma"
  {
# line 1658 "Traverse.puma"
 t->LOOP_VAR.LOOP_VARNAME = ReplaceAST (t->LOOP_VAR.LOOP_VARNAME, pred, visit); 
  }
   return visit (t);

  case kDUMMY_VAR:
# line 1662 "Traverse.puma"
   return visit (t);

  case kREMOTE_VAR:
# line 1666 "Traverse.puma"
  {
# line 1668 "Traverse.puma"
 t->REMOTE_VAR.VAR = ReplaceAST (t->REMOTE_VAR.VAR, pred, visit); 
  }
   return visit (t);

  case kSELECTED_VAR:
# line 1672 "Traverse.puma"
  {
# line 1674 "Traverse.puma"
 t->SELECTED_VAR.SELEC_VAR = ReplaceAST (t->SELECTED_VAR.SELEC_VAR, pred, visit); 
  }
   return visit (t);

  case kSUBSTRING_VAR:
# line 1678 "Traverse.puma"
  {
# line 1680 "Traverse.puma"
 t->SUBSTRING_VAR.IND_VAR    = ReplaceAST (t->SUBSTRING_VAR.IND_VAR, pred, visit); 
     t->SUBSTRING_VAR.IND_EXP = ReplaceAST (t->SUBSTRING_VAR.IND_EXP, pred, visit);
   
  }
   return visit (t);

  case kINDEXED_VAR:
# line 1686 "Traverse.puma"
  {
# line 1688 "Traverse.puma"
 t->INDEXED_VAR.IND_VAR = ReplaceAST (t->INDEXED_VAR.IND_VAR, pred, visit);
     t->INDEXED_VAR.IND_EXPS = ReplaceAST (t->INDEXED_VAR.IND_EXPS, pred, visit);
   
  }
   return visit (t);

  case kPERM_VAR:
# line 1694 "Traverse.puma"
  {
# line 1696 "Traverse.puma"
 t->PERM_VAR.VAL = ReplaceAST (t->PERM_VAR.VAL, pred, visit); 
  }
   return visit (t);

  case kADDR:
# line 1700 "Traverse.puma"
  {
# line 1702 "Traverse.puma"
 t->ADDR.E = ReplaceAST (t->ADDR.E, pred, visit); 
  }
   return visit (t);

  case kDO_VAR:
# line 1706 "Traverse.puma"
  {
# line 1708 "Traverse.puma"
 t->DO_VAR.DO_ID    = ReplaceAST (t->DO_VAR.DO_ID, pred, visit);
     t->DO_VAR.RANGE = ReplaceAST (t->DO_VAR.RANGE, pred, visit);
     t->DO_VAR.BODY  = ReplaceAST (t->DO_VAR.BODY, pred, visit);
   
  }
   return visit (t);

  case kBTV_LIST:
# line 1721 "Traverse.puma"
  {
# line 1723 "Traverse.puma"
 t->BTV_LIST.Elem = ReplaceAST (t->BTV_LIST.Elem, pred, visit);
     t->BTV_LIST.Next = ReplaceAST (t->BTV_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kBTV_EMPTY:
# line 1729 "Traverse.puma"
   return visit (t);

  case kBTP_LIST:
# line 1739 "Traverse.puma"
  {
# line 1741 "Traverse.puma"
 t->BTP_LIST.Elem = ReplaceAST (t->BTP_LIST.Elem, pred, visit); 
     t->BTP_LIST.Next = ReplaceAST (t->BTP_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kBTP_EMPTY:
# line 1747 "Traverse.puma"
   return visit (t);

  case kVAR_PARAM:
# line 1751 "Traverse.puma"
  {
# line 1753 "Traverse.puma"
 t->VAR_PARAM.V = ReplaceAST (t->VAR_PARAM.V, pred, visit); 
  }
   return visit (t);

  case kNO_PARAM:
# line 1757 "Traverse.puma"
   return visit (t);

  case kNAMED_PARAM:
# line 1761 "Traverse.puma"
  {
# line 1763 "Traverse.puma"
 t->NAMED_PARAM.VAL = ReplaceAST (t->NAMED_PARAM.VAL, pred, visit); 
  }
   return visit (t);

  case kFUNC_PARAM:
# line 1767 "Traverse.puma"
   return visit (t);

  case kPROC_PARAM:
# line 1771 "Traverse.puma"
   return visit (t);

  case kSERIAL_INFO:
# line 1781 "Traverse.puma"
   return visit (t);

  case kVECTOR_INFO:
# line 1786 "Traverse.puma"
   return visit (t);

  case kPARDO_INFO:
# line 1791 "Traverse.puma"
   return visit (t);

  case kINDEP_INFO:
# line 1796 "Traverse.puma"
   return visit (t);

  case kNO_HOME_INFO:
# line 1807 "Traverse.puma"
   return visit (t);

  case kCOMM_INFO:
# line 1812 "Traverse.puma"
  {
# line 1814 "Traverse.puma"
 if (t->COMM_INFO.home_var != NoTree)
        t->COMM_INFO.home_var = ReplaceAST (t->COMM_INFO.home_var, pred, visit);
   
  }
   return visit (t);

  case kON_INFO:
# line 1821 "Traverse.puma"
   return visit (t);

  case kDEFAULT_PROCESSOR_ARRAY:
# line 1832 "Traverse.puma"
   return visit (t);

  case kANY_PROCESSOR_ARRAY:
# line 1837 "Traverse.puma"
   return visit (t);

  case kPROCESSOR_ARRAY:
# line 1842 "Traverse.puma"
   return visit (t);

  case kPROCESSOR_SUBSET:
# line 1847 "Traverse.puma"
  {
# line 1849 "Traverse.puma"
 t->PROCESSOR_SUBSET.SUBSCRIPTS = ReplaceAST (t->PROCESSOR_SUBSET.SUBSCRIPTS, pred, visit); 
  }
   return visit (t);

  }

# line 1853 "Traverse.puma"
  {
# line 1855 "Traverse.puma"
   failure_protocol (MODULE, "ReplaceAST", t);
  }
   return NoTree;

}

static void SetStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREG_SHADOW_GET) {
# line 1867 "Traverse.puma"
  {
# line 1869 "Traverse.puma"
   SetActualOverlap (t);
  }
   return;

  }
;
}

void BeginTraverse ()
{
}

void CloseTraverse ()
{
}
