# include "Transform.h"
# include "yyTransform.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 69 "Transform.puma"


# include <stdio.h>
# include <string.h>

# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"
# include "DefTable.h"       /*              */
# include "Expressions.h"    /* MakeConstant */
# include "protocol.h"
# include "BuildTree.h"      /* use some same simple functionality */

# define MODULE "Transform"



static void yyExit () { Exit (1); }

void (* Transform_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Transform, routine %s failed\n", yyFunction);
 Transform_Exit ();
}

tTree CombineACF ARGS((tTree list1, tTree list2));
tTree CompleteACFs ARGS((tTree list));
tTree CombineBTP ARGS((tTree list1, tTree list2));
tTree CompleteBTPs ARGS((tTree list));
tTree CombineBTV ARGS((tTree list1, tTree list2));
tTree CompleteBTVs ARGS((tTree list));
tTree ReplaceACF ARGS((tTree old, tTree newelem, tTree newnext));
static bool IsEmptyStmt ARGS((tTree t));
static void ReplaceACF_Set ARGS((tTree newelem, int line, int save_label));
tTree ReplaceUNIT ARGS((tTree old, tTree newelem, tTree newnext));
tTree ReplaceDECL ARGS((tTree old, tTree newelem, tTree newnext));
tTree ReplaceBTP ARGS((tTree old, tTree newelem, tTree newnext));
tTree AppendDECLS ARGS((tTree t, tTree newlist));
static int DeclLevel ARGS((tTree decl));
tTree ExpToVarParam ARGS((tTree exp));
tTree ExpListToVarParamList ARGS((tTree explist));
tTree VarParamToExp ARGS((tTree param));
void SetVarParamAttributes ARGS((tTree p, int intent));
tTree GetStringParams ARGS((tIdent name));
tTree AppendParam ARGS((tTree plist, tTree param));
tTree ConcatParams ARGS((tTree list1, tTree list2));
tTree ConcatVars ARGS((tTree list1, tTree list2));
tTree AppendBody ARGS((tTree list1, tTree list2));
tTree ComposeNewACF ARGS((tTree pre, tTree s, tTree post));
tTree MakeIntegerType ARGS((int size));
tTree MakeRealType ARGS((int size));
tTree MakeLogicalType ARGS((int size));
tTree MakeStringType ARGS((int size));
tTree MakeStmtList ARGS((tTree stmt));
tTree MakeVarDeclA ARGS((tIdent id, String n, tTree val));
tTree MakeVarDeclAn ARGS((tIdent id, String n, int no, tTree val));
tTree MakeUsedVarA ARGS((tIdent id, String n));
tTree MakeUsedVarAn ARGS((tIdent id, String n, int no));
tTree MakeVarParamDeclA ARGS((tIdent id, String n));
tTree MakeVarParamDeclAn ARGS((tIdent id, String n, int no));
tTree MakeVarSuffixA ARGS((tTree var, String n));
tTree MakeVarSuffixAn ARGS((tTree var, String n, int no));
static tIdent MakeIdentSuffixA ARGS((tIdent ident, String n));
static tIdent MakeIdentSuffixAn ARGS((tIdent ident, String n, int no));
void SetVarObject ARGS((tTree var));
void LineACFNode ARGS((tTree node, int line));

tTree CombineACF
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 97 "Transform.puma"
  {
# line 98 "Transform.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kACF_EMPTY) {
# line 102 "Transform.puma"
   return list2;

  }
  if (list1->Kind == kACF_LIST) {
# line 106 "Transform.puma"
  {
# line 107 "Transform.puma"
   if (! ((list1->ACF_LIST.Next == NoTree))) goto yyL3;
  {
# line 108 "Transform.puma"
 list1->ACF_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 112 "Transform.puma"
  {
# line 113 "Transform.puma"
 list1->ACF_LIST.Next = list2; 
  }
   return list1;

  }
# line 117 "Transform.puma"
  {
# line 118 "Transform.puma"
 list1->ACF_LIST.Next = CombineACF (list1->ACF_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kACF_NODE)) {
# line 122 "Transform.puma"
   return mACF_LIST (list1, list2);

  }
# line 126 "Transform.puma"
  {
# line 127 "Transform.puma"
   failure_protocol (MODULE, "CombineACF", list1);
  }
   return NoTree;

}

tTree CompleteACFs
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
# line 133 "Transform.puma"
  {
# line 134 "Transform.puma"
   if (! ((list == NoTree))) goto yyL1;
  }
   return mACF_EMPTY ();
yyL1:;

  if (list->Kind == kACF_EMPTY) {
# line 138 "Transform.puma"
   return list;

  }
  if (list->Kind == kACF_LIST) {
# line 142 "Transform.puma"
  {
# line 143 "Transform.puma"
 list->ACF_LIST.Next = CompleteACFs (list->ACF_LIST.Next); 
  }
   return list;

  }
# line 147 "Transform.puma"
  {
# line 148 "Transform.puma"
   failure_protocol (MODULE, "CompleteACFS", list);
  }
   return list;

}

tTree CombineBTP
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 163 "Transform.puma"
  {
# line 164 "Transform.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTP_EMPTY) {
# line 168 "Transform.puma"
   return list2;

  }
  if (list1->Kind == kBTP_LIST) {
# line 172 "Transform.puma"
  {
# line 173 "Transform.puma"
   if (! ((list1->BTP_LIST.Next == NoTree))) goto yyL3;
  {
# line 174 "Transform.puma"
 list1->BTP_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 178 "Transform.puma"
  {
# line 179 "Transform.puma"
 list1->BTP_LIST.Next = list2; 
  }
   return list1;

  }
# line 183 "Transform.puma"
  {
# line 184 "Transform.puma"
 list1->BTP_LIST.Next = CombineBTP (list1->BTP_LIST.Next, list2); 
  }
   return list1;

  }
# line 188 "Transform.puma"
   return mBTP_LIST (list1, list2);

}

tTree CompleteBTPs
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
# line 194 "Transform.puma"
  {
# line 195 "Transform.puma"
   if (! ((list == NoTree))) goto yyL1;
  }
   return mBTP_EMPTY ();
yyL1:;

  if (list->Kind == kBTP_EMPTY) {
# line 199 "Transform.puma"
   return list;

  }
  if (list->Kind == kBTP_LIST) {
# line 203 "Transform.puma"
  {
# line 204 "Transform.puma"
 list->BTP_LIST.Next = CompleteBTPs (list->BTP_LIST.Next); 
  }
   return list;

  }
# line 208 "Transform.puma"
  {
# line 209 "Transform.puma"
   failure_protocol (MODULE, "CompleteBTPS", list);
  }
   return list;

}

tTree CombineBTV
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 224 "Transform.puma"
  {
# line 225 "Transform.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTV_EMPTY) {
# line 229 "Transform.puma"
   return list2;

  }
  if (list1->Kind == kBTV_LIST) {
# line 233 "Transform.puma"
  {
# line 234 "Transform.puma"
   if (! ((list1->BTV_LIST.Next == NoTree))) goto yyL3;
  {
# line 235 "Transform.puma"
 list1->BTV_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 239 "Transform.puma"
  {
# line 240 "Transform.puma"
 list1->BTV_LIST.Next = list2; 
  }
   return list1;

  }
# line 244 "Transform.puma"
  {
# line 245 "Transform.puma"
 list1->BTV_LIST.Next = CombineBTV (list1->BTV_LIST.Next, list2); 
  }
   return list1;

  }
# line 249 "Transform.puma"
   return mBTV_LIST (list1, list2);

}

tTree CompleteBTVs
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
# line 255 "Transform.puma"
  {
# line 256 "Transform.puma"
   if (! ((list == NoTree))) goto yyL1;
  }
   return mBTV_EMPTY ();
yyL1:;

  if (list->Kind == kBTV_EMPTY) {
# line 260 "Transform.puma"
   return list;

  }
  if (list->Kind == kBTV_LIST) {
# line 264 "Transform.puma"
  {
# line 265 "Transform.puma"
 list->BTV_LIST.Next = CompleteBTVs (list->BTV_LIST.Next); 
  }
   return list;

  }
# line 269 "Transform.puma"
  {
# line 270 "Transform.puma"
   failure_protocol (MODULE, "CompleteBTVS", list);
  }
   return list;

}

tTree ReplaceACF
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kACF_LIST) {
# line 297 "Transform.puma"
  {
# line 301 "Transform.puma"
   if (! ((old->ACF_LIST.Elem->ACF_NODE.Label == 0))) goto yyL1;
  {
# line 303 "Transform.puma"
   if (! ((IsEmptyStmt (newelem)))) goto yyL1;
  }
  }
   return newnext;
yyL1:;

# line 316 "Transform.puma"
 {
  tTree elem1;
  {
# line 320 "Transform.puma"
   if (! ((IsEmptyStmt (newelem)))) goto yyL2;
  {
# line 322 "Transform.puma"

# line 324 "Transform.puma"
 

      elem1 = mACF_DUMMY ();
      SetACFNode (elem1, old->ACF_LIST.Elem->ACF_NODE.Label, old->ACF_LIST.Elem->ACF_NODE.Line);
      old->ACF_LIST.Elem = elem1;
      old->ACF_LIST.Next = newnext;
    
  }
  }
  {
   return old;
  }
 }
yyL2:;

# line 340 "Transform.puma"
  {
# line 341 "Transform.puma"
   if (! ((old->ACF_LIST.Elem == newelem))) goto yyL3;
  {
# line 342 "Transform.puma"
 old->ACF_LIST.Next = newnext; 
  }
  }
   return old;
yyL3:;

  if (Tree_IsType (newelem, kACF_NODE)) {
# line 352 "Transform.puma"
 {
  int save_label;
  {
# line 355 "Transform.puma"

# line 357 "Transform.puma"
 save_label = old->ACF_LIST.Elem->ACF_NODE.Label;  
       old->ACF_LIST.Elem->ACF_NODE.Label  = 0;          
       if (save_label != 0) newelem->ACF_NODE.Label  = save_label;
       newelem->ACF_NODE.Line   = old->ACF_LIST.Elem->ACF_NODE.Line;
       old->ACF_LIST.Elem = newelem;
       old->ACF_LIST.Next = newnext;   
     
  }
  {
   return old;
  }
 }

  }
  if (newelem->Kind == kACF_LIST) {
# line 373 "Transform.puma"
 {
  int save_label;
  {
# line 376 "Transform.puma"

# line 378 "Transform.puma"
 save_label = old->ACF_LIST.Elem->ACF_NODE.Label;  
      old->ACF_LIST.Elem->ACF_NODE.Label = 0;           
      ReplaceACF_Set (newelem, old->ACF_LIST.Elem->ACF_NODE.Line, save_label);
      if (save_label != 0) newelem->ACF_LIST.Elem->ACF_NODE.Label  = save_label;
    
  }
  {
   return CombineACF (newelem, newnext);
  }
 }

  }
  }
# line 386 "Transform.puma"
  {
# line 388 "Transform.puma"
   failure2_protocol (MODULE, "ReplaceACF", old, newelem);
  }
   return NoTree;

}

static bool IsEmptyStmt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 395 "Transform.puma"
  {
# line 397 "Transform.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

  if (t->Kind == kACF_EMPTY) {
# line 400 "Transform.puma"
   return true;

  }
  return false;
}

static void ReplaceACF_Set
# if defined __STDC__ | defined __cplusplus
(register tTree newelem, register int line, register int save_label)
# else
(newelem, line, save_label)
 register tTree newelem;
 register int line;
 register int save_label;
# endif
{
  if (newelem->Kind == kACF_LIST) {
# line 411 "Transform.puma"
  {
# line 413 "Transform.puma"
 newelem->ACF_LIST.Elem->ACF_NODE.Line = line;
     if (newelem->ACF_LIST.Elem->ACF_NODE.Label == save_label) newelem->ACF_LIST.Elem->ACF_NODE.Label = 0;
     if (newelem->ACF_LIST.Next != NoTree)
        ReplaceACF_Set (newelem->ACF_LIST.Next, line, save_label);
   
  }
   return;

  }
;
}

tTree ReplaceUNIT
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kUNIT_LIST) {
# line 432 "Transform.puma"
  {
# line 434 "Transform.puma"
   if (! ((newelem == NoTree))) goto yyL1;
  }
   return old->UNIT_LIST.Next;
yyL1:;

  if (Tree_IsType (newelem, kUNIT_NODE)) {
# line 438 "Transform.puma"
  {
# line 442 "Transform.puma"
 old->UNIT_LIST.Elem = newelem;
     old->UNIT_LIST.Next = newnext;
   
  }
   return old;

  }
  }
# line 448 "Transform.puma"
  {
# line 450 "Transform.puma"
   failure2_protocol (MODULE, "ReplaceUNIT", newelem, newnext);
  }
   return NoTree;

}

tTree ReplaceDECL
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kDECL_LIST) {
# line 466 "Transform.puma"
  {
# line 467 "Transform.puma"
   if (! ((newelem == NoTree))) goto yyL1;
  }
   return old->DECL_LIST.Next;
yyL1:;

  if (Tree_IsType (newelem, kDECL_NODE)) {
# line 471 "Transform.puma"
  {
# line 476 "Transform.puma"
 old->DECL_LIST.Elem = newelem;
     old->DECL_LIST.Next = newnext;
   
  }
   return old;

  }
  if (newelem->Kind == kDECL_LIST) {
# line 482 "Transform.puma"
 {
  tTree hdecl;
  {
# line 485 "Transform.puma"

# line 487 "Transform.puma"
 hdecl = newelem;
     while (hdecl->DECL_LIST.Next != NoTree)
         hdecl = hdecl->DECL_LIST.Next;
     hdecl->DECL_LIST.Next = newnext;
   
  }
  {
   return newelem;
  }
 }

  }
  }
# line 495 "Transform.puma"
  {
# line 496 "Transform.puma"
   failure2_protocol (MODULE, "ReplaceDECL", newelem, newnext);
  }
   return NoTree;

}

tTree ReplaceBTP
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kBTP_LIST) {
# line 512 "Transform.puma"
  {
# line 513 "Transform.puma"
   if (! ((newelem == NoTree))) goto yyL1;
  }
   return old->BTP_LIST.Next;
yyL1:;

  if (Tree_IsType (newelem, kBT_PARAM)) {
# line 517 "Transform.puma"
  {
# line 522 "Transform.puma"
 old->BTP_LIST.Elem = newelem;
     old->BTP_LIST.Next = newnext;
   
  }
   return old;

  }
  if (newelem->Kind == kBTP_LIST) {
# line 528 "Transform.puma"
 {
  tTree hdecl;
  {
# line 531 "Transform.puma"

# line 533 "Transform.puma"
 hdecl = newelem;
     while (hdecl->BTP_LIST.Next != NoTree)
         hdecl = hdecl->BTP_LIST.Next;
     hdecl->BTP_LIST.Next = newnext;
   
  }
  {
   return newelem;
  }
 }

  }
  }
# line 541 "Transform.puma"
  {
# line 542 "Transform.puma"
   failure2_protocol (MODULE, "ReplaceBTP", newelem, newnext);
  }
   return NoTree;

}

tTree AppendDECLS
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree newlist)
# else
(t, newlist)
 register tTree t;
 register tTree newlist;
# endif
{
# line 554 "Transform.puma"
  {
# line 555 "Transform.puma"
   if (! (newlist == NoTree)) goto yyL1;
  {
# line 556 "Transform.puma"
   printf ("AppendDECLS: newlist = NoTree\n");
# line 557 "Transform.puma"
   exit (- 1);
  }
  }
   return t;
yyL1:;

# line 561 "Transform.puma"
  {
# line 562 "Transform.puma"
   if (! ((t == NoTree))) goto yyL2;
  }
   return newlist;
yyL2:;

  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Elem->Kind == kSTMT_FUNC_DECL) {
  if (newlist->Kind == kDECL_LIST) {
  if (newlist->DECL_LIST.Elem->Kind == kSTMT_FUNC_DECL) {
# line 566 "Transform.puma"
  {
# line 567 "Transform.puma"
 t->DECL_LIST.Next = AppendDECLS (t->DECL_LIST.Next, newlist); 
  }
   return t;

  }
  }
  }
  if (newlist->Kind == kDECL_LIST) {
# line 571 "Transform.puma"
  {
# line 575 "Transform.puma"
   if (! ((DeclLevel (newlist->DECL_LIST.Elem) < DeclLevel (t->DECL_LIST.Elem)))) goto yyL4;
  }
   return AppendDECLS (newlist, t);
yyL4:;

  }
# line 580 "Transform.puma"
  {
# line 581 "Transform.puma"
 t->DECL_LIST.Next = AppendDECLS (t->DECL_LIST.Next, newlist); 
  }
   return t;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 585 "Transform.puma"
   return newlist;

  }
 yyAbort ("AppendDECLS");
}

static int DeclLevel
# if defined __STDC__ | defined __cplusplus
(register tTree decl)
# else
(decl)
 register tTree decl;
# endif
{
  if (decl->Kind == kIMPLICIT_DECL) {
# line 591 "Transform.puma"
   return 0;

  }
  if (decl->Kind == kUSE_DECL) {
# line 592 "Transform.puma"
   return 1;

  }
  if (decl->Kind == kDATA_DECL) {
# line 593 "Transform.puma"
   return 4;

  }
  if (decl->Kind == kSTMT_FUNC_DECL) {
# line 594 "Transform.puma"
   return 5;

  }
# line 595 "Transform.puma"
   return 2;

}

tTree ExpToVarParam
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kVAR_EXP) {
# line 605 "Transform.puma"
   return (mVAR_PARAM (exp->VAR_EXP.V));

  }
# line 609 "Transform.puma"
   return (mVAR_PARAM (mADDR (exp)));

}

tTree ExpListToVarParamList
# if defined __STDC__ | defined __cplusplus
(register tTree explist)
# else
(explist)
 register tTree explist;
# endif
{
  if (explist->Kind == kBTE_LIST) {
# line 615 "Transform.puma"
   return mBTP_LIST (ExpToVarParam (explist->BTE_LIST.Elem), ExpListToVarParamList (explist->BTE_LIST.Next));

  }
  if (explist->Kind == kBTE_EMPTY) {
# line 620 "Transform.puma"
   return mBTP_EMPTY ();

  }
 yyAbort ("ExpListToVarParamList");
}

tTree VarParamToExp
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 627 "Transform.puma"
   return param->VAR_PARAM.V->ADDR.E;

  }
# line 632 "Transform.puma"
   return mVAR_EXP (param->VAR_PARAM.V);

  }
# line 637 "Transform.puma"
  {
# line 638 "Transform.puma"
   failure_protocol (MODULE, "VarParamToExp", param);
  }
   return param;

}

void SetVarParamAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree p, register int intent)
# else
(p, intent)
 register tTree p;
 register int intent;
# endif
{
  if (p->Kind == kVAR_PARAM) {
# line 648 "Transform.puma"
  {
# line 650 "Transform.puma"
 p->VAR_PARAM.intent = intent; 
  }
   return;

  }
# line 653 "Transform.puma"
  {
# line 655 "Transform.puma"
   failure_protocol (MODULE, "SetVarParamAttributes", p);
  }
   return;

;
}

tTree GetStringParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
# line 664 "Transform.puma"

char sname [100];
int  slength;
tTree param, paramlist;

# line 670 "Transform.puma"
  {
# line 671 "Transform.puma"
 GetString (name, sname);
    slength = strlen (sname);
    param = ExpToVarParam (MakeConstant (slength));
    paramlist = mBTP_LIST (param, NoTree);
    param = mCONST_EXP (mSTRING_CONSTANT (PutString (sname, slength)));
    param = ExpToVarParam (param);
    paramlist = mBTP_LIST (param, paramlist);
  
  }
   return paramlist;

}

tTree AppendParam
# if defined __STDC__ | defined __cplusplus
(register tTree plist, register tTree param)
# else
(plist, param)
 register tTree plist;
 register tTree param;
# endif
{
  if (plist->Kind == kBTP_EMPTY) {
# line 684 "Transform.puma"
   return mBTP_LIST (param, plist);

  }
  if (plist->Kind == kBTP_LIST) {
# line 688 "Transform.puma"
  {
# line 689 "Transform.puma"
 plist->BTP_LIST.Next = AppendParam (plist->BTP_LIST.Next, param); 
  }
   return plist;

  }
 yyAbort ("AppendParam");
}

tTree ConcatParams
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 695 "Transform.puma"
  {
# line 696 "Transform.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTP_EMPTY) {
# line 700 "Transform.puma"
   return list2;

  }
  if (list1->Kind == kBTP_LIST) {
# line 704 "Transform.puma"
  {
# line 705 "Transform.puma"
 list1->BTP_LIST.Next = ConcatParams (list1->BTP_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kBT_PARAM)) {
# line 709 "Transform.puma"
   return mBTP_LIST (list1, list2);

  }
# line 713 "Transform.puma"
  {
# line 714 "Transform.puma"
   failure2_protocol (MODULE, "ConcatParams", list1, list2);
  }
   return list2;

}

tTree ConcatVars
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
# line 720 "Transform.puma"
  {
# line 721 "Transform.puma"
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTV_EMPTY) {
# line 725 "Transform.puma"
   return list2;

  }
  if (list1->Kind == kBTV_LIST) {
# line 729 "Transform.puma"
  {
# line 730 "Transform.puma"
 list1->BTV_LIST.Next = ConcatVars (list1->BTV_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kBT_VAR)) {
# line 734 "Transform.puma"
   return mBTV_LIST (list1, list2);

  }
# line 738 "Transform.puma"
  {
# line 739 "Transform.puma"
   failure2_protocol (MODULE, "ConcatVars", list1, list2);
  }
   return list2;

}

tTree AppendBody
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
  if (list1->Kind == kACF_EMPTY) {
# line 754 "Transform.puma"
  {
# line 755 "Transform.puma"
   if (! ((list2 == NoTree))) goto yyL1;
  }
   return list1;
yyL1:;

  if (list2->Kind == kACF_LIST) {
# line 759 "Transform.puma"
  {
# line 760 "Transform.puma"
 list2->ACF_LIST.Next = AppendBody (list1, list2->ACF_LIST.Next); 
  }
   return list2;

  }
  if (Tree_IsType (list2, kACF_NODE)) {
# line 764 "Transform.puma"
   return mACF_LIST (list2, list1);

  }
  }
  if (list1->Kind == kACF_LIST) {
# line 768 "Transform.puma"
  {
# line 769 "Transform.puma"
 list1->ACF_LIST.Next = AppendBody (list1->ACF_LIST.Next, list2); 
  }
   return list1;

  }
# line 773 "Transform.puma"
  {
# line 774 "Transform.puma"
   failure2_protocol (MODULE, "AppendBody", list1, list2);
  }
   return NoTree;

}

tTree ComposeNewACF
# if defined __STDC__ | defined __cplusplus
(register tTree pre, register tTree s, register tTree post)
# else
(pre, s, post)
 register tTree pre;
 register tTree s;
 register tTree post;
# endif
{
# line 780 "Transform.puma"
  {
# line 782 "Transform.puma"
   if (! ((pre == NoTree))) goto yyL1;
  {
# line 783 "Transform.puma"
   if (! ((post == NoTree))) goto yyL1;
  }
  }
   return s;
yyL1:;

# line 788 "Transform.puma"
   return CombineACF (pre, CombineACF (s, post));

}

tTree MakeIntegerType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
# line 795 "Transform.puma"
   return mINTEGER_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeRealType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
# line 801 "Transform.puma"
   return mREAL_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeLogicalType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
# line 807 "Transform.puma"
   return mBOOLEAN_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeStringType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
# line 813 "Transform.puma"
   return mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeStmtList
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_EMPTY) {
# line 825 "Transform.puma"
   return stmt;

  }
  if (stmt->Kind == kACF_LIST) {
# line 830 "Transform.puma"
   return stmt;

  }
  if (Tree_IsType (stmt, kACF_NODE)) {
# line 835 "Transform.puma"
   return mACF_LIST (stmt, mACF_EMPTY ());

  }
# line 840 "Transform.puma"
  {
# line 841 "Transform.puma"
   failure_protocol (MODULE, "MakeStmtList", stmt);
  }
   return NoTree;

}

tTree MakeVarDeclA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register tTree val)
# else
(id, n, val)
 register tIdent id;
 String n;
 register tTree val;
# endif
{
# line 855 "Transform.puma"

char hstring[250];
tIdent hid;

# line 860 "Transform.puma"
  {
# line 861 "Transform.puma"
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_DECL (hid, 0, val));

}

tTree MakeVarDeclAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no, register tTree val)
# else
(id, n, no, val)
 register tIdent id;
 String n;
 register int no;
 register tTree val;
# endif
{
# line 878 "Transform.puma"

char hstring[250];
tIdent hid;

# line 883 "Transform.puma"
  {
# line 884 "Transform.puma"
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_DECL (hid, 0, val));

}

tTree MakeUsedVarA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n)
# else
(id, n)
 register tIdent id;
 String n;
# endif
{
# line 901 "Transform.puma"

char hstring[250];
tIdent hid;
tTree v;

# line 907 "Transform.puma"
  {
# line 908 "Transform.puma"
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
     v = mVAR_OBJ (0, hid);
     v->VAR_OBJ.Object = NoObject;
   
  }
   return mUSED_VAR (v);

}

tTree MakeUsedVarAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no)
# else
(id, n, no)
 register tIdent id;
 String n;
 register int no;
# endif
{
# line 927 "Transform.puma"

char hstring[250];
tIdent hid;
tTree v;

# line 933 "Transform.puma"
  {
# line 934 "Transform.puma"
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
     v = mVAR_OBJ (0, hid);
     v->VAR_OBJ.Object = NoObject;
   
  }
   return mUSED_VAR (v);

}

tTree MakeVarParamDeclA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n)
# else
(id, n)
 register tIdent id;
 String n;
# endif
{
# line 953 "Transform.puma"

char hstring[250];
tIdent hid;

# line 958 "Transform.puma"
  {
# line 959 "Transform.puma"
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_PARAM_DECL (hid, 0, mDUMMY_TYPE ()));

}

tTree MakeVarParamDeclAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no)
# else
(id, n, no)
 register tIdent id;
 String n;
 register int no;
# endif
{
# line 976 "Transform.puma"

char hstring[250];
tIdent hid;

# line 981 "Transform.puma"
  {
# line 982 "Transform.puma"
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_PARAM_DECL (hid, 0, mDUMMY_TYPE ()));

}

tTree MakeVarSuffixA
# if defined __STDC__ | defined __cplusplus
(register tTree var, String n)
# else
(var, n)
 register tTree var;
 String n;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 1000 "Transform.puma"
 {
  tTree v;
  {
# line 1002 "Transform.puma"

# line 1004 "Transform.puma"
 v = mVAR_OBJ (0, MakeIdentSuffixA (var->USED_VAR.VARNAME->VAR_OBJ.Ident, n));
     v->VAR_OBJ.Object = NoObject;
   
  }
  {
   return mUSED_VAR (v);
  }
 }

  }
  if (var->Kind == kSELECTED_VAR) {
# line 1010 "Transform.puma"
 {
  tTree v;
  {
# line 1012 "Transform.puma"

# line 1014 "Transform.puma"
 v = mREC_COMP (MakeIdentSuffixA (var->SELECTED_VAR.SELECTOR->REC_COMP.Ident, n));
     v->REC_COMP.Object = NoObject;
   
  }
  {
   return mSELECTED_VAR (CopyTree (var->SELECTED_VAR.SELEC_VAR), v);
  }
 }

  }
# line 1020 "Transform.puma"
  {
# line 1022 "Transform.puma"
   failure_protocol (MODULE, "MakeVarSuffixA", var);
  }
   return NoTree;

}

tTree MakeVarSuffixAn
# if defined __STDC__ | defined __cplusplus
(register tTree var, String n, register int no)
# else
(var, n, no)
 register tTree var;
 String n;
 register int no;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 1028 "Transform.puma"
 {
  tTree v;
  {
# line 1030 "Transform.puma"

# line 1032 "Transform.puma"
 v = mVAR_OBJ (0, MakeIdentSuffixAn (var->USED_VAR.VARNAME->VAR_OBJ.Ident, n, no));
     v->VAR_OBJ.Object = NoObject;
   
  }
  {
   return mUSED_VAR (v);
  }
 }

  }
  if (var->Kind == kSELECTED_VAR) {
# line 1038 "Transform.puma"
 {
  tTree v;
  {
# line 1040 "Transform.puma"

# line 1042 "Transform.puma"
 v = mREC_COMP (MakeIdentSuffixAn (var->SELECTED_VAR.SELECTOR->REC_COMP.Ident, n, no));
     v->REC_COMP.Object = NoObject;
   
  }
  {
   return mSELECTED_VAR (CopyTree (var->SELECTED_VAR.SELEC_VAR), v);
  }
 }

  }
# line 1049 "Transform.puma"
  {
# line 1051 "Transform.puma"
   failure_protocol (MODULE, "MakeVarSuffixA", var);
  }
   return NoTree;

}

static tIdent MakeIdentSuffixA
# if defined __STDC__ | defined __cplusplus
(register tIdent ident, String n)
# else
(ident, n)
 register tIdent ident;
 String n;
# endif
{
# line 1063 "Transform.puma"

char   name[250];
tIdent new_id;

# line 1068 "Transform.puma"
  {
# line 1070 "Transform.puma"
   GetString (ident, name);
# line 1071 "Transform.puma"
   strcat (name, n);
  }
   return MakeIdent (name, strlen (name));

}

static tIdent MakeIdentSuffixAn
# if defined __STDC__ | defined __cplusplus
(register tIdent ident, String n, register int no)
# else
(ident, n, no)
 register tIdent ident;
 String n;
 register int no;
# endif
{
# line 1077 "Transform.puma"

char   name[250];
tIdent new_id;

# line 1082 "Transform.puma"
  {
# line 1084 "Transform.puma"
   GetString (ident, name);
# line 1085 "Transform.puma"
   sprintf (name, "%s%s%d", name, n, no);
  }
   return MakeIdent (name, strlen (name));

}

void SetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_OBJ) {
# line 1097 "Transform.puma"
  {
# line 1099 "Transform.puma"
 var->VAR_OBJ.Object = GetGlobalObject (var->VAR_OBJ.Ident); 
  }
   return;

  }
  if (var->Kind == kUSED_VAR) {
# line 1102 "Transform.puma"
  {
# line 1104 "Transform.puma"
   SetVarObject (var->USED_VAR.VARNAME);
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 1107 "Transform.puma"
  {
# line 1109 "Transform.puma"
   SetVarObject (var->INDEXED_VAR.IND_VAR);
  }
   return;

  }
# line 1112 "Transform.puma"
  {
# line 1114 "Transform.puma"
   failure_protocol (MODULE, "SetVarObject", var);
  }
   return;

;
}

void LineACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int line)
# else
(node, line)
 register tTree node;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
# line 1125 "Transform.puma"
  {
# line 1127 "Transform.puma"
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void BeginTransform ()
{
}

void CloseTransform ()
{
}
