# include "TempVars.h"
# include "yyTempVars.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 46 "TempVars.puma"


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Transform.h" 
# include "DefTable.h"

# include "Objects.h"      /* MakeNewObject */
# include "Rank.h"         /* MakeNewObject */
# include "MapDefs.h"      /* SetDistributions, SetAlignments */
# include "ChangeDefs.h"   /* MakeObjAllocatable              */
# include "Expressions.h"  /* MakeConstant                    */
# include "Descriptor.h"   /* IsTemplateDescriptor            */
# include "SemMap.h"       /* EvalObjDistribution             */

# include "Nesting.h"      /* access to outer loops           */

# define MODULE "TempVars"

     /***************************************************************
     *                                                              *
     *   Global Data needed for the creation of a temporary Var     *
     *                                                              *
     ***************************************************************/

static tTree allocate_stmt     = NoTree;
static tTree deallocate_stmt   = NoTree;

static tTree        reaching_allocate     = NoTree;

       /* new_decls stands for VAR_DECL + ALIGN/DISTRIBUTE */

static tTree temp_formals  [MAX_DIMENSIONS];

    /* data global needed for the allocate statement */

static tTree temp_actuals  [MAX_DIMENSIONS];

    /* data global needed for the distribute statement */

static int   temp_distribution_kind [MAX_DIMENSIONS];
static tTree temp_distribution_size [MAX_DIMENSIONS];

    /* data global needed for the new use of the temporary variable

      template_vardim[i] = 0 : no array dim is aligned to template dim i
      template_vardim[i] = k : array dim k is aligned to template dim i

    */

static int template_vardim [MAX_DIMENSIONS];
static int template_mult   [MAX_DIMENSIONS];
static int template_add    [MAX_DIMENSIONS];

    /* data global needed for alignment directive */

static tTree global_var;
static bool global_error;



static void yyExit () { Exit (1); }

void (* TempVars_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempVars, routine %s failed\n", yyFunction);
 TempVars_Exit ();
}

void MakeTempVar ARGS((tIdent name, pvar vard, tTree * yyP5, tTree * yyP4, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static tTree MakeVarDeclaration ARGS((tIdent name, int rank, pvar vard));
static tTree MakeDeferredShape ARGS((int n));
static tTree MakeVDType ARGS((pvar vard));
static void MakeMemoryStmts ARGS((tIdent id, int rank, pvar vard));
static tTree MakeExplicitShape ARGS((tTree exp));
static tTree MakeUsedVar ARGS((tIdent id, int rank));
static void PreCompute ARGS((pvar vard, int * temp_rank));
static tTree TranslateActual ARGS((tTree exp));
static void SetActual ARGS((int pos, tTree low, tTree up, tTree inc));
static void SetFormal ARGS((int pos, tTree low, tTree up));
static tTree MakeDistributeDecl ARGS((tIdent name, int new_rank, pvar vard));
static tTree MakeAlignDecl ARGS((tIdent name, int new_rank, pvar vard));
static void SetTemplateObject ARGS((tTree t, tDefinitions template));
static tTree MakeUse ARGS((tIdent id));
static void SetReachingInfo ARGS((tTree used_var, pvar vard));
static void GetDistribution ARGS((tDefinitions obj, tDefinitions * yyP6));
static void GetTemplateInfo ARGS((tTree reach_info, tTree * yyP8, tDefinitions * yyP7));
static bool IsAlignedDescriptor ARGS((pvar vard));

void MakeTempVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, pvar vard, register tTree * yyP5, register tTree * yyP4, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(name, vard, yyP5, yyP4, yyP3, yyP2, yyP1)
 register tIdent name;
 pvar vard;
 register tTree * yyP5;
 register tTree * yyP4;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 126 "TempVars.puma"
 {
  tTree var_decl;
  tTree dist_decl;
  tDefinitions new_obj;
  tTree used_var;
  int yyV1;
  {
# line 128 "TempVars.puma"

# line 129 "TempVars.puma"

# line 130 "TempVars.puma"

# line 131 "TempVars.puma"

# line 133 "TempVars.puma"
 global_error = false;

      global_var = vard->var_tree;

#ifdef DEBUG
      printf ("MakeTempVar for the following var descriptor:\n");
      PrintVarDescriptor (vard);
#endif

    
# line 144 "TempVars.puma"
   PreCompute (vard, & yyV1);
# line 146 "TempVars.puma"
 var_decl  = MakeVarDeclaration (name, yyV1, vard);

#ifdef DEBUG
      FileUnparse (stdout, var_decl); printf (" is the complete decl\n");
#endif

      

      new_obj = MakeNewObject (var_decl, GetCurrentUnitObject ());
      InsertEntry (new_obj);

      if (yyV1 > 0)
         MakeObjAllocatable (new_obj);   

      if (yyV1 == 0) 

         { dist_decl = NoTree;   
           MakeObjReplicated (new_obj);  
         }

       else if (vard->topology_rank < 1)

         { 

           dist_decl  = MakeDistributeDecl (name, yyV1, vard);

#ifdef DEBUG
           printf ("Distribution: ");
           FileUnparse (stdout, dist_decl);
           printf ("\n");
#endif

           SetDistributions (dist_decl, GetCurrentUnitObject());
           EvalObjDistribution (new_obj);

         }

       else if (!IsAlignedDescriptor (vard))

         { 

           dist_decl  = MakeDistributeDecl (name, yyV1, vard);

#ifdef DEBUG
           printf ("Distribution: ");
           FileUnparse (stdout, dist_decl);
           printf ("\n");
#endif

           SetDistributions (dist_decl, GetCurrentUnitObject());
           EvalObjDistribution (new_obj);

         }

       else

         { 

           dist_decl  = MakeAlignDecl (name, yyV1, vard);

#ifdef DEBUG
           printf ("Alignment: ");
           FileUnparse (stdout, dist_decl);
           printf ("\n");
#endif

           SetAlignments (dist_decl, GetCurrentUnitObject ());
           EvalObjDistribution (new_obj);

         }

      MakeMemoryStmts (name, yyV1, vard);

      used_var = MakeUsedVar (name, yyV1);

      SetReachingInfo (used_var, vard);

      if (global_error)
        { error_protocol ("could not create temporary");
          used_var = NoTree;
        }

    
  }
   * yyP5 = used_var;
   * yyP4 = var_decl;
   * yyP3 = dist_decl;
   * yyP2 = allocate_stmt;
   * yyP1 = deallocate_stmt;
   return;
 }

;
}

static tTree MakeVarDeclaration
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int rank, pvar vard)
# else
(name, rank, vard)
 register tIdent name;
 register int rank;
 pvar vard;
# endif
{
# line 241 "TempVars.puma"
  {
# line 243 "TempVars.puma"
   if (! ((rank == 0))) goto yyL1;
  }
   return mVAR_DECL (name, 0, MakeVDType (vard));
yyL1:;

# line 248 "TempVars.puma"
  {
# line 250 "TempVars.puma"
   if (! ((IsTemplateDescriptor (vard)))) goto yyL2;
  }
   return mTEMPLATE_DECL (name, 0, MakeDeferredShape (rank));
yyL2:;

# line 255 "TempVars.puma"
   return mVAR_DECL (name, 0, mARRAY_TYPE (MakeDeferredShape (rank), MakeVDType (vard)));

}

static tTree MakeDeferredShape
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
# line 269 "TempVars.puma"
 {
  tTree type_decl;
  tTree type_index;
  {
# line 271 "TempVars.puma"

# line 272 "TempVars.puma"

# line 274 "TempVars.puma"
 int i;
 
     type_decl = mSHAPE_EMPTY ();
 
     for (i=0; i<n; i++)
       {  type_index = mDEFERRED_SHAPE ();
          type_index->DEFERRED_SHAPE.Overlap = mOVERLAP_SPEC (0, 0, 0, 0);
          type_decl = mSHAPE_LIST (type_index, type_decl);
       }
   
  }
  {
   return type_decl;
  }
 }

}

static tTree MakeVDType
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 296 "TempVars.puma"
 {
  tTree result;
  {
# line 298 "TempVars.puma"

# line 300 "TempVars.puma"
 if (vard->type_kind == kINTEGER_TYPE)
       result = MakeIntegerType (vard->type_size);
     else if (vard->type_kind == kREAL_TYPE)
       result = MakeRealType (vard->type_size);
     else if (vard->type_kind == kBOOLEAN_TYPE)
       result = MakeLogicalType (vard->type_size);
     else if (vard->type_kind == kCOMPLEX_TYPE)
       result = mCOMPLEX_TYPE (MakeConstant (vard->type_size));
     else if (vard->type_kind == kSTRING_TYPE)
       result = mSTRING_TYPE (MakeConstant (0));
     else
       result = MakeIntegerType (default_int_size);
  
  }
  {
   return result;
  }
 }

}

static void MakeMemoryStmts
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int rank, pvar vard)
# else
(id, rank, vard)
 register tIdent id;
 register int rank;
 pvar vard;
# endif
{
# line 324 "TempVars.puma"
  {
# line 326 "TempVars.puma"
   if (! ((rank == 0))) goto yyL1;
  {
# line 328 "TempVars.puma"
   allocate_stmt = NoTree;
# line 329 "TempVars.puma"
   deallocate_stmt = NoTree;
# line 330 "TempVars.puma"
   reaching_allocate = NoTree;
  }
  }
   return;
yyL1:;

# line 333 "TempVars.puma"
 {
  tTree indexes;
  tTree stmt;
  {
# line 335 "TempVars.puma"
   if (! ((IsTemplateDescriptor (vard)))) goto yyL2;
  {
# line 337 "TempVars.puma"

# line 339 "TempVars.puma"

# line 341 "TempVars.puma"
 int i;

#ifdef DEBUG
     printf ("generate create_dsp/free_dsp, rank = %d\n", rank);
#endif

     stmt = MakeUse (id);
     stmt = mFREE_DSP_STMT (stmt, kTEMPLATE_DSP);
     stmt = mACF_BASIC (stmt);

     deallocate_stmt = stmt;

#ifdef DEBUG
     printf ("free_dsp : ");
     FileUnparse (stdout, deallocate_stmt);
     printf ("\n");
#endif

     indexes = mBTE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        indexes = mBTE_LIST (temp_formals[i], indexes);

     reaching_allocate = indexes;

     indexes = mSHAPE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        indexes = mSHAPE_LIST (MakeExplicitShape(temp_formals[i]), indexes);

     stmt = MakeUse (id);
     stmt = mCREATE_DSP_STMT (stmt, indexes, kTEMPLATE_DSP);
     stmt = mACF_BASIC (stmt);

     allocate_stmt = stmt;

#ifdef DEBUG
     printf ("create dsp : ");
     FileUnparse (stdout, allocate_stmt);
     printf ("\n");
#endif

   
  }
  }
   return;
 }
yyL2:;

# line 384 "TempVars.puma"
 {
  tTree indexes;
  tTree stmt;
  {
# line 386 "TempVars.puma"

# line 388 "TempVars.puma"

# line 390 "TempVars.puma"
 int i;

#ifdef DEBUG
     printf ("generate allocate/deallocate, rank = %d\n", rank);
#endif

     stmt = MakeUse (id);
     stmt = mFREE_DSP_STMT (stmt, kALLOCATE_DSP);
     stmt = mACF_BASIC (stmt);

     deallocate_stmt = mACF_LIST (stmt, NoTree);

     stmt = MakeUse (id);
     stmt = mBTP_LIST (mVAR_PARAM (stmt), mBTP_EMPTY());
     stmt = mDEALLOCATE_STMT (stmt, mDUMMY_VAR ());
     stmt = mACF_BASIC (stmt);

     deallocate_stmt = CombineACF (stmt, deallocate_stmt);
      
#ifdef DEBUG
     printf ("deallocate/free_dsp : ");
     FileUnparse (stdout, deallocate_stmt);
     printf ("\n");
#endif

     indexes = mBTE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        indexes = mBTE_LIST (temp_formals[i], indexes);

     reaching_allocate = indexes;

     stmt = MakeUse (id);
     stmt = mINDEXED_VAR (stmt, indexes);
     stmt = mBTP_LIST (mVAR_PARAM (stmt), mBTP_EMPTY());
     stmt = mALLOCATE_STMT (stmt, mDUMMY_VAR ());
     stmt = mACF_BASIC (stmt);

     allocate_stmt = mACF_LIST (stmt, NoTree);

     stmt = MakeUse (id);
     stmt = mCREATE_DSP_STMT (stmt, MakeDeferredShape (rank), kALLOCATE_DSP);
     stmt = mACF_BASIC (stmt);

     allocate_stmt = CombineACF (stmt, allocate_stmt);

#ifdef DEBUG
     printf ("allocate : ");
     FileUnparse (stdout, allocate_stmt);
     printf ("\n");
#endif

   
  }
   return;
 }

;
}

static tTree MakeExplicitShape
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
# line 452 "TempVars.puma"
 {
  tTree shape;
  {
# line 454 "TempVars.puma"

# line 456 "TempVars.puma"
 shape = mEXPLICIT_SHAPE (CopyTree(exp->SLICE_EXP.START), CopyTree(exp->SLICE_EXP.STOP));
     shape->EXPLICIT_SHAPE.Overlap = mOVERLAP_SPEC (0, 0, 0, 0);
   
  }
  {
   return shape;
  }
 }

  }
# line 463 "TempVars.puma"
  {
# line 464 "TempVars.puma"
   failure_protocol (MODULE, "MakeExplicitShape", exp);
  }
   return NoTree;

}

static tTree MakeUsedVar
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int rank)
# else
(id, rank)
 register tIdent id;
 register int rank;
# endif
{
# line 476 "TempVars.puma"
  {
# line 477 "TempVars.puma"
   if (! ((rank == 0))) goto yyL1;
  }
   return MakeUse (id);
yyL1:;

# line 481 "TempVars.puma"
 {
  tTree result;
  {
# line 483 "TempVars.puma"

# line 485 "TempVars.puma"
 int i;

     result = mBTE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        result = mBTE_LIST (temp_actuals[i], result);

     result = mINDEXED_VAR (MakeUse (id), result);

#ifdef DEBUG
     printf ("new temp_var access : ");
     FileUnparse (stdout, result);
     printf ("\n");
#endif

   
  }
  {
   return result;
  }
 }

}

static void PreCompute
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int * temp_rank)
# else
(vard, temp_rank)
 pvar vard;
 register int * temp_rank;
# endif
{
# line 516 "TempVars.puma"

int i, loop;
tTree a_low, a_up, a_inc;       /* actual   extension    */
tTree t_low, t_up, t_inc;       /* extension of temporay */

# line 522 "TempVars.puma"
 {
  int new_rank;
  {
# line 524 "TempVars.puma"

# line 526 "TempVars.puma"
 int   dist;
     tTree size;
     int   tdim;
     bool  is_aligned;

     new_rank = 0;

     if (!vard->expanded)
       failure_protocol (MODULE, "PreCompute, no expansion", NoTree);

     is_aligned = (vard->template_obj != NoObject);

     

     for (i=0; i < vard->template_rank; i++)
        template_vardim [i] = 0;
     
     for (i=0; i < vard->formal_rank; i++)

        { a_low = vard->actual_shape[i][0];
          a_up  = vard->actual_shape[i][1];
          a_inc = vard->actual_shape[i][2];

          if (a_low == a_up)

            { a_low  = TranslateActual (a_low);
              a_up   = a_low;
            }

          

          t_low  = vard->expand_shape[i][0];
          t_up   = vard->expand_shape[i][1];

          if (vard->topology_rank < 1)

             { dist = 0;
               size = NoTree;
             }

            else
             { dist = vard->distribution_kind [i];
               size = vard->distribution_size [i];
             }

          if (t_low == t_up)

             { 

               if ((dist != 0) && is_aligned)

                  { 

                  }

             }

            else

             { 

               SetFormal (new_rank, t_low, t_up);
               SetActual (new_rank, a_low, a_up, a_inc);

               if ((dist != 0) && is_aligned)

                  { 

                    tdim = vard->template_dim[i];

                    template_vardim [tdim-1] = new_rank + 1;
                    template_mult   [tdim-1] = vard->align_mult[i];
                    template_add    [tdim-1] = vard->align_add [i];
                  }

               temp_distribution_kind [new_rank] = dist;
               temp_distribution_size [new_rank] = size;
               new_rank++;

             }

        }; 

    
  }
   * temp_rank = new_rank;
   return;
 }

;
}

static tTree TranslateActual
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 622 "TempVars.puma"
  {
# line 623 "TempVars.puma"
   if (! ((exp == NoTree))) goto yyL1;
  }
   return exp;
yyL1:;

  if (exp->Kind == kLOOP_VAR) {
# line 627 "TempVars.puma"
   return mVAR_EXP (exp);

  }
# line 631 "TempVars.puma"
   return exp;

}

static void SetActual
# if defined __STDC__ | defined __cplusplus
(register int pos, register tTree low, register tTree up, register tTree inc)
# else
(pos, low, up, inc)
 register int pos;
 register tTree low;
 register tTree up;
 register tTree inc;
# endif
{
# line 645 "TempVars.puma"
  {
# line 646 "TempVars.puma"
   if (! ((low == up))) goto yyL1;
  {
# line 647 "TempVars.puma"
 temp_actuals[pos] = CopyTree (low); 
  }
  }
   return;
yyL1:;

# line 650 "TempVars.puma"
 {
  tTree inc1;
  {
# line 652 "TempVars.puma"

# line 654 "TempVars.puma"
 if (inc == NoTree)
         inc1 = mDUMMY_EXP ();
        else
         inc1 = CopyTree (inc);

      temp_actuals[pos] = mSLICE_EXP (CopyTree (low), CopyTree (up), inc1);
    
  }
   return;
 }

;
}

static void SetFormal
# if defined __STDC__ | defined __cplusplus
(register int pos, register tTree low, register tTree up)
# else
(pos, low, up)
 register int pos;
 register tTree low;
 register tTree up;
# endif
{
# line 675 "TempVars.puma"
  {
# line 676 "TempVars.puma"
   if (! ((low == up))) goto yyL1;
  {
# line 677 "TempVars.puma"
   if (! ((low != NoTree))) goto yyL1;
  {
# line 678 "TempVars.puma"
   if (! ((TreeRank (low) > 0))) goto yyL1;
  {
# line 679 "TempVars.puma"
 global_error = true; 
  }
  }
  }
  }
   return;
yyL1:;

# line 682 "TempVars.puma"
 {
  tTree temp_low;
  tTree temp_up;
  int local;
  {
# line 684 "TempVars.puma"

# line 685 "TempVars.puma"

# line 687 "TempVars.puma"

# line 689 "TempVars.puma"
 local = 0;

      if (low == NoTree)
         temp_low = mBOUND_EXP (global_var, pos+1, 0, local);
        else
         temp_low = CopyTree (low);

      if (up == NoTree)
         temp_up = mBOUND_EXP (global_var, pos+1, 1, local);
        else
         temp_up = CopyTree (up);

      temp_formals [pos] = mSLICE_EXP (temp_low,
                                       temp_up,
                                       mDUMMY_EXP ()); 
    
  }
   return;
 }

;
}

static tTree MakeDistributeDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int new_rank, pvar vard)
# else
(name, new_rank, vard)
 register tIdent name;
 register int new_rank;
 pvar vard;
# endif
{
# line 718 "TempVars.puma"
  {
# line 720 "TempVars.puma"
   if (! ((vard -> topology_rank == - 1))) goto yyL1;
  }
   return mDISTRIBUTE_DECL (name, 0, mREPL_DISTRIBUTION (0), mDEFAULT_PROCESSOR_ARRAY (mTOP_OBJ (DefaultId ())));
yyL1:;

# line 729 "TempVars.puma"
  {
# line 731 "TempVars.puma"
   if (! ((vard -> topology_rank <= 0))) goto yyL2;
  }
   return mDISTRIBUTE_DECL (name, 0, mREPL_DISTRIBUTION (0), mDEFAULT_PROCESSOR_ARRAY (mTOP_OBJ (DefaultId ())));
yyL2:;

# line 740 "TempVars.puma"
 {
  tTree mapping;
  tTree target;
  {
# line 742 "TempVars.puma"

# line 743 "TempVars.puma"

# line 745 "TempVars.puma"
 int i, rank, dist;
     tTree size;

     rank = vard->formal_rank;

     mapping = mDIST_EMPTY ();

     for (i=new_rank; i>0; i--)

       { dist = temp_distribution_kind [i-1];
         size = temp_distribution_size [i-1];
 
         if (size == NoTree) 
             size = mDUMMY_EXP();
           else
             size = CopyTree (size);

         if (dist == kBLOCK_DIM)
            mapping = mDIST_LIST (mBLOCK_DISTRIBUTION (size), mapping);
          else if (dist == kCYCLIC_DIM)
            mapping = mDIST_LIST (mCYCLIC_DISTRIBUTION (size), mapping);
          else
            mapping = mDIST_LIST (mSERIAL_DISTRIBUTION (), mapping);

       } 
  
   
# line 773 "TempVars.puma"
   target = mDEFAULT_PROCESSOR_ARRAY (mTOP_OBJ (DefaultId ()));
  }
  {
   return mDISTRIBUTE_DECL (name, 0, mNODE_DISTRIBUTION (0, mapping), target);
  }
 }

}

static tTree MakeAlignDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int new_rank, pvar vard)
# else
(name, new_rank, vard)
 register tIdent name;
 register int new_rank;
 pvar vard;
# endif
{
# line 792 "TempVars.puma"
 {
  tTree align_decl;
  {
# line 794 "TempVars.puma"

# line 796 "TempVars.puma"
 tTree source_list, spec_list, item;
    tIdent item_id, template_id;
    int i, vdim, template_rank;
    int mult, add;
    tObject template_obj;

#ifdef DEBUG
    printf ("MakeAlignDecl, rank = %d\n", new_rank);
#endif 

    source_list = mBTE_EMPTY ();
    item_id = MakeIdent ("I", 1);
    for (i=new_rank; i>0; i--)
      { item = mVAR_EXP (MakeUsedVarAn (item_id, "", i));
        source_list = mBTE_LIST (item, source_list);
      }

    template_obj  = vard->template_obj;
    template_rank = VarRank (template_obj);
    spec_list = mBTE_EMPTY();

    for (i=template_rank; i>0; i--)
      { vdim = template_vardim[i-1];
        mult = template_mult[i-1];
        add  = template_add [i-1];
        if (vdim > 0)
           { item = mVAR_EXP (MakeUsedVarAn (item_id, "", vdim));
             item = AddConstant (MultConstant (item, mult), add);
           }
          else
           item = mDUMMY_EXP();
        spec_list = mBTE_LIST (item, spec_list);
      }

    spec_list = mALIGN_SPEC (0, mTEMP_OBJ (DefaultId()), spec_list);
    SetTemplateObject (spec_list, template_obj);
    align_decl = mALIGN_DECL (name, 0, source_list, spec_list);
     
  
  }
  {
   return align_decl;
  }
 }

}

static void SetTemplateObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions template)
# else
(t, template)
 register tTree t;
 register tDefinitions template;
# endif
{
  if (t->Kind == kALIGN_SPEC) {
# line 841 "TempVars.puma"
  {
# line 843 "TempVars.puma"
   SetTemplateObject (t->ALIGN_SPEC.TEMPNAME, template);
  }
   return;

  }
  if (t->Kind == kTEMP_OBJ) {
# line 846 "TempVars.puma"
  {
# line 848 "TempVars.puma"
 t->TEMP_OBJ.Object = template;
      t->TEMP_OBJ.Ident  = template->Object.Ident;
    
  }
   return;

  }
;
}

static tTree MakeUse
# if defined __STDC__ | defined __cplusplus
(register tIdent id)
# else
(id)
 register tIdent id;
# endif
{
# line 863 "TempVars.puma"
 {
  tTree var;
  {
# line 865 "TempVars.puma"

# line 867 "TempVars.puma"
 var = mVAR_OBJ (0, id);
    var->VAR_OBJ.Object = GetGlobalObject (id);
  
  }
  {
   return mUSED_VAR (var);
  }
 }

}

static void SetReachingInfo
# if defined __STDC__ | defined __cplusplus
(register tTree used_var, pvar vard)
# else
(used_var, vard)
 register tTree used_var;
 pvar vard;
# endif
{
  if (used_var->Kind == kINDEXED_VAR) {
# line 881 "TempVars.puma"
  {
# line 883 "TempVars.puma"
   SetReachingInfo (used_var->INDEXED_VAR.IND_VAR, vard);
  }
   return;

  }
  if (used_var->Kind == kUSED_VAR) {
# line 886 "TempVars.puma"
  {
# line 888 "TempVars.puma"
   SetReachingInfo (used_var->USED_VAR.VARNAME, vard);
  }
   return;

  }
  if (used_var->Kind == kVAR_OBJ) {
# line 891 "TempVars.puma"
  {
# line 893 "TempVars.puma"
   if (! ((VarRank (used_var->VAR_OBJ.Object) == 0))) goto yyL3;
  {
# line 895 "TempVars.puma"
 used_var->VAR_OBJ.Reaching = NoTree; 
  }
  }
   return;
yyL3:;

# line 898 "TempVars.puma"
 {
  tDefinitions yyV1;
  {
# line 900 "TempVars.puma"
   if (! ((vard -> topology_rank < 1))) goto yyL4;
  {
# line 902 "TempVars.puma"
   GetDistribution (used_var->VAR_OBJ.Object, & yyV1);
# line 904 "TempVars.puma"
 used_var->VAR_OBJ.Reaching = mREACHING_INFO (reaching_allocate, reaching_allocate, yyV1, yyV1); 
  }
  }
   return;
 }
yyL4:;

# line 907 "TempVars.puma"
 {
  tDefinitions yyV1;
  {
# line 909 "TempVars.puma"
   if (! ((IsTemplateDescriptor (vard)))) goto yyL5;
  {
# line 911 "TempVars.puma"
   GetDistribution (used_var->VAR_OBJ.Object, & yyV1);
# line 913 "TempVars.puma"
 used_var->VAR_OBJ.Reaching = mREACHING_INFO (reaching_allocate, reaching_allocate, yyV1, yyV1); 
  }
  }
   return;
 }
yyL5:;

# line 916 "TempVars.puma"
 {
  tTree yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  {
# line 918 "TempVars.puma"
   GetTemplateInfo (vard -> reach_info, & yyV1, & yyV2);
# line 919 "TempVars.puma"
   GetDistribution (used_var->VAR_OBJ.Object, & yyV3);
# line 921 "TempVars.puma"
 used_var->VAR_OBJ.Reaching = mREACHING_INFO (reaching_allocate, yyV1, yyV3, yyV2); 
  }
   return;
 }

  }
# line 925 "TempVars.puma"
  {
# line 927 "TempVars.puma"
   failure_protocol (MODULE, "SetReachingInfo", used_var);
  }
   return;

;
}

static void GetDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP6)
# else
(obj, yyP6)
 register tDefinitions obj;
 register tDefinitions * yyP6;
# endif
{
  if (obj->Kind == kVarObject) {
# line 936 "TempVars.puma"
   * yyP6 = obj->VarObject.Dist;
   return;

  }
  if (obj->Kind == kTemplateObject) {
# line 939 "TempVars.puma"
   * yyP6 = obj->TemplateObject.Dist;
   return;

  }
# line 942 "TempVars.puma"
  {
# line 944 "TempVars.puma"
   failure_protocol (MODULE, "GetDistribuiton", obj->Object.decl);
  }
   * yyP6 = NoDefinitions;
   return;

;
}

static void GetTemplateInfo
# if defined __STDC__ | defined __cplusplus
(register tTree reach_info, register tTree * yyP8, register tDefinitions * yyP7)
# else
(reach_info, yyP8, yyP7)
 register tTree reach_info;
 register tTree * yyP8;
 register tDefinitions * yyP7;
# endif
{
# line 953 "TempVars.puma"
  {
# line 955 "TempVars.puma"
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   * yyP8 = NoTree;
   * yyP7 = NoDefinitions;
   return;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
# line 958 "TempVars.puma"
   * yyP8 = reach_info->REACHING_INFO.temp_allocate;
   * yyP7 = reach_info->REACHING_INFO.temp_distribution;
   return;

  }
# line 961 "TempVars.puma"
  {
# line 963 "TempVars.puma"
   failure_protocol (MODULE, "GetTemplateInfo", reach_info);
  }
   * yyP8 = NoTree;
   * yyP7 = NoDefinitions;
   return;

;
}

static bool IsAlignedDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 978 "TempVars.puma"
  {
# line 980 "TempVars.puma"
   if (! ((IsTemplateDescriptor (vard)))) goto yyL1;
  {
# line 981 "TempVars.puma"
   return false;
  }
  }
yyL1:;

# line 984 "TempVars.puma"
  {
# line 985 "TempVars.puma"
   if (! ((vard -> template_obj != NoObject))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

void BeginTempVars ()
{
}

void CloseTempVars ()
{
}
