# include "TempFunctions.h"
# include "yyTempFunctions.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 29 "TempFunctions.puma"


# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Objects.h"
# include "Intrinsics.h"
# include "Rank.h"
# include "Expansion.h"
# include "MoveControl.h" 
# include "Transform.h"             /*   CombineACF           */
# include "TempAssigns.h"           /*   MakeTemporaryStmt    */

# include "Types.h"                 /*   IsSameExpType        */
# include "Traverse.h"              /*   ReplaceAST           */

# define MODULE "TempFunctions"



static void yyExit () { Exit (1); }

void (* TempFunctions_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempFunctions, routine %s failed\n", yyFunction);
 TempFunctions_Exit ();
}

static void TempFunctions ARGS((tTree exp, tTree * yyP3, tTree * yyP2, tTree * yyP1));
void MakeTempFunctions ARGS((tTree t));
static bool StopMakeFuncStmts ARGS((tTree t));
static tTree DoMakeFuncStmts ARGS((tTree t));
static tTree BasicFuncStmts ARGS((tTree t));
static void AssignFuncStmts ARGS((tTree t, bool masked, tTree * yyP5, tTree * yyP4));
static bool HandledFunctionCall ARGS((tTree var, tTree exp));
static void ParallelFuncStmts ARGS((tTree t, bool where_mask, tTree * yyP7, tTree * yyP6));
static bool AllowedFunctionExpression ARGS((tTree exp));
static tTree MakeVarTree ARGS((tTree old, tTree new));

static void TempFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(exp, yyP3, yyP2, yyP1)
 register tTree exp;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{

  switch (exp->Kind) {
  case kADDR:
# line 65 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 69 "TempFunctions.puma"
   TempFunctions (exp->ADDR.E, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = MakeVarTree (exp, yyV1);
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kDUMMY_EXP:
# line 72 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kCONST_EXP:
# line 75 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kARRAY_EXP:
# line 78 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 80 "TempFunctions.puma"
   TempFunctions (exp->ARRAY_EXP.ELEMENTS, & yyV1, & yyV2, & yyV3);
# line 81 "TempFunctions.puma"
 exp->ARRAY_EXP.ELEMENTS = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kBOUND_EXP:
# line 84 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kRANK_EXP:
# line 87 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kSLICE_EXP:
# line 90 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  tTree yyV8;
  tTree yyV9;
  {
# line 93 "TempFunctions.puma"
   TempFunctions (exp->SLICE_EXP.START, & yyV1, & yyV2, & yyV3);
# line 94 "TempFunctions.puma"
   TempFunctions (exp->SLICE_EXP.STOP, & yyV4, & yyV5, & yyV6);
# line 95 "TempFunctions.puma"
   TempFunctions (exp->SLICE_EXP.INC, & yyV7, & yyV8, & yyV9);
# line 97 "TempFunctions.puma"
 exp->SLICE_EXP.START = yyV1; exp->SLICE_EXP.STOP = yyV4; exp->SLICE_EXP.INC = yyV7; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, CombineACF (yyV5, yyV8));
   * yyP1 = CombineACF (yyV9, CombineACF (yyV6, yyV3));
   return;
 }

  case kOP_EXP:
# line 100 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 102 "TempFunctions.puma"
   TempFunctions (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3);
# line 103 "TempFunctions.puma"
   TempFunctions (exp->OP_EXP.OPND2, & yyV4, & yyV5, & yyV6);
# line 104 "TempFunctions.puma"
 exp->OP_EXP.OPND1 = yyV1; exp->OP_EXP.OPND2 = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kOP1_EXP:
# line 107 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 108 "TempFunctions.puma"
   TempFunctions (exp->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3);
# line 109 "TempFunctions.puma"
 exp->OP1_EXP.OPND = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kPERM_EXP:
# line 112 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 113 "TempFunctions.puma"
   TempFunctions (exp->PERM_EXP.VAL, & yyV1, & yyV2, & yyV3);
# line 114 "TempFunctions.puma"
 exp->PERM_EXP.VAL = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kVAR_EXP:
# line 117 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 118 "TempFunctions.puma"
   TempFunctions (exp->VAR_EXP.V, & yyV1, & yyV2, & yyV3);
# line 119 "TempFunctions.puma"
 exp->VAR_EXP.V = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kDO_EXP:
# line 122 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 123 "TempFunctions.puma"
   TempFunctions (exp->DO_EXP.BODY, & yyV1, & yyV2, & yyV3);
# line 124 "TempFunctions.puma"
   if (! (((yyV2 != NoTree) || (yyV3 != NoTree)))) goto yyL12;
  {
# line 125 "TempFunctions.puma"
   error_protocol ("temporaries in implied do needed (function call)");
  }
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL12:;

# line 128 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 129 "TempFunctions.puma"
   TempFunctions (exp->DO_EXP.RANGE, & yyV1, & yyV2, & yyV3);
# line 130 "TempFunctions.puma"
 exp->DO_EXP.RANGE = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
# line 133 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 135 "TempFunctions.puma"
   if (! ((AllowedFunctionExpression (exp)))) goto yyL14;
  {
# line 137 "TempFunctions.puma"
   TempFunctions (exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
# line 138 "TempFunctions.puma"
 exp->FUNC_CALL_EXP.FUNC_PARAMS = yyV1; 
  }
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }
yyL14:;

# line 141 "TempFunctions.puma"
 {
  var_descriptor vard;
  bool found;
  tTree pre_stmts;
  tTree post_stmts;
  tTree tmp_var;
  tTree assign;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 144 "TempFunctions.puma"
  
# line 146 "TempFunctions.puma"

# line 147 "TempFunctions.puma"

# line 148 "TempFunctions.puma"

# line 149 "TempFunctions.puma"

# line 150 "TempFunctions.puma"

# line 151 "TempFunctions.puma"

# line 153 "TempFunctions.puma"
   TempFunctions (exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
# line 155 "TempFunctions.puma"
   GetExpDescriptor (exp, & found, & vard);
# line 156 "TempFunctions.puma"
   if (! ((found))) goto yyL15;
  {
# line 158 "TempFunctions.puma"
   NoExpansion (& vard);
# line 160 "TempFunctions.puma"
   MakeTemporaryStmt (exp, & vard, & pre_stmts, & tmp_var, & assign, & post_stmts);
# line 164 "TempFunctions.puma"
   pre_stmts = CombineACF (CombineACF (pre_stmts, yyV2), CombineACF (assign, yyV3));
  }
  }
   * yyP3 = mVAR_EXP (tmp_var);
   * yyP2 = pre_stmts;
   * yyP1 = post_stmts;
   return;
 }
yyL15:;

# line 168 "TempFunctions.puma"
  {
# line 170 "TempFunctions.puma"
   error_protocol ("could not create own statement for function call");
# line 171 "TempFunctions.puma"
   tree_protocol ("unresolved function call is : ", exp);
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kBTE_LIST:
# line 174 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 176 "TempFunctions.puma"
   TempFunctions (exp->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 177 "TempFunctions.puma"
   TempFunctions (exp->BTE_LIST.Next, & yyV4, & yyV5, & yyV6);
# line 179 "TempFunctions.puma"
 exp->BTE_LIST.Elem = yyV1; exp->BTE_LIST.Next = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kBTE_EMPTY:
# line 182 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kBTP_LIST:
# line 185 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 187 "TempFunctions.puma"
   TempFunctions (exp->BTP_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 188 "TempFunctions.puma"
   TempFunctions (exp->BTP_LIST.Next, & yyV4, & yyV5, & yyV6);
# line 189 "TempFunctions.puma"
 exp->BTP_LIST.Elem = yyV1; exp->BTP_LIST.Next = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kBTP_EMPTY:
# line 192 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kNAMED_PARAM:
# line 195 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 196 "TempFunctions.puma"
   TempFunctions (exp->NAMED_PARAM.VAL, & yyV1, & yyV2, & yyV3);
# line 197 "TempFunctions.puma"
 exp->NAMED_PARAM.VAL = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kVAR_PARAM:
# line 200 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 201 "TempFunctions.puma"
   TempFunctions (exp->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
# line 202 "TempFunctions.puma"
 exp->VAR_PARAM.V = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kNO_PARAM:
# line 205 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kPROC_PARAM:
# line 208 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kFUNC_PARAM:
# line 211 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kUSED_VAR:
# line 214 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kLOOP_VAR:
# line 217 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kPERM_VAR:
# line 220 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 221 "TempFunctions.puma"
   TempFunctions (exp->PERM_VAR.VAL, & yyV1, & yyV2, & yyV3);
# line 222 "TempFunctions.puma"
 exp->PERM_VAR.VAL = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kINDEXED_VAR:
# line 225 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 227 "TempFunctions.puma"
   TempFunctions (exp->INDEXED_VAR.IND_VAR, & yyV1, & yyV2, & yyV3);
# line 228 "TempFunctions.puma"
   TempFunctions (exp->INDEXED_VAR.IND_EXPS, & yyV4, & yyV5, & yyV6);
# line 229 "TempFunctions.puma"
 exp->INDEXED_VAR.IND_VAR = yyV1; exp->INDEXED_VAR.IND_EXPS = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kSUBSTRING_VAR:
# line 232 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 234 "TempFunctions.puma"
   TempFunctions (exp->SUBSTRING_VAR.IND_VAR, & yyV1, & yyV2, & yyV3);
# line 235 "TempFunctions.puma"
   TempFunctions (exp->SUBSTRING_VAR.IND_EXP, & yyV4, & yyV5, & yyV6);
# line 236 "TempFunctions.puma"
 exp->SUBSTRING_VAR.IND_VAR = yyV1; exp->SUBSTRING_VAR.IND_EXP = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kSELECTED_VAR:
# line 239 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 241 "TempFunctions.puma"
   TempFunctions (exp->SELECTED_VAR.SELEC_VAR, & yyV1, & yyV2, & yyV3);
# line 242 "TempFunctions.puma"
 exp->SELECTED_VAR.SELEC_VAR = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kBTV_LIST:
# line 245 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 247 "TempFunctions.puma"
   TempFunctions (exp->BTV_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 248 "TempFunctions.puma"
   TempFunctions (exp->BTV_LIST.Next, & yyV4, & yyV5, & yyV6);
# line 249 "TempFunctions.puma"
 exp->BTV_LIST.Elem = yyV1; exp->BTV_LIST.Next = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kBTV_EMPTY:
# line 252 "TempFunctions.puma"
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kDO_VAR:
# line 255 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 256 "TempFunctions.puma"
   TempFunctions (exp->DO_VAR.BODY, & yyV1, & yyV2, & yyV3);
# line 257 "TempFunctions.puma"
   if (! (((yyV2 != NoTree) || (yyV3 != NoTree)))) goto yyL34;
  {
# line 258 "TempFunctions.puma"
   error_protocol ("temporaries in implied do needed (function call)");
  }
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL34:;

# line 261 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 262 "TempFunctions.puma"
   TempFunctions (exp->DO_VAR.RANGE, & yyV1, & yyV2, & yyV3);
# line 263 "TempFunctions.puma"
 exp->DO_VAR.RANGE = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  }

# line 266 "TempFunctions.puma"
  {
# line 267 "TempFunctions.puma"
   failure_protocol (MODULE, "TempFunctions", exp);
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

void MakeTempFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 278 "TempFunctions.puma"
  {
# line 280 "TempFunctions.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeFuncStmts, DoMakeFuncStmts); 
  }
   return;

  }
# line 283 "TempFunctions.puma"
  {
# line 284 "TempFunctions.puma"
   failure_protocol (MODULE, "MakeTempFunctions", t);
  }
   return;

;
}

static bool StopMakeFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
# line 301 "TempFunctions.puma"
   return true;

  }
  if (t->Kind == kACF_WHERE) {
# line 307 "TempFunctions.puma"
   return true;

  }
# line 310 "TempFunctions.puma"
  {
# line 311 "TempFunctions.puma"
   return false;
  }

}

static tTree DoMakeFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_IF) {
# line 322 "TempFunctions.puma"
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 324 "TempFunctions.puma"

# line 326 "TempFunctions.puma"
   TempFunctions (t->ACF_IF.IF_EXP, & yyV1, & yyV2, & yyV3);
# line 328 "TempFunctions.puma"
 t->ACF_IF.IF_EXP = yyV1;  

     if (yyV2 != NoTree)
       { stmt_protocol ("function calls extracted");
         tree_protocol ("pre_stmts  : \n", yyV2);
       }

     if (yyV3 != NoTree)
       { error_protocol ("post statements for extracting functions in IF");
         tree_protocol ("post_stmts : \n", yyV3);
       }

     new = CombineACF (yyV2, mACF_LIST (t, NoTree));

   
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_WHILE) {
# line 346 "TempFunctions.puma"
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 348 "TempFunctions.puma"

# line 350 "TempFunctions.puma"
   TempFunctions (t->ACF_WHILE.WHILE_EXP, & yyV1, & yyV2, & yyV3);
# line 352 "TempFunctions.puma"
 t->ACF_WHILE.WHILE_EXP = yyV1;  

     if (yyV2 != NoTree)
       { stmt_protocol ("function calls extracted for WHILE");
         tree_protocol ("pre_stmts  : \n", yyV2);
         t->ACF_WHILE.WHILE_BODY = AppendBody (t->ACF_WHILE.WHILE_BODY, CopyTree (yyV2));
       }

     if (yyV3 != NoTree)
       { error_protocol ("post statements for extracting functions in WHILE");
         tree_protocol ("post_stmts : \n", yyV3);
       }

     new = CombineACF (yyV2, mACF_LIST (t, NoTree));

   
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_BASIC) {
# line 372 "TempFunctions.puma"
 {
  tTree new;
  {
# line 374 "TempFunctions.puma"

# line 376 "TempFunctions.puma"
   new = BasicFuncStmts (t);
# line 378 "TempFunctions.puma"
 if (new != t)
       tree_protocol ("function calls extracted : \n", new);
  
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_WHERE) {
# line 385 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 387 "TempFunctions.puma"
   ParallelFuncStmts (t, false, & yyV1, & yyV2);
# line 389 "TempFunctions.puma"
 if (yyV1 != NoTree)

      { stmt_protocol ("function calls extracted for WHERE");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
  {
   return CombineACF (yyV1, CombineACF (t, yyV2));
  }
 }

  }
  if (t->Kind == kACF_FORALL) {
# line 400 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 402 "TempFunctions.puma"
   ParallelFuncStmts (t, false, & yyV1, & yyV2);
# line 404 "TempFunctions.puma"
 if (yyV1 != NoTree)
      { stmt_protocol ("function calls extracted in FORALL");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
  {
   return CombineACF (yyV1, CombineACF (t, yyV2));
  }
 }

  }
  if (t->Kind == kACF_DO) {
# line 414 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 416 "TempFunctions.puma"
   TempFunctions (t->ACF_DO.DO_RANGE, & yyV1, & yyV2, & yyV3);
# line 417 "TempFunctions.puma"
 t->ACF_DO.DO_RANGE = yyV1; 
  }
  {
   return CombineACF (yyV2, CombineACF (t, yyV3));
  }
 }

  }
# line 421 "TempFunctions.puma"
   return t;

}

static tTree BasicFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 433 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 435 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS, & yyV1, & yyV2, & yyV3);
# line 436 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, & yyV4, & yyV5, & yyV6);
# line 438 "TempFunctions.puma"
 t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS = yyV1; t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS = yyV4; 
# line 440 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 441 "TempFunctions.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
  {
   return ComposeNewACF (yyV2, t, yyV3);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 446 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 448 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2, & yyV3);
# line 450 "TempFunctions.puma"
 t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS = yyV1; 
  }
  {
   return ComposeNewACF (yyV2, t, yyV3);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCOMP_IF_STMT) {
# line 455 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 457 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP, & yyV1, & yyV2, & yyV3);
# line 459 "TempFunctions.puma"
 t->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP = yyV1; 
  }
  {
   return ComposeNewACF (yyV2, t, yyV3);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 464 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 466 "TempFunctions.puma"
   AssignFuncStmts (t->ACF_BASIC.BASIC_STMT, false, & yyV1, & yyV2);
  }
  {
   return ComposeNewACF (yyV1, t, yyV2);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kPTR_ASSIGN_STMT) {
# line 471 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 473 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
# line 474 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_EXP, & yyV4, & yyV5, & yyV6);
# line 476 "TempFunctions.puma"
 t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_VAR = yyV1; t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_EXP = yyV4; 
# line 478 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 479 "TempFunctions.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
  {
   return ComposeNewACF (yyV2, t, yyV3);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 484 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 486 "TempFunctions.puma"
   TempFunctions (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, & yyV1, & yyV2, & yyV3);
# line 488 "TempFunctions.puma"
 t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS = yyV1; 
  }
  {
   return ComposeNewACF (yyV2, t, yyV3);
  }
 }

  }
# line 493 "TempFunctions.puma"
   return t;

  }
 yyAbort ("BasicFuncStmts");
}

static void AssignFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t, register bool masked, register tTree * yyP5, register tTree * yyP4)
# else
(t, masked, yyP5, yyP4)
 register tTree t;
 register bool masked;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (t->Kind == kASSIGN_STMT) {
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 515 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 517 "TempFunctions.puma"
   if (! ((! masked))) goto yyL1;
  {
# line 518 "TempFunctions.puma"
   if (! ((HandledFunctionCall (t->ASSIGN_STMT.ASSIGN_VAR, t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  {
# line 520 "TempFunctions.puma"
   TempFunctions (t->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
# line 521 "TempFunctions.puma"
   TempFunctions (t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV4, & yyV5, & yyV6);
# line 523 "TempFunctions.puma"
 t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS = yyV4; t->ASSIGN_STMT.ASSIGN_VAR = yyV1; 
# line 525 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 526 "TempFunctions.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
  }
  }
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }
yyL1:;

  }
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kTYPE_EXP) {
# line 529 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 531 "TempFunctions.puma"
   if (! ((! masked))) goto yyL2;
  {
# line 532 "TempFunctions.puma"
   if (! ((TreeRank (t->ASSIGN_STMT.ASSIGN_VAR) == TreeRank (t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
# line 533 "TempFunctions.puma"
   if (! ((IsSameExpType (t->ASSIGN_STMT.ASSIGN_VAR, t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
# line 535 "TempFunctions.puma"
   TempFunctions (t->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
# line 536 "TempFunctions.puma"
   TempFunctions (t->ASSIGN_STMT.ASSIGN_EXP->TYPE_EXP.ELEMENTS, & yyV4, & yyV5, & yyV6);
# line 538 "TempFunctions.puma"
 t->ASSIGN_STMT.ASSIGN_EXP->TYPE_EXP.ELEMENTS = yyV4; t->ASSIGN_STMT.ASSIGN_VAR = yyV1; 
# line 540 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 541 "TempFunctions.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
  }
  }
  }
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }
yyL2:;

  }
# line 546 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 548 "TempFunctions.puma"
   TempFunctions (t->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
# line 549 "TempFunctions.puma"
   TempFunctions (t->ASSIGN_STMT.ASSIGN_EXP, & yyV4, & yyV5, & yyV6);
# line 551 "TempFunctions.puma"
 t->ASSIGN_STMT.ASSIGN_VAR = yyV1; t->ASSIGN_STMT.ASSIGN_EXP = yyV4; 
# line 553 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 554 "TempFunctions.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
# line 557 "TempFunctions.puma"
  {
# line 559 "TempFunctions.puma"
   failure_protocol (MODULE, "AssignFuncStmts", t);
  }
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static bool HandledFunctionCall
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
# line 572 "TempFunctions.puma"
  {
# line 574 "TempFunctions.puma"
   if (! ((TreeRank (var) != TreeRank (exp)))) goto yyL1;
  {
# line 575 "TempFunctions.puma"
   return false;
  }
  }
yyL1:;

# line 578 "TempFunctions.puma"
  {
# line 580 "TempFunctions.puma"
   if (! ((! IsSameExpType (var, exp)))) goto yyL2;
  {
# line 581 "TempFunctions.puma"
   return false;
  }
  }
yyL2:;

  if (var->Kind == kINDEXED_VAR) {
# line 584 "TempFunctions.puma"
  {
# line 586 "TempFunctions.puma"
   if (! ((TreeRank (var) == 0))) goto yyL3;
  {
# line 587 "TempFunctions.puma"
   return false;
  }
  }
yyL3:;

  }
# line 590 "TempFunctions.puma"
   return true;

}

static void ParallelFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t, register bool where_mask, register tTree * yyP7, register tTree * yyP6)
# else
(t, where_mask, yyP7, yyP6)
 register tTree t;
 register bool where_mask;
 register tTree * yyP7;
 register tTree * yyP6;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 602 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 605 "TempFunctions.puma"
   TempFunctions (t->ACF_FORALL.FORALL_RANGE, & yyV1, & yyV2, & yyV3);
# line 607 "TempFunctions.puma"
 t->ACF_FORALL.FORALL_RANGE = yyV1; 
# line 609 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_FORALL.FORALL_BODY, where_mask, & yyV4, & yyV5);
# line 611 "TempFunctions.puma"
   ExpandNewStatements (yyV4, t, t->ACF_FORALL.Line);
# line 612 "TempFunctions.puma"
   ExpandNewStatements (yyV5, t, t->ACF_FORALL.Line);
# line 614 "TempFunctions.puma"
   yyV4 = CombineACF (yyV2, yyV4);
# line 615 "TempFunctions.puma"
   yyV5 = CombineACF (yyV5, yyV3);
  }
   * yyP7 = yyV4;
   * yyP6 = yyV5;
   return;
 }

  }
  if (t->Kind == kACF_WHERE) {
# line 618 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  {
# line 622 "TempFunctions.puma"
   TempFunctions (t->ACF_WHERE.WHERE_EXP, & yyV1, & yyV2, & yyV3);
# line 624 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_WHERE.TRUE_PART, true, & yyV4, & yyV5);
# line 625 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_WHERE.FALSE_PART, true, & yyV6, & yyV7);
# line 627 "TempFunctions.puma"
 t->ACF_WHERE.WHERE_EXP = yyV1; 
# line 629 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, CombineACF (yyV4, yyV6));
# line 630 "TempFunctions.puma"
   yyV3 = CombineACF (yyV7, CombineACF (yyV5, yyV3));
  }
   * yyP7 = yyV2;
   * yyP6 = yyV3;
   return;
 }

  }
  if (t->Kind == kACF_IF) {
# line 633 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  {
# line 637 "TempFunctions.puma"
   TempFunctions (t->ACF_IF.IF_EXP, & yyV1, & yyV2, & yyV3);
# line 641 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_IF.THEN_PART, false, & yyV4, & yyV5);
# line 642 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_IF.ELSE_PART, false, & yyV6, & yyV7);
# line 644 "TempFunctions.puma"
 t->ACF_IF.IF_EXP = yyV1; 
# line 646 "TempFunctions.puma"
   yyV2 = CombineACF (yyV2, CombineACF (yyV4, yyV6));
# line 647 "TempFunctions.puma"
   yyV3 = CombineACF (yyV7, CombineACF (yyV5, yyV3));
  }
   * yyP7 = yyV2;
   * yyP6 = yyV3;
   return;
 }

  }
  if (t->Kind == kACF_LIST) {
# line 650 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 652 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_LIST.Elem, where_mask, & yyV1, & yyV2);
# line 653 "TempFunctions.puma"
   ParallelFuncStmts (t->ACF_LIST.Next, where_mask, & yyV3, & yyV4);
# line 655 "TempFunctions.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 656 "TempFunctions.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   return;
 }

  }
  if (t->Kind == kACF_EMPTY) {
# line 659 "TempFunctions.puma"
   * yyP7 = NoTree;
   * yyP6 = NoTree;
   return;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 662 "TempFunctions.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 664 "TempFunctions.puma"
   AssignFuncStmts (t->ACF_BASIC.BASIC_STMT, where_mask, & yyV1, & yyV2);
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   return;
 }

  }
  }
# line 667 "TempFunctions.puma"
  {
# line 669 "TempFunctions.puma"
   failure_protocol (MODULE, "ParallelFuncStmts", t);
  }
   * yyP7 = NoTree;
   * yyP6 = NoTree;
   return;

;
}

static bool AllowedFunctionExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
# line 686 "TempFunctions.puma"
  {
# line 688 "TempFunctions.puma"
   if (! ((IsStmtCall (exp)))) goto yyL1;
  }
   return true;
yyL1:;

# line 691 "TempFunctions.puma"
  {
# line 693 "TempFunctions.puma"
   if (! ((IsF77Call (exp)))) goto yyL2;
  {
# line 694 "TempFunctions.puma"
   if (! ((! IsSerialCall (exp)))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 697 "TempFunctions.puma"
  {
# line 699 "TempFunctions.puma"
   if (! ((! IsIntrCall (exp)))) goto yyL3;
  {
# line 700 "TempFunctions.puma"
   return false;
  }
  }
yyL3:;

# line 703 "TempFunctions.puma"
  {
# line 705 "TempFunctions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL4;
  {
# line 706 "TempFunctions.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL4;
  {
# line 707 "TempFunctions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident != IsIdent ("MERGE")))) goto yyL4;
  }
  }
  }
   return true;
yyL4:;

# line 710 "TempFunctions.puma"
  {
# line 712 "TempFunctions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL5;
  {
# line 713 "TempFunctions.puma"
   if (! ((IntrFuncInquiry (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL5;
  {
# line 714 "TempFunctions.puma"
   if (! ((! IntrFuncShape (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL5;
  {
# line 715 "TempFunctions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident != IsIdent ("ACTIVE_NUM_PROCS")))) goto yyL5;
  }
  }
  }
  }
   return true;
yyL5:;

# line 718 "TempFunctions.puma"
  {
# line 720 "TempFunctions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL6;
  {
# line 721 "TempFunctions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SPREAD")))) goto yyL6;
  }
  }
   return true;
yyL6:;

# line 724 "TempFunctions.puma"
  {
# line 726 "TempFunctions.puma"
   if (! ((IsIntrCall (exp)))) goto yyL7;
  {
# line 727 "TempFunctions.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("TRANSPOSE")))) goto yyL7;
  }
  }
   return true;
yyL7:;

  }
  return false;
}

static tTree MakeVarTree
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree new)
# else
(old, new)
 register tTree old;
 register tTree new;
# endif
{
  if (old->Kind == kADDR) {
  if (new->Kind == kVAR_EXP) {
# line 736 "TempFunctions.puma"
   return new->VAR_EXP.V;

  }
# line 741 "TempFunctions.puma"
  {
# line 743 "TempFunctions.puma"
 old->ADDR.E = new; 
  }
   return old;

  }
 yyAbort ("MakeVarTree");
}

void BeginTempFunctions ()
{
}

void CloseTempFunctions ()
{
}
