# include "TempExp.h"
# include "yyTempExp.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 35 "TempExp.puma"


# include "protocol.h"

# include "Transform.h"       /* CombineACF                        */
# include "TreeOps.h"         /* CombineACF                        */

# include "Temporary.h"
# include "Distributions.h"
# include "Loops.h"           /*                                   */
# include "NewStatements.h"   /* ExpandNewStatements               */

# include "Nesting.h"         /* GetLoopId                         */
# include "ParNest.h"         /*                                   */
# include "Rank.h"            /*                                   */

# include "Expansion.h"      /* PrintableDescriptorVar            */
# include "Descriptor.h"      /* PrintableDescriptorVar            */
# include "Accepted.h"        /* PrintableDescriptorVar            */
# include "HomeDescriptor.h"  /* MakeHostDescriptor                */

# include "VarComm.h"         /* IsLocalVarRead, IsLocalVarWrite   */

# include "HomeTemps.h"       /* HomeTempVar                       */
# include "TempAssigns.h"
# include "ExpDescriptor.h"   /* SetExpType                        */

# include "IndShadow.h"       /* Indirect Shadows                  */

# define MODULE "TempExp"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* TempExp_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempExp, routine %s failed\n", yyFunction);
 TempExp_Exit ();
}

void MakeLocalExp ARGS((tTree exp, pvar home_vard, tTree * yyP3, tTree * yyP2, tTree * yyP1));
void MakeHostExp ARGS((tTree exp, tTree * yyP6, tTree * yyP5, tTree * yyP4));
void MakeReplExp ARGS((tTree exp, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static void LocalizeExp ARGS((tTree exp, pvar home_vard, tTree * yyP12, tTree * yyP11, tTree * yyP10));
static void LocalizeVarIndexes ARGS((tTree var, pvar home_vard, tTree * yyP14, tTree * yyP13));
void MakeLocalParams ARGS((tTree args, pvar home_vard, tTree * yyP16, tTree * yyP15));
void MakeLocalVarParam ARGS((tTree var, int intent, pvar home_vard, tTree * yyP19, tTree * yyP18, tTree * yyP17));
void MakeLocalVarAccess ARGS((tTree var, pvar home_vard, int intent, tTree * yyP22, tTree * yyP21, tTree * yyP20));
void MakeFullLocalIndexes ARGS((tTree var, pvar home_vard, tTree * yyP24, tTree * yyP23));
static bool IsSpreadAssign ARGS((pvar home_vard, tTree exp));
static void MakeSpreadDescriptor ARGS((pvar home, tTree exp, var_descriptor * yyP25));
static void SetParamExp ARGS((tTree param, tTree exp));
static void MakeLocalIndex ARGS((tTree index, pvar home, tTree * yyP28, tTree * yyP27, tTree * yyP26));
static void MyMakeTemporaryStmt ARGS((tTree exp, pvar vard, tTree * yyP32, tTree * yyP31, tTree * yyP30, tTree * yyP29));
static bool IsFullBroadcast ARGS((tTree var));
static int ImpliedDos ARGS(());
static bool ImpliedDoLoop ARGS((tTree loop));

void MakeLocalExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home_vard, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(exp, home_vard, yyP3, yyP2, yyP1)
 register tTree exp;
 pvar home_vard;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 90 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 92 "TempExp.puma"
   LocalizeExp (exp, home_vard, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = yyV1;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

;
}

void MakeHostExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(exp, yyP6, yyP5, yyP4)
 register tTree exp;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
# line 114 "TempExp.puma"
 {
  var_descriptor vard;
  int dist;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 116 "TempExp.puma"

# line 117 "TempExp.puma"

# line 119 "TempExp.puma"
   MakeHostDescriptor (& vard);
# line 121 "TempExp.puma"
   LocalizeExp (exp, & vard, & yyV1, & yyV2, & yyV3);
# line 123 "TempExp.puma"
 dist = TreeReadDistribution (yyV1);
    if ((dist < -1) || (dist > 0))
       { error_protocol ("failed to make host expression");
         tree_protocol  ("illegal expression is : ", exp);
         tree_protocol  ("pre statements : ", yyV2);
         tree_protocol  ("post statements : ", yyV3);
       }
  
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

;
}

void MakeReplExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(exp, yyP9, yyP8, yyP7)
 register tTree exp;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
# line 151 "TempExp.puma"
 {
  var_descriptor vard;
  int dist;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 153 "TempExp.puma"

# line 154 "TempExp.puma"

# line 156 "TempExp.puma"
   MakeReplicatedDescriptor (& vard);
# line 158 "TempExp.puma"
   LocalizeExp (exp, & vard, & yyV1, & yyV2, & yyV3);
# line 160 "TempExp.puma"
 dist = TreeReadDistribution (yyV1);

    if (dist != 0)

       { char msg[128];
         error_protocol ("failed to make replicated expression");
         sprintf (msg, "illegal expression (dist = %d) is : ", dist);
         tree_protocol  (msg, exp);
       }
  
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

;
}

static void LocalizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home_vard, register tTree * yyP12, register tTree * yyP11, register tTree * yyP10)
# else
(exp, home_vard, yyP12, yyP11, yyP10)
 register tTree exp;
 pvar home_vard;
 register tTree * yyP12;
 register tTree * yyP11;
 register tTree * yyP10;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 187 "TempExp.puma"
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kCONST_EXP:
# line 190 "TempExp.puma"
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kBOUND_EXP:
# line 193 "TempExp.puma"
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kRANK_EXP:
# line 196 "TempExp.puma"
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kOP_EXP:
# line 205 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 208 "TempExp.puma"
   LocalizeExp (exp->OP_EXP.OPND1, home_vard, & yyV1, & yyV2, & yyV3);
# line 209 "TempExp.puma"
   LocalizeExp (exp->OP_EXP.OPND2, home_vard, & yyV4, & yyV5, & yyV6);
# line 211 "TempExp.puma"
 exp->OP_EXP.OPND1 = yyV1; 
     exp->OP_EXP.OPND2 = yyV4;
   
  }
   * yyP12 = exp;
   * yyP11 = CombineACF (yyV2, yyV5);
   * yyP10 = CombineACF (yyV6, yyV3);
   return;
 }

  case kOP1_EXP:
# line 223 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 225 "TempExp.puma"
   LocalizeExp (exp->OP1_EXP.OPND, home_vard, & yyV1, & yyV2, & yyV3);
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
# line 234 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 242 "TempExp.puma"
   MakeLocalParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home_vard, & yyV1, & yyV2);
  }
   * yyP12 = exp;
   * yyP11 = yyV1;
   * yyP10 = yyV2;
   return;
 }

  case kTYPE_EXP:
# line 251 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 253 "TempExp.puma"
   LocalizeExp (exp->TYPE_EXP.ELEMENTS, home_vard, & yyV1, & yyV2, & yyV3);
# line 255 "TempExp.puma"
 exp->TYPE_EXP.ELEMENTS = yyV1; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kARRAY_EXP:
# line 264 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 266 "TempExp.puma"
   LocalizeExp (exp->ARRAY_EXP.ELEMENTS, home_vard, & yyV1, & yyV2, & yyV3);
# line 268 "TempExp.puma"
 exp->ARRAY_EXP.ELEMENTS = yyV1; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kBTE_LIST:
# line 271 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 273 "TempExp.puma"
   LocalizeExp (exp->BTE_LIST.Elem, home_vard, & yyV1, & yyV2, & yyV3);
# line 274 "TempExp.puma"
   LocalizeExp (exp->BTE_LIST.Next, home_vard, & yyV4, & yyV5, & yyV6);
# line 276 "TempExp.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 277 "TempExp.puma"
   yyV3 = CombineACF (yyV6, yyV3);
# line 279 "TempExp.puma"
 exp->BTE_LIST.Elem = yyV1; exp->BTE_LIST.Next = yyV4; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kBTE_EMPTY:
# line 282 "TempExp.puma"
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kSLICE_EXP:
# line 285 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  tTree yyV8;
  tTree yyV9;
  {
# line 287 "TempExp.puma"
   LocalizeExp (exp->SLICE_EXP.START, home_vard, & yyV1, & yyV2, & yyV3);
# line 288 "TempExp.puma"
   LocalizeExp (exp->SLICE_EXP.STOP, home_vard, & yyV4, & yyV5, & yyV6);
# line 289 "TempExp.puma"
   LocalizeExp (exp->SLICE_EXP.INC, home_vard, & yyV7, & yyV8, & yyV9);
# line 291 "TempExp.puma"
 exp->SLICE_EXP.START = yyV1; exp->SLICE_EXP.STOP = yyV4; exp->SLICE_EXP.INC = yyV7;  
# line 293 "TempExp.puma"
   yyV2 = CombineACF (yyV2, CombineACF (yyV5, yyV8));
# line 294 "TempExp.puma"
   yyV3 = CombineACF (yyV9, CombineACF (yyV6, yyV3));
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kDO_EXP:
# line 304 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 306 "TempExp.puma"
   LocalizeExp (exp->DO_EXP.RANGE, home_vard, & yyV1, & yyV2, & yyV3);
# line 308 "TempExp.puma"
   IncParNesting (exp);
# line 310 "TempExp.puma"
   LocalizeExp (exp->DO_EXP.BODY, home_vard, & yyV4, & yyV5, & yyV6);
# line 312 "TempExp.puma"
 exp->DO_EXP.BODY = yyV4; exp->DO_EXP.RANGE = yyV1; 
# line 314 "TempExp.puma"
   DecParNesting (exp);
# line 316 "TempExp.puma"
   ExpandNewStatements (yyV5, exp, 0);
# line 317 "TempExp.puma"
   ExpandNewStatements (yyV6, exp, 0);
# line 319 "TempExp.puma"
   yyV5 = CombineACF (yyV2, yyV5);
# line 320 "TempExp.puma"
   yyV6 = CombineACF (yyV6, yyV3);
  }
   * yyP12 = exp;
   * yyP11 = yyV5;
   * yyP10 = yyV6;
   return;
 }

  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kREMOTE_VAR) {
# line 323 "TempExp.puma"
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  }
# line 336 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 338 "TempExp.puma"
   if (! ((IsLocalVarRead (exp->VAR_EXP.V, home_vard)))) goto yyL15;
  {
# line 340 "TempExp.puma"
   LocalizeVarIndexes (exp->VAR_EXP.V, home_vard, & yyV1, & yyV2);
  }
  }
   * yyP12 = exp;
   * yyP11 = yyV1;
   * yyP10 = yyV2;
   return;
 }
yyL15:;

# line 343 "TempExp.puma"
 {
  var_descriptor yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 345 "TempExp.puma"
   if (! ((IsSpreadAssign (home_vard, exp)))) goto yyL16;
  {
# line 347 "TempExp.puma"
   MakeSpreadDescriptor (home_vard, exp, & yyV1);
# line 349 "TempExp.puma"
   SetExpType (exp, & yyV1);
# line 351 "TempExp.puma"
   tree_protocol ("non local spread assign, temp = ", PrintableDescriptorVar (& yyV1));
# line 354 "TempExp.puma"
   MyMakeTemporaryStmt (exp, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 356 "TempExp.puma"
   yyV3 = CombineACF (yyV3, yyV4);
# line 358 "TempExp.puma"
   tree_protocol ("non local spread assign : \n", yyV3);
  }
  }
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   * yyP10 = yyV5;
   return;
 }
yyL16:;

# line 371 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 373 "TempExp.puma"
   MakeLocalVarAccess (exp->VAR_EXP.V, home_vard, IntentIn, & yyV1, & yyV2, & yyV3);
# line 376 "TempExp.puma"
 exp->VAR_EXP.V = yyV1; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  }

# line 379 "TempExp.puma"
  {
# line 381 "TempExp.puma"
   error_protocol ("LocalizeExp failed, could not localize computation");
# line 382 "TempExp.puma"
   tree_protocol ("illegal term  : ", exp);
  }
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

;
}

static void LocalizeVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register tTree * yyP14, register tTree * yyP13)
# else
(var, home_vard, yyP14, yyP13)
 register tTree var;
 pvar home_vard;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
# line 394 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 396 "TempExp.puma"
   LocalizeVarIndexes (var->REMOTE_VAR.VAR, home_vard, & yyV1, & yyV2);
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }

  }
  if (var->Kind == kSELECTED_VAR) {
# line 399 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 401 "TempExp.puma"
   LocalizeVarIndexes (var->SELECTED_VAR.SELEC_VAR, home_vard, & yyV1, & yyV2);
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }

  }
  if (var->Kind == kINDEXED_VAR) {
# line 404 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 407 "TempExp.puma"
   LocalizeVarIndexes (var->INDEXED_VAR.IND_VAR, home_vard, & yyV1, & yyV2);
# line 408 "TempExp.puma"
   LocalizeExp (var->INDEXED_VAR.IND_EXPS, home_vard, & yyV3, & yyV4, & yyV5);
# line 410 "TempExp.puma"
 var->INDEXED_VAR.IND_EXPS = yyV3; 
  }
   * yyP14 = CombineACF (yyV1, yyV4);
   * yyP13 = CombineACF (yyV5, yyV2);
   return;
 }

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 413 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 416 "TempExp.puma"
   LocalizeVarIndexes (var->SUBSTRING_VAR.IND_VAR, home_vard, & yyV1, & yyV2);
# line 417 "TempExp.puma"
   LocalizeExp (var->SUBSTRING_VAR.IND_EXP, home_vard, & yyV3, & yyV4, & yyV5);
# line 419 "TempExp.puma"
 var->SUBSTRING_VAR.IND_EXP = yyV3; 
  }
   * yyP14 = CombineACF (yyV1, yyV4);
   * yyP13 = CombineACF (yyV5, yyV2);
   return;
 }

  }
  if (var->Kind == kUSED_VAR) {
# line 422 "TempExp.puma"
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

  }
  if (var->Kind == kLOOP_VAR) {
# line 425 "TempExp.puma"
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

  }
# line 428 "TempExp.puma"
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

;
}

void MakeLocalParams
# if defined __STDC__ | defined __cplusplus
(register tTree args, pvar home_vard, register tTree * yyP16, register tTree * yyP15)
# else
(args, home_vard, yyP16, yyP15)
 register tTree args;
 pvar home_vard;
 register tTree * yyP16;
 register tTree * yyP15;
# endif
{
  if (args->Kind == kBTP_LIST) {
# line 440 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 442 "TempExp.puma"
   MakeLocalParams (args->BTP_LIST.Elem, home_vard, & yyV1, & yyV2);
# line 443 "TempExp.puma"
   MakeLocalParams (args->BTP_LIST.Next, home_vard, & yyV3, & yyV4);
# line 445 "TempExp.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 446 "TempExp.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP16 = yyV1;
   * yyP15 = yyV2;
   return;
 }

  }
  if (args->Kind == kBTP_EMPTY) {
# line 449 "TempExp.puma"
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  if (args->Kind == kVAR_PARAM) {
  if (args->VAR_PARAM.V->Kind == kADDR) {
# line 452 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 454 "TempExp.puma"
   LocalizeExp (args->VAR_PARAM.V->ADDR.E, home_vard, & yyV1, & yyV2, & yyV3);
# line 455 "TempExp.puma"
   SetParamExp (args, yyV1);
  }
   * yyP16 = yyV2;
   * yyP15 = yyV3;
   return;
 }

  }
# line 458 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 461 "TempExp.puma"
   MakeLocalVarParam (args->VAR_PARAM.V, args->VAR_PARAM.intent, home_vard, & yyV1, & yyV2, & yyV3);
# line 464 "TempExp.puma"
 args->VAR_PARAM.V = yyV1; 
  }
   * yyP16 = yyV2;
   * yyP15 = yyV3;
   return;
 }

  }
  if (args->Kind == kNO_PARAM) {
# line 467 "TempExp.puma"
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  if (args->Kind == kFUNC_PARAM) {
# line 470 "TempExp.puma"
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  if (args->Kind == kPROC_PARAM) {
# line 473 "TempExp.puma"
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
# line 476 "TempExp.puma"
  {
# line 478 "TempExp.puma"
   error_protocol ("MakeLocalParams failed, could not localize arguments");
# line 479 "TempExp.puma"
   tree_protocol ("illegal arg  : ", args);
  }
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

;
}

void MakeLocalVarParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar home_vard, register tTree * yyP19, register tTree * yyP18, register tTree * yyP17)
# else
(var, intent, home_vard, yyP19, yyP18, yyP17)
 register tTree var;
 register int intent;
 pvar home_vard;
 register tTree * yyP19;
 register tTree * yyP18;
 register tTree * yyP17;
# endif
{
  if (var->Kind == kDO_VAR) {
# line 493 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 495 "TempExp.puma"
   tree_protocol ("I/O argument will be localized : ", var);
# line 499 "TempExp.puma"
   MakeLocalVarAccess (var, home_vard, intent, & yyV1, & yyV2, & yyV3);
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   * yyP17 = yyV3;
   return;
 }

  }
# line 505 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 507 "TempExp.puma"
   if (! ((TreeRank (var) == 0))) goto yyL2;
  {
# line 509 "TempExp.puma"
   tree_protocol ("scalar argument will be localized : ", var);
# line 511 "TempExp.puma"
   MakeLocalVarAccess (var, home_vard, intent, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   * yyP17 = yyV3;
   return;
 }
yyL2:;

# line 517 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 519 "TempExp.puma"
   if (! ((TreeRank (var) > 0))) goto yyL3;
  {
# line 523 "TempExp.puma"
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
   * yyP19 = var;
   * yyP18 = yyV1;
   * yyP17 = yyV2;
   return;
 }
yyL3:;

;
}

void MakeLocalVarAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register int intent, register tTree * yyP22, register tTree * yyP21, register tTree * yyP20)
# else
(var, home_vard, intent, yyP22, yyP21, yyP20)
 register tTree var;
 pvar home_vard;
 register int intent;
 register tTree * yyP22;
 register tTree * yyP21;
 register tTree * yyP20;
# endif
{
  if (var->Kind == kDO_VAR) {
# line 549 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 551 "TempExp.puma"
   LocalizeExp (var->DO_VAR.RANGE, home_vard, & yyV1, & yyV2, & yyV3);
# line 553 "TempExp.puma"
   IncParNesting (var);
# line 555 "TempExp.puma"
   MakeLocalVarAccess (var->DO_VAR.BODY, home_vard, intent, & yyV4, & yyV5, & yyV6);
# line 558 "TempExp.puma"
   DecParNesting (var);
# line 560 "TempExp.puma"
 var->DO_VAR.BODY = yyV4; var->DO_VAR.RANGE = yyV1; 
# line 562 "TempExp.puma"
   ExpandNewStatements (yyV5, var, 0);
# line 563 "TempExp.puma"
   ExpandNewStatements (yyV6, var, 0);
# line 565 "TempExp.puma"
   yyV5 = CombineACF (yyV2, yyV5);
# line 566 "TempExp.puma"
   yyV6 = CombineACF (yyV6, yyV3);
  }
   * yyP22 = var;
   * yyP21 = yyV5;
   * yyP20 = yyV6;
   return;
 }

  }
  if (var->Kind == kBTV_LIST) {
# line 569 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 571 "TempExp.puma"
   MakeLocalVarAccess (var->BTV_LIST.Elem, home_vard, intent, & yyV1, & yyV2, & yyV3);
# line 573 "TempExp.puma"
   MakeLocalVarAccess (var->BTV_LIST.Next, home_vard, intent, & yyV4, & yyV5, & yyV6);
# line 576 "TempExp.puma"
 var->BTV_LIST.Elem = yyV1;
     var->BTV_LIST.Next = yyV4; 
   
# line 580 "TempExp.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 581 "TempExp.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
   * yyP22 = var;
   * yyP21 = yyV2;
   * yyP20 = yyV3;
   return;
 }

  }
  if (var->Kind == kBTV_EMPTY) {
# line 584 "TempExp.puma"
   * yyP22 = var;
   * yyP21 = NoTree;
   * yyP20 = NoTree;
   return;

  }
  if (var->Kind == kREMOTE_VAR) {
# line 591 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 593 "TempExp.puma"
   LocalizeVarIndexes (var->REMOTE_VAR.VAR, home_vard, & yyV1, & yyV2);
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }

  }
# line 600 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 602 "TempExp.puma"
   if (! ((intent == IntentIn))) goto yyL5;
  {
# line 603 "TempExp.puma"
   if (! ((IsLocalVarRead (var, home_vard)))) goto yyL5;
  {
# line 605 "TempExp.puma"
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }
yyL5:;

# line 612 "TempExp.puma"
 {
  tTree pre_stmts;
  tTree post_stmts;
  {
# line 614 "TempExp.puma"

# line 615 "TempExp.puma"

# line 617 "TempExp.puma"
   if (! ((intent == IntentIn))) goto yyL6;
  {
# line 618 "TempExp.puma"
   if (! ((IsIndShadowVariable (var, home_vard)))) goto yyL6;
  {
# line 622 "TempExp.puma"
   MakeIndShadowGet (var, & pre_stmts, & post_stmts);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }
yyL6:;

# line 629 "TempExp.puma"
 {
  tTree pre_stmts;
  tTree post_stmts;
  {
# line 631 "TempExp.puma"

# line 632 "TempExp.puma"

# line 634 "TempExp.puma"
   if (! ((intent == IntentOut))) goto yyL7;
  {
# line 635 "TempExp.puma"
   if (! ((IsIndShadowVariable (var, home_vard)))) goto yyL7;
  {
# line 637 "TempExp.puma"
   MakeIndShadowPut (var, & pre_stmts, & post_stmts);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }
yyL7:;

# line 644 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 646 "TempExp.puma"
   if (! ((IsLocalVarWrite (var, home_vard)))) goto yyL8;
  {
# line 648 "TempExp.puma"
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }
yyL8:;

# line 655 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 657 "TempExp.puma"
   if (! ((IsLocalVarGlobal (var, home_vard)))) goto yyL9;
  {
# line 658 "TempExp.puma"
   if (! ((IsHostDescriptor (home_vard)))) goto yyL9;
  {
# line 662 "TempExp.puma"
   if (! ((IsFullBroadcast (var)))) goto yyL9;
  {
# line 664 "TempExp.puma"
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
  }
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }
yyL9:;

# line 674 "TempExp.puma"
 {
  tTree tmp_var;
  tTree pre_stmts;
  tTree post_stmts;
  var_descriptor new_vard;
  {
# line 676 "TempExp.puma"

# line 677 "TempExp.puma"

# line 678 "TempExp.puma"

# line 680 "TempExp.puma"
   if (! ((IsDescriptorVar (var)))) goto yyL10;
  {
# line 682 "TempExp.puma"

# line 684 "TempExp.puma"
   tree_protocol ("communication temporary needed for : ", var);
# line 686 "TempExp.puma"
   HomeTempVar (var, home_vard, & new_vard);
# line 687 "TempExp.puma"
   ParallelExpansion (& new_vard);
# line 691 "TempExp.puma"
   SetExpType (var, & new_vard);
# line 693 "TempExp.puma"
   tree_protocol ("new var access for localization ", PrintableDescriptorVar (& new_vard));
# line 696 "TempExp.puma"
   MakeTempVarStmt (var, intent, & new_vard, & tmp_var, & pre_stmts, & post_stmts);
  }
  }
   * yyP22 = tmp_var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }
yyL10:;

  if (var->Kind == kINDEXED_VAR) {
# line 700 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree tmp_var;
  tTree pre_stmts;
  tTree post_stmts;
  var_descriptor vard;
  {
# line 702 "TempExp.puma"
   MakeFullLocalIndexes (var->INDEXED_VAR.IND_EXPS, home_vard, & yyV1, & yyV2);
# line 704 "TempExp.puma"

# line 705 "TempExp.puma"

# line 706 "TempExp.puma"

# line 708 "TempExp.puma"

# line 712 "TempExp.puma"
   FullHomeTemp (var, home_vard, & vard);
# line 713 "TempExp.puma"
   ParallelExpansion (& vard);
# line 715 "TempExp.puma"
   tree_protocol ("new irregular var access for localization ", PrintableDescriptorVar (& vard));
# line 717 "TempExp.puma"
   MakeTempVarStmt (var, intent, & vard, & tmp_var, & pre_stmts, & post_stmts);
# line 720 "TempExp.puma"
   pre_stmts = CombineACF (yyV1, pre_stmts);
# line 721 "TempExp.puma"
   post_stmts = CombineACF (post_stmts, yyV2);
  }
   * yyP22 = tmp_var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }

  }
# line 724 "TempExp.puma"
  {
# line 726 "TempExp.puma"
   error_protocol ("MakeLocalVarAccess failed, could not localize computation");
# line 727 "TempExp.puma"
   tree_protocol ("illegal term  : ", var);
  }
   * yyP22 = var;
   * yyP21 = NoTree;
   * yyP20 = NoTree;
   return;

;
}

void MakeFullLocalIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register tTree * yyP24, register tTree * yyP23)
# else
(var, home_vard, yyP24, yyP23)
 register tTree var;
 pvar home_vard;
 register tTree * yyP24;
 register tTree * yyP23;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 738 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 740 "TempExp.puma"
   MakeFullLocalIndexes (var->INDEXED_VAR.IND_EXPS, home_vard, & yyV1, & yyV2);
  }
   * yyP24 = yyV1;
   * yyP23 = yyV2;
   return;
 }

  }
  if (var->Kind == kBTE_LIST) {
# line 743 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 746 "TempExp.puma"
   MakeLocalIndex (var->BTE_LIST.Elem, home_vard, & yyV1, & yyV2, & yyV3);
# line 747 "TempExp.puma"
 var->BTE_LIST.Elem = yyV1; 
# line 748 "TempExp.puma"
   MakeFullLocalIndexes (var->BTE_LIST.Next, home_vard, & yyV4, & yyV5);
  }
   * yyP24 = CombineACF (yyV2, yyV4);
   * yyP23 = CombineACF (yyV5, yyV3);
   return;
 }

  }
  if (var->Kind == kBTE_EMPTY) {
# line 751 "TempExp.puma"
   * yyP24 = NoTree;
   * yyP23 = NoTree;
   return;

  }
# line 754 "TempExp.puma"
  {
# line 756 "TempExp.puma"
   failure_protocol (MODULE, "MakeFullLocalIndexes", var);
  }
   * yyP24 = NoTree;
   * yyP23 = NoTree;
   return;

;
}

static bool IsSpreadAssign
# if defined __STDC__ | defined __cplusplus
(pvar home_vard, register tTree exp)
# else
(home_vard, exp)
 pvar home_vard;
 register tTree exp;
# endif
{
  if (exp->Kind == kVAR_EXP) {
# line 772 "TempExp.puma"
  {
# line 774 "TempExp.puma"
   if (! ((! IsFullParLoopVar (exp->VAR_EXP.V)))) goto yyL1;
  {
# line 775 "TempExp.puma"
   if (! ((! IsIndShadowVariable (exp->VAR_EXP.V, home_vard)))) goto yyL1;
  {
# line 776 "TempExp.puma"
   if (! ((HasOuterParallelLoop ()))) goto yyL1;
  }
  }
  }
   return true;
yyL1:;

  }
  return false;
}

static void MakeSpreadDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree exp, var_descriptor * yyP25)
# else
(home, exp, yyP25)
 pvar home;
 register tTree exp;
 var_descriptor * yyP25;
# endif
{
  if (exp->Kind == kVAR_EXP) {
# line 792 "TempExp.puma"
 {
  var_descriptor vard;
  {
# line 794 "TempExp.puma"

# line 796 "TempExp.puma"
 int k, rank, pos;

     vard = *home;

     pos = 1;
 
     while (pos != 0)
 
       { pos = 0;
 
         rank = vard.formal_rank;
 
         for (k=0; k < rank; k++)
            { if (FreeLoopIndex (vard.actual_shape[k][0], exp->VAR_EXP.V))
                 pos = k+1;
            }
 
        if (pos > 0) RemDimDescriptor (&vard, pos);
 
       } 

  
  }
   * yyP25 = vard;
   return;
 }

  }
# line 820 "TempExp.puma"
 {
  var_descriptor vard;
  {
# line 822 "TempExp.puma"

# line 824 "TempExp.puma"
   failure_protocol (MODULE, "MakeSpreadDescriptor", exp);
  }
   * yyP25 = vard;
   return;
 }

;
}

static void SetParamExp
# if defined __STDC__ | defined __cplusplus
(register tTree param, register tTree exp)
# else
(param, exp)
 register tTree param;
 register tTree exp;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (exp->Kind == kVAR_EXP) {
# line 835 "TempExp.puma"
  {
# line 836 "TempExp.puma"
 param->VAR_PARAM.V = exp->VAR_EXP.V; 
  }
   return;

  }
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 839 "TempExp.puma"
  {
# line 840 "TempExp.puma"
 param->VAR_PARAM.V->ADDR.E = exp; 
  }
   return;

  }
# line 843 "TempExp.puma"
  {
# line 844 "TempExp.puma"
 param->VAR_PARAM.V = mADDR (exp); 
  }
   return;

  }
# line 847 "TempExp.puma"
  {
# line 848 "TempExp.puma"
   failure_protocol (MODULE, "SetParamExp", param);
  }
   return;

;
}

static void MakeLocalIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, pvar home, register tTree * yyP28, register tTree * yyP27, register tTree * yyP26)
# else
(index, home, yyP28, yyP27, yyP26)
 register tTree index;
 pvar home;
 register tTree * yyP28;
 register tTree * yyP27;
 register tTree * yyP26;
# endif
{
  if (index->Kind == kVAR_EXP) {
# line 878 "TempExp.puma"
  {
# line 880 "TempExp.puma"
   if (! ((IsFullLoopVar (index->VAR_EXP.V)))) goto yyL1;
  {
# line 881 "TempExp.puma"
   if (! ((IsLocalVarWrite (index->VAR_EXP.V, home)))) goto yyL1;
  }
  }
   * yyP28 = index;
   * yyP27 = NoTree;
   * yyP26 = NoTree;
   return;
yyL1:;

  }
# line 887 "TempExp.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  var_descriptor vard;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  {
# line 891 "TempExp.puma"
   LocalizeExp (index, home, & yyV1, & yyV2, & yyV3);
# line 893 "TempExp.puma"

# line 895 "TempExp.puma"
   FullHomeTemp (index, home, & vard);
# line 897 "TempExp.puma"
   MyMakeTemporaryStmt (yyV1, & vard, & yyV4, & yyV5, & yyV6, & yyV7);
# line 899 "TempExp.puma"
   yyV2 = CombineACF (yyV2, CombineACF (yyV5, yyV6));
# line 900 "TempExp.puma"
   yyV3 = CombineACF (yyV7, yyV3);
  }
   * yyP28 = yyV4;
   * yyP27 = yyV2;
   * yyP26 = yyV3;
   return;
 }

;
}

static void MyMakeTemporaryStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP32, register tTree * yyP31, register tTree * yyP30, register tTree * yyP29)
# else
(exp, vard, yyP32, yyP31, yyP30, yyP29)
 register tTree exp;
 pvar vard;
 register tTree * yyP32;
 register tTree * yyP31;
 register tTree * yyP30;
 register tTree * yyP29;
# endif
{
# line 911 "TempExp.puma"
 {
  tTree post_stmt;
  tTree pre_stmt;
  tTree assign;
  tTree tmp_var;
  {
# line 913 "TempExp.puma"

# line 914 "TempExp.puma"

# line 915 "TempExp.puma"

# line 916 "TempExp.puma"

# line 918 "TempExp.puma"
   ParallelExpansion (vard);
# line 919 "TempExp.puma"
   MakeTemporaryStmt (exp, vard, & pre_stmt, & tmp_var, & assign, & post_stmt);
  }
   * yyP32 = mVAR_EXP (tmp_var);
   * yyP31 = pre_stmt;
   * yyP30 = assign;
   * yyP29 = post_stmt;
   return;
 }

;
}

static bool IsFullBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 935 "TempExp.puma"
  {
# line 937 "TempExp.puma"
   if (! ((ImpliedDos () == 0))) goto yyL1;
  }
   return true;
yyL1:;

  if (var->Kind == kUSED_VAR) {
# line 940 "TempExp.puma"
   return true;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 943 "TempExp.puma"
  {
# line 945 "TempExp.puma"
   if (! ((TreeListLength (var->INDEXED_VAR.IND_EXPS) <= ImpliedDos ()))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static int ImpliedDos
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 958 "TempExp.puma"
 {
  int n;
  {
# line 960 "TempExp.puma"

# line 962 "TempExp.puma"
 int loop;

     n = 0;

     for (loop=1; loop <= OuterLoops(); loop++)
       if (ImpliedDoLoop (GetOuterLoop(loop)))
          n++;

   
  }
  {
   return n;
  }
 }

}

static bool ImpliedDoLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kDO_EXP) {
# line 977 "TempExp.puma"
   return true;

  }
  if (loop->Kind == kDO_VAR) {
# line 980 "TempExp.puma"
   return true;

  }
  return false;
}

void BeginTempExp ()
{
}

void CloseTempExp ()
{
}
