# include "TempAssigns.h"
# include "yyTempAssigns.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 28 "TempAssigns.puma"


# include "protocol.h"

# include "Transform.h"       /* CombineACF                        */
# include "Temporary.h"
# include "ExpDescriptor.h"   /* GetVarDescriptor                  */

# define MODULE "TempAssigns"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* TempAssigns_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempAssigns, routine %s failed\n", yyFunction);
 TempAssigns_Exit ();
}

void MakeTemporaryStmt ARGS((tTree exp, pvar vard, tTree * alloc, tTree * new_var, tTree * assign, tTree * dealloc));
void MakeTempVarStmt ARGS((tTree var, int code, pvar vard, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void SwitchAssignment ARGS((tTree assign));
void MakeTempExpStmt ARGS((tTree exp, tTree * yyP6, tTree * yyP5, tTree * yyP4));
void MakeTempAssignment ARGS((tTree exp, pvar vard, tTree * yyP9, tTree * yyP8, tTree * yyP7));

void MakeTemporaryStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * alloc, register tTree * new_var, register tTree * assign, register tTree * dealloc)
# else
(exp, vard, alloc, new_var, assign, dealloc)
 register tTree exp;
 pvar vard;
 register tTree * alloc;
 register tTree * new_var;
 register tTree * assign;
 register tTree * dealloc;
# endif
{
# line 65 "TempAssigns.puma"
 {
  tTree tmp_var;
  tTree stmt;
  tTree allocate;
  tTree deallocate;
  {
# line 67 "TempAssigns.puma"

# line 68 "TempAssigns.puma"

# line 69 "TempAssigns.puma"

# line 70 "TempAssigns.puma"

# line 72 "TempAssigns.puma"
 tmp_var = GetVDTemporary (vard);
 
     if (tmp_var == NoTree)
 
        { error_protocol ("could not create temporary");
          allocate = NoTree;
          deallocate = NoTree;
          (* new_var)    = NoTree;
          stmt       = NoTree;
        }
 
      else
 
        { stmt = mASSIGN_STMT (CopyTree(tmp_var), exp);
          
          stmt = mACF_LIST (mACF_BASIC (stmt), NoTree);
 
          GetMemoryStmts (&allocate, &deallocate);
          allocate = CombineACF (allocate, NoTree);
          deallocate = CombineACF (deallocate, NoTree);
        }
   
  }
   * alloc = allocate;
   * new_var = tmp_var;
   * assign = stmt;
   * dealloc = deallocate;
   return;
 }

;
}

void MakeTempVarStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int code, pvar vard, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(var, code, vard, yyP3, yyP2, yyP1)
 register tTree var;
 register int code;
 pvar vard;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 119 "TempAssigns.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 121 "TempAssigns.puma"
   if (! ((code == IntentIn))) goto yyL1;
  {
# line 123 "TempAssigns.puma"
   MakeTemporaryStmt (mVAR_EXP (var), vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  }
   * yyP3 = yyV2;
   * yyP2 = CombineACF (yyV1, yyV3);
   * yyP1 = yyV4;
   return;
 }
yyL1:;

# line 127 "TempAssigns.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 129 "TempAssigns.puma"
   if (! ((code == IntentOut))) goto yyL2;
  {
# line 131 "TempAssigns.puma"
   MakeTemporaryStmt (mVAR_EXP (var), vard, & yyV1, & yyV2, & yyV3, & yyV4);
# line 134 "TempAssigns.puma"
   SwitchAssignment (yyV3);
  }
  }
   * yyP3 = yyV2;
   * yyP2 = yyV1;
   * yyP1 = CombineACF (yyV3, yyV4);
   return;
 }
yyL2:;

# line 138 "TempAssigns.puma"
 {
  tTree assign1;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 141 "TempAssigns.puma"

# line 143 "TempAssigns.puma"
   MakeTemporaryStmt (mVAR_EXP (var), vard, & yyV1, & yyV2, & yyV3, & yyV4);
# line 146 "TempAssigns.puma"
   assign1 = CopyTree (yyV3);
# line 147 "TempAssigns.puma"
   SwitchAssignment (yyV3);
  }
   * yyP3 = yyV2;
   * yyP2 = CombineACF (yyV1, assign1);
   * yyP1 = CombineACF (yyV3, yyV4);
   return;
 }

;
}

static void SwitchAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kACF_LIST) {
# line 160 "TempAssigns.puma"
  {
# line 161 "TempAssigns.puma"
   SwitchAssignment (assign->ACF_LIST.Elem);
  }
   return;

  }
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 164 "TempAssigns.puma"
 {
  tTree hvar;
  {
# line 166 "TempAssigns.puma"

# line 167 "TempAssigns.puma"
 hvar = assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR; assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V; assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V = hvar; 
  }
   return;
 }

  }
  }
  }
# line 170 "TempAssigns.puma"
  {
# line 171 "TempAssigns.puma"
   failure_protocol (MODULE, "SwitchAssignment", assign);
  }
   return;

;
}

void MakeTempExpStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(exp, yyP6, yyP5, yyP4)
 register tTree exp;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
# line 202 "TempAssigns.puma"
 {
  int found;
  bool found1;
  tTree maj_var;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 204 "TempAssigns.puma"

# line 205 "TempAssigns.puma"

# line 206 "TempAssigns.puma"

# line 207 "TempAssigns.puma"

# line 209 "TempAssigns.puma"
   GetMajorityVar (exp, & found, & maj_var);
# line 210 "TempAssigns.puma"
   if (! ((found == 1))) goto yyL1;
  {
# line 212 "TempAssigns.puma"
   GetVarDescriptor (maj_var, & found1, & vard);
# line 213 "TempAssigns.puma"
   if (! ((found1))) goto yyL1;
  {
# line 215 "TempAssigns.puma"
   SetExpType (exp, & vard);
# line 217 "TempAssigns.puma"
   MakeTemporaryStmt (exp, & vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  }
  }
   * yyP6 = mVAR_EXP (yyV2);
   * yyP5 = CombineACF (yyV1, yyV3);
   * yyP4 = yyV4;
   return;
 }
yyL1:;

# line 220 "TempAssigns.puma"
 {
  var_descriptor vard;
  bool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 222 "TempAssigns.puma"

# line 223 "TempAssigns.puma"

# line 225 "TempAssigns.puma"
   GetExpDescriptor (exp, & found, & vard);
# line 226 "TempAssigns.puma"
   if (! ((found))) goto yyL2;
  {
# line 228 "TempAssigns.puma"
   MakeTemporaryStmt (exp, & vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  }
   * yyP6 = mVAR_EXP (yyV2);
   * yyP5 = CombineACF (yyV1, yyV3);
   * yyP4 = yyV4;
   return;
 }
yyL2:;

# line 231 "TempAssigns.puma"
  {
# line 233 "TempAssigns.puma"
   error_protocol ("could not resolve for temporaries");
# line 234 "TempAssigns.puma"
   tree_protocol ("no descriptor for this expression : ", exp);
  }
   * yyP6 = exp;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

void MakeTempAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(exp, vard, yyP9, yyP8, yyP7)
 register tTree exp;
 pvar vard;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
# line 247 "TempAssigns.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 249 "TempAssigns.puma"
   MakeTemporaryStmt (exp, vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
   * yyP9 = mVAR_EXP (yyV2);
   * yyP8 = CombineACF (yyV1, yyV3);
   * yyP7 = yyV4;
   return;
 }

;
}

void BeginTempAssigns ()
{
}

void CloseTempAssigns ()
{
}
