# include "StrUnparse.h"
# include "yyStrUnparse.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 31 "StrUnparse.puma"


# define  STR_LENGTH 1024

# include <string.h>

# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"
# include "TreeOps.h"

typedef char fstring[STR_LENGTH];



static void yyExit () { Exit (1); }

void (* StrUnparse_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module StrUnparse, routine %s failed\n", yyFunction);
 StrUnparse_Exit ();
}

void StrUnparse ARGS((String str, int len, tTree t));

void StrUnparse
# if defined __STDC__ | defined __cplusplus
(String str, register int len, register tTree t)
# else
(str, len, t)
 String str;
 register int len;
 register tTree t;
# endif
{
# line 67 "StrUnparse.puma"
  {
# line 69 "StrUnparse.puma"
   if (! ((t == NoTree))) goto yyL1;
  {
# line 70 "StrUnparse.puma"
   if (! ((len >= 6))) goto yyL1;
  {
# line 71 "StrUnparse.puma"
   sprintf (str, "NoTree");
  }
  }
  }
   return;
yyL1:;

# line 74 "StrUnparse.puma"
  {
# line 76 "StrUnparse.puma"
   if (! ((t == NoTree))) goto yyL2;
  {
# line 77 "StrUnparse.puma"
   sprintf (str, "");
  }
  }
   return;
yyL2:;


  switch (t->Kind) {
  case kVAR_OBJ:
# line 80 "StrUnparse.puma"
 {
  fstring hstr;
  {
# line 82 "StrUnparse.puma"

# line 84 "StrUnparse.puma"
   GetString (t->VAR_OBJ.Ident, hstr);
# line 85 "StrUnparse.puma"
   if (! ((strlen (hstr) <= len))) goto yyL3;
  {
# line 86 "StrUnparse.puma"
   sprintf (str, "%s", hstr);
  }
  }
   return;
 }
yyL3:;

  break;
  case kUSED_VAR:
# line 89 "StrUnparse.puma"
  {
# line 91 "StrUnparse.puma"
   StrUnparse (str, len, t->USED_VAR.VARNAME);
  }
   return;

  case kLOOP_VAR:
# line 94 "StrUnparse.puma"
  {
# line 96 "StrUnparse.puma"
   StrUnparse (str, len, t->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kINDEXED_VAR:
# line 99 "StrUnparse.puma"
 {
  fstring hstr;
  {
# line 101 "StrUnparse.puma"

# line 103 "StrUnparse.puma"
   StrUnparse (str, len - 2, t->INDEXED_VAR.IND_VAR);
# line 104 "StrUnparse.puma"
   StrUnparse (hstr, len - strlen (str) - 2, t->INDEXED_VAR.IND_EXPS);
# line 106 "StrUnparse.puma"
   strcat (str, "(");
# line 107 "StrUnparse.puma"
   strcat (str, hstr);
# line 108 "StrUnparse.puma"
   strcat (str, ")");
  }
   return;
 }

  case kVAR_EXP:
# line 111 "StrUnparse.puma"
  {
# line 113 "StrUnparse.puma"
   StrUnparse (str, len, t->VAR_EXP.V);
  }
   return;

  case kBTE_EMPTY:
# line 116 "StrUnparse.puma"
  {
# line 118 "StrUnparse.puma"
   sprintf (str, "");
  }
   return;

  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 121 "StrUnparse.puma"
  {
# line 123 "StrUnparse.puma"
   StrUnparse (str, len, t->BTE_LIST.Elem);
  }
   return;

  }
# line 126 "StrUnparse.puma"
 {
  int minlen;
  fstring hstr;
  {
# line 128 "StrUnparse.puma"

# line 130 "StrUnparse.puma"
   minlen = 2 * TreeListLength (t) - 1;
# line 132 "StrUnparse.puma"
   if (! ((minlen <= len))) goto yyL10;
  {
# line 134 "StrUnparse.puma"

# line 136 "StrUnparse.puma"
   StrUnparse (str, len + 1 - minlen, t->BTE_LIST.Elem);
# line 137 "StrUnparse.puma"
   StrUnparse (hstr, len - strlen (str) - 1, t->BTE_LIST.Next);
# line 139 "StrUnparse.puma"
   strcat (str, ",");
# line 140 "StrUnparse.puma"
   strcat (str, hstr);
  }
  }
   return;
 }
yyL10:;

  break;
  case kCONST_EXP:
  if (t->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 143 "StrUnparse.puma"
  {
# line 145 "StrUnparse.puma"
   if (! ((len >= 5))) goto yyL11;
  {
# line 146 "StrUnparse.puma"
   sprintf (str, "%d", t->CONST_EXP.C->INT_CONSTANT.value);
  }
  }
   return;
yyL11:;

  }
  break;
  }

# line 149 "StrUnparse.puma"
  {
# line 151 "StrUnparse.puma"
   if (! ((len >= 1))) goto yyL12;
  {
# line 152 "StrUnparse.puma"
   sprintf (str, ".");
  }
  }
   return;
yyL12:;

# line 155 "StrUnparse.puma"
  {
# line 157 "StrUnparse.puma"
   sprintf (str, "");
  }
   return;

;
}

void BeginStrUnparse ()
{
}

void CloseStrUnparse ()
{
}
