# include "StmtDeps.h"
# include "yyStmtDeps.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 35 "StmtDeps.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "FArguments.h"       /* IsOnlyReadParam */

# include "protocol.h"

# define  MODULE "StmtDeps" 

# define  READ_ACCESS   1
# define  WRITE_ACCESS  2
# define  INOUT_ACCESS  3

# undef  DEBUG

       /*************************************************
       *                                                *
       *  Global Data for comparing two variables       *
       *                                                *
       *************************************************/
 
static Predicate  global_check_pred;
static Predicate  global_result_pred;

static int   Nesting1;            /* nesting depth for stmt1 */
static int   Nesting2;            /* nesting depth for stmt2 */

static int   CommonLoops;

static tTree Nest1[MAX_FORALL];   /* DOLOCAL loops for maximal nesting */
static tTree Nest2[MAX_FORALL];   /* DOLOCAL loops for maximal nesting */

static tTree global_stmt1, global_stmt2;

static tTree var1, var2;
static int   kind1, kind2;

static int   step;



static void yyExit () { Exit (1); }

void (* StmtDeps_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module StmtDeps, routine %s failed\n", yyFunction);
 StmtDeps_Exit ();
}

void FusionDependence ARGS((tTree stmt1, tTree stmt2, Predicate * yyP1));
static int CountOnLoops ARGS((tTree spec));
static void FusionTestPredicate ARGS((int n, Predicate * yyP2));
void StmtDependence ARGS((tTree stmt1, tTree stmt2, Predicate p, Predicate * yyP3));
static void TraverseVars ARGS((tTree t));
static void SpecsIncreaseNesting ARGS((tTree speclist));
static void SpecsDecreaseNesting ARGS((tTree speclist));
static void IncreaseNesting ARGS((tTree stmt));
static void DecreaseNesting ARGS(());
static void VisitVar ARGS((tTree var, int kind));
static void ProveDependences ARGS((tTree var1, int kind1, tTree var2, int kind2));
static void SetFullDependence ARGS(());

void FusionDependence
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2, Predicate * yyP1)
# else
(stmt1, stmt2, yyP1)
 register tTree stmt1;
 register tTree stmt2;
 Predicate * yyP1;
# endif
{
  if (stmt1->Kind == kACF_DO) {
  if (stmt2->Kind == kACF_DO) {
# line 86 "StmtDeps.puma"
 {
  Predicate yyV1;
  Predicate yyV2;
  {
# line 89 "StmtDeps.puma"
   FusionTestPredicate (1, & yyV1);
# line 91 "StmtDeps.puma"
   StmtDependence (stmt1, stmt2, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  }
  }
  if (stmt1->Kind == kACF_ON) {
  if (stmt2->Kind == kACF_ON) {
# line 94 "StmtDeps.puma"
 {
  Predicate yyV1;
  Predicate yyV2;
  {
# line 99 "StmtDeps.puma"
   FusionTestPredicate (CountOnLoops (stmt1->ACF_ON.ON_SPECS), & yyV1);
# line 101 "StmtDeps.puma"
   StmtDependence (stmt1, stmt2, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  }
  }
# line 104 "StmtDeps.puma"
 {
  Predicate P;
  {
# line 106 "StmtDeps.puma"

# line 107 "StmtDeps.puma"
   failure2_protocol (MODULE, "StmtDependence", stmt1, stmt2);
  }
   * yyP1 = P;
   return;
 }

;
}

static int CountOnLoops
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kON_EMPTY) {
# line 118 "StmtDeps.puma"
   return 0;

  }
  if (spec->Kind == kON_LIST) {
# line 122 "StmtDeps.puma"
   return CountOnLoops (spec->ON_LIST.Next);

  }
# line 132 "StmtDeps.puma"
  {
# line 133 "StmtDeps.puma"
   failure_protocol (MODULE, "CountOnLoops", spec);
  }
   return 0;

}

static void FusionTestPredicate
# if defined __STDC__ | defined __cplusplus
(register int n, Predicate * yyP2)
# else
(n, yyP2)
 register int n;
 Predicate * yyP2;
# endif
{
# line 151 "StmtDeps.puma"

PredVector PV;
int k;
char str[100];

# line 157 "StmtDeps.puma"
 {
  Predicate P;
  {
# line 159 "StmtDeps.puma"

# line 161 "StmtDeps.puma"
 PMakeFalse (&P);

      for (k=1; k<=n; k++)

       { 

         PVMakeForLoopNest (n, k-1, k-1, &PV);

         

         PVAndComponent    (&PV, k, -MaxInt, -1);

         POrVector (&P, &PV);

       }

      strcpy (str, "");
      POut (str, &P);

      

   
  }
   * yyP2 = P;
   return;
 }

;
}

void StmtDependence
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2, Predicate p, Predicate * yyP3)
# else
(stmt1, stmt2, p, yyP3)
 register tTree stmt1;
 register tTree stmt2;
 Predicate p;
 Predicate * yyP3;
# endif
{
# line 193 "StmtDeps.puma"

char str[100];

# line 197 "StmtDeps.puma"
  {
# line 199 "StmtDeps.puma"
 Nesting1 = 0;
     Nesting2 = 0;
     CommonLoops = 0;
     global_check_pred = p;          
#ifdef DEBUG
     strcpy (str, "");
     POut (str, &global_check_pred);
     printf ("Stmt Dependence : check for p = %s\n", str);
     printf ("stmt 1 : \n");
     FileUnparse (stdout, stmt1);
     printf ("stmt 2 : \n");
     FileUnparse (stdout, stmt2);
#endif
     PMakeFalse (&global_result_pred); 
     step = 1;                       
     global_stmt1 = stmt1;
     global_stmt2 = stmt2;
   
# line 218 "StmtDeps.puma"
   TraverseVars (global_stmt1);
# line 220 "StmtDeps.puma"

#ifdef DEBUG
     strcpy (str, "");
     POut (str, &global_result_pred);
     printf ("Stmt Dependence : result p = %s\n", str);
#endif
   
  }
   * yyP3 = global_result_pred;
   return;

;
}

static void TraverseVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 245 "StmtDeps.puma"
  {
# line 246 "StmtDeps.puma"
   TraverseVars (t->ACF_LIST.Elem);
# line 247 "StmtDeps.puma"
   TraverseVars (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 250 "StmtDeps.puma"
   return;

  case kACF_DUMMY:
# line 253 "StmtDeps.puma"
   return;

  case kACF_IF:
# line 256 "StmtDeps.puma"
  {
# line 258 "StmtDeps.puma"
   TraverseVars (t->ACF_IF.IF_EXP);
# line 259 "StmtDeps.puma"
   TraverseVars (t->ACF_IF.THEN_PART);
# line 260 "StmtDeps.puma"
   TraverseVars (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_BASIC:
# line 263 "StmtDeps.puma"
  {
# line 265 "StmtDeps.puma"
   TraverseVars (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_DO:
# line 268 "StmtDeps.puma"
  {
# line 270 "StmtDeps.puma"
   TraverseVars (t->ACF_DO.DO_RANGE);
# line 272 "StmtDeps.puma"
   IncreaseNesting (t);
# line 273 "StmtDeps.puma"
   TraverseVars (t->ACF_DO.DO_BODY);
# line 274 "StmtDeps.puma"
   DecreaseNesting ();
  }
   return;

  case kACF_ON:
# line 277 "StmtDeps.puma"
  {
# line 279 "StmtDeps.puma"
   TraverseVars (t->ACF_ON.ON_SPECS);
# line 281 "StmtDeps.puma"
   SpecsIncreaseNesting (t->ACF_ON.ON_SPECS);
# line 282 "StmtDeps.puma"
   TraverseVars (t->ACF_ON.ON_BODY);
# line 283 "StmtDeps.puma"
   SpecsDecreaseNesting (t->ACF_ON.ON_SPECS);
  }
   return;

  case kON_LIST:
# line 286 "StmtDeps.puma"
  {
# line 288 "StmtDeps.puma"
   TraverseVars (t->ON_LIST.Elem);
# line 289 "StmtDeps.puma"
   TraverseVars (t->ON_LIST.Next);
  }
   return;

  case kON_EMPTY:
# line 292 "StmtDeps.puma"
   return;

  case kON_SPEC:
# line 295 "StmtDeps.puma"
  {
# line 297 "StmtDeps.puma"
   TraverseVars (t->ON_SPEC.ON_VAL);
  }
   return;

  case kACF_NODE:
  case kACF_WHERE:
  case kACF_CASE:
  case kACF_WHILE:
  case kACF_REPEAT:
  case kACF_LOOP:
  case kACF_FORALL:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_HOME:
  case kACF_RESIDENT:
  case kACF_NEW:
  case kACF_REDUCTION:
  case kACF_TASK_REGION:
  case kACF_PARALLEL:
  case kACF_CRITICAL:
  case kACF_RM_READ:
  case kACF_RM_WRITE:
  case kACF_MOVE:
  case kACF_BARRIER:
  case kACF_UPDATE:
# line 300 "StmtDeps.puma"
  {
# line 302 "StmtDeps.puma"
   SetFullDependence ();
  }
   return;

  case kCALL_STMT:
# line 311 "StmtDeps.puma"
  {
# line 313 "StmtDeps.puma"
   if (! ((IsPureCall (t->CALL_STMT.CALL_ID)))) goto yyL12;
  {
# line 315 "StmtDeps.puma"
   TraverseVars (t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL12:;

# line 318 "StmtDeps.puma"
  {
# line 322 "StmtDeps.puma"
   SetFullDependence ();
  }
   return;

  case kIO_STMT:
# line 325 "StmtDeps.puma"
  {
# line 329 "StmtDeps.puma"
   SetFullDependence ();
  }
   return;

  case kASSIGN_STMT:
# line 332 "StmtDeps.puma"
  {
# line 334 "StmtDeps.puma"
   VisitVar (t->ASSIGN_STMT.ASSIGN_VAR, WRITE_ACCESS);
# line 335 "StmtDeps.puma"
   TraverseVars (t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  case kREDUCE_STMT:
  if (t->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 338 "StmtDeps.puma"
  {
# line 340 "StmtDeps.puma"
   TraverseVars (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
  }
   return;

  }
  }
  break;
  }


  switch (t->Kind) {
  case kBT_STMT:
  case kPTR_ASSIGN_STMT:
  case kLABEL_ASSIGN_STMT:
  case kGOTO_STMT:
  case kASS_GOTO_STMT:
  case kCOMP_GOTO_STMT:
  case kCOMP_IF_STMT:
  case kRETURN_STMT:
  case kPAUSE_STMT:
  case kEXIT_STMT:
  case kCYCLE_STMT:
  case kSTOP_STMT:
  case kFORMAT_STMT:
  case kINHERIT_DSP_STMT:
  case kCREATE_DSP_STMT:
  case kFREE_DSP_STMT:
  case kALLOCATE_STMT:
  case kDEALLOCATE_STMT:
  case kNULLIFY_STMT:
  case kREDUCE_STMT:
  case kMOVE_STMT:
  case kSCATTER_STMT:
  case kREALIGN_STMT:
  case kREDISTRIBUTE_STMT:
  case kREG_SHADOW_GET:
  case kREG_SHADOW_PUT:
  case kREG_SHADOW_SET:
  case kIND_SHADOW_CREATE:
  case kIND_SHADOW_FREE:
  case kIND_SHADOW_GET:
  case kIND_SHADOW_PUT:
  case kIND_SHADOW_SET:
  case kBROADCAST_STMT:
  case kREDUCTION_STMT:
  case kDIRTY_STMT:
# line 343 "StmtDeps.puma"
  {
# line 345 "StmtDeps.puma"
   SetFullDependence ();
  }
   return;

  case kSLICE_EXP:
# line 354 "StmtDeps.puma"
  {
# line 356 "StmtDeps.puma"
   TraverseVars (t->SLICE_EXP.START);
# line 357 "StmtDeps.puma"
   TraverseVars (t->SLICE_EXP.STOP);
# line 358 "StmtDeps.puma"
   TraverseVars (t->SLICE_EXP.INC);
  }
   return;

  case kDUMMY_EXP:
# line 361 "StmtDeps.puma"
   return;

  case kOP_EXP:
# line 364 "StmtDeps.puma"
  {
# line 366 "StmtDeps.puma"
   TraverseVars (t->OP_EXP.OPND1);
# line 367 "StmtDeps.puma"
   TraverseVars (t->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 370 "StmtDeps.puma"
  {
# line 372 "StmtDeps.puma"
   TraverseVars (t->OP1_EXP.OPND);
  }
   return;

  case kCONST_EXP:
# line 375 "StmtDeps.puma"
   return;

  case kBOUND_EXP:
# line 378 "StmtDeps.puma"
   return;

  case kRANK_EXP:
# line 381 "StmtDeps.puma"
   return;

  case kUSED_VAR:
# line 384 "StmtDeps.puma"
   return;

  case kLOOP_VAR:
# line 389 "StmtDeps.puma"
   return;

  case kVAR_EXP:
# line 394 "StmtDeps.puma"
  {
# line 396 "StmtDeps.puma"
   VisitVar (t->VAR_EXP.V, READ_ACCESS);
  }
   return;

  case kFUNC_CALL_EXP:
# line 399 "StmtDeps.puma"
  {
# line 401 "StmtDeps.puma"
   TraverseVars (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return;

  case kADDR:
# line 404 "StmtDeps.puma"
  {
# line 406 "StmtDeps.puma"
   TraverseVars (t->ADDR.E);
  }
   return;

  case kBTP_LIST:
# line 415 "StmtDeps.puma"
  {
# line 417 "StmtDeps.puma"
   TraverseVars (t->BTP_LIST.Elem);
# line 418 "StmtDeps.puma"
   TraverseVars (t->BTP_LIST.Next);
  }
   return;

  case kBTP_EMPTY:
# line 421 "StmtDeps.puma"
   return;

  case kVAR_PARAM:
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 424 "StmtDeps.puma"
  {
# line 426 "StmtDeps.puma"
   TraverseVars (t->VAR_PARAM.V->ADDR.E);
  }
   return;

  }
# line 429 "StmtDeps.puma"
  {
# line 431 "StmtDeps.puma"
   if (! ((IsOnlyReadParam (t)))) goto yyL33;
  {
# line 433 "StmtDeps.puma"
   VisitVar (t->VAR_PARAM.V, READ_ACCESS);
  }
  }
   return;
yyL33:;

# line 436 "StmtDeps.puma"
  {
# line 438 "StmtDeps.puma"
   if (! ((t->VAR_PARAM.intent == IntentOut))) goto yyL34;
  {
# line 440 "StmtDeps.puma"
   VisitVar (t->VAR_PARAM.V, WRITE_ACCESS);
  }
  }
   return;
yyL34:;

# line 443 "StmtDeps.puma"
  {
# line 447 "StmtDeps.puma"
   VisitVar (t->VAR_PARAM.V, INOUT_ACCESS);
  }
   return;

  case kNO_PARAM:
# line 450 "StmtDeps.puma"
   return;

  case kFUNC_PARAM:
# line 453 "StmtDeps.puma"
   return;

  case kPROC_PARAM:
# line 456 "StmtDeps.puma"
   return;

  }

# line 465 "StmtDeps.puma"
  {
# line 466 "StmtDeps.puma"
   failure_protocol (MODULE, "TraverseVars", t);
  }
   return;

;
}

static void SpecsIncreaseNesting
# if defined __STDC__ | defined __cplusplus
(register tTree speclist)
# else
(speclist)
 register tTree speclist;
# endif
{
  if (speclist->Kind == kON_LIST) {
# line 477 "StmtDeps.puma"
  {
# line 479 "StmtDeps.puma"
   SpecsIncreaseNesting (speclist->ON_LIST.Elem);
# line 480 "StmtDeps.puma"
   SpecsIncreaseNesting (speclist->ON_LIST.Next);
  }
   return;

  }
;
}

static void SpecsDecreaseNesting
# if defined __STDC__ | defined __cplusplus
(register tTree speclist)
# else
(speclist)
 register tTree speclist;
# endif
{
  if (speclist->Kind == kON_LIST) {
# line 492 "StmtDeps.puma"
  {
# line 494 "StmtDeps.puma"
   SpecsDecreaseNesting (speclist->ON_LIST.Elem);
# line 495 "StmtDeps.puma"
   SpecsDecreaseNesting (speclist->ON_LIST.Next);
  }
   return;

  }
;
}

static void IncreaseNesting
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 508 "StmtDeps.puma"
  {
# line 510 "StmtDeps.puma"
   if (! ((step == 1))) goto yyL1;
  {
# line 512 "StmtDeps.puma"
 Nest1[Nesting1] = stmt;
    Nesting1 ++;
  
  }
  }
   return;
yyL1:;

# line 517 "StmtDeps.puma"
  {
# line 518 "StmtDeps.puma"
   if (! ((step == 2))) goto yyL2;
  {
# line 520 "StmtDeps.puma"
 Nest2[Nesting2] = stmt;
    Nesting2 ++;
  
  }
  }
   return;
yyL2:;

# line 525 "StmtDeps.puma"
  {
# line 526 "StmtDeps.puma"
   failure_protocol (MODULE, "IncreaseNesting", stmt);
  }
   return;

;
}

static void DecreaseNesting
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 531 "StmtDeps.puma"
  {
# line 532 "StmtDeps.puma"
   if (! ((step == 1))) goto yyL1;
  {
# line 533 "StmtDeps.puma"
 Nesting1 --; 
  }
  }
   return;
yyL1:;

# line 536 "StmtDeps.puma"
  {
# line 537 "StmtDeps.puma"
   if (! ((step == 2))) goto yyL2;
  {
# line 538 "StmtDeps.puma"
 Nesting2 --; 
  }
  }
   return;
yyL2:;

;
}

static void VisitVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
# line 549 "StmtDeps.puma"
  {
# line 551 "StmtDeps.puma"
 if (step == 1)

        {  step++;
           kind1 = kind;
           var1  = var;
           TraverseVars (global_stmt2);
        }

      else if (step == 2)

        {  

           step++;
           kind2 = kind;
           var2  = var;
           ProveDependences (var1, kind1, var2, kind2);
        }

      step--;

    
  }
   return;

;
}

static void ProveDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register int kind1, register tTree var2, register int kind2)
# else
(var1, kind1, var2, kind2)
 register tTree var1;
 register int kind1;
 register tTree var2;
 register int kind2;
# endif
{
# line 582 "StmtDeps.puma"

char PString [100];

# line 586 "StmtDeps.puma"
  {
# line 588 "StmtDeps.puma"

#ifdef DEBUG
    printf ("Check dependences between ");
    FileUnparse (stdout, var1); printf (" (kind = %d) and ", kind1);
    FileUnparse (stdout, var2); printf (" (kind = %d)\n", kind2);
#endif
    
# line 595 "StmtDeps.puma"
   goto yyL1;
  }
yyL1:;

# line 598 "StmtDeps.puma"
  {
# line 600 "StmtDeps.puma"
   if (! ((kind1 == READ_ACCESS))) goto yyL2;
  {
# line 601 "StmtDeps.puma"
   if (! ((kind2 == READ_ACCESS))) goto yyL2;
  }
  }
   return;
yyL2:;

# line 604 "StmtDeps.puma"
  {
# line 608 "StmtDeps.puma"
   if (! ((TreeVarName (var1) != TreeVarName (var2)))) goto yyL3;
  }
   return;
yyL3:;

  if (var1->Kind == kINDEXED_VAR) {
  if (var1->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
  if (var2->Kind == kINDEXED_VAR) {
  if (var2->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 611 "StmtDeps.puma"
 {
  PredVector PV;
  int k;
  int dim;
  {
# line 614 "StmtDeps.puma"

# line 616 "StmtDeps.puma"

# line 617 "StmtDeps.puma"

# line 619 "StmtDeps.puma"
 dim = global_check_pred.p_dim;

      for (k=0; k<dim; k++)

        { 

          PV = global_check_pred.p_arr[k];

#ifdef DEBUG
          strcpy (PString, "check for : ");
          PVOut (PString, &PV);
          printf (PString);
          printf (" Nest1 = %d, Nest2 = %d, common = %d\n",
                    Nesting1, Nesting2, CommonLoops);
#endif

          Dependences (var1, Nest1, Nesting1, var2, Nest2, Nesting2,
                       CommonLoops, 0, &PV);
 
#ifdef DEBUG
          strcpy (PString, "result is : ");
          PVOut (PString, &PV);
          printf (PString);
          printf (" for %d common loops\n", CommonLoops);
#endif 

          POrVector (&global_result_pred, &PV);

        }
 
      if (!PIsFalse (&global_result_pred))
 
        {
          stmt_protocol ("dependences");
          tree_protocol ("Variable1 = ", var1);
          tree_protocol ("Variable2 = ", var2);
          strcpy (PString, "Dependences : ");
          POut (PString, &global_result_pred);
          print_protocol (PString);
#ifdef DEBUG
          printf ("%s\n", PString);
#endif
        }
 
    
  }
   return;
 }

  }
  }
  }
  }
# line 666 "StmtDeps.puma"
  {
# line 670 "StmtDeps.puma"
   SetFullDependence ();
  }
   return;

;
}

static void SetFullDependence
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 681 "StmtDeps.puma"
  {
# line 683 "StmtDeps.puma"
   global_result_pred = global_check_pred;
  }
   return;

;
}

void BeginStmtDeps ()
{
}

void CloseStmtDeps ()
{
}
