# include "SpecialMap.h"
# include "yySpecialMap.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 27 "SpecialMap.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
 
# include "protocol.h"

# define MODULE "SpecialMap"
 
# undef DEBUG



static void yyExit () { Exit (1); }

void (* SpecialMap_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SpecialMap, routine %s failed\n", yyFunction);
 SpecialMap_Exit ();
}

bool IsSpecialisation ARGS((pvar actual_vard, pvar dummy_vard));
static bool IsTopSpecialisation ARGS((tDefinitions actual_topology, tDefinitions dummy_topology));
static bool IsDistFormatSpecialisation ARGS((int actual_dist_kind, tTree actual_dist_size, int dummy_dist_kind, tTree dummy_dist_size));
static bool IsRangeFormatSpecialisation ARGS((int actual_dist_kind, tTree actual_dist_size, int dummy_range_kind, tTree dummy_range_size));
static bool IsSameSize ARGS((tTree size1, tTree size2));
static bool IsDistSpecialisation ARGS((pvar actual_vard, pvar dummy_vard));
static bool IsRangeSpecialisation ARGS((pvar actual_vard, pvar dummy_vard));
static bool IsMapSpecialisation ARGS((pvar actual_vard, pvar dummy_vard));
static bool IsRegularAlignment ARGS((pvar vard));
static bool IsNormalAlignment ARGS((pvar vard));
static bool HasNoPermutation ARGS((pvar vard));
static bool IsNoStrideAlignment ARGS((pvar vard));
static bool IsFullFormalShape ARGS((pvar vard));
static bool IsFullFormalDimShape ARGS((tTree lb, tTree ub, tTree str, tTree formal_lb, tTree formal_ub));
static bool MyEqualExpression ARGS((tTree actual, tTree formal));
static bool IsDistFormatUnderspecified ARGS((int dist_kind));
static bool IsDistUnderspecified ARGS((pvar vard));
static bool IsMapUnderspecified ARGS((pvar vard));

bool IsSpecialisation
# if defined __STDC__ | defined __cplusplus
(pvar actual_vard, pvar dummy_vard)
# else
(actual_vard, dummy_vard)
 pvar actual_vard;
 pvar dummy_vard;
# endif
{
# line 49 "SpecialMap.puma"
  {
# line 51 "SpecialMap.puma"
   if (! ((IsTopSpecialisation (actual_vard -> topology_obj, dummy_vard -> topology_obj)))) goto yyL1;
  {
# line 52 "SpecialMap.puma"
   if (! ((IsMapSpecialisation (actual_vard, dummy_vard)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  return false;
}

static bool IsTopSpecialisation
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_topology, register tDefinitions dummy_topology)
# else
(actual_topology, dummy_topology)
 register tDefinitions actual_topology;
 register tDefinitions dummy_topology;
# endif
{
# line 64 "SpecialMap.puma"
  {
# line 66 "SpecialMap.puma"
   if (! ((dummy_topology == NoObject))) goto yyL1;
  }
   return true;
yyL1:;

# line 69 "SpecialMap.puma"
  {
# line 71 "SpecialMap.puma"
   if (! ((actual_topology != NoObject))) goto yyL2;
  {
# line 72 "SpecialMap.puma"
   if (! ((SameTopologyObject (actual_topology, dummy_topology)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  return false;
}

static bool IsDistFormatSpecialisation
# if defined __STDC__ | defined __cplusplus
(register int actual_dist_kind, register tTree actual_dist_size, register int dummy_dist_kind, register tTree dummy_dist_size)
# else
(actual_dist_kind, actual_dist_size, dummy_dist_kind, dummy_dist_size)
 register int actual_dist_kind;
 register tTree actual_dist_size;
 register int dummy_dist_kind;
 register tTree dummy_dist_size;
# endif
{
# line 97 "SpecialMap.puma"
  {
# line 99 "SpecialMap.puma"

#ifdef DEBUG
    printf ("IsDistFormatSpecialisation, act_kind = %d, act_size =", 
            actual_dist_kind);
    FileUnparse (stdout, actual_dist_size);
    printf (", formal_kind = %d, formal_size =", dummy_dist_kind);
    FileUnparse (stdout, dummy_dist_size);
    printf ("\n");
#endif
   
# line 110 "SpecialMap.puma"
   goto yyL1;
  }
yyL1:;

# line 113 "SpecialMap.puma"
  {
# line 115 "SpecialMap.puma"
   if (! ((actual_dist_kind == kBLOCK_DIM))) goto yyL2;
  {
# line 116 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kBLOCK_DIM))) goto yyL2;
  {
# line 117 "SpecialMap.puma"
   if (! ((IsSameSize (actual_dist_size, dummy_dist_size)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

# line 122 "SpecialMap.puma"
  {
# line 124 "SpecialMap.puma"
   if (! (((actual_dist_kind == kBLOCK_DIM) || (actual_dist_kind == kANY_BLOCK_DIM)))) goto yyL3;
  {
# line 125 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kANY_BLOCK_DIM))) goto yyL3;
  }
  }
   return true;
yyL3:;

# line 130 "SpecialMap.puma"
  {
# line 132 "SpecialMap.puma"
   if (! ((actual_dist_kind == kCYCLIC_DIM))) goto yyL4;
  {
# line 133 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kCYCLIC_DIM))) goto yyL4;
  {
# line 134 "SpecialMap.puma"
   if (! ((IsSameSize (actual_dist_size, dummy_dist_size)))) goto yyL4;
  }
  }
  }
   return true;
yyL4:;

# line 139 "SpecialMap.puma"
  {
# line 141 "SpecialMap.puma"
   if (! (((actual_dist_kind == kCYCLIC_DIM) || (actual_dist_kind == kANY_CYCLIC_DIM)))) goto yyL5;
  {
# line 143 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kANY_CYCLIC_DIM))) goto yyL5;
  }
  }
   return true;
yyL5:;

# line 148 "SpecialMap.puma"
  {
# line 150 "SpecialMap.puma"
   if (! ((actual_dist_kind == kGEN_BLOCK_DIM))) goto yyL6;
  {
# line 151 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kGEN_BLOCK_DIM))) goto yyL6;
  {
# line 152 "SpecialMap.puma"
   if (! ((IsSameSize (actual_dist_size, dummy_dist_size)))) goto yyL6;
  }
  }
  }
   return true;
yyL6:;

# line 157 "SpecialMap.puma"
  {
# line 159 "SpecialMap.puma"
   if (! (((actual_dist_kind == kGEN_BLOCK_DIM) || (actual_dist_kind == kANY_GEN_BLOCK_DIM)))) goto yyL7;
  {
# line 161 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kANY_GEN_BLOCK_DIM))) goto yyL7;
  }
  }
   return true;
yyL7:;

# line 166 "SpecialMap.puma"
  {
# line 168 "SpecialMap.puma"
   if (! ((actual_dist_kind == kINDIRECT_DIM))) goto yyL8;
  {
# line 169 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kINDIRECT_DIM))) goto yyL8;
  {
# line 170 "SpecialMap.puma"
   if (! ((IsSameSize (actual_dist_size, dummy_dist_size)))) goto yyL8;
  }
  }
  }
   return true;
yyL8:;

# line 175 "SpecialMap.puma"
  {
# line 177 "SpecialMap.puma"
   if (! (((actual_dist_kind == kINDIRECT_DIM) || (actual_dist_kind == kANY_INDIRECT_DIM)))) goto yyL9;
  {
# line 179 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kANY_INDIRECT_DIM))) goto yyL9;
  }
  }
   return true;
yyL9:;

# line 184 "SpecialMap.puma"
  {
# line 186 "SpecialMap.puma"
   if (! ((actual_dist_kind == kSERIAL_DIM))) goto yyL10;
  {
# line 187 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kSERIAL_DIM))) goto yyL10;
  }
  }
   return true;
yyL10:;

# line 192 "SpecialMap.puma"
  {
# line 194 "SpecialMap.puma"
   if (! ((dummy_dist_kind == kANY_DISTRIBUTED_DIM))) goto yyL11;
  }
   return true;
yyL11:;

  return false;
}

static bool IsRangeFormatSpecialisation
# if defined __STDC__ | defined __cplusplus
(register int actual_dist_kind, register tTree actual_dist_size, register int dummy_range_kind, register tTree dummy_range_size)
# else
(actual_dist_kind, actual_dist_size, dummy_range_kind, dummy_range_size)
 register int actual_dist_kind;
 register tTree actual_dist_size;
 register int dummy_range_kind;
 register tTree dummy_range_size;
# endif
{
# line 208 "SpecialMap.puma"
  {
# line 210 "SpecialMap.puma"
   if (! ((IsDistFormatSpecialisation (actual_dist_kind, actual_dist_size, dummy_range_kind, dummy_range_size)))) goto yyL1;
  }
   return true;
yyL1:;

# line 216 "SpecialMap.puma"
  {
# line 218 "SpecialMap.puma"
   if (! ((actual_dist_kind == kSERIAL_DIM))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

static bool IsSameSize
# if defined __STDC__ | defined __cplusplus
(register tTree size1, register tTree size2)
# else
(size1, size2)
 register tTree size1;
 register tTree size2;
# endif
{
# line 228 "SpecialMap.puma"
  {
# line 230 "SpecialMap.puma"
   if (! ((size1 == NoTree))) goto yyL1;
  {
# line 231 "SpecialMap.puma"
   if (! ((size2 == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 234 "SpecialMap.puma"
  {
# line 236 "SpecialMap.puma"
   if (! ((size1 != NoTree))) goto yyL2;
  {
# line 237 "SpecialMap.puma"
   if (! ((size2 != NoTree))) goto yyL2;
  {
# line 238 "SpecialMap.puma"
   if (! ((EqualExpression (size1, size2)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  return false;
}

static bool IsDistSpecialisation
# if defined __STDC__ | defined __cplusplus
(pvar actual_vard, pvar dummy_vard)
# else
(actual_vard, dummy_vard)
 pvar actual_vard;
 pvar dummy_vard;
# endif
{
# line 249 "SpecialMap.puma"
 {
  bool okay;
  {
# line 251 "SpecialMap.puma"

# line 253 "SpecialMap.puma"
 int i, rank;

     okay = true; rank = actual_vard->formal_rank;

     for (i=0; i<rank; i++)

        if (!IsDistFormatSpecialisation (

          actual_vard->distribution_kind[i], actual_vard->distribution_size[i],
          dummy_vard->distribution_kind[i], dummy_vard->distribution_size[i]) )

             okay = false;
   
# line 267 "SpecialMap.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsRangeSpecialisation
# if defined __STDC__ | defined __cplusplus
(pvar actual_vard, pvar dummy_vard)
# else
(actual_vard, dummy_vard)
 pvar actual_vard;
 pvar dummy_vard;
# endif
{
# line 278 "SpecialMap.puma"
 {
  bool okay;
  {
# line 280 "SpecialMap.puma"

# line 282 "SpecialMap.puma"
 int i, rank;

     okay = true; rank = actual_vard->formal_rank;

     for (i=0; i<rank; i++)

        if (!IsRangeFormatSpecialisation (

          actual_vard->distribution_kind[i], actual_vard->distribution_size[i],
          dummy_vard->distribution_kind[i], dummy_vard->distribution_size[i]) )

            okay = false;
   
# line 296 "SpecialMap.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsMapSpecialisation
# if defined __STDC__ | defined __cplusplus
(pvar actual_vard, pvar dummy_vard)
# else
(actual_vard, dummy_vard)
 pvar actual_vard;
 pvar dummy_vard;
# endif
{
# line 307 "SpecialMap.puma"
  {
# line 317 "SpecialMap.puma"
   if (! ((actual_vard -> formal_rank != dummy_vard -> formal_rank))) goto yyL1;
  {
# line 319 "SpecialMap.puma"
   warning_protocol ("rank mismatch between actual and dummy");
# line 321 "SpecialMap.puma"
   return false;
  }
  }
yyL1:;

# line 332 "SpecialMap.puma"
  {
# line 334 "SpecialMap.puma"
   if (! ((dummy_vard -> var_obj == dummy_vard -> template_obj))) goto yyL2;
  {
# line 335 "SpecialMap.puma"
   if (! ((dummy_vard -> topology_obj != NoObject))) goto yyL2;
  {
# line 337 "SpecialMap.puma"
   if (! ((IsRegularAlignment (actual_vard)))) goto yyL2;
  {
# line 338 "SpecialMap.puma"
   if (! ((IsDistSpecialisation (actual_vard, dummy_vard)))) goto yyL2;
  }
  }
  }
  }
   return true;
yyL2:;

# line 349 "SpecialMap.puma"
  {
# line 351 "SpecialMap.puma"
   if (! ((dummy_vard -> var_obj == dummy_vard -> template_obj))) goto yyL3;
  {
# line 352 "SpecialMap.puma"
   if (! ((dummy_vard -> topology_obj == NoObject))) goto yyL3;
  {
# line 353 "SpecialMap.puma"
   if (! ((! dummy_vard -> template_inherited))) goto yyL3;
  {
# line 355 "SpecialMap.puma"
   if (! ((IsNoStrideAlignment (actual_vard)))) goto yyL3;
  {
# line 356 "SpecialMap.puma"
   if (! ((IsRangeSpecialisation (actual_vard, dummy_vard)))) goto yyL3;
  }
  }
  }
  }
  }
   return true;
yyL3:;

# line 367 "SpecialMap.puma"
  {
# line 369 "SpecialMap.puma"
   if (! ((dummy_vard -> var_obj == dummy_vard -> template_obj))) goto yyL4;
  {
# line 370 "SpecialMap.puma"
   if (! ((dummy_vard -> topology_obj == NoObject))) goto yyL4;
  {
# line 371 "SpecialMap.puma"
   if (! ((dummy_vard -> template_inherited))) goto yyL4;
  {
# line 373 "SpecialMap.puma"
   if (! ((IsRangeSpecialisation (actual_vard, dummy_vard)))) goto yyL4;
  }
  }
  }
  }
   return true;
yyL4:;

# line 387 "SpecialMap.puma"
  {
# line 389 "SpecialMap.puma"
   if (! ((dummy_vard -> var_obj != dummy_vard -> template_obj))) goto yyL5;
  {
# line 391 "SpecialMap.puma"
   if (! ((IsRegularAlignment (dummy_vard)))) goto yyL5;
  {
# line 392 "SpecialMap.puma"
   if (! ((! IsMapUnderspecified (dummy_vard)))) goto yyL5;
  {
# line 393 "SpecialMap.puma"
   if (! ((IsRegularAlignment (actual_vard)))) goto yyL5;
  {
# line 394 "SpecialMap.puma"
   if (! ((IsDistSpecialisation (actual_vard, dummy_vard)))) goto yyL5;
  }
  }
  }
  }
  }
   return true;
yyL5:;

# line 405 "SpecialMap.puma"
  {
# line 407 "SpecialMap.puma"
   if (! ((dummy_vard -> var_obj != dummy_vard -> template_obj))) goto yyL6;
  {
# line 411 "SpecialMap.puma"
   return false;
  }
  }
yyL6:;

  return false;
}

static bool IsRegularAlignment
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 426 "SpecialMap.puma"
  {
# line 428 "SpecialMap.puma"
   if (! ((IsNormalAlignment (vard)))) goto yyL1;
  {
# line 429 "SpecialMap.puma"
   if (! ((HasNoPermutation (vard)))) goto yyL1;
  {
# line 430 "SpecialMap.puma"
   if (! ((IsNoStrideAlignment (vard)))) goto yyL1;
  {
# line 431 "SpecialMap.puma"
   if (! ((IsFullFormalShape (vard)))) goto yyL1;
  }
  }
  }
  }
   return true;
yyL1:;

  return false;
}

static bool IsNormalAlignment
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 446 "SpecialMap.puma"
 {
  bool okay;
  {
# line 448 "SpecialMap.puma"

# line 450 "SpecialMap.puma"
 int i, rank;

     okay = true; rank = vard->topology_rank;

     for (i=0; i<rank; i++)

        if (vard->on_index_dim[i] == 0)

           okay = false;

   
# line 462 "SpecialMap.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool HasNoPermutation
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 475 "SpecialMap.puma"
 {
  bool okay;
  {
# line 477 "SpecialMap.puma"

# line 479 "SpecialMap.puma"
 int i, rank, last_dim;

     okay = true; last_dim = 0;

     rank = vard->topology_rank;

     for (i=0; i<rank; i++)

        { int index_dim;

          index_dim = vard->on_index_dim[i];

          if (index_dim > 0)

             { if (index_dim < last_dim)

                  okay = false;

                 else

                   last_dim = index_dim;

             } 

        } 

   
# line 507 "SpecialMap.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsNoStrideAlignment
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 522 "SpecialMap.puma"
 {
  bool okay;
  {
# line 524 "SpecialMap.puma"

# line 526 "SpecialMap.puma"
 int i, rank;

     okay = true; rank = vard->formal_rank;

     for (i=0; i<rank; i++)

       {  if (vard->align_mult[i] != 1) okay = false;

          if (vard->topology_dim[i] > 0)  

            if (!IsStride1 (vard->actual_shape[i][2])) okay = false;
       }

   
# line 541 "SpecialMap.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsFullFormalShape
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 554 "SpecialMap.puma"
 {
  bool okay;
  {
# line 556 "SpecialMap.puma"

# line 558 "SpecialMap.puma"
 int i, rank;

     okay = true; rank = vard->formal_rank;

     for (i=0; i<rank; i++)

      if (vard->topology_dim[i] > 0)

       { 

         if (!IsFullFormalDimShape 
               (vard->actual_shape[i][0], vard->actual_shape[i][1],
                vard->actual_shape[i][2],
                vard->formal_shape[i][0], vard->formal_shape[i][1]))
     
            okay = false;
       }
   
# line 577 "SpecialMap.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsFullFormalDimShape
# if defined __STDC__ | defined __cplusplus
(register tTree lb, register tTree ub, register tTree str, register tTree formal_lb, register tTree formal_ub)
# else
(lb, ub, str, formal_lb, formal_ub)
 register tTree lb;
 register tTree ub;
 register tTree str;
 register tTree formal_lb;
 register tTree formal_ub;
# endif
{
# line 583 "SpecialMap.puma"
  {
# line 585 "SpecialMap.puma"
   if (! ((lb == ub))) goto yyL1;
  {
# line 586 "SpecialMap.puma"
   return false;
  }
  }
yyL1:;

# line 589 "SpecialMap.puma"
  {
# line 591 "SpecialMap.puma"
   if (! ((! IsStride1 (str)))) goto yyL2;
  {
# line 592 "SpecialMap.puma"
   return false;
  }
  }
yyL2:;

# line 595 "SpecialMap.puma"
  {
# line 597 "SpecialMap.puma"
   if (! ((MyEqualExpression (lb, formal_lb)))) goto yyL3;
  {
# line 598 "SpecialMap.puma"
   if (! ((MyEqualExpression (ub, formal_ub)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  return false;
}

static bool MyEqualExpression
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree formal)
# else
(actual, formal)
 register tTree actual;
 register tTree formal;
# endif
{
# line 603 "SpecialMap.puma"
  {
# line 605 "SpecialMap.puma"
   if (! ((actual == NoTree))) goto yyL1;
  {
# line 606 "SpecialMap.puma"
   if (! ((formal == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 609 "SpecialMap.puma"
  {
# line 611 "SpecialMap.puma"
   if (! ((actual == NoTree))) goto yyL2;
  {
# line 612 "SpecialMap.puma"
   return false;
  }
  }
yyL2:;

# line 614 "SpecialMap.puma"
  {
# line 616 "SpecialMap.puma"
   if (! ((formal == NoTree))) goto yyL3;
  {
# line 617 "SpecialMap.puma"
   return false;
  }
  }
yyL3:;

# line 620 "SpecialMap.puma"
  {
# line 622 "SpecialMap.puma"
   if (! ((EqualExpression (actual, formal)))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

static bool IsDistFormatUnderspecified
# if defined __STDC__ | defined __cplusplus
(register int dist_kind)
# else
(dist_kind)
 register int dist_kind;
# endif
{
# line 636 "SpecialMap.puma"
  {
# line 637 "SpecialMap.puma"
   if (! ((dist_kind == kANY_BLOCK_DIM))) goto yyL1;
  }
   return true;
yyL1:;

# line 640 "SpecialMap.puma"
  {
# line 641 "SpecialMap.puma"
   if (! ((dist_kind == kANY_CYCLIC_DIM))) goto yyL2;
  }
   return true;
yyL2:;

# line 644 "SpecialMap.puma"
  {
# line 645 "SpecialMap.puma"
   if (! ((dist_kind == kANY_GEN_BLOCK_DIM))) goto yyL3;
  }
   return true;
yyL3:;

# line 648 "SpecialMap.puma"
  {
# line 649 "SpecialMap.puma"
   if (! ((dist_kind == kANY_INDIRECT_DIM))) goto yyL4;
  }
   return true;
yyL4:;

# line 652 "SpecialMap.puma"
  {
# line 653 "SpecialMap.puma"
   if (! ((dist_kind == kANY_DISTRIBUTED_DIM))) goto yyL5;
  }
   return true;
yyL5:;

  return false;
}

static bool IsDistUnderspecified
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 664 "SpecialMap.puma"
 {
  bool under_spec;
  {
# line 666 "SpecialMap.puma"

# line 668 "SpecialMap.puma"
 int i, rank;

     under_spec = false;

     rank = vard->formal_rank;

     for (i=0; i<rank; i++)

        if (IsDistFormatUnderspecified (vard->distribution_kind[i]))

           under_spec = true;
   
# line 681 "SpecialMap.puma"
   if (! ((under_spec))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsMapUnderspecified
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 692 "SpecialMap.puma"
  {
# line 694 "SpecialMap.puma"
   if (! ((vard -> topology_obj == NoObject))) goto yyL1;
  }
   return true;
yyL1:;

# line 697 "SpecialMap.puma"
  {
# line 698 "SpecialMap.puma"
   if (! ((IsDistUnderspecified (vard)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

void BeginSpecialMap ()
{
}

void CloseSpecialMap ()
{
}
